/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class DutyTransferOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("transferdate");
        e.getFieldKeys().add("presponsibleperson");
        e.getFieldKeys().add("aresponsibleperson");
        e.getFieldKeys().add("aresponsibledept");
        e.getFieldKeys().add("transferperson");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("transfertime");
        e.getFieldKeys().add("dstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "save": {
                DynamicObject[] transfers;
                ArrayList<Long> taskIds = new ArrayList<Long>();
                DynamicObjectCollection dutyentityList = dataEntities[0].getDynamicObjectCollection("dutyentity");
                for (DynamicObject dutyentity : dutyentityList) {
                    taskIds.add(dutyentity.getLong("task_id"));
                }
                QFilter taskidFilter = new QFilter("dutyentity.task", "in", taskIds);
                QFilter islatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
                QFilter[] ofilters = new QFilter[]{taskidFilter, islatestFilter};
                for (DynamicObject transfer : transfers = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"dutytasktransfer"), (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, aperson, person, remark1, dept, date, islatestbillno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, transferdate, presponsibleperson, aresponsibleperson, aresponsibledept, transferperson, remark, task, transfertime, dstatus, islatestd", (QFilter[])ofilters)) {
                    if (transfer.getPkValue().equals(dataEntities[0].getPkValue())) continue;
                    transfer.set("islatest", (Object)DefaultEnum.NO.getValue());
                    for (DynamicObject entity : transfer.getDynamicObjectCollection("dutyentity")) {
                        entity.set("islatestd", (Object)DefaultEnum.NO.getValue());
                        entity.set("remark", transfer.get("remark1"));
                    }
                }
                SaveServiceHelper.update((DynamicObject[])transfers);
                break;
            }
            case "submit": {
                this.updateDutyEntityData(dataEntities[0], StatusEnum.UNCHECKED.getValue());
                break;
            }
            case "unsubmit": {
                this.updateDutyEntityData(dataEntities[0], StatusEnum.TEMPSAVE.getValue());
                break;
            }
            case "audit": {
                this.updateDutyEntityData(dataEntities[0], StatusEnum.CHECKED.getValue());
                this.TransferDuty(dataEntities[0]);
                break;
            }
        }
    }

    public void TransferDuty(DynamicObject dataEntity) {
        DynamicObject[] tasks;
        DynamicObjectCollection dutyentityList = dataEntity.getDynamicObjectCollection("dutyentity");
        ArrayList<Object> taskIds = new ArrayList<Object>();
        HashMap<Object, DynamicObject> taskToDuty = new HashMap<Object, DynamicObject>();
        for (DynamicObject dt : dutyentityList) {
            taskIds.add(dt.getDynamicObject("task").getPkValue());
            taskToDuty.put(dt.getDynamicObject("task").getPkValue(), dt);
        }
        QFilter taskid = new QFilter("id", "in", taskIds);
        QFilter[] filters = new QFilter[]{taskid};
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sharer,responsibleperson,multicooperationperson,responsibledept,multicooperationdept,relationtask", (QFilter[])filters)) {
            task.set("responsibleperson", ((DynamicObject)taskToDuty.get(task.getPkValue())).get("aresponsibleperson"));
            task.set("responsibledept", ((DynamicObject)taskToDuty.get(task.getPkValue())).get("aresponsibledept"));
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    public void updateDutyEntityData(DynamicObject dataEntity, String billstatus) {
        DynamicObject[] dutys;
        DynamicObjectCollection dutyentityList = dataEntity.getDynamicObjectCollection("dutyentity");
        ArrayList<Object> dutyIds = new ArrayList<Object>();
        for (DynamicObject duty : dutyentityList) {
            dutyIds.add(duty.getPkValue());
        }
        QFilter dutyId = new QFilter("id", "in", dutyIds);
        QFilter[] filters = new QFilter[]{dutyId};
        for (DynamicObject dt : dutys = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"dutytransfer"), (String)"id, transferdate, presponsibleperson, aresponsibleperson, aresponsibledept, transferperson, remark, dstatus, islatestd", (QFilter[])filters)) {
            dt.set("dstatus", (Object)billstatus);
        }
        SaveServiceHelper.update((DynamicObject[])dutys);
    }
}

