/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class MajorTypeOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("plantype");
        e.getFieldKeys().add("plantypename");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("status");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObjectType taskSourceDt = MetaDataUtil.getDT((String)this.getAppId(), (String)"tasksource");
        String taskSourceEntityId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource");
        DynamicObjectType planTypeDt = MetaDataUtil.getDT((String)this.getAppId(), (String)"plantype");
        String planTypeEntityId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype");
        switch (operationKey = e.getOperationKey()) {
            case "save": {
                for (DynamicObject entity : dataEntities) {
                    DynamicObject planType;
                    DynamicObject taskSource;
                    LocaleString planName_s;
                    String name_cn = entity.getLocaleString("name").getLocaleValue_zh_CN();
                    String name_tw = entity.getLocaleString("name").getLocaleValue_zh_TW();
                    EnabledLang lang = InteServiceHelper.getUserLang((Long)Long.valueOf(RequestContext.get().getUserId()));
                    if (lang.getNumber().equals("zh_CN")) {
                        planName_s = new LocaleString();
                        String planName_cn = String.format(ResManager.loadKDString((String)"%s\u4e13\u9879\u8ba1\u5212", (String)"MajorTypeOp_0", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name_cn);
                        planName_s.setLocaleValue_zh_CN(planName_cn);
                        String planName_tw = String.format(ResManager.loadKDString((String)"%s\u5c08\u9805\u8a08\u5283", (String)"MajorTypeOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name_tw);
                        planName_s.setLocaleValue_zh_TW(planName_tw);
                    } else {
                        planName_s = entity.getLocaleString("name");
                    }
                    entity.set("plantypename", (Object)planName_s);
                    boolean taskSourceExist = QueryServiceHelper.exists((String)taskSourceEntityId, (Object)entity.getPkValue());
                    if (taskSourceExist) {
                        taskSource = BusinessDataServiceHelper.loadSingle((Object)entity.getPkValue(), (DynamicObjectType)taskSourceDt);
                    } else {
                        taskSource = new DynamicObject(taskSourceDt);
                        taskSource.set("id", entity.getPkValue());
                        taskSource.set("masterid", entity.getPkValue());
                    }
                    taskSource.set("name", (Object)planName_s);
                    taskSource.set("number", (Object)entity.getString("number"));
                    taskSource.set("enable", entity.get("enable"));
                    taskSource.set("status", entity.get("status"));
                    taskSource.set("group", (Object)entity.getDynamicObject("group"));
                    taskSource.set("creator", (Object)entity.getDynamicObject("creator"));
                    taskSource.set("createtime", entity.get("createtime"));
                    taskSource.set("modifier", (Object)entity.getDynamicObject("modifier"));
                    taskSource.set("modifytime", entity.get("modifytime"));
                    if (taskSourceExist) {
                        SaveServiceHelper.update((DynamicObject)taskSource);
                    } else {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskSource});
                    }
                    boolean planTypeExist = QueryServiceHelper.exists((String)planTypeEntityId, (Object)entity.getPkValue());
                    if (planTypeExist) {
                        planType = BusinessDataServiceHelper.loadSingle((Object)entity.getPkValue(), (DynamicObjectType)planTypeDt);
                    } else {
                        planType = new DynamicObject(planTypeDt);
                        planType.set("id", entity.getPkValue());
                        planType.set("masterid", entity.getPkValue());
                    }
                    planType.set("name", (Object)planName_s);
                    planType.set("number", (Object)entity.getString("number"));
                    planType.set("enable", entity.get("enable"));
                    planType.set("status", entity.get("status"));
                    planType.set("plantype", entity.get("plantype"));
                    planType.set("group", (Object)entity.getDynamicObject("group"));
                    planType.set("creator", (Object)entity.getDynamicObject("creator"));
                    planType.set("modifier", (Object)entity.getDynamicObject("modifier"));
                    planType.set("createtime", entity.get("createtime"));
                    planType.set("modifytime", entity.get("modifytime"));
                    if (planTypeExist) {
                        SaveServiceHelper.update((DynamicObject)planType);
                        continue;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planType});
                }
                break;
            }
            case "delete": {
                for (DynamicObject entity : dataEntities) {
                    DeleteServiceHelper.delete((IDataEntityType)taskSourceDt, (Object[])new Object[]{entity.getPkValue()});
                    DeleteServiceHelper.delete((IDataEntityType)planTypeDt, (Object[])new Object[]{entity.getPkValue()});
                }
                break;
            }
        }
    }
}

