/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class MasterPlanOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("sourceplan");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("prechangeplan");
        e.getFieldKeys().add("majortype");
        e.getFieldKeys().add("taskentity");
        e.getFieldKeys().add("specialtype");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("islatest");
        e.getFieldKeys().add("taskproject");
        e.getFieldKeys().add("belongplantype");
        e.getFieldKeys().add("prechangetask");
        e.getFieldKeys().add("relationtask");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("sourcetask");
        e.getFieldKeys().add("pretask");
        e.getFieldKeys().add("logical");
        e.getFieldKeys().add("achievementnode");
        e.getFieldKeys().add("percent");
        e.getFieldKeys().add("expecttime");
        e.getFieldKeys().add("assigner");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("taskentity.pid");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("multicooperationperson");
        e.getFieldKeys().add("responsibleperson");
        e.getFieldKeys().add("meetassigncount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (key) {
            case "submit": {
                for (DynamicObject bill : dataEntities) {
                    this.checkExistResultDoc(bill);
                }
                this.verifyLogical(dataEntities);
                this.verifyTaskDate(dataEntities);
                for (DynamicObject bill : dataEntities) {
                    this.changePlanStatus(bill, "submit");
                }
                this.updateTaskCompleteStatus(dataEntities);
                this.checkDifferentPerson(dataEntities);
                break;
            }
            case "unsubmit": {
                for (DynamicObject bill : dataEntities) {
                    this.changePlanStatus(bill, "unsubmit");
                }
                break;
            }
            case "audit": {
                this.changeBillStatus(dataEntities);
                this.updateReference(dataEntities);
                break;
            }
            case "delete": {
                break;
            }
        }
    }

    protected void verifyBuilding(DynamicObject[] dataEntities) {
    }

    private void checkDifferentPerson(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getPkValue().toString())) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject task = (DynamicObject)entries.get(i);
                DynamicObjectCollection multicooperationpersons = task.getDynamicObjectCollection("multicooperationperson");
                DynamicObject responsibleperson = task.getDynamicObject("responsibleperson");
                if (multicooperationpersons.size() < 1) continue;
                for (DynamicObject multicooperationperson : multicooperationpersons) {
                    if (!multicooperationperson.get("fbasedataid_id").equals(responsibleperson.getPkValue())) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u540d\u79f0\u201d\u7b2c%1$s\u884c \uff1a%2$s\u7684\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"MasterPlanOp_19", (String)"pccs-placs-opplugin", (Object[])new Object[0]), i + 1, task.getString("name"));
                    throw new KDBizException(msg);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(8);
        if ("audit".equals(key)) {
            for (DynamicObject bill : dataEntities) {
                if (bill.getDynamicObject("assigner") != null || bill.getDynamicObject("auditor") == null) continue;
                bill.set("assigner", (Object)bill.getDynamicObject("auditor"));
                billList.add(bill);
            }
            if (billList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
            }
            this.updateTaskAssigner(dataEntities);
        }
    }

    private void updateTaskAssigner(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject[] taskArr;
            DynamicObject assigner = bill.getDynamicObject("assigner");
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(8);
            QFilter planIdFilter = new QFilter("planid", "=", (Object)Long.valueOf(bill.getString("id")));
            for (DynamicObject task : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"assigner", (QFilter[])new QFilter[]{planIdFilter})) {
                task.set("assigner", (Object)assigner);
                taskList.add(task);
            }
            if (taskList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                if ("submit".equals(this.getOperateKey())) {
                    ExtendedDataEntity[] dataEntities;
                    block0: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObject bill = dataEntity.getDataEntity();
                        DynamicObjectCollection tasks = bill.getDynamicObjectCollection("taskentity");
                        if (tasks.size() <= 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5206\u5f55\u4e2d\u7f3a\u5c11\u4efb\u52a1\u884c\uff0c\u8bf7\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"MasterPlanOp_20", (String)"pccs-placs-opplugin", (Object[])new Object[0]), bill.get("billname").toString()));
                        }
                        HashMap<String, Integer> dic = new HashMap<String, Integer>(tasks.size());
                        for (int i = 0; i < tasks.size(); ++i) {
                            String name = ((DynamicObject)tasks.get(i)).getString("name");
                            if (dic.containsKey(name)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u7684\u4efb\u52a1\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MasterPlanOp_16", (String)"pccs-placs-opplugin", (Object[])new Object[0]), (Integer)dic.get(name) + 1, i + 1));
                                continue block0;
                            }
                            dic.put(name, i);
                        }
                    }
                }
            }
        });
    }

    protected void updateTaskCompleteStatus(DynamicObject[] dataEntities) {
        Date currentDate = new Date();
        BigDecimal oneHundred = BigDecimal.valueOf(100.0);
        for (DynamicObject plan : dataEntities) {
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
            if (taskEntries == null || taskEntries.isEmpty()) continue;
            for (DynamicObject task : taskEntries) {
                DynamicObject relateTask = task.getDynamicObject("relationtask");
                BigDecimal percent = task.getBigDecimal("percent");
                if (relateTask != null || percent.compareTo(oneHundred) == 0) continue;
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                Date expectTime = task.getDate("expecttime");
                if (DateUtil.compareByDay((Date)planStartTime, (Date)currentDate) > 0 && percent.compareTo(BigDecimal.ZERO) == 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                    continue;
                }
                if (expectTime != null && DateUtil.compareByDay((Date)expectTime, (Date)planEndTime) > 0 && percent.compareTo(BigDecimal.ZERO) > 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
                    continue;
                }
                if (DateUtil.compareByDay((Date)planEndTime, (Date)currentDate) < 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                    continue;
                }
                task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            }
        }
    }

    protected void updateReference(DynamicObject[] dataEntities) {
        for (DynamicObject plan : dataEntities) {
            DynamicObject[] workHourObjs;
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
            Map<Object, DynamicObject> ref = taskEntries.stream().filter(entry -> entry.getDynamicObject("prechangetask") != null).collect(Collectors.toMap(task -> task.getDynamicObject("prechangetask").getPkValue(), task -> task));
            QFilter filter1 = new QFilter("task", "in", ref.keySet());
            for (DynamicObject workHour : workHourObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"), (String)"task", (QFilter[])new QFilter[]{filter1})) {
                DynamicObject workHourTask = workHour.getDynamicObject("task");
                if (!ref.containsKey(workHourTask.getPkValue())) continue;
                workHour.set("task", (Object)ref.get(workHourTask.getPkValue()));
            }
            SaveServiceHelper.update((DynamicObject[])workHourObjs);
            HashMap<Object, Integer> task2meetcount = new HashMap<Object, Integer>(taskEntries.size());
            QFilter meettasksFilter = new QFilter("meettask", "in", (Object)ref.keySet().toArray());
            DynamicObject[] meettasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"meettask", (QFilter[])new QFilter[]{meettasksFilter});
            for (DynamicObject meettask : meettasks) {
                DynamicObject curTask = ref.get(meettask.getDynamicObject("meettask").getPkValue());
                meettask.set("meettask", (Object)curTask);
                task2meetcount.put(curTask.getPkValue(), task2meetcount.getOrDefault(curTask.getPkValue(), 0) + 1);
            }
            for (DynamicObject task2 : taskEntries) {
                if (!task2meetcount.containsKey(task2.getPkValue())) continue;
                task2.set("meetassigncount", task2meetcount.get(task2.getPkValue()));
            }
            if (meettasks.length <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])meettasks);
        }
    }

    protected void changePlanStatus(DynamicObject bill, String operate) {
        DynamicObjectCollection taskEntries = bill.getDynamicObjectCollection("taskentity");
        List<Object> taskIds = taskEntries.stream().map(entry -> Long.valueOf(entry.getPkValue().toString())).collect(Collectors.toList());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Object[taskIds.size()]), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        if ("submit".equals(operate)) {
            bill.set("planstatus", (Object)PlanEnum.CHECKING.getValue());
            this.changeTaskStatus(tasks, StatusEnum.UNCHECKED);
        } else {
            bill.set("planstatus", (Object)PlanEnum.CREATEING.getValue());
            this.changeTaskStatus(tasks, StatusEnum.TEMPSAVE);
        }
    }

    protected void changeTaskStatus(DynamicObject[] tasks, StatusEnum statusEnum) {
        if (tasks == null || tasks.length <= 0) {
            return;
        }
        DynamicObject[] newTasks = new DynamicObject[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            DynamicObject task = tasks[i];
            task.set("status", (Object)statusEnum.getValue());
            newTasks[i] = task;
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    protected void changeBillStatus(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject preChangePlanObject;
            bill.set("planstatus", (Object)PlanEnum.PUBLISHED.getValue());
            DynamicObjectCollection currentTaskEntry = bill.getDynamicObjectCollection("taskentity");
            DynamicObject majorType = bill.getDynamicObject("majortype");
            String planTypeEnumValue = majorType.getString("plantype");
            QFilter filter = planTypeEnumValue.equals(PlanTypeEnum.MAINPLAN.getValue()) ? new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue()) : new QFilter("id", "=", majorType.getPkValue());
            DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
            DynamicObject preChangeTask = null;
            DynamicObject sourceTask = null;
            for (DynamicObject currentEntry : currentTaskEntry) {
                preChangeTask = currentEntry.getDynamicObject("prechangetask");
                sourceTask = currentEntry.getDynamicObject("sourcetask");
                if (preChangeTask == null || sourceTask == null) {
                    currentEntry.set("sourcetask", (Object)currentEntry);
                }
                currentEntry.set("status", (Object)StatusEnum.CHECKED.getValue());
                currentEntry.set("islatest", (Object)DefaultEnum.YES.getValue());
                currentEntry.set("taskproject", (Object)bill.getDynamicObject("project"));
                currentEntry.set("belongplantype", (Object)planType);
            }
            DynamicObject preChangePlan = bill.getDynamicObject("prechangeplan");
            if (preChangePlan == null || (preChangePlanObject = BusinessDataServiceHelper.loadSingle((Object)preChangePlan.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"masterplan"))) == null) continue;
            preChangePlanObject.set("planstatus", (Object)PlanEnum.HISTORY.getValue());
            SaveServiceHelper.update((DynamicObject)preChangePlanObject);
            this.riskColorSet(currentTaskEntry);
            DynamicObjectCollection preChangePlanTasks = preChangePlanObject.getDynamicObjectCollection("taskentity");
            for (DynamicObject task : preChangePlanTasks) {
                if (task == null) continue;
                task.set("islatest", (Object)DefaultEnum.NO.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])preChangePlanTasks.toArray((Object[])new DynamicObject[preChangePlanTasks.size()])));
        }
    }

    protected void riskColorSet(DynamicObjectCollection currentTaskEntry) {
        Set taskIds = currentTaskEntry.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(',').append("controllevel").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("tasktype").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        RiskColorUtil.setColor((String)this.getAppId(), (DynamicObject[])tasks, (boolean)true);
        SaveServiceHelper.update((DynamicObject[])tasks);
    }

    protected void verifyLogical(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getPkValue().toString())) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
            StringBuilder sb = new StringBuilder();
            for (int curIndex = 0; curIndex < entries.size(); ++curIndex) {
                DynamicObject task = (DynamicObject)entries.get(curIndex);
                DynamicObject pretask = task.getDynamicObject("pretask");
                String logical = task.getString("logical");
                if (pretask == null || !StringUtil.isEmpty((CharSequence)logical)) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                    sb.append(curIndex + 1);
                    continue;
                }
                sb.append(curIndex + 1);
            }
            if (sb.length() == 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u586b\u5199\u524d\u7f6e\u4efb\u52a1\uff0c\u9700\u586b\u5199\u201c\u903b\u8f91\u5173\u7cfb\u201d\u3002", (String)"MasterPlanOp_21", (String)"pccs-placs-opplugin", (Object[])new Object[0]), sb));
        }
    }

    protected void verifyTaskDate(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getPkValue().toString())) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
            HashMap<String, DynamicObject> pkId2Task = new HashMap<String, DynamicObject>(entries.size());
            for (DynamicObject task : entries) {
                String msg;
                pkId2Task.put(task.getPkValue().toString(), task);
                DynamicObject parentTask = (DynamicObject)pkId2Task.get(task.getString("pid"));
                if (parentTask != null) {
                    Date parentEndDate;
                    Date parentBeginDate;
                    Date beginDate = task.getDate("planstarttime");
                    if (beginDate.compareTo(parentBeginDate = parentTask.getDate("planstarttime")) < 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"MasterPlanOp_22", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                        throw new KDBizException(msg);
                    }
                    Date endDate = task.getDate("planendtime");
                    if (endDate.compareTo(parentEndDate = parentTask.getDate("planendtime")) > 0) {
                        String msg2 = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"MasterPlanOp_23", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                        throw new KDBizException(msg2);
                    }
                }
                if (task == null) continue;
                Date endDate = task.getDate("planendtime");
                Date beginDate = task.getDate("planstarttime");
                if (endDate == null || beginDate == null || endDate.compareTo(beginDate) >= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"MasterPlanOp_23", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                throw new KDBizException(msg);
            }
        }
    }

    protected void verifyNameNotNull(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("taskentity");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tasks.size(); ++i) {
                DynamicObject task = (DynamicObject)tasks.get(i);
                if (!StringUtils.isEmpty((CharSequence)task.getString("name"))) continue;
                if (sb.length() > 0) {
                    sb.append('\uff0c');
                    sb.append(i + 1);
                    continue;
                }
                sb.append(i + 1);
            }
            if (sb.length() <= 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterPlanOp_18", (String)"pccs-placs-opplugin", (Object[])new Object[0]), sb));
        }
    }

    protected void checkExistResultDoc(DynamicObject bill) {
        DynamicObjectCollection tasks = bill.getDynamicObjectCollection("taskentity");
        if (tasks.size() <= 0) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            DynamicObjectCollection resultDocCollection;
            boolean hasResultDoc = false;
            DynamicObjectCollection txCollect = ((DynamicObject)tasks.get(i)).getDynamicObjectCollection("transactiontype");
            for (DynamicObject tx : txCollect) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                hasResultDoc = true;
            }
            if (!hasResultDoc || (resultDocCollection = ((DynamicObject)tasks.get(i)).getDynamicObjectCollection("taskresultdocentry")).size() > 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f53\u524d\u8ba1\u5212\u7b2c%s\u884c\uff1a\u201c\u6210\u679c\u660e\u7ec6\u201d\u3002", (String)"MasterPlanOp_24", (String)"pccs-placs-opplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(msg);
        }
    }
}

