/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.PersonPlanValidator;
import kd.pccs.placs.opplugin.base.BaseOp;

public class PersonPlanOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("respersontx");
        e.getFieldKeys().add("resdepttx");
        e.getFieldKeys().add("multicooperationperson");
        e.getFieldKeys().add("multicooperationdept");
        e.getFieldKeys().add("taskname");
        e.getFieldKeys().add("taskcontrolleveltx");
        e.getFieldKeys().add("taskstarttimetx");
        e.getFieldKeys().add("taskendtimetx");
        e.getFieldKeys().add("taskmubiaotx");
        e.getFieldKeys().add("tasktimepctx");
        e.getFieldKeys().add("taskabstractdate");
        e.getFieldKeys().add("islatest");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("relationtask");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("planningcycle");
        e.getFieldKeys().add("timerangestartdate");
        e.getFieldKeys().add("timerangeenddate");
        e.getFieldKeys().add("pid");
        e.getFieldKeys().add("name");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PersonPlanValidator(this.getAppId()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (key) {
            case "audit": {
                this.onAudit(dataEntities);
                break;
            }
            case "submit": {
                this.verifyTaskDate(dataEntities);
                this.changeTaskStatus(dataEntities);
                this.updateTaskCompleteStatus(dataEntities);
                break;
            }
            case "unaudit": {
                this.onUnaudit(dataEntities);
                break;
            }
        }
    }

    protected void onUnaudit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntry = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject task : taskEntry) {
                task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                task.set("islatest", (Object)"0");
            }
        }
    }

    protected void onAudit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntries = bill.getDynamicObjectCollection("entryentity");
            List<Object> taskIds = taskEntries.stream().map(entry -> Long.parseLong(entry.getPkValue().toString())).collect(Collectors.toList());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Object[taskIds.size()]), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            if (tasks == null || tasks.length <= 0) {
                return;
            }
            for (int i = 0; i < tasks.length; ++i) {
                DynamicObject task = tasks[i];
                task.set("status", (Object)StatusEnum.CHECKED.getValue());
                task.set("islatest", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        }
    }

    protected void verifySameName(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("entryentity");
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            for (int i = 0; i < tasks.size(); ++i) {
                String taskName = ((DynamicObject)tasks.get(i)).getString("taskname");
                if (map.containsKey(taskName)) {
                    int row = (Integer)map.get(taskName);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u7684\u4efb\u52a1\u540d\u79f0\u91cd\u590d\u3002", (String)"PersonPlanOp_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]), row + 1, i + 1));
                }
                map.put(taskName, i);
            }
        }
    }

    protected void changeTaskStatus(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntries = bill.getDynamicObjectCollection("entryentity");
            List<Object> taskIds = taskEntries.stream().map(entry -> Long.parseLong(entry.getPkValue().toString())).collect(Collectors.toList());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Object[taskIds.size()]), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            if (tasks == null || tasks.length <= 0) {
                return;
            }
            for (int i = 0; i < tasks.length; ++i) {
                DynamicObject task = tasks[i];
                task.set("status", (Object)StatusEnum.UNCHECKED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        }
    }

    protected void updateTaskCompleteStatus(DynamicObject[] dataEntities) {
        Date currentDate = new Date();
        for (DynamicObject plan : dataEntities) {
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("entryentity");
            if (taskEntries == null || taskEntries.isEmpty()) continue;
            for (DynamicObject task : taskEntries) {
                int result2;
                Date planEndTime;
                int result1;
                DynamicObject relateTask = task.getDynamicObject("relationtask");
                String complteStatus = task.getString("completionstatus");
                if (relateTask != null || !StringUtils.equals((CharSequence)complteStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue())) continue;
                Date planStartTime = task.getDate("taskstarttimetx");
                if (planStartTime != null && (result1 = DateUtil.compareByDay((Date)planStartTime, (Date)currentDate)) != 1) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                }
                if ((planEndTime = task.getDate("taskendtimetx")) == null || (result2 = DateUtil.compareByDay((Date)planEndTime, (Date)currentDate)) != -1) continue;
                task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            }
        }
    }

    protected void verifyTaskDate(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getPkValue().toString())) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            HashMap<String, DynamicObject> pkToTask = new HashMap<String, DynamicObject>(entries.size());
            for (DynamicObject task : entries) {
                String msg;
                pkToTask.put(task.getPkValue().toString(), task);
                DynamicObject parentTask = (DynamicObject)pkToTask.get(task.getString("pid"));
                if (parentTask != null) {
                    Date parentEndDate;
                    Date parentBeginDate;
                    Date beginDate = task.getDate("taskstarttimetx");
                    if (beginDate.compareTo(parentBeginDate = parentTask.getDate("taskstarttimetx")) < 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PersonPlanOp_9", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("taskname"));
                        throw new KDBizException(msg);
                    }
                    Date endDate = task.getDate("taskendtimetx");
                    if (endDate.compareTo(parentEndDate = parentTask.getDate("taskendtimetx")) > 0) {
                        String msg2 = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PersonPlanOp_10", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("taskname"));
                        throw new KDBizException(msg2);
                    }
                }
                if (task == null) continue;
                Date endDate = task.getDate("taskendtimetx");
                Date beginDate = task.getDate("taskstarttimetx");
                if (endDate == null || beginDate == null || endDate.compareTo(beginDate) >= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PersonPlanOp_11", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("taskname"));
                throw new KDBizException(msg);
            }
        }
    }
}

