/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class PersonPlanValidator
extends AbstractValidator {
    private String appId = "placs";

    public PersonPlanValidator(String appId) {
        this.appId = appId;
    }

    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            this.submitValidate();
        }
    }

    protected void submitValidate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        String userId = RequestContext.get().getUserId();
        for (ExtendedDataEntity dataEntity : entities) {
            boolean result = true;
            StringBuilder sb = new StringBuilder();
            DynamicObject object = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = object.getDynamicObjectCollection("entryentity");
            if (entryEntities.size() <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5206\u5f55\u4e2d\u7f3a\u5c11\u4efb\u52a1\u884c\uff0c\u8bf7\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"PersonPlanValidator_9", (String)"pccs-placs-opplugin", (Object[])new Object[0]), object.get("name").toString()));
            }
            if (result = this.validateOfNull(object, sb)) {
                result = this.onePlan(object, sb);
            }
            if (result) {
                result = this.validateCoopAndResp(object, sb, userId);
            }
            if (result) continue;
            this.addErrorMessage(dataEntity, sb.toString());
        }
    }

    protected boolean validateCoopAndResp(DynamicObject object, StringBuilder sb, String userId) {
        DynamicObjectCollection entryEntities = object.getDynamicObjectCollection("entryentity");
        if (entryEntities != null) {
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject response = entryEntity.getDynamicObject("respersontx");
                DynamicObjectCollection coopers = entryEntity.getDynamicObjectCollection("multicooperationperson");
                ArrayList cooperIds = new ArrayList();
                coopers.stream().map(o -> cooperIds.add(o.getLong("fbasedataid_id"))).count();
                if (response != null && response.getPkValue().toString().equals(userId) || coopers != null && cooperIds.contains(Long.parseLong(userId))) continue;
                sb.append(ResManager.loadKDString((String)"\u767b\u5f55\u4eba\u5fc5\u987b\u4e3a\u4e3b\u8d23\u4eba\u6216\u534f\u529e\u4eba\u3002", (String)"PersonPlanValidator_10", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean onePlan(DynamicObject object, StringBuilder sb) {
        DynamicObject org = object.getDynamicObject("org");
        DynamicObject modifier = object.getDynamicObject("modifier");
        Object planningCycle = object.get("planningcycle");
        Object startTime = object.get("timerangestartdate");
        Object endTime = object.get("timerangeenddate");
        QFilter time1 = new QFilter("timerangestartdate", "<=", startTime).and(new QFilter("timerangeenddate", ">=", startTime));
        QFilter time2 = new QFilter("timerangestartdate", "<=", endTime).and(new QFilter("timerangeenddate", ">=", endTime));
        QFilter time = time1.or(time2);
        QFilter time3 = new QFilter("timerangestartdate", ">=", startTime).and(new QFilter("timerangeenddate", "<=", endTime));
        time.or(time3);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("planningcycle", "=", planningCycle), new QFilter("modifier", "=", modifier.get("id")), time, new QFilter("id", "!=", object.getPkValue())};
        boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.appId, (String)"personplan"), (QFilter[])filters);
        if (exists) {
            sb.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5728\u8be5\u65f6\u95f4\u6bb5\u5df2\u5b58\u5728\u4e2a\u4eba\u8ba1\u5212\uff0c\u65e0\u6cd5\u91cd\u590d\u5236\u5b9a\u3002", (String)"PersonPlanValidator_11", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
        }
        return !exists;
    }

    protected boolean validateOfNull(DynamicObject object, StringBuilder sb) {
        boolean flag = true;
        Object planningcycle = object.get("planningcycle");
        if (null == planningcycle) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u5468\u671f\u3002", (String)"PersonPlanValidator_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
            flag = false;
        }
        Object startTime = object.get("timerangestartdate");
        Object endTime = object.get("timerangeenddate");
        if (null == startTime || null == endTime) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65f6\u95f4\u8303\u56f4\u3002", (String)"PersonPlanValidator_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
            flag = false;
        }
        return flag;
    }
}

