/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.project.StageStatusHelper;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.MajorTypeEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.enums.project.BudgetStageEnum;
import kd.pccs.placs.common.enums.project.ProjectStageEnum;
import kd.pccs.placs.common.enums.project.ProjectStatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class ProgressReportOp
extends BaseOp {
    private static final String PERCENT_OK = "100";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("percent");
        e.getFieldKeys().add("completetime");
        e.getFieldKeys().add("huibaoperson");
        e.getFieldKeys().add("reportdesc");
        e.getFieldKeys().add("achieveentity");
        e.getFieldKeys().add("taskresultdocentry");
        e.getFieldKeys().add("resultname1");
        e.getFieldKeys().add("force1");
        e.getFieldKeys().add("frequency1");
        e.getFieldKeys().add("resultname1");
        e.getFieldKeys().add("resultdescription");
        e.getFieldKeys().add("resolutionentity");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("sourcetask");
        e.getFieldKeys().add("taskpercent");
        e.getFieldKeys().add("planstarttime1");
        e.getFieldKeys().add("planendtime1");
        e.getFieldKeys().add("expecttime");
        e.getFieldKeys().add("realendtime");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("tasksource");
        e.getFieldKeys().add("islatest");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("achieveentity.attachmentfield");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"submit")) {
            this.doSubmit(dataEntities);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"unsubmit")) {
            this.doUnsubmit(dataEntities);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"audit")) {
            this.doAudit(dataEntities);
        }
        this.processMeetingResolutionTask(dataEntities, operationKey);
    }

    protected void doSubmit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject task = bill.getDynamicObject("task");
            QFilter noComFilter = new QFilter("autocomplete", "=", (Object)Boolean.FALSE);
            QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
            QFilter percentFilter = new QFilter("percent", "=", (Object)100);
            QFilter taskIdFilter = new QFilter("task", "=", task.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
            DynamicObject lastReport = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"id,task,percent,autocomplete,latest,reportdesc,achieveentity.attachmentfield,resolutionentity.name", (QFilter[])new QFilter[]{noComFilter, latestFilter, percentFilter, taskIdFilter, statusFilter});
            if (lastReport != null) {
                String preReportDesc = lastReport.getString("reportdesc");
                String selectProperties = "fid,fattachmentname";
                QFilter preInterIdFilter = new QFilter("finterid", "=", (Object)String.valueOf(lastReport.getPkValue()));
                QFilter billTypeFilter = new QFilter("fbilltype", "=", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
                QFilter panelFilter = new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel");
                DynamicObject[] preAttachmentsInPanel = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectProperties, (QFilter[])new QFilter[]{preInterIdFilter, billTypeFilter, panelFilter});
                Set prePanelNameSet = Arrays.stream(preAttachmentsInPanel).map(o -> o.getString("fattachmentname")).collect(Collectors.toSet());
                DynamicObjectCollection preAchieveentity = (DynamicObjectCollection)lastReport.get("achieveentity");
                ArrayList preAttachNameList = new ArrayList(10);
                for (int i = 0; i < preAchieveentity.size(); ++i) {
                    DynamicObject row = (DynamicObject)preAchieveentity.get(i);
                    DynamicObjectCollection attachmentfield = (DynamicObjectCollection)row.get("attachmentfield");
                    HashSet<String> fieldnameSet = new HashSet<String>(16);
                    for (int j = 0; j < attachmentfield.size(); ++j) {
                        DynamicObject attach = (DynamicObject)attachmentfield.get(j);
                        String attachName = ((DynamicObject)attach.get("fbasedataid")).get("name").toString();
                        fieldnameSet.add(attachName);
                    }
                    preAttachNameList.add(fieldnameSet);
                }
                DynamicObjectCollection lastResolutions = (DynamicObjectCollection)lastReport.get("resolutionentity");
                String curReportDesc = bill.getString("reportdesc");
                QFilter curInterIdFilter = new QFilter("finterid", "=", (Object)String.valueOf(bill.getPkValue()));
                DynamicObject[] curAttachmentsInPanel = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectProperties, (QFilter[])new QFilter[]{curInterIdFilter, billTypeFilter, panelFilter});
                Set curPanelNameSet = Arrays.stream(curAttachmentsInPanel).map(o -> o.getString("fattachmentname")).collect(Collectors.toSet());
                DynamicObjectCollection curAchieveentity = (DynamicObjectCollection)bill.get("achieveentity");
                ArrayList curAttachNameList = new ArrayList(10);
                for (int i = 0; i < curAchieveentity.size(); ++i) {
                    DynamicObject row = (DynamicObject)curAchieveentity.get(i);
                    DynamicObjectCollection attachmentfield = (DynamicObjectCollection)row.get("attachmentfield");
                    HashSet<String> fieldnameSet = new HashSet<String>(16);
                    for (int j = 0; j < attachmentfield.size(); ++j) {
                        DynamicObject attach = (DynamicObject)attachmentfield.get(j);
                        String attachName = ((DynamicObject)attach.get("fbasedataid")).get("name").toString();
                        fieldnameSet.add(attachName);
                    }
                    curAttachNameList.add(fieldnameSet);
                }
                DynamicObjectCollection curResolutions = (DynamicObjectCollection)bill.get("resolutionentity");
                boolean beSameDesc = true;
                if (!preReportDesc.equals(curReportDesc)) {
                    beSameDesc = false;
                }
                boolean beSamePanelName = true;
                if (!prePanelNameSet.containsAll(curPanelNameSet)) {
                    beSamePanelName = false;
                }
                boolean beSameFieldName = true;
                if (preAttachNameList.size() == curAttachNameList.size()) {
                    for (int i = 0; i < preAttachNameList.size(); ++i) {
                        Set set2;
                        Set set1 = (Set)preAttachNameList.get(i);
                        if (set1.containsAll(set2 = (Set)curAttachNameList.get(i))) continue;
                        beSameFieldName = false;
                        break;
                    }
                }
                boolean beSameResolutions = false;
                if ((lastResolutions == null || lastResolutions.isEmpty()) && (curResolutions == null || curResolutions.isEmpty())) {
                    beSameResolutions = true;
                }
                if (beSameDesc && beSameFieldName && beSamePanelName && beSameResolutions) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u6c47\u62a5\u672a\u505a\u4fee\u6539\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ProgressReportOp_13", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
                }
            }
            DynamicObject majortype = task.getDynamicObject("majortype");
            DynamicObject project = task.getDynamicObject("project");
            if (project == null || majortype == null || !StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) continue;
            this.reportChangeStatus(project, ProjectStatusEnum.APPROVAL_IN);
        }
    }

    protected void processMeetingResolutionTask(DynamicObject[] dataEntities, String operationKey) {
        this.changeTaskStatus(dataEntities, operationKey);
        if (StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)operationKey)) {
            this.checkExistResultDoc(dataEntities);
            this.updateTaskCompleteStatus(dataEntities);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"audit", (CharSequence)operationKey)) {
            this.riskColorSet(dataEntities);
            this.setMeettaskCount(dataEntities, true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"unaudit", (CharSequence)operationKey)) {
            this.setMeettaskCount(dataEntities, false);
        }
    }

    protected void checkExistResultDoc(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("resolutionentity");
            if (tasks.size() <= 0) {
                return;
            }
            for (int i = 0; i < tasks.size(); ++i) {
                DynamicObjectCollection resultDocCollection;
                boolean hasResultDoc = false;
                DynamicObjectCollection txCollect = ((DynamicObject)tasks.get(i)).getDynamicObjectCollection("transactiontype");
                for (DynamicObject tx : txCollect) {
                    Long baseDataId = tx.getLong("fbasedataid_id");
                    DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                    if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                    hasResultDoc = true;
                }
                if (!hasResultDoc || (resultDocCollection = ((DynamicObject)tasks.get(i)).getDynamicObjectCollection("taskresultdocentry")).size() > 0) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4f1a\u8bae\u51b3\u8bae\u7b2c%s\u884c\uff1a\u201c\u6210\u679c\u660e\u7ec6\u201d\u3002", (String)"ProgressReportOp_14", (String)"pccs-placs-opplugin", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg);
            }
        }
    }

    protected void setMeettaskCount(DynamicObject[] dataEntities, boolean add) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("resolutionentity");
            DynamicObject task = bill.getDynamicObject("task");
            if ((task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"))) == null) continue;
            if (add) {
                task.set("meetassigncount", (Object)(task.getInt("meetassigncount") + tasks.size()));
            } else {
                task.set("meetassigncount", (Object)(task.getInt("meetassigncount") - tasks.size()));
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        }
    }

    protected void updateTaskCompleteStatus(DynamicObject[] dataEntities) {
        BigDecimal oneHundred = BigDecimal.valueOf(100.0);
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("resolutionentity");
            for (DynamicObject task : tasks) {
                BigDecimal percent = task.getBigDecimal("taskpercent");
                if (percent.compareTo(oneHundred) == 0) {
                    return;
                }
                Date planStartTime = task.getDate("planstarttime1");
                Date planEndTime = task.getDate("planendtime1");
                Date expectTime = task.getDate("expecttime");
                Date currentDate = new Date();
                if (DateUtil.compareByDay((Date)planStartTime, (Date)currentDate) > 0 && percent.compareTo(BigDecimal.ZERO) == 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                    continue;
                }
                if (expectTime != null && DateUtil.compareByDay((Date)expectTime, (Date)planEndTime) > 0 && percent.compareTo(BigDecimal.ZERO) > 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
                    continue;
                }
                if (DateUtil.compareByDay((Date)planEndTime, (Date)currentDate) < 0) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                    continue;
                }
                task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            }
        }
    }

    protected void changeTaskStatus(DynamicObject[] dataEntities, String operationKey) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("resolutionentity");
            for (DynamicObject task : tasks) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)operationKey)) {
                    task.set("status", (Object)StatusEnum.UNCHECKED.getValue());
                    task.set("isleaf", (Object)DefaultEnum.YES.getValue());
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"audit", (CharSequence)operationKey)) {
                    task.set("status", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject sourceTask = task.getDynamicObject("sourcetask");
                    if (null == sourceTask) {
                        task.set("sourcetask", (Object)task);
                    }
                    task.set("islatest", (Object)DefaultEnum.YES.getValue());
                    continue;
                }
                task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            }
        }
    }

    protected void riskColorSet(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection meettasks = bill.getDynamicObjectCollection("resolutionentity");
            Set taskIds = meettasks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            StringBuilder seletors = new StringBuilder();
            seletors.append("id").append(',').append("controllevel").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("tasktype").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
            RiskColorUtil.setColor((String)this.getAppId(), (DynamicObject[])tasks, (boolean)true);
            SaveServiceHelper.update((DynamicObject[])tasks);
        }
    }

    protected void doAddAssignTask(DynamicObject[] dataEntities) {
        DynamicObject task = dataEntities[0].getDynamicObject("task");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assigntask"));
        if (null != task) {
            map.put("taskId", task.getPkValue());
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.setAppId(this.getAppId());
    }

    protected void reportChangeStatus(DynamicObject project, ProjectStatusEnum approvalIn) {
        StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, (ProjectStatusEnum)approvalIn);
    }

    protected void doUnsubmit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject task = bill.getDynamicObject("task");
            DynamicObject majortype = task.getDynamicObject("majortype");
            DynamicObject project = task.getDynamicObject("project");
            if (project == null || majortype == null || !StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) continue;
            DynamicObject[] budgetStage = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_2.getValue())});
            QFilter filter1 = new QFilter("budgetstage", "=", budgetStage[0].getPkValue());
            QFilter filter2 = new QFilter("version", "=", (Object)BigDecimal.valueOf(1.0));
            QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter3.or(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
            DynamicObject[] budget = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, name, project, version, sourcetype, issys, type, description, isvalid, currency, totalamount, group, budgetstage, presamount, prevamount, schangeamount, vchangeamount", (QFilter[])new QFilter[]{filter1, filter2, filter3});
            if (budget != null && budget.length >= 1) continue;
            this.reportChangeStatus(project, null);
        }
    }

    protected void doAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> reportTaskList = new ArrayList<DynamicObject>();
        HashMap<DynamicObject, DynamicObject> reportRecordMap = new HashMap<DynamicObject, DynamicObject>(10);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject task = (DynamicObject)dataEntity.get("task");
            DynamicObject reportTask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            this.updataTaskField(dataEntity, reportTaskList, reportRecordMap, reportTask);
            this.updateTaskReportRecordStatus(reportTask.getPkValue(), dataEntity.getPkValue());
        }
        Collection reportRecords = reportRecordMap.values();
        if (reportRecords != null && !reportRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])reportRecords.toArray(new DynamicObject[reportRecords.size()]));
        }
        for (Map.Entry entry : reportRecordMap.entrySet()) {
            this.updateTaskReportRecordStatus(((DynamicObject)entry.getKey()).getPkValue(), ((DynamicObject)entry.getValue()).getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])reportTaskList.toArray(new DynamicObject[reportTaskList.size()]));
        this.updateRelateTaskData(reportTaskList);
    }

    protected void updataTaskField(DynamicObject dataEntity, List<DynamicObject> reportTaskList, Map<DynamicObject, DynamicObject> reportRecordMap, DynamicObject reportTask) {
        int percent = dataEntity.getInt("percent");
        String reportPerson = dataEntity.getString("huibaoperson");
        this.riskWarningSet(dataEntity, reportTask);
        if (percent == 100) {
            DynamicObject parentTask;
            DynamicObject curReportTask = reportTask;
            while (curReportTask != null && (parentTask = curReportTask.getDynamicObject("parent")) != null) {
                parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                DynamicObject plan = null;
                DynamicObjectCollection taskEntry = null;
                DynamicObject belongPlanType = curReportTask.getDynamicObject("belongplantype");
                belongPlanType = BusinessDataServiceHelper.loadSingle((Object)belongPlanType.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"plantype"));
                String planType = belongPlanType.getString("plantype");
                String planId = curReportTask.getString("planid");
                if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                    plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
                    taskEntry = plan.getDynamicObjectCollection("taskentity");
                } else if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.MAJORPLAN.getValue())) {
                    plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
                    taskEntry = plan.getDynamicObjectCollection("taskentity");
                } else if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) {
                    plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"));
                    taskEntry = plan.getDynamicObjectCollection("taskentity");
                } else if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue())) {
                    plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"personplan"));
                    taskEntry = plan.getDynamicObjectCollection("entryentity");
                }
                if (plan == null) continue;
                ArrayList<DynamicObject> sonTaskList = new ArrayList<DynamicObject>();
                for (DynamicObject task : taskEntry) {
                    long pid = task.getLong("pid");
                    if (pid != (Long)parentTask.getPkValue() || ((Long)task.getPkValue()).longValue() == ((Long)curReportTask.getPkValue()).longValue()) continue;
                    sonTaskList.add(task);
                }
                if (!sonTaskList.isEmpty()) {
                    boolean isSonTaskComplete = true;
                    for (DynamicObject sonTask : sonTaskList) {
                        int sonTaskPercent = sonTask.getInt("percent");
                        if (sonTaskPercent == 100) continue;
                        isSonTaskComplete = false;
                        break;
                    }
                    if (isSonTaskComplete) {
                        curReportTask = this.updateParentTask(dataEntity, reportTaskList, reportRecordMap, parentTask);
                        continue;
                    }
                    break;
                }
                curReportTask = this.updateParentTask(dataEntity, reportTaskList, reportRecordMap, parentTask);
            }
        } else {
            reportTask.set("realendtime", null);
        }
        DynamicObject sharer = reportTask.getDynamicObject("sharer");
        boolean reporterIsSahrer = sharer != null && sharer.getString("id").equals(RequestContext.get().getUserId());
        reportTask.set("completedescription", (Object)dataEntity.getString("reportdesc"));
        this.setResultdocField(dataEntity, reportTask);
        reportTaskList.add(reportTask);
        if (reporterIsSahrer || !StringUtils.containsIgnoreCase((CharSequence)reportPerson, (CharSequence)ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"ProgressReportOp_0", (String)"pccs-placs-opplugin", (Object[])new Object[0]))) {
            this.setTaskProgressFields(dataEntity, reportTaskList, percent);
        }
    }

    protected DynamicObject updateParentTask(DynamicObject dataEntity, List<DynamicObject> reportTaskList, Map<DynamicObject, DynamicObject> reportRecordMap, DynamicObject parentTask) {
        DynamicObject relateTask = parentTask.getDynamicObject("relationtask");
        if (relateTask == null) {
            int parentPercent = parentTask.getInt("percent");
            if (parentPercent != 100) {
                parentTask.set("realendtime", (Object)dataEntity.getDate("completetime"));
                parentTask.set("completedescription", (Object)ResManager.loadKDString((String)"\u4e0b\u7ea7\u5b50\u4efb\u52a1\u90fd\u5b8c\u6210\uff0c\u81ea\u52a8\u66f4\u65b0\u7236\u7ea7\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210\u3002", (String)"ProgressReportOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
                this.riskWarningSet(dataEntity, parentTask);
                reportTaskList.add(parentTask);
                DynamicObject taskReport = this.createNewTaskReport(parentTask);
                reportRecordMap.put(parentTask, taskReport);
                DynamicObject majortype = parentTask.getDynamicObject("majortype");
                DynamicObject project = parentTask.getDynamicObject("project");
                if (project != null && majortype != null && StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) {
                    this.reportChangeStatus(project, ProjectStatusEnum.APPROVAL_IN);
                }
            }
        } else if ((relateTask = BusinessDataServiceHelper.loadSingle((Object)relateTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"))).getBoolean("islatest")) {
            int relatePercent = relateTask.getInt("percent");
            if (relatePercent != 100) {
                relateTask.set("realendtime", (Object)dataEntity.getDate("completetime"));
                relateTask.set("completedescription", (Object)ResManager.loadKDString((String)"\u4e0b\u7ea7\u5b50\u4efb\u52a1\u90fd\u5b8c\u6210\uff0c\u81ea\u52a8\u66f4\u65b0\u7236\u7ea7\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210\u3002", (String)"ProgressReportOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
                this.riskWarningSet(dataEntity, relateTask);
                reportTaskList.add(relateTask);
                DynamicObject taskReport = this.createNewTaskReport(relateTask);
                reportRecordMap.put(relateTask, taskReport);
                DynamicObject majortype = relateTask.getDynamicObject("majortype");
                DynamicObject project = relateTask.getDynamicObject("project");
                if (project != null && majortype != null && StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) {
                    this.reportChangeStatus(project, ProjectStatusEnum.APPROVAL_IN);
                }
            }
            parentTask = relateTask;
        } else {
            DynamicObject sourceTask = relateTask.getDynamicObject("sourcetask");
            QFilter filter = sourceTask == null ? new QFilter("sourcetask", "in", relateTask.getPkValue()) : new QFilter("sourcetask", "in", sourceTask.getPkValue());
            filter.and(new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue()));
            filter.and(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
            DynamicObject latestRelateTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter});
            latestRelateTask = BusinessDataServiceHelper.loadSingle((Object)latestRelateTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            if (latestRelateTask != null) {
                int relatePercent = relateTask.getInt("percent");
                if (relatePercent != 100) {
                    latestRelateTask.set("realendtime", (Object)dataEntity.getDate("completetime"));
                    latestRelateTask.set("completedescription", (Object)ResManager.loadKDString((String)"\u4e0b\u7ea7\u5b50\u4efb\u52a1\u90fd\u5b8c\u6210\uff0c\u81ea\u52a8\u66f4\u65b0\u7236\u7ea7\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210\u3002", (String)"ProgressReportOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
                    this.riskWarningSet(dataEntity, latestRelateTask);
                    reportTaskList.add(latestRelateTask);
                    DynamicObject taskReport = this.createNewTaskReport(latestRelateTask);
                    reportRecordMap.put(latestRelateTask, taskReport);
                    DynamicObject majortype = latestRelateTask.getDynamicObject("majortype");
                    DynamicObject project = latestRelateTask.getDynamicObject("project");
                    if (project != null && majortype != null && StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) {
                        this.reportChangeStatus(project, ProjectStatusEnum.APPROVAL_IN);
                    }
                }
                parentTask = latestRelateTask;
            }
        }
        return parentTask;
    }

    protected void setTaskProgressFields(DynamicObject dataEntity, List<DynamicObject> reportTaskList, int percent) {
        for (DynamicObject reportTask : reportTaskList) {
            BigDecimal realTimeDeviatiom;
            reportTask.set("percent", (Object)percent);
            Date completeTime = dataEntity.getDate("completetime");
            Date planendtime = reportTask.getDate("planendtime");
            DynamicObject project = reportTask.getDynamicObject("project");
            if (project != null) {
                realTimeDeviatiom = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)completeTime, (Date)planendtime, (String)this.getAppId());
            } else {
                try {
                    realTimeDeviatiom = TaskUtil.getDaysBetweenTwoDateByOrg((Object)RequestContext.get().getOrgId(), (Date)completeTime, (Date)planendtime, (String)this.getAppId());
                }
                catch (KDBizException e) {
                    realTimeDeviatiom = BigDecimal.valueOf(DateUtil.getDaysBetweenTwoDate((Date)completeTime, (Date)planendtime));
                }
            }
            if (100 == percent) {
                reportTask.set("realtimedeviation", (Object)realTimeDeviatiom);
            } else {
                reportTask.set("realtimedeviation", (Object)BigDecimal.ZERO);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(percent), (CharSequence)PERCENT_OK)) {
                if (DateUtil.compareByDay((Date)completeTime, (Date)planendtime) <= 0) {
                    reportTask.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
                } else if (DateUtil.compareByDay((Date)completeTime, (Date)planendtime) > 0) {
                    reportTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                }
                reportTask.set("realendtime", (Object)completeTime);
                continue;
            }
            if (percent <= 0) continue;
            Date currentDate = DateUtil.getCurrentDate();
            if (DateUtil.compareByDay((Date)planendtime, (Date)currentDate) < 0) {
                reportTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            } else if (DateUtil.compareByDay((Date)completeTime, (Date)planendtime) > 0) {
                reportTask.set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
            } else if (DateUtil.compareByDay((Date)planendtime, (Date)currentDate) > 0) {
                reportTask.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            }
            reportTask.set("expecttime", (Object)completeTime);
        }
    }

    protected void setResultdocField(DynamicObject dataEntity, DynamicObject reportTask) {
        DynamicObjectCollection achieveEntity = dataEntity.getDynamicObjectCollection("achieveentity");
        if (achieveEntity != null && achieveEntity.size() > 0) {
            int uploadNum = 0;
            for (int i = 0; i < achieveEntity.size(); ++i) {
                DynamicObjectCollection files = (DynamicObjectCollection)((DynamicObject)achieveEntity.get(i)).get("attachmentfield");
                if (files.size() > 0) {
                    ++uploadNum;
                    continue;
                }
                QFilter taskid = new QFilter("task", "=", reportTask.getPkValue());
                QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
                DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency"), (QFilter[])filters, (String)"modifytime desc");
                if (taskReportObjs == null || taskReportObjs.length <= 0) continue;
                for (DynamicObject oldReport : taskReportObjs) {
                    DynamicObjectCollection oldEntity = oldReport.getDynamicObjectCollection("achieveentity");
                    DynamicObjectCollection oldFiles = (DynamicObjectCollection)((DynamicObject)oldEntity.get(i)).get("attachmentfield");
                    if (oldFiles.size() <= 0) continue;
                    ++uploadNum;
                }
            }
            reportTask.set("resultdoc", (Object)("(" + uploadNum + "/" + achieveEntity.size() + ")"));
        }
    }

    protected void updateRelateTaskData(List<DynamicObject> tasks) {
        LinkedList<DynamicObject> relateTaskList = new LinkedList<DynamicObject>();
        for (DynamicObject task : tasks) {
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            DynamicObject[] relationTasks = null;
            if (sourceTask == null) {
                QFilter qFilter = new QFilter("relationtask", "=", task.getPkValue());
                relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{qFilter});
                if (relationTasks.length == 0) {
                    continue;
                }
            } else {
                QFilter taskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue()).or(new QFilter("id", "=", sourceTask.getPkValue()));
                DynamicObject[] allTaskOfPlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{taskFilter});
                Set taskIdSet = Arrays.stream(allTaskOfPlan).map(o -> o.getPkValue()).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("relationtask", "in", taskIdSet);
                relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{qFilter});
                if (relationTasks.length == 0) continue;
            }
            BigDecimal percent = task.getBigDecimal("percent");
            Date expectTime = task.getDate("expecttime");
            Date realendTime = task.getDate("realendtime");
            String completionStatus = task.getString("completionstatus");
            String completeDescription = task.getString("completedescription");
            BigDecimal realtimedeviation = task.getBigDecimal("realtimedeviation");
            if (percent.intValue() == 100) {
                for (DynamicObject relationTask : relationTasks) {
                    relationTask.set("percent", (Object)percent);
                    relationTask.set("realendtime", (Object)realendTime);
                    relationTask.set("completionstatus", (Object)completionStatus);
                    relationTask.set("completedescription", (Object)completeDescription);
                    relationTask.set("realtimedeviation", (Object)realtimedeviation);
                    relateTaskList.add(relationTask);
                }
                continue;
            }
            for (DynamicObject relationTask : relationTasks) {
                relationTask.set("percent", (Object)percent);
                relationTask.set("realendtime", null);
                relationTask.set("expecttime", (Object)expectTime);
                relationTask.set("completionstatus", (Object)completionStatus);
                relationTask.set("completedescription", (Object)completeDescription);
                relationTask.set("realtimedeviation", (Object)realtimedeviation);
                relateTaskList.add(relationTask);
            }
        }
        SaveServiceHelper.save((DynamicObject[])relateTaskList.toArray(new DynamicObject[relateTaskList.size()]));
    }

    protected void riskWarningSet(DynamicObject dataEntity, DynamicObject reportTask) {
        Date completetime = dataEntity.getDate("completetime");
        Date planendTime = reportTask.getDate("planendtime");
        if (dataEntity.getInt("percent") == 100) {
            reportTask.set("riskcolor", null);
            return;
        }
        if (completetime != null && completetime.compareTo(planendTime) > 0) {
            BigDecimal newAbsoluteDuration;
            DynamicObject tasktype = reportTask.getDynamicObject("tasktype");
            DynamicObject project = reportTask.getDynamicObject("project");
            if (tasktype == null) {
                return;
            }
            QFilter filter = new QFilter("tasktype", "=", tasktype.getPkValue());
            DynamicObject[] riskWarnings = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"riskwarningset"), (String)"risktime, riskcolor, tasktype", (QFilter[])new QFilter[]{filter}, (String)"risktime");
            if (project != null) {
                newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)ProgressReportOp.getStartTime(), (Date)planendTime, (String)this.getAppId());
            } else {
                DynamicObject[] sourcePlan = null;
                DynamicObject belongplantype = reportTask.getDynamicObject("belongplantype");
                if (belongplantype != null) {
                    String plantype = belongplantype.getString("plantype");
                    QFilter filter1 = new QFilter("id", "=", reportTask.get("planid"));
                    if (StringUtils.equals((CharSequence)"3", (CharSequence)plantype)) {
                        sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                    } else if (StringUtils.equals((CharSequence)"4", (CharSequence)plantype)) {
                        sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"personplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                    }
                }
                if (sourcePlan != null && sourcePlan.length > 0) {
                    newAbsoluteDuration = TaskUtil.getAbsDurationByOrgId((Object)sourcePlan[0].getDynamicObject("org").getPkValue(), (Date)ProgressReportOp.getStartTime(), (Date)planendTime, (String)this.getAppId());
                } else if (sourcePlan == null && tasktype != null && TaskTypeEnum.ASSIGNTASK.getValue().equals(tasktype.getString("number"))) {
                    long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(RequestContext.get().getUserId()));
                    newAbsoluteDuration = TaskUtil.getAbsDurationByOrgId((Object)mainOrgId, (Date)ProgressReportOp.getStartTime(), (Date)planendTime, (String)this.getAppId());
                } else {
                    return;
                }
            }
            newAbsoluteDuration = newAbsoluteDuration.add(BigDecimal.ONE);
            boolean isRisk = false;
            for (int i = 0; i < riskWarnings.length; ++i) {
                DynamicObject risk = riskWarnings[i];
                if (newAbsoluteDuration.compareTo(risk.getBigDecimal("risktime")) > 0 || newAbsoluteDuration.compareTo(BigDecimal.ZERO) <= 0) continue;
                reportTask.set("riskcolor", (Object)risk.getString("riskcolor"));
                isRisk = true;
                break;
            }
            if (!isRisk) {
                reportTask.set("riskcolor", null);
            }
        } else {
            reportTask.set("riskcolor", null);
        }
    }

    protected static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    protected void updateTaskReportRecordStatus(Object taskId, Object currentReportId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter taskFilter = new QFilter("task", "=", taskId);
        filters.add(taskFilter);
        QFilter idFilter = new QFilter("id", "!=", currentReportId);
        filters.add(idFilter);
        DynamicObject[] reports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"latest", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (reports.length == 0) {
            return;
        }
        for (DynamicObject report : reports) {
            report.set("latest", (Object)DefaultEnum.NO.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])reports);
    }

    protected DynamicObject createNewTaskReport(DynamicObject task) {
        DynamicObject taskReport = new DynamicObject(MetaDataUtil.getDT((String)this.getAppId(), (String)"taskreport"));
        ORM orm = ORM.create();
        Long id = orm.genLongId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
        taskReport.set("id", (Object)id);
        taskReport.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        String userId = RequestContext.get().getUserId();
        taskReport.set("creator", (Object)userId);
        taskReport.set("modifier", (Object)userId);
        taskReport.set("auditor", (Object)userId);
        Date date = DateUtil.getCurrentDate();
        taskReport.set("createtime", (Object)date);
        taskReport.set("modifytime", (Object)date);
        taskReport.set("auditdate", (Object)date);
        taskReport.set("iscomplete", (Object)Boolean.TRUE);
        taskReport.set("completetime", (Object)date);
        taskReport.set("task", task.getPkValue());
        taskReport.set("percent", (Object)PERCENT_OK);
        taskReport.set("reportdesc", (Object)ResManager.loadKDString((String)"\u4e0b\u7ea7\u5b50\u4efb\u52a1\u90fd\u5b8c\u6210\uff0c\u81ea\u52a8\u66f4\u65b0\u7236\u7ea7\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210\u3002", (String)"ProgressReportOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
        taskReport.set("autocomplete", (Object)DefaultEnum.YES.getValue());
        String name = RequestContext.get().getUserName();
        DynamicObject responsibleperson = task.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
        StringBuilder cooPersonStrs = new StringBuilder();
        cooPersons.forEach(o -> cooPersonStrs.append(o.getString("fbasedataid_id")));
        DynamicObject sharer = task.getDynamicObject("sharer");
        if (null != responsibleperson && StringUtils.equals((CharSequence)responsibleperson.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"ProgressReportOp_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name));
        } else if (null != cooPersons && cooPersons.size() > 0 && new String(cooPersonStrs).contains(userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"ProgressReportOp_9", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name));
        } else if (null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"ProgressReportOp_10", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name));
        } else {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u6279\u91cf\u6807\u6ce8\u4eba\uff09", (String)"ProgressReportOp_11", (String)"pccs-placs-opplugin", (Object[])new Object[0]), name));
        }
        DynamicObjectCollection taskcg = task.getDynamicObjectCollection("taskresultdocentry");
        DynamicObjectCollection taskReportEntry = taskReport.getDynamicObjectCollection("achieveentity");
        if (null != taskcg) {
            long[] ids = DB.genLongIds((String)("t_" + this.getAppId() + "_taskreportdoc"), (int)taskcg.size());
            for (int i = 0; i < taskcg.size(); ++i) {
                DynamicObject cgEntry = new DynamicObject(taskReportEntry.getDynamicObjectType());
                long cgEntryId = ids[i];
                taskReport.getDataEntityType().getPrimaryKey().setValueFast((Object)cgEntry, (Object)cgEntryId);
                cgEntry.set("seq", (Object)(i + 1));
                cgEntry.set("resultname", ((DynamicObject)taskcg.get(i)).get("resultname"));
                cgEntry.set("force", ((DynamicObject)taskcg.get(i)).get("force"));
                cgEntry.set("desc", ((DynamicObject)taskcg.get(i)).get("resultdescription"));
                cgEntry.set("frequency", ((DynamicObject)taskcg.get(i)).get("frequency"));
                cgEntry.set("resultid", ((DynamicObject)taskcg.get(i)).getPkValue());
                taskReportEntry.add(i, cgEntry);
            }
        }
        return taskReport;
    }
}

