/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkHoursBillValidtor
extends AbstractValidator {
    private static final String CANCEL_OP = "cancel";
    private String appID;

    public WorkHoursBillValidtor(String appId) {
        this.appID = appId;
    }

    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)CANCEL_OP)) {
            this.cancelValidate();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
            this.auditValidate();
        }
    }

    protected void auditValidate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        String userId = RequestContext.get().getUserId();
        WorkHoursUtils unit = this.getUtil();
        block0: for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject currentBill = dataEntity.getDataEntity();
            ArrayList<DynamicObject> needCheckBills = new ArrayList<DynamicObject>(10);
            if (WorkHoursUtils.isSourceBill((DynamicObject)currentBill)) {
                Map splitBills = WorkHoursUtils.getSplitBills((String)currentBill.getPkValue().toString(), (String)this.appID);
                if (splitBills != null && splitBills.size() != 0) {
                    splitBills.forEach((k, v) -> needCheckBills.add((DynamicObject)v));
                } else {
                    needCheckBills.add(currentBill);
                }
            } else {
                needCheckBills.add(currentBill);
            }
            for (DynamicObject bill : needCheckBills) {
                boolean isDepartManger;
                boolean hasProjAudit;
                DynamicObject projectObj = bill.getDynamicObject("project");
                if (projectObj != null) {
                    projectObj = BusinessDataServiceHelper.loadSingleFromCache((Object)projectObj.getPkValue(), (String)this.getProjectFormId());
                }
                DynamicObject departObj = bill.getDynamicObject("depart");
                if (projectObj != null && departObj != null) {
                    hasProjAudit = this.hasProjAuditPerm(projectObj, userId);
                    boolean isDepartManger2 = unit.isDeptManager(departObj, userId);
                    if (hasProjAudit || isDepartManger2) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u5de5\u65f6\u5ba1\u6279\u6743\u9650\u3002", (String)"WorkHoursBillValidtor_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]), hasProjAudit ? departObj.get("name") : projectObj.get("name"));
                    this.addErrorMessage(dataEntity, msg);
                    continue block0;
                }
                if (projectObj != null && departObj == null) {
                    hasProjAudit = this.hasProjAuditPerm(projectObj, userId);
                    if (hasProjAudit) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u5de5\u65f6\u5ba1\u6279\u6743\u9650\u3002", (String)"WorkHoursBillValidtor_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]), projectObj.get("name"));
                    this.addErrorMessage(dataEntity, msg);
                    continue block0;
                }
                if (projectObj != null || departObj == null || (isDepartManger = unit.isDeptManager(departObj, userId))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u5de5\u65f6\u5ba1\u6279\u6743\u9650\u3002", (String)"WorkHoursBillValidtor_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]), departObj.get("name"));
                this.addErrorMessage(dataEntity, msg);
                continue block0;
            }
        }
    }

    protected String getProjectFormId() {
        return "bd_project";
    }

    protected boolean hasProjAuditPerm(DynamicObject projectObj, String userId) {
        DynamicObject projDepartment = projectObj.getDynamicObject("department");
        boolean isDeptManager = this.isProjDeptManager(projDepartment, userId);
        return isDeptManager;
    }

    protected boolean isProjDeptManager(DynamicObject projDepartment, String userId) {
        if (projDepartment == null) {
            return false;
        }
        WorkHoursUtils unit = this.getUtil();
        return unit.isDeptManager(projDepartment, userId);
    }

    protected void cancelValidate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            Map<Object, DynamicObject> splitBills;
            DynamicObject bill = dataEntity.getDataEntity();
            String billStatus = bill.getString("billstatus");
            if (!StringUtils.equals((CharSequence)StatusEnum.UNCHECKED.getValue(), (CharSequence)billStatus) && !StringUtils.equals((CharSequence)StatusEnum.CHECKED.getValue(), (CharSequence)billStatus)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5de5\u65f6\u63d0\u4ea4\u5355\u624d\u5141\u8bb8\u53d6\u6d88\uff0c\u5355\u636e\uff1a[%s]", (String)"WorkHoursBillValidtor_5", (String)"pccs-placs-opplugin", (Object[])new Object[0]), bill.get("billno"));
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            if (!this.isSourceBill(bill) || (splitBills = this.getSplitBills(bill.getPkValue().toString())) == null || splitBills.size() == 0) continue;
            HashSet<String> auditingBillNos = new HashSet<String>(splitBills.size());
            for (Map.Entry<Object, DynamicObject> entry : splitBills.entrySet()) {
                DynamicObject splitWorkHoursBill = entry.getValue();
                if (!WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)splitWorkHoursBill.getPkValue()))) continue;
                auditingBillNos.add(splitWorkHoursBill.getString("billno"));
            }
            if (!CollectionUtils.isNotEmpty(auditingBillNos)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355[%s]\u5df2\u7ecf\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u53d6\u6d88\u3002", (String)"WorkHoursBillValidtor_6", (String)"pccs-placs-opplugin", (Object[])new Object[0]), StringUtils.join(auditingBillNos, (String)","));
            this.addErrorMessage(dataEntity, msg);
        }
    }

    protected boolean isSourceBill(DynamicObject workHoursBillObj) {
        return StringUtils.isBlank((CharSequence)workHoursBillObj.getString("oribillid"));
    }

    protected Map<Object, DynamicObject> getSplitBills(String oriBillID) {
        QFilter oriBillFilter = new QFilter("oribillid", "=", (Object)oriBillID);
        return BusinessDataServiceHelper.loadFromCache((String)MetaDataUtil.getEntityId((String)this.appID, (String)"workhours_bill"), (QFilter[])new QFilter[]{oriBillFilter});
    }

    protected WorkHoursUtils getUtil() {
        return new WorkHoursUtils();
    }
}

