/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.WorkHoursListValidator;
import kd.pccs.placs.opplugin.base.BaseOp;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkHoursListOP
extends BaseOp {
    private static final Log logger = LogFactory.getLog(WorkHoursListOP.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey = e.getOperationKey()) {
            case "generateworkhoursbill": {
                for (DynamicObject dataEntity : dataEntities) {
                    this.generateAndSubmitWorkHoursBill(e, dataEntity);
                }
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WorkHoursListValidator(this.getAppId()));
    }

    protected void generateAndSubmitWorkHoursBill(BeginOperationTransactionArgs e, DynamicObject dataEntity) {
        DynamicObjectCollection workHoursListObjList = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject workHoursBillObj = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"));
        workHoursBillObj.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        Date workhoursstarttime = (Date)dataEntity.get("workhoursstarttime");
        workHoursBillObj.set("workhoursstarttime", (Object)workhoursstarttime);
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"worhhours_bill_num"), (DynamicObject)workHoursBillObj, (String)String.valueOf(RequestContext.get().getOrgId()));
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)workHoursBillObj);
        if (StringUtils.isBlank((CharSequence)number)) {
            number = "GSTJ-" + TimeServiceHelper.now().getTime();
        }
        workHoursBillObj.set("billno", (Object)number);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
        workHoursBillObj.set("owner", (Object)user);
        workHoursBillObj.set("creator", (Object)user);
        workHoursBillObj.set("createtime", (Object)TimeServiceHelper.now());
        workHoursBillObj.set("modifier", (Object)TimeServiceHelper.now());
        workHoursBillObj.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection taskWorkHoursBillObjList = workHoursBillObj.getDynamicObjectCollection("taskworkhours");
        List<DynamicObject> canSubmitWorkHoursListObjs = workHoursListObjList.stream().filter(workHoursListObj -> WorkHoursUtils.canSubmit((DynamicObject)workHoursListObj, (Date)workhoursstarttime, (String)this.getAppId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(canSubmitWorkHoursListObjs)) {
            logger.warn(String.format("\u6ca1\u6709\u53ef\u63d0\u4ea4\u7684\u5de5\u65f6,\u5355\u636e\u4e3a:%s", workHoursBillObj.get("billno")));
            return;
        }
        canSubmitWorkHoursListObjs.forEach(workHoursListObj -> {
            DynamicObject taskWorkHoursBillObj = taskWorkHoursBillObjList.addNew();
            DynamicObject task = workHoursListObj.getDynamicObject("task");
            taskWorkHoursBillObj.set("task", (Object)task);
            taskWorkHoursBillObj.set("completionstatus", workHoursListObj.get("completionstatus"));
            taskWorkHoursBillObj.set("majortype", workHoursListObj.get("majortype"));
            for (int i = 1; i <= 7; ++i) {
                taskWorkHoursBillObj.set("day_" + i + "_actual", workHoursListObj.get("day_" + i + "_actual"));
                taskWorkHoursBillObj.set("day_" + i + "_effective", workHoursListObj.get("day_" + i + "_effective"));
            }
            taskWorkHoursBillObj.set("daysum_actual", workHoursListObj.get("daysum_actual"));
            taskWorkHoursBillObj.set("daysum_effective", workHoursListObj.get("daysum_effective"));
        });
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (DynamicObject[])new DynamicObject[]{workHoursBillObj}, (OperateOption)OperateOption.create());
        if (!submitResult.isSuccess()) {
            logger.error(String.format("\u5de5\u65f6\u63d0\u4ea4\u5355\u751f\u6210\u5e76\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25,\u5355\u636e\u4e3a:%s", workHoursBillObj.get("billno")));
        }
    }
}

