/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.WorkHoursGroupEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.WorkHoursBillValidtor;
import kd.pccs.placs.opplugin.base.BaseOp;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class WorkHoursStatusOp
extends BaseOp {
    private static final Log logger = LogFactory.getLog(WorkHoursStatusOp.class);
    private static final String SUBMIT_OP = "submit";
    private static final String AUDIT_OP = "audit";
    private static final String DEL_OP = "delete";
    private static final String CANCEL_OP = "cancel";
    private static final String CANCEL_STATUS = "F";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("oribillid");
        e.getFieldKeys().add("workhoursstarttime");
        e.getFieldKeys().add("taskworkhours");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("depart");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("majortype");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("day_1_effective");
        e.getFieldKeys().add("day_1_actual");
        e.getFieldKeys().add("day_2_actual");
        e.getFieldKeys().add("day_2_effective");
        e.getFieldKeys().add("day_3_actual");
        e.getFieldKeys().add("day_3_effective");
        e.getFieldKeys().add("day_4_actual");
        e.getFieldKeys().add("day_4_effective");
        e.getFieldKeys().add("day_5_actual");
        e.getFieldKeys().add("day_5_effective");
        e.getFieldKeys().add("day_6_actual");
        e.getFieldKeys().add("day_6_effective");
        e.getFieldKeys().add("day_7_actual");
        e.getFieldKeys().add("day_7_effective");
        e.getFieldKeys().add("daysum_actual");
        e.getFieldKeys().add("daysum_effective");
        e.getFieldKeys().add("workhoursstarttime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WorkHoursBillValidtor(this.getAppId()));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "delete": {
                for (DynamicObject dataEntity : dataEntities) {
                    this.delWorkHoursBillMap(dataEntity);
                }
                break;
            }
            case "submit": {
                for (DynamicObject dataEntity : dataEntities) {
                    if (WorkHoursUtils.isSourceBill((DynamicObject)dataEntity)) {
                        this.splitAndSubmitWorkHoursBill(dataEntity);
                        continue;
                    }
                    this.synWorkHoursStatus(dataEntity, StatusEnum.UNCHECKED.getValue());
                }
                break;
            }
            case "audit": {
                for (DynamicObject dataEntity : dataEntities) {
                    if (WorkHoursUtils.isSourceBill((DynamicObject)dataEntity)) {
                        this.doAuditOpSplitBills(dataEntity);
                        continue;
                    }
                    if (WorkHoursUtils.isSingleSplitBill((DynamicObject)dataEntity)) {
                        this.synWorkHoursStatus(dataEntity, StatusEnum.CHECKED.getValue());
                        continue;
                    }
                    this.synWorkHoursStatus(dataEntity, StatusEnum.CHECKED.getValue());
                    this.synOriWorkHoursBillChechdStatus(dataEntity);
                }
                break;
            }
            case "cancel": {
                for (DynamicObject dataEntity : dataEntities) {
                    if (WorkHoursUtils.isSourceBill((DynamicObject)dataEntity)) {
                        this.doCancelOpSplitBill(dataEntity);
                        this.synWorkHoursBillStatus(dataEntity, CANCEL_STATUS);
                        this.delWorkHoursBillMap(dataEntity);
                        continue;
                    }
                    this.synWorkHoursBillStatus(dataEntity, CANCEL_STATUS);
                    this.synWorkHoursStatus(dataEntity, StatusEnum.TEMPSAVE.getValue());
                    this.delWorkHoursBillMap(dataEntity);
                    this.synOriWorkHoursBillCancelStatus(dataEntity);
                }
                break;
            }
        }
    }

    protected void synOriWorkHoursBillCancelStatus(DynamicObject workHoursBillObj) {
        if (StringUtils.isBlank((CharSequence)workHoursBillObj.getString("oribillid"))) {
            return;
        }
        Map<Object, DynamicObject> otherSplitBills = this.getSplitBillsExclude(workHoursBillObj.getString("oribillid"), workHoursBillObj.getPkValue());
        boolean allCancel = true;
        for (Map.Entry<Object, DynamicObject> entry : otherSplitBills.entrySet()) {
            DynamicObject splitWorkHoursBillObj = entry.getValue();
            String billStatus = splitWorkHoursBillObj.getString("billstatus");
            if (StringUtils.equals((CharSequence)CANCEL_STATUS, (CharSequence)billStatus)) continue;
            allCancel = false;
            break;
        }
        if (allCancel) {
            DynamicObject oriWorkHoursBill = this.getWorkHoursBill(workHoursBillObj.getLong("oribillid"));
            if (oriWorkHoursBill == null) {
                return;
            }
            String oriBillStatus = oriWorkHoursBill.getString("billstatus");
            if (!StringUtils.equals((CharSequence)CANCEL_STATUS, (CharSequence)oriBillStatus)) {
                oriWorkHoursBill.set("billstatus", (Object)CANCEL_STATUS);
                SaveServiceHelper.update((DynamicObject)oriWorkHoursBill);
            }
        }
    }

    protected void doCancelOpSplitBill(DynamicObject oriWorkHoursBillObj) {
        Map<Object, DynamicObject> splitBills = this.getSplitBills(oriWorkHoursBillObj.getPkValue().toString());
        if (splitBills == null || splitBills.size() == 0) {
            return;
        }
        for (Map.Entry<Object, DynamicObject> entry : splitBills.entrySet()) {
            DynamicObject workHoursBill = entry.getValue();
            if (StringUtils.equals((CharSequence)CANCEL_STATUS, (CharSequence)workHoursBill.getString("billstatus"))) continue;
            OperationServiceHelper.executeOperate((String)CANCEL_OP, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (DynamicObject[])new DynamicObject[]{workHoursBill}, (OperateOption)OperateOption.create());
        }
    }

    protected void synWorkHoursBillStatus(DynamicObject workHoursBillObj, String status) {
        workHoursBillObj.set("billstatus", (Object)status);
        SaveServiceHelper.update((DynamicObject)workHoursBillObj);
    }

    protected void synOriWorkHoursBillChechdStatus(DynamicObject workHoursBillObj) {
        if (StringUtils.isBlank((CharSequence)workHoursBillObj.getString("oribillid"))) {
            return;
        }
        Map<Object, DynamicObject> otherSplitBills = this.getSplitBillsExclude(workHoursBillObj.getString("oribillid"), workHoursBillObj.getPkValue());
        boolean allCheckd = true;
        for (Map.Entry<Object, DynamicObject> entry : otherSplitBills.entrySet()) {
            DynamicObject splitWorkHoursBillObj = entry.getValue();
            String billStatus = splitWorkHoursBillObj.getString("billstatus");
            if (StringUtils.equals((CharSequence)StatusEnum.CHECKED.getValue(), (CharSequence)billStatus)) continue;
            allCheckd = false;
            break;
        }
        if (allCheckd) {
            DynamicObject oriWorkHoursBill = this.getWorkHoursBill(workHoursBillObj.getLong("oribillid"));
            if (oriWorkHoursBill == null) {
                return;
            }
            String oriBillStatus = oriWorkHoursBill.getString("billstatus");
            if (!StringUtils.equals((CharSequence)StatusEnum.CHECKED.getValue(), (CharSequence)oriBillStatus)) {
                oriWorkHoursBill.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                SaveServiceHelper.update((DynamicObject)oriWorkHoursBill);
            }
        }
    }

    protected void doAuditOpSplitBills(DynamicObject oriWorkHoursBill) {
        Map<Object, DynamicObject> splitBills = this.getSplitBills(oriWorkHoursBill.getPkValue().toString());
        if (splitBills == null || splitBills.size() == 0) {
            return;
        }
        for (Map.Entry<Object, DynamicObject> entry : splitBills.entrySet()) {
            DynamicObject workHoursBill = entry.getValue();
            if (StringUtils.equals((CharSequence)StatusEnum.CHECKED.getValue(), (CharSequence)workHoursBill.getString("billstatus"))) continue;
            OperationServiceHelper.executeOperate((String)AUDIT_OP, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (Object[])new Object[]{workHoursBill.getPkValue()}, (OperateOption)OperateOption.create());
        }
    }

    protected Map<Object, DynamicObject> getSplitBills(String oriBillID) {
        QFilter oriBillFilter = new QFilter("oribillid", "=", (Object)oriBillID);
        return BusinessDataServiceHelper.loadFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (QFilter[])new QFilter[]{oriBillFilter});
    }

    protected Map<Object, DynamicObject> getSplitBillsExclude(Object oriBillID, Object excludeID) {
        QFilter oriBillFilter = new QFilter("oribillid", "=", oriBillID);
        QFilter excludeFilter = new QFilter("id", "<>", excludeID);
        return BusinessDataServiceHelper.loadFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (QFilter[])new QFilter[]{oriBillFilter, excludeFilter});
    }

    protected DynamicObject getWorkHoursBill(Object ID) {
        QFilter idFilter = new QFilter("id", "=", ID);
        return BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (QFilter[])new QFilter[]{idFilter});
    }

    protected void splitAndSubmitWorkHoursBill(DynamicObject dataEntity) {
        DynamicObjectCollection taskWorkHoursObjs = dataEntity.getDynamicObjectCollection("taskworkhours");
        if (CollectionUtils.isEmpty((Collection)taskWorkHoursObjs)) {
            return;
        }
        Map<String, List<DynamicObject>> spiltWorkHoursBillsMap = this.spiltWorkHoursBill(taskWorkHoursObjs);
        if (spiltWorkHoursBillsMap == null || spiltWorkHoursBillsMap.size() == 0) {
            logger.info(String.format("\u62c6\u5206\u5355\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u7ee7\u7eed\u505a\u540e\u7eed\u5904\u7406,\u5355\u636e\u4e3a:%s", dataEntity.get("billno")));
            return;
        }
        if (spiltWorkHoursBillsMap.size() > 1) {
            this.handerSubTask(spiltWorkHoursBillsMap, taskWorkHoursObjs);
        }
        if (spiltWorkHoursBillsMap.size() == 1) {
            String groupKey = spiltWorkHoursBillsMap.entrySet().iterator().next().getKey();
            this.updateSingleOriBill(dataEntity, groupKey);
            this.generateWorkHoursBillMap(dataEntity);
            this.synWorkHoursStatus(dataEntity, StatusEnum.UNCHECKED.getValue());
            SaveServiceHelper.update((DynamicObject)dataEntity);
        } else {
            int seqNo = 1;
            for (Map.Entry<String, List<DynamicObject>> entry : spiltWorkHoursBillsMap.entrySet()) {
                String groupKey = entry.getKey();
                List<DynamicObject> spiltWorkHoursBillEntrys = entry.getValue();
                if (CollectionUtils.isEmpty(spiltWorkHoursBillEntrys)) continue;
                this.handlerSplitWorkHoursBill(dataEntity, groupKey, spiltWorkHoursBillEntrys, seqNo);
                ++seqNo;
            }
        }
    }

    protected void handerSubTask(Map<String, List<DynamicObject>> spiltWorkHoursBillsMap, DynamicObjectCollection taskWorkHoursObjs) {
        List<Object> spiltWorkHoursBillEntrys;
        String groupKey;
        HashMap<String, List<DynamicObject>> subMaps = new HashMap<String, List<DynamicObject>>(spiltWorkHoursBillsMap.size());
        ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>(taskWorkHoursObjs.size());
        for (Map.Entry<String, List<DynamicObject>> entry : spiltWorkHoursBillsMap.entrySet()) {
            List<DynamicObject> subSpiltWorkHoursBillEntrys;
            String groupKey2 = entry.getKey();
            List<DynamicObject> spiltWorkHoursBillEntrys2 = entry.getValue();
            if (CollectionUtils.isEmpty(spiltWorkHoursBillEntrys2) || !groupKey2.startsWith(WorkHoursGroupEnum.GROUP_TRANSACTION.getValue()) && !groupKey2.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue()) || !CollectionUtils.isNotEmpty(subSpiltWorkHoursBillEntrys = this.getSubSpiltWorkHoursBillEntrys(spiltWorkHoursBillEntrys2, taskWorkHoursObjs))) continue;
            subMaps.put(groupKey2, subSpiltWorkHoursBillEntrys);
            subList.addAll(subSpiltWorkHoursBillEntrys);
        }
        if (CollectionUtils.isEmpty(subList)) {
            return;
        }
        List subTaksList = subList.stream().map(o -> {
            DynamicObject taskObj = o.getDynamicObject("task");
            return taskObj.getPkValue();
        }).collect(Collectors.toList());
        for (Map.Entry<String, List<DynamicObject>> entry : spiltWorkHoursBillsMap.entrySet()) {
            groupKey = entry.getKey();
            spiltWorkHoursBillEntrys = entry.getValue();
            List keepList = spiltWorkHoursBillEntrys.stream().filter(o -> {
                DynamicObject taskObj = o.getDynamicObject("task");
                return !subTaksList.contains(taskObj.getPkValue());
            }).collect(Collectors.toList());
            spiltWorkHoursBillsMap.put(groupKey, keepList);
        }
        for (Map.Entry<String, List<DynamicObject>> entry : spiltWorkHoursBillsMap.entrySet()) {
            groupKey = entry.getKey();
            if (!groupKey.startsWith(WorkHoursGroupEnum.GROUP_TRANSACTION.getValue()) && !groupKey.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue())) continue;
            spiltWorkHoursBillEntrys = entry.getValue();
            spiltWorkHoursBillEntrys = spiltWorkHoursBillEntrys == null ? new ArrayList() : spiltWorkHoursBillEntrys;
            List subs = (List)subMaps.get(groupKey);
            if (CollectionUtils.isNotEmpty((Collection)subs)) {
                spiltWorkHoursBillEntrys.addAll(subs);
            }
            spiltWorkHoursBillsMap.put(groupKey, spiltWorkHoursBillEntrys);
        }
        Iterator<Map.Entry<String, List<DynamicObject>>> iterator = spiltWorkHoursBillsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<DynamicObject>> next = iterator.next();
            List<DynamicObject> spiltWorkHoursBillEntrys2 = next.getValue();
            if (!CollectionUtils.isEmpty(spiltWorkHoursBillEntrys2)) continue;
            iterator.remove();
        }
    }

    protected List<DynamicObject> getSubSpiltWorkHoursBillEntrys(List<DynamicObject> spiltWorkHoursBillEntrys, DynamicObjectCollection oriTaskWorkHoursObjs) {
        ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>();
        for (DynamicObject item : spiltWorkHoursBillEntrys) {
            DynamicObject taskObj = item.getDynamicObject("task");
            List<DynamicObject> subTaskObjs = this.getRealSubTaskObjs(taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task")));
            if (CollectionUtils.isEmpty(subTaskObjs)) continue;
            List subTaskObjIds = subTaskObjs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            List subs = oriTaskWorkHoursObjs.stream().filter(obj -> {
                DynamicObject taskObj2 = obj.getDynamicObject("task");
                return subTaskObjIds.contains(taskObj2.getPkValue());
            }).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(subs)) continue;
            subList.addAll(subs);
        }
        return subList;
    }

    protected List<DynamicObject> getRealSubTaskObjs(DynamicObject taskObj) {
        List<DynamicObject> subTaskObjs;
        DynamicObject oriTaskObj = this.getOriTaskObj(taskObj);
        if (oriTaskObj == null) {
            oriTaskObj = taskObj;
        }
        if (CollectionUtils.isEmpty(subTaskObjs = this.getSubTaskObjs(oriTaskObj))) {
            return null;
        }
        List<DynamicObject> sourceLatestTaskObjs = this.getSourceLatestTaskObjs(subTaskObjs);
        return sourceLatestTaskObjs;
    }

    protected List<DynamicObject> getSourceLatestTaskObjs(List<DynamicObject> subTaskObjs) {
        ArrayList<DynamicObject> finalTaskObjs = new ArrayList<DynamicObject>(subTaskObjs.size());
        for (DynamicObject taskOBj : subTaskObjs) {
            boolean isLatest = taskOBj.getBoolean("islatest");
            if (!isLatest) {
                DynamicObject latestTaskObj = this.getLatestTaskObj(taskOBj);
                finalTaskObjs.add(latestTaskObj);
                continue;
            }
            finalTaskObjs.add(taskOBj);
        }
        return finalTaskObjs;
    }

    protected DynamicObject getLatestTaskObj(DynamicObject taskOBj) {
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", taskOBj.getPkValue());
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)1);
        return BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (QFilter[])new QFilter[]{sourceTaskFilter, isLatestFilter});
    }

    protected List<DynamicObject> getSubTaskObjs(DynamicObject taskObj) {
        QFilter parentFilter = new QFilter("parent", "=", taskObj.getPkValue());
        QFilter planTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (QFilter[])new QFilter[]{parentFilter, planTypeFilter});
        if (objectDynamicObjectMap == null || objectDynamicObjectMap.size() == 0) {
            return null;
        }
        return objectDynamicObjectMap.values().stream().collect(Collectors.toList());
    }

    private DynamicObject getOriTaskObj(DynamicObject relationTaskObj) {
        QFilter relationTaskFilter = new QFilter("relationtask", "=", relationTaskObj.getPkValue());
        DynamicObject oriTaskOBj = BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (QFilter[])new QFilter[]{relationTaskFilter});
        return oriTaskOBj;
    }

    protected void updateSingleOriBill(DynamicObject dataEntity, String groupKey) {
        dataEntity.set("oribillid", dataEntity.get("id"));
        DynamicObjectCollection workHoursBillEntrys = dataEntity.getDynamicObjectCollection("taskworkhours");
        if (CollectionUtils.isEmpty((Collection)workHoursBillEntrys)) {
            return;
        }
        DynamicObject taskObj = ((DynamicObject)workHoursBillEntrys.get(0)).getDynamicObject("task");
        taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject projectObj = taskObj.getDynamicObject("project");
        DynamicObject responsibleDeptObj = taskObj.getDynamicObject("responsibledept");
        dataEntity.set("depart", (Object)responsibleDeptObj);
        if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_NODEPT.getValue())) {
            dataEntity.set("project", (Object)projectObj);
        } else if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue())) {
            dataEntity.set("project", (Object)projectObj);
        } else if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PERSON.getValue())) {
            dataEntity.set("project", null);
        }
    }

    protected void generateWorkHoursBillMap(DynamicObject dataEntity) {
        ArrayList<DynamicObject> workhoursBillMapList = new ArrayList<DynamicObject>();
        Date workhoursstarttime = (Date)dataEntity.get("workhoursstarttime");
        DynamicObjectCollection taskWorkHoursBillEntrys = dataEntity.getDynamicObjectCollection("taskworkhours");
        for (DynamicObject taskWorkHoursBillEntry : taskWorkHoursBillEntrys) {
            DynamicObject task = taskWorkHoursBillEntry.getDynamicObject("task");
            for (int i = 1; i <= 7; ++i) {
                Date workdate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)workhoursstarttime), (int)(i - 1));
                DynamicObject workhoursObj = WorkHoursUtils.getWorkhoursObj((Date)(workdate = DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)workdate))), (DynamicObject)task, (String)this.getAppId());
                if (workhoursObj == null || !StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)workhoursObj.getString("status"))) continue;
                DynamicObject workhoursBillMapObj = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_billmap"));
                workhoursBillMapObj.set("workhoursbillid", dataEntity.getPkValue());
                workhoursBillMapObj.set("task", (Object)task);
                workhoursBillMapObj.set("workhours", (Object)workhoursObj);
                workhoursBillMapObj.set("creator", (Object)RequestContext.get().getUserId());
                workhoursBillMapObj.set("createtime", (Object)TimeServiceHelper.now());
                workhoursBillMapObj.set("modifier", (Object)RequestContext.get().getUserId());
                workhoursBillMapObj.set("modifytime", (Object)TimeServiceHelper.now());
                workhoursBillMapList.add(workhoursBillMapObj);
            }
        }
        if (CollectionUtils.isNotEmpty(workhoursBillMapList)) {
            SaveServiceHelper.save((DynamicObject[])workhoursBillMapList.toArray(new DynamicObject[workhoursBillMapList.size()]));
        }
    }

    protected void handlerSplitWorkHoursBill(DynamicObject oriWrokHoursBillObj, String groupKey, List<DynamicObject> spiltWorkHoursBillEntrys, int seqNo) {
        OperationResult submitResult;
        DynamicObject projectObj;
        if (CollectionUtils.isEmpty(spiltWorkHoursBillEntrys)) {
            return;
        }
        DynamicObject workHoursBillObj = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"));
        long workHoursBillObjId = ORM.create().genLongId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"));
        workHoursBillObj.set("id", (Object)workHoursBillObjId);
        workHoursBillObj.set("oribillid", oriWrokHoursBillObj.get("id"));
        workHoursBillObj.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        workHoursBillObj.set("billno", (Object)(oriWrokHoursBillObj.getString("billno") + "-" + seqNo));
        Date workhoursstarttime = oriWrokHoursBillObj.getDate("workhoursstarttime");
        workHoursBillObj.set("workhoursstarttime", (Object)workhoursstarttime);
        workHoursBillObj.set("owner", oriWrokHoursBillObj.get("owner"));
        workHoursBillObj.set("creator", oriWrokHoursBillObj.get("creator"));
        workHoursBillObj.set("createtime", oriWrokHoursBillObj.get("createtime"));
        workHoursBillObj.set("modifier", oriWrokHoursBillObj.get("modifier"));
        workHoursBillObj.set("modifytime", oriWrokHoursBillObj.get("modifytime"));
        DynamicObject taskObj = spiltWorkHoursBillEntrys.get(0).getDynamicObject("task");
        taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_NODEPT.getValue())) {
            projectObj = taskObj.getDynamicObject("project");
            workHoursBillObj.set("project", (Object)projectObj);
        } else if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_TRANSACTION.getValue())) {
            DynamicObject responsibleDeptObj = taskObj.getDynamicObject("responsibledept");
            workHoursBillObj.set("depart", (Object)responsibleDeptObj);
        } else if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue())) {
            projectObj = taskObj.getDynamicObject("project");
            DynamicObject responsibleDeptObj = taskObj.getDynamicObject("responsibledept");
            workHoursBillObj.set("project", (Object)projectObj);
            workHoursBillObj.set("depart", (Object)responsibleDeptObj);
        } else if (groupKey.startsWith(WorkHoursGroupEnum.GROUP_PERSON.getValue())) {
            workHoursBillObj.set("project", null);
            workHoursBillObj.set("depart", null);
        }
        ArrayList workhoursBillMapList = new ArrayList();
        DynamicObjectCollection workHoursBillEntrys = workHoursBillObj.getDynamicObjectCollection("taskworkhours");
        spiltWorkHoursBillEntrys.forEach(workHoursBillEntryItemObj -> {
            DynamicObject workHoursBillEntryObj = workHoursBillEntrys.addNew();
            DynamicObject task = workHoursBillEntryItemObj.getDynamicObject("task");
            workHoursBillEntryObj.set("task", (Object)task);
            workHoursBillEntryObj.set("completionstatus", workHoursBillEntryItemObj.get("completionstatus"));
            workHoursBillEntryObj.set("majortype", workHoursBillEntryItemObj.get("majortype"));
            for (int i = 1; i <= 7; ++i) {
                workHoursBillEntryObj.set("day_" + i + "_actual", workHoursBillEntryItemObj.get("day_" + i + "_actual"));
                workHoursBillEntryObj.set("day_" + i + "_effective", workHoursBillEntryItemObj.get("day_" + i + "_effective"));
                this.generateWorkHoursMap(workHoursBillObjId, i, workhoursstarttime, task, workhoursBillMapList);
            }
            workHoursBillEntryObj.set("daysum_actual", workHoursBillEntryItemObj.get("daysum_actual"));
            workHoursBillEntryObj.set("daysum_effective", workHoursBillEntryItemObj.get("daysum_effective"));
        });
        if (CollectionUtils.isNotEmpty(workhoursBillMapList)) {
            SaveServiceHelper.save((DynamicObject[])workhoursBillMapList.toArray(new DynamicObject[workhoursBillMapList.size()]));
        }
        if (!(submitResult = OperationServiceHelper.executeOperate((String)SUBMIT_OP, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (DynamicObject[])new DynamicObject[]{workHoursBillObj}, (OperateOption)OperateOption.create())).isSuccess()) {
            logger.warn(String.format("\u62c6\u5355\u63d0\u4ea4\u5931\u8d25,\u6e90\u5355\u4e3a:%s", oriWrokHoursBillObj.get("billno")));
        }
    }

    protected void generateWorkHoursMap(long workHoursBillObjId, int i, Date workhoursstarttime, DynamicObject task, List<DynamicObject> workhoursBillMapList) {
        Date workdate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)workhoursstarttime), (int)(i - 1));
        DynamicObject workhoursObj = WorkHoursUtils.getWorkhoursObj((Date)(workdate = DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)workdate))), (DynamicObject)task, (String)this.getAppId());
        if (workhoursObj == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)workhoursObj.getString("status"))) {
            return;
        }
        DynamicObject workhoursBillMapObj = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_billmap"));
        workhoursBillMapObj.set("workhoursbillid", (Object)workHoursBillObjId);
        workhoursBillMapObj.set("task", (Object)task);
        workhoursBillMapObj.set("workhours", (Object)workhoursObj);
        workhoursBillMapObj.set("creator", (Object)RequestContext.get().getUserId());
        workhoursBillMapObj.set("createtime", (Object)TimeServiceHelper.now());
        workhoursBillMapObj.set("modifier", (Object)RequestContext.get().getUserId());
        workhoursBillMapObj.set("modifytime", (Object)TimeServiceHelper.now());
        workhoursBillMapList.add(workhoursBillMapObj);
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, List<DynamicObject>> spiltWorkHoursBill(DynamicObjectCollection taskWorkHoursObjs) {
        List<DynamicObject> person_groups;
        List<DynamicObject> project_dept_groups;
        List<DynamicObject> transaction_groups;
        HashMap<String, List<DynamicObject>> spiltWorkHoursBillsMap = new HashMap<String, List<DynamicObject>>();
        Map<String, List<DynamicObject>> groupMap = taskWorkHoursObjs.stream().collect(Collectors.groupingBy(item -> this.generateGroupKey((DynamicObject)item).getValue()));
        List<DynamicObject> project_nodept_groups = groupMap.get(WorkHoursGroupEnum.GROUP_PROJECT_NODEPT.getValue());
        if (CollectionUtils.isNotEmpty(project_nodept_groups)) {
            Map<Object, List<DynamicObject>> group1Map = project_nodept_groups.stream().collect(Collectors.groupingBy(obj -> {
                DynamicObject taskObj = obj.getDynamicObject("task");
                taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                DynamicObject projectObj = taskObj.getDynamicObject("project");
                return projectObj.getPkValue();
            }));
            int key1Suffix = 0;
            for (Map.Entry<Object, List<DynamicObject>> entry : group1Map.entrySet()) {
                String string = WorkHoursGroupEnum.GROUP_PROJECT_NODEPT.getValue() + key1Suffix;
                spiltWorkHoursBillsMap.put(string, entry.getValue());
                ++key1Suffix;
            }
        }
        if (CollectionUtils.isNotEmpty(transaction_groups = groupMap.get(WorkHoursGroupEnum.GROUP_TRANSACTION.getValue()))) {
            Map<Object, List<DynamicObject>> group2Map = transaction_groups.stream().collect(Collectors.groupingBy(obj -> {
                DynamicObject taskObj = obj.getDynamicObject("task");
                taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                DynamicObject responsibleDeptObj = taskObj.getDynamicObject("responsibledept");
                return responsibleDeptObj.getPkValue();
            }));
            int key2Suffix = 0;
            for (Map.Entry<Object, List<DynamicObject>> entry : group2Map.entrySet()) {
                String key2 = WorkHoursGroupEnum.GROUP_TRANSACTION.getValue() + key2Suffix;
                spiltWorkHoursBillsMap.put(key2, entry.getValue());
                ++key2Suffix;
            }
        }
        if (CollectionUtils.isNotEmpty(project_dept_groups = groupMap.get(WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue()))) {
            Map<Object, List<DynamicObject>> group3Map = project_dept_groups.stream().collect(Collectors.groupingBy(obj -> {
                DynamicObject taskObj = obj.getDynamicObject("task");
                taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                DynamicObject projectObj = taskObj.getDynamicObject("project");
                DynamicObject relationtaskDeptObj = this.getRelationtaskDept(taskObj);
                StringBuilder sb = new StringBuilder();
                sb.append(projectObj.getPkValue().toString());
                sb.append(relationtaskDeptObj.getPkValue());
                return sb.toString();
            }));
            boolean bl = false;
            for (Map.Entry<Object, List<DynamicObject>> entry : group3Map.entrySet()) {
                void var8_15;
                String key2 = WorkHoursGroupEnum.GROUP_PROJECT_DEPT.getValue() + (int)var8_15;
                spiltWorkHoursBillsMap.put(key2, entry.getValue());
                ++var8_15;
            }
        }
        if (CollectionUtils.isNotEmpty(person_groups = groupMap.get(WorkHoursGroupEnum.GROUP_PERSON.getValue()))) {
            spiltWorkHoursBillsMap.put(WorkHoursGroupEnum.GROUP_PERSON.getValue(), person_groups);
        }
        return spiltWorkHoursBillsMap;
    }

    protected WorkHoursGroupEnum generateGroupKey(DynamicObject item) {
        DynamicObject taskObj = item.getDynamicObject("task");
        taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject projectObj = taskObj.getDynamicObject("project");
        DynamicObject responsibleDeptObj = taskObj.getDynamicObject("responsibledept");
        String majortype = item.getString("majortype");
        DynamicObject relationtaskDeptObj = this.getRelationtaskDept(taskObj);
        if (projectObj != null && relationtaskDeptObj == null) {
            return WorkHoursGroupEnum.GROUP_PROJECT_NODEPT;
        }
        if (responsibleDeptObj != null && projectObj == null && !StringUtils.equals((CharSequence)PlanTypeEnum.PRIVATEPLAN.getName(), (CharSequence)majortype)) {
            return WorkHoursGroupEnum.GROUP_TRANSACTION;
        }
        if (projectObj != null && relationtaskDeptObj != null) {
            return WorkHoursGroupEnum.GROUP_PROJECT_DEPT;
        }
        return WorkHoursGroupEnum.GROUP_PERSON;
    }

    protected DynamicObject getRelationtaskDept(DynamicObject taskObj) {
        QFilter relationtaskFilter;
        String plantype;
        DynamicObject belongplantypeObj = taskObj.getDynamicObject("belongplantype");
        String string = plantype = belongplantypeObj != null ? belongplantypeObj.getString("plantype") : null;
        if (StringUtils.equals((CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue(), (CharSequence)plantype)) {
            DynamicObject parenTaskObj = taskObj.getDynamicObject("parent");
            DynamicObject relationTaskObj = parenTaskObj.getDynamicObject("relationtask");
            DynamicObject releationTaskOBj = BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (QFilter[])new QFilter[]{new QFilter("id", "=", relationTaskObj.getPkValue())});
            relationtaskFilter = new QFilter("taskentity.relationtask", "=", releationTaskOBj.getPkValue());
        } else {
            relationtaskFilter = new QFilter("taskentity.relationtask", "=", taskObj.getPkValue());
        }
        DynamicObject deptPlanObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"assigner,billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, planningcycle, timerange, STARTTIME, ENDTIME, name, version, sourceplan, prechangeplan, planstatus, planstatus1", (QFilter[])new QFilter[]{relationtaskFilter});
        if (deptPlanObj == null) {
            return null;
        }
        return deptPlanObj.getDynamicObject("org");
    }

    protected void synWorkHoursStatus(DynamicObject dataEntity, String status) {
        QFilter workhoursbillidFilter = new QFilter("workhoursbillid", "=", (Object)String.valueOf(dataEntity.getPkValue()));
        DynamicObject[] workHoursBillMapObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_billmap"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, workhoursbillid, workhours, task", (QFilter[])new QFilter[]{workhoursbillidFilter});
        if (workHoursBillMapObjs == null || workHoursBillMapObjs.length == 0) {
            return;
        }
        List<DynamicObject> workHoursObjs = Stream.of(workHoursBillMapObjs).map(obj -> {
            DynamicObject workHoursObj = obj.getDynamicObject("workhours");
            workHoursObj = BusinessDataServiceHelper.loadSingleFromCache((Object)workHoursObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"));
            BigDecimal actualHour = workHoursObj.getBigDecimal("actualhour");
            BigDecimal effectiveHour = workHoursObj.getBigDecimal("effectivehour");
            if (actualHour.compareTo(BigDecimal.ZERO) == 0 && effectiveHour.compareTo(BigDecimal.ZERO) == 0) {
                workHoursObj.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            } else {
                workHoursObj.set("status", (Object)status);
            }
            return workHoursObj;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workHoursObjs)) {
            return;
        }
        SaveServiceHelper.update((DynamicObject[])workHoursObjs.toArray(new DynamicObject[workHoursObjs.size()]));
    }

    protected void delWorkHoursBillMap(DynamicObject entity) {
        QFilter workHoursBIllFilter = new QFilter("workhoursbillid", "=", (Object)String.valueOf(entity.getPkValue()));
        DeleteServiceHelper.delete((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_billmap"), (QFilter[])new QFilter[]{workHoursBIllFilter});
    }
}

