/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin.mobile;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.OperateHelper;
import kd.pccs.placs.common.utils.WorkFlowHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class AssignTaskOp
extends BaseOp {
    private static final String assignTaskBillId = "_assigntask";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"save")) {
            boolean processEnable = WorkFlowHelper.getProcessEnable((String)(this.getAppId() + assignTaskBillId));
            boolean addNew = false;
            ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(dataEntities.length);
            int genTaskIdCount = 0;
            for (DynamicObject bill : dataEntities) {
                if (bill.getLong("id") != 0L) continue;
                ++genTaskIdCount;
            }
            long[] genTaskIds = ORM.create().genLongIds(this.getAppId() + assignTaskBillId, genTaskIdCount);
            for (DynamicObject bill : dataEntities) {
                DynamicObjectCollection attachmentPanel;
                DynamicObject taskType;
                DynamicObject task;
                String taskname = bill.getString("taskname");
                Date startTime = bill.getDate("start_time");
                Date endTime = bill.getDate("end_time");
                long taskId = bill.getLong("id");
                DynamicObject rp = bill.getDynamicObject("responsibleperson");
                DynamicObjectCollection mcp = bill.getDynamicObjectCollection("multicooperationperson");
                DynamicObjectCollection mcpDept = bill.getDynamicObjectCollection("cp_dept_bd");
                DynamicObject rpDept = bill.getDynamicObject("rp_dept_bd");
                String content = bill.getString("content");
                if (taskId == 0L) {
                    task = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(this.getAppId() + assignTaskBillId)));
                    taskId = genTaskIds[--genTaskIdCount];
                    addNew = true;
                } else {
                    task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)(this.getAppId() + assignTaskBillId));
                }
                taskIds.add(taskId);
                task.set("id", (Object)taskId);
                task.set("name", (Object)taskname);
                task.set("planstarttime", (Object)startTime);
                task.set("planendtime", (Object)endTime);
                task.set("responsibleperson", (Object)rp);
                if (mcp != null) {
                    task.set("multicooperationperson", (Object)AssignTaskOp.multiCooPersonOrDepts(mcp));
                }
                if (rpDept != null) {
                    task.set("responsibledept", (Object)rpDept);
                }
                if (mcpDept != null) {
                    task.set("multicooperationdept", (Object)AssignTaskOp.multiCooPersonOrDepts(mcpDept));
                }
                if ((taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue())})) != null) {
                    task.set("tasktype", (Object)taskType);
                }
                if ((attachmentPanel = bill.getDynamicObjectCollection("attachmentpanel")) != null && attachmentPanel.size() > 0) {
                    this.toSaveAttachements(attachmentPanel, taskId, this.getAppId() + assignTaskBillId);
                }
                task.set("contentrequirements", (Object)content);
                task.set("isleaf", (Object)DefaultEnum.YES.getValue());
                task.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                task.set("assigner", (Object)RequestContext.get().getUserId());
                QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
                DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
                if (null != taskSource) {
                    task.set("tasksource", taskSource.getPkValue());
                }
                task.set("sourcetask", (Object)task);
                task.set("islatest", (Object)DefaultEnum.YES.getValue());
                task.set("percent", (Object)BigDecimal.ZERO);
                String billStatus = processEnable ? StatusEnum.TEMPSAVE.getValue() : StatusEnum.CHECKED.getValue();
                task.set("billstatus", (Object)billStatus);
                task.set("status", (Object)billStatus);
                task.set("version", (Object)bill.getBigDecimal("version"));
                this.updateTaskCompleteStatus(bill, task);
                this.calAbsoluteTime(startTime, endTime, task);
                tasks.add(task);
            }
            this.riskColorSet(taskIds);
            DynamicObject[] dynamicObjects = new DynamicObject[tasks.size()];
            tasks.toArray(dynamicObjects);
            if (processEnable) {
                OperationResult saveResult = OperateHelper.executeOperate((String)(this.getAppId() + assignTaskBillId), (DynamicObject[])dynamicObjects, (String)"save");
                OperateHelper.submitOperate((String)(this.getAppId() + assignTaskBillId), (OperationResult)saveResult);
            } else if (addNew) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            } else {
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            }
        }
    }

    protected void doUpdateAndSave(DynamicObject[] dataEntities) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        boolean processEnable = WorkFlowHelper.getProcessEnable((String)(this.getAppId() + assignTaskBillId));
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection attachmentPanel;
            DynamicObject taskType;
            String taskname = bill.getString("taskname");
            Date startTime = bill.getDate("start_time");
            Date endTime = bill.getDate("end_time");
            long taskId = bill.getLong("id");
            DynamicObject rp = bill.getDynamicObject("responsibleperson");
            DynamicObjectCollection mcp = bill.getDynamicObjectCollection("multicooperationperson");
            DynamicObjectCollection mcpDept = bill.getDynamicObjectCollection("cp_dept_bd");
            DynamicObject rpDept = bill.getDynamicObject("rp_dept_bd");
            String content = bill.getString("content");
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)(this.getAppId() + assignTaskBillId));
            task.set("name", (Object)taskname);
            task.set("planstarttime", (Object)startTime);
            task.set("planendtime", (Object)endTime);
            task.set("responsibleperson", (Object)rp);
            if (mcp != null) {
                task.set("multicooperationperson", (Object)AssignTaskOp.multiCooPersonOrDepts(mcp));
            }
            if (rpDept != null) {
                task.set("responsibledept", (Object)rpDept);
            }
            if (mcpDept != null) {
                task.set("multicooperationdept", (Object)AssignTaskOp.multiCooPersonOrDepts(mcpDept));
            }
            if ((taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue())})) != null) {
                task.set("tasktype", (Object)taskType);
            }
            if ((attachmentPanel = bill.getDynamicObjectCollection("attachmentpanel")) != null && attachmentPanel.size() > 0) {
                this.toSaveAttachements(attachmentPanel, taskId, this.getAppId() + assignTaskBillId);
            }
            task.set("contentrequirements", (Object)content);
            task.set("isleaf", (Object)DefaultEnum.YES.getValue());
            task.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            task.set("assigner", (Object)RequestContext.get().getUserId());
            QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
            DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
            if (null != taskSource) {
                task.set("tasksource", taskSource.getPkValue());
            }
            task.set("sourcetask", (Object)task);
            task.set("islatest", (Object)DefaultEnum.YES.getValue());
            task.set("percent", (Object)BigDecimal.ZERO);
            String billStatus = processEnable ? StatusEnum.TEMPSAVE.getValue() : StatusEnum.CHECKED.getValue();
            task.set("billstatus", (Object)billStatus);
            task.set("status", (Object)StatusEnum.CHECKED);
            task.set("version", (Object)bill.getBigDecimal("version"));
            this.updateTaskCompleteStatus(bill, task);
            this.calAbsoluteTime(startTime, endTime, task);
            tasks.add(task);
        }
        this.riskColorSet(taskIds);
        DynamicObject[] dynamicObjects = new DynamicObject[tasks.size()];
        tasks.toArray(dynamicObjects);
        if (processEnable) {
            OperationResult saveResult = OperateHelper.executeOperate((String)(this.getAppId() + assignTaskBillId), (DynamicObject[])dynamicObjects, (String)"save");
            OperateHelper.submitOperate((String)(this.getAppId() + assignTaskBillId), (OperationResult)saveResult);
        } else {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    protected static DynamicObjectCollection multiCooPersonOrDepts(DynamicObjectCollection relaCollect) {
        ORM orm = ORM.create();
        DynamicObjectType relaDT = relaCollect.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)relaDT, relaCollect.size());
        DynamicObjectCollection newCollect = new DynamicObjectCollection();
        for (int i = 0; i < relaCollect.size(); ++i) {
            DynamicObject personOrDept = (DynamicObject)relaCollect.get(i);
            DynamicObject newPersonOrDept = new DynamicObject(relaDT);
            newPersonOrDept.set("pkid", (Object)longIds[i]);
            newPersonOrDept.set("fbasedataid", personOrDept.get("fbasedataid"));
            newPersonOrDept.set("fbasedataid_id", personOrDept.get("fbasedataid_id"));
            newCollect.add((Object)newPersonOrDept);
        }
        return newCollect;
    }

    protected void toSaveAttachements(DynamicObjectCollection attachmentEntry, long taskReportId, String entityType) {
        try (TXHandle h = TX.requiresNew();){
            try {
                for (int i = 0; i < attachmentEntry.size(); ++i) {
                    DynamicObject attachment = ((DynamicObject)attachmentEntry.get(i)).getDynamicObject(1);
                    this.toSaveAttachment(attachment, taskReportId, entityType);
                }
            }
            catch (Throwable e1) {
                h.markRollback();
                throw e1;
            }
        }
    }

    protected void toSaveAttachment(DynamicObject attachment, long taskReportId, String entityType) {
        if (attachment == null) {
            return;
        }
        String url = attachment.getString("url");
        String name = attachment.getString("name");
        InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
        FileItem fileItem = new FileItem(name, AssignTaskOp.generateAttPath(name), inputStream);
        fileItem.setCreateNewFileWhenExists(true);
        String fullUrl = FileServiceFactory.getAttachmentFileService().upload(fileItem);
        attachment.set("url", (Object)fullUrl);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynamicObject.set("finterid", (Object)taskReportId);
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel");
        dynamicObject.set("fattachmentname", (Object)attachment.getString("name"));
        dynamicObject.set("fattachmentsize", attachment.get("size"));
        dynamicObject.set("fextname", attachment.get("type"));
        dynamicObject.set("fbilltype", (Object)entityType);
        dynamicObject.set("fnumber", attachment.get("uid"));
        dynamicObject.set("ffileid", attachment.get("url"));
        dynamicObject.set("fcreatetime", (Object)TimeServiceHelper.now());
        dynamicObject.set("fmodifytime", (Object)TimeServiceHelper.now());
        dynamicObject.set("fcreatemen", (Object)RequestContext.get().getUserId());
        dynamicObject.set("fmodifymen", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)"ectc_assigntask_mobile", (String)fileName);
    }

    protected String encodeWithUTF8(String fileName) {
        String utf8FileName = fileName;
        try {
            utf8FileName = URLEncoder.encode(utf8FileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return utf8FileName;
        }
        return utf8FileName;
    }

    protected void updateTaskCompleteStatus(DynamicObject bill, DynamicObject task) {
        Date planStartTime = bill.getDate("start_time");
        Date planEndTime = bill.getDate("end_time");
        Date currentDate = new Date();
        if (DateUtil.compareByDay((Date)planStartTime, (Date)currentDate) > 0) {
            task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        } else if (DateUtil.compareByDay((Date)planEndTime, (Date)currentDate) < 0) {
            task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
        } else {
            task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
        }
    }

    protected void riskColorSet(List<Long> taskIds) {
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(',').append("controllevel").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("tasktype").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        RiskColorUtil.setColor((String)this.getAppId(), (DynamicObject[])tasks, (boolean)true);
        SaveServiceHelper.update((DynamicObject[])tasks);
    }

    protected void calAbsoluteTime(Date planStartTime, Date planEndTime, DynamicObject task) {
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(RequestContext.get().getUserId()));
        if (null != planStartTime && null != planEndTime) {
            BigDecimal absDuration = TaskUtil.getAbsDurationByOrgId((Object)mainOrgId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
            task.set("absoluteduration", (Object)absDuration.add(new BigDecimal(BigInteger.ONE)));
        }
    }
}

