/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin.mobile;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.opplugin.ProgressReportOp;
import org.apache.commons.lang3.StringUtils;

public class ProgressReportMobileOp
extends ProgressReportOp {
    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        long[] genIds = ORM.create().genLongIds(this.getAppId() + "_taskreport", dataEntities.length);
        int idIndex = 0;
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject taskReport = BusinessDataServiceHelper.newDynamicObject((String)(this.getAppId() + "_taskreport"));
            String entityType = taskReport.getDataEntityType().getName();
            long taskReportId = genIds[idIndex++];
            taskReport.set("id", (Object)taskReportId);
            taskReport.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            taskReport.set("createtime", (Object)TimeServiceHelper.now());
            taskReport.set("modifytime", (Object)TimeServiceHelper.now());
            taskReport.set("creator", (Object)RequestContext.get().getUserId());
            taskReport.set("modifier", (Object)RequestContext.get().getUserId());
            String reportDesc = dynamicObject.getString("reportdesc");
            taskReport.set("reportdesc", (Object)reportDesc);
            Date completeTime = dynamicObject.getDate("completetime");
            taskReport.set("completetime", (Object)completeTime);
            DynamicObject task = dynamicObject.getDynamicObject("task");
            taskReport.set("task", (Object)task);
            int percent = dynamicObject.getInt("percent");
            taskReport.set("percent", (Object)percent);
            String huibaoPerson = dynamicObject.getString("huibaoperson");
            taskReport.set("huibaoperson", (Object)huibaoPerson);
            String personType = dynamicObject.getString("persontype");
            taskReport.set("persontype", (Object)personType);
            taskReport.set("latest", (Object)"1");
            taskReport.set("autocomplete", (Object)"0");
            int docEntryNum = dynamicObject.getInt("docentrynum");
            if (docEntryNum == 0) {
                DynamicObjectCollection attachmentPanel = dynamicObject.getDynamicObjectCollection("attachmentpanel");
                if (attachmentPanel != null) {
                    this.toSaveAttachements(attachmentPanel, taskReportId, entityType);
                }
            } else {
                DynamicObjectCollection dynamicObjectCollection = taskReport.getDynamicObjectCollection("achieveentity");
                DynamicObjectCollection achieveEntity = dynamicObject.getDynamicObjectCollection("achieveentity");
                this.saveTempAchieveEntity(achieveEntity);
                for (int i = 0; i < docEntryNum; ++i) {
                    DynamicObject docEntryRow = dynamicObjectCollection.addNew();
                    DynamicObject entityRow = (DynamicObject)achieveEntity.get(i);
                    DynamicObjectCollection attachmentField = entityRow.getDynamicObjectCollection("attachmentfield");
                    docEntryRow.set("attachmentfield", (Object)attachmentField);
                    docEntryRow.set("resultname", (Object)entityRow.getString("resultname"));
                    docEntryRow.set("desc", (Object)entityRow.getString("desc"));
                    docEntryRow.set("force", (Object)entityRow.getString("force"));
                    docEntryRow.set("frequency", (Object)entityRow.getString("frequency"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskReport});
            if (!StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"doreport")) continue;
            this.doAudit(dataEntities);
        }
    }

    protected void saveTempAchieveEntity(DynamicObjectCollection achieveEntity) {
        try (TXHandle h = TX.requiresNew();){
            try {
                for (DynamicObject achieveEntityRow : achieveEntity) {
                    DynamicObjectCollection attachmentEntry = achieveEntityRow.getDynamicObjectCollection("attachmentfield");
                    this.saveTempAttachment(attachmentEntry);
                }
            }
            catch (Throwable e1) {
                h.markRollback();
                throw e1;
            }
        }
    }

    protected void saveTempAttachment(DynamicObjectCollection attachmentEntry) {
        DynamicObject[] dynamicObject = new DynamicObject[attachmentEntry.size()];
        for (int i = 0; i < attachmentEntry.size(); ++i) {
            DynamicObject attachment = ((DynamicObject)attachmentEntry.get(i)).getDynamicObject(1);
            String url = attachment.getString("url");
            String name = attachment.getString("name");
            InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
            FileItem fileItem = new FileItem(name, this.generateAttPath(name), inputStream);
            fileItem.setCreateNewFileWhenExists(true);
            String fullUrl = FileServiceFactory.getAttachmentFileService().upload(fileItem);
            attachment.set("url", (Object)fullUrl);
            attachment.set("status", (Object)"B");
            dynamicObject[i] = attachment;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObject);
    }

    protected String encodeWithUTF8(String fileName) {
        String utf8FileName = fileName;
        try {
            utf8FileName = URLEncoder.encode(utf8FileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return utf8FileName;
        }
        return utf8FileName;
    }

    protected void toSaveAttachements(DynamicObjectCollection attachmentEntry, long taskReportId, String entityType) {
        try (TXHandle h = TX.requiresNew();){
            try {
                for (int i = 0; i < attachmentEntry.size(); ++i) {
                    DynamicObject attachment = ((DynamicObject)attachmentEntry.get(i)).getDynamicObject(1);
                    this.toSaveAttachment(attachment, taskReportId, entityType);
                }
            }
            catch (Throwable e1) {
                h.markRollback();
                throw e1;
            }
        }
    }

    protected void toSaveAttachment(DynamicObject attachment, long taskReportId, String entityType) {
        if (attachment == null) {
            return;
        }
        String url = attachment.getString("url");
        String name = attachment.getString("name");
        InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
        FileItem fileItem = new FileItem(name, this.generateAttPath(name), inputStream);
        fileItem.setCreateNewFileWhenExists(true);
        String fullUrl = FileServiceFactory.getAttachmentFileService().upload(fileItem);
        attachment.set("url", (Object)fullUrl);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynamicObject.set("finterid", (Object)taskReportId);
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel");
        dynamicObject.set("fattachmentname", (Object)attachment.getString("name"));
        dynamicObject.set("fattachmentsize", attachment.get("size"));
        dynamicObject.set("fextname", attachment.get("type"));
        dynamicObject.set("fbilltype", (Object)entityType);
        dynamicObject.set("fnumber", attachment.get("uid"));
        dynamicObject.set("ffileid", attachment.get("url"));
        dynamicObject.set("fcreatetime", (Object)TimeServiceHelper.now());
        dynamicObject.set("fmodifytime", (Object)TimeServiceHelper.now());
        dynamicObject.set("fcreatemen", (Object)RequestContext.get().getUserId());
        dynamicObject.set("fmodifymen", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)(this.getAppId() + "_taskreport_mobile"), (String)fileName);
    }
}

