/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin.tools;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;
import kd.pccs.placs.opplugin.tools.MulitTxType;

public class DataBackupOp
extends BaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        if ("fixtasksource".equals(operateKey)) {
            ArrayList<String> majorTypeValue = new ArrayList<String>();
            majorTypeValue.add(PlanTypeEnum.MAINPLAN.getValue());
            majorTypeValue.add(PlanTypeEnum.DEPTPLAN.getValue());
            majorTypeValue.add(PlanTypeEnum.DEPTFENJIEPLAN.getValue());
            majorTypeValue.add(PlanTypeEnum.PRIVATEPLAN.getValue());
            QFilter qFilter = new QFilter("plantype", "in", majorTypeValue);
            DynamicObject[] majorTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"plantype", (QFilter[])new QFilter[]{qFilter});
            HashMap<String, DynamicObject> majorTypeMap = new HashMap<String, DynamicObject>(majorTypes.length);
            for (DynamicObject majorType : majorTypes) {
                majorTypeMap.put(majorType.getString("plantype"), majorType);
            }
            String properties = String.join((CharSequence)",", "belongplantype", "tasksource", "relationtask", "planid");
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)properties, (QFilter[])new QFilter[0]);
            if (tasks == null || tasks.length == 0) {
                return;
            }
            for (DynamicObject task : tasks) {
                DynamicObject taskSource = task.getDynamicObject("tasksource");
                if (taskSource != null) continue;
                DynamicObject relationTask = task.getDynamicObject("relationtask");
                if (relationTask != null) {
                    DynamicObject relationTask1 = BusinessDataServiceHelper.loadSingle((Object)relationTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"tasksource,belongplantype");
                    DynamicObject taskSource1 = relationTask1.getDynamicObject("tasksource");
                    if (taskSource1 != null) {
                        task.set("tasksource", taskSource1.getPkValue());
                        continue;
                    }
                    DynamicObject planType1 = relationTask1.getDynamicObject("belongplantype");
                    task.set("tasksource", (Object)planType1);
                    continue;
                }
                DynamicObject planType = task.getDynamicObject("belongplantype");
                if (planType != null) {
                    task.set("tasksource", planType.getPkValue());
                    continue;
                }
                Long planId = task.getLong("planid");
                boolean isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (Object)planId);
                if (isExist) {
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"majortype");
                    DynamicObject planType1 = plan.getDynamicObject("majortype");
                    if (planType1 == null) continue;
                    task.set("tasksource", planType1.getPkValue());
                    continue;
                }
                isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (Object)planId);
                if (isExist) {
                    task.set("tasksource", ((DynamicObject)majorTypeMap.get(PlanTypeEnum.DEPTPLAN.getValue())).getPkValue());
                    continue;
                }
                task.set("tasksource", ((DynamicObject)majorTypeMap.get(PlanTypeEnum.PRIVATEPLAN.getValue())).getPkValue());
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        } else if ("synctasksourceandplantype".equals(operateKey)) {
            DynamicObject[] majorTypes;
            for (DynamicObject majorType : majorTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, group, description, plantypename, plantype, issysfield", (QFilter[])new QFilter[0])) {
                Object pk = majorType.getPkValue();
                ILocaleString name = majorType.getLocaleString("name");
                DynamicObject taskSource = new DynamicObject(MetaDataUtil.getDT((String)this.getAppId(), (String)"tasksource"));
                taskSource.set("id", majorType.getPkValue());
                taskSource.set("name", (Object)name);
                taskSource.set("number", (Object)majorType.getString("number"));
                taskSource.set("enable", majorType.get("enable"));
                taskSource.set("status", majorType.get("status"));
                taskSource.set("group", (Object)majorType.getDynamicObject("group"));
                taskSource.set("creator", (Object)majorType.getDynamicObject("creator"));
                taskSource.set("createtime", majorType.get("createtime"));
                taskSource.set("modifier", (Object)majorType.getDynamicObject("modifier"));
                taskSource.set("modifytime", majorType.get("modifytime"));
                boolean isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (Object)pk.toString());
                if (isExist) {
                    SaveServiceHelper.update((DynamicObject)taskSource);
                } else {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskSource});
                }
                DynamicObject planType = new DynamicObject(MetaDataUtil.getDT((String)this.getAppId(), (String)"plantype"));
                planType.set("id", majorType.getPkValue());
                planType.set("name", (Object)name);
                planType.set("number", (Object)majorType.getString("number"));
                planType.set("enable", majorType.get("enable"));
                planType.set("status", majorType.get("status"));
                planType.set("plantype", majorType.get("plantype"));
                planType.set("group", (Object)majorType.getDynamicObject("group"));
                planType.set("creator", (Object)majorType.getDynamicObject("creator"));
                planType.set("modifier", (Object)majorType.getDynamicObject("modifier"));
                planType.set("createtime", majorType.get("createtime"));
                planType.set("modifytime", majorType.get("modifytime"));
                isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (Object)pk.toString());
                if (isExist) {
                    SaveServiceHelper.update((DynamicObject)planType);
                    continue;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planType});
            }
        } else if ("upgradecooperationdata".equals(operateKey)) {
            this.upgradeTaskData();
        } else if ("updatecompletedesc".equals(operateKey)) {
            this.updateCompleteDesc();
        } else if ("updateadjustpretask".equals(operateKey)) {
            this.updateAdjustTask();
        } else if ("updateachievementnodedata".equals(operateKey)) {
            this.updateAchievementNode();
        } else if ("updatemeetassigntaskdata".equals(operateKey)) {
            this.updatemeetassigntaskdata();
        }
    }

    protected void backUpPlanStatusForAssignTask() {
        DynamicObject[] taskArr;
        QFilter typeFilter = null;
        QFilter taskTypeFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id", (QFilter[])new QFilter[]{taskTypeFilter});
        if (null != taskType) {
            typeFilter = new QFilter("tasktype", "=", taskType.getPkValue());
        }
        String selectedProperties = String.join((CharSequence)",", "planstatus", "status", "islatest");
        for (DynamicObject task : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)selectedProperties, (QFilter[])new QFilter[]{typeFilter})) {
            String status = task.getString("status");
            String isLatest = task.getString("islatest");
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
                task.set("planstatus", (Object)PlanEnum.CREATEING.getValue());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
                task.set("planstatus", (Object)PlanEnum.CHECKING.getValue());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)StatusEnum.CHECKED.getValue()) && StringUtils.equals((CharSequence)"true", (CharSequence)isLatest)) {
                task.set("planstatus", (Object)PlanEnum.PUBLISHED.getValue());
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)StatusEnum.CHECKED.getValue()) || !StringUtils.equals((CharSequence)"false", (CharSequence)isLatest)) continue;
            task.set("planstatus", (Object)PlanEnum.HISTORY.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])taskArr);
    }

    protected void updatemeetassigntaskdata() {
        DynamicObject[] assignTask;
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter taskTypeFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id", (QFilter[])new QFilter[]{taskTypeFilter});
        if (null != taskType) {
            filter.and(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        String selectedProperties = String.join((CharSequence)",", "meettask", "tasksource", "tasktype", "belongplantype", "project");
        for (DynamicObject t2 : assignTask = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)selectedProperties, (QFilter[])new QFilter[]{filter})) {
            DynamicObject meettask = t2.getDynamicObject("meettask");
            if (null == meettask) continue;
            t2.set("tasksource", (Object)meettask.getDynamicObject("tasksource"));
            t2.set("tasktype", (Object)meettask.getDynamicObject("tasktype"));
            t2.set("belongplantype", (Object)meettask.getDynamicObject("belongplantype"));
            t2.set("project", (Object)meettask.getDynamicObject("project"));
        }
        SaveServiceHelper.update((DynamicObject[])assignTask);
        DynamicObject[] taskArray = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"meettask", null);
        HashMap meettaskMap = new HashMap();
        Arrays.stream(taskArray).filter(task -> null != task.get("meettask")).forEach(task -> meettaskMap.put(task, task.getDynamicObject("meettask")));
        Set entries = meettaskMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            DynamicObject meettask = (DynamicObject)next.getValue();
            if (!"1".equals(meettask.get("islatest"))) continue;
            iterator.remove();
        }
        List sourceTaskIds = meettaskMap.values().stream().map(o -> o.getDynamicObject("sourcetask").getPkValue()).collect(Collectors.toList());
        QFilter latestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
        QFilter sourceTaskFilter = new QFilter("sourcetask", "in", sourceTaskIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] latestMeetask = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{latestFilter, sourceTaskFilter, statusFilter});
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        for (Map.Entry next : entries) {
            DynamicObject meettask = (DynamicObject)next.getValue();
            for (DynamicObject dynamicObject : latestMeetask) {
                if (meettask.getDynamicObject("sourcetask") == null || dynamicObject.getDynamicObject("sourcetask") == null || !meettask.getDynamicObject("sourcetask").getPkValue().equals(dynamicObject.getDynamicObject("sourcetask").getPkValue())) continue;
                DynamicObject task2 = (DynamicObject)next.getKey();
                task2.set("meettask", (Object)dynamicObject);
                taskList.add(task2);
            }
        }
        SaveServiceHelper.update((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        selectedProperties = String.join((CharSequence)",", "id", "meettask", "meetassigncount");
        DynamicObject[] allCheckedTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)selectedProperties, (QFilter[])new QFilter[]{statusFilter});
        QFilter txTypeFilter = new QFilter("number", "=", (Object)TransactionTypeEnum.MEETING.getValue());
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"), (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        String routeKey = MetaDataUtil.getDT((String)this.getAppId(), (String)"transactiontype").getDBRouteKey();
        String sql = " select fpkid,fentryid,fbasedataid from t_" + this.getAppId() + "_multitxtype where fbasedataid=? ";
        ArrayList<Object> paramsList = new ArrayList<Object>(1);
        List mulitTxTypes = new ArrayList();
        if (txType != null) {
            paramsList.add(txType.getPkValue());
            mulitTxTypes = (List)DB.query((DBRoute)new DBRoute(routeKey), (String)sql, (Object[])paramsList.toArray(new Object[paramsList.size()]), (ResultSetHandler)new ResultSetHandler<List<MulitTxType>>(){

                public List<MulitTxType> handle(ResultSet rs) throws Exception {
                    ArrayList<MulitTxType> result = new ArrayList<MulitTxType>(10);
                    while (rs.next()) {
                        MulitTxType tx = new MulitTxType();
                        tx.setfEntryId(rs.getLong("fentryid"));
                        result.add(tx);
                    }
                    return result;
                }
            });
        }
        List taskIds = mulitTxTypes.stream().map(mt -> mt.getfEntryId()).collect(Collectors.toList());
        for (DynamicObject allCheckedTask : allCheckedTasks) {
            if (!taskIds.contains(allCheckedTask.getPkValue())) continue;
            Object pkValue = allCheckedTask.getPkValue();
            long meetDecisionCount = Arrays.stream(allCheckedTasks).map(t -> t.getDynamicObject("meettask") == null ? Long.valueOf(0L) : t.getDynamicObject("meettask").getPkValue()).filter(t -> pkValue.equals(t)).count();
            allCheckedTask.set("meetassigncount", (Object)meetDecisionCount);
        }
        SaveServiceHelper.update((DynamicObject[])allCheckedTasks);
    }

    protected void updateAchievementNode() {
        DynamicObject[] taskArray = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", null);
        if (taskArray == null || taskArray.length == 0) {
            return;
        }
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])Arrays.stream(taskArray).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        this.upgradeAchievementNodedata(tasks);
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    private void upgradeAchievementNodedata(DynamicObject[] tasks) {
        ORM orm = ORM.create();
        DynamicObjectType multiTxDt = tasks[0].getDynamicObjectCollection("transactiontype").getDynamicObjectType();
        long[] multiTxPkids = orm.genLongIds((IDataEntityType)multiTxDt, tasks.length);
        QFilter filter = new QFilter("number", "=", (Object)TransactionTypeEnum.RESULT.getValue());
        DynamicObject resultTypeBaseData = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"), (String)"", (QFilter[])new QFilter[]{filter});
        for (int index = 0; index < tasks.length; ++index) {
            DynamicObject task = tasks[index];
            String achievementNode = task.getString("achievementnode");
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)achievementNode)) continue;
            DynamicObjectCollection transactionTypes = task.getDynamicObjectCollection("transactiontype");
            boolean isExist = transactionTypes.stream().map(tx -> tx.getLong("fbasedataid_id")).anyMatch(id -> id.equals(resultTypeBaseData.getPkValue()));
            DynamicObject bd = new DynamicObject(multiTxDt);
            if (!isExist) {
                transactionTypes.add((Object)this.initMultiData(bd, multiTxPkids[index], resultTypeBaseData, resultTypeBaseData.getPkValue()));
            }
            task.set("transactiontype", (Object)transactionTypes);
        }
    }

    protected void updateCompleteDesc() {
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        DynamicObject[] taskArray = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"completedescription", (QFilter[])new QFilter[]{latestTaskFilter});
        if (taskArray == null || taskArray.length == 0) {
            return;
        }
        for (DynamicObject task : taskArray) {
            QFilter taskid = new QFilter("task", "=", task.getPkValue());
            QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter latestFilter = new QFilter("latest", "=", (Object)DefaultEnum.YES.getValue());
            QFilter[] filters = new QFilter[]{taskid, taskreportStatus, latestFilter};
            DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"reportdesc", (QFilter[])filters);
            if (taskReportObjs.length != 1) continue;
            task.set("completedescription", (Object)taskReportObjs[0].getString("reportdesc"));
        }
        SaveServiceHelper.save((DynamicObject[])taskArray);
    }

    private void upgradeTaskData() {
        DynamicObject[] taskArray = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", null);
        if (taskArray == null || taskArray.length == 0) {
            return;
        }
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])Arrays.stream(taskArray).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        this.upgradeCooperationData(tasks);
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    private void upgradeCooperationData(DynamicObject[] tasks) {
        ORM orm = ORM.create();
        DynamicObjectType multiPersonDt = tasks[0].getDynamicObjectCollection("multicooperationperson").getDynamicObjectType();
        DynamicObjectType multiDeptDt = tasks[0].getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
        long[] multiPersonPkids = orm.genLongIds((IDataEntityType)multiPersonDt, tasks.length);
        long[] multiDeptPkids = orm.genLongIds((IDataEntityType)multiDeptDt, tasks.length);
        for (int index = 0; index < tasks.length; ++index) {
            DynamicObject task = tasks[index];
            DynamicObject person = task.getDynamicObject("cooperationperson");
            DynamicObjectCollection multiPerson = task.getDynamicObjectCollection("multicooperationperson");
            if (person != null) {
                DynamicObjectCollection persons = new DynamicObjectCollection();
                DynamicObjectType dt = multiPerson.getDynamicObjectType();
                DynamicObject p = new DynamicObject(dt);
                persons.add((Object)this.initMultiData(p, multiPersonPkids[index], person, person.getPkValue()));
                task.set("multicooperationperson", (Object)persons);
            }
            if (person == null && multiPerson.size() > 0) {
                boolean beError = false;
                for (DynamicObject mulPer : multiPerson) {
                    DynamicObject basedata = mulPer.getDynamicObject("fbasedataid");
                    if (basedata != null) continue;
                    beError = true;
                    break;
                }
                if (beError) {
                    task.set("multicooperationperson", null);
                }
            }
            DynamicObject dept = task.getDynamicObject("cooperationdept");
            DynamicObjectCollection multiDept = task.getDynamicObjectCollection("multicooperationdept");
            if (dept != null) {
                DynamicObjectCollection depts = new DynamicObjectCollection();
                DynamicObjectType dt = multiDept.getDynamicObjectType();
                DynamicObject d = new DynamicObject(dt);
                depts.add((Object)this.initMultiData(d, multiDeptPkids[index], dept, dept.getPkValue()));
                task.set("multicooperationdept", (Object)depts);
            }
            if (dept != null || multiDept.size() <= 0) continue;
            boolean beError = false;
            for (DynamicObject mulDept : multiDept) {
                DynamicObject basedata = mulDept.getDynamicObject("fbasedataid");
                if (basedata != null) continue;
                beError = true;
                break;
            }
            if (!beError) continue;
            task.set("multicooperationdept", null);
        }
    }

    private DynamicObject initMultiData(DynamicObject entity, Object pkId, Object basedata, Object basedataId) {
        entity.set("pkid", pkId);
        entity.set("fbasedataid", basedata);
        entity.set("fbasedataid_id", basedataId);
        return entity;
    }

    private void updateAdjustTask() {
        DynamicObject[] latestPreTask;
        QFilter filter = new QFilter("relationtask", "=", (Object)0L);
        filter.and("islatest", "=", (Object)"1");
        filter.and("pretask", "!=", (Object)0L);
        DynamicObject[] taskHasPre = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"islatest,pretask", (QFilter[])filter.toArray());
        HashMap pre2Task = new HashMap();
        for (DynamicObject task2 : taskHasPre) {
            if (!pre2Task.containsKey(task2.getDynamicObject("pretask").getPkValue().toString())) {
                pre2Task.put(task2.getDynamicObject("pretask").getPkValue().toString(), new ArrayList());
            }
            ((List)pre2Task.get(task2.getDynamicObject("pretask").getPkValue().toString())).add(task2);
        }
        ArrayList preIds = new ArrayList();
        Arrays.stream(taskHasPre).forEach(task -> preIds.add(task.getDynamicObject("pretask").getPkValue()));
        filter = new QFilter("relationtask", "=", (Object)0L);
        filter.and("islatest", "=", (Object)"0");
        filter.and("id", "in", preIds);
        DynamicObject[] preTask = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask", (QFilter[])filter.toArray());
        if (preTask.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u65e0\u9700\u4fee\u590d\u3002", (String)"DataBackupOp_1", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
        }
        ArrayList sourceTaskIds = new ArrayList();
        Arrays.stream(preTask).forEach(task -> sourceTaskIds.add(task.getDynamicObject("sourcetask").getPkValue().toString()));
        filter = new QFilter("sourcetask", "in", sourceTaskIds);
        filter.and("islatest", "=", (Object)"1");
        HashMap<String, DynamicObject> change2Latest = new HashMap<String, DynamicObject>(10);
        for (DynamicObject task3 : latestPreTask = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask,prechangetask", (QFilter[])filter.toArray())) {
            change2Latest.put(task3.getDynamicObject("prechangetask").getPkValue().toString(), task3);
        }
        for (DynamicObject task3 : preTask) {
            DynamicObject latestPre = (DynamicObject)change2Latest.get(task3.getPkValue().toString());
            List repairTask = (List)pre2Task.get(task3.getPkValue().toString());
            for (DynamicObject repair : repairTask) {
                repair.set("pretask", (Object)latestPre);
            }
            SaveServiceHelper.update((DynamicObject[])repairTask.toArray(new DynamicObject[0]));
        }
    }
}

