/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.utils.task.FileAttachmentHelper;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.permission.PermServiceHelper;

public class AssignTaskEditPlugin
extends AbstractPlacsBillAdapter
implements BeforeF7SelectListener,
UploadListener,
TabSelectListener,
RowClickEventListener {
    private static final String PARENTID = "parentBillId";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String RESULTDOCCONTROL = "advconap1";

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        switch (key = e.getProperty().getName()) {
            case "planstarttime": {
                this.checkInputTime("planstarttime");
                this.calAbsoluteTime();
                break;
            }
            case "planendtime": {
                this.checkInputTime("planendtime");
                this.calAbsoluteTime();
                break;
            }
            case "responsibleperson": {
                this.checkResponsiblePerson("responsibleperson");
                break;
            }
            case "multicooperationperson": {
                this.checkResponsiblePerson("multicooperationperson");
                break;
            }
            case "transactiontype": {
                this.deleteResultDocEntry();
                this.setTransactionEntryEnable();
                break;
            }
            case "project": {
                this.dealControllevel();
                break;
            }
        }
    }

    protected void dealControllevel() {
        if (null != this.getModel().getValue("project")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"controllevel"});
            BasedataEdit bd = (BasedataEdit)this.getControl("controllevel");
            bd.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"controllevel"});
            BasedataEdit bd = (BasedataEdit)this.getControl("controllevel");
            bd.setMustInput(false);
        }
    }

    protected void deleteResultDocEntry() {
        Object trans = this.getModel().getValue("transactiontype");
        if (!this.containSpecifyType(trans, TransactionTypeEnum.RESULT.getValue())) {
            this.getModel().deleteEntryData("taskresultdocentry");
        }
    }

    protected void setTransactionEntryEnable() {
        Object trans = this.getModel().getValue("transactiontype");
        if (this.containSpecifyType(trans, TransactionTypeEnum.RESULT.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{RESULTDOCCONTROL});
            this.getView().setVisible(Boolean.TRUE, new String[]{RESULTDOCCONTROL});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{RESULTDOCCONTROL});
            this.getView().setVisible(Boolean.FALSE, new String[]{RESULTDOCCONTROL});
        }
    }

    protected void doCheckTime(ChangeData changeSet, String changeField) {
        try {
            this.checkInputTime(changeField);
        }
        catch (Exception e) {
            Date oldValue = (Date)changeSet.getOldValue();
            this.getModel().setValue(changeField, (Object)oldValue);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void checkResponsiblePerson(String operateKey) {
        IDataModel model = this.getModel();
        DynamicObject responsiblePerson = (DynamicObject)model.getValue("responsibleperson");
        DynamicObjectCollection cooperationPersons = (DynamicObjectCollection)model.getValue("multicooperationperson");
        MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPersons);
        if (responsiblePerson != null && "responsibleperson".equalsIgnoreCase(operateKey)) {
            long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePerson.getPkValue().toString()));
            this.getModel().setValue("responsibledept", (Object)orgId);
        } else if ("multicooperationperson".equalsIgnoreCase(operateKey)) {
            MultiCooperationPersonUtils.writeCodeptsByCoPersons((DynamicObjectCollection)cooperationPersons, (IDataModel)this.getModel(), (int)-1);
        }
    }

    protected void calAbsoluteTime() {
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(RequestContext.get().getUserId()));
        Date planStartTime = (Date)this.getModel().getValue("planstarttime");
        Date planEndTime = (Date)this.getModel().getValue("planendtime");
        if (null != planStartTime && null != planEndTime) {
            BigDecimal absDuration = TaskUtil.getAbsDurationByOrgId((Object)mainOrgId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
            this.getModel().setValue("absoluteduration", (Object)absDuration.add(new BigDecimal(BigInteger.ONE)));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit meettask = (BasedataEdit)this.getControl("meettask");
        meettask.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)this.viewDetail(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected BillShowParameter viewDetail(String formBillId, Object pkId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formBillId);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(bill.getPkValue());
        showParameter.setFormId(formBillId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    protected void checkInputTime(String changeField) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime");
        Date planEndTime = (Date)this.getModel().getValue("planendtime");
        if ("planstarttime".equals(changeField)) {
            if (planStartTime == null) {
                return;
            }
            if (planEndTime != null && planStartTime.after(planEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4\u3002", (String)"AssignTaskEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("planendtime".equals(changeField)) {
            if (planEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(planEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"AssignTaskEditPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DateUtil.compareByDay((Date)planEndTime, (Date)new Date()) <= -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"AssignTaskEditPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        Object parentBillId = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        IDataModel curTask = this.getModel();
        if (isCopy != null && isCopy.booleanValue() && null != parentBillId) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            BigDecimal version = (BigDecimal)this.getModel().getValue("version");
            BigDecimal newVersion = version.add(BigDecimal.ONE);
            curTask.setValue("version", (Object)newVersion);
            String sourceBillFormId = this.getView().getFormShowParameter().getFormId();
            Object sourceBillId = parentBillId;
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
            DynamicObject oldTask = BusinessDataServiceHelper.loadSingle((Object)parentBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            curTask.setValue("prechangetask", (Object)oldTask);
            DynamicObject oldSourceTask = oldTask.getDynamicObject("sourcetask");
            if (null != oldSourceTask) {
                curTask.setValue("sourcetask", (Object)oldSourceTask);
            } else {
                curTask.setValue("sourcetask", (Object)oldTask);
            }
            curTask.setValue("Billno", oldTask.get("Billno"));
            curTask.setValue("status", (Object)StatusEnum.TEMPSAVE.getValue());
            curTask.setValue("islatest", (Object)DefaultEnum.NO.getValue());
            this.getView().invokeOperation("save");
            this.getModel().updateCache();
        }
    }

    public void afterBindData(EventObject e) {
        BigDecimal version;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"controllevel"});
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        Object taskId = customMap.get("taskId");
        if (null != taskId) {
            DynamicObject meetTask = BusinessDataServiceHelper.loadSingle((Object)((Long)taskId), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            this.getModel().setValue("meettask", (Object)meetTask);
        }
        if ((version = (BigDecimal)this.getModel().getValue("version")).intValue() > 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assigner"});
        }
        Object transactionType = this.getModel().getValue("transactiontype");
        this.hideResultdocapByTransactionType(transactionType);
    }

    protected boolean containSpecifyType(Object transactionType, String number) {
        if (null != transactionType) {
            DynamicObjectCollection transactionTypeCollections = (DynamicObjectCollection)transactionType;
            for (DynamicObject tx : transactionTypeCollections) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(number, txType.get("number"))) continue;
                return true;
            }
        }
        return false;
    }

    private void hideResultdocapByTransactionType(Object transactionType) {
        if (this.containSpecifyType(transactionType, TransactionTypeEnum.RESULT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{RESULTDOCCONTROL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{RESULTDOCCONTROL});
        }
    }

    public void tabSelected(TabSelectEvent evt) {
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName = arg.getProperty().getName();
        if ("project".equals(propName)) {
            arg.setCustomQFilters(this.setProjectListFilter().getQFilters());
        }
    }

    protected List<Long> getAllPermOrgs() {
        return PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)this.getView().getEntityId(), (String)"view");
    }

    protected ListFilterParameter setProjectListFilter() {
        ListFilterParameter filterParameter = new ListFilterParameter();
        return filterParameter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (key = operate.getOperateKey()) {
            case "audit": {
                this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
                this.getView().updateView("assigner");
                break;
            }
        }
    }
}

