/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;

public class AssignTaskListPlugin
extends AbstractPlacsListPlugin {
    private static final String PARENTID = "parentBillId";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject meettask;
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        ListView view = (ListView)this.getView();
        Object focusRowPkId = view.getFocusRowPkId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"percent")) {
            QFilter taskid = new QFilter("task", "=", focusRowPkId);
            QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
            DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
            if (taskReportObjs.length == 0) {
                DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                int percent = taskObj.getInt("percent");
                if (percent == 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"AssignTaskListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject sourceTask = taskObj.getDynamicObject("sourcetask");
                if (sourceTask != null) {
                    QFilter sameSourceTaskFilter = new QFilter("sourcetask", "=", (Object)sourceTask.getPkValue().toString());
                    QFilter taskStatus = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] sameSourceTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", (QFilter[])new QFilter[]{sameSourceTaskFilter, taskStatus});
                    if (sameSourceTasks == null || sameSourceTasks.length == 0) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"AssignTaskListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ArrayList<String> taskIds = new ArrayList<String>(sameSourceTasks.length);
                    for (DynamicObject task : sameSourceTasks) {
                        taskIds.add(task.getPkValue().toString());
                    }
                    taskid = new QFilter("task", "in", taskIds);
                    taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])new QFilter[]{taskid, taskreportStatus}, (String)"auditdate desc", (int)1);
                    if (null == taskReportObjs || taskReportObjs.length == 0) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"AssignTaskListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"AssignTaskListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
            map.put("pkId", taskReportObjs[0].getPkValue().toString());
            map.put("taskId", focusRowPkId);
            map.put("viewPercent", focusRowPkId);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meettask_name") && null != (meettask = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task")).getDynamicObject("meettask"))) {
            map.clear();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", meettask.getPkValue().toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", focusRowPkId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filterList = e.getQFilters();
        Optional<QFilter> colorFilter = filterList.stream().filter(qFilter -> StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"riskcolor")).findFirst();
        colorFilter.ifPresent(filter -> {
            Object riskColor = filter.getValue();
            if (riskColor instanceof List) {
                Optional<Object> nonColor = ((List)riskColor).stream().filter(o -> Objects.equals(o, RiskColorEnum.NOCOLOR.getValue())).findAny();
                if (nonColor.isPresent()) {
                    filterList.remove(colorFilter.get());
                    List colors = Stream.of(RiskColorEnum.values()).filter(riskColorEnum -> !StringUtils.equalsIgnoreCase((CharSequence)RiskColorEnum.NOCOLOR.getValue(), (CharSequence)riskColorEnum.getValue())).map(colorEnum -> colorEnum.getValue()).collect(Collectors.toList());
                    QFilter cQfilter = new QFilter("riskcolor", "not in", colors);
                    List selectedColors = ((List)riskColor).stream().filter(o -> !Objects.equals(o, RiskColorEnum.NOCOLOR.getValue())).collect(Collectors.toList());
                    cQfilter.or(new QFilter("riskcolor", "in", selectedColors));
                    filterList.add(cQfilter);
                }
            } else if (Objects.equals(riskColor, RiskColorEnum.NOCOLOR.getValue())) {
                filterList.remove(colorFilter.get());
                List colors = Stream.of(RiskColorEnum.values()).filter(riskColorEnum -> !StringUtils.equalsIgnoreCase((CharSequence)RiskColorEnum.NOCOLOR.getValue(), (CharSequence)riskColorEnum.getValue())).map(colorEnum -> colorEnum.getValue()).collect(Collectors.toList());
                QFilter cQfilter = new QFilter("riskcolor", "not in", colors);
                filterList.add(cQfilter);
            }
        });
        QFilter creatoFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        filterList.add(creatoFilter);
        QFilter taskTypeFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id", (QFilter[])new QFilter[]{taskTypeFilter});
        if (null != taskType) {
            filterList.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
        if (null != taskSource) {
            filterList.add(new QFilter("tasksource", "=", taskSource.getPkValue()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "doadjust": {
                ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                if (row == null || ((ListView)this.getView()).getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"AssignTaskListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object id = row.getPrimaryKeyValue();
                if (null == id) break;
                DynamicObject curTask = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"billstatus,percent");
                if (curTask == null) {
                    return;
                }
                if (!"C".equals(curTask.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8c03\u6574\u5df2\u5ba1\u6838\u7684\u4efb\u52a1\u3002", (String)"AssignTaskListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (curTask.getBigDecimal("percent").intValue() == 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\u3002\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"AssignTaskListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("prechangetask", "=", id)};
                DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"Billno", (QFilter[])filters);
                if (tasks == null || tasks.length < 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u65b0\u7684\u4efb\u52a1\u7248\u672c\u8fdb\u884c\u8c03\u6574\u3002", (String)"AssignTaskListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "doadjust": {
                this.getView().invokeOperation("copy");
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        IListView listView = (IListView)this.getView();
        ListSelectedRow row = listView.getCurrentSelectedRowInfo();
        if (null != row && null != isCopy && isCopy.booleanValue()) {
            Object selectRowPk = row.getPrimaryKeyValue();
            e.getParameter().setCustomParam(PARENTID, selectRowPk);
        }
    }
}

