/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;

public class BatchModifyEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("directperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("directorg");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationPerson = (MulBasedataEdit)this.getControl("multicooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationDept = (MulBasedataEdit)this.getControl("multicooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        switch (key = e.getProperty().getName()) {
            case "multicooperationperson": {
                DynamicObjectCollection cooperationPersons = (DynamicObjectCollection)changeData.getNewValue();
                if (cooperationPersons == null || cooperationPersons.size() <= 0) break;
                DynamicObject responsiblePerson = (DynamicObject)this.getModel().getValue("directperson");
                MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPersons);
                MultiCooperationPersonUtils.writeCodeptsByCoPersons((DynamicObjectCollection)cooperationPersons, (IDataModel)this.getModel(), (int)-1);
                break;
            }
            case "directperson": {
                DynamicObject responsiblePerson = (DynamicObject)changeData.getNewValue();
                if (responsiblePerson == null) break;
                DynamicObjectCollection cooperationPersons = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson");
                MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPersons);
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePerson.getPkValue().toString()));
                this.getModel().setValue("directorg", (Object)orgId);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String key = operate.getOperateKey();
        if ("comfirm".equals(key)) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            DynamicObject directPerson = (DynamicObject)this.getModel().getValue("directperson");
            DynamicObject directOrg = (DynamicObject)this.getModel().getValue("directorg");
            DynamicObjectCollection indirectPerson = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson");
            DynamicObjectCollection indirectOrg = (DynamicObjectCollection)this.getModel().getValue("multicooperationdept");
            if (directPerson != null) {
                dataMap.put("directperson", directPerson.getPkValue().toString());
            }
            if (directOrg != null) {
                dataMap.put("directorg", directOrg.getPkValue().toString());
            }
            if (indirectPerson != null && indirectPerson.size() > 0) {
                dataMap.put("multicooperationperson", indirectPerson.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
            if (indirectOrg != null && indirectOrg.size() > 0) {
                dataMap.put("multicooperationdept", indirectOrg.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
            if (dataMap.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8d23\u4efb\u4eba\u201d\u3001\u201c\u8d23\u4efb\u90e8\u95e8\u201d\u3002", (String)"BatchModifyEditPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "directperson": {
                DynamicObject responsibleDept = (DynamicObject)model.getValue("directorg");
                if (responsibleDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(responsibleDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "directorg": {
                DynamicObject responsiblePreson = (DynamicObject)model.getValue("directperson");
                if (responsiblePreson == null) break;
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsiblePreson.getPkValue().toString()), (boolean)false);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "multicooperationperson": {
                DynamicObjectCollection cooperationDepts = (DynamicObjectCollection)model.getValue("multicooperationdept");
                if (cooperationDepts == null || cooperationDepts.size() <= 0) break;
                List userIds = MultiCooperationPersonUtils.getAllCopersonIdsByCodepts((DynamicObjectCollection)cooperationDepts);
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "multicooperationdept": {
                DynamicObjectCollection cooperationPersons = (DynamicObjectCollection)model.getValue("multicooperationperson");
                if (cooperationPersons == null || cooperationPersons.size() <= 0) break;
                List deptIds = MultiCooperationPersonUtils.getMultiAllOrgIdsByCopersons((DynamicObjectCollection)cooperationPersons);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
        }
    }
}

