/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.tree.DynamicObjectTreeNode;
import kd.pccs.placs.common.utils.tree.Hierarchy;
import kd.pccs.placs.common.utils.tree.OrgProjectTreeHelper;
import kd.pccs.placs.formplugin.OrgProjectTreeDeptListPlugin;

public class DeptImportListPlugin
extends OrgProjectTreeDeptListPlugin {
    private static final Log logger = LogFactory.getLog(DeptImportListPlugin.class);

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void initializeTree(EventObject e) {
        Object source = e.getSource();
        if (source instanceof BillList) {
            return;
        }
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (customMap.get("deptid") != null) {
            Long deptId = Long.valueOf(customMap.get("deptid").toString());
            DynamicObject[] projs = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)deptId)});
            ArrayList<String> proIds = new ArrayList<String>(projs.length);
            for (DynamicObject proj : projs) {
                proIds.add(proj.getPkValue().toString());
            }
            OrgProjectTreeHelper helper = this.getHelper();
            Hierarchy tree = helper.initProjectNavTree(this.getTreeListView().getTreeView(), deptId, false, proIds);
            if (tree != null) {
                DynamicObjectTreeNode node = (DynamicObjectTreeNode)tree.getRootNode();
                TreeNode root = node.getTreeNode();
                this.getTreeModel().setRoot(root);
                TreeView treeView = this.getTreeListView().getTreeView();
                treeView.focusNode(root);
                treeView.treeNodeClick(null, root.getId());
            }
            this.getPageCache().put("orgproject_tree_key", SerializeHelper.serialize((Object)tree));
        }
    }

    @Override
    public OrgProjectTreeHelper getHelper() {
        return new OrgProjectTreeHelper();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusProject = treeState.getFocusNode();
        if (null != focusProject && this.isProjectNode(focusProject)) {
            ArrayList<String> proIds = new ArrayList<String>(10);
            proIds.add(focusProject.get("id").toString());
            this.addTreeFilterByNode(e, proIds);
        } else if (null != focusProject) {
            String orgId = focusProject.get("id").toString();
            DynamicObject[] projs = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            ArrayList<String> proIds = new ArrayList<String>(projs.length);
            for (DynamicObject proj : projs) {
                proIds.add(proj.getPkValue().toString());
            }
            this.addTreeFilterByNode(e, proIds);
        }
        e.setCancel(true);
    }

    private void addTreeFilterByNode(BuildTreeListFilterEvent e, List<String> proIds) {
        QFilter taskFilter;
        QFilter qFilter = new QFilter("project", "in", proIds);
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        DynamicObject[] projectPlans = BusinessDataServiceHelper.load((String)(this.getAppId() + "_" + "masterplan"), (String)"taskentity,taskid", (QFilter[])new QFilter[]{qFilter, statusFilter});
        ArrayList<Object> taskIds = new ArrayList<Object>(10);
        for (DynamicObject projectPlan : projectPlans) {
            DynamicObjectCollection taskEntrys = projectPlan.getDynamicObjectCollection("taskentity");
            for (DynamicObject taskEntry : taskEntrys) {
                taskIds.add(taskEntry.getPkValue());
            }
        }
        if (!taskIds.isEmpty()) {
            taskFilter = new QFilter("id", "in", taskIds).and(qFilter);
            e.addQFilter(taskFilter);
        } else {
            taskFilter = new QFilter("id", "=", (Object)0);
            e.addQFilter(taskFilter);
        }
    }

    protected boolean isProjectNode(Map<String, Object> focusProject) {
        Object nodeId = focusProject.get("id");
        DynamicObject project = null;
        try {
            project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)this.getProjectFormId());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return project != null;
    }
}

