/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.task.DealWithEntryDataUtils;
import kd.pccs.placs.business.utils.task.DeptPlanTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.DeptTaskUtil;
import kd.pccs.placs.business.utils.task.FileAttachmentHelper;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.PlanTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.business.utils.task.TreeEntryUtils;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.PlanningCycleEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;
import kd.pccs.placs.formplugin.helper.TreeEntryGridHelper;

public class DeptPlanBillPlugin
extends AbstractPlacsBillPlugin
implements BeforeF7SelectListener,
TabSelectListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(DeptPlanBillPlugin.class);
    private static final String TREEENTRY_PID = "pid";
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String FORM_ID = "formId";
    private static final String XIEBANTABPAGEAP = "xiebantabpageap";
    private static final String ID_PLANTYPE_PLANTYPENAME = "id,plantype,plantypename";
    private static final String TOTALTABPAGEAP = "totaltabpageap";
    private static final String VERSION = "version";
    private static final String IMPORTPROJECTTASK = "importprojecttask";
    private static final String SWITCH_PLANNINGCYCLE = "switchPlanningcycle";
    private static final String BROTHER_INDEX = "brotherIndex";
    private static final String PARENT_INDEX = "parentIndex";
    private static final String SWITCH_ORG = "switchOrg";
    private static final String SWITCH_TIMERANGE = "switchTimerange";
    private static final String ZHUZETABPAGEAP = "zhuzetabpageap";
    private static final String UPDATEENTRY = "updateentry";
    private static final String PARENTID = "parentBillId";
    private static final String INVOKEOPER = "invokeOper";
    private static final String ISPROPERTYCHANGED = "isPropertyChanged";
    private static final String MAIN = "ma";
    private static final String ASS = "ass";
    private static final int MAX_LEVEL = 6;
    private static final int TAB_SIZE = 1;
    private static final String LEVEL = "level";
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.modifyPerson();
    }

    protected void modifyPerson() {
        if (null != this.getModel().getValue("creator")) {
            this.getModel().setValue("modifier", this.getModel().getValue("creator"));
        }
        if (null != this.getModel().getValue("createtime")) {
            this.getModel().setValue("modifytime", this.getModel().getValue("createtime"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("respersontx");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("resdepttx");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationPerson = (MulBasedataEdit)this.getControl("multicooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationDept = (MulBasedataEdit)this.getControl("multicooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("taskentity");
        taskEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit tasktype = (BasedataEdit)this.getControl("tasktype");
        tasktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.levelLableAddListener(6, 1);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("taskentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"DeptPlanBillPlugin_95", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object taskId = this.getModel().getEntryRowEntity("taskentity", rowIndex).getPkValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", taskId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
        }
    }

    protected void levelLableAddListener(int maxLevel, int tabSize) {
        for (int i = 1; i <= maxLevel * tabSize; ++i) {
            Label level = (Label)this.getControl("level_" + i);
            level.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String treeEntityKey = "";
        if (key.contains(LEVEL)) {
            int level = Integer.parseInt(key.split("_")[1]);
            if (level <= 6 && level > 0) {
                treeEntityKey = "taskentity";
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeEntityKey);
            Map all = this.getPageCache().getAll();
            all.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("@taskId")).forEach(entry -> this.taskLevelMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("@taskId")), Integer.valueOf((String)entry.getValue())));
            level = this.getOriginLevel(level);
            TreeEntryGridHelper.expandNodes(treeEntryGrid, "id", level, this.taskLevelMap);
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7ec4\u7ec7\u3002", (String)"DeptPlanBillPlugin_74", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String key = arg0.getTabKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)ZHUZETABPAGEAP)) {
            this.mainDutyTabSelected(org);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)XIEBANTABPAGEAP)) {
            this.assistantTaskTabSelected(org);
        }
    }

    protected void assistantTaskTabSelected(DynamicObject org) {
        this.getModel().deleteEntryData("entryentity2");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject taskEntry : entries) {
            DynamicObjectCollection coopDepts = taskEntry.getDynamicObjectCollection("multicooperationdept");
            ArrayList coopDeptIds = new ArrayList();
            coopDepts.stream().map(o -> coopDeptIds.add(o.getLong("fbasedataid_id"))).count();
            if (coopDepts.size() <= 0 || !coopDeptIds.contains(org.getPkValue())) continue;
            int rowIndex = this.getModel().createNewEntryRow("entryentity2");
            this.setTaskTabByEntry(taskEntry, rowIndex, ASS);
            this.updateTimeDeviationColor("asstasktimepctx", "entryentity2", rowIndex);
        }
        this.modifyTabName(XIEBANTABPAGEAP, "entryentity2");
    }

    protected void mainDutyTabSelected(DynamicObject org) {
        this.getModel().deleteEntryData("entryentity1");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject taskEntry : entries) {
            DynamicObject resDept = taskEntry.getDynamicObject("resdepttx");
            if (resDept == null || !org.getPkValue().toString().equalsIgnoreCase(resDept.getPkValue().toString())) continue;
            int rowIndex = this.getModel().createNewEntryRow("entryentity1");
            this.setTaskTabByEntry(taskEntry, rowIndex, MAIN);
            this.updateTimeDeviationColor("matasktimepctx", "entryentity1", rowIndex);
        }
        this.modifyTabName(ZHUZETABPAGEAP, "entryentity1");
    }

    protected void setTaskTabByEntry(DynamicObject taskEntry, int rowIndex, String prefix) {
        DynamicObjectCollection cooDept;
        DynamicObjectCollection cooPerson;
        if (taskEntry.getDynamicObject("tasksource") != null) {
            this.getModel().setValue(prefix + "belongplantype", taskEntry.getDynamicObject("tasksource").getPkValue(), rowIndex);
        }
        if (taskEntry.getDynamicObject("taskprojecttx") != null) {
            this.getModel().setValue(prefix + "taskprojecttx", taskEntry.getDynamicObject("taskprojecttx").getPkValue(), rowIndex);
        }
        if (taskEntry.getDynamicObject("taskcontrolleveltx") != null) {
            this.getModel().setValue(prefix + "taskcontrolleveltx", taskEntry.getDynamicObject("taskcontrolleveltx").getPkValue(), rowIndex);
        }
        if (taskEntry.getDynamicObject("respersontx") != null) {
            this.getModel().setValue(prefix + "respersontx", taskEntry.getDynamicObject("respersontx").getPkValue(), rowIndex);
        }
        if (taskEntry.getDynamicObject("resdepttx") != null) {
            this.getModel().setValue(prefix + "resdepttx", taskEntry.getDynamicObject("resdepttx").getPkValue(), rowIndex);
        }
        if ((cooPerson = taskEntry.getDynamicObjectCollection("multicooperationperson")) != null && cooPerson.size() > 0) {
            this.getModel().setValue(prefix + "multicooperationperson", (Object)cooPerson, rowIndex);
        }
        if ((cooDept = taskEntry.getDynamicObjectCollection("multicooperationdept")) != null && cooDept.size() > 0) {
            this.getModel().setValue(prefix + "multicooperationdept", (Object)cooDept, rowIndex);
        }
        this.getModel().setValue(prefix + "tasknametx", taskEntry.get("tasknametx"), rowIndex);
        this.getModel().setValue(prefix + "taskstarttimetx", taskEntry.get("taskstarttimetx"), rowIndex);
        this.getModel().setValue(prefix + "taskendtimetx", taskEntry.get("taskendtimetx"), rowIndex);
        this.getModel().setValue(prefix + "taskmubiaotx", taskEntry.get("taskmubiaotx"), rowIndex);
        this.getModel().setValue(prefix + "tasktimepctx", taskEntry.get("tasktimepctx"), rowIndex);
        this.getModel().setValue(prefix + "taskjdgqtx", taskEntry.get("taskjdgqtx"), rowIndex);
    }

    protected void modifyTabName(String tabName, String entryName) {
        int rowCount = this.getModel().getEntryRowCount(entryName);
        TabPage tabPage = (TabPage)this.getView().getControl(tabName);
        if (StringUtils.equalsIgnoreCase((CharSequence)tabName, (CharSequence)ZHUZETABPAGEAP)) {
            if (rowCount == 0) {
                LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u4e3b\u8d23", (String)"DeptPlanBillPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                tabPage.setText(text);
            } else {
                LocaleString text = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e3b\u8d23[%s]", (String)"DeptPlanBillPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowCount));
                tabPage.setText(text);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabName, (CharSequence)XIEBANTABPAGEAP)) {
            if (rowCount == 0) {
                LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u534f\u529e", (String)"DeptPlanBillPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                tabPage.setText(text);
            } else {
                LocaleString text = new LocaleString(String.format(ResManager.loadKDString((String)"\u534f\u529e[%s]", (String)"DeptPlanBillPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowCount));
                tabPage.setText(text);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabName, (CharSequence)TOTALTABPAGEAP)) {
            if (rowCount == 0) {
                LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DeptPlanBillPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                tabPage.setText(text);
            } else {
                LocaleString text = new LocaleString(String.format(ResManager.loadKDString((String)"\u5168\u90e8[%s]", (String)"DeptPlanBillPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowCount));
                tabPage.setText(text);
            }
        }
    }

    protected void updateTimeDeviationColor(int rowIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)this.getModel().getValue("tasktimepctx", rowIndex);
        ArrayList<CellStyle> list = new ArrayList<CellStyle>(10);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey("tasktimepctx");
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setForeColor("#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            cellStyle.setForeColor("#FF0000");
        }
        list.add(cellStyle);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("taskentity");
        treeEntryGrid.setCellStyle(list);
    }

    protected void updateTimeDeviationColor(String cellName, String entryName, int rowIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)this.getModel().getValue(cellName, rowIndex);
        ArrayList<CellStyle> list = new ArrayList<CellStyle>(10);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(cellName);
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setForeColor("#FF0000");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            cellStyle.setForeColor("#00DD2C");
        }
        list.add(cellStyle);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        entryGrid.setCellStyle(list);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        int row = arg0.getRow();
        String propertyName = arg0.getProperty().getName();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"respersontx")) {
            this.beforeRespersontxSelected(arg0, row, org);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"resdepttx")) {
            this.beforeResdepttxSelected(arg0, row, org);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"multicooperationperson")) {
            this.beforeCooperontxSelected(arg0, row);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"multicooperationdept")) {
            this.beforeCoodepttxSelected(arg0, row);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"tasktype")) {
            this.beforeTaskTypeSelected(arg0, row);
        }
    }

    protected void beforeCoodepttxSelected(BeforeF7SelectEvent arg0, int row) {
        DynamicObjectCollection taskCooperson = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson", row);
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype", row);
        if (null != plantype) {
            plantype = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"));
        }
        if (null != plantype && (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()))) {
            if (taskCooperson != null && taskCooperson.size() > 0) {
                ArrayList allDeptIds = new ArrayList();
                for (DynamicObject taskCoper : taskCooperson) {
                    String userId = taskCoper.get("fbasedataid_id").toString();
                    List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                    List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    deptIds.removeAll(subordinateOrgs);
                    deptIds.addAll(subordinateOrgs);
                    allDeptIds.addAll(deptIds);
                }
                QFilter orgFilter = new QFilter("id", "in", allDeptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
            }
        } else if (taskCooperson != null && taskCooperson.size() > 0) {
            ArrayList deptIds = new ArrayList();
            taskCooperson.stream().map(o -> deptIds.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
            QFilter orgFilter = new QFilter("id", "in", deptIds);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(orgFilter);
        }
    }

    protected void beforeCooperontxSelected(BeforeF7SelectEvent arg0, int row) {
        DynamicObjectCollection taskCoodept = (DynamicObjectCollection)this.getModel().getValue("multicooperationdept", row);
        DynamicObject responsiblePreson1 = (DynamicObject)this.getModel().getValue("respersontx", row);
        QFilter notSamePeopleFilter = null;
        if (responsiblePreson1 != null) {
            notSamePeopleFilter = new QFilter("id", "!=", responsiblePreson1.getPkValue());
        }
        if (taskCoodept != null && taskCoodept.size() > 0) {
            ArrayList taskCoodeptIds = new ArrayList();
            taskCoodept.stream().map(o -> taskCoodeptIds.add(o.getLong("fbasedataid_id"))).count();
            List userIds = UserServiceHelper.getAllUsersOfOrg(taskCoodeptIds);
            QFilter userFilter = new QFilter("id", "in", (Object)userIds);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(userFilter.and(notSamePeopleFilter));
        } else {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(notSamePeopleFilter);
        }
    }

    protected void beforeResdepttxSelected(BeforeF7SelectEvent arg0, int row, DynamicObject org) {
        DynamicObject taskResperson = (DynamicObject)this.getModel().getValue("respersontx", row);
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype", row);
        if (null != plantype) {
            plantype = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"));
        }
        if (null != plantype && (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()))) {
            if (null != org) {
                Long orgId = Long.valueOf(org.getPkValue().toString());
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                orgIds.add(orgId);
                List orgIdList = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), orgIds, (boolean)true);
                String userId = RequestContext.get().getUserId();
                if (taskResperson != null) {
                    userId = taskResperson.getPkValue().toString();
                }
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                QFilter orgFilter = null;
                if (null != subordinateOrgs && subordinateOrgs.contains(orgId)) {
                    orgFilter = new QFilter("id", "in", (Object)orgIdList);
                } else {
                    List allDeptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    allDeptList.retainAll(orgIdList);
                    orgFilter = new QFilter("id", "in", (Object)allDeptList);
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                showParameter.setMultiSelect(false);
            }
        } else if (taskResperson != null) {
            List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(taskResperson.getPkValue().toString()), (boolean)false);
            QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(orgFilter);
            showParameter.setMultiSelect(false);
        }
    }

    protected void beforeRespersontxSelected(BeforeF7SelectEvent arg0, int row, DynamicObject org) {
        DynamicObject plantype;
        DynamicObject taskDept = (DynamicObject)this.getModel().getValue("resdepttx", row);
        DynamicObjectCollection cooperationPresons = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson", row);
        QFilter notSameCooperationPresonFilter = null;
        if (cooperationPresons != null && cooperationPresons.size() > 0) {
            ArrayList coperIds = new ArrayList();
            cooperationPresons.stream().map(o -> coperIds.add(o.getLong("fbasedataid_id"))).count();
            notSameCooperationPresonFilter = new QFilter("id", "not in", coperIds);
        }
        if (null != (plantype = (DynamicObject)this.getModel().getValue("belongplantype", row)) && !plantype.get("number").equals(TaskTypeEnum.ASSIGNTASK.getValue())) {
            plantype = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"));
        }
        if (null != plantype && (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()))) {
            if (null != org) {
                Long orgId = Long.valueOf(org.getPkValue().toString());
                if (null != taskDept) {
                    orgId = Long.valueOf(taskDept.getPkValue().toString());
                }
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                orgIds.add(orgId);
                String userId = RequestContext.get().getUserId();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List userIds = null;
                userIds = null != subordinateOrgs && subordinateOrgs.contains(orgId) ? UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true) : UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)false);
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter.and(notSameCooperationPresonFilter));
                showParameter.setMultiSelect(false);
            }
        } else if (taskDept != null) {
            List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(taskDept.getPkValue().toString()));
            QFilter userFilter = new QFilter("id", "in", (Object)userIds);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(userFilter.and(notSameCooperationPresonFilter));
            showParameter.setMultiSelect(false);
        } else {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(notSameCooperationPresonFilter);
            showParameter.setMultiSelect(false);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String isInit = this.getPageCache().get("isInit");
        if (StringUtils.equals((CharSequence)isInit, (CharSequence)"true")) {
            return;
        }
        String key = (String)this.getView().getFormShowParameter().getCustomParam(INVOKEOPER);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        if (null != key && key.equalsIgnoreCase("copy") && null != parentbill) {
            BigDecimal version = (BigDecimal)this.getModel().getValue(VERSION);
            BigDecimal newVersion = version.add(new BigDecimal(1));
            this.getModel().setValue(VERSION, (Object)newVersion);
            this.getView().setVisible(Boolean.FALSE, new String[]{"importdepttask"});
            String billId = String.valueOf(parentbill);
            this.getModel().setValue("prechangeplan", (Object)(StringUtils.isNotBlank((CharSequence)billId) ? Long.parseLong(billId) : 0L));
            int intnewVersion = newVersion.intValue();
            if (intnewVersion == 2) {
                this.getModel().setValue("sourceplan", (Object)String.valueOf(parentbill));
            } else {
                DynamicObject parentBill = BusinessDataServiceHelper.loadSingle((Object)parentbill, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"id, sourceplan");
                if (null != parentBill) {
                    this.getModel().setValue("sourceplan", (Object)parentBill.getString("sourceplan"));
                }
            }
            this.modifyPerson();
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "planningcycle", "timerange", "plantimetange"});
            this.getView().updateView("modifier");
            this.getView().updateView("modifytime");
            this.getView().updateView(VERSION);
            this.getView().updateView("prechangeplan");
            String sourceBillFormId = this.getView().getFormShowParameter().getFormId();
            Object sourceBillId = parentbill;
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("taskentity");
        treeEntryGrid.setCollapse(false);
    }

    protected void autoName() {
        String planningcycle = (String)this.getModel().getValue("planningcycle");
        Date startTime = (Date)this.getModel().getValue("STARTTIME");
        if (planningcycle == null || startTime == null) {
            return;
        }
        int year = startTime.getYear() % 100;
        int month = startTime.getMonth();
        int date = startTime.getDate();
        String periodName = null;
        block7 : switch (planningcycle) {
            case "YEAR": {
                periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_56", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                break;
            }
            case "HALFYEAR": {
                if (month < 6) {
                    periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u4e0a\u534a\u5e74\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_57", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                    break;
                }
                periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u4e0b\u534a\u5e74\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_58", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                break;
            }
            case "QUART": {
                switch (month / 3 + 1) {
                    case 1: {
                        periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u7b2c\u4e00\u5b63\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_59", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                        break block7;
                    }
                    case 2: {
                        periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u7b2c\u4e8c\u5b63\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_60", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                        break block7;
                    }
                    case 3: {
                        periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u7b2c\u4e09\u5b63\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_61", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                        break block7;
                    }
                    case 4: {
                        periodName = String.format(ResManager.loadKDString((String)"%s\u5e74\u7b2c\u56db\u5b63\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_62", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year);
                        break block7;
                    }
                }
                break;
            }
            case "MONTH": {
                periodName = String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u5ea6\u8ba1\u5212", (String)"DeptPlanBillPlugin_71", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year, month + 1);
                break;
            }
            case "WEEK": {
                int week = date / 7 + (date % 7 <= 1 ? 1 : 2);
                periodName = String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u5ea6\u7b2c%3$s\u5468\u8ba1\u5212", (String)"DeptPlanBillPlugin_72", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year, month + 1, week);
                break;
            }
        }
        BigDecimal version = (BigDecimal)this.getModel().getValue(VERSION);
        int intVsrsion = version.intValue();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String name = org.getString("name") + periodName + intVsrsion + ".0";
        this.getModel().setValue("name", (Object)name);
    }

    protected int getOriginLevel(int level) {
        while (level > 6) {
            level -= 6;
        }
        return level;
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (null == map || map.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    protected void hideLevelNum() {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        HashMap<String, Long> map = new HashMap<String, Long>();
        int maxLevel = 0;
        for (DynamicObject taskEnetity : taskEntries) {
            map.put(taskEnetity.getString("id"), taskEnetity.getLong(TREEENTRY_PID));
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        maxLevel = max.isPresent() ? max.get() : 0;
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        for (int i = 1; i <= 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                if (maxLevel < i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
            }
        }
    }

    public void afterBindData(EventObject e) {
        String planningcycle;
        super.afterBindData(e);
        this.autoName();
        String isInit = this.getPageCache().get("isInit");
        if (StringUtils.equals((CharSequence)isInit, (CharSequence)"true")) {
            return;
        }
        this.setBaseInfoCollapse();
        this.hideLevelNum();
        String key = (String)this.getView().getFormShowParameter().getCustomParam(INVOKEOPER);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        BigDecimal version = (BigDecimal)this.getModel().getValue(VERSION);
        int intVsrsion = version.intValue();
        if (intVsrsion > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "planningcycle", "timerange", "plantimetange", "assigner"});
            if (null != key && key.equalsIgnoreCase("copy") && null != parentbill) {
                this.adjustPlan(parentbill);
            }
        }
        if (null != (planningcycle = (String)this.getModel().getValue("planningcycle")) && (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.MONTH.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.WEEK.getValue()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTPROJECTTASK});
        }
        this.updateImportTask();
        this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        this.lockEntry();
        this.setDateEditRange();
        this.setTransactionEntryEnable(0);
        this.getPageCache().put("isInit", "true");
    }

    protected void setBaseInfoCollapse() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        boolean isCopy = formShowParameter.getCustomParam("iscopy") != null;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (OperationStatus.VIEW.equals((Object)status) || isCopy || !StringUtils.endsWithIgnoreCase((CharSequence)"A", (CharSequence)billStatus)) {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(true);
        } else {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(false);
        }
    }

    protected void adjustPlan(Object parentbill) {
        boolean isBefore;
        this.adjustTasks(parentbill);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (null != org && (isBefore = this.isBeforePlanAudit(org.getPkValue(), parentbill))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u90e8\u95e8\u65e5\u5386\u5df2\u4fee\u6539\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u8ba1\u7b97\u65f6\u95f4\uff1f", (String)"DeptPlanBillPlugin_96", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("calmodify"));
        }
        this.copyAttachments();
    }

    protected void copyAttachments() {
        QFilter filter = new QFilter("finterid", "=", (Object)String.valueOf(this.getModel().getValue("prechangeplan")));
        filter.and(new QFilter("fbilltype", "=", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan")));
        filter.and(new QFilter("fattachmentpanel", "=", (Object)ATTACHMENTPANEL));
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)"ffileid,fattachmentname", (QFilter[])new QFilter[]{filter});
        long[] newIds = ORM.create().genLongIds(BOS_ATTACHMENT, attachments.length);
        int index = 0;
        for (DynamicObject attachment : attachments) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            String attachmentName = attachment.getString("fattachmentname");
            String attachmentUrl = attachment.getString("ffileid");
            InputStream inputStream = service.getInputStream(attachmentUrl);
            String utf8Name = "";
            try {
                utf8Name = URLEncoder.encode(attachmentName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
            String path = "/deptplanattachment_" + System.currentTimeMillis() + '/' + attachmentName;
            int fileSize = 0;
            try {
                fileSize = inputStream.available();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            FileItem fileItem = new FileItem(utf8Name, path, inputStream);
            fileItem.setCreateNewFileWhenExists(true);
            String copyUrl = service.upload(fileItem);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
            long id = newIds[index++];
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("fnumber", (Object)UUID.randomUUID().toString());
            dynamicObject.set("fbilltype", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"));
            dynamicObject.set("fattachmentpanel", (Object)ATTACHMENTPANEL);
            dynamicObject.set("finterid", this.getModel().getDataEntity().getPkValue());
            dynamicObject.set("fmodifytime", (Object)new Date());
            dynamicObject.set("fcreatetime", (Object)new Date());
            dynamicObject.set("faliasfilename", (Object)attachmentName);
            dynamicObject.set("fattachmentname", (Object)attachmentName);
            dynamicObject.set("fextname", (Object)attachmentName.substring(attachmentName.lastIndexOf(46) + 1));
            dynamicObject.set("fattachmentsize", (Object)fileSize);
            dynamicObject.set("fcreatemen", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fdescription", (Object)ResManager.loadKDString((String)"\u90e8\u95e8\u4efb\u52a1\u9644\u4ef6", (String)"DeptPlanBillPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            dynamicObject.set("ffileid", (Object)copyUrl);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        this.getView().updateView(ATTACHMENTPANEL);
    }

    protected void adjustTasks(Object parentBillId) {
        IDataModel model = this.getModel();
        DynamicObject parentBill = BusinessDataServiceHelper.loadSingle((Object)parentBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"));
        DynamicObjectCollection parentTaskEntries = parentBill.getDynamicObjectCollection("taskentity");
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject parentEntry = (DynamicObject)parentTaskEntries.get(i);
            if (model.getValue("sourcetask", i) == null) {
                model.setValue("sourcetask", parentEntry.getPkValue(), i);
            }
            model.setValue("prechangetask", parentEntry.getPkValue(), i);
            model.setValue("taskversion", (Object)(parentEntry.getInt("taskversion") + 1), i);
            model.setValue("status", (Object)StatusEnum.TEMPSAVE.getValue(), i);
            model.setValue("islatest", (Object)DefaultEnum.NO.getValue(), i);
        }
    }

    protected void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("taskstarttimetx");
        DateEdit planEndTime = (DateEdit)this.getControl("taskendtimetx");
        DateEdit aimFinishTime = (DateEdit)this.getControl("taskmubiaotx");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            Object taskResDeptId = org.getPkValue();
            Date firstDay = TaskUtil.getFirstDayByOrg((Object)taskResDeptId, (String)this.getAppId()).getTime();
            Date endDay = TaskUtil.getEndDayByOrg((Object)taskResDeptId, (String)this.getAppId()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    protected void lockEntry() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject taskEntry = this.getModel().getEntryRowEntity("taskentity", i);
            int percent = taskEntry.getInt("percent");
            if (percent == 100) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tasknametx", "taskstarttimetx", "taskendtimetx", "taskmubiaotx", "taskjdgqtx", "respersontx", "resdepttx", "multicooperationperson", "multicooperationdept", "achievementnode", "transactiontype"});
                continue;
            }
            DynamicObject planType = taskEntry.getDynamicObject("belongplantype");
            if (null != planType && !StringUtils.equalsIgnoreCase((CharSequence)planType.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) && !StringUtils.equalsIgnoreCase((CharSequence)planType.getString("plantype"), (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) && !StringUtils.equalsIgnoreCase((CharSequence)planType.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue()) || taskEntry.getDynamicObject("relationtask") != null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tasknametx", "taskstarttimetx", "taskendtimetx", "taskmubiaotx", "taskjdgqtx", "achievementnode", "transactiontype", "tasktype"});
            }
            if (null != planType && PlanTypeEnum.DEPTFENJIEPLAN.getValue().equals(planType.getString("plantype"))) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"achievementnode"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"transactiontype"});
                continue;
            }
            if (null == planType || !PlanTypeEnum.DEPTPLAN.getValue().equals(planType.getString("plantype"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"achievementnode"});
        }
    }

    protected void updateImportTask() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        Map<String, DynamicObject> relationNewTaskMap = this.checkRelationNewTasks();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        Set<Object> entryRelateTaskSet = this.getExcludeTaskSet(relationNewTaskMap, entryEntity);
        DynamicObject[] increaseTasks = null;
        if (!entryRelateTaskSet.isEmpty()) {
            QFilter excludeTaskFilter = new QFilter("id", "not in", entryRelateTaskSet);
            increaseTasks = this.getMonthOrWeekTask(excludeTaskFilter);
        } else {
            increaseTasks = this.getMonthOrWeekTask(null);
        }
        if (relationNewTaskMap.isEmpty() && (increaseTasks == null || increaseTasks.length == 0)) {
            return;
        }
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            if (increaseTasks == null || increaseTasks.length == 0) {
                if (entryEntity != null && !entryEntity.isEmpty()) {
                    this.updateDeptRelateTask(relationNewTaskMap, entryEntity);
                }
            } else {
                DynamicObjectCollection deptTaskEntries = new DynamicObjectCollection();
                if (entryEntity != null && !entryEntity.isEmpty()) {
                    this.updateDeptRelateTask(relationNewTaskMap, entryEntity);
                    for (DynamicObject task : entryEntity) {
                        deptTaskEntries.add((Object)task);
                    }
                }
                this.convertToDeptTaskEntry(deptTaskEntries, increaseTasks, relationNewTaskMap);
            }
            this.getModel().updateCache();
            this.getView().updateView("taskentity");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u4efb\u52a1\u6709\u8c03\u6574\uff0c\u5df2\u66f4\u65b0\u5230\u6700\u65b0\u7248\u672c\u3002", (String)"DeptPlanBillPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            List<Integer> linesOfChanging;
            String planStatus = (String)this.getModel().getValue("planstatus");
            if (PlanEnum.PUBLISHED.getValue().equalsIgnoreCase(planStatus) && (linesOfChanging = this.getLinesOfChanging(relationNewTaskMap, entryEntity)).size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u5f15\u5165\u65f6\u95f4\u5df2\u8c03\u6574\u3002\u5982\u9700\u540c\u6b65\uff0c\u8bf7\u9009\u62e9\u6700\u65b0\u7684\u90e8\u95e8\u8ba1\u5212\u7248\u672c\u8fdb\u884c\u8c03\u6574\u3002", (String)"DeptPlanBillPlugin_97", (String)"pccs-placs-formplugin", (Object[])new Object[0]), linesOfChanging), Integer.valueOf(3000));
            }
        }
    }

    protected List<Integer> getLinesOfChanging(Map<String, DynamicObject> relationNewTaskMap, DynamicObjectCollection entryEntity) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Set<String> keySet = relationNewTaskMap.keySet();
        for (int i = 0; i < entryEntity.size(); ++i) {
            String relationTaskId;
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            DynamicObject relationTask = row.getDynamicObject("relationtask");
            if (relationTask == null || !keySet.contains(relationTaskId = relationTask.getPkValue().toString())) continue;
            Date rowStartTime = row.getDate("taskstarttimetx");
            Date rowEndTime = row.getDate("taskendtimetx");
            DynamicObject newTask = relationNewTaskMap.get(relationTaskId);
            if (newTask == null) continue;
            Date newStartTime = newTask.getDate("planstarttime");
            Date newEndTime = newTask.getDate("planendtime");
            if (newStartTime.compareTo(rowStartTime) != 0) {
                lines.add(i + 1);
                continue;
            }
            if (newEndTime.compareTo(rowEndTime) == 0) continue;
            lines.add(i + 1);
        }
        return lines;
    }

    protected Set<Object> getExcludeTaskSet(Map<String, DynamicObject> relationNewTaskMap, DynamicObjectCollection entryEntity) {
        HashSet<Object> excludeTaskSet = new HashSet<Object>(entryEntity.size());
        for (DynamicObject entryTask : entryEntity) {
            DynamicObject relateTask = entryTask.getDynamicObject("relationtask");
            if (relateTask != null) {
                excludeTaskSet.add(relateTask.getPkValue());
                continue;
            }
            DynamicObject preChangeTask = entryTask.getDynamicObject("prechangetask");
            if (preChangeTask != null) {
                excludeTaskSet.add(preChangeTask.getPkValue());
                excludeTaskSet.add(entryTask.getPkValue());
                continue;
            }
            excludeTaskSet.add(entryTask.getPkValue());
        }
        HashSet<String> oldRelateTaskSet = new HashSet<String>(relationNewTaskMap.size());
        for (Map.Entry<String, DynamicObject> entry : relationNewTaskMap.entrySet()) {
            oldRelateTaskSet.add(entry.getKey());
            excludeTaskSet.add(entry.getValue().getPkValue());
        }
        excludeTaskSet.removeAll(oldRelateTaskSet);
        return excludeTaskSet;
    }

    protected DynamicObject[] getMonthOrWeekTask(QFilter conditionFilter) {
        Object planningcycle = this.getModel().getValue("planningcycle");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object startTime = this.getModel().getValue("STARTTIME");
        Object endTime = this.getModel().getValue("ENDTIME");
        if (null != planningcycle) {
            String planCycle = planningcycle.toString();
            if (planCycle.equalsIgnoreCase(PlanningCycleEnum.MONTH.getValue()) || planCycle.equalsIgnoreCase(PlanningCycleEnum.WEEK.getValue())) {
                if (null != startTime && null != endTime && null != org) {
                    Object orgId = org.getPkValue();
                    QFilter deptFilter = new QFilter("responsibledept", "=", orgId).or("multicooperationdept.fbasedataid.id", "=", orgId);
                    QFilter time1 = new QFilter("planstarttime", ">=", startTime).and(new QFilter("planstarttime", "<=", endTime));
                    QFilter time2 = new QFilter("planendtime", ">=", startTime).and(new QFilter("planendtime", "<=", endTime));
                    QFilter time3 = new QFilter("planstarttime", "<=", startTime).and(new QFilter("planendtime", ">=", endTime));
                    QFilter jJtime = time1.or(time2).or(time3);
                    QFilter beginTime = new QFilter("planendtime", "<=", startTime);
                    QFilter timeFilter = jJtime.or(beginTime);
                    QFilter completionStatus = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue()).and("completionstatus", "<>", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                    QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
                    QFilter projectTaskFilter = this.getProjectTaskFilter();
                    QFilter[] filters = conditionFilter == null ? new QFilter[]{projectTaskFilter, completionStatus, timeFilter, deptFilter, latestTaskFilter} : new QFilter[]{projectTaskFilter, completionStatus, timeFilter, deptFilter, latestTaskFilter, conditionFilter};
                    DynamicObject[] importTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])filters);
                    return importTasks;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    protected void convertToDeptTaskEntry(DynamicObjectCollection deptTaskEntries, DynamicObject[] increaseTasks, Map<String, DynamicObject> relationNewTaskMap) {
        if (!(deptTaskEntries != null && !deptTaskEntries.isEmpty() || increaseTasks != null && increaseTasks.length != 0)) {
            return;
        }
        Object[] deptPks = new Object[]{};
        if (deptTaskEntries != null && !deptTaskEntries.isEmpty()) {
            deptPks = deptTaskEntries.stream().map(DataEntityBase::getPkValue).toArray();
        }
        Object[] increTaskPks = new Object[]{};
        Set<Object> taskIdSet = new HashSet<Object>(0);
        if (increaseTasks != null && increaseTasks.length > 0) {
            increTaskPks = Arrays.stream(increaseTasks).map(DataEntityBase::getPkValue).toArray();
            taskIdSet = Arrays.stream(increaseTasks).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        }
        if (deptPks.length == 0 && increTaskPks.length == 0) {
            return;
        }
        for (Map.Entry<String, DynamicObject> entry : relationNewTaskMap.entrySet()) {
            taskIdSet.add(entry.getValue().getPkValue());
        }
        HashMap<Object, Object> latestRelateToDeptTaskMap = new HashMap<Object, Object>(relationNewTaskMap.size());
        HashMap<Object, Object> preChangeToDeptTaskMap = new HashMap<Object, Object>(relationNewTaskMap.size());
        for (DynamicObject deptTask : deptTaskEntries) {
            DynamicObject newRelateTask = deptTask.getDynamicObject("relationtask");
            if (newRelateTask != null) {
                latestRelateToDeptTaskMap.put(newRelateTask.getPkValue(), deptTask.getPkValue());
                continue;
            }
            DynamicObject preChangeTask = deptTask.getDynamicObject("prechangetask");
            if (preChangeTask == null) continue;
            taskIdSet.add(preChangeTask.getPkValue());
            preChangeToDeptTaskMap.put(preChangeTask.getPkValue(), deptTask.getPkValue());
        }
        DynamicObject[] tasksFromOtherPlan = BusinessDataServiceHelper.load((Object[])increTaskPks, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        HashMap<Object, Object> refMap = new HashMap<Object, Object>(16);
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        this.addRefMapFromTaskEntry(taskEntries, refMap);
        this.fillTaskEntryFromOtherPlan(taskEntries, tasksFromOtherPlan, refMap, taskIdSet);
        for (Object taskEntry : taskEntries) {
            Object pid = taskEntry.get(TREEENTRY_PID);
            if (pid == null || (Long)pid == 0L) continue;
            if (refMap.containsKey(pid)) {
                taskEntry.set(TREEENTRY_PID, refMap.get(pid));
                continue;
            }
            DynamicObject relateTask = taskEntry.getDynamicObject("relationtask");
            if (relateTask == null) continue;
            Object deptTaskId = latestRelateToDeptTaskMap.get(pid);
            if (deptTaskId == null) {
                deptTaskId = preChangeToDeptTaskMap.get(pid);
            }
            taskEntry.set(TREEENTRY_PID, refMap.get(deptTaskId));
        }
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (Object taskEntry : taskEntries) {
            Object parentId = taskEntry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : taskEntries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString(TREEENTRY_PID), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject taskEntry : taskEntries) {
            Long pid = taskEntry.getLong(TREEENTRY_PID);
            int level = 1;
            if (pid != 0L) continue;
            this.addChildTask(newEntries, parentToChildMap, taskEntry, level);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(newEntries);
        this.getView().updateView("taskentity");
    }

    private void addChildTask(DynamicObjectCollection newEntries, Map<Object, List<DynamicObject>> parentToChildMap, DynamicObject parentTask, int level) {
        List<DynamicObject> childList = parentToChildMap.get(parentTask.getPkValue());
        if (!childList.isEmpty()) {
            parentTask.set(LEVEL, (Object)level);
            parentTask.set("isleaf", (Object)EnableEnum.DISABLE.getValue());
            newEntries.add((Object)parentTask);
            ++level;
            for (DynamicObject child : childList) {
                this.addChildTask(newEntries, parentToChildMap, child, level);
            }
        } else {
            parentTask.set("isleaf", (Object)EnableEnum.ENABLE.getValue());
            parentTask.set(LEVEL, (Object)level);
            newEntries.add((Object)parentTask);
        }
    }

    private void updateDeptRelateTask(Map<String, DynamicObject> relationNewTaskMap, DynamicObjectCollection taskEntries) {
        if (relationNewTaskMap == null || relationNewTaskMap.isEmpty()) {
            return;
        }
        for (DynamicObject task : taskEntries) {
            DynamicObject newTask;
            DynamicObject relateTask = task.getDynamicObject("relationtask");
            if (relateTask == null || (newTask = relationNewTaskMap.get(relateTask.getPkValue().toString())) == null) continue;
            newTask = BusinessDataServiceHelper.loadSingle((Object)newTask.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            task.set("tasknametx", newTask.get("name"));
            task.set("taskprojecttx", (Object)newTask.getDynamicObject("project"));
            task.set("taskcontrolleveltx", newTask.get("controllevel"));
            task.set("achievementnode", newTask.get("achievementnode"));
            DeptPlanBillPlugin.setTx(newTask.getDynamicObjectCollection("transactiontype"), task, ORM.create());
            task.set("taskstarttimetx", newTask.get("planstarttime"));
            task.set("taskendtimetx", newTask.get("planendtime"));
            task.set("taskmubiaotx", newTask.get("aimfinishtime"));
            task.set("tasktimepctx", newTask.get("comptimedeviation"));
            task.set("taskjdgqtx", newTask.get("absoluteduration"));
            task.set("respersontx", (Object)newTask.getDynamicObject("responsibleperson"));
            task.set("resdepttx", (Object)newTask.getDynamicObject("responsibledept"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationperson", (DynamicObject)newTask, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationdept", (DynamicObject)newTask, (String)"multicooperationdept");
            task.set("majortype", (Object)newTask.getDynamicObject("majortype"));
            task.set("tasksource", (Object)newTask.getDynamicObject("tasksource"));
            task.set("belongplantype", (Object)newTask.getDynamicObject("belongplantype"));
            task.set("relationtask", (Object)newTask);
            task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            task.set("percent", newTask.get("percent"));
            task.set("completionstatus", newTask.get("completionstatus"));
            task.set("taskversion", this.getModel().getValue(VERSION));
            task.set("tasktype", (Object)newTask.getDynamicObject("tasktype"));
            task.set(LEVEL, newTask.get(LEVEL));
            task.set("isleaf", newTask.get("isleaf"));
            task.set("islatest", (Object)DefaultEnum.NO.getValue());
            this.copyTaskFile(newTask, task);
        }
    }

    private void fillTaskEntry(DynamicObject task, DynamicObject newTask) {
        task.set("tasknametx", newTask.get("name"));
        task.set("taskprojecttx", (Object)newTask.getDynamicObject("project"));
        task.set("taskcontrolleveltx", newTask.get("controllevel"));
        task.set("achievementnode", newTask.get("achievementnode"));
        DeptPlanBillPlugin.setTx(newTask.getDynamicObjectCollection("transactiontype"), task, ORM.create());
        task.set("taskstarttimetx", newTask.get("planstarttime"));
        task.set("taskendtimetx", newTask.get("planendtime"));
        task.set("taskmubiaotx", newTask.get("aimfinishtime"));
        task.set("tasktimepctx", newTask.get("comptimedeviation"));
        task.set("taskjdgqtx", newTask.get("absoluteduration"));
        task.set("respersontx", (Object)newTask.getDynamicObject("responsibleperson"));
        task.set("resdepttx", (Object)newTask.getDynamicObject("responsibledept"));
        MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationperson", (DynamicObject)newTask, (String)"multicooperationperson");
        MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationdept", (DynamicObject)newTask, (String)"multicooperationdept");
        task.set("majortype", (Object)newTask.getDynamicObject("majortype"));
        task.set("tasksource", (Object)newTask.getDynamicObject("tasksource"));
        task.set("belongplantype", (Object)newTask.getDynamicObject("belongplantype"));
        task.set("status", (Object)newTask.getString("status"));
        task.set("percent", newTask.get("percent"));
        task.set("completionstatus", newTask.get("completionstatus"));
        task.set("taskversion", (Object)newTask.getString(VERSION));
        task.set("tasktype", (Object)newTask.getDynamicObject("tasktype"));
        task.set(LEVEL, newTask.get(LEVEL));
        task.set("isleaf", newTask.get("isleaf"));
        task.set("islatest", (Object)newTask.getString("islatest"));
    }

    protected void fillTaskEntryFromOtherPlan(DynamicObjectCollection taskEntries, DynamicObject[] tasksFromOtherPlan, Map<Object, Object> refMap, Set<Object> taskIdSet) {
        IDataModel model = this.getModel();
        DynamicObjectType taskEntryDT = MetaDataUtil.getEntryDT((String)this.getAppId(), (String)"deptplan", (String)"taskentity");
        ORM orm = ORM.create();
        long[] newEntryIds = orm.genLongIds((IDataEntityType)taskEntryDT, tasksFromOtherPlan.length);
        int index = 0;
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        for (DynamicObject otherTask : tasksFromOtherPlan) {
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = newEntryIds[index++];
            refMap.put(otherTask.getPkValue(), pk);
            newEntry.set("id", (Object)pk);
            newEntry.set("tasknametx", otherTask.get("name"));
            newEntry.set("taskprojecttx", (Object)otherTask.getDynamicObject("project"));
            newEntry.set("taskcontrolleveltx", otherTask.get("controllevel"));
            newEntry.set("achievementnode", otherTask.get("achievementnode"));
            DeptPlanBillPlugin.setTx(otherTask.getDynamicObjectCollection("transactiontype"), newEntry, orm);
            newEntry.set("taskstarttimetx", otherTask.get("planstarttime"));
            newEntry.set("taskendtimetx", otherTask.get("planendtime"));
            newEntry.set("taskmubiaotx", otherTask.get("aimfinishtime"));
            newEntry.set("tasktimepctx", otherTask.get("comptimedeviation"));
            newEntry.set("taskjdgqtx", otherTask.get("absoluteduration"));
            newEntry.set("respersontx", (Object)otherTask.getDynamicObject("responsibleperson"));
            newEntry.set("resdepttx", (Object)otherTask.getDynamicObject("responsibledept"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)otherTask, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)otherTask, (String)"multicooperationdept");
            newEntry.set("majortype", (Object)otherTask.getDynamicObject("majortype"));
            newEntry.set("tasksource", (Object)otherTask.getDynamicObject("tasksource"));
            newEntry.set("belongplantype", (Object)otherTask.getDynamicObject("belongplantype"));
            newEntry.set("relationtask", (Object)otherTask);
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("percent", otherTask.get("percent"));
            newEntry.set("completionstatus", otherTask.get("completionstatus"));
            newEntry.set("taskversion", model.getValue(VERSION));
            newEntry.set("majortype", (Object)otherTask.getDynamicObject("majortype"));
            newEntry.set("tasktype", (Object)otherTask.getDynamicObject("tasktype"));
            newEntry.set(LEVEL, otherTask.get(LEVEL));
            newEntry.set("isleaf", otherTask.get("isleaf"));
            newEntry.set("islatest", (Object)DefaultEnum.NO.getValue());
            DynamicObject parent = otherTask.getDynamicObject("parent");
            while (parent != null) {
                DynamicObject parentRelaTaskObj = (parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))).getDynamicObject("relationtask");
                if (parentRelaTaskObj == null) {
                    if (taskIdSet.contains(parent.getPkValue())) break;
                    parent = parent.getDynamicObject("parent");
                    continue;
                }
                boolean isLatest = (parentRelaTaskObj = BusinessDataServiceHelper.loadSingle((Object)parentRelaTaskObj.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))).getBoolean("islatest");
                if (isLatest) {
                    if (taskIdSet.contains(parentRelaTaskObj.getPkValue())) {
                        parent = parentRelaTaskObj;
                        break;
                    }
                    parent = parentRelaTaskObj.getDynamicObject("parent");
                    continue;
                }
                DynamicObject sourceTask = parentRelaTaskObj.getDynamicObject("sourcetask");
                QFilter latestTaskFilter = sourceTask == null ? new QFilter("sourcetask", "=", parentRelaTaskObj.getPkValue()) : new QFilter("sourcetask", "=", sourceTask.getPkValue());
                QFilter islatestFilter = new QFilter("islatest", "=", (Object)"1");
                DynamicObject latestTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{latestTaskFilter, islatestFilter, statusFilter});
                if (latestTask != null) {
                    if (taskIdSet.contains(latestTask.getPkValue())) {
                        parent = latestTask;
                        break;
                    }
                    parent = latestTask.getDynamicObject("parent");
                    continue;
                }
                parent = null;
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set(TREEENTRY_PID, (Object)pid);
            taskEntries.add((Object)newEntry);
            this.copyTaskFile(otherTask, newEntry);
        }
    }

    protected void dealTaskEntryExtField(DynamicObject newEntry, DynamicObject masterTask) {
    }

    protected void addRefMapFromTaskEntry(DynamicObjectCollection taskEntries, Map<Object, Object> refMap) {
        for (DynamicObject deptTask : taskEntries) {
            Object pkValue = deptTask.getPkValue();
            refMap.put(pkValue, pkValue);
        }
    }

    protected void setEntryByRelationTask(Object taskId, int rowIndex, boolean isUpdate, DynamicObject deptPlanType) {
        DynamicObject relationTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        IDataModel model = this.getModel();
        model.setValue("relationtask", relationTask.getPkValue(), rowIndex);
        model.setValue("tasknametx", relationTask.get("name"), rowIndex);
        model.setValue("taskcontrolleveltx", relationTask.get("controllevel"), rowIndex);
        model.setValue("taskstarttimetx", relationTask.get("planstarttime"), rowIndex);
        model.setValue("taskendtimetx", relationTask.get("planendtime"), rowIndex);
        model.setValue("taskmubiaotx", relationTask.get("aimfinishtime"), rowIndex);
        model.setValue("tasktimepctx", relationTask.get("comptimedeviation"), rowIndex);
        model.setValue("taskjdgqtx", relationTask.get("absoluteduration"), rowIndex);
        model.setValue("taskversion", model.getValue(VERSION), rowIndex);
        model.setValue("status", relationTask.get("status"), rowIndex);
        model.setValue("percent", relationTask.get("percent"), rowIndex);
        model.setValue("completionstatus", relationTask.get("completionstatus"), rowIndex);
        model.setValue("achievementnode", relationTask.get("achievementnode"), rowIndex);
        if (relationTask.getDynamicObject("project") != null) {
            model.setValue("taskprojecttx", relationTask.getDynamicObject("project").getPkValue(), rowIndex);
        }
        if (relationTask.getDynamicObject("controllevel") != null) {
            model.setValue("taskcontrolleveltx", relationTask.getDynamicObject("controllevel").getPkValue(), rowIndex);
        }
        if (relationTask.getDynamicObject("responsibleperson") != null) {
            model.setValue("respersontx", relationTask.getDynamicObject("responsibleperson").getPkValue(), rowIndex);
        }
        if (relationTask.getDynamicObject("responsibledept") != null) {
            model.setValue("resdepttx", relationTask.getDynamicObject("responsibledept").getPkValue(), rowIndex);
        }
        DynamicObject currentTask = model.getEntryRowEntity("taskentity", rowIndex);
        if (relationTask.getDynamicObject("multicooperationperson") != null) {
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)currentTask, (String)"multicooperationperson", (DynamicObject)relationTask, (String)"multicooperationperson");
        }
        if (relationTask.getDynamicObject("multicooperationdept") != null) {
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)currentTask, (String)"multicooperationdept", (DynamicObject)relationTask, (String)"multicooperationdept");
        }
        if (relationTask.getDynamicObject("belongplantype") != null) {
            model.setValue("tasksource", relationTask.getDynamicObject("belongplantype").getPkValue(), rowIndex);
        }
        if (relationTask.getDynamicObject("majortype") != null) {
            model.setValue("majortype", relationTask.getDynamicObject("majortype").getPkValue(), rowIndex);
        }
        if (relationTask.getDynamicObject("tasktype") != null) {
            model.setValue("tasktype", relationTask.getDynamicObject("tasktype").getPkValue(), rowIndex);
        }
        if (!isUpdate && deptPlanType != null) {
            model.setValue("belongplantype", deptPlanType.getPkValue(), rowIndex);
        }
        this.copyTaskFile(relationTask, currentTask);
    }

    protected static void setTx(DynamicObjectCollection transactiontype, DynamicObject newTask, ORM orm) {
        DynamicObjectType type = transactiontype.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)type, transactiontype.size());
        DynamicObjectCollection newCollect = new DynamicObjectCollection();
        for (int i = 0; i < transactiontype.size(); ++i) {
            DynamicObject tx = (DynamicObject)transactiontype.get(i);
            DynamicObject newtx = new DynamicObject(type);
            newtx.set("pkid", (Object)longIds[i]);
            newtx.set("fbasedataid", tx.get("fbasedataid"));
            newtx.set("fbasedataid_id", tx.get("fbasedataid_id"));
            newCollect.add((Object)newtx);
        }
        newTask.set("transactiontype", (Object)newCollect);
    }

    protected void fillEntryByRelationTask(DynamicObject[] importTasks) {
        IDataModel model = this.getModel();
        Set taskIdSet = Arrays.stream(importTasks).map(o -> o.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection taskEntries = model.getEntryEntity("taskentity");
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        ORM orm = ORM.create();
        long[] ids = ORM.create().genLongIds(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), importTasks.length);
        int idIndex = 0;
        HashMap<Object, Long> refMap = new HashMap<Object, Long>(importTasks.length);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        for (DynamicObject task : importTasks) {
            task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = ids[idIndex++];
            refMap.put(task.getPkValue(), pk);
            DynamicObject taskSource = task.getDynamicObject("tasksource");
            DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
            newEntry.set("id", (Object)pk);
            newEntry.set("tasknametx", task.get("name"));
            newEntry.set("taskprojecttx", (Object)task.getDynamicObject("project"));
            newEntry.set("taskcontrolleveltx", task.get("controllevel"));
            String achievementnode = task.getString("achievementnode");
            if (!DefaultEnum.NO.getValue().equals(achievementnode) && !DefaultEnum.YES.getValue().equals(achievementnode)) {
                newEntry.set("achievementnode", (Object)DefaultEnum.NO.getValue());
            } else {
                newEntry.set("achievementnode", task.get("achievementnode"));
            }
            DeptPlanBillPlugin.setTx(task.getDynamicObjectCollection("transactiontype"), newEntry, orm);
            newEntry.set("taskstarttimetx", task.get("planstarttime"));
            newEntry.set("taskendtimetx", task.get("planendtime"));
            newEntry.set("taskmubiaotx", task.get("aimfinishtime"));
            newEntry.set("tasktimepctx", task.get("comptimedeviation"));
            newEntry.set("taskjdgqtx", task.get("absoluteduration"));
            newEntry.set("respersontx", (Object)task.getDynamicObject("responsibleperson"));
            newEntry.set("resdepttx", (Object)task.getDynamicObject("responsibledept"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)task, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)task, (String)"multicooperationdept");
            newEntry.set("tasksource", (Object)taskSource);
            newEntry.set("majortype", (Object)task.getDynamicObject("majortype"));
            newEntry.set("belongplantype", (Object)belongPlanType);
            newEntry.set("relationtask", (Object)task);
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("percent", task.get("percent"));
            newEntry.set("completionstatus", task.get("completionstatus"));
            newEntry.set("taskversion", model.getValue(VERSION));
            newEntry.set("tasktype", (Object)task.getDynamicObject("tasktype"));
            newEntry.set(LEVEL, task.get(LEVEL));
            newEntry.set("isleaf", task.get("isleaf"));
            newEntry.set("islatest", (Object)DefaultEnum.NO.getValue());
            CharSequence planType = null;
            DynamicObject parent = task.getDynamicObject("parent");
            if (null != belongPlanType) {
                belongPlanType = BusinessDataServiceHelper.loadSingleFromCache((Object)belongPlanType.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"plantype"));
                belongPlanType.getString("plantype");
            }
            if (StringUtils.equals(planType, (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) || StringUtils.equals(planType, (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equals(planType, (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) {
                while (parent != null) {
                    DynamicObject parentRelaTaskObj = (parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))).getDynamicObject("relationtask");
                    if (parentRelaTaskObj == null) {
                        if (!taskIdSet.contains(parent.getPkValue())) {
                            parent = parent.getDynamicObject("parent");
                            continue;
                        }
                        break;
                    }
                    boolean isLatest = (parentRelaTaskObj = BusinessDataServiceHelper.loadSingle((Object)parentRelaTaskObj.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))).getBoolean("islatest");
                    if (isLatest) {
                        if (taskIdSet.contains(parentRelaTaskObj.getPkValue())) {
                            parent = parentRelaTaskObj;
                            break;
                        }
                        parent = parentRelaTaskObj.getDynamicObject("parent");
                        continue;
                    }
                    DynamicObject sourceTask = parentRelaTaskObj.getDynamicObject("sourcetask");
                    QFilter latestTaskFilter = sourceTask == null ? new QFilter("sourcetask", "=", parentRelaTaskObj.getPkValue()) : new QFilter("sourcetask", "=", sourceTask.getPkValue());
                    QFilter islatestFilter = new QFilter("islatest", "=", (Object)"1");
                    DynamicObject latestTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,parent", (QFilter[])new QFilter[]{latestTaskFilter, islatestFilter, statusFilter});
                    if (latestTask != null) {
                        if (taskIdSet.contains(latestTask.getPkValue())) {
                            parent = latestTask;
                            break;
                        }
                        parent = latestTask.getDynamicObject("parent");
                        continue;
                    }
                    parent = null;
                }
            } else {
                while (parent != null && !taskIdSet.contains(parent.getPkValue())) {
                    parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
                    parent = parent.getDynamicObject("parent");
                }
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set(TREEENTRY_PID, (Object)pid);
            taskEntries.add((Object)newEntry);
            this.copyTaskFile(task, newEntry);
        }
        for (DynamicObject task : taskEntries) {
            Long pid = task.getLong(TREEENTRY_PID);
            if (pid == 0L || !refMap.containsKey(pid)) continue;
            task.set(TREEENTRY_PID, refMap.get(pid));
        }
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (DynamicObject taskEntry : taskEntries) {
            Object parentId = taskEntry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : taskEntries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString(TREEENTRY_PID), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject taskEntry : taskEntries) {
            Long pid = taskEntry.getLong(TREEENTRY_PID);
            int level = 1;
            if (pid != 0L) continue;
            this.addChildTask(newEntries, parentToChildMap, taskEntry, level);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        if (!newEntries.isEmpty()) {
            model.updateEntryCache(newEntries);
        }
        this.getModel().updateCache();
        this.getView().updateView("taskentity");
    }

    protected void fillEntryByProjectTask(DynamicObject[] importTasks) {
        IDataModel model = this.getModel();
        Set taskIdSet = Arrays.stream(importTasks).map(o -> o.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection taskEntries = model.getEntryEntity("taskentity");
        for (DynamicObject taskEntry : taskEntries) {
            Object relationTaskId = taskEntry.get("relationtask_id");
            taskIdSet.add(relationTaskId);
        }
        HashMap<Long, Long> relationTaskIdMap = new HashMap<Long, Long>(16);
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        ORM orm = ORM.create();
        long[] ids = ORM.create().genLongIds(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), importTasks.length);
        int idIndex = 0;
        HashMap<Object, Long> refMap = new HashMap<Object, Long>(importTasks.length);
        for (DynamicObject task : importTasks) {
            task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = ids[idIndex++];
            refMap.put(task.getPkValue(), pk);
            newEntry.set("id", (Object)pk);
            newEntry.set("tasknametx", task.get("name"));
            newEntry.set("taskprojecttx", (Object)task.getDynamicObject("project"));
            newEntry.set("taskcontrolleveltx", task.get("controllevel"));
            String achievementnode = task.getString("achievementnode");
            if (!DefaultEnum.NO.getValue().equals(achievementnode) && !DefaultEnum.YES.getValue().equals(achievementnode)) {
                newEntry.set("achievementnode", (Object)DefaultEnum.NO.getValue());
            } else {
                newEntry.set("achievementnode", task.get("achievementnode"));
            }
            DeptPlanBillPlugin.setTx(task.getDynamicObjectCollection("transactiontype"), newEntry, orm);
            newEntry.set("taskstarttimetx", task.get("planstarttime"));
            newEntry.set("taskendtimetx", task.get("planendtime"));
            newEntry.set("taskmubiaotx", task.get("aimfinishtime"));
            newEntry.set("tasktimepctx", task.get("comptimedeviation"));
            newEntry.set("taskjdgqtx", task.get("absoluteduration"));
            newEntry.set("respersontx", (Object)task.getDynamicObject("responsibleperson"));
            newEntry.set("resdepttx", (Object)task.getDynamicObject("responsibledept"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)task, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)task, (String)"multicooperationdept");
            newEntry.set("tasksource", (Object)task.getDynamicObject("tasksource"));
            newEntry.set("majortype", (Object)task.getDynamicObject("majortype"));
            newEntry.set("belongplantype", (Object)task.getDynamicObject("belongplantype"));
            newEntry.set("relationtask", (Object)task);
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("percent", task.get("percent"));
            newEntry.set("completionstatus", task.get("completionstatus"));
            newEntry.set("taskversion", model.getValue(VERSION));
            newEntry.set("tasktype", (Object)task.getDynamicObject("tasktype"));
            newEntry.set(LEVEL, task.get(LEVEL));
            newEntry.set("isleaf", task.get("isleaf"));
            newEntry.set("islatest", (Object)DefaultEnum.NO.getValue());
            DynamicObject parent = task.getDynamicObject("parent");
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set(TREEENTRY_PID, (Object)pid);
            taskEntries.add((Object)newEntry);
            this.copyTaskFile(task, newEntry);
        }
        for (DynamicObject taskEntry : taskEntries) {
            Long relationTaskId = taskEntry.getLong("relationtask_id");
            Long pkValue = (Long)taskEntry.getPkValue();
            relationTaskIdMap.put(relationTaskId, pkValue);
        }
        for (DynamicObject task : taskEntries) {
            Long pid;
            DynamicObject relationTask = task.getDynamicObject("relationtask");
            if (relationTask != null) {
                long parentId;
                DynamicObject parent;
                for (parent = relationTask.getDynamicObject("parent"); parent != null && !taskIdSet.contains(parent.getPkValue()); parent = parent.getDynamicObject("parent")) {
                    parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
                }
                long l = parentId = parent == null ? 0L : parent.getLong("id");
                if (parentId != 0L && relationTaskIdMap.containsKey(parentId)) {
                    task.set(TREEENTRY_PID, relationTaskIdMap.get(parentId));
                    continue;
                }
            }
            if ((pid = Long.valueOf(task.getLong(TREEENTRY_PID))) == 0L) continue;
            if (refMap.containsKey(pid)) {
                task.set(TREEENTRY_PID, refMap.get(pid));
                continue;
            }
            task.set(TREEENTRY_PID, (Object)0);
        }
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (DynamicObject taskEntry : taskEntries) {
            Object parentId = taskEntry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : taskEntries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString(TREEENTRY_PID), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject taskEntry : taskEntries) {
            Long pid = taskEntry.getLong(TREEENTRY_PID);
            int level = 1;
            if (pid != 0L) continue;
            this.addChildTask(newEntries, parentToChildMap, taskEntry, level);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        if (!newEntries.isEmpty()) {
            this.getModel().deleteEntryData("taskentity");
            model.updateEntryCache(newEntries);
        }
        model.updateCache();
        this.getView().updateView();
    }

    protected Map<String, DynamicObject> checkRelationNewTasks() {
        DynamicObject[] latestTasks;
        HashMap<String, DynamicObject> relationNewTaskMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, String> sourceTaskIdMap = new HashMap<String, String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject entry : entryEntity) {
            DynamicObject sourceTask;
            DynamicObject relationTask = entry.getDynamicObject("relationtask");
            if (relationTask == null) continue;
            relationTask = BusinessDataServiceHelper.loadSingle((Object)relationTask.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            int percent = entry.getInt("percent");
            if (percent == 100 || relationTask.getBoolean("islatest") || (sourceTask = relationTask.getDynamicObject("sourcetask")) == null) continue;
            sourceTaskIdMap.put(sourceTask.getPkValue().toString(), relationTask.getPkValue().toString());
        }
        List collect = sourceTaskIdMap.keySet().stream().filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcetask", "in", collect);
        filter.and(new QFilter("islatest", "=", (Object)EnableEnum.ENABLE.getValue()));
        for (DynamicObject latest : latestTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sourcetask,planstarttime,planendtime", (QFilter[])new QFilter[]{filter})) {
            String latestSourceId = latest.getDynamicObject("sourcetask").getPkValue().toString();
            relationNewTaskMap.put((String)sourceTaskIdMap.get(latestSourceId), latest);
        }
        return relationNewTaskMap;
    }

    protected boolean isBeforePlanAudit(Object orgId, Object prePlanId) {
        DynamicObject lastProCal;
        Date modifyTime;
        boolean flag = false;
        DynamicObject prePlanObj = BusinessDataServiceHelper.loadSingle((Object)prePlanId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"));
        Date auditTime = prePlanObj.getDate("auditdate");
        DynamicObject[] proCalArr = this.getProCalendar(orgId);
        if (proCalArr != null && proCalArr.length > 0 && (modifyTime = (lastProCal = proCalArr[0]).getDate("modifytime")) != null && auditTime != null && modifyTime.after(auditTime)) {
            flag = true;
        }
        return flag;
    }

    protected DynamicObject[] getProCalendar(Object orgId) {
        QFilter projectFilter = new QFilter("org", "=", orgId);
        DynamicObject[] projectCalendarArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_projworkcalendarset"), (String)"id,org,modifytime,version", (QFilter[])new QFilter[]{projectFilter}, (String)"modifytime desc");
        if (projectCalendarArr.length == 0) {
            List supOrg = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)Long.parseLong(String.valueOf(orgId)));
            if (supOrg != null && !supOrg.isEmpty() && (Long)supOrg.get(0) != 0L) {
                projectCalendarArr = this.getProCalendar(supOrg.get(0));
            } else {
                QFilter defaultVersionFilter = new QFilter(VERSION, "=", (Object)"default");
                projectCalendarArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_projworkcalendarset"), (String)"id,org,modifytime,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"modifytime desc");
                return projectCalendarArr;
            }
        }
        return projectCalendarArr;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isImport;
        String flag;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object orgId = null;
        if (null != org) {
            orgId = org.getPkValue();
        }
        if ((flag = this.getPageCache().get(ISPROPERTYCHANGED)) != null && Boolean.parseBoolean(flag)) {
            this.getPageCache().put(ISPROPERTYCHANGED, "false");
            return;
        }
        boolean bl = isImport = this.getModel().getValue("relationtask", rowIndex) != null;
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"org")) {
            this.orgValueChange(valueSet[0]);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planningcycle")) {
            this.planningCycleChange(valueSet[0]);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"timerange")) {
            this.timeRangeChange(valueSet[0]);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taskstarttimetx") && !isImport) {
            this.taskStartTimetxChange(rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taskendtimetx") && !isImport) {
            this.taskEndTimetxChange(rowIndex, orgId);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taskmubiaotx") && !isImport) {
            this.calCompTimeDeviation(rowIndex, orgId);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taskjdgqtx") && !isImport) {
            this.taskAbsolutetxChange(valueSet[0], rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"respersontx")) {
            DynamicObject resPersontx = (DynamicObject)this.getModel().getValue("respersontx", rowIndex);
            if (resPersontx == null) {
                return;
            }
            DynamicObjectCollection cooPersontx = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson", rowIndex);
            MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)resPersontx, (DynamicObjectCollection)cooPersontx);
            long resDeptId = UserServiceHelper.getUserMainOrgId((long)((Long)resPersontx.getPkValue()));
            this.getModel().setValue("resdepttx", (Object)resDeptId, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"multicooperationperson")) {
            DynamicObject resPersontx = (DynamicObject)this.getModel().getValue("respersontx", rowIndex);
            DynamicObjectCollection cooPersontx = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson", rowIndex);
            if (cooPersontx == null || cooPersontx.size() <= 0) {
                return;
            }
            MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)resPersontx, (DynamicObjectCollection)cooPersontx);
            MultiCooperationPersonUtils.writeCodeptsByCoPersons((DynamicObjectCollection)cooPersontx, (IDataModel)this.getModel(), (int)rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"transactiontype")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
            Object trans = this.getModel().getValue("transactiontype", entryCurrentRowIndex);
            boolean deleteEntry = true;
            if (null != trans) {
                DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
                for (DynamicObject tx : transactionType) {
                    Long baseDataId = tx.getLong("fbasedataid_id");
                    DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                    if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                    deleteEntry = false;
                }
            }
            if (deleteEntry) {
                this.getModel().deleteEntryData("taskresultdocentry");
            }
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
    }

    protected void taskAbsolutetxChange(ChangeData changeData, int rowIndex) {
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        if (newValue.compareTo(BigDecimal.ONE) < 0) {
            this.getModel().setValue("taskjdgqtx", (Object)oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u9700\u8981\u5927\u4e8e0\u3002", (String)"DeptPlanBillPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        this.calPlanTime("taskjdgqtx", rowIndex);
        boolean timeFlag = this.isPlanTimeIncludeTaskTime(rowIndex);
        if (!timeFlag) {
            String msg = String.format(this.getTimeNotMatchTips(), rowIndex + 1);
            this.getView().showErrorNotification(msg);
            this.getModel().setValue("taskendtimetx", null, rowIndex);
        }
    }

    protected String getTimeNotMatchTips() {
        return ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0e\u90e8\u95e8\u8ba1\u5212\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u3002", (String)"DeptPlanBillPlugin_98", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    protected boolean isPlanTimeIncludeTaskTime(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("STARTTIME");
        Date planEndTime = (Date)this.getModel().getValue("ENDTIME");
        Date taskStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        Date taskEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        if (null != planStartTime && null != planEndTime && null != taskStartTime && null != taskEndTime) {
            if (taskStartTime.equals(planStartTime) && taskEndTime.equals(planEndTime)) {
                return true;
            }
            if (!taskEndTime.before(planStartTime) && !taskStartTime.after(planEndTime)) {
                return true;
            }
        } else if (null == planStartTime || null == planEndTime || null == taskStartTime || null == taskEndTime) {
            return true;
        }
        return false;
    }

    protected void calPlanTime(String changeField, int rowIndex) {
        switch (changeField) {
            case "taskjdgqtx": {
                this.taskAbsoluteTime(rowIndex);
                break;
            }
            case "taskendtimetx": {
                this.settingParentPlanTime("taskendtimetx", rowIndex);
                this.taskEndTime(rowIndex);
                break;
            }
            case "taskstarttimetx": {
                this.settingParentPlanTime("taskstarttimetx", rowIndex);
                this.taskStartTime(rowIndex);
                break;
            }
        }
    }

    protected void taskStartTime(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("taskjdgqtx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object taskResDeptId = org.getPkValue();
        DynamicObject project = (DynamicObject)this.getModel().getValue("taskprojecttx", rowIndex);
        if (absoluteDuration != null && BigDecimal.ZERO.compareTo(absoluteDuration) == 0) {
            if (planEndTime != null) {
                try {
                    BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                    if (null != project) {
                        newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                    }
                    this.getModel().setValue("taskjdgqtx", (Object)newAbsoluteDuration, rowIndex);
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                this.getView().updateView("taskjdgqtx", rowIndex);
            }
        } else if (absoluteDuration != null && absoluteDuration.compareTo(BigDecimal.ZERO) > 0) {
            try {
                Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                if (null != project) {
                    newPlanEndTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                }
                this.getModel().setValue("taskendtimetx", (Object)newPlanEndTime, rowIndex);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            this.calCompTimeDeviation(rowIndex, taskResDeptId);
            this.getView().updateView("taskendtimetx", rowIndex);
            this.deptFenjie("taskendtimetx", rowIndex);
        }
    }

    protected void taskEndTime(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("taskjdgqtx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object taskResDeptId = org.getPkValue();
        DynamicObject project = (DynamicObject)this.getModel().getValue("taskprojecttx", rowIndex);
        if (planStartTime != null) {
            try {
                BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                if (null != project) {
                    newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                }
                this.getModel().setValue("taskjdgqtx", (Object)newAbsoluteDuration, rowIndex);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            this.getView().updateView("taskjdgqtx", rowIndex);
        } else if (absoluteDuration != null && absoluteDuration.compareTo(BigDecimal.ZERO) > 0) {
            try {
                Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                if (null != project) {
                    newPlanStartTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                }
                this.getModel().setValue("taskstarttimetx", (Object)newPlanStartTime, rowIndex);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            this.getView().updateView("taskstarttimetx", rowIndex);
            this.deptFenjie("taskstarttimetx", rowIndex);
        }
    }

    protected void taskAbsoluteTime(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("taskjdgqtx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object taskResDeptId = org.getPkValue();
        DynamicObject project = (DynamicObject)this.getModel().getValue("taskprojecttx", rowIndex);
        if (planStartTime != null) {
            try {
                Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                if (null != project) {
                    newPlanEndTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                }
                this.getModel().setValue("taskendtimetx", (Object)newPlanEndTime, rowIndex);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                this.getModel().setValue("taskjdgqtx", (Object)1, rowIndex);
            }
            this.calCompTimeDeviation(rowIndex, taskResDeptId);
            this.getModel().endInit();
            this.getView().updateView("taskendtimetx", rowIndex);
            this.deptFenjie("taskendtimetx", rowIndex);
        } else if (planEndTime != null) {
            this.getModel().beginInit();
            try {
                Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                if (null != project) {
                    newPlanStartTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                }
                this.getModel().setValue("taskstarttimetx", (Object)newPlanStartTime, rowIndex);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            this.getView().updateView("taskstarttimetx", rowIndex);
            this.deptFenjie("taskstarttimetx", rowIndex);
        }
    }

    protected void deptFenjie(String changeField, int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype", rowIndex);
        long pid = this.getModel().getEntryRowEntity("taskentity", rowIndex).getLong(TREEENTRY_PID);
        switch (changeField) {
            case "taskstarttimetx": {
                if (null == planStartTime || pid == 0L || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) break;
                Date parentStart = (Date)this.getModel().getValue("taskstarttimetx", rowIndex - 1);
                if (null == parentStart) {
                    this.getModel().beginInit();
                    this.getModel().setValue("taskstarttimetx", null, rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("taskstarttimetx", rowIndex);
                    String msg = String.format(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"DeptPlanBillPlugin_99", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1);
                    this.getView().showMessage(msg);
                    break;
                }
                if (DateUtil.compareByDay((Date)planStartTime, (Date)parentStart) >= 0) break;
                String msg = String.format(ResManager.loadKDStringExt((String)"\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u65e9\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"DeptPlanBillPlugin_100", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showMessage(msg);
                break;
            }
            case "taskendtimetx": {
                if (null == planEndTime || pid == 0L || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) break;
                Date parentEnd = (Date)this.getModel().getValue("taskendtimetx", rowIndex - 1);
                if (null == parentEnd) {
                    this.getModel().beginInit();
                    this.getModel().setValue("taskendtimetx", null, rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("taskendtimetx", rowIndex);
                    String msg = String.format(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"DeptPlanBillPlugin_101", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1);
                    this.getView().showMessage(msg);
                    break;
                }
                if (DateUtil.compareByDay((Date)planEndTime, (Date)parentEnd) <= 0) break;
                String msg = String.format(ResManager.loadKDStringExt((String)"\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u665a\u4e8e\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u3002", (String)"DeptPlanBillPlugin_102", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showMessage(msg);
                break;
            }
        }
    }

    protected void calCompTimeDeviation(int rowIndex, Object taskResDeptId) {
        Date aimFinishTime = (Date)this.getModel().getValue("taskmubiaotx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        DynamicObject project = (DynamicObject)this.getModel().getValue("taskprojecttx", rowIndex);
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        try {
            BigDecimal days = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planEndTime, (Date)aimFinishTime, (String)this.getAppId());
            if (null != project) {
                days = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime, (String)this.getAppId());
            }
            days = days.subtract(BigDecimal.ONE);
            this.getModel().setValue("tasktimepctx", (Object)days, rowIndex);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        this.settingParentPlanTime("taskmubiaotx", rowIndex);
        this.getView().updateView("tasktimepctx", rowIndex);
        this.settingEntryFieldTextColor("taskentity", "tasktimepctx", rowIndex);
    }

    protected void settingEntryFieldTextColor(String entryEntity, String fieldName, int curIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)this.getModel().getValue(fieldName, curIndex);
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntity);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(curIndex);
        statusStyle.setFieldKey(fieldName);
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            statusStyle.setForeColor("#FF0000");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            statusStyle.setForeColor("#00DD2C");
        } else {
            statusStyle.setForeColor("#666");
        }
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    protected void taskEndTimetxChange(int rowIndex, Object orgId) {
        boolean isPlanTimeIncludeTaskTime;
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        Date taskStartTime = (Date)this.getModel().getValue("STARTTIME");
        Date taskEndTime = (Date)this.getModel().getValue("ENDTIME");
        if (planStartTime != null && planEndTime != null && DateUtil.compareByDay((Date)planEndTime, (Date)planStartTime) < 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"DeptPlanBillPlugin_103", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("taskendtimetx", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("taskendtimetx", rowIndex);
            return;
        }
        if (null != taskStartTime && null != taskEndTime && planStartTime != null && planEndTime != null && !(isPlanTimeIncludeTaskTime = this.isPlanTimeIncludeTaskTime(rowIndex))) {
            String msg = String.format(this.getTimeNotMatchTips(), rowIndex + 1);
            this.getView().showErrorNotification(msg);
            this.getModel().setValue("taskendtimetx", null, rowIndex);
            return;
        }
        if (planEndTime != null) {
            this.calPlanTime("taskendtimetx", rowIndex);
            this.deptFenjie("taskendtimetx", rowIndex);
            this.calCompTimeDeviation(rowIndex, orgId);
        }
    }

    protected void taskStartTimetxChange(int rowIndex) {
        boolean isPlanTimeIncludeTaskTime;
        Date planStartTime = (Date)this.getModel().getValue("taskstarttimetx", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("taskendtimetx", rowIndex);
        Date taskStartTime = (Date)this.getModel().getValue("STARTTIME");
        Date taskEndTime = (Date)this.getModel().getValue("ENDTIME");
        if (null != taskStartTime && null != taskEndTime && planStartTime != null && planEndTime != null && !(isPlanTimeIncludeTaskTime = this.isPlanTimeIncludeTaskTime(rowIndex))) {
            String msg = String.format(this.getTimeNotMatchTips(), rowIndex + 1);
            this.getView().showErrorNotification(msg);
            this.getModel().setValue("taskstarttimetx", null, rowIndex);
            return;
        }
        if (planStartTime != null) {
            this.calPlanTime("taskstarttimetx", rowIndex);
            this.deptFenjie("taskstarttimetx", rowIndex);
        }
    }

    protected void timeRangeChange(ChangeData changeData) {
        this.setStartEndTime();
        Date oldTimeRange = (Date)changeData.getOldValue();
        boolean isPlanConflict = this.justOnePlan("timerange", oldTimeRange);
        if (isPlanConflict) {
            this.getView().showMessage(this.getDeptPlanExistTips());
            return;
        }
        if (null != oldTimeRange) {
            this.getPageCache().put("oldTimeRange", DateUtil.formatShortDate((Date)oldTimeRange));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6539\u53d8\u5f00\u59cb\u65f6\u95f4\u8303\u56f4\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DeptPlanBillPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SWITCH_TIMERANGE));
        } else {
            this.monthOrWeekInsertTask();
            this.autoName();
        }
    }

    protected String getDeptPlanExistTips() {
        return ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5728\u8be5\u65f6\u95f4\u6bb5\u5df2\u5b58\u5728\u90e8\u95e8\u8ba1\u5212\uff0c\u65e0\u6cd5\u91cd\u590d\u5236\u5b9a\u3002", (String)"DeptPlanBillPlugin_104", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    protected void monthOrWeekInsertTask() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object planningcycle = this.getModel().getValue("planningcycle");
        Object startTime = this.getModel().getValue("STARTTIME");
        Object endTime = this.getModel().getValue("ENDTIME");
        if (null != planningcycle) {
            String planCycle = planningcycle.toString();
            if (planCycle.equalsIgnoreCase(PlanningCycleEnum.MONTH.getValue()) || planCycle.equalsIgnoreCase(PlanningCycleEnum.WEEK.getValue())) {
                if (null != startTime && null != endTime && null != org) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTPROJECTTASK});
                    Object orgId = org.getPkValue();
                    QFilter filterDept = new QFilter("responsibledept", "=", orgId).or("multicooperationdept.fbasedataid.id", "=", orgId);
                    QFilter time1 = new QFilter("planstarttime", ">=", startTime).and(new QFilter("planstarttime", "<=", endTime));
                    QFilter time2 = new QFilter("planendtime", ">=", startTime).and(new QFilter("planendtime", "<=", endTime));
                    QFilter time3 = new QFilter("planstarttime", "<=", startTime).and(new QFilter("planendtime", ">=", endTime));
                    QFilter jJtime = time1.or(time2).or(time3);
                    QFilter beginTime = new QFilter("planendtime", "<=", startTime);
                    QFilter time = jJtime.or(beginTime);
                    QFilter completionStatus = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue()).and("completionstatus", "<>", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                    QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
                    QFilter projectTaskFilter = this.getProjectTaskFilter();
                    QFilter[] filters = new QFilter[]{projectTaskFilter, completionStatus, time, filterDept, latestTaskFilter};
                    DynamicObject deptPlanType = this.getDeptTaskSource();
                    DynamicObject[] importTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])filters);
                    this.fillEntryByRelationTask(importTasks);
                    TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("taskentity");
                    this.modifyTabName(TOTALTABPAGEAP, "taskentity");
                    treeEntryGrid.setCollapse(false);
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{IMPORTPROJECTTASK});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMPORTPROJECTTASK});
            this.getModel().updateCache();
            this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        }
        this.lockEntry();
    }

    protected boolean justOnePlan(String fieldName, Object oldValue) {
        BigDecimal version = (BigDecimal)this.getModel().getValue(VERSION);
        int intVsrsion = version.intValue();
        if (1 == intVsrsion) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Object planningcycle = this.getModel().getValue("planningcycle");
            Object startTime = this.getModel().getValue("STARTTIME");
            Object endTime = this.getModel().getValue("ENDTIME");
            if (null != planningcycle && null != org && null != startTime && null != endTime) {
                QFilter time1 = new QFilter("STARTTIME", "<=", startTime).and(new QFilter("ENDTIME", ">=", startTime));
                QFilter time2 = new QFilter("STARTTIME", "<=", endTime).and(new QFilter("ENDTIME", ">=", endTime));
                QFilter time3 = new QFilter("STARTTIME", ">=", startTime).and(new QFilter("ENDTIME", "<=", endTime));
                QFilter timeFilter = time1.or(time2).or(time3);
                QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("planningcycle", "=", planningcycle), new QFilter(VERSION, "=", (Object)version), timeFilter};
                DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"id", (QFilter[])filters);
                if (null != plans && plans.length == 1 && !StringUtils.equalsIgnoreCase((CharSequence)plans[0].getPkValue().toString(), (CharSequence)this.getModel().getDataEntity().get("id").toString())) {
                    this.getModel().beginInit();
                    this.getPageCache().put(ISPROPERTYCHANGED, "true");
                    this.getModel().setValue(fieldName, oldValue);
                    this.setDateEditRange();
                    this.getModel().endInit();
                    this.getView().updateView(fieldName);
                    this.setStartEndTime();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected void setStartEndTime() {
        String planningcycle = (String)this.getModel().getValue("planningcycle");
        Date timeRange = (Date)this.getModel().getValue("timerange");
        Date start = null;
        Date end = null;
        if (null != timeRange) {
            if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.YEAR.getValue())) {
                start = DateUtil.getYearFirst((Date)timeRange);
                end = DateUtil.getYearLast((Date)timeRange);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.HALFYEAR.getValue())) {
                start = DateUtil.getHalfYearStartTime((Date)timeRange);
                end = DateUtil.getHalfYearEndTime((Date)timeRange);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.QUART.getValue())) {
                start = DateUtil.getQuarterStartTime((Date)timeRange);
                end = DateUtil.getQuarterEndTime((Date)timeRange);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.MONTH.getValue())) {
                start = DateUtil.getFirstDayOfThisMonth((Date)timeRange);
                end = DateUtil.getLastDayOfThisMonth((Date)timeRange);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.WEEK.getValue())) {
                start = DateUtil.getThisWeekMonday((Date)timeRange);
                end = DateUtil.getThisWeekSunDay((Date)timeRange);
            }
        }
        this.getModel().setValue("STARTTIME", start);
        this.getModel().setValue("ENDTIME", end);
    }

    protected void planningCycleChange(ChangeData changeData) {
        String oldPlanningcycle = (String)changeData.getOldValue();
        this.setStartEndTime();
        boolean isPlanConflict = this.justOnePlan("planningcycle", oldPlanningcycle);
        if (isPlanConflict) {
            this.getView().showMessage(this.getDeptPlanExistTips());
            return;
        }
        if (null != oldPlanningcycle) {
            this.getPageCache().put("oldPlanningcycle", oldPlanningcycle);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6539\u53d8\u8ba1\u5212\u5468\u671f\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DeptPlanBillPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SWITCH_PLANNINGCYCLE));
        } else {
            this.monthOrWeekInsertTask();
            this.autoName();
        }
    }

    protected void orgValueChange(ChangeData changeData) {
        boolean isPlanConflict;
        DynamicObject oldOrg = (DynamicObject)changeData.getOldValue();
        String oldOrgId = null;
        if (oldOrg != null) {
            oldOrgId = oldOrg.getPkValue().toString();
        }
        if (isPlanConflict = this.justOnePlan("org", oldOrgId)) {
            this.getView().showMessage(this.getDeptPlanExistTips());
            return;
        }
        if (oldOrg != null) {
            oldOrgId = oldOrg.getPkValue().toString();
            this.getPageCache().put("oldOrgId", oldOrgId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6539\u53d8\u6240\u5c5e\u7ec4\u7ec7\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DeptPlanBillPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SWITCH_ORG));
        } else {
            this.monthOrWeekInsertTask();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = grid.getSelectRows();
        if (StringUtils.equals((CharSequence)"projecttask", (CharSequence)key)) {
            this.importProjectTask(args);
        } else if (StringUtils.equals((CharSequence)UPDATEENTRY, (CharSequence)key)) {
            this.updateEntry(args, selRows);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.beforeDoSaveAndSubmit(args);
        } else if (StringUtils.equals((CharSequence)"newentrytext", (CharSequence)key)) {
            this.newEntryText(args, grid);
        } else if (StringUtils.equals((CharSequence)"inserttaskentry", (CharSequence)key)) {
            this.newLowerEntryText(args, grid, selRows);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"viewtaskdetail", (CharSequence)key)) {
            this.doViewTaskDetail(selRows);
        } else if (StringUtils.equals((CharSequence)"upgrade", (CharSequence)key)) {
            this.doUpgrade(args, grid, selRows);
        } else if (StringUtils.equals((CharSequence)"downgrade", (CharSequence)key)) {
            this.doDowngrade(args, grid, selRows);
        } else if (StringUtils.equals((CharSequence)"moveentryup", (CharSequence)key)) {
            this.doMoveEntryUp(selRows);
        } else if (StringUtils.equals((CharSequence)"moveentrydown", (CharSequence)key)) {
            this.doMoveEntryDown(selRows);
        } else if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)key)) {
            this.beforeDeleteEntry(args);
        }
    }

    protected void beforeDeleteEntry(BeforeDoOperationEventArgs args) {
        int[] selectRowsIndex;
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        for (int selectRowIndex : selectRowsIndex = grid.getSelectRows()) {
            DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRowIndex);
            DynamicObject prechangeTask = entry.getDynamicObject("prechangetask");
            if (prechangeTask == null) {
                return;
            }
            Set<Object> relationIds = this.getSameSourceTaskIds(prechangeTask.getPkValue());
            QFilter[] qFilters = new QFilter[]{new QFilter("relationtask", "in", relationIds)};
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])qFilters);
            if (tasks == null || tasks.length == 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u4e2a\u4eba\u8ba1\u5212\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DeptPlanBillPlugin_105", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private Set<Object> getSameSourceTaskIds(Object pkValue) {
        HashSet<Object> idSet = new HashSet<Object>(10);
        idSet.add(pkValue);
        DynamicObject preTask = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject sourceTask = preTask.getDynamicObject("sourcetask");
        if (sourceTask != null) {
            DynamicObject[] relationTasks;
            idSet.add(sourceTask.getPkValue());
            QFilter filter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            filter.and(new QFilter("id", "!=", pkValue));
            for (DynamicObject task : relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{filter})) {
                idSet.add(task.getPkValue());
            }
        }
        return idSet;
    }

    protected void doMoveEntryDown(int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"DeptPlanBillPlugin_25", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TreeEntryUtils.isAllowMoveDown((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            return;
        }
        int pIndex = this.getParentRowIndex(selRows[0]);
        int bIndex = this.getYoungerBrotherIndex(selRows[0]);
        this.getPageCache().put(PARENT_INDEX, String.valueOf(pIndex));
        this.getPageCache().put(BROTHER_INDEX, String.valueOf(bIndex));
    }

    protected int getYoungerBrotherIndex(int row) {
        DynamicObject parentRowEntity = this.getModel().getEntryRowEntity("taskentity", row);
        String parentEntryId = String.valueOf(parentRowEntity.get(TREEENTRY_PID));
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (!StringUtils.equalsIgnoreCase((CharSequence)parentEntryId, (CharSequence)"0")) {
            int nextIndex = 0;
            int nextCount = 0;
            for (int i = row + 1; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                String pid = String.valueOf(rowEntity.get(TREEENTRY_PID));
                if (!StringUtils.equalsIgnoreCase((CharSequence)pid, (CharSequence)parentEntryId)) continue;
                if (nextIndex != 0) {
                    nextCount = i - nextIndex;
                    break;
                }
                nextIndex = i;
            }
            if (nextCount == 0) {
                nextCount = rowCount - nextIndex;
            }
            return row + nextCount;
        }
        int nextIndex = 0;
        int nextCount = 0;
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
            String pid = String.valueOf(rowEntity.get(TREEENTRY_PID));
            if (!StringUtils.equalsIgnoreCase((CharSequence)pid, (CharSequence)"0")) continue;
            if (nextIndex != 0) {
                nextCount = i - nextIndex;
                break;
            }
            nextIndex = i;
        }
        if (nextCount == 0) {
            nextCount = rowCount - nextIndex;
        }
        return row + nextCount;
    }

    protected int getParentRowIndex(int row) {
        boolean isImport;
        DynamicObject currentRow = this.getModel().getEntryRowEntity("taskentity", row);
        long currentPid = currentRow.getLong(TREEENTRY_PID);
        boolean bl = isImport = this.getModel().getValue("relationtask", row) != null;
        if (currentPid != 0L && !isImport) {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                if (Long.parseLong(rowEntity.getPkValue().toString()) != currentPid) continue;
                return i;
            }
        }
        return 0;
    }

    protected void doMoveEntryUp(int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"DeptPlanBillPlugin_25", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TreeEntryUtils.isAllowMoveUp((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            return;
        }
        int parentIndex = this.getParentRowIndex(selRows[0]);
        int brotherIndex = this.getOlderBrotherIndex(selRows[0]);
        this.getPageCache().put(PARENT_INDEX, String.valueOf(parentIndex));
        this.getPageCache().put(BROTHER_INDEX, String.valueOf(brotherIndex));
    }

    protected int getOlderBrotherIndex(int row) {
        DynamicObject currentRow = this.getModel().getEntryRowEntity("taskentity", row);
        String currentPid = currentRow.getString(TREEENTRY_PID);
        if (!StringUtils.equalsIgnoreCase((CharSequence)currentPid, (CharSequence)"0")) {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                String pid = rowEntity.getString(TREEENTRY_PID);
                if (!StringUtils.equalsIgnoreCase((CharSequence)pid, (CharSequence)currentPid)) continue;
                return i;
            }
        } else {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                String pid = rowEntity.getString(TREEENTRY_PID);
                if (!StringUtils.equalsIgnoreCase((CharSequence)pid, (CharSequence)"0")) continue;
                return i;
            }
        }
        return 0;
    }

    protected void doDowngrade(BeforeDoOperationEventArgs args, TreeEntryGrid grid, int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u964d\u7ea7\u7684\u884c\u3002", (String)"DeptPlanBillPlugin_106", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u964d\u7ea7\u4efb\u52a1\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"DeptPlanBillPlugin_107", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isImport = this.isImportTask(selRows);
        if (isImport) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5f15\u5165\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"DeptPlanBillPlugin_27", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isPorject = this.isProjectTask(selRows);
        if (isPorject) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u9879\u76ee\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"DeptPlanBillPlugin_108", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isPercent = this.isPercentTask(selRows);
        if (isPercent) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6216\u4efb\u52a1\u5305\u542b\u7684\u5b50\u7ea7\u4efb\u52a1\u7684\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"DeptPlanBillPlugin_109", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)this.getAppId());
        int curIndex = selRows[0];
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", curIndex);
        if (row.getDate("taskstarttimetx") != null) {
            this.settingParentPlanTime("taskstarttimetx", curIndex);
        }
        if (row.getDate("taskendtimetx") != null) {
            this.settingParentPlanTime("taskendtimetx", curIndex);
        }
        grid.setCollapse(false);
        this.lockEntry();
    }

    protected boolean isPercentTask(int[] selRows) {
        for (int row : selRows) {
            if (this.isTaskPercentCompleted(row)) {
                return true;
            }
            int lastChildIndex = this.getLastChildIndex(row);
            for (int i = row + 1; i <= lastChildIndex; ++i) {
                if (!this.isTaskPercentCompleted(i)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTaskPercentCompleted(int rowIndex) {
        BigDecimal percent = (BigDecimal)this.getModel().getValue("percent", rowIndex);
        return percent.compareTo(BigDecimal.valueOf(100L)) == 0;
    }

    protected int getLastChildIndex(int seq) {
        DynamicObject rowEntity;
        String curParentId;
        DynamicObject parentTask = this.getModel().getEntryRowEntity("taskentity", seq);
        int lastChildIndex = seq;
        HashSet<String> parentIdSet = new HashSet<String>();
        parentIdSet.add(parentTask.getPkValue().toString());
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = seq + 1; i < rowCount && parentIdSet.contains(curParentId = (rowEntity = this.getModel().getEntryRowEntity("taskentity", i)).getString(TREEENTRY_PID)); ++i) {
            parentIdSet.add(rowEntity.getPkValue().toString());
            ++lastChildIndex;
        }
        return lastChildIndex;
    }

    protected boolean isProjectTask(int[] selRows) {
        for (int row : selRows) {
            if (null == this.getModel().getValue("taskprojecttx", row)) continue;
            return true;
        }
        return false;
    }

    protected boolean isImportTask(int[] selRows) {
        for (int row : selRows) {
            boolean isimport;
            boolean bl = isimport = this.getModel().getValue("relationtask", row) != null;
            if (!isimport) continue;
            return true;
        }
        return false;
    }

    protected void doUpgrade(BeforeDoOperationEventArgs args, TreeEntryGrid grid, int[] selRows) {
        int parentIndex;
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u884c\u3002", (String)"DeptPlanBillPlugin_110", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c\u3002", (String)"DeptPlanBillPlugin_80", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isImport = this.isImportTask(selRows);
        if (isImport) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5f15\u5165\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"DeptPlanBillPlugin_81", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isPorject = this.isProjectTask(selRows);
        if (isPorject) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u9879\u76ee\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"DeptPlanBillPlugin_111", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isPercent = this.isPercentTask(selRows);
        if (isPercent) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6216\u4efb\u52a1\u5305\u542b\u7684\u5b50\u7ea7\u4efb\u52a1\u7684\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"DeptPlanBillPlugin_112", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        String parentPk = task.getString(TREEENTRY_PID);
        for (int index = parentIndex = curIndex - 1; index >= 0; --index) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            if (!StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)parentPk)) continue;
            parentIndex = index;
            break;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)this.getAppId());
        this.settingTimeByChildren(parentIndex);
        grid.setCollapse(false);
        this.lockEntry();
    }

    protected void doViewTaskDetail(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"DeptPlanBillPlugin_113", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DeptPlanBillPlugin_114", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (task != null) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"DeptPlanBillPlugin_95", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", task.getPkValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void openUpdateParameter(String operRation, int rowIndex) {
        Object endTime;
        Object startTime;
        if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
            return;
        }
        String id = this.getModel().getEntryRowEntity("taskentity", rowIndex).getPkValue().toString();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            map.put("deptId", org.getPkValue().toString());
        }
        if (null != (startTime = this.getModel().getValue("STARTTIME"))) {
            map.put("starttime", startTime);
        }
        if (null != (endTime = this.getModel().getValue("ENDTIME"))) {
            map.put("endtime", endTime);
        }
        boolean isImport = this.getModel().getValue("relationtask", rowIndex) != null;
        map.put("isImport", isImport);
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype", rowIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue())) {
            map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptprojecttasktk"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue())) {
            map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"depttask"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) {
            if (null != this.getModel().getValue("taskprojecttx", rowIndex)) {
                map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            } else {
                map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"depttasktk"));
            }
        }
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setAppId(this.getAppId());
        if (StringUtils.equals((CharSequence)operRation, (CharSequence)"view")) {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else if (StringUtils.equals((CharSequence)operRation, (CharSequence)"edit")) {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (null != map.get(FORM_ID) && StringUtils.equalsIgnoreCase((CharSequence)map.get(FORM_ID).toString(), (CharSequence)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"depttasktk"))) {
                StyleCss css = new StyleCss();
                css.setHeight("610px");
                css.setWidth("1050px");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPDATEENTRY));
        }
        boolean isPercent = this.isTaskPercentCompleted(rowIndex);
        if (isPercent) {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        ((BillShowParameter)parameter).setPkId((Object)id);
        this.getView().showForm(parameter);
    }

    protected String getUnsaveTips() {
        return ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"DeptPlanBillPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    protected void newEntryText(BeforeDoOperationEventArgs args, TreeEntryGrid grid) {
        if (!this.checkNull()) {
            args.setCancel(true);
            return;
        }
        int index = this.getModel().createNewEntryRow("taskentity");
        this.createTaskAndSave(index, PlanTypeEnum.DEPTPLAN.getValue(), false, 0);
        grid.setCollapse(false);
    }

    protected void newLowerEntryText(BeforeDoOperationEventArgs args, TreeEntryGrid grid, int[] selRows) {
        if (!this.checkNull()) {
            args.setCancel(true);
            return;
        }
        if (selRows.length != 0) {
            int index = selRows[0];
            DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", index);
            DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
            if (taskEntries == null || taskEntries.isEmpty()) {
                return;
            }
            String entryId = entry.getPkValue().toString();
            DynamicObject relateTask = entry.getDynamicObject("relationtask");
            if (relateTask != null && !relateTask.getBoolean("isleaf")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5728\u5bf9\u5e94\u8ba1\u5212\u7f16\u5236\u4e2d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u4efb\u52a1\u3002", (String)"DeptPlanBillPlugin_36", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int i = index + 1; i < taskEntries.size(); ++i) {
                String parentId = ((DynamicObject)taskEntries.get(i)).get(TREEENTRY_PID).toString();
                if (parentId == null || !entryId.equals(parentId) || ((DynamicObject)taskEntries.get(i)).getDynamicObject("relationtask") == null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5728\u5bf9\u5e94\u8ba1\u5212\u7f16\u5236\u4e2d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u4efb\u52a1\u3002", (String)"DeptPlanBillPlugin_36", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.newChildTaskWithTaskEntry(args, grid, selRows);
        }
    }

    protected void newChildTaskWithTaskEntry(BeforeDoOperationEventArgs args, TreeEntryGrid grid, int[] selRows) {
        if (selRows.length > 1) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u53d6\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u65b0\u589e\u5b50\u7ea7\u3002", (String)"DeptPlanBillPlugin_85", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isPercent = this.isTaskPercentCompleted(selRows[0]);
        if (isPercent) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u4e3a\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5b50\u7ea7\u3002", (String)"DeptPlanBillPlugin_38", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int parentLevel = (Integer)this.getModel().getValue(LEVEL, selRows[0]);
        int curRowLevel = parentLevel + 1;
        int index = this.getModel().insertEntryRow("taskentity", selRows[0]);
        this.getModel().setValue(LEVEL, (Object)curRowLevel, index);
        this.getModel().setValue("isleaf", (Object)Boolean.FALSE, selRows[0]);
        DynamicObject taskSource = (DynamicObject)this.getModel().getValue("tasksource", selRows[0]);
        QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
        DynamicObject parentRelationTask = (DynamicObject)this.getModel().getValue("relationtask", selRows[0]);
        if (parentRelationTask != null) {
            if (this.getModel().getValue("taskprojecttx", selRows[0]) != null) {
                this.createTaskAndSave(index, PlanTypeEnum.DEPTFENJIEPLAN.getValue(), true, selRows[0]);
            } else {
                this.createTaskAndSave(index, PlanTypeEnum.DEPTFENJIEPLAN.getValue(), false, selRows[0]);
            }
        } else if (null != taskSource && taskSource.getPkValue().toString().equals(majorType.getPkValue().toString())) {
            if (this.getModel().getValue("taskprojecttx", selRows[0]) != null) {
                this.createTaskAndSave(index, PlanTypeEnum.DEPTFENJIEPLAN.getValue(), true, selRows[0]);
            } else {
                this.createTaskAndSave(index, PlanTypeEnum.DEPTFENJIEPLAN.getValue(), false, selRows[0]);
            }
        } else {
            this.createTaskAndSave(index, PlanTypeEnum.DEPTPLAN.getValue(), false, selRows[0]);
        }
        grid.setCollapse(false);
    }

    protected void createTaskAndSave(int index, String type, boolean isproject, int parentIndex) {
        BigDecimal version = (BigDecimal)this.getModel().getValue(VERSION);
        this.getModel().setValue("taskversion", (Object)version, index);
        if (!isproject && StringUtils.equalsIgnoreCase((CharSequence)PlanTypeEnum.DEPTPLAN.getValue(), (CharSequence)type)) {
            this.initDeptTask(index);
        } else if (isproject && StringUtils.equalsIgnoreCase((CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue(), (CharSequence)type)) {
            this.initProjectSplitTask(index, parentIndex);
        } else if (!isproject && StringUtils.equalsIgnoreCase((CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue(), (CharSequence)type)) {
            this.initDeptSplitTask(index);
        }
        this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        this.lockEntry();
    }

    protected void initDeptSplitTask(int index) {
        DynamicObject taskSource = this.getDeptSplitTaskSource();
        this.getModel().setValue("belongplantype", (Object)this.getDeptPlanType(), index);
        this.getModel().setValue("tasksource", taskSource.getPkValue(), index);
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.ROUTINEWORK.getValue())});
        this.getModel().setValue("tasktype", taskType.getPkValue(), index);
    }

    protected void initDeptTask(int index) {
        DynamicObject taskSource = this.getDeptTaskSource();
        this.getModel().setValue("belongplantype", (Object)this.getDeptPlanType(), index);
        this.getModel().setValue("tasksource", taskSource.getPkValue(), index);
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.ROUTINEWORK.getValue())});
        this.getModel().setValue("tasktype", taskType.getPkValue(), index);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            this.getModel().setValue("resdepttx", org.getPkValue(), index);
        }
    }

    protected void initProjectSplitTask(int index, int parentIndex) {
        DynamicObject taskSource = this.getDeptSplitTaskSource();
        this.getModel().setValue("belongplantype", (Object)this.getDeptPlanType(), index);
        this.getModel().setValue("tasksource", taskSource.getPkValue(), index);
        DynamicObject parent = this.getModel().getEntryRowEntity("taskentity", parentIndex);
        if (parent.get("taskcontrolleveltx") != null) {
            this.getModel().setValue("taskcontrolleveltx", parent.getDynamicObject("taskcontrolleveltx").getPkValue(), index);
        }
        if (parent.get("majortype") != null) {
            this.getModel().setValue("majortype", parent.getDynamicObject("majortype").getPkValue(), index);
        }
        if (parent.get("tasktype") != null) {
            this.getModel().setValue("tasktype", parent.getDynamicObject("tasktype").getPkValue(), index);
        }
        if (parent.get("taskprojecttx") != null) {
            this.getModel().setValue("taskprojecttx", parent.getDynamicObject("taskprojecttx").getPkValue(), index);
        }
        this.getModel().setValue("tasktimepctx", parent.get("tasktimepctx"), index);
    }

    protected DynamicObject getDeptSplitTaskSource() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue())});
    }

    protected DynamicObject getDeptTaskSource() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTPLAN.getValue())});
    }

    protected DynamicObject getDeptPlanType() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (String)"", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTPLAN.getValue())});
    }

    protected boolean checkNull() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u7ec4\u7ec7\u3002", (String)"DeptPlanBillPlugin_86", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object planningcycle = this.getModel().getValue("planningcycle");
        if (null == planningcycle) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u5468\u671f\u3002", (String)"DeptPlanBillPlugin_87", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object timerange = this.getModel().getValue("timerange");
        if (null == timerange) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u59cb\u65f6\u95f4\u3002", (String)"DeptPlanBillPlugin_88", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object startTime = this.getModel().getValue("STARTTIME");
        Object endTime = this.getModel().getValue("ENDTIME");
        if (null == startTime || null == endTime) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u8303\u56f4\u3002", (String)"DeptPlanBillPlugin_89", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object name = this.getModel().getValue("name");
        if (null == name || StringUtils.equalsIgnoreCase((CharSequence)"", (CharSequence)name.toString())) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u540d\u79f0\u3002", (String)"DeptPlanBillPlugin_90", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void beforeDoSaveAndSubmit(BeforeDoOperationEventArgs args) {
        if (!this.checkNull()) {
            args.setCancel(true);
            return;
        }
        boolean isPlanConflict = this.justOnePlan("timerange", null);
        if (isPlanConflict) {
            this.getView().showMessage(this.getDeptPlanExistTips());
            args.setCancel(true);
        }
    }

    protected void updateEntry(BeforeDoOperationEventArgs args, int[] selRows) {
        if (selRows == null || selRows.length != 1) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8bb0\u5f55\u3002", (String)"DeptPlanBillPlugin_115", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isPercent = this.isTaskPercentCompleted(selRows[0]);
        if (isPercent) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u4e3a\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DeptPlanBillPlugin_45", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.openUpdateParameter("edit", selRows[0]);
    }

    protected void importProjectTask(BeforeDoOperationEventArgs args) {
        if (!this.checkNull()) {
            args.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object startTime = this.getModel().getValue("STARTTIME");
        Object endTime = this.getModel().getValue("ENDTIME");
        QFilter completionstatus1 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        QFilter completionstatus2 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
        QFilter projectTaskFilter = this.getProjectTaskFilter();
        QFilter filterProject = new QFilter("project", "<>", (Object)0L);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        QFilter time1 = new QFilter("planstarttime", ">=", startTime).and(new QFilter("planstarttime", "<=", endTime));
        QFilter time2 = new QFilter("planendtime", ">=", startTime).and(new QFilter("planendtime", "<=", endTime));
        QFilter time3 = new QFilter("planstarttime", "<=", startTime).and(new QFilter("planendtime", ">=", endTime));
        QFilter jJtime = time1.or(time2).or(time3);
        QFilter beginTime = new QFilter("planendtime", "<=", startTime);
        QFilter timeFilter = jJtime.or(beginTime);
        Object orgId = org.getPkValue();
        List childOrgs = OrgServiceHelper.getAllSubordinateOrgs((long)((Long)orgId), (boolean)true);
        QFilter deptFilter = new QFilter("responsibledept", "=", orgId).or("multicooperationdept.fbasedataid.id", "=", orgId);
        ArrayList<Object> importedTaskIds = new ArrayList<Object>(10);
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            if (this.getModel().getValue("relationtask", i) == null) continue;
            DynamicObject task = (DynamicObject)this.getModel().getValue("relationtask", i);
            importedTaskIds.add(task.getPkValue());
        }
        QFilter taskFilter = new QFilter("id", "not in", importedTaskIds);
        QFilter filter = completionstatus1.and(completionstatus2).and(projectTaskFilter).and(latestTaskFilter).and(filterProject).and(timeFilter).and(deptFilter).and(taskFilter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FORM_ID, this.getAppId() + "_taskimportf7");
        map.put("deptid", orgId);
        map.put("filter", SerializeHelper.serialize((Object)filter));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f15\u5165\u9879\u76ee\u8ba1\u5212", (String)"DeptPlanBillPlugin_46", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        StyleCss css = new StyleCss();
        css.setHeight("800px");
        css.setWidth("1500px");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTPROJECTTASK));
        this.getView().showForm(showParameter);
    }

    protected QFilter getProjectTaskFilter() {
        QFilter filter = new QFilter("belongplantype.plantype", "<>", (Object)PlanTypeEnum.PRIVATEPLAN.getValue());
        filter.or(new QFilter("tasksource.number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue()));
        filter.or(new QFilter("meettask", "is not null", null));
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (UPDATEENTRY.equals(actionId)) {
            Integer entityRowIndex = Integer.parseInt(((Map)e.getReturnData()).get("seq").toString()) - 1;
            DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity("taskentity");
            DynamicObject oldNewDataEntry = (DynamicObject)entryEntityCollection.get(entityRowIndex.intValue());
            String taskId = oldNewDataEntry.getString("id");
            DynamicObject newDataEntry = BusinessDataServiceHelper.loadSingle((Object)taskId, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            this.fillTaskEntry(oldNewDataEntry, newDataEntry);
            entryEntityCollection.set(entityRowIndex.intValue(), (Object)oldNewDataEntry);
            this.getModel().setValue("taskentity", (Object)entryEntityCollection);
            this.getView().updateView("taskentity");
        } else if (IMPORTPROJECTTASK.equals(actionId) && null != e.getReturnData()) {
            this.afterImportProjectTaskCallBack(e);
        } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog").equalsIgnoreCase(actionId) && StringUtils.isNotBlank((Object)(returnData = e.getReturnData()))) {
            DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
            DealWithEntryDataUtils.updateEntryLevelData((DynamicObjectCollection)tasks);
            this.getModel().deleteEntryData("taskentity");
            this.getModel().updateCache();
            this.getModel().updateEntryCache(tasks);
            this.getView().updateView("taskentity");
            this.getView().invokeOperation("save");
            this.modifyTabName(TOTALTABPAGEAP, "taskentity");
            this.setTaskLeaf();
            this.getView().invokeOperation("refresh");
            DynamicObject deptPlan = this.getPersonPlanType();
            for (int i = 0; i < tasks.size(); ++i) {
                this.getView().getModel().setValue("tasksource", (Object)deptPlan, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"transactiontype"});
            }
            TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
            entryTree.setCollapse(false);
        }
        this.lockEntry();
    }

    protected DynamicObject getPersonPlanType() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)ID_PLANTYPE_PLANTYPENAME, (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTPLAN.getValue())});
    }

    protected void afterImportProjectTaskCallBack(ClosedCallBackEvent e) {
        List taskIds = (List)e.getReturnData();
        DynamicObject[] importTasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        this.fillEntryByProjectTask(importTasks);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("taskentity");
        this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        treeEntryGrid.setCollapse(false);
        this.getModel().updateCache();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "deleteentry": {
                this.doDeleteEntry();
                break;
            }
            case "moveentryup": {
                this.afterMoveEntry();
                break;
            }
            case "moveentrydown": {
                this.afterMoveEntry();
                break;
            }
            case "upgrade": {
                this.rebuildTreeStructure();
                this.getView().updateView("taskentity");
                break;
            }
            case "importdepttask": {
                if (this.getModel().getDataEntity().getPkValue().equals(0L)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"DeptPlanBillPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u4efb\u52a1\u5c06\u8986\u76d6\u73b0\u6709\u975e\u5f15\u5165\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DeptPlanBillPlugin_116", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importdepttask"));
                break;
            }
            case "exportexcel": {
                DeptPlanTaskImpAndExpUtil deptUtil = new DeptPlanTaskImpAndExpUtil(this.getView());
                deptUtil.exportDeptModel(this.getView(), true, "taskentity");
                break;
            }
            case "audit": {
                this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
                this.getView().updateView("assigner");
                break;
            }
        }
    }

    protected PlanTaskImpAndExpUtil getUtil() {
        return new PlanTaskImpAndExpUtil(this.getView());
    }

    protected void rebuildTreeStructure() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        if (entries.isEmpty()) {
            return;
        }
        HashSet<String> pidSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            String pid = entry.getString(TREEENTRY_PID);
            if (pid == null) continue;
            pidSet.add(pid);
        }
        for (int index = 0; index < entries.size(); ++index) {
            DynamicObject entry;
            entry = (DynamicObject)entries.get(index);
            String id = entry.getPkValue().toString();
            if (pidSet.contains(id)) {
                this.getModel().setValue("isleaf", (Object)Boolean.FALSE, index);
                continue;
            }
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
            this.getModel().getEntryRowEntity("taskentity", index).set("isGroupNode", (Object)Boolean.FALSE);
        }
    }

    protected void afterMoveEntry() {
        this.getModel().updateCache();
        String parentIndex = this.getPageCache().get(PARENT_INDEX);
        String brotherIndex = this.getPageCache().get(BROTHER_INDEX);
        if (parentIndex != null && brotherIndex != null) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
            grid.selectRows(Integer.parseInt(brotherIndex));
            grid.focus(Integer.parseInt(parentIndex), Integer.parseInt(brotherIndex));
            grid.setCollapse(false);
            this.getPageCache().remove(PARENT_INDEX);
            this.getPageCache().remove(BROTHER_INDEX);
        }
        this.lockEntry();
    }

    protected void doDeleteEntry() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length <= 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"DeptPlanBillPlugin_117", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < selRows.length; ++i) {
            String nextRowParentId;
            String currentTaskId;
            int rowIndex = selRows[i];
            boolean isPercnet = this.isTaskPercentCompleted(rowIndex);
            if (isPercnet) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeptPlanBillPlugin_93", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rowCount < rowIndex + 1 || !StringUtils.equalsIgnoreCase((CharSequence)(currentTaskId = this.getModel().getEntryRowEntity("taskentity", rowIndex).getPkValue().toString()), (CharSequence)(nextRowParentId = this.getModel().getEntryRowEntity("taskentity", rowIndex).getString(TREEENTRY_PID)))) continue;
            String msg = String.format(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u5220\u9664\u7b2c%s\u884c\u8282\u70b9\u7684\u5b50\u7ea7\u4efb\u52a1\u3002", (String)"DeptPlanBillPlugin_94", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1);
            this.getView().showMessage(msg);
            return;
        }
        Object planningcycle = this.getModel().getValue("planningcycle");
        if (null != planningcycle && (planningcycle.toString().equalsIgnoreCase(PlanningCycleEnum.MONTH.getValue()) || planningcycle.toString().equalsIgnoreCase(PlanningCycleEnum.WEEK.getValue()))) {
            for (int i = 0; i < selRows.length; ++i) {
                int rowIndex = selRows[i];
                if (this.getModel().getValue("relationtask", rowIndex) == null) continue;
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u7f16\u5236\u6708\u5ea6\u6216\u5468\u8ba1\u5212\u65f6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u81ea\u52a8\u5f15\u5165\u7684\u4efb\u52a1\u3002", (String)"DeptPlanBillPlugin_50", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u4efb\u52a1\uff1f", (String)"DeptPlanBillPlugin_118", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteTaskConfirm"));
    }

    public void confirmCallBack(MessageBoxClosedEvent mesce) {
        super.confirmCallBack(mesce);
        MessageBoxResult result = mesce.getResult();
        if (StringUtils.equals((CharSequence)"deleteTaskConfirm", (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.afterDeleteTaskConfirm();
        } else if (SWITCH_ORG.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mesce.getResult())) {
            this.afterSwitchOrgConfirm();
        } else if (SWITCH_ORG.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Cancel.equals((Object)mesce.getResult())) {
            this.afterSwitchOrgCancel();
        } else if (SWITCH_PLANNINGCYCLE.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mesce.getResult()) || SWITCH_TIMERANGE.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mesce.getResult())) {
            this.afterSwitchTimeConfirm();
            this.autoName();
        } else if (SWITCH_PLANNINGCYCLE.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Cancel.equals((Object)mesce.getResult())) {
            this.afterSwitchPlanCycleCancel();
        } else if (SWITCH_TIMERANGE.equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Cancel.equals((Object)mesce.getResult())) {
            this.afterSwitchTimeRangeCancel();
        } else if ("calmodify".equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mesce.getResult())) {
            this.afterRecalTimeConfirm();
        } else if ("importdepttask".equalsIgnoreCase(mesce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            this.importTaskOperation();
        }
        this.lockEntry();
    }

    protected void importTaskOperation() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog")));
        this.getView().showForm(importExcelFormParameter);
    }

    protected void afterRecalTimeConfirm() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        HashMap<Integer, DynamicObject> taskIndexMap = new HashMap<Integer, DynamicObject>(16);
        for (int i = 0; i < rowCount; ++i) {
            boolean hasProject;
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
            boolean isImport = rowEntity.get("relationtask") != null;
            Integer percent = rowEntity.getInt("percent");
            boolean bl = hasProject = rowEntity.get("taskprojecttx") != null;
            if (isImport || percent == 100 || hasProject) continue;
            taskIndexMap.put(i, rowEntity);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!taskIndexMap.isEmpty() && null != org) {
            Long orgId = Long.valueOf(org.getPkValue().toString());
            DeptTaskUtil.updateDeptTaskTime(taskIndexMap, (int)1, (Long)orgId, (String)this.getAppId());
        }
        for (Map.Entry entry : taskIndexMap.entrySet()) {
            Integer key = (Integer)entry.getKey();
            DynamicObject task = (DynamicObject)entry.getValue();
            this.getModel().setValue("taskjdgqtx", task.get("taskjdgqtx"), key.intValue());
            this.getModel().setValue("taskendtimetx", task.get("taskendtimetx"), key.intValue());
            this.getModel().setValue("tasktimepctx", task.get("tasktimepctx"), key.intValue());
        }
    }

    protected void afterSwitchTimeRangeCancel() {
        String oldTimeRange = this.getPageCache().get("oldTimeRange");
        this.getModel().beginInit();
        this.getModel().setValue("timerange", (Object)oldTimeRange);
        this.getModel().endInit();
        this.getView().updateView("timerange");
        this.setStartEndTime();
    }

    protected void afterSwitchPlanCycleCancel() {
        String oldPlanningcycle = this.getPageCache().get("oldPlanningcycle");
        this.getModel().beginInit();
        this.getModel().setValue("planningcycle", (Object)oldPlanningcycle);
        this.getModel().endInit();
        this.getView().updateView("planningcycle");
        this.setStartEndTime();
    }

    protected void afterSwitchTimeConfirm() {
        this.getModel().deleteEntryData("taskentity");
        this.getModel().deleteEntryData("taskresultdocentry");
        this.getModel().deleteEntryData("taskreferdocentry");
        this.monthOrWeekInsertTask();
    }

    protected void afterSwitchOrgCancel() {
        String oldOrgId = this.getPageCache().get("oldOrgId");
        this.getModel().beginInit();
        this.getModel().setValue("org", (Object)oldOrgId);
        this.getModel().endInit();
        this.getView().updateView("org");
        this.setDateEditRange();
    }

    protected void afterSwitchOrgConfirm() {
        this.afterSwitchTimeConfirm();
        this.setDateEditRange();
    }

    protected void afterDeleteTaskConfirm() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = entryGrid.getEntryState().getSelectedRows();
        this.getModel().deleteEntryRows("taskentity", selRows);
        this.getModel().updateCache();
        this.setTaskLeaf();
        this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        this.getView().updateView("taskentity");
    }

    protected void setTaskLeaf() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        if (entries.isEmpty()) {
            return;
        }
        HashSet<String> pidSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            String pid = entry.getString(TREEENTRY_PID);
            if (pid == null) continue;
            pidSet.add(pid);
        }
        for (int index = 0; index < entries.size(); ++index) {
            DynamicObject entry;
            entry = (DynamicObject)entries.get(index);
            String id = entry.getPkValue().toString();
            if (pidSet.contains(id)) {
                entry.set("isleaf", (Object)Boolean.FALSE);
                continue;
            }
            entry.set("isleaf", (Object)Boolean.TRUE);
            entry.set("isGroupNode", (Object)Boolean.FALSE);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (OperationStatus.VIEW.equals((Object)status) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            e.setCheckDataChange(false);
        }
    }

    protected void copyTaskFile(DynamicObject relationTask, DynamicObject currentTask) {
        DynamicObjectCollection taskReferDocEntries;
        String achievementNode = currentTask.get("achievementnode").toString();
        DynamicObjectType resultDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.getAppId(), (String)"deptplan", (String)"taskentity", (String)"taskresultdocentry");
        DynamicObjectType referDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.getAppId(), (String)"deptplan", (String)"taskentity", (String)"taskreferdocentry");
        ORM orm = ORM.create();
        DynamicObjectCollection taskResultDocEntries = relationTask.getDynamicObjectCollection("taskresultdocentry");
        if (!taskResultDocEntries.isEmpty()) {
            DynamicObjectCollection resultDocEntries = new DynamicObjectCollection();
            long[] resultDocEntryPks = orm.genLongIds((IDataEntityType)resultDocEntryDT, taskResultDocEntries.size());
            int resultDocEntryindex = 0;
            for (DynamicObject resultDocEntry : taskResultDocEntries) {
                Long resultDocEntryPk = resultDocEntryPks[resultDocEntryindex++];
                DynamicObject newResultDoc = new DynamicObject(resultDocEntryDT);
                newResultDoc.set("id", (Object)resultDocEntryPk);
                newResultDoc.setParent((Object)currentTask);
                newResultDoc.set("resultname", resultDocEntry.get("resultname"));
                newResultDoc.set("force", resultDocEntry.get("force"));
                newResultDoc.set("frequency", resultDocEntry.get("frequency"));
                newResultDoc.set("resultdescription", resultDocEntry.get("resultdescription"));
                resultDocEntries.add((Object)newResultDoc);
            }
            currentTask.set("taskresultdocentry", (Object)resultDocEntries);
        }
        if (!(taskReferDocEntries = relationTask.getDynamicObjectCollection("taskreferdocentry")).isEmpty()) {
            DynamicObjectCollection referDocEntries = new DynamicObjectCollection();
            long[] referDocEntryPks = orm.genLongIds((IDataEntityType)referDocEntryDT, taskReferDocEntries.size());
            int taskReferDocIndex = 0;
            for (DynamicObject referDocEntry : taskReferDocEntries) {
                Long referDocEntryPk = referDocEntryPks[taskReferDocIndex++];
                DynamicObject newReferDoc = new DynamicObject(referDocEntryDT);
                newReferDoc.setParent((Object)currentTask);
                newReferDoc.set("id", (Object)referDocEntryPk);
                newReferDoc.set("referdocname", referDocEntry.get("referdocname"));
                DynamicObjectCollection doces = referDocEntry.getDynamicObjectCollection("attachment");
                if (doces != null && !doces.isEmpty()) {
                    DynamicObjectCollection newDoces = new DynamicObjectCollection();
                    DynamicObjectType docDT = doces.getDynamicObjectType();
                    for (DynamicObject doc : doces) {
                        DynamicObject newDoc = new DynamicObject(docDT);
                        referDocEntry.getDataEntityType().getPrimaryKey().setValueFast((Object)newDoc, (Object)orm.genLongId((IDataEntityType)docDT));
                        newDoc.set("fbasedataid", (Object)doc.getDynamicObject("fbasedataid"));
                        newDoces.add((Object)newDoc);
                    }
                    newReferDoc.set("attachment", (Object)newDoces);
                }
                newReferDoc.set("description", referDocEntry.get("description"));
                referDocEntries.add((Object)newReferDoc);
            }
            currentTask.set("taskreferdocentry", (Object)referDocEntries);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("taskentity", evt.getRow());
        if (entryRowEntity == null) {
            return;
        }
        String entryKey = entryGrid.getEntryKey();
        if (StringUtils.equals((CharSequence)"taskentity", (CharSequence)entryKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
    }

    protected void setTransactionEntryEnable(int rowIndex) {
        DynamicObject relationTask;
        int count = this.getModel().getEntryRowCount("taskentity");
        if (count == 0) {
            return;
        }
        boolean showResultDoc = false;
        Object trans = this.getModel().getValue("transactiontype", rowIndex);
        if (null != trans) {
            DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
            for (DynamicObject tx : transactionType) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if ((relationTask = ((DynamicObject)this.getModel().getEntryEntity("taskentity").get(rowIndex)).getDynamicObject("relationtask")) != null) {
            if (showResultDoc) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"taskresultdocentry"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taskreferdocentry"});
        } else {
            if (showResultDoc) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"taskresultdocentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"taskreferdocentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap2"});
        }
    }

    protected void setAchievementEntryEnable(int rowIndex) {
        int count = this.getModel().getEntryRowCount("taskentity");
        if (count == 0) {
            return;
        }
        String achievementNode = (String)this.getModel().getValue("achievementnode", rowIndex);
        DynamicObject relationTask = ((DynamicObject)this.getModel().getEntryEntity("taskentity").get(rowIndex)).getDynamicObject("relationtask");
        if (relationTask != null) {
            if (StringUtils.equals((CharSequence)DefaultEnum.YES.getValue(), (CharSequence)achievementNode)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"taskresultdocentry"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taskreferdocentry"});
        } else {
            if (StringUtils.equals((CharSequence)DefaultEnum.YES.getValue(), (CharSequence)achievementNode)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"taskresultdocentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"taskreferdocentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap2"});
        }
    }

    protected void beforeTaskTypeSelected(BeforeF7SelectEvent arg0, int row) {
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype", row);
        if (null != plantype) {
            plantype = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"));
        }
        if (null != plantype && StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTPLAN.getValue())) {
            QFilter qFilter = new QFilter("checkboxisprojecttask", "=", (Object)"0");
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    protected void settingParentPlanTime(String changeField, int rowIndex) {
        block17: {
            DynamicObjectCollection entries;
            block18: {
                block16: {
                    entries = this.getModel().getEntryEntity("taskentity");
                    if (!"taskstarttimetx".equalsIgnoreCase(changeField)) break block16;
                    DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
                    Date planStartTime = row.getDate("taskstarttimetx");
                    long pid = row.getLong(TREEENTRY_PID);
                    if (pid == 0L || planStartTime == null) {
                        return;
                    }
                    int rowSeq = 0;
                    for (DynamicObject entry : entries) {
                        if (pid == Long.parseLong(entry.getPkValue().toString())) {
                            DynamicObject relationTask = entry.getDynamicObject("relationtask");
                            if (relationTask != null) {
                                if (planStartTime.before(entry.getDate("taskstarttimetx"))) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7ea7\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f15\u5165\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"DeptPlanBillPlugin_119", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                                }
                                if (planStartTime.after(entry.getDate("taskendtimetx"))) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7ea7\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5f15\u5165\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"DeptPlanBillPlugin_120", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                                }
                                return;
                            }
                            Date firstPlanStartTime = this.getBeginTimeBySameLevelTask(entries, row);
                            this.getModel().setValue("taskstarttimetx", (Object)firstPlanStartTime, rowSeq);
                            return;
                        }
                        ++rowSeq;
                    }
                    break block17;
                }
                if (!"taskendtimetx".equalsIgnoreCase(changeField)) break block18;
                DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
                Date planEndTime = row.getDate("taskendtimetx");
                long pid = row.getLong(TREEENTRY_PID);
                if (pid == 0L || planEndTime == null) {
                    return;
                }
                int rowSeq = 0;
                for (DynamicObject entry : entries) {
                    if (pid == Long.parseLong(entry.getPkValue().toString())) {
                        DynamicObject relationTask = entry.getDynamicObject("relationtask");
                        if (relationTask != null) {
                            if (planEndTime.after(entry.getDate("taskendtimetx"))) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7ea7\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5f15\u5165\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"DeptPlanBillPlugin_120", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                            }
                            return;
                        }
                        Date lastPlanEndTime = this.getEndTimeBySameLevelTask(entries, row);
                        this.getModel().setValue("taskendtimetx", (Object)lastPlanEndTime, rowSeq);
                        return;
                    }
                    ++rowSeq;
                }
                break block17;
            }
            if (!"taskmubiaotx".equalsIgnoreCase(changeField)) break block17;
            DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
            Date planAimTime = row.getDate("taskmubiaotx");
            long pid = row.getLong(TREEENTRY_PID);
            if (pid == 0L || planAimTime == null) {
                return;
            }
            int rowSeq = 0;
            for (DynamicObject entry : entries) {
                if (pid == Long.parseLong(entry.getPkValue().toString())) {
                    DynamicObject relationTask = entry.getDynamicObject("relationtask");
                    if (relationTask != null && entry.getDate("taskmubiaotx") != null) {
                        if (planAimTime.after(entry.getDate("taskmubiaotx"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7ea7\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5f15\u5165\u4efb\u52a1\u7684\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"DeptPlanBillPlugin_55", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        }
                        return;
                    }
                    Date parentPlanAimTime = this.getAimFinishTimeBySameLevelTask(entries, row);
                    this.getModel().setValue("taskmubiaotx", (Object)parentPlanAimTime, rowSeq);
                    return;
                }
                ++rowSeq;
            }
        }
    }

    protected Date getBeginTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date firstStartTime = currentTask.getDate("taskstarttimetx");
        long pid = currentTask.getLong(TREEENTRY_PID);
        for (DynamicObject entry : entries) {
            Date planStartTime;
            long entryPid = entry.getLong(TREEENTRY_PID);
            if (entryPid != pid || (planStartTime = entry.getDate("taskstarttimetx")) == null || planStartTime.compareTo(firstStartTime) >= 0) continue;
            firstStartTime = planStartTime;
        }
        return firstStartTime;
    }

    protected Date getEndTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastEndTime = currentTask.getDate("taskendtimetx");
        long pid = currentTask.getLong(TREEENTRY_PID);
        for (DynamicObject entry : entries) {
            Date planEndTime;
            long entryPid = entry.getLong(TREEENTRY_PID);
            if (entryPid != pid || (planEndTime = entry.getDate("taskendtimetx")) == null || planEndTime.compareTo(lastEndTime) <= 0) continue;
            lastEndTime = planEndTime;
        }
        return lastEndTime;
    }

    protected void settingTimeByChildren(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        long id = Long.parseLong(row.getPkValue().toString());
        if (id == 0L) {
            return;
        }
        Date firstStartTime = null;
        for (Object entry : entries) {
            Date planStartTime;
            Long parentId = entry.getLong(TREEENTRY_PID);
            if (parentId == 0L || id != parentId || null == (planStartTime = entry.getDate("taskstarttimetx"))) continue;
            if (null == firstStartTime) {
                firstStartTime = planStartTime;
            }
            firstStartTime = planStartTime.compareTo(firstStartTime) < 0 ? planStartTime : firstStartTime;
        }
        if (null != firstStartTime) {
            this.getModel().setValue("taskstarttimetx", firstStartTime, rowIndex);
        }
        Date lastEndTime = null;
        for (DynamicObject entry : entries) {
            Date planEndTime;
            Long parentId = entry.getLong(TREEENTRY_PID);
            if (parentId == 0L || id != parentId || null == (planEndTime = entry.getDate("taskendtimetx"))) continue;
            if (null == lastEndTime) {
                lastEndTime = planEndTime;
            }
            lastEndTime = planEndTime.compareTo(lastEndTime) > 0 ? planEndTime : lastEndTime;
        }
        if (null != lastEndTime) {
            this.getModel().setValue("taskendtimetx", lastEndTime, rowIndex);
        }
        Date lastAimfinishtime = null;
        for (DynamicObject entry : entries) {
            Date planAimfinishTime;
            Long parentId = entry.getLong(TREEENTRY_PID);
            if (parentId == 0L || id != parentId || null == (planAimfinishTime = entry.getDate("taskmubiaotx"))) continue;
            if (null == lastAimfinishtime) {
                lastAimfinishtime = planAimfinishTime;
            }
            lastAimfinishtime = planAimfinishTime.compareTo(lastAimfinishtime) > 0 ? planAimfinishTime : lastAimfinishtime;
        }
        if (null != lastAimfinishtime) {
            this.getModel().setValue("taskmubiaotx", lastAimfinishtime, rowIndex);
        }
    }

    protected Date getAimFinishTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastAimFinishTime = currentTask.getDate("taskmubiaotx");
        long pid = currentTask.getLong(TREEENTRY_PID);
        for (int i = 0; i < entries.size(); ++i) {
            Date aimFinishTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong(TREEENTRY_PID);
            if (entryPid != pid || (aimFinishTime = ((DynamicObject)entries.get(i)).getDate("taskmubiaotx")) == null || aimFinishTime.compareTo(lastAimFinishTime) <= 0) continue;
            lastAimFinishTime = aimFinishTime;
        }
        return lastAimFinishTime;
    }
}

