/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanningCycleEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class DeptPlanReachRatePlugin
extends AbstractPlacsFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String THIS_MONTH = "thisMonth";
    private static final String THREE_MONTH = "threeMonth";
    private static final String DUTYS = "dutys";
    private static final String CONTAINSUB = "containsub";
    private static final String FBASEDATAID = "fbasedataid";
    private static final String TEXTFIELD = "textfield";
    private static final String ENTRYENTITY = "entryentity";
    private static final String THISWEEK = "thisweek";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final String ENDRATE = "endrate";
    private static final String OVERTIMEENDRATE = "overtimeendrate";
    private static final String ONTIMEENDRATE = "ontimeendrate";
    private static final String OVERTIMENOTEND = "overtimenotend";
    private static final String TOTALEND = "totalend";
    private static final String OVERTIMEEND = "overtimeend";
    private static final String ONTIMEEND = "ontimeend";
    private static final String PLANEND = "planend";
    private static final String[] COLUMNKEY = new String[]{"org", "planend", "ontimeend", "overtimeend", "totalend", "overtimenotend", "ontimeendrate", "overtimeendrate", "endrate"};
    private String fileName = ResManager.loadKDString((String)"\u90e8\u95e8\u8ba1\u5212\u8fbe\u6210\u7387-\u6570\u636e\u660e\u7ec6", (String)"DeptPlanReachRatePlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    private String sheetName = ResManager.loadKDString((String)"\u6570\u636e\u660e\u7ec6", (String)"DeptPlanReachRatePlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    private String[] header = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"DeptPlanReachRatePlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u603b\u6570", (String)"DeptPlanReachRatePlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0])};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit orgs = (MulBasedataEdit)this.getControl("orgs");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit taskSource = (MulBasedataEdit)this.getControl("tasksource");
        taskSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Chart totalChart = (Chart)this.getControl(HISTOGRAMCHARTAP);
        totalChart.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"dataap"});
        this.setStartEndTime();
        this.getView().updateView("timerange");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)"tasksource", (CharSequence)propName)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter sysPreFilter = new QFilter("group", "=", (Object)0).and("number", "in", (Object)new String[]{"MASTERPLAN_S", "TRANSACTIONPLAN_S", "DECOMPOSITIONTASK_S", "ASSIGNTASK_S"});
            QFilter specialFilter = new QFilter("group", "!=", (Object)0);
            QFilter taskSourceFilter = sysPreFilter.or(specialFilter);
            showParameter.getListFilterParameter().getQFilters().add(taskSourceFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"querydata", (CharSequence)operateKey)) {
            this.updateDeptPlanData();
        } else if (StringUtils.equals((CharSequence)"refreshdata", (CharSequence)operateKey)) {
            this.updateDeptPlanData();
        } else if (StringUtils.equals((CharSequence)"export", (CharSequence)operateKey)) {
            JSONArray data = new JSONArray();
            DynamicObjectCollection dataCol = this.getModel().getEntryEntity(ENTRYENTITY);
            DecimalFormat df2 = new DecimalFormat("#.##");
            for (DynamicObject dynamicObject : dataCol) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("org", (Object)dynamicObject.getString("org.name"));
                jsonObj.put(PLANEND, (Object)dynamicObject.getInt(PLANEND));
                jsonObj.put(ONTIMEEND, (Object)dynamicObject.getInt(ONTIMEEND));
                jsonObj.put(OVERTIMEEND, (Object)dynamicObject.getInt(OVERTIMEEND));
                jsonObj.put(TOTALEND, (Object)dynamicObject.getInt(TOTALEND));
                jsonObj.put(OVERTIMENOTEND, (Object)dynamicObject.getInt(OVERTIMENOTEND));
                jsonObj.put(ONTIMEENDRATE, (Object)(df2.format(dynamicObject.getBigDecimal(ONTIMEENDRATE).multiply(BigDecimal.valueOf(100L))) + "%"));
                jsonObj.put(OVERTIMEENDRATE, (Object)(df2.format(dynamicObject.getBigDecimal(OVERTIMEENDRATE).multiply(BigDecimal.valueOf(100L))) + "%"));
                jsonObj.put(ENDRATE, (Object)(df2.format(dynamicObject.getBigDecimal(ENDRATE).multiply(BigDecimal.valueOf(100L))) + "%"));
                data.add((Object)jsonObj);
            }
            ArrayList mustFillColumn = new ArrayList(10);
            String url = POIHelper.exportExcel((String)this.fileName, (String)this.sheetName, (String[])this.header, (String[])COLUMNKEY, mustFillColumn, (JSONArray)data);
            this.getView().download(url);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"DeptPlanReachRatePlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (StringUtils.equals((CharSequence)"queryclick", (CharSequence)operateKey)) {
            String textField = (String)this.getModel().getValue(TEXTFIELD);
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TEXTFIELD, (Object)"true");
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"DeptPlanReachRatePlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TEXTFIELD, (Object)"false");
            }
        }
    }

    protected void updateDeptPlanData() {
        DynamicObjectCollection orgCol = this.getModel().getDataEntity().getDynamicObjectCollection("orgs");
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : orgCol) {
            DynamicObject org = dynamicObject.getDynamicObject(FBASEDATAID);
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        boolean containsub = this.getModel().getDataEntity().getBoolean(CONTAINSUB);
        if (containsub) {
            orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIdList, (boolean)true);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject[] deptPlans = this.getDeptPlan(orgIdList);
        if (deptPlans == null || deptPlans.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u5207\u6362\u6761\u4ef6\u67e5\u8be2\u3002", (String)"DeptPlanReachRatePlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"dataap"});
        Map<String, Map<String, Object>> orgDataMap = this.handleDeptplanData(deptPlans);
        ArrayList<Integer> onTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeNotEndList = new ArrayList<Integer>(10);
        ArrayList<BigDecimal> endRateList = new ArrayList<BigDecimal>(10);
        ArrayList<String> projectNameList = new ArrayList<String>(10);
        for (Map.Entry<String, Map<String, Object>> data : orgDataMap.entrySet()) {
            Map<String, Object> taskQtyMap = data.getValue();
            String orgName = taskQtyMap.get("orgname").toString();
            Integer onTimeEnd = (Integer)taskQtyMap.get(ONTIMEEND);
            Integer overTimeEnd = (Integer)taskQtyMap.get(OVERTIMEEND);
            Integer overTimeNotEnd = (Integer)taskQtyMap.get(OVERTIMENOTEND);
            Integer planEnd = (Integer)taskQtyMap.get(PLANEND);
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("org", (Object)data.getKey(), rowIndex);
            this.getModel().setValue(PLANEND, (Object)planEnd, rowIndex);
            onTimeEndList.add(onTimeEnd);
            this.getModel().setValue(ONTIMEEND, (Object)onTimeEnd, rowIndex);
            overTimeEndList.add(overTimeEnd);
            this.getModel().setValue(OVERTIMEEND, (Object)overTimeEnd, rowIndex);
            overTimeNotEndList.add(overTimeNotEnd);
            this.getModel().setValue(OVERTIMENOTEND, (Object)overTimeNotEnd, rowIndex);
            projectNameList.add(orgName);
            Integer totalEnd = onTimeEnd + overTimeEnd;
            BigDecimal endRate = BigDecimal.ZERO;
            if (planEnd != 0) {
                endRate = BigDecimal.valueOf(totalEnd.intValue()).divide(BigDecimal.valueOf(planEnd.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            }
            endRateList.add(endRate);
        }
        this.setHistogramChart(onTimeEndList, overTimeEndList, overTimeNotEndList, endRateList, projectNameList);
    }

    protected void updateData() {
        DynamicObjectCollection orgCol = this.getModel().getDataEntity().getDynamicObjectCollection("orgs");
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : orgCol) {
            DynamicObject org = dynamicObject.getDynamicObject(FBASEDATAID);
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        boolean containsub = this.getModel().getDataEntity().getBoolean(CONTAINSUB);
        if (containsub) {
            orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIdList, (boolean)true);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject[] taskArr = this.getTaskArr(dataEntity, orgIdList);
        if (taskArr == null || taskArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u5207\u6362\u6761\u4ef6\u67e5\u8be2\u3002", (String)"DeptPlanReachRatePlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"dataap"});
        Map<String, Map<String, Object>> orgDataMap = this.handleData(taskArr, orgIdList);
        ArrayList<Integer> onTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeNotEndList = new ArrayList<Integer>(10);
        ArrayList<BigDecimal> endRateList = new ArrayList<BigDecimal>(10);
        ArrayList<String> projectNameList = new ArrayList<String>(10);
        for (Map.Entry<String, Map<String, Object>> data : orgDataMap.entrySet()) {
            Map<String, Object> taskQtyMap = data.getValue();
            String orgName = taskQtyMap.get("orgname").toString();
            Integer onTimeEnd = (Integer)taskQtyMap.get(ONTIMEEND);
            Integer overTimeEnd = (Integer)taskQtyMap.get(OVERTIMEEND);
            Integer overTimeNotEnd = (Integer)taskQtyMap.get(OVERTIMENOTEND);
            Integer planEnd = (Integer)taskQtyMap.get(PLANEND);
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("org", (Object)data.getKey(), rowIndex);
            this.getModel().setValue(PLANEND, (Object)planEnd, rowIndex);
            onTimeEndList.add(onTimeEnd);
            this.getModel().setValue(ONTIMEEND, (Object)onTimeEnd, rowIndex);
            overTimeEndList.add(overTimeEnd);
            this.getModel().setValue(OVERTIMEEND, (Object)overTimeEnd, rowIndex);
            overTimeNotEndList.add(overTimeNotEnd);
            this.getModel().setValue(OVERTIMENOTEND, (Object)overTimeNotEnd, rowIndex);
            projectNameList.add(orgName);
            Integer totalEnd = onTimeEnd + overTimeEnd;
            BigDecimal endRate = BigDecimal.ZERO;
            if (planEnd != 0) {
                endRate = BigDecimal.valueOf(totalEnd.intValue()).divide(BigDecimal.valueOf(planEnd.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            }
            endRateList.add(endRate);
        }
        this.setHistogramChart(onTimeEndList, overTimeEndList, overTimeNotEndList, endRateList, projectNameList);
    }

    private void setHistogramChart(List<Integer> onTimeEndList, List<Integer> overTimeEndList, List<Integer> overTimeNotEndList, List<BigDecimal> endRateList, List<String> projectNameList) {
        for (int i = projectNameList.size(); i < 8; ++i) {
            projectNameList.add("");
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
        histogramChart.clearData();
        Axis xAxis = histogramChart.createXAxis("", projectNameList);
        if (projectNameList.size() > 8) {
            HashMap<String, Integer> axisLabelMap = new HashMap<String, Integer>();
            axisLabelMap.put("interval", 0);
            axisLabelMap.put("rotate", -40);
            xAxis.setPropValue("axisLabel", axisLabelMap);
        }
        kd.bos.form.chart.Label plLabel = new kd.bos.form.chart.Label();
        plLabel.setShow(true);
        plLabel.setFontSize("14");
        plLabel.setPosition(Position.inside);
        histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"DeptPlanReachRatePlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), AxisType.value);
        BarSeries series = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series.setBarWidth("50px");
        series.setStack("aa");
        series.setData((Number[])onTimeEndList.toArray(new Integer[onTimeEndList.size()]));
        series.setColor("#83F348");
        series.setLabel(plLabel);
        BarSeries series1 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series1.setBarWidth("50px");
        series1.setStack("aa");
        series1.setData((Number[])overTimeEndList.toArray(new Integer[overTimeEndList.size()]));
        series1.setColor("#2DECE9");
        series1.setLabel(plLabel);
        BarSeries series2 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series2.setBarWidth("50px");
        series2.setStack("aa");
        series2.setData((Number[])overTimeNotEndList.toArray(new Integer[overTimeNotEndList.size()]));
        series2.setColor("#FF585A");
        series2.setLabel(plLabel);
        Axis yAxis2 = histogramChart.createYAxis(ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"DeptPlanReachRatePlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formatter", "{value}%");
        yAxis2.setPropValue("axisLabel", map);
        yAxis2.setMax((Number)100);
        LineSeries lineSeries = histogramChart.createLineSeries(ResManager.loadKDString((String)"\u5b8c\u6210\u7387\uff08%\uff09", (String)"DeptPlanReachRatePlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        lineSeries.setData((Number[])endRateList.toArray(new BigDecimal[endRateList.size()]));
        HashMap itemStyleMap = new HashMap();
        HashMap<String, String> normalMap = new HashMap<String, String>();
        normalMap.put("color", "#1A94E6");
        itemStyleMap.put("normal", normalMap);
        lineSeries.setPropValue("itemStyle", itemStyleMap);
        lineSeries.setYAxisIndex(1);
        histogramChart.setShowTooltip(true);
        histogramChart.setShowLegend(true);
        histogramChart.setShowTitle(false);
        histogramChart.refresh();
    }

    protected Set<Object> getTaskTypeIdSet(DynamicObject dataEntity) {
        HashSet<Object> taskTypeIdSet = new HashSet<Object>();
        DynamicObjectCollection taskTypeCol = dataEntity.getDynamicObjectCollection("tasktypes");
        if (taskTypeCol != null && !taskTypeCol.isEmpty()) {
            for (DynamicObject dynamicObject : taskTypeCol) {
                DynamicObject taskType = dynamicObject.getDynamicObject(FBASEDATAID);
                if (taskType == null) continue;
                taskTypeIdSet.add(taskType.getPkValue());
            }
        }
        return taskTypeIdSet;
    }

    protected Set<Object> getTaskSourceIdSet(DynamicObject dataEntity) {
        HashSet<Object> taskSourceIdSet = new HashSet<Object>();
        DynamicObjectCollection taskSourceCol = dataEntity.getDynamicObjectCollection("tasksource");
        if (taskSourceCol != null && !taskSourceCol.isEmpty()) {
            for (DynamicObject taskSourceObj : taskSourceCol) {
                DynamicObject taskSource = taskSourceObj.getDynamicObject(FBASEDATAID);
                if (taskSource == null) continue;
                taskSourceIdSet.add(taskSource.getPkValue());
            }
        }
        return taskSourceIdSet;
    }

    protected String[] getPlanTypeArr(DynamicObject dataEntity) {
        String[] planTypeArr;
        String planTypes = dataEntity.getString("plantypes");
        if (StringUtils.isNotBlank((CharSequence)planTypes) && (planTypeArr = planTypes.split(",")) != null && planTypeArr.length > 0) {
            return planTypeArr;
        }
        return new String[0];
    }

    protected DynamicObject[] getDeptPlan(List<Long> orgIdList) {
        Object startTime = this.getModel().getValue("starttime");
        Object endTime = this.getModel().getValue("endtime");
        QFilter time1 = new QFilter("STARTTIME", "<=", startTime).and(new QFilter("ENDTIME", ">=", startTime));
        QFilter time2 = new QFilter("STARTTIME", "<=", endTime).and(new QFilter("ENDTIME", ">=", endTime));
        QFilter time3 = new QFilter("STARTTIME", ">=", startTime).and(new QFilter("ENDTIME", "<=", endTime));
        QFilter timeFilter = time1.or(time2).or(time3);
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        String planningCycle = (String)this.getModel().getValue("planningcycle");
        QFilter plancycleFilter = new QFilter("planningcycle", "=", (Object)planningCycle);
        QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        QFilter[] filters = new QFilter[]{orgFilter, plancycleFilter, planStatusFilter, timeFilter};
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"assigner,billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, planningcycle, timerange, STARTTIME, ENDTIME, name, version, sourceplan, prechangeplan, planstatus, planstatus1", (QFilter[])filters);
        return plans;
    }

    protected DynamicObject[] getTaskArr(DynamicObject dataEntity, List<Long> orgIdList) {
        String[] dutyArr;
        String dutys;
        String[] planTypeArr;
        Set<Object> taskTypeIdSet;
        QFilter commonFilter = this.getCommonFilter();
        QFilter controlLevelFilter = null;
        QFilter taskTypeFilter = null;
        QFilter planEndTimeFilter = this.getPlanStartAndEndTimeFilter(dataEntity);
        QFilter planTypeQfilter = null;
        QFilter responsibleDeptFilter = null;
        QFilter cooperationdeptFilter = null;
        QFilter orgFilter = null;
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypeIdSet);
        }
        if ((planTypeArr = this.getPlanTypeArr(dataEntity)) != null && planTypeArr.length != 0) {
            planTypeQfilter = new QFilter("belongplantype.plantype", "in", (Object)planTypeArr);
        }
        if (StringUtils.isNotBlank((CharSequence)(dutys = dataEntity.getString(DUTYS))) && (dutyArr = dutys.split(",")).length == 0) {
            responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
            cooperationdeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", orgIdList);
            orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
        }
        if (dutys == null || StringUtils.contains((CharSequence)dutys, (CharSequence)"1") && StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
            cooperationdeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", orgIdList);
            orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1")) {
            orgFilter = new QFilter("responsibledept", "in", orgIdList);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            orgFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", orgIdList);
        }
        return BusinessDataServiceHelper.load((String)(this.getAppId() + "_" + "task"), (String)"id,name,majortype,planendtime,completionstatus,responsibledept,multicooperationdept", (QFilter[])new QFilter[]{planEndTimeFilter, commonFilter, planTypeQfilter, controlLevelFilter, taskTypeFilter, orgFilter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planningcycle")) {
            this.setStartEndTime();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"begintime")) {
            this.setStartEndTime();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)THISWEEK) || StringUtils.equals((CharSequence)propertyName, (CharSequence)THIS_MONTH) || StringUtils.equals((CharSequence)propertyName, (CharSequence)THREE_MONTH)) {
            this.getModel().setValue("daterange_startdate", null);
            this.getModel().setValue("daterange_enddate", null);
            this.getPageCache().put("timeType", propertyName);
        }
    }

    protected void setStartEndTime() {
        String planningcycle = (String)this.getModel().getValue("planningcycle");
        Date beginTime = (Date)this.getModel().getValue("begintime");
        Date start = null;
        Date end = null;
        if (null != beginTime && !StringUtils.isEmpty((CharSequence)planningcycle)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.YEAR.getValue())) {
                start = DateUtil.getYearFirst((Date)beginTime);
                end = DateUtil.getYearLast((Date)beginTime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.HALFYEAR.getValue())) {
                start = DateUtil.getHalfYearStartTime((Date)beginTime);
                end = DateUtil.getHalfYearEndTime((Date)beginTime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.QUART.getValue())) {
                start = DateUtil.getQuarterStartTime((Date)beginTime);
                end = DateUtil.getQuarterEndTime((Date)beginTime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.MONTH.getValue())) {
                start = DateUtil.getFirstDayOfThisMonth((Date)beginTime);
                end = DateUtil.getLastDayOfThisMonth((Date)beginTime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.WEEK.getValue())) {
                start = DateUtil.getThisWeekMonday((Date)beginTime);
                end = DateUtil.getThisWeekSunDay((Date)beginTime);
            }
        }
        this.getModel().setValue("starttime", start);
        this.getModel().setValue("endtime", end);
    }

    protected Set<Object> getControlLevelSet(DynamicObject dataEntity) {
        DynamicObjectCollection controlLevelCol = dataEntity.getDynamicObjectCollection("controllevels");
        HashSet<Object> controlLevelIdSet = new HashSet<Object>();
        if (controlLevelCol != null && !controlLevelCol.isEmpty()) {
            for (DynamicObject dynamicObject : controlLevelCol) {
                DynamicObject controlLevel = dynamicObject.getDynamicObject(FBASEDATAID);
                if (controlLevel == null) continue;
                controlLevelIdSet.add(controlLevel.getPkValue());
            }
        }
        return controlLevelIdSet;
    }

    protected QFilter getPlanStartAndEndTimeFilter(DynamicObject dataEntity) {
        QFilter planEndTimeFilter = null;
        boolean thisWeek = dataEntity.getBoolean(THISWEEK);
        boolean thisMonth = dataEntity.getBoolean(THIS_MONTH);
        boolean threeMonth = dataEntity.getBoolean(THREE_MONTH);
        Date nowDate = new Date();
        if (thisWeek) {
            Date firstDayOfThisWeek = DateUtil.getThisWeekMonday((Date)nowDate);
            Date lastDayOfThisWeek = DateUtil.getThisWeekSunDay((Date)nowDate);
            QFilter largeFirstDayOfThisWeek = new QFilter("planendtime", ">=", (Object)firstDayOfThisWeek);
            QFilter lessLastDayOfThisWeek = new QFilter("planendtime", "<=", (Object)lastDayOfThisWeek);
            planEndTimeFilter = largeFirstDayOfThisWeek.and(lessLastDayOfThisWeek);
        } else if (thisMonth) {
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)nowDate);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfThisMonth = new QFilter("planendtime", ">=", (Object)firstDayOfThisMonth);
            QFilter lessLastDatOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfThisMonth.and(lessLastDatOfThisMonth);
        } else if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            Date firstDayOfPreTwoMonth = DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfPreTwoMonth = new QFilter("planendtime", ">=", (Object)firstDayOfPreTwoMonth);
            QFilter lessLastDayOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfPreTwoMonth.and(lessLastDayOfThisMonth);
        } else {
            Date firstDayOfRange = dataEntity.getDate("daterange_startdate");
            Date lastDayOfRange = dataEntity.getDate("daterange_enddate");
            if (firstDayOfRange != null && lastDayOfRange != null) {
                QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", (Object)firstDayOfRange);
                QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", (Object)lastDayOfRange);
                planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
            }
        }
        return planEndTimeFilter;
    }

    protected QFilter getCommonFilter() {
        return new QFilter("islatest", "=", (Object)"1").and(new QFilter("relationtask", "=", (Object)"0")).and(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
    }

    protected Map<String, Map<String, Object>> handleDeptplanData(DynamicObject[] deptPlans) {
        Set<Object> taskSourceIdSet;
        Set<Object> taskTypeIdSet;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap<String, Map<String, Object>> projectDataMap = new HashMap<String, Map<String, Object>>();
        QFilter controlLevelFilter = null;
        QFilter taskTypeFilter = null;
        QFilter taskSourceFilter = null;
        QFilter responsibleDeptFilter = null;
        QFilter cooperationdeptFilter = null;
        QFilter orgFilter = null;
        QFilter timeFilter = this.getPlanStartAndEndTimeFilter(dataEntity);
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypeIdSet);
        }
        if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
            taskSourceFilter = new QFilter("tasksource", "in", taskSourceIdSet);
        }
        String dutys = dataEntity.getString(DUTYS);
        for (DynamicObject deptPlan : deptPlans) {
            DynamicObject[] tasks;
            QFilter planidFilter = new QFilter("planid", "=", deptPlan.getPkValue());
            DynamicObject org = deptPlan.getDynamicObject("org");
            Object orgId = org.getPkValue();
            if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1") && StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
                responsibleDeptFilter = new QFilter("responsibledept", "=", orgId);
                cooperationdeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "=", orgId);
                orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
            } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1")) {
                orgFilter = new QFilter("responsibledept", "=", orgId);
            } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
                orgFilter = new QFilter("multicooperationdept.fbasedataid.id", "=", orgId);
            }
            String orgIdStr = String.valueOf(orgId);
            for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{planidFilter, timeFilter, controlLevelFilter, taskTypeFilter, orgFilter, taskSourceFilter})) {
                String completStatus = task.getString("completionstatus");
                HashMap<String, Object> taskQtyMap = (HashMap<String, Object>)projectDataMap.get(orgIdStr);
                if (taskQtyMap != null && !taskQtyMap.isEmpty()) {
                    Integer planEnd;
                    Integer n = planEnd = (Integer)taskQtyMap.get(PLANEND);
                    Integer n2 = planEnd = Integer.valueOf(planEnd + 1);
                    taskQtyMap.put(PLANEND, planEnd);
                    if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completStatus)) {
                        Integer onTimeEnd;
                        n2 = onTimeEnd = (Integer)taskQtyMap.get(ONTIMEEND);
                        Integer n3 = onTimeEnd = Integer.valueOf(onTimeEnd + 1);
                        taskQtyMap.put(ONTIMEEND, onTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completStatus)) {
                        Integer overTimeEnd;
                        n2 = overTimeEnd = (Integer)taskQtyMap.get(OVERTIMEEND);
                        Integer n4 = overTimeEnd = Integer.valueOf(overTimeEnd + 1);
                        taskQtyMap.put(OVERTIMEEND, overTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completStatus)) {
                        Integer overTimeNotEnd;
                        n2 = overTimeNotEnd = (Integer)taskQtyMap.get(OVERTIMENOTEND);
                        Integer n5 = overTimeNotEnd = Integer.valueOf(overTimeNotEnd + 1);
                        taskQtyMap.put(OVERTIMENOTEND, overTimeNotEnd);
                    }
                    projectDataMap.put(orgIdStr, taskQtyMap);
                    continue;
                }
                taskQtyMap = new HashMap<String, Object>();
                int planEnd = 0;
                int onTimeEnd = 0;
                int overTimeEnd = 0;
                int overTimeNotEnd = 0;
                ++planEnd;
                taskQtyMap.put("orgname", org.getString("name"));
                if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completStatus)) {
                    ++onTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completStatus)) {
                    ++overTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completStatus) || StringUtils.equals((CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue(), (CharSequence)completStatus)) {
                    ++overTimeNotEnd;
                }
                taskQtyMap.put(PLANEND, planEnd);
                taskQtyMap.put(ONTIMEEND, onTimeEnd);
                taskQtyMap.put(OVERTIMEEND, overTimeEnd);
                taskQtyMap.put(OVERTIMENOTEND, overTimeNotEnd);
                projectDataMap.put(orgIdStr, taskQtyMap);
            }
        }
        return projectDataMap;
    }

    protected Map<String, Map<String, Object>> handleData(DynamicObject[] taskArr, List<Long> orgIdList) {
        HashMap<String, Map<String, Object>> projectDataMap = new HashMap<String, Map<String, Object>>();
        DynamicObjectCollection orgCol = this.getModel().getDataEntity().getDynamicObjectCollection("orgs");
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject orgObj : orgCol) {
            DynamicObject org = orgObj.getDynamicObject(FBASEDATAID);
            if (org == null) continue;
            orgMap.put(org.getLong("id"), org);
        }
        if (orgIdList != null && !orgIdList.isEmpty()) {
            DynamicObject[] orgs;
            QFilter idFilter = new QFilter("id", "in", orgIdList);
            for (DynamicObject org : orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{idFilter})) {
                if (org == null || orgMap.containsKey(org.getLong("id"))) continue;
                orgMap.put(org.getLong("id"), org);
            }
        }
        for (DynamicObject task : taskArr) {
            String completStatus = task.getString("completionstatus");
            for (Long orgId : orgIdList) {
                HashMap<String, Object> taskQtyMap = (HashMap<String, Object>)projectDataMap.get(orgId.toString());
                if (taskQtyMap != null && !taskQtyMap.isEmpty()) {
                    Integer planEnd;
                    Integer n = planEnd = (Integer)taskQtyMap.get(PLANEND);
                    Integer n2 = planEnd = Integer.valueOf(planEnd + 1);
                    taskQtyMap.put(PLANEND, planEnd);
                    if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completStatus)) {
                        Integer onTimeEnd;
                        n2 = onTimeEnd = (Integer)taskQtyMap.get(ONTIMEEND);
                        Integer n3 = onTimeEnd = Integer.valueOf(onTimeEnd + 1);
                        taskQtyMap.put(ONTIMEEND, onTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completStatus)) {
                        Integer overTimeEnd;
                        n2 = overTimeEnd = (Integer)taskQtyMap.get(OVERTIMEEND);
                        Integer n4 = overTimeEnd = Integer.valueOf(overTimeEnd + 1);
                        taskQtyMap.put(OVERTIMEEND, overTimeEnd);
                    } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completStatus)) {
                        Integer overTimeNotEnd;
                        n2 = overTimeNotEnd = (Integer)taskQtyMap.get(OVERTIMENOTEND);
                        Integer n5 = overTimeNotEnd = Integer.valueOf(overTimeNotEnd + 1);
                        taskQtyMap.put(OVERTIMENOTEND, overTimeNotEnd);
                    }
                    projectDataMap.put(orgId.toString(), taskQtyMap);
                    continue;
                }
                taskQtyMap = new HashMap<String, Object>();
                int planEnd = 0;
                int onTimeEnd = 0;
                int overTimeEnd = 0;
                int overTimeNotEnd = 0;
                ++planEnd;
                taskQtyMap.put("orgname", ((DynamicObject)orgMap.get(orgId)).getString("name"));
                if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completStatus)) {
                    ++onTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completStatus)) {
                    ++overTimeEnd;
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completStatus)) {
                    ++overTimeNotEnd;
                }
                taskQtyMap.put(PLANEND, planEnd);
                taskQtyMap.put(ONTIMEEND, onTimeEnd);
                taskQtyMap.put(OVERTIMEEND, overTimeEnd);
                taskQtyMap.put(OVERTIMENOTEND, overTimeNotEnd);
                projectDataMap.put(orgId.toString(), taskQtyMap);
            }
        }
        return projectDataMap;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)PLANEND, (CharSequence)fieldName)) {
            this.showDeptTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)ONTIMEEND, (CharSequence)fieldName)) {
            this.showDeptTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)OVERTIMEEND, (CharSequence)fieldName)) {
            this.showDeptTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)OVERTIMENOTEND, (CharSequence)fieldName)) {
            this.showDeptTask(fieldName, rowIndex);
        }
    }

    protected void showDeptTask(String fieldName, int rowIndex) {
        Set<Object> taskSourceIdSet;
        Set<Object> taskTypeIdSet;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
        if ((org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", org.getPkValue())})) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u540e\u64cd\u4f5c\u3002", (String)"DeptPlanReachRatePlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String completionStatus = "";
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)ONTIMEEND)) {
            completionStatus = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)OVERTIMEEND)) {
            completionStatus = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)OVERTIMENOTEND)) {
            completionStatus = CompletionStatusEnum.OVERDUE.getValue();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            paramMap.put("controllevels", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasktypes", taskTypeIdSet);
        }
        if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasksource", taskSourceIdSet);
        }
        paramMap.put("daterange_startdate", this.getRangeBeginDate(dataEntity));
        paramMap.put("daterange_enddate", this.getRangeEndDate(dataEntity));
        String dutys = dataEntity.getString(DUTYS);
        paramMap.put(DUTYS, dutys);
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(org.getLong("id"));
        DynamicObject[] deptPlan = this.getDeptPlan(orgIdList);
        if (deptPlan.length == 1) {
            paramMap.put("deptplanId", deptPlan[0].getString("id"));
        }
        paramMap.put("orgId", org.getString("id"));
        paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasklist"));
        paramMap.put("completionStatus", completionStatus);
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplanreachrate"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        ChartClickEvent chartClickEvent;
        Chart chart;
        super.click(evt);
        String sourceName = evt.getSource().getClass().getName();
        if (StringUtils.equals((CharSequence)sourceName, (CharSequence)HistogramChart.class.getName()) && StringUtils.equals((CharSequence)HISTOGRAMCHARTAP, (CharSequence)(chart = (chartClickEvent = (ChartClickEvent)evt).getSource()).getKey())) {
            Set<Object> taskSourceIdSet;
            Set<Object> taskTypeIdSet;
            String orgName = chartClickEvent.getName();
            String seriesName = chartClickEvent.getSeriesName();
            if (orgName == null || seriesName == null) {
                return;
            }
            if (seriesName.contains("%")) {
                return;
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)orgName)});
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u540e\u64cd\u4f5c\u3002", (String)"DeptPlanReachRatePlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            String completionStatus = "";
            if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getName())) {
                completionStatus = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
            } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"DeptPlanReachRatePlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
                completionStatus = CompletionStatusEnum.OVERDUE.getValue();
            } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getName())) {
                completionStatus = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
            }
            if (StringUtils.isBlank((CharSequence)completionStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u5757\u72b6\u6001\u4e0e\u7cfb\u7edf\u4efb\u52a1\u72b6\u6001\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeptPlanReachRatePlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
            if (!controlLevelIdSet.isEmpty()) {
                paramMap.put("controllevels", controlLevelIdSet);
            }
            if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
                paramMap.put("tasktypes", taskTypeIdSet);
            }
            if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
                paramMap.put("tasksource", taskSourceIdSet);
            }
            paramMap.put("daterange_startdate", this.getRangeBeginDate(dataEntity));
            paramMap.put("daterange_enddate", this.getRangeEndDate(dataEntity));
            String dutys = dataEntity.getString(DUTYS);
            paramMap.put(DUTYS, dutys);
            ArrayList<Long> orgIdList = new ArrayList<Long>(1);
            orgIdList.add(org.getLong("id"));
            DynamicObject[] deptPlan = this.getDeptPlan(orgIdList);
            if (deptPlan.length == 1) {
                paramMap.put("deptplanId", deptPlan[0].getString("id"));
            }
            paramMap.put("orgId", org.getString("id"));
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasklist"));
            paramMap.put("completionStatus", completionStatus);
            paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplanreachrate"));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected Date getRangeBeginDate(DynamicObject dataEntity) {
        boolean thisWeek = dataEntity.getBoolean(THISWEEK);
        boolean thisMonth = dataEntity.getBoolean(THIS_MONTH);
        boolean threeMonth = dataEntity.getBoolean(THREE_MONTH);
        Date nowDate = new Date();
        if (thisWeek) {
            return DateUtil.getThisWeekMonday((Date)nowDate);
        }
        if (thisMonth) {
            return DateUtil.getFirstDayOfThisMonth((Date)nowDate);
        }
        if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            return DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
        }
        return dataEntity.getDate("daterange_startdate");
    }

    protected Date getRangeEndDate(DynamicObject dataEntity) {
        boolean thisWeek = dataEntity.getBoolean(THISWEEK);
        boolean thisMonth = dataEntity.getBoolean(THIS_MONTH);
        boolean threeMonth = dataEntity.getBoolean(THREE_MONTH);
        Date nowDate = new Date();
        if (thisWeek) {
            return DateUtil.getThisWeekSunDay((Date)nowDate);
        }
        if (thisMonth) {
            return DateUtil.getLastDayOfThisMonth((Date)nowDate);
        }
        if (threeMonth) {
            return DateUtil.getLastDayOfThisMonth((Date)nowDate);
        }
        return dataEntity.getDate("daterange_enddate");
    }
}

