/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class DeptPlanTaskFormPlugin
extends AbstractPlacsBillPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(DeptPlanTaskFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationPerson = (BasedataEdit)this.getControl("cooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationDept = (BasedataEdit)this.getControl("cooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        switch (propName) {
            case "responsibleperson": {
                DynamicObject responsibleDept = this.getModel().getDataEntity().getDynamicObject("responsibledept");
                if (null == customMap.get("deptId")) break;
                Long orgId = Long.valueOf(customMap.get("deptId").toString());
                if (responsibleDept != null) {
                    orgId = Long.valueOf(responsibleDept.getPkValue().toString());
                }
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                String userId = RequestContext.get().getUserId();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List userIds = null;
                userIds = null != orgIdList_1 && orgIdList_1.contains(orgId) ? UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true) : UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)false);
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "responsibledept": {
                DynamicObject responsiblePreson = this.getModel().getDataEntity().getDynamicObject("responsibleperson");
                if (null == customMap.get("deptId")) break;
                Long orgId = Long.valueOf(customMap.get("deptId").toString());
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                List orgIdList = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), orgIds, (boolean)true);
                String userId = RequestContext.get().getUserId();
                if (responsiblePreson != null) {
                    userId = responsiblePreson.getPkValue().toString();
                }
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                QFilter orgFilter = null;
                if (null != orgIdList_1 && orgIdList_1.contains(orgId)) {
                    orgFilter = new QFilter("id", "in", (Object)orgIdList);
                } else {
                    List allDeptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    allDeptList.retainAll(orgIdList);
                    orgFilter = new QFilter("id", "in", (Object)allDeptList);
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "cooperationperson": {
                DynamicObject cooperationDept = this.getModel().getDataEntity().getDynamicObject("cooperationdept");
                if (cooperationDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(cooperationDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "cooperationdept": {
                DynamicObject cooperationPreson = this.getModel().getDataEntity().getDynamicObject("cooperationperson");
                if (cooperationPreson == null) break;
                String userId = cooperationPreson.getPkValue().toString();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                deptIds.removeAll(orgIdList_1);
                deptIds.addAll(orgIdList_1);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        if (null != customMap.get("actionId") && StringUtils.equals((CharSequence)((String)customMap.get("actionId")), (CharSequence)"newentry")) {
            Object taskSeq = customMap.get("seq");
            this.getModel().setValue("taskseq", taskSeq);
            Object parentTaskId = customMap.get("parenttaskid");
            if (parentTaskId != null) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle(parentTaskId, (String)(this.getAppId() + "_" + "task"));
                this.getModel().setValue("level", (Object)(parent.getInt("level") + 1));
                this.getModel().setValue("parent", parentTaskId);
                this.getModel().setValue("isleaf", (Object)"1");
            }
            QFilter[] filters = new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTPLAN.getValue())};
            DynamicObject[] majors = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])filters);
            if (null != majors && majors.length > 0) {
                this.getModel().setValue("belongplantype", (Object)majors[0]);
            }
            if (null != customMap.get("deptId")) {
                this.getModel().setValue("responsibledept", customMap.get("deptId"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isImport;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        boolean bl = isImport = null != customMap.get("isImport") && (Boolean)customMap.get("isImport") != false;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save") && !isImport && null != customMap.get("starttime") && null != customMap.get("endtime")) {
            String starttime = customMap.get("starttime").toString();
            String endtime = customMap.get("endtime").toString();
            Date taskstarttimeFrom = null;
            Date taskendtimeTo = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                taskstarttimeFrom = dateFormat.parse(starttime);
                taskendtimeTo = dateFormat.parse(endtime);
            }
            catch (ParseException e) {
                LOG.error(e.getMessage());
            }
            boolean flag = this.responsAndCoopration(taskstarttimeFrom, taskendtimeTo);
            if (!flag) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0e\u90e8\u95e8\u8ba1\u5212\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u3002", (String)"DeptPlanTaskFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    protected boolean responsAndCoopration(Date taskstarttimeFrom, Date taskendtimeTo) {
        Date planstarttime = (Date)this.getModel().getValue("planstarttime");
        Date planendtime = (Date)this.getModel().getValue("planendtime");
        if (planstarttime.equals(taskstarttimeFrom) && planendtime.equals(taskendtimeTo)) {
            return true;
        }
        return !planendtime.before(taskstarttimeFrom) && !planstarttime.after(taskendtimeTo);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateTimeDeviationColor();
        this.setDateEditRange();
        this.isImport();
    }

    protected void isImport() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        if (null != customMap.get("isImport") && ((Boolean)customMap.get("isImport")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "tasktype", "planstarttime", "planendtime", "aimfinishtime", "absoluteduration"});
        }
    }

    protected void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("planstarttime");
        DateEdit planEndTime = (DateEdit)this.getControl("planendtime");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        if (null != customMap.get("deptId")) {
            Object taskResDeptId = customMap.get("deptId");
            Date firstDay = TaskUtil.getFirstDayByOrg(taskResDeptId, (String)this.getAppId()).getTime();
            Date endDay = TaskUtil.getEndDayByOrg(taskResDeptId, (String)this.getAppId()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    protected void updateTimeDeviationColor() {
        BigDecimal comTimeDeviation = this.getModel().getDataEntity().getBigDecimal("comptimedeviation");
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            propMap.put("fc", "#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            propMap.put("fc", "#FF0000");
        }
        this.getView().updateControlMetadata("comptimedeviation", propMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        Object deptId = null;
        if (null != customMap.get("deptId")) {
            deptId = customMap.get("deptId");
        }
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        Date planEndTime = model.getDate("planendtime");
        Date aimEndTime = model.getDate("aimfinishtime");
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planstarttime")) {
            Date oldValue = (Date)changeSet.getOldValue();
            if (planStartTime != null && planEndTime != null && DateUtil.compareByDay((Date)planStartTime, (Date)planEndTime) > 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u665a\u4e8e\u4efb\u52a1\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u3002", (String)"DeptPlanTaskFormPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("planstarttime", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                return;
            }
            if (planStartTime != null) {
                this.calPlanTime("planstarttime", deptId);
                this.deptFenjie("planstarttime");
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planendtime")) {
            Date oldValue = (Date)changeSet.getOldValue();
            if (planStartTime != null && planEndTime != null && DateUtil.compareByDay((Date)planEndTime, (Date)planStartTime) < 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5e94\u665a\u4e8e\u7b49\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"DeptPlanTaskFormPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("planendtime", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("planendtime");
                return;
            }
            if (planEndTime != null) {
                if (aimEndTime == null) {
                    this.getModel().beginInit();
                    this.getModel().setValue("aimfinishtime", (Object)planEndTime);
                    this.getModel().endInit();
                    this.getView().updateView("aimfinishtime");
                }
                this.calPlanTime("planendtime", deptId);
                this.deptFenjie("planendtime");
                this.calCompTimeDeviation(deptId);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"aimfinishtime")) {
            this.calCompTimeDeviation(deptId);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"absoluteduration")) {
            BigDecimal oldValue = (BigDecimal)changeSet.getOldValue();
            BigDecimal newValue = (BigDecimal)changeSet.getNewValue();
            if (newValue.compareTo(BigDecimal.ONE) < 0) {
                this.getModel().setValue("absoluteduration", (Object)oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u9700\u8981\u5927\u4e8e0\u3002", (String)"DeptPlanTaskFormPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            this.calPlanTime("absoluteduration", deptId);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"cooperationperson") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"responsibleperson")) {
            DynamicObject zeren = (DynamicObject)this.getModel().getValue("responsibleperson");
            DynamicObject xieban = (DynamicObject)this.getModel().getValue("cooperationperson");
            if (zeren != null && xieban != null && StringUtils.equalsIgnoreCase((CharSequence)zeren.getPkValue().toString(), (CharSequence)xieban.getPkValue().toString())) {
                this.getModel().setValue("cooperationperson", null);
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u534f\u529e\u4eba\uff0c\u4e0d\u80fd\u4e0e\u8d23\u4efb\u4eba\u76f8\u540c\u3002", (String)"DeptPlanTaskFormPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject xiebanDept = (DynamicObject)this.getModel().getValue("cooperationdept");
            if (null != xieban && null == xiebanDept) {
                String userId = xieban.getPkValue().toString();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                deptIds.removeAll(orgIdList_1);
                deptIds.addAll(orgIdList_1);
                if (deptIds.size() > 0) {
                    this.getModel().setValue("cooperationdept", deptIds.get(0));
                }
            }
            DynamicObject zerenDept = (DynamicObject)this.getModel().getValue("responsibledept");
            if (null != zeren && null == zerenDept) {
                String userId = zeren.getPkValue().toString();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List orgIdList_1 = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                deptIds.removeAll(orgIdList_1);
                deptIds.addAll(orgIdList_1);
                if (deptIds.size() > 0) {
                    this.getModel().setValue("responsibledept", deptIds.get(0));
                }
            }
        }
    }

    protected void calCompTimeDeviation(Object taskResDeptId) {
        Date aimFinishTime = this.getModel().getDataEntity().getDate("aimfinishtime");
        Date planEndTime = this.getModel().getDataEntity().getDate("planendtime");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (taskResDeptId != null) {
            try {
                BigDecimal days = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planEndTime, (Date)aimFinishTime, (String)this.getAppId());
                this.getModel().setValue("comptimedeviation", (Object)days);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
                this.getModel().setValue("comptimedeviation", (Object)days);
            }
        } else {
            int days = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime);
            this.getModel().setValue("comptimedeviation", (Object)days);
        }
        this.getView().updateView("comptimedeviation");
        this.updateTimeDeviationColor();
    }

    protected void deptFenjie(String changeField) {
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        Date planEndTime = model.getDate("planendtime");
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("belongplantype");
        switch (changeField) {
            case "planstarttime": {
                Date parentStart;
                if (null == planStartTime || null == parent || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getPkValue().toString(), (CharSequence)"697516877831783424") || null == (parentStart = parent.getDate("planstarttime")) || DateUtil.compareByDay((Date)planStartTime, (Date)parentStart) >= 0) break;
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5206\u89e3\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"DeptPlanTaskFormPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "planendtime": {
                Date parentEnd;
                if (null == planEndTime || null == parent || null == plantype || !StringUtils.equalsIgnoreCase((CharSequence)plantype.getPkValue().toString(), (CharSequence)"697516877831783424") || null == (parentEnd = parent.getDate("planendtime")) || DateUtil.compareByDay((Date)planEndTime, (Date)parentEnd) <= 0) break;
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5206\u89e3\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4\u5e94\u65e9\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4\u3002", (String)"DeptPlanTaskFormPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    protected void calPlanTime(String changeField, Object taskResDeptId) {
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        BigDecimal absoluteDuration = model.getBigDecimal("absoluteduration");
        Date planEndTime = model.getDate("planendtime");
        switch (changeField) {
            case "absoluteduration": {
                if (planStartTime != null) {
                    Date newPlanEndTime;
                    this.getModel().beginInit();
                    if (taskResDeptId != null) {
                        try {
                            newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                            this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                        }
                        catch (KDBizException e) {
                            this.getView().showTipNotification(e.getMessage());
                            this.getModel().setValue("absoluteduration", (Object)1);
                        }
                    } else {
                        newPlanEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                        this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                    }
                    Date aimEndTime = (Date)this.getModel().getValue("aimfinishtime");
                    if (aimEndTime == null) {
                        Date newPlanEndTime2 = (Date)this.getModel().getValue("planendtime");
                        this.getModel().setValue("aimfinishtime", (Object)newPlanEndTime2);
                    }
                    this.calCompTimeDeviation(taskResDeptId);
                    this.getModel().endInit();
                    this.getView().updateView("planendtime");
                    this.getView().updateView("aimfinishtime");
                    this.deptFenjie("planendtime");
                    break;
                }
                if (planEndTime == null) break;
                this.getModel().beginInit();
                if (taskResDeptId != null) {
                    try {
                        Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        Date newPlanStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteDuration.intValue() + 1));
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    }
                } else {
                    Date newPlanStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteDuration.intValue() + 1));
                    this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                }
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                this.deptFenjie("planstarttime");
                break;
            }
            case "planendtime": {
                if (planStartTime != null) {
                    this.getModel().beginInit();
                    if (taskResDeptId != null) {
                        try {
                            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                            this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                        }
                        catch (KDBizException e) {
                            this.getView().showTipNotification(e.getMessage());
                            int newAbsoluteDuration = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)planEndTime) + 1;
                            this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration);
                        }
                    } else {
                        int newAbsoluteDuration = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)planEndTime) + 1;
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration);
                    }
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                if (taskResDeptId != null) {
                    try {
                        Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        Date newPlanStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteDuration.intValue() + 1));
                        this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                    }
                } else {
                    Date newPlanStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absoluteDuration.intValue() + 1));
                    this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                }
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                this.deptFenjie("planstarttime");
                break;
            }
            case "planstarttime": {
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
                    if (planEndTime == null) break;
                    this.getModel().beginInit();
                    if (taskResDeptId != null) {
                        try {
                            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)taskResDeptId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                            this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                        }
                        catch (KDBizException e) {
                            this.getView().showTipNotification(e.getMessage());
                            int newAbsoluteDuration = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)planEndTime) + 1;
                            this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration);
                        }
                    } else {
                        int newAbsoluteDuration = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)planEndTime) + 1;
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration);
                    }
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                if (absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                if (taskResDeptId != null) {
                    try {
                        Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)taskResDeptId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                        this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        Date newPlanEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                        this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                    }
                } else {
                    Date newPlanEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absoluteDuration.intValue() - 1));
                    this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                }
                this.calCompTimeDeviation(taskResDeptId);
                this.getModel().endInit();
                this.getView().updateView("planendtime");
                this.deptFenjie("planendtime");
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject parent;
        super.beforeClosed(e);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (null != this.getModel().getDataEntity() && null != this.getModel().getDataEntity().getPkValue()) {
            returnData.put("taskId", this.getModel().getDataEntity().getPkValue().toString());
        }
        if (null != (parent = (DynamicObject)this.getModel().getValue("parent"))) {
            returnData.put("parentTaskId", parent.getPkValue().toString());
        }
        int seq = (Integer)this.getModel().getValue("taskseq");
        returnData.put("seq", seq);
        this.getView().returnDataToParent(returnData);
    }
}

