/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanningCycleEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import kd.pccs.placs.formplugin.helper.TreeEntryGridHelper;

public class FuncPlanMonitorListPlugin
extends AbstractPlacsFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String KEY_TREEENTRYENTITY = "taskentity";
    private static final String CODE_EXPORT = "export";
    private static final String CODE_SEARCH = "search";
    private static final String CODE_QUERYCLICK = "queryclick";
    private static final int MAX_LEVEL = 6;
    private static final int TAB_SIZE = 1;
    private static final String LEVEL = "level";
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();
    private static String[] COLUMNKEY = new String[]{"taskname", "completionstatus", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "pretaskname", "planstarttime", "planendtime", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"FuncPlanMonitorListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"FuncPlanMonitorListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"FuncPlanMonitorListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"FuncPlanMonitorListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"FuncPlanMonitorListPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"FuncPlanMonitorListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"FuncPlanMonitorListPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6\uff08%\uff09", (String)"FuncPlanMonitorListPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"FuncPlanMonitorListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"FuncPlanMonitorListPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"FuncPlanMonitorListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"FuncPlanMonitorListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"FuncPlanMonitorListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0])};
    private Map<String, DynamicObject> mapAllTasks = null;

    private String getFileName() {
        return ResManager.loadKDString((String)"\u804c\u80fd\u8ba1\u5212\u76d1\u63a7", (String)"FuncPlanMonitorListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"FuncPlanMonitorListPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit belongplantype = (BasedataEdit)this.getControl("belongplantype");
        belongplantype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.levelLableAddListener(6, 1);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)"belongplantype", (CharSequence)propName)) {
            this.beforeDoBelongPlanType(arg0);
        }
    }

    protected void beforeDoBelongPlanType(BeforeF7SelectEvent arg0) {
        IFormView view = this.getView();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90", (String)"FuncPlanMonitorListPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        DynamicObject org = (DynamicObject)this.getModel().getValue("businessorg");
        if (org == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"FuncPlanMonitorListPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        Object planningcycle = this.getModel().getValue("planningcycle");
        if (planningcycle == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u5468\u671f\u3002", (String)"FuncPlanMonitorListPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        Object plantime = this.getModel().getValue("plantime");
        if (plantime == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65f6\u95f4\u3002", (String)"FuncPlanMonitorListPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        qFilters.add(orgFilter);
        QFilter cycleFilter = new QFilter("planningcycle", "=", (Object)PlanningCycleEnum.getEnumByValue((Object)planningcycle));
        qFilters.add(cycleFilter);
        QFilter timeFilter = new QFilter("STARTTIME", "<=", plantime).and("ENDTIME", ">=", plantime);
        qFilters.add(timeFilter);
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        qFilters.add(planVersion);
        HashSet<Object> planTypeIdSet = new HashSet<Object>();
        QFilter plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"id,taskentity,taskentity.taskid", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        HashSet<Object> allTaskids = new HashSet<Object>();
        if (plans == null || ((DynamicObject[])plans).length == 0) {
            QFilter planTypeIdFilter = new QFilter("id", "in", planTypeIdSet);
            showParameter.getListFilterParameter().getQFilters().add(planTypeIdFilter);
            return;
        }
        for (DynamicObject plan : plans) {
            DynamicObjectCollection taskentries = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
            if (taskentries == null || taskentries.isEmpty()) continue;
            for (DynamicObject entry : taskentries) {
                Object id = entry.getPkValue();
                allTaskids.add(id);
            }
        }
        if (allTaskids.isEmpty()) {
            QFilter planTypeIdFilter = new QFilter("id", "in", planTypeIdSet);
            showParameter.getListFilterParameter().getQFilters().add(planTypeIdFilter);
            return;
        }
        QFilter ids = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        DynamicObject[] allTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,belongplantype,tasksource", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq");
        QFilter assignTaskFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject assginTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id,number", (QFilter[])new QFilter[]{assignTaskFilter});
        for (DynamicObject task : allTasks) {
            DynamicObject taskSource = task.getDynamicObject("tasksource");
            if (taskSource != null && StringUtils.equalsIgnoreCase((CharSequence)taskSource.getString("id"), (CharSequence)assginTask.getString("id"))) {
                planTypeIdSet.add(taskSource.getPkValue());
                continue;
            }
            DynamicObject belongplantype = task.getDynamicObject("belongplantype");
            if (belongplantype == null) continue;
            planTypeIdSet.add(belongplantype.getPkValue());
        }
        QFilter planTypeIdFilter = new QFilter("id", "in", planTypeIdSet);
        showParameter.getListFilterParameter().getQFilters().add(planTypeIdFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_EXPORT.equals(operateKey)) {
            this.doExportExcel();
        } else if (CODE_SEARCH.equals(operateKey)) {
            this.doSearch();
        } else if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_24", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"true");
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"FuncPlanMonitorListPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"false");
            }
        }
    }

    protected void levelLableAddListener(int maxLevel, int tabSize) {
        for (int i = 1; i <= maxLevel * tabSize; ++i) {
            Label level = (Label)this.getControl("level_" + i);
            level.addClickListener((ClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideLevelNum();
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (map.size() == 0 || null == map) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    protected void hideLevelNum() {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (taskEntries.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
        }
        int maxLevel = 0;
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DynamicObject en : taskEntries) {
            map.put(en.getString("id"), en.getLong("pid"));
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        maxLevel = max.isPresent() ? max.get() : 0;
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        for (int i = 1; i <= 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                if (maxLevel < i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String levelColKey = "";
        String treeEntityKey = "";
        if (key.contains(LEVEL)) {
            int level = Integer.parseInt(key.split("_")[1]);
            if (level <= 6 && level > 0) {
                treeEntityKey = KEY_TREEENTRYENTITY;
                levelColKey = "task";
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeEntityKey);
            Map all = this.getPageCache().getAll();
            all.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("@taskId")).forEach(entry -> this.taskLevelMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("@taskId")), Integer.valueOf((String)entry.getValue())));
            TreeEntryGridHelper.expandNodes(treeEntryGrid, levelColKey, level, this.taskLevelMap);
        }
    }

    private void doSearch() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("businessorg");
        Object planningCycle = this.getModel().getValue("planningCycle");
        Object plantime = this.getModel().getValue("plantime");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"FuncPlanMonitorListPlugin_30", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (planningCycle == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u5468\u671f\u3002", (String)"FuncPlanMonitorListPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (plantime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65f6\u95f4\u3002", (String)"FuncPlanMonitorListPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        FormDataModel dataModel = (FormDataModel)grid.getModel();
        dataModel.deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] deptPlans = this.getDeptPlans(org, planningCycle, plantime);
        this.hideLevelNum();
        if (deptPlans == null || deptPlans.length == 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"FuncPlanMonitorListPlugin_31", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> allTaskids = new ArrayList<Object>(10);
        HashMap<String, DynamicObject> taskEntryMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entries = new DynamicObjectCollection();
        this.getTaskEntryFromDept(deptPlans, allTaskids, taskEntryMap, entries);
        if (allTaskids.isEmpty()) {
            return;
        }
        QFilter ids = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        DynamicObject[] allTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,parent,tasktype,controllevel,planstarttime,planendtime,sourcetask,status,completionstatus,realtimedeviation,comptimedeviation,belongplantype,percent,relationtask,completedescription,level", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq");
        this.mapAllTasks = new HashMap<String, DynamicObject>(16);
        HashMap<String, QFilter> mapFilters = new HashMap<String, QFilter>(16);
        this.constructTaskFilter(mapFilters);
        this.filterTask(taskEntryMap, allTasks, mapFilters);
        if (taskEntryMap.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"FuncPlanMonitorListPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.batchCreateTaskEntryRows(grid, taskEntryMap);
        this.getView().updateView(KEY_TREEENTRYENTITY);
        this.hideLevelNum();
    }

    private void getTaskEntryFromDept(DynamicObject[] deptPlans, List<Object> allTaskids, Map<String, DynamicObject> taskEntryMap, DynamicObjectCollection entries) {
        for (DynamicObject plan : deptPlans) {
            DynamicObjectCollection taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
            if (taskEntry == null || taskEntry.isEmpty()) continue;
            entries.addAll((Collection)taskEntry);
        }
        for (DynamicObject entry : entries) {
            Object id = entry.getPkValue();
            allTaskids.add(id);
            taskEntryMap.put(id.toString(), entry);
        }
    }

    private void batchCreateTaskEntryRows(TreeEntryGrid grid, Map<String, DynamicObject> mapEntries) {
        DynamicObjectCollection afterFilterEntries = new DynamicObjectCollection();
        Iterator<Map.Entry<String, DynamicObject>> iter = mapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            afterFilterEntries.add((Object)iter.next().getValue());
        }
        afterFilterEntries.sort(Comparator.comparing(obj -> obj.getInt("seq")));
        DynamicObjectCollection taskEntityCols = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = taskEntityCols.getDynamicObjectType();
        DynamicObject newTaskObj = null;
        DynamicObject taskObj = null;
        ArrayList<Integer> taskIndexFromMainPlans = new ArrayList<Integer>(afterFilterEntries.size());
        for (int i = 0; i < afterFilterEntries.size(); ++i) {
            taskObj = (DynamicObject)afterFilterEntries.get(i);
            newTaskObj = new DynamicObject(dt);
            DynamicObject task = this.mapAllTasks.get(taskObj.getString("id"));
            if (task != null) {
                newTaskObj.set("id", task.getPkValue());
                newTaskObj.set("task", (Object)task);
                BigDecimal realtimedeviation = task.getBigDecimal("realtimedeviation");
                if (realtimedeviation.compareTo(BigDecimal.ZERO) < 0) {
                    newTaskObj.set("overduedays", (Object)realtimedeviation.multiply(new BigDecimal(-1)));
                }
                newTaskObj.set("pid", (Object)(task.getDynamicObject("parent") == null ? "0" : task.getDynamicObject("parent").getPkValue().toString()));
                newTaskObj.set("completionstatusvalue", task.get("completionstatus"));
                DynamicObject relateTask = task.getDynamicObject("relationtask");
                if (relateTask != null) {
                    taskIndexFromMainPlans.add(i);
                }
            }
            taskEntityCols.add((Object)newTaskObj);
        }
        int[] taskIndexFromMainPlan = taskIndexFromMainPlans.stream().mapToInt(Integer::intValue).toArray();
        grid.setRowLock(true, taskIndexFromMainPlan);
        grid.setRowBackcolor("lightgrey", taskIndexFromMainPlan);
        this.getModel().updateEntryCache(taskEntityCols);
        this.setTextColor(grid);
        grid.setCollapse(false);
        grid.getModel().updateCache();
        grid.getModel().updateEntryCache(taskEntityCols);
        this.getModel().updateEntryCache(taskEntityCols);
    }

    private void filterTask(Map<String, DynamicObject> mapEntries, DynamicObject[] allTasks, Map<String, QFilter> mapFilters) {
        for (DynamicObject task : allTasks) {
            this.mapAllTasks.put(task.getPkValue().toString(), task);
            Object controllevel = task.get("controllevel.id");
            if (mapFilters.get("controllevel.id") != null) {
                Object levelIds = mapFilters.get("controllevel.id").getValue();
                ArrayList<Long> levelList = new ArrayList<Long>(10);
                if (levelIds instanceof List) {
                    for (Object obj : (List)levelIds) {
                        levelList.add((Long)obj);
                    }
                }
                if (!levelList.isEmpty() && !levelList.contains(controllevel)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            DynamicObject taskType = task.getDynamicObject("tasktype");
            if (mapFilters.get("tasktype.id") != null && taskType != null) {
                Object typeIds = mapFilters.get("tasktype.id").getValue();
                ArrayList<Long> taskTypeList = new ArrayList<Long>(10);
                if (typeIds instanceof List) {
                    Object obj;
                    obj = ((List)typeIds).iterator();
                    while (obj.hasNext()) {
                        Object obj2 = obj.next();
                        taskTypeList.add((Long)obj2);
                    }
                }
                if (!taskTypeList.isEmpty() && !taskTypeList.contains(taskType.getPkValue())) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object completionStatus = task.get("completionstatus");
            if (mapFilters.get("completionstatus") != null) {
                Object statusIds = mapFilters.get("completionstatus").getValue();
                ArrayList<String> statusList = new ArrayList<String>(10);
                if (statusIds instanceof List) {
                    for (Object obj : (List)statusIds) {
                        statusList.add((String)obj);
                    }
                }
                if (!statusList.isEmpty() && !statusList.contains(completionStatus)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object belongPlanType = task.get("belongplantype.id");
            if (mapFilters.get("belongplantype.id") == null) continue;
            Object planTypeIds = mapFilters.get("belongplantype.id").getValue();
            ArrayList<Long> belongPlantypeList = new ArrayList<Long>(10);
            if (planTypeIds instanceof List) {
                for (Object obj : (List)planTypeIds) {
                    belongPlantypeList.add((Long)obj);
                }
            }
            if (belongPlantypeList.isEmpty() || belongPlantypeList.contains(belongPlanType)) continue;
            mapEntries.remove(task.getPkValue().toString());
        }
    }

    private void constructTaskFilter(Map<String, QFilter> mapFilters) {
        DynamicObjectCollection belongPlanTypes;
        Object completionStatusObj;
        DynamicObjectCollection tasktypes;
        DynamicObjectCollection controllevels = (DynamicObjectCollection)this.getModel().getValue("controllevel");
        if (!controllevels.isEmpty()) {
            QFilter filter1 = new QFilter("controllevel.id", "in", controllevels.stream().map(controllevel -> controllevel.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("controllevel.id", filter1);
        }
        if (!(tasktypes = (DynamicObjectCollection)this.getModel().getValue("tasktype")).isEmpty()) {
            QFilter filter2 = new QFilter("tasktype.id", "in", tasktypes.stream().map(tasktype -> tasktype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("tasktype.id", filter2);
        }
        if ((completionStatusObj = this.getModel().getValue("completionstatus")) != null) {
            String completionStatusText = this.getModel().getValue("completionstatus").toString();
            String[] completionStatusArray = completionStatusText.split(",");
            ArrayList<String> compleStatusList = new ArrayList<String>(10);
            for (String status : completionStatusArray) {
                if (status == null) continue;
                compleStatusList.add(status);
            }
            QFilter filter3 = new QFilter("completionstatus", "in", compleStatusList);
            mapFilters.put("completionstatus", filter3);
        }
        if (!(belongPlanTypes = (DynamicObjectCollection)this.getModel().getValue("belongplantype")).isEmpty()) {
            QFilter filter4 = new QFilter("belongplantype.id", "in", belongPlanTypes.stream().map(belongplantype -> belongplantype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("belongplantype.id", filter4);
        }
    }

    private DynamicObject[] getDeptPlans(DynamicObject org, Object planningCycle, Object plantime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        qFilters.add(orgFilter);
        QFilter cycleFilter = new QFilter("planningcycle", "=", (Object)PlanningCycleEnum.getEnumByValue((Object)planningCycle));
        qFilters.add(cycleFilter);
        QFilter timeFilter = new QFilter("STARTTIME", "<=", plantime).and("ENDTIME", ">=", plantime);
        qFilters.add(timeFilter);
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        qFilters.add(planVersion);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"id,taskentity,taskentity.taskid,taskentity.pid,taskentity.seq,taskentity.level,taskentity.isleaf", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return plans;
    }

    private void doExportExcel() {
        JSONArray data;
        DynamicObjectCollection rowDatas = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (!rowDatas.isEmpty()) {
            data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject row : rowDatas) {
                JSONObject obj = new JSONObject();
                DynamicObject task = row.getDynamicObject("task");
                obj.put("taskname", (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("completionstatus", (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                this.projectNameToJson(obj, task, "project", "project");
                obj.put("controllevelname", task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("majortypename", task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("tasktype", task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("absoluteduration", (Object)task.getInt("absoluteduration"));
                obj.put("percent", (Object)task.getBigDecimal("percent").setScale(2));
                obj.put("pretaskname", task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
                obj.put("planendtime", (Object)sdf.format(task.get("planendtime")));
                Date aimFinishTime = task.getDate("aimfinishtime");
                if (aimFinishTime == null) {
                    obj.put("aimfinishtime", (Object)aimFinishTime);
                } else {
                    obj.put("aimfinishtime", (Object)sdf.format(aimFinishTime));
                }
                obj.put("responsiblepersonname", task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("responsibledeptname", task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                StringBuilder cooPersonsStr = new StringBuilder();
                cooPersons.stream().map(o -> cooPersonsStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
                if (cooPersonsStr.length() > 0) {
                    cooPersonsStr.deleteCharAt(cooPersonsStr.length() - 1);
                }
                obj.put("cooperationpersonsname", (Object)cooPersonsStr);
                obj.put("resultdoc", task.get("resultdoc"));
                data.add((Object)obj);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"FuncPlanMonitorListPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
        this.getView().download(url);
    }

    protected void projectNameToJson(JSONObject obj, DynamicObject task, String project, String project2) {
        obj.put(project, task.getDynamicObject(project2) == null ? null : task.getDynamicObject(project2).getLocaleString("name").getLocaleValue_zh_CN());
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
        String pkId = String.valueOf(task.getPkValue());
        if (StringUtils.equals((CharSequence)"taskname", (CharSequence)fieldName) && task != null) {
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", pkId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
        if (StringUtils.equals((CharSequence)"meetassigncount", (CharSequence)fieldName)) {
            if (task.getLong("meetassigncount") == 0L) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8be5\u4efb\u52a1\u65e0\u4f1a\u8bae\u51b3\u8bae\u3002", (String)"FuncPlanMonitorListPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(paramMap);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("planningcycle".equalsIgnoreCase(key) || "plantime".equalsIgnoreCase(key)) {
            this.setTimeRange();
        }
    }

    private void setTimeRange() {
        String planningcycle = (String)this.getModel().getValue("planningcycle");
        Date plantime = (Date)this.getModel().getValue("plantime");
        Date start = null;
        Date end = null;
        if (null != plantime) {
            if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.YEAR.getValue())) {
                start = DateUtil.getYearFirst((Date)plantime);
                end = DateUtil.getYearLast((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.HALFYEAR.getValue())) {
                start = DateUtil.getHalfYearStartTime((Date)plantime);
                end = DateUtil.getHalfYearEndTime((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.QUART.getValue())) {
                start = DateUtil.getQuarterStartTime((Date)plantime);
                end = DateUtil.getQuarterEndTime((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.MONTH.getValue())) {
                start = DateUtil.getFirstDayOfThisMonth((Date)plantime);
                end = DateUtil.getLastDayOfThisMonth((Date)plantime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)planningcycle, (CharSequence)PlanningCycleEnum.WEEK.getValue())) {
                start = DateUtil.getThisWeekMonday((Date)plantime);
                end = DateUtil.getThisWeekSunDay((Date)plantime);
            }
        }
        this.getModel().setValue("starttime", start);
        this.getModel().setValue("endtime", end);
    }

    private void setTextColor(TreeEntryGrid grid) {
        int rows = this.getModel().getEntryRowCount(KEY_TREEENTRYENTITY);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        for (int i = 0; i < rows; ++i) {
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("overduedays");
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", i);
            BigDecimal rtd = task.getBigDecimal("realtimedeviation");
            if (rtd.compareTo(BigDecimal.ZERO) < 0) {
                style.setForeColor("red");
            }
            styles.add(style);
            CellStyle style1 = new CellStyle();
            style1.setRow(i);
            style1.setFieldKey("taskname");
            String riskColor = task.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style1.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style1.setBackColor("#FD6C6A");
            }
            styles.add(style1);
        }
        grid.setCellStyle(styles);
    }
}

