/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ImportProjectPlanPlugin
extends AbstractPlacsFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(ImportProjectPlanPlugin.class);
    private SimpleDateFormat DATAFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String OKBTN = "okbtn";
    private static final String CANCELBTN = "cancelbtn";
    private static final String KEY_SEARCHAP = "searchap";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(KEY_SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{OKBTN, CANCELBTN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDate(null);
    }

    public void search(SearchEnterEvent arg0) {
        String searchText = arg0.getText();
        this.initDate(searchText);
    }

    public void click(EventObject evt) {
        String btnKey;
        Button source = (Button)evt.getSource();
        switch (btnKey = source.getKey()) {
            case "okbtn": {
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(ENTRYENTITY);
                int[] rows = entryGrid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u4efb\u52a1\u3002", (String)"ImportProjectPlanPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<String> list = new ArrayList<String>(10);
                for (int row : rows) {
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
                    String pkId = rowObj.getString("id");
                    list.add(pkId);
                }
                this.getView().returnDataToParent(list);
                this.getView().invokeOperation("close");
                break;
            }
            case "cancelbtn": {
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void initDate(String searchKey) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(ENTRYENTITY);
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData(ENTRYENTITY);
        String userId = RequestContext.get().getUserId();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object startTime = parameter.getCustomParam("starttime");
        Object endTime = parameter.getCustomParam("endtime");
        List taskIds = (List)parameter.getCustomParam("taskIds");
        ArrayList<Long> taskLongIdList = new ArrayList<Long>(10);
        if (taskIds != null) {
            for (String taskId : taskIds) {
                taskLongIdList.add(Long.valueOf(taskId));
            }
        }
        Date startTimeFrom = null;
        Date endTimeTo = null;
        try {
            startTimeFrom = this.DATAFORMAT.parse(startTime.toString());
            endTimeTo = this.DATAFORMAT.parse(endTime.toString());
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002" + px);
        }
        QFilter respUserFilter = new QFilter("responsibleperson", "=", (Object)Long.valueOf(userId));
        QFilter coopUserFilter = new QFilter("multicooperationperson.fbasedataid.id", "=", (Object)Long.valueOf(userId));
        QFilter userFilter = respUserFilter.or(coopUserFilter);
        QFilter completionstatus1 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        QFilter completionstatus2 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
        QFilter completeStatusFilter = completionstatus1.and(completionstatus2);
        QFilter projectTaskFilter = new QFilter("belongplantype.plantype", "in", (Object)new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.MAJORPLAN.getValue()});
        QFilter filterProject = new QFilter("project", "<>", (Object)0);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        QFilter time1 = new QFilter("planstarttime", ">=", (Object)startTimeFrom).and(new QFilter("planstarttime", "<=", (Object)endTimeTo));
        QFilter time2 = new QFilter("planendtime", ">=", (Object)startTimeFrom).and(new QFilter("planendtime", "<=", (Object)endTimeTo));
        QFilter time3 = new QFilter("planstarttime", "<=", (Object)startTimeFrom).and(new QFilter("planendtime", ">=", (Object)endTimeTo));
        QFilter jJtime = time1.or(time2).or(time3);
        QFilter beginTime = new QFilter("planendtime", "<=", (Object)startTimeFrom);
        QFilter timeFilter = jJtime.or(beginTime);
        QFilter taskFilter = new QFilter("id", "not in", taskLongIdList);
        QFilter nameFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            nameFilter = new QFilter("name", "like", (Object)("%" + searchKey + "%"));
        }
        QFilter[] taskfilters = nameFilter == null ? new QFilter[]{userFilter, completeStatusFilter, projectTaskFilter, filterProject, timeFilter, latestTaskFilter, taskFilter} : new QFilter[]{userFilter, completeStatusFilter, projectTaskFilter, filterProject, timeFilter, latestTaskFilter, taskFilter, nameFilter};
        DynamicObject[] showTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])taskfilters, (String)"project asc");
        Set taskIdSet = Arrays.stream(showTasks).map(o -> o.getPkValue().toString()).collect(Collectors.toSet());
        if (showTasks == null || showTasks.length == 0) {
            return;
        }
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType taskEntryDT = MetaDataUtil.getEntryDT((String)this.getAppId(), (String)"importprojecttask", (String)ENTRYENTITY);
        for (DynamicObject task : showTasks) {
            DynamicObject parent;
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            newEntry.set("id", task.get("id"));
            newEntry.set("name", task.get("name"));
            newEntry.set("project", task.get("project"));
            newEntry.set("tasktype", task.get("tasktype"));
            newEntry.set("seq", task.get("taskseq"));
            newEntry.set("controllevel", task.get("controllevel"));
            newEntry.set("planstarttime", task.get("planstarttime"));
            newEntry.set("planendtime", task.get("planendtime"));
            newEntry.set("absoluteduration", task.get("absoluteduration"));
            newEntry.set("responsibleperson", task.get("responsibleperson"));
            newEntry.set("responsibledept", task.get("responsibledept"));
            newEntry.set("multicooperationperson", task.get("multicooperationperson"));
            newEntry.set("multicooperationdept", task.get("multicooperationdept"));
            for (parent = task.getDynamicObject("parent"); parent != null && !taskIdSet.contains(parent.getPkValue().toString()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            taskEntries.add((Object)newEntry);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(ENTRYENTITY);
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView(ENTRYENTITY);
    }
}

