/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ImportTaskPlugin
extends AbstractPlacsFormPlugin
implements SelectRowsEventListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(ImportTaskPlugin.class);
    private SimpleDateFormat DATAFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String TREEENTRYENTITY1 = "treeentryentity1";
    private static final String ADDBUTTONAP = "addbuttonap";
    private static final String DELBUTTONAP = "delbuttonap";
    private static final String OKBTN = "okbtn";
    private static final String CANCELBTN = "cancelbtn";
    private static final String KEY_SEARCHAP = "searchap";
    private static final String OLD_TREELIST_SEARCH_TEXT_KEY = "old_treelist_search_text";
    private static final String SEARCH_TREELIST_RESULT_KEY = "search_treelist_result_key";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search treeListSearch = (Search)this.getView().getControl(KEY_SEARCHAP);
        treeListSearch.addEnterListener((SearchEnterListener)this);
        TreeEntryGrid control = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        control.addSelectRowsListener((SelectRowsEventListener)this);
        TreeEntryGrid control1 = (TreeEntryGrid)this.getControl(TREEENTRYENTITY1);
        control1.addSelectRowsListener((SelectRowsEventListener)this);
        this.addClickListeners(new String[]{DELBUTTONAP, ADDBUTTONAP, OKBTN, CANCELBTN});
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        FormOperate formOperate = (FormOperate)arg.getSource();
        String key = formOperate.getOperateKey();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY1);
        IDataModel dataModel = treeEntry.getModel();
        int rowCount = dataModel.getEntryRowCount(TREEENTRYENTITY1);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowEntity = dataModel.getEntryRowEntity(TREEENTRYENTITY1, i);
            DynamicObject taskObject1 = (DynamicObject)rowEntity.get("taskname1");
            String taskObjectid1 = taskObject1.get("id").toString();
            list.add(taskObjectid1);
        }
        switch (key) {
            case "add": {
                int j;
                TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
                int[] rows = treeEntryGrid.getSelectRows();
                IDataModel model = treeEntryGrid.getModel();
                if (rowCount > 0) {
                    if (rows == null || rows.length <= 0) break;
                    for (j = 0; j < rows.length; ++j) {
                        for (int i = 0; i < rowCount; ++i) {
                            DynamicObject entryRowEntity = model.getEntryRowEntity(TREEENTRYENTITY, rows[j]);
                            DynamicObject taskObject = (DynamicObject)entryRowEntity.get("taskname");
                            String taskObjectid = taskObject.get("id").toString();
                            if (list.contains(taskObjectid)) continue;
                            list.add(taskObjectid);
                            int rIndex = model.createNewEntryRow(TREEENTRYENTITY1);
                            this.getModel().setValue("taskname1", (Object)taskObject, rIndex);
                        }
                    }
                }
                if (rowCount != 0) break;
                for (j = 0; j < rows.length; ++j) {
                    DynamicObject entryRowEntity = model.getEntryRowEntity(TREEENTRYENTITY, rows[j]);
                    int rIndex = model.createNewEntryRow(TREEENTRYENTITY1);
                    this.getModel().setValue("taskname1", entryRowEntity.get("taskname"), rIndex);
                }
                break;
            }
            case "del": {
                int[] selectRows = treeEntry.getSelectRows();
                dataModel.deleteEntryRows(TREEENTRYENTITY1, selectRows);
                break;
            }
            case "submit": {
                ArrayList listcheck = new ArrayList(rowCount);
                HashMap<String, String> map = null;
                for (int i = 0; i < rowCount; ++i) {
                    map = new HashMap<String, String>();
                    DynamicObject rowEntity = dataModel.getEntryRowEntity(TREEENTRYENTITY1, i);
                    DynamicObject taskObject1 = (DynamicObject)rowEntity.get("taskname1");
                    String taskObjectid1 = taskObject1.get("id").toString();
                    map.put("taskid", taskObjectid1);
                    String level = taskObject1.get("level").toString();
                    map.put("level", level);
                    listcheck.add(map);
                }
                if (listcheck.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u3002", (String)"ImportTaskPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().returnDataToParent(listcheck);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDate();
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        String searchText = arg0.getText();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_SEARCHAP, (CharSequence)search.getKey())) {
            ImportTaskPlugin.searchPage(this.getView(), pageCache, searchText);
        }
    }

    public static void searchPage(IFormView view, IPageCache pageCache, String searchText) {
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            int size;
            searchText = searchText.trim();
            JSONArray results = new JSONArray();
            JSONObject result = null;
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl(TREEENTRYENTITY);
            String oldSearchText = pageCache.get(OLD_TREELIST_SEARCH_TEXT_KEY);
            pageCache.put(OLD_TREELIST_SEARCH_TEXT_KEY, searchText);
            if (oldSearchText == null || !oldSearchText.equals(searchText)) {
                IDataModel model = treeEntryGrid.getModel();
                DynamicObjectCollection rows = model.getEntryEntity(TREEENTRYENTITY);
                JSONObject resultData = new JSONObject();
                int j = 0;
                if (results.isEmpty()) {
                    for (int i = 0; i < rows.size(); ++i) {
                        boolean isExistName;
                        DynamicObject row = (DynamicObject)rows.get(i);
                        String name = row.getString("searchname");
                        boolean bl = isExistName = name != null && name.contains(searchText);
                        if (!isExistName) continue;
                        resultData.put("row" + j, (Object)(row.getString("row") + "@@&&" + row.getString("prow")));
                        results.add((Object)resultData);
                        ++j;
                    }
                    int size2 = results.size();
                    if (size2 > 0) {
                        result = results.getJSONObject(0);
                        if (size2 == 1) {
                            pageCache.put(OLD_TREELIST_SEARCH_TEXT_KEY, null);
                        }
                        results.remove((Object)result);
                        pageCache.put(SEARCH_TREELIST_RESULT_KEY, results.toString());
                    }
                }
            } else if (pageCache.get(SEARCH_TREELIST_RESULT_KEY) != null && (size = (results = JSONArray.parseArray((String)pageCache.get(SEARCH_TREELIST_RESULT_KEY))).size()) > 0) {
                result = results.getJSONObject(0);
                if (size == 1) {
                    pageCache.put(OLD_TREELIST_SEARCH_TEXT_KEY, null);
                }
                results.remove((Object)result);
                pageCache.put(SEARCH_TREELIST_RESULT_KEY, results.toString());
            }
            if (result == null) {
                view.showMessage(ResManager.loadKDStringExt((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"ImportTaskPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < result.size(); ++i) {
                    String row = result.getString("row" + i);
                    if (!StringUtils.isNotEmpty((CharSequence)row)) continue;
                    list.add(Integer.valueOf(row.split("@@&&")[1]));
                }
                int[] ints = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ints[i] = (Integer)list.get(i);
                }
                Integer[] array = list.toArray(new Integer[list.size()]);
                int fouce = array[0];
                treeEntryGrid.selectRows(ints, fouce);
            }
        }
    }

    private void initDate() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        IDataModel model = treeEntryGrid.getModel();
        model.deleteEntryData(TREEENTRYENTITY);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String userId = RequestContext.get().getUserId();
        Object startTime = parameter.getCustomParam("starttime");
        Object endTime = parameter.getCustomParam("endtime");
        List importedTaskIds = (List)parameter.getCustomParam("importedTaskIds");
        Date startTimeFrom = null;
        Date endTimeTo = null;
        try {
            startTimeFrom = this.DATAFORMAT.parse(startTime.toString());
            endTimeTo = this.DATAFORMAT.parse(endTime.toString());
            Calendar c = Calendar.getInstance();
            c.setTime(endTimeTo);
            c.add(5, 1);
            endTimeTo = c.getTime();
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002" + px);
        }
        QFilter respUserFilter = new QFilter("responsibleperson", "=", (Object)Long.valueOf(userId));
        QFilter coopUserFilter = new QFilter("multicooperationperson.fbasedataid.id", "=", (Object)Long.valueOf(userId));
        QFilter userFilter = respUserFilter.or(coopUserFilter);
        QFilter completionstatus1 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        QFilter completionstatus2 = new QFilter("completionstatus", "<>", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
        QFilter completeStatusFilter = completionstatus1.and(completionstatus2);
        QFilter belongPlanTypeFilter = new QFilter("belongplantype.plantype", "in", (Object)new String[]{PlanTypeEnum.DEPTPLAN.getValue(), PlanTypeEnum.DEPTFENJIEPLAN.getValue()});
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        QFilter time1 = new QFilter("planstarttime", ">=", (Object)startTimeFrom).and(new QFilter("planstarttime", "<=", (Object)endTimeTo));
        QFilter time2 = new QFilter("planendtime", ">=", (Object)startTimeFrom).and(new QFilter("planendtime", "<=", (Object)endTimeTo));
        QFilter time3 = new QFilter("planstarttime", "<=", (Object)startTimeFrom).and(new QFilter("planendtime", ">=", (Object)endTimeTo));
        QFilter jJtime = time1.or(time2).or(time3);
        QFilter beginTime = new QFilter("planendtime", "<=", (Object)startTimeFrom);
        QFilter timeFilter = jJtime.or(beginTime);
        QFilter taskFilter = new QFilter("id", "not in", (Object)importedTaskIds);
        QFilter[] taskfilters = new QFilter[]{userFilter, completeStatusFilter, belongPlanTypeFilter, timeFilter, latestTaskFilter, taskFilter};
        DynamicObject[] showTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])taskfilters);
        int length = showTasks.length;
        if (length > 0) {
            int[] rows = model.batchCreateNewEntryRow(TREEENTRYENTITY, length);
            for (int i = 0; i < length; ++i) {
                this.getModel().setValue("taskname", showTasks[i].get("id"), rows[i]);
                this.getModel().setValue("searchname", showTasks[i].get("name"), rows[i]);
                this.getModel().setValue("prow", (Object)rows[i], rows[i]);
                this.getModel().setValue("row", (Object)rows[i], rows[i]);
                this.getModel().getEntryRowEntity(TREEENTRYENTITY, rows[i]).set("pid", showTasks[i].get("parent_id"));
                this.getModel().getEntryRowEntity(TREEENTRYENTITY, rows[i]).set("id", showTasks[i].get("id"));
            }
        }
    }
}

