/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.formplugin.base.AbstractPlacsTreeListPlugin;

public class MajortypeListPlugin
extends AbstractPlacsTreeListPlugin {
    private static final String NO_MAJOR_BACKCOLOR = "#E5E5E5";
    private static final String NEW_OPERATE = "new";
    private static final String DEFAULT_TREE_SEARCH_PANNEL = "flexpanel_treebtn";
    private static String[] PLANTYPEARRAY = new String[]{PlanTypeEnum.DEPTPLAN.getValue(), PlanTypeEnum.PRIVATEPLAN.getValue(), PlanTypeEnum.DEPTFENJIEPLAN.getValue()};

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterList = e.getQFilters();
        this.setFilterList(filterList);
    }

    protected void setFilterList(List<QFilter> filterList) {
        if (this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter() instanceof ListShowParameter) {
            String billFormId = ((ListShowParameter)this.getView().getParentView().getFormShowParameter()).getBillFormId();
            String projPlan = this.getAppId() + "_projectplan";
            if (projPlan.equals(billFormId)) {
                QFilter plantypeFilter = new QFilter("plantype", "not in", (Object)PLANTYPEARRAY);
                filterList.add(plantypeFilter);
                return;
            }
        }
        ListIterator<QFilter> iterator = filterList.listIterator();
        while (iterator.hasNext()) {
            QFilter filter = iterator.next();
            if (!"group".equals(filter.getProperty())) continue;
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_" + "majortype")).getProperties();
            block1: for (IDataEntityProperty property : properties) {
                if (!"group".equals(property.getName())) continue;
                String id = ((GroupProp)property).getBaseEntityId();
                DataEntityPropertyCollection groupProperties = EntityMetadataCache.getDataEntityType((String)id).getProperties();
                for (IDataEntityProperty groupProperty : groupProperties) {
                    if (!"parent".equals(groupProperty.getName())) continue;
                    filter.or(new QFilter("group.parent", "=", (Object)0L));
                    continue block1;
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeNode root = this.getTreeModel().getRoot();
        this.setTreeNodeView(root);
        this.getView().setVisible(Boolean.FALSE, new String[]{DEFAULT_TREE_SEARCH_PANNEL});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals(NEW_OPERATE)) {
            this.beforeNewOp(args);
        }
    }

    protected void beforeNewOp(BeforeDoOperationEventArgs args) {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        String id = this.getTreeModel().getRoot().getId();
        if (!id.equals(currentNodeId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(currentNodeId.toString()));
            qFilter.and(new QFilter("isleaf", "=", (Object)"1"));
            boolean isLeaf = QueryServiceHelper.exists((String)"bd_projectkind", (QFilter[])new QFilter[]{qFilter});
            if (!isLeaf) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u8282\u70b9\u3002", (String)"MajortypeListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected void cancelNewOperate(BeforeDoOperationEventArgs args) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u5206\u7c7b", (String)"MajortypeListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        args.setCancel(true);
    }

    protected void setTreeNodeView(TreeNode treeNode) {
        List children;
        String longNumber = treeNode.getLongNumber();
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            treeNode.setColor(NO_MAJOR_BACKCOLOR);
        }
        if ((children = treeNode.getChildren()) != null && children.size() > 0) {
            children.forEach(this::setTreeNodeView);
        }
    }

    public void expendTreeNode(TreeNodeEvent e) {
        super.expendTreeNode(e);
    }
}

