/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class MasterPlanAdjustComparePlugin
extends AbstractPlacsBillPlugin
implements TabSelectListener {
    private static final String KEY_ADJUSTTAB = "adjusttab";
    private static final String KEY_TAB = "tabap";
    private static final String KEY_DISPLAYFILTER = "displayfilter";
    private static final int MAX_LEVEL = 6;
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(KEY_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        if (KEY_ADJUSTTAB.equals(tabKey)) {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_DISPLAYFILTER, (Object)Boolean.FALSE);
            this.getView().updateView(KEY_DISPLAYFILTER);
            this.getModel().endInit();
            this.loadData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_DISPLAYFILTER.equals(key)) {
            this.loadData();
        }
    }

    protected void loadData() {
        DynamicObject basePlan = (DynamicObject)this.getModel().getValue("prechangeplan");
        String[] keys = new String[]{"treeentryentity"};
        if (basePlan == null) {
            this.hideLevelNum(keys);
            return;
        }
        DynamicObject prePlan = BusinessDataServiceHelper.loadSingle((Object)basePlan.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"masterplan"));
        DynamicObjectCollection prePlanTasksEntries = prePlan.getDynamicObjectCollection("taskentity");
        DynamicObjectCollection currentPlanTaskEntries = this.getModel().getEntryEntity("taskentity");
        DynamicObjectCollection adjustTaskEntries = this.getEntryEntity(prePlanTasksEntries, currentPlanTaskEntries);
        boolean isDisplay = Boolean.parseBoolean(this.getModel().getValue(KEY_DISPLAYFILTER).toString());
        if (isDisplay) {
            List collect = (List)adjustTaskEntries.stream().filter(entry -> entry.getInt("haschanged") == 1).collect(Collectors.toCollection(DynamicObjectCollection::new));
            adjustTaskEntries.clear();
            adjustTaskEntries.addAll((Collection)collect);
        }
        adjustTaskEntries.sort(Comparator.comparing(entry -> entry.getInt("seq")));
        this.getModel().updateEntryCache(adjustTaskEntries);
        this.getView().updateView("treeentryentity");
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeGrid.setCollapse(false);
        this.hideLevelNum(keys);
        this.initStyleTreeEntity(treeGrid);
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (null == map || map.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    protected int doFillLevelMap(DynamicObjectCollection taskEntries) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DynamicObject taskEnetity : taskEntries) {
            map.put(taskEnetity.getString("id"), taskEnetity.getLong("pid"));
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        return max.isPresent() ? max.get() : 0;
    }

    protected void hideLevelNum(String ... keys) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(keys[0]);
        if (entries.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjustlable"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"adjustlable"});
        }
        int maxLevel = this.doFillLevelMap(entries);
        for (int i = 1; i <= 6; ++i) {
            for (int j = 1; j < 2; ++j) {
                if (maxLevel < i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
            }
        }
    }

    protected DynamicObjectCollection getEntryEntity(DynamicObjectCollection prePlanTasksEntries, DynamicObjectCollection currentPlanTaskEntries) {
        Iterator adjustTask;
        DynamicObjectCollection adjustTaskEntries = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
        for (DynamicObject currentTask : currentPlanTaskEntries) {
            DynamicObject preChangeTask = currentTask.getDynamicObject("prechangetask");
            if (preChangeTask == null) {
                adjustTask = this.getCompareTask(null, currentTask, 1);
                adjustTask.set("statusvalue", 1);
                adjustTaskEntries.add((Object)adjustTask);
                continue;
            }
            for (DynamicObject preTask : prePlanTasksEntries) {
                if (!preTask.getPkValue().toString().equals(preChangeTask.getPkValue().toString())) continue;
                DynamicObject adjustTask2 = this.getCompareTask(preTask, currentTask, 2);
                adjustTask2.set("statusvalue", (Object)2);
                adjustTaskEntries.add((Object)adjustTask2);
            }
        }
        Set preTasks = currentPlanTaskEntries.stream().filter(entry -> entry.getDynamicObject("prechangetask") != null).map(entry -> entry.getDynamicObject("prechangetask").getPkValue().toString()).collect(Collectors.toSet());
        for (DynamicObject preTask : prePlanTasksEntries) {
            if (preTasks.contains(preTask.getPkValue().toString())) continue;
            adjustTask = this.getCompareTask(preTask, null, 3);
            adjustTask.set("statusvalue", 3);
            adjustTaskEntries.add((Object)adjustTask);
        }
        return adjustTaskEntries;
    }

    protected DynamicObject getCompareTask(DynamicObject preTask, DynamicObject currentTask, Integer type) {
        DynamicObjectType dt = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity").getDynamicObjectType();
        DynamicObject adjustTask = new DynamicObject(dt);
        int hasChanged = -1;
        if (type == 1) {
            adjustTask.set("id", currentTask.getPkValue());
            adjustTask.set("pid", currentTask.get("pid"));
            adjustTask.set("seq", currentTask.get("seq"));
            adjustTask.set("task", (Object)currentTask);
            adjustTask.set("newtaskname", (Object)currentTask.getLocaleString("name").getLocaleValue());
            adjustTask.set("newtaskcontrollevel", currentTask.get("controllevel"));
            adjustTask.set("newtasktype", currentTask.get("tasktype"));
            adjustTask.set("newresponsibleperson", currentTask.get("responsibleperson"));
            adjustTask.set("planstarttime2", (Object)currentTask.getDate("planstarttime"));
            adjustTask.set("planendtime2", (Object)currentTask.getDate("planendtime"));
            adjustTask.set("aimfinishtime2", (Object)currentTask.getDate("aimfinishtime"));
            adjustTask.set("level1", currentTask.get("level"));
            BigDecimal duration1 = BigDecimal.ZERO;
            BigDecimal duration2 = currentTask.getBigDecimal("absoluteduration");
            adjustTask.set("absoluteduration1", (Object)duration1);
            adjustTask.set("absoluteduration2", (Object)duration2);
            adjustTask.set("absoluteduration3", (Object)duration2);
        } else if (type == 2) {
            adjustTask.set("id", currentTask.getPkValue());
            adjustTask.set("pid", currentTask.get("pid"));
            adjustTask.set("seq", currentTask.get("seq"));
            adjustTask.set("task", (Object)currentTask);
            adjustTask.set("newtaskname", (Object)currentTask.getLocaleString("name").getLocaleValue());
            adjustTask.set("newtaskcontrollevel", currentTask.get("controllevel"));
            adjustTask.set("newtasktype", currentTask.get("tasktype"));
            adjustTask.set("newresponsibleperson", currentTask.get("responsibleperson"));
            adjustTask.set("level1", currentTask.get("level"));
            adjustTask.set("planstarttime1", (Object)preTask.getDate("planstarttime"));
            adjustTask.set("planstarttime2", (Object)currentTask.getDate("planstarttime"));
            adjustTask.set("planendtime1", (Object)preTask.getDate("planendtime"));
            adjustTask.set("planendtime2", (Object)currentTask.getDate("planendtime"));
            adjustTask.set("aimfinishtime1", (Object)preTask.getDate("aimfinishtime"));
            adjustTask.set("aimfinishtime2", (Object)currentTask.getDate("aimfinishtime"));
            BigDecimal duration1 = preTask.getBigDecimal("absoluteduration");
            BigDecimal duration2 = currentTask.getBigDecimal("absoluteduration");
            adjustTask.set("absoluteduration1", (Object)duration1);
            adjustTask.set("absoluteduration2", (Object)duration2);
            adjustTask.set("absoluteduration3", (Object)duration2.subtract(duration1));
            hasChanged = 0;
            Date currentTaskStartTime = currentTask.getDate("planstarttime");
            Date preTaskStartTime = preTask.getDate("planstarttime");
            if (currentTaskStartTime == null || preTaskStartTime == null || currentTaskStartTime.getTime() != preTaskStartTime.getTime()) {
                hasChanged = 1;
            }
            Date currentTaskEndTime = currentTask.getDate("planendtime");
            Date preTaskEndTime = preTask.getDate("planendtime");
            if (currentTaskEndTime == null || preTaskEndTime == null || currentTaskEndTime.getTime() != preTaskEndTime.getTime()) {
                hasChanged = 1;
            }
            Date currentTaskFinishTime = currentTask.getDate("aimfinishtime");
            Date preTaskFinishTime = preTask.getDate("aimfinishtime");
            if (currentTaskFinishTime == null || preTaskFinishTime == null || currentTaskFinishTime.getTime() != preTaskFinishTime.getTime()) {
                hasChanged = 1;
            }
        } else if (type == 3) {
            adjustTask.set("id", preTask.getPkValue());
            adjustTask.set("seq", preTask.get("seq"));
            adjustTask.set("task", (Object)preTask);
            adjustTask.set("newtaskname", (Object)preTask.getLocaleString("name").getLocaleValue());
            adjustTask.set("newtaskcontrollevel", preTask.get("controllevel"));
            adjustTask.set("newtasktype", preTask.get("tasktype"));
            adjustTask.set("newresponsibleperson", preTask.get("responsibleperson"));
            adjustTask.set("level1", currentTask.get("level"));
            adjustTask.set("planstarttime1", (Object)preTask.getDate("planstarttime"));
            adjustTask.set("planendtime1", (Object)preTask.getDate("planendtime"));
            adjustTask.set("aimfinishtime1", (Object)preTask.getDate("aimfinishtime"));
            BigDecimal duration1 = preTask.getBigDecimal("absoluteduration");
            BigDecimal duration2 = BigDecimal.ZERO;
            adjustTask.set("absoluteduration1", (Object)duration1);
            adjustTask.set("absoluteduration2", (Object)duration2);
            adjustTask.set("absoluteduration3", (Object)duration1);
        }
        adjustTask.set("haschanged", (Object)hasChanged);
        return adjustTask;
    }

    protected void initStyleTreeEntity(TreeEntryGrid grid) {
        if (grid == null) {
            return;
        }
        IDataModel model = grid.getModel();
        DynamicObjectCollection rows = model.getEntryEntity("treeentryentity");
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            int type = row.getInt("statusvalue");
            if (type != 2) continue;
            Date start1 = row.getDate("planstarttime1");
            Date start2 = row.getDate("planstarttime2");
            if (start1 != null && start2 != null) {
                String color = "black";
                if (start2.before(start1)) {
                    color = "green";
                } else if (start2.after(start1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, "planstarttime2", color);
            }
            Date end1 = row.getDate("planendtime1");
            Date end2 = row.getDate("planendtime2");
            if (end1 != null && end2 != null) {
                String color = "black";
                if (end2.before(end1)) {
                    color = "green";
                } else if (end2.after(end1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, "planendtime2", color);
            }
            Date aim1 = row.getDate("aimfinishtime1");
            Date aim2 = row.getDate("aimfinishtime2");
            if (aim1 != null && aim2 != null) {
                String color = "black";
                if (aim2.before(aim1)) {
                    color = "green";
                } else if (aim2.after(aim1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, "aimfinishtime2", color);
            }
            BigDecimal abs1 = row.getBigDecimal("absoluteduration1");
            BigDecimal abs2 = row.getBigDecimal("absoluteduration2");
            if (abs1 == null || abs2 == null || abs1.compareTo(BigDecimal.ZERO) == 0 || abs2.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal dvalue = abs2.subtract(abs1);
            String color = "black";
            if (dvalue.compareTo(BigDecimal.ZERO) < 0) {
                color = "green";
            } else if (dvalue.compareTo(BigDecimal.ZERO) > 0) {
                color = "red";
            }
            this.setCellTextColor(grid, i, "absoluteduration3", color);
        }
    }

    protected void setCellTextColor(TreeEntryGrid grid, int rowIndex, String fieldKey, String color) {
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(rowIndex);
        statusStyle.setFieldKey(fieldKey);
        statusStyle.setForeColor(color);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    protected void setRowBgColor(TreeEntryGrid grid, int rowIndex, int type) {
        if (type == 1) {
            grid.setRowBackcolor("green", new int[]{rowIndex});
        } else if (type == 2) {
            grid.setRowBackcolor("orange", new int[]{rowIndex});
        } else {
            grid.setRowBackcolor("gray", new int[]{rowIndex});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentity");
        for (int i = 0; i < taskEntryCol.size(); ++i) {
            DynamicObject task = (DynamicObject)taskEntryCol.get(i);
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            if (sourceTask == null) continue;
            QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            DynamicObjectCollection sameSourceTaskCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceFilter});
            Set taskIdSet = sameSourceTaskCol.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
            QFilter relationTaskFilter = new QFilter("relationtask", "in", taskIdSet);
            QFilter planTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (QFilter[])new QFilter[]{relationTaskFilter, planTypeFilter});
            if (exists) {
                this.getModel().setValue("isrelated", (Object)Boolean.TRUE, i);
                continue;
            }
            this.getModel().setValue("isrelated", (Object)Boolean.FALSE, i);
        }
    }
}

