/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.callback.CallBackStrategy;
import kd.pccs.placs.business.operation.OperationStrategy;
import kd.pccs.placs.business.utils.task.DealWithEntryDataUtils;
import kd.pccs.placs.business.utils.task.FileAttachmentHelper;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.PlanEntryUtil;
import kd.pccs.placs.business.utils.task.PlanTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.business.utils.task.TreeEntryUtils;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.helper.TreeEntryGridHelper;

public class MasterPlanEditPlugin
extends AbstractPlacsBillAdapter
implements BeforeF7SelectListener,
UploadListener,
TabSelectListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(MasterPlanEditPlugin.class);
    private static final String parentId = "parentBillId";
    private static final String DELETE_TASK_CONFIRM = "deleteTaskConfirm";
    private static final String NEW_TASK_CONFIRM = "newTaskConfirm";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();
    private static final String TASKENTITY = "taskentity";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String spectaskentity = "spectaskentity";
    private static final int MAX_LEVEL = 6;
    private static final int TAB_SIZE = 3;
    private static final String LEVEL = "level";
    private String[] rowNames = new String[]{"name", "number", "controllevel", "specialtype", "tasktype", "absoluteduration", "pretask", "logical", "relativeduration", "planstarttime", "planendtime", "aimfinishtime", "comptimedeviation", "responsibleperson", "responsibledept", "multicooperationperson", "multicooperationdept", "achievementnode", "transactiontype"};
    private static final String YES = "1";
    private static final String NO = "0";
    private String[] keys = new String[]{"taskentity", "treeentryentity", "spectaskentity"};

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"MasterPlanEditPlugin_34", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object taskId = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex).getPkValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", taskId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        int curIndex = changeSet.getRowIndex();
        switch (key) {
            case "project": {
                DynamicObject project = (DynamicObject)changeSet.getNewValue();
                if (project == null) break;
                this.switchProject(project.getPkValue());
                break;
            }
            case "pretask": {
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                Object newValue = changeSet.getNewValue();
                if (newValue != null) break;
                this.getModel().setValue("logical", null, curIndex);
                break;
            }
            case "logical": {
                this.ctrlV2Enum(curIndex);
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                break;
            }
            case "aimfinishtime": {
                try {
                    this.checkInputTime("aimfinishtime", curIndex);
                }
                catch (Exception e1) {
                    Date oldValue = (Date)changeSet.getOldValue();
                    this.getModel().setValue("aimfinishtime", (Object)oldValue, curIndex);
                    this.getView().showTipNotification(e1.getMessage());
                }
                this.calculateCompleteTimeDeviation(curIndex);
                this.settingParentPlanTime("aimfinishtime", curIndex);
                break;
            }
            case "planstarttime": {
                String startLogical = (String)this.getModel().getValue("logical", curIndex);
                if (startLogical == null || startLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)startLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)startLogical)) {
                    this.settingParentPlanTime("planstarttime", curIndex);
                    this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                } else {
                    try {
                        this.checkInputTime("planstarttime", curIndex);
                        this.settingParentPlanTime("planstarttime", curIndex);
                    }
                    catch (Exception e1) {
                        Date oldValue = (Date)changeSet.getOldValue();
                        this.getModel().setValue("planstarttime", (Object)oldValue, curIndex);
                        this.getView().showTipNotification(e1.getMessage());
                    }
                    this.calculateAbusoluteDuration(curIndex);
                }
                this.calculateOtherTaskTime(curIndex);
                break;
            }
            case "planendtime": {
                String endLogical = (String)this.getModel().getValue("logical", curIndex);
                if (endLogical == null || endLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)endLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)endLogical)) {
                    try {
                        this.checkInputTime("planendtime", curIndex);
                        this.settingParentPlanTime("planendtime", curIndex);
                    }
                    catch (Exception e1) {
                        Date oldValue = (Date)changeSet.getOldValue();
                        this.getModel().setValue("planendtime", (Object)oldValue, curIndex);
                        this.getView().showTipNotification(e1.getMessage());
                    }
                    this.calculateAbusoluteDuration(curIndex);
                    this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                } else {
                    this.calculatePlanStartTimeByAbusoluteDuration(curIndex);
                }
                this.calculateCompleteTimeDeviation(curIndex);
                this.calculateOtherTaskTime(curIndex);
                this.calculateAimFinishTime(curIndex);
                break;
            }
            case "absoluteduration": {
                String absLogical = (String)this.getModel().getValue("logical", curIndex);
                if (absLogical == null || absLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)absLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)absLogical)) {
                    this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                    break;
                }
                this.calculatePlanStartTimeByAbusoluteDuration(curIndex);
                break;
            }
            case "relativeduration": {
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                break;
            }
            case "multicooperationperson": {
                this.checkResponsiblePerson("multicooperationperson", curIndex);
                break;
            }
            case "responsibleperson": {
                this.checkResponsiblePerson("responsibleperson", curIndex);
                break;
            }
            case "spectypecombo": {
                String projectPlanId = this.getModel().getDataEntity().getPkValue().toString();
                String specId = (String)this.getModel().getValue("spectypecombo");
                this.loadSpecialEntryData(projectPlanId, specId);
                break;
            }
            case "transactiontype": {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
                Object trans = this.getModel().getValue("transactiontype", entryCurrentRowIndex);
                boolean deleteEntry = true;
                if (null != trans) {
                    DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
                    for (DynamicObject tx : transactionType) {
                        Long baseDataId = tx.getLong("fbasedataid_id");
                        DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                        if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                        deleteEntry = false;
                    }
                }
                if (deleteEntry) {
                    this.getModel().deleteEntryData("taskresultdocentry");
                }
                this.setTransactionEntryEnable(entryCurrentRowIndex);
                break;
            }
        }
    }

    protected void calculateAimFinishTime(int curIndex) {
        Date aimFinishTime = (Date)this.getModel().getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", curIndex);
        if (aimFinishTime == null && planEndTime != null) {
            this.getModel().setValue("aimfinishtime", (Object)planEndTime, curIndex);
        }
    }

    protected void ctrlV2Enum(int row) {
        String logical = (String)this.getModel().getValue("logical", row);
        if (logical == null) {
            return;
        }
        switch (logical.trim()) {
            case "\u5f00\u59cb-\u5b8c\u6210": {
                this.getModel().setValue("logical", (Object)LogicalEnum.START_FINISH.getValue(), row);
                break;
            }
            case "\u5b8c\u6210-\u5b8c\u6210": {
                this.getModel().setValue("logical", (Object)LogicalEnum.FINISH_FINISH.getValue(), row);
                break;
            }
            case "\u5f00\u59cb-\u5f00\u59cb": {
                this.getModel().setValue("logical", (Object)LogicalEnum.START_START.getValue(), row);
                break;
            }
            case "\u5b8c\u6210-\u5f00\u59cb": {
                this.getModel().setValue("logical", (Object)LogicalEnum.FINISH_START.getValue(), row);
            }
        }
    }

    protected void calculateOtherTaskTime(int curIndex) {
        DynamicObject curTask = this.getModel().getEntryRowEntity(TASKENTITY, curIndex);
        DynamicObjectCollection tasks = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        IDataModel model = this.getModel();
        Object curPk = curTask.getPkValue();
        if (curPk == null) {
            return;
        }
        Date preTaskPlanStartTime = curTask.getDate("planstarttime");
        Date preTaskPlanEndTime = curTask.getDate("planendtime");
        for (int rowIndex = 0; rowIndex < tasks.size(); ++rowIndex) {
            Date planEndTime;
            Date planStartTime;
            String logical;
            DynamicObject task = (DynamicObject)tasks.get(rowIndex);
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask == null || !curPk.equals(preTask.getPkValue()) || (logical = (String)model.getValue("logical", rowIndex)) == null) continue;
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeDuration = (BigDecimal)model.getValue("relativeduration", rowIndex);
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                if (preTaskPlanStartTime == null) continue;
                if (project == null) {
                    planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                    continue;
                }
                planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                if (preTaskPlanEndTime == null) continue;
                if (project == null) {
                    planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                    continue;
                }
                planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                if (preTaskPlanStartTime == null) continue;
                if (project == null) {
                    planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                    model.setValue("planendtime", (Object)planEndTime, rowIndex);
                    continue;
                }
                planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
                continue;
            }
            if (!StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) || preTaskPlanEndTime == null) continue;
            if (project == null) {
                planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
                continue;
            }
            planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
            model.setValue("planendtime", (Object)planEndTime, rowIndex);
        }
    }

    protected void setTransactionEntryEnable(int rowIndex) {
        boolean showResultDoc = false;
        Object trans = this.getModel().getValue("transactiontype", rowIndex);
        if (null != trans) {
            DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
            for (DynamicObject tx : transactionType) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if (showResultDoc) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    protected void setAchievementEntryEnable(int rowIndex) {
        String achievementNode = (String)this.getModel().getValue("achievementnode", rowIndex);
        if (StringUtils.equals((CharSequence)YES, (CharSequence)achievementNode)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("showProjectListCallBack".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.showProjectList();
            }
        } else if (callBackId.equals(DELETE_TASK_CONFIRM)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
                int[] selRows = grid.getSelectRows();
                HashSet<Integer> selectRows = new HashSet<Integer>(16);
                for (int row : selRows) {
                    selectRows.add(row);
                    this.selectChildren(row, selectRows);
                }
                selRows = selectRows.stream().mapToInt(Integer::valueOf).toArray();
                this.deleteTaskCheck(selRows);
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity(TASKENTITY, selectRow);
                    String pkvalue = entry.getPkValue().toString();
                    deletepks.add(pkvalue);
                }
                this.deletePreTask(deletepks);
                this.getModel().deleteEntryRows(TASKENTITY, selRows);
                this.getModel().updateCache();
                this.rebuildTreeStructure();
                this.afterDeleteTask();
                this.getView().updateView(TASKENTITY);
                int entryRowNum = this.getModel().getEntryEntity(TASKENTITY).getRowCount();
                if (entryRowNum == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconap2"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
                }
            }
        } else if ("importtask".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.importTaskOperation();
            }
        } else if (NEW_TASK_CONFIRM.equalsIgnoreCase(callBackId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
            int[] selRows = grid.getSelectRows();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity(TASKENTITY, selectRow);
                    String pidPkValue = entry.getString("pid");
                    deletepks.add(pidPkValue);
                }
                this.deletePreTask(deletepks);
            } else {
                this.getModel().deleteEntryRows(TASKENTITY, selRows);
            }
            this.getModel().updateCache();
            this.rebuildTreeStructure();
            this.getView().updateView(TASKENTITY);
        } else {
            new OperationStrategy(callBackId).confirmCallBack((AbstractPlacsBillAdapter)this, messageBoxClosedEvent);
        }
    }

    private void selectChildren(int row, Set<Integer> selectRows) {
        int count = this.getModel().getEntryRowCount(TASKENTITY);
        String pkId = this.getModel().getEntryRowEntity(TASKENTITY, row).getPkValue().toString();
        for (int index = row + 1; index < count; ++index) {
            DynamicObject task = this.getModel().getEntryRowEntity(TASKENTITY, index);
            if (!task.getString("pid").equals(pkId)) continue;
            selectRows.add(index);
            this.selectChildren(index, selectRows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("switchProjectCallBack".equalsIgnoreCase(key)) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
            this.switchProject(listSelectedRow.getPrimaryKeyValue());
        } else if ("batchmodify".equalsIgnoreCase(key)) {
            Map dataMap = (Map)closedCallBackEvent.getReturnData();
            MultiCooperationPersonUtils.dealBatchModifyPersons((IFormView)this.getView(), (Map)dataMap);
        } else if ("showTaskF7".equalsIgnoreCase(key)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null) {
                int curRow = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
                this.getModel().setValue("pretask", rows.get(0).getPrimaryKeyValue(), curRow);
            }
        } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog").equalsIgnoreCase(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (StringUtils.isNotBlank((Object)returnData)) {
                int i;
                DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
                boolean showResultDoc = false;
                for (DynamicObject task : tasks) {
                    DynamicObjectCollection transactionType = task.getDynamicObjectCollection("transactiontype");
                    if (null != transactionType) {
                        for (DynamicObject tx : transactionType) {
                            Long baseDataId = tx.getLong("fbasedataid_id");
                            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                            if (transactionType.size() >= 2 || Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number")) || task.getDynamicObjectCollection("taskresultdocentry") == null || task.getDynamicObjectCollection("taskresultdocentry").size() <= 0) continue;
                            showResultDoc = true;
                        }
                        continue;
                    }
                    if (transactionType != null || task.getDynamicObjectCollection("taskresultdocentry") == null) continue;
                    showResultDoc = true;
                }
                if (showResultDoc) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u679c\u201d\u7684\u4efb\u52a1\uff0c\u624d\u80fd\u4e0a\u4f20\u201c\u6210\u679c\u6587\u6863\u201d\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"MasterPlanEditPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                DealWithEntryDataUtils.updateEntryLevelData((DynamicObjectCollection)tasks);
                this.dealErrorBuilding(returnData);
                this.getModel().deleteEntryData(TASKENTITY);
                this.getModel().updateCache();
                this.getModel().updateEntryCache(tasks);
                this.getView().updateView();
                this.getView().invokeOperation("save");
                for (i = 0; i < tasks.size(); ++i) {
                    for (DynamicObject task1 : tasks) {
                        if (((DynamicObject)tasks.get(i)).get("pretask") == null || !((DynamicObject)tasks.get(i)).get("pretask").equals(task1.getString("name")) || !((DynamicObject)tasks.get(i)).getBoolean("isleaf")) continue;
                        this.getModel().setValue("pretask", (Object)task1, i);
                    }
                    if (((DynamicObject)tasks.get(i)).get("pretask") != null && ((DynamicObject)tasks.get(i)).getBoolean("isleaf")) continue;
                    this.getModel().setValue("logical", null, i);
                    this.getModel().setValue("relativeduration", null, i);
                }
                for (i = 0; i < tasks.size(); ++i) {
                    if (((DynamicObject)tasks.get(i)).get("pretask") == null) continue;
                    this.calculatePlanStartTimeByPreTaskAndLogical(i);
                }
                TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TASKENTITY);
                entryTree.setCollapse(false);
            }
        } else {
            new CallBackStrategy().closedCallBack((AbstractPlacsBillAdapter)this, closedCallBackEvent);
        }
    }

    protected void dealErrorBuilding(Object returnData) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter planTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
        QFilter isSysFilter = new QFilter("issysfield", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject[] majorType = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"plantypename", (QFilter[])new QFilter[]{planTypeFilter, isSysFilter});
        if (majorType.length == 1) {
            this.getModel().setValue("majortype", (Object)majorType[0]);
            logger.info(String.format("\u8bbe\u7f6e\u5f53\u524d\u5355\u636e\u7684\u8ba1\u5212\u7c7b\u578b\u4e3a\uff1a[ID=%s,Name=%s]", majorType[0].getPkValue(), majorType[0].getLocaleString("plantypename").getLocaleValue()));
        } else {
            JSONArray majorTypeList = new JSONArray();
            if (majorType.length != 0) {
                for (DynamicObject type : majorType) {
                    JSONObject data = new JSONObject();
                    data.put(type.getPkValue().toString(), (Object)type.getLocaleString("plantypename").getLocaleValue());
                    majorTypeList.add((Object)data);
                }
            }
            logger.info(String.format("\u8bbe\u7f6e\u5f53\u524d\u5355\u636e\u7684\u8ba1\u5212\u7c7b\u578b\u65f6\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\uff0c%s", majorTypeList));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretask");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationPerson = (MulBasedataEdit)this.getControl("multicooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationDept = (MulBasedataEdit)this.getControl("multicooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit spec = (BasedataEdit)this.getControl("specialtype");
        spec.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button uploadBtn = (Button)this.getControl("btnimp");
        uploadBtn.addUploadListener((UploadListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl(TASKENTITY);
        taskEntryGrid.addRowClickListener((RowClickEventListener)this);
        this.levelLableAddListener(6, 3);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASKENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void levelLableAddListener(int maxLevel, int tabSize) {
        for (int i = 1; i <= maxLevel * tabSize; ++i) {
            Label level = (Label)this.getControl("level_" + i);
            level.addClickListener((ClickListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (StringUtils.equals((CharSequence)TASKENTITY, (CharSequence)entryKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconap2"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (StringUtils.equals((CharSequence)TASKENTITY, (CharSequence)entryProp.getName())) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            for (int i = 0; i < rowDataEntities.length; ++i) {
                int rowIndex = rowDataEntities[i].getRowIndex();
                if (i == 0) {
                    this.setAchievementEntryEnable(rowIndex);
                }
                this.getModel().setValue("belongplantype", this.getMasterPlanType().getPkValue(), rowIndex);
                this.getModel().setValue("tasksource", this.getMasterPlanType().getPkValue(), rowIndex);
            }
        }
    }

    protected DynamicObject getMasterPlanType() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue())});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabkey = tabSelectEvent.getTabKey();
        if ("spectab".equals(tabkey)) {
            this.setSpecTypeCombo();
            this.hideLevelNum();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        Object parentBillId = this.getView().getFormShowParameter().getCustomParam(parentId);
        if (isCopy != null && isCopy.booleanValue() && null != parentBillId) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"project"});
            BigDecimal version = (BigDecimal)this.getModel().getValue("version");
            BigDecimal newVersion = version.add(BigDecimal.ONE);
            this.getModel().setValue("version", (Object)newVersion);
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                this.getModel().setValue("billname", (Object)this.createPlanName(project, newVersion));
            }
            this.getModel().setValue("prechangeplan", (Object)String.valueOf(parentBillId));
            DynamicObject parentPlan = BusinessDataServiceHelper.loadSingle((Object)parentBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
            HashMap<Long, Integer> idSeqMap = new HashMap<Long, Integer>(16);
            DynamicObject sourcePlan = parentPlan.getDynamicObject("sourceplan");
            if (null == sourcePlan) {
                this.getModel().setValue("sourceplan", (Object)parentPlan);
            } else {
                this.getModel().setValue("sourceplan", (Object)sourcePlan);
            }
            this.getModel().setValue("planstatus", (Object)PlanEnum.CREATEING.getValue());
            String sourceBillFormId = parentPlan.getDynamicObjectType().toString();
            Object sourceBillId = parentBillId;
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
            DynamicObjectCollection entries = this.getModel().getEntryEntity(TASKENTITY);
            if (entries == null || entries.isEmpty()) {
                return;
            }
            DynamicObjectCollection parentPlanEntries = parentPlan.getDynamicObjectCollection(TASKENTITY);
            for (int i = 0; i < parentPlanEntries.size(); ++i) {
                idSeqMap.put((Long)((DynamicObject)parentPlanEntries.get(i)).getPkValue(), i);
            }
            int seq = 0;
            for (DynamicObject entry : entries) {
                DynamicObject oldTask = (DynamicObject)parentPlanEntries.get(seq);
                entry.set("prechangetask", (Object)oldTask);
                DynamicObject sourceTask = oldTask.getDynamicObject("sourcetask");
                if (sourceTask == null) {
                    entry.set("sourcetask", (Object)oldTask);
                } else {
                    entry.set("sourcetask", (Object)sourceTask);
                }
                entry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                entry.set("taskversion", (Object)BigDecimal.ONE.add(oldTask.getBigDecimal("taskversion")));
                entry.set("islatest", (Object)DefaultEnum.NO.getValue());
                ++seq;
                long preTaskId = entry.getLong("pretask_id");
                if (preTaskId == 0L) continue;
                DynamicObject newTask = (DynamicObject)entries.get(((Integer)idSeqMap.get(preTaskId)).intValue());
                entry.set("pretask", (Object)newTask);
            }
            this.getView().invokeOperation("save");
            this.getModel().updateCache();
        } else {
            String projectId = (String)this.getView().getFormShowParameter().getCustomParam("projectId");
            if (null == this.getModel().getValue("project") && !StringUtils.isEmpty((CharSequence)projectId)) {
                QFilter planType = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
                DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{planType});
                if (majorType == null) {
                    logger.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u4e3b\u9879\u8ba1\u5212\u7c7b\u578b\uff0c\u53ef\u80fd\u5bfc\u81f4\u76f8\u5173\u67e5\u8be2\u8fc7\u6ee4\u6570\u636e\u4e0d\u51c6\u786e\uff0c\u8bf7\u6392\u67e5\u3002\u539f\u56e0\uff1a\u53ef\u80fd\u662f\u56e0\u4e3a\u9879\u76ee\u4e91\u516c\u5171\u670d\u52a1\u4e91\u4e0b\u8ba1\u5212\u7ba1\u7406\u7684\u4e13\u4e1a\u7c7b\u578b\u9884\u7f6e\u6570\u636e\uff0c\u672a\u5728\u7ee7\u627f\u65b9\u7684\u6570\u636e\u8868\u4e2d\u5b58\u5728\u3002");
                } else {
                    QFilter majorTypeFilter = new QFilter("majortype", "=", majorType.getPkValue());
                    QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(projectId));
                    boolean flag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (QFilter[])new QFilter[]{majorTypeFilter, projectFilter});
                    if (!flag) {
                        this.getModel().setValue("project", (Object)projectId);
                    }
                }
            }
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TASKENTITY);
        entryTree.setCollapse(false);
    }

    private void hideResultdocapByTransactionType(Object transactionType) {
        boolean showResultDoc = false;
        if (null != transactionType) {
            DynamicObjectCollection transactionTypeCollections = (DynamicObjectCollection)transactionType;
            for (DynamicObject tx : transactionTypeCollections) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if (showResultDoc) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    protected int getOriginLevel(int level) {
        while (level > 6) {
            level -= 6;
        }
        return level;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String levelColKey = "";
        String treeEntityKey = "";
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if (key.contains(LEVEL)) {
            int level = Integer.parseInt(key.split("_")[1]);
            if (level <= 6 && level > 0) {
                treeEntityKey = TASKENTITY;
            }
            if (level <= 12 && level > 6) {
                treeEntityKey = TREEENTRYENTITY;
            }
            if (level <= 18 && level > 12) {
                treeEntityKey = spectaskentity;
            }
            level = this.getOriginLevel(level);
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeEntityKey);
            Map all = this.getPageCache().getAll();
            all.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("@taskId")).forEach(entry -> this.taskLevelMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("@taskId")), Integer.valueOf((String)entry.getValue())));
            if (StringUtils.equals((CharSequence)"tabpageap", (CharSequence)currentTab)) {
                TreeEntryGridHelper.expandNodes(treeEntryGrid, "id", level, this.taskLevelMap);
            }
            if (StringUtils.equals((CharSequence)"adjusttab", (CharSequence)currentTab)) {
                TreeEntryGridHelper.expandNodes(treeEntryGrid, "task", level, this.taskLevelMap);
            }
            if (StringUtils.equals((CharSequence)"spectab", (CharSequence)currentTab)) {
                TreeEntryGridHelper.expandNodes(treeEntryGrid, "taskobj", level, this.taskLevelMap);
            }
        }
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (null == map || map.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    protected int doFillLevelMap(DynamicObjectCollection taskEntries) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DynamicObject taskEnetity : taskEntries) {
            map.put(taskEnetity.getString("id"), taskEnetity.getLong("pid"));
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        return max.isPresent() ? max.get() : 0;
    }

    protected void hideLevelNum() {
        int j;
        int i;
        int maxLevel = 0;
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if (StringUtils.equals((CharSequence)"tabpageap", (CharSequence)currentTab)) {
            DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(this.keys[0]);
            maxLevel = this.doFillLevelMap(taskEntries);
            for (i = 1; i <= 6; ++i) {
                for (j = 0; j < 1; ++j) {
                    if (maxLevel < i) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                        continue;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
                }
            }
        }
        if (StringUtils.equals((CharSequence)"adjusttab", (CharSequence)currentTab)) {
            DynamicObjectCollection adjustEntries = this.getModel().getEntryEntity(this.keys[1]);
            if (adjustEntries.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjustlable"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"adjustlable"});
            }
            maxLevel = this.doFillLevelMap(adjustEntries);
            for (i = 1; i <= 6; ++i) {
                for (j = 1; j < 2; ++j) {
                    if (maxLevel < i) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                        continue;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
                }
            }
        }
        if (StringUtils.equals((CharSequence)"spectab", (CharSequence)currentTab)) {
            DynamicObjectCollection specEntries = this.getModel().getEntryEntity(this.keys[2]);
            if (specEntries.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"speciallabel"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"speciallabel"});
            }
            maxLevel = this.doFillLevelMap(specEntries);
            for (i = 1; i <= 6; ++i) {
                for (j = 2; j < 3; ++j) {
                    if (maxLevel < i) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                        continue;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBaseInfoCollapse();
        this.hideLevelNum();
        this.setDateEditRange();
        this.setAllParentRowLocked();
        this.setShowTab();
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        if (version.intValue() > 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"generatefromtpl"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assigner"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"generatefromtpl"});
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
        Object transactionType = this.getModel().getValue("transactiontype", 0);
        this.hideResultdocapByTransactionType(transactionType);
        this.dealNodeLeve();
    }

    public void dealNodeLeve() {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TASKENTITY);
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (Object taskEntry : taskEntries) {
            Object parentId = taskEntry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : taskEntries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString("pid"), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection(taskEntries.getDynamicObjectType(), null);
        for (DynamicObject taskEntry : taskEntries) {
            Long pid = taskEntry.getLong("pid");
            int level = 1;
            int seq = 1;
            if (pid != 0L) continue;
            this.addChildTask(newEntries, parentToChildMap, taskEntry, level, seq);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TASKENTITY);
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(newEntries);
        this.getView().updateView(TASKENTITY);
    }

    protected void setBaseInfoCollapse() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        boolean isCopy = formShowParameter.getCustomParam("iscopy") != null;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (OperationStatus.VIEW.equals((Object)status) || isCopy || !StringUtils.endsWithIgnoreCase((CharSequence)"A", (CharSequence)billStatus)) {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(true);
        } else {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(false);
        }
    }

    private void addChildTask(DynamicObjectCollection newEntries, Map<Object, List<DynamicObject>> parentToChildMap, DynamicObject parentTask, int level, int seq) {
        List<DynamicObject> childList = parentToChildMap.get(parentTask.getPkValue());
        if (!childList.isEmpty()) {
            parentTask.set(LEVEL, (Object)level);
            parentTask.set("isleaf", (Object)EnableEnum.DISABLE.getValue());
            parentTask.set("seq", (Object)seq);
            newEntries.add((Object)parentTask);
            ++level;
            for (DynamicObject child : childList) {
                this.addChildTask(newEntries, parentToChildMap, child, level, seq++);
            }
        } else {
            parentTask.set("isleaf", (Object)EnableEnum.ENABLE.getValue());
            parentTask.set(LEVEL, (Object)level);
            parentTask.set("seq", (Object)seq);
            newEntries.add((Object)parentTask);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
        int[] selectRows = grid.getSelectRows();
        switch (key) {
            case "save": {
                this.setEntryTaskBelongTypeAndTaskSource();
                break;
            }
            case "submit": {
                this.setEntryTaskBelongTypeAndTaskSource();
                break;
            }
            case "newtaskentry": {
                Object project = this.getModel().getValue("project");
                if (project != null) break;
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"MasterPlanEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "inserttaskentry": {
                this.verifyTaskIsPre(args);
                this.verifyTaskIsRelatedTask(args);
                break;
            }
            case "deletetaskentry": {
                this.deleteTaskEntry(args);
                break;
            }
            case "upgrade": {
                this.upgradeOperation(selectRows);
                break;
            }
            case "downgrade": {
                this.downgradeOperation(selectRows);
                break;
            }
        }
    }

    protected void setEntryTaskBelongTypeAndTaskSource() {
        DynamicObjectCollection taskEntrys = this.getModel().getEntryEntity(TASKENTITY);
        for (int i = 0; i < taskEntrys.size(); ++i) {
            this.getModel().setValue("belongplantype", this.getMasterPlanType().getPkValue(), i);
            this.getModel().setValue("tasksource", this.getMasterPlanType().getPkValue(), i);
        }
    }

    protected void verifyTaskIsRelatedTask(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TASKENTITY, entryCurrentRowIndex);
        Long sourceTaskId = entryRowEntity.getLong("sourcetask_id");
        if (sourceTaskId == 0L) {
            return;
        }
        QFilter relatedMasterTaskFilter = new QFilter("relatedmastertask", "=", (Object)sourceTaskId);
        DynamicObject specPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"id", (QFilter[])new QFilter[]{relatedMasterTaskFilter});
        if (specPlan != null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8be5\u8282\u70b9\u88ab\u7528\u4f5c\u5173\u8054\u4efb\u52a1\uff0c\u65e0\u6cd5\u65b0\u589e\u5b50\u7ea7\u3002", (String)"MasterPlanEditPlugin_36", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
        switch (key) {
            case "newtaskentry": {
                this.settingTreeStructureAfterNew();
                break;
            }
            case "inserttaskentry": {
                this.settingTreeStructureAfterNew();
                break;
            }
            case "viewtaskdetail": {
                this.viewTaskDetailOperation(grid);
                break;
            }
            case "batchmodify": {
                this.batchModifyOperation(grid);
                break;
            }
            case "upgrade": {
                this.rebuildTreeStructure();
                this.getView().updateView(TASKENTITY);
                break;
            }
            case "exportmodel": {
                PlanTaskImpAndExpUtil util = this.getUtil();
                util.exportCommonModel(this.getView(), true);
                break;
            }
            case "proimptask": {
                new OperationStrategy(key).afterDoOperation((AbstractPlacsBillAdapter)this);
                break;
            }
            case "importtask": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"MasterPlanEditPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                Object project = this.getModel().getValue("project");
                if (project == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"MasterPlanEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5bfc\u5165\u5c06\u4f1a\u5220\u9664\u73b0\u6709\u4e3b\u9879\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MasterPlanEditPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importtask"));
                break;
            }
            case "audit": {
                this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
                this.getView().updateView("assigner");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        int entryCurrentRowIndex;
        DynamicObjectCollection orgEntryEntity;
        DynamicObject taskRow;
        DynamicObjectCollection cooperationpersons;
        String propName = arg.getProperty().getName();
        Object project = this.getModel().getValue("project");
        ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
        if (propName.equals("project")) {
            int entryRowNum;
            if (project != null && (entryRowNum = this.getModel().getEntryEntity(TASKENTITY).getRowCount()) > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MasterPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showProjectListCallBack"));
                arg.setCancel(true);
            }
            arg.setCustomQFilters(this.setProjectListFilter().getQFilters());
        } else if ("pretask".equals(propName)) {
            boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!isFromDb) {
                this.getView().invokeOperation("save");
                this.getModel().updateCache();
            } else {
                DynamicObjectCollection tasks = this.getModel().getEntryEntity(TASKENTITY);
                SaveServiceHelper.update((DynamicObject[])((DynamicObject[])tasks.toArray((Object[])new DynamicObject[0])));
            }
            if (!arg.getSourceMethod().equals("click")) {
                this.settingPreTaskFilter(arg);
                return;
            }
            this.showTaskF7(arg);
        } else if (StringUtils.equals((CharSequence)"specialtype", (CharSequence)propName)) {
            this.beforeSpecialTypeSelected(arg, project);
        } else if (StringUtils.equals((CharSequence)"responsibledept", (CharSequence)propName)) {
            int entryCurrentRowIndex2;
            DynamicObjectCollection orgEntryEntity2 = this.getModel().getEntryEntity(TASKENTITY);
            DynamicObject taskRow2 = (DynamicObject)orgEntryEntity2.get(entryCurrentRowIndex2 = this.getModel().getEntryCurrentRowIndex(TASKENTITY));
            DynamicObject responsibleperson = taskRow2.getDynamicObject("responsibleperson");
            if (responsibleperson != null) {
                List deptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsibleperson.getPkValue().toString()), (boolean)false);
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)deptList));
            }
        } else if (StringUtils.equals((CharSequence)"multicooperationdept", (CharSequence)propName) && (cooperationpersons = (taskRow = (DynamicObject)(orgEntryEntity = this.getModel().getEntryEntity(TASKENTITY)).get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY))).getDynamicObjectCollection("multicooperationperson")) != null) {
            ArrayList deptList = new ArrayList();
            cooperationpersons.stream().map(o -> deptList.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", deptList));
            if (cooperationpersons.size() == 1) {
                param.setMultiSelect(false);
            }
        }
    }

    private void showTaskF7(BeforeF7SelectEvent arg) {
        arg.setCancel(true);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (boolean)false, (int)2);
        this.settingPreTaskFilter(parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showTaskF7"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void beforeSpecialTypeSelected(BeforeF7SelectEvent arg, Object project) {
        if (project != null) {
            DynamicObject projectObj = (DynamicObject)project;
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            this.specialTypeKindFilter(projectObj, qFilters);
        }
    }

    protected void specialTypeKindFilter(DynamicObject projectObj, List<QFilter> qFilters) {
        Object projectKindId = projectObj.get("group_id");
        QFilter kindFilter = new QFilter("group", "=", projectKindId);
        QFilter specialFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        qFilters.add(specialFilter);
        qFilters.add(kindFilter);
    }

    private void loadSpecialEntryData(String projectPlanId, String specId) {
        this.getModel().deleteEntryData(spectaskentity);
        if (!"".equals(specId)) {
            QFilter proPlanFilter = new QFilter("masterplan", "=", (Object)Long.valueOf(projectPlanId));
            QFilter specTypeFilter = new QFilter("majortype", "=", (Object)Long.valueOf(specId));
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] majorPlans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)TASKENTITY, (QFilter[])new QFilter[]{proPlanFilter, specTypeFilter, statusFilter}, (String)"version desc");
            if (majorPlans.length > 0) {
                TreeEntryGrid specEntryCtrl = (TreeEntryGrid)this.getControl(spectaskentity);
                specEntryCtrl.setCollapse(false);
                DynamicObject majorPlan = majorPlans[0];
                DynamicObjectCollection specialTaskEntries = majorPlan.getDynamicObjectCollection(TASKENTITY);
                if (specialTaskEntries == null || specialTaskEntries.isEmpty()) {
                    return;
                }
                DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(spectaskentity);
                for (DynamicObject entry : specialTaskEntries) {
                    DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)entry.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                    DynamicObject item = new DynamicObject(taskEntries.getDynamicObjectType());
                    item.set("id", task.getPkValue());
                    DynamicObject parent = task.getDynamicObject("parent");
                    item.set("pid", parent == null ? Integer.valueOf(0) : parent.getPkValue());
                    item.set("taskobj", (Object)task);
                    taskEntries.add((Object)item);
                }
                if (!taskEntries.isEmpty()) {
                    this.getModel().updateEntryCache(taskEntries);
                    this.getView().updateView(spectaskentity);
                }
            }
        }
        this.hideLevelNum();
    }

    protected void checkResponsiblePerson(String operateKey, int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex);
        DynamicObject responsiblePerson = row.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperationPersons = row.getDynamicObjectCollection("multicooperationperson");
        MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPersons);
        if (responsiblePerson != null && "responsibleperson".equalsIgnoreCase(operateKey)) {
            long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePerson.getPkValue().toString()));
            this.getModel().setValue("responsibledept", (Object)orgId, rowIndex);
        } else if ("multicooperationperson".equalsIgnoreCase(operateKey)) {
            MultiCooperationPersonUtils.writeCodeptsByCoPersons((DynamicObjectCollection)cooperationPersons, (IDataModel)this.getModel(), (int)rowIndex);
        }
    }

    protected void batchModifyOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"MasterPlanEditPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"batchmodify"));
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setAppId(this.getAppId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchmodify"));
        this.getView().showForm(parameter);
    }

    protected void calculatePlanStartTimeByPreTaskAndLogical(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject preTask = (DynamicObject)this.getModel().getValue("pretask", rowIndex);
        if (preTask == null) {
            return;
        }
        String logical = (String)model.getValue("logical", rowIndex);
        if (logical == null) {
            return;
        }
        DynamicObjectCollection tasks = this.getModel().getEntryEntity(TASKENTITY);
        for (int row = 0; row < tasks.size(); ++row) {
            DynamicObject task = (DynamicObject)tasks.get(row);
            if (!task.getPkValue().equals(preTask.getPkValue())) continue;
            preTask = task;
            break;
        }
        DynamicObject project = (DynamicObject)model.getValue("project");
        BigDecimal relativeDuration = (BigDecimal)model.getValue("relativeduration");
        if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime == null) {
                return;
            }
            if (project == null) {
                Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            } else {
                Date planStartTime = this.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeDuration.intValue(), this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanEndTime = preTask.getDate("planendtime");
            if (preTaskPlanEndTime == null) {
                return;
            }
            if (project == null) {
                Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            } else {
                Date planStartTime = this.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime, relativeDuration.intValue(), this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime == null) {
                return;
            }
            if (project == null) {
                Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            } else {
                Date planEndTime = this.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeDuration.intValue(), this.getAppId());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical)) {
            Date preTaskPlanEndTime = preTask.getDate("planendtime");
            if (preTaskPlanEndTime == null) {
                return;
            }
            if (project == null) {
                Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            } else {
                Date planEndTime = this.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime, relativeDuration.intValue(), this.getAppId());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            }
        }
    }

    protected Date getDateAfterAddRelativeDays(Object projectId, Date preTaskPlanEndTime, Integer relativeDuration, String appId) {
        return TaskUtil.getDateAfterAddRelativeDays((Object)projectId, (Date)preTaskPlanEndTime, (int)relativeDuration, (String)appId);
    }

    protected void settingPreTaskFilter(BeforeF7SelectEvent arg) {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TASKENTITY);
        int selectIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
        DynamicObject selectEntry = this.getModel().getEntryRowEntity(TASKENTITY, selectIndex);
        Set taskIds = taskEntries.stream().filter(entry -> !StringUtils.isEmpty((CharSequence)entry.getString("name")) && !entry.getPkValue().equals(selectEntry.getPkValue()) && entry.getBoolean("isleaf") && (entry.getDynamicObject("pretask") == null || entry.getDynamicObject("pretask") != null && !entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue()))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet<Object> excludeTaskIds = new HashSet<Object>();
        this.getPreTaskLinkSet(taskEntries, selectEntry, excludeTaskIds);
        taskIds.removeAll(excludeTaskIds);
        QFilter filter = new QFilter("id", "in", taskIds);
        arg.getCustomQFilters().add(filter);
    }

    protected void settingPreTaskFilter(ListShowParameter param) {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TASKENTITY);
        int selectIndex = this.getModel().getEntryCurrentRowIndex(TASKENTITY);
        DynamicObject selectEntry = this.getModel().getEntryRowEntity(TASKENTITY, selectIndex);
        Set taskIds = taskEntries.stream().filter(entry -> !StringUtils.isEmpty((CharSequence)entry.getString("name")) && !entry.getPkValue().equals(selectEntry.getPkValue()) && entry.getBoolean("isleaf") && entry.getDate("planstarttime") != null && entry.getDate("planendtime") != null && (entry.getDynamicObject("pretask") == null || entry.getDynamicObject("pretask") != null && !entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue()))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet<Object> excludeTaskIds = new HashSet<Object>();
        this.getPreTaskLinkSet(taskEntries, selectEntry, excludeTaskIds);
        taskIds.removeAll(excludeTaskIds);
        ListFilterParameter parameter = param.getListFilterParameter();
        QFilter filter = new QFilter("id", "in", taskIds);
        parameter.setFilter(filter);
        parameter.setOrderBy("taskseq");
    }

    protected void getPreTaskLinkSet(DynamicObjectCollection taskEntries, DynamicObject selectEntry, Set<Object> taskSet) {
        long count = taskEntries.stream().filter(entry -> entry.getDynamicObject("pretask") != null && entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue())).count();
        if (count == 0L) {
            return;
        }
        for (DynamicObject task : taskEntries) {
            DynamicObject preTask;
            if (selectEntry.getPkValue().equals(task.getPkValue()) || (preTask = task.getDynamicObject("pretask")) == null || !selectEntry.getPkValue().equals(preTask.getPkValue())) continue;
            taskSet.add(task.getPkValue());
            this.getPreTaskLinkSet(taskEntries, task, taskSet);
        }
    }

    protected void downgradeOperation(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u964d\u7ea7\u7684\u884c\u3002", (String)"MasterPlanEditPlugin_37", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u4e0d\u80fd\u964d\u7ea7\u3002", (String)"MasterPlanEditPlugin_38", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)this.getAppId());
        DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, curIndex);
        if (row.getDate("planstarttime") != null) {
            this.settingParentPlanTime("planstarttime", curIndex);
        }
        if (row.getDate("planendtime") != null) {
            this.settingParentPlanTime("planendtime", curIndex);
        }
        if (row.getDate("aimfinishtime") != null) {
            this.settingParentPlanTime("aimfinishtime", curIndex);
        }
    }

    protected void upgradeOperation(int[] selRows) {
        int parentIndex;
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u884c\u3002", (String)"MasterPlanEditPlugin_39", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"MasterPlanEditPlugin_40", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        String parentPk = task.getString("pid");
        for (int index = parentIndex = curIndex - 1; index >= 0; --index) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            if (!StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)parentPk)) continue;
            parentIndex = index;
            break;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)this.getAppId());
        this.settingTimeByChildren(parentIndex);
    }

    private void settingTimeByChildren(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex);
        long id = Long.parseLong(row.getPkValue().toString());
        if (id == 0L) {
            return;
        }
        Date firstStartTime = null;
        for (Object entry : entries) {
            Date planStartTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planStartTime = entry.getDate("planstarttime"))) continue;
            if (null == firstStartTime) {
                firstStartTime = planStartTime;
            }
            firstStartTime = planStartTime.compareTo(firstStartTime) < 0 ? planStartTime : firstStartTime;
        }
        if (null != firstStartTime) {
            this.getModel().setValue("planstarttime", firstStartTime, rowIndex);
        }
        Date lastEndTime = null;
        for (DynamicObject entry : entries) {
            Date planEndTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planEndTime = entry.getDate("planendtime"))) continue;
            if (null == lastEndTime) {
                lastEndTime = planEndTime;
            }
            lastEndTime = planEndTime.compareTo(lastEndTime) > 0 ? planEndTime : lastEndTime;
        }
        if (null != lastEndTime) {
            this.getModel().setValue("planendtime", lastEndTime, rowIndex);
        }
        Date lastAimfinishtime = null;
        for (DynamicObject entry : entries) {
            Date planAimfinishTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planAimfinishTime = entry.getDate("aimfinishtime"))) continue;
            if (null == lastAimfinishtime) {
                lastAimfinishtime = planAimfinishTime;
            }
            lastAimfinishtime = planAimfinishTime.compareTo(lastAimfinishtime) > 0 ? planAimfinishTime : lastAimfinishtime;
        }
        if (null != lastAimfinishtime) {
            this.getModel().setValue("aimfinishtime", lastAimfinishtime, rowIndex);
        }
    }

    protected void settingTreeStructureAfterNew() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int index = selectRows[0];
        DynamicObject entry = this.getModel().getEntryRowEntity(TASKENTITY, index);
        long pid = entry.getLong("pid");
        int rows = this.getModel().getEntryRowCount(TASKENTITY);
        if (pid == 0L) {
            this.getModel().setValue(LEVEL, (Object)1, index);
            this.getModel().setValue("isleaf", (Object)DefaultEnum.YES.getValue(), index);
        } else {
            for (int i = 0; i < rows; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, i);
                if (pid != Long.parseLong(row.getPkValue().toString())) continue;
                this.getModel().setValue("pretask", null, i);
                this.getModel().setValue("logical", null, i);
                this.getModel().setValue("isleaf", (Object)DefaultEnum.NO.getValue(), i);
                this.getModel().setValue(LEVEL, (Object)(row.getInt(LEVEL) + 1), index);
                this.getModel().setValue("isleaf", (Object)DefaultEnum.YES.getValue(), index);
            }
        }
    }

    protected void settingParentPlanTime(String changeField, int rowIndex) {
        block10: {
            DynamicObjectCollection entries;
            block11: {
                block9: {
                    entries = this.getModel().getEntryEntity(TASKENTITY);
                    if (!"planstarttime".equalsIgnoreCase(changeField)) break block9;
                    Object planStartTime = this.getModel().getValue("planstarttime");
                    DynamicObject currentTask = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex);
                    long pid = currentTask.getLong("pid");
                    if (pid == 0L || planStartTime == null) {
                        return;
                    }
                    int rowSeq = 0;
                    for (DynamicObject entry : entries) {
                        if (pid == Long.parseLong(entry.getPkValue().toString())) {
                            Date firstPlanStartTime = this.getBeginTimeBySameLevelTask(entries, currentTask);
                            this.getModel().setValue("planstarttime", (Object)firstPlanStartTime, rowSeq);
                            return;
                        }
                        ++rowSeq;
                    }
                    break block10;
                }
                if (!"planendtime".equalsIgnoreCase(changeField)) break block11;
                Object planEndTime = this.getModel().getValue("planendtime");
                DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex);
                long pid = row.getLong("pid");
                if (pid == 0L || planEndTime == null) {
                    return;
                }
                int rowSeq = 0;
                for (DynamicObject entry : entries) {
                    if (pid == Long.parseLong(entry.getPkValue().toString())) {
                        Date lastPlanEndTime = this.getEndTimeBySameLevelTask(entries, row);
                        this.getModel().setValue("planendtime", (Object)lastPlanEndTime, rowSeq);
                        return;
                    }
                    ++rowSeq;
                }
                break block10;
            }
            if (!"aimfinishtime".equalsIgnoreCase(changeField)) break block10;
            Object planAimTime = this.getModel().getValue("aimfinishtime");
            DynamicObject row = this.getModel().getEntryRowEntity(TASKENTITY, rowIndex);
            long pid = row.getLong("pid");
            if (pid == 0L || planAimTime == null) {
                return;
            }
            int rowSeq = 0;
            for (DynamicObject entry : entries) {
                if (pid == Long.parseLong(entry.getPkValue().toString())) {
                    Date parentPlanAimTime = this.getAimFinishTimeBySameLevelTask(entries, row);
                    this.getModel().setValue("aimfinishtime", (Object)parentPlanAimTime, rowSeq);
                    return;
                }
                ++rowSeq;
            }
        }
    }

    protected Date getBeginTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date firstStartTime = currentTask.getDate("planstarttime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date planStartTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (planStartTime = ((DynamicObject)entries.get(i)).getDate("planstarttime")) == null || planStartTime.compareTo(firstStartTime) >= 0) continue;
            firstStartTime = planStartTime;
        }
        return firstStartTime;
    }

    protected Date getEndTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastEndTime = currentTask.getDate("planendtime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date planEndTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (planEndTime = ((DynamicObject)entries.get(i)).getDate("planendtime")) == null || planEndTime.compareTo(lastEndTime) <= 0) continue;
            lastEndTime = planEndTime;
        }
        return lastEndTime;
    }

    protected Date getAimFinishTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastAimFinishTime = currentTask.getDate("aimfinishtime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date aimFinishTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (aimFinishTime = ((DynamicObject)entries.get(i)).getDate("aimfinishtime")) == null || aimFinishTime.compareTo(lastAimFinishTime) <= 0) continue;
            lastAimFinishTime = aimFinishTime;
        }
        return lastAimFinishTime;
    }

    protected void settingEntryFieldTextColor(String entryEntity, String fieldName, int curIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)this.getModel().getValue(fieldName, curIndex);
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntity);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(curIndex);
        statusStyle.setFieldKey(fieldName);
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            statusStyle.setForeColor("#FF0000");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            statusStyle.setForeColor("#00DD2C");
        } else {
            statusStyle.setForeColor("#666");
        }
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    protected void calculatePlanStartTimeByAbusoluteDuration(int rowIndex) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"MasterPlanEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        if (planEndTime == null) {
            return;
        }
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("absoluteduration", rowIndex);
        if (absoluteDuration.compareTo(BigDecimal.ZERO) != 0) {
            Date newPlanStartTime = this.getDateAfterAddDays(project.getPkValue(), planEndTime, absoluteDuration.intValue() * -1, this.getAppId());
            this.getModel().setValue("planstarttime", (Object)newPlanStartTime, rowIndex);
        }
    }

    protected void calculatePlanEndTimeByAbusoluteDuration(int rowIndex) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"MasterPlanEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        if (planStartTime == null) {
            return;
        }
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("absoluteduration", rowIndex);
        if (absoluteDuration.compareTo(BigDecimal.ZERO) != 0) {
            Date newPlanEndTime = this.getDateAfterAddDays(project.getPkValue(), planStartTime, absoluteDuration.intValue() - 1, this.getAppId());
            this.getModel().setValue("planendtime", (Object)newPlanEndTime, rowIndex);
        }
    }

    protected Date getDateAfterAddDays(Object projectId, Date planStartTime, Integer relativeDuration, String appId) {
        return TaskUtil.getDateAfterAddDays((Object)projectId, (Date)planStartTime, (int)relativeDuration, (String)appId);
    }

    protected void calculateAbusoluteDuration(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        if (planStartTime == null || planEndTime == null) {
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"MasterPlanEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        BigDecimal newAbsoluteDuration = this.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime, this.getAppId());
        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration, rowIndex);
        if (newAbsoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
            String dateFormat = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            String msg = String.format(ResManager.loadKDStringExt((String)"\u7b2c%1$s\u884c\uff0c\u5728\u83b7\u53d6\u65f6\u95f4%2$s\u4e0e%3$s\u4e4b\u95f4\u7684\u76f8\u5dee\u5929\u6570\u65f6\uff0c\u53d1\u73b0\u4e24\u65e5\u671f\u4e4b\u95f4\u6ca1\u6709\u5de5\u4f5c\u65e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MasterPlanEditPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex + 1, sdf.format(planStartTime), sdf.format(planEndTime));
            this.getView().showErrorNotification(msg);
        }
    }

    protected void calculateCompleteTimeDeviation(int curIndex) {
        BigDecimal days;
        Date aimFinishTime = (Date)this.getModel().getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", curIndex);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (aimFinishTime == null || planEndTime == null) {
            this.getModel().setValue("comptimedeviation", null, curIndex);
            return;
        }
        if (project != null) {
            try {
                days = this.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, this.getAppId());
            }
            catch (KDBizException e) {
                this.getView().showMessage(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        days = days.subtract(BigDecimal.ONE);
        this.getModel().setValue("comptimedeviation", (Object)days, curIndex);
        this.settingEntryFieldTextColor(TASKENTITY, "comptimedeviation", curIndex);
    }

    protected BigDecimal getDaysBetweenTwoDate(Object projectId, Date planStartTime, Date planEndTime, String appId) {
        return TaskUtil.getDaysBetweenTwoDate((Object)projectId, (Date)planStartTime, (Date)planEndTime, (String)appId);
    }

    protected void showProjectList() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)this.getProjectFormId(), (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "switchProjectCallBack");
        showListForm.setCloseCallBack(closeCallBack);
        showListForm.setListFilterParameter(this.setProjectListFilter());
        this.getView().showForm((FormShowParameter)showListForm);
    }

    protected ListFilterParameter setProjectListFilter() {
        QFilter planType = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
        DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{planType});
        QFilter majorTypeFilter = null;
        if (majorType != null) {
            majorTypeFilter = new QFilter("majortype", "=", majorType.getPkValue());
        } else {
            logger.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u4e3b\u9879\u8ba1\u5212\u7c7b\u578b\uff0c\u53ef\u80fd\u5bfc\u81f4\u76f8\u5173\u67e5\u8be2\u8fc7\u6ee4\u6570\u636e\u4e0d\u51c6\u786e\uff0c\u8bf7\u6392\u67e5\u3002\u539f\u56e0\uff1a\u53ef\u80fd\u662f\u56e0\u4e3a\u9879\u76ee\u4e91\u516c\u5171\u670d\u52a1\u4e91\u4e0b\u8ba1\u5212\u7ba1\u7406\u7684\u4e13\u4e1a\u7c7b\u578b\u9884\u7f6e\u6570\u636e\uff0c\u672a\u5728\u7ee7\u627f\u65b9\u7684\u6570\u636e\u8868\u4e2d\u5b58\u5728\u3002");
        }
        QFilter projectFilter = new QFilter("project", "!=", (Object)0L);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"id,project", (QFilter[])new QFilter[]{majorTypeFilter, projectFilter});
        List ids = Arrays.stream(plans).filter(entry -> entry.getDynamicObject("project") != null).map(entry -> entry.getDynamicObject("project").getPkValue()).collect(Collectors.toList());
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
        DynamicObject[] projects = this.getAllProjects(isLeafFilter);
        List includeProjectIds = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        includeProjectIds.removeAll(ids);
        ListFilterParameter filterParameter = new ListFilterParameter();
        QFilter filter = new QFilter("id", "in", includeProjectIds);
        filterParameter.setFilter(filter);
        return filterParameter;
    }

    protected DynamicObject[] getAllProjects(QFilter isLeafFilter) {
        return BusinessDataServiceHelper.load((String)"bd_project", (String)"", (QFilter[])new QFilter[]{isLeafFilter});
    }

    protected void checkInputTime(String changeField, int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        Date aimEndTime = (Date)this.getModel().getValue("aimfinishtime", rowIndex);
        if ("planstarttime".equals(changeField)) {
            if (planStartTime == null) {
                return;
            }
            if (planEndTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4\u3002", (String)"MasterPlanEditPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if ("planendtime".equals(changeField)) {
            if (planEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"MasterPlanEditPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if ("aimfinishtime".equals(changeField)) {
            if (aimEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(aimEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"MasterPlanEditPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void deletePreTask(Set<String> deleteTasks) {
        DynamicObjectCollection taskEntity = this.getModel().getEntryEntity(TASKENTITY);
        for (DynamicObject task : taskEntity) {
            String pretaskPk;
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (null == preTask || !deleteTasks.contains(pretaskPk = preTask.getPkValue().toString())) continue;
            task.set("pretask", null);
            task.set("logical", null);
        }
    }

    protected void deleteTaskEntry(BeforeDoOperationEventArgs args) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length <= 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"MasterPlanEditPlugin_41", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean hasSub = false;
        for (int selRow : selRows) {
            BigDecimal percent = (BigDecimal)this.getModel().getValue("percent", selRow);
            if (percent.compareTo(new BigDecimal(100)) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u5ea6\u4e3a100%\u65f6\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"MasterPlanEditPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", selRow);
            if (isLeaf) continue;
            hasSub = true;
            break;
        }
        if (!hasSub) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"MasterPlanEditPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
            args.setCancel(true);
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u4efb\u52a1\u7684\u540c\u65f6\u5c06\u5220\u9664\u5b50\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MasterPlanEditPlugin_43", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
            args.setCancel(true);
        }
    }

    protected void deleteTaskCheck(int[] selectRowsIndex) {
        for (int selectRowIndex : selectRowsIndex) {
            DynamicObject entry = this.getModel().getEntryRowEntity(TASKENTITY, selectRowIndex);
            DynamicObject prechangeTask = entry.getDynamicObject("prechangetask");
            if (prechangeTask == null) continue;
            Set<Object> relationIds = this.getSameSourceTaskIds(prechangeTask.getPkValue());
            QFilter[] qFilters = new QFilter[]{new QFilter("relationtask", "in", relationIds)};
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])qFilters);
            if (tasks == null || tasks.length == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u8ba1\u5212\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"MasterPlanEditPlugin_44", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Object> getSameSourceTaskIds(Object pkValue) {
        HashSet<Object> idSet = new HashSet<Object>();
        DynamicObject preChangeTask = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject sourceTask = preChangeTask.getDynamicObject("sourcetask");
        if (sourceTask != null) {
            DynamicObject[] relationTasks;
            QFilter filter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            for (DynamicObject task : relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{filter})) {
                idSet.add(task.getPkValue());
            }
        }
        return idSet;
    }

    protected void rebuildTreeStructure() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(TASKENTITY);
        if (entries.isEmpty()) {
            return;
        }
        HashSet<String> pidSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            String pid = entry.getString("pid");
            if (pid == null) continue;
            pidSet.add(pid);
        }
        for (int index = 0; index < entries.size(); ++index) {
            DynamicObject entry;
            entry = (DynamicObject)entries.get(index);
            String id = entry.getPkValue().toString();
            if (pidSet.contains(id)) {
                entry.set("isleaf", (Object)Boolean.FALSE);
                continue;
            }
            entry.set("isleaf", (Object)Boolean.TRUE);
            entry.set("isGroupNode", (Object)Boolean.FALSE);
        }
    }

    protected String createPlanName(DynamicObject project, BigDecimal version) {
        String name = project.getString("name");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        String billName = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u4e3b\u9879\u8ba1\u5212%3$s", (String)"MasterPlanEditPlugin_30", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name, formatDate, version.setScale(1, RoundingMode.HALF_UP));
        IDataEntityProperty billNameProperty = this.getView().getModel().getDataEntityType().findProperty("billname");
        int limitLength = ((TextProp)billNameProperty).getMaxLenth();
        if (billName.length() > limitLength) {
            billName = billName.substring(0, limitLength);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u540d\u79f0\u8d85\u51fa\u4e86\u6700\u5927\u957f\u5ea6%s\uff0c\u5df2\u81ea\u52a8\u622a\u53d6\u3002", (String)"MasterPlanEditPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]), limitLength));
        }
        return billName;
    }

    protected void switchProject(Object projectPk) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectPk, (String)this.getProjectFormId());
        if (project == null) {
            return;
        }
        this.getModel().setValue("project", (Object)project);
        this.getModel().deleteEntryData(TASKENTITY);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        this.getModel().setValue("billname", (Object)this.createPlanName(project, version));
        QFilter projectFilter = new QFilter("project", "=", projectPk);
        DynamicObject[] calendarArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"), (String)"version", (QFilter[])new QFilter[]{projectFilter});
        if (calendarArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u672a\u8bbe\u7f6e\u65e5\u5386\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u65e5\u5386\u3002", (String)"MasterPlanEditPlugin_45", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void setShowTab() {
        Object preChangePlan = this.getModel().getValue("prechangeplan");
        String status = this.getModel().getDataEntity().getString("billstatus");
        if (preChangePlan != null && !"C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"adjusttab"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adjusttab"});
        }
        Object proPlanId = this.getModel().getDataEntity().getPkValue();
        QFilter proPlanFilter = new QFilter("masterplan", "=", proPlanId);
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (QFilter[])proPlanFilter.toArray()) && "C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"spectab"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"spectab"});
        }
    }

    protected void setSpecTypeCombo() {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        ArrayList<String> specNameList = new ArrayList<String>(16);
        int rowCount = this.getModel().getEntryRowCount(TASKENTITY);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject specObj = (DynamicObject)this.getModel().getValue("specialtype", i);
            if (specObj == null) continue;
            String specId = specObj.getString("id");
            String specName = specObj.getString("name");
            if (specNameList.contains(specName)) continue;
            specNameList.add(specName);
            comboList.add(new ComboItem(new LocaleString(specName), specId));
        }
        ComboEdit specCombo = (ComboEdit)this.getControl("spectypecombo");
        specCombo.setComboItems(comboList);
        if (comboList.size() > 0) {
            ComboItem comboItem = (ComboItem)comboList.get(0);
            this.getModel().setValue("spectypecombo", (Object)comboItem.getValue());
        }
    }

    protected void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("planstarttime");
        DateEdit planEndTime = (DateEdit)this.getControl("planendtime");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project != null) {
            Object projecId = project.getPkValue();
            Date firstDay = TaskUtil.getFirstDayByProject((Object)projecId, (String)this.getAppId()).getTime();
            Date endDay = TaskUtil.getEndDayByProject((Object)projecId, (String)this.getAppId()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    protected int getParentRowIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("pid", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(TASKENTITY, i);
                Object taskId = rowEntity.get("id");
                if (taskId == null || !parentId.toString().equals(taskId.toString())) continue;
                return i;
            }
        }
        return 0;
    }

    protected int getOlderBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("pid", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(TASKENTITY, i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("pid");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                return i;
            }
        } else {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(TASKENTITY, i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("pid");
                if (rowParent != null) continue;
                return i;
            }
        }
        return 0;
    }

    protected int getYoungerBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("pid", row);
        int rowCount = this.getModel().getEntryRowCount(TASKENTITY);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            int nextIndex = 0;
            int nextCount = 0;
            for (int i = row + 1; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(TASKENTITY, i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("pid");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                if (nextIndex != 0) {
                    nextCount = i - nextIndex;
                    break;
                }
                nextIndex = i;
            }
            if (nextCount == 0) {
                nextCount = rowCount - nextIndex;
            }
            return row + nextCount;
        }
        int nextIndex = 0;
        int nextCount = 0;
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(TASKENTITY, i);
            DynamicObject rowParent = (DynamicObject)rowEntity.get("pid");
            if (rowParent != null) continue;
            if (nextIndex != 0) {
                nextCount = i - nextIndex;
                break;
            }
            nextIndex = i;
        }
        if (nextCount == 0) {
            nextCount = rowCount - nextIndex;
        }
        return row + nextCount;
    }

    protected void viewTaskDetailOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"MasterPlanEditPlugin_46", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"MasterPlanEditPlugin_47", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASKENTITY);
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (task != null) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"MasterPlanEditPlugin_34", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", task.getPkValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void importTaskOperation() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog")));
        this.getView().showForm(importExcelFormParameter);
    }

    protected void loadTask() {
        int rowCount = this.getModel().getEntryRowCount(TASKENTITY);
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("id", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            PlanEntryUtil.setRowTaskObj((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)i);
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    protected void openTaskPage(Map<Object, Object> customMap, String pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        map.put("customParams", customMap);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        if (pkId != null) {
            ((BillShowParameter)parameter).setPkId((Object)pkId);
        } else {
            customMap.put("masterplanid", this.getModel().getDataEntity().getPkValue());
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                customMap.put("projectid", project.getString("id"));
            }
        }
        parameter.setAppId(this.getAppId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "task"));
        this.getView().showForm(parameter);
    }

    protected void setAllParentRowLocked() {
        Object preChangePlan = this.getModel().getValue("prechangeplan");
        if (preChangePlan != null) {
            // empty if block
        }
    }

    protected void setAdjustLocked() {
        int rowCount = this.getModel().getEntryRowCount(TASKENTITY);
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("id", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"completionstatus,prechangetask");
            if (!CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(task.get("completionstatus")) && !CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(task.get("completionstatus"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, this.rowNames);
        }
    }

    protected void isNoExistMajorType(String projectId) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)this.getProjectFormId(), (String)"group");
        DynamicObject projectKind = this.getProjectKind(project);
        if (projectKind == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"specialtype"});
        } else {
            String kindId = projectKind.getString("id");
            QFilter groupFilter = new QFilter("group", "=", (Object)kindId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObject[] majorTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{groupFilter, enableFilter});
            if (majorTypes.length == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"specialtype"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"specialtype"});
            }
        }
    }

    protected DynamicObject getProjectKind(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    protected DynamicObject[] getProCal(Object projectId) {
        QFilter projectFilter = new QFilter("project", "=", projectId);
        DynamicObject[] projectCalendarArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_projworkcalendarset"), (String)"id,project,modifytime,version", (QFilter[])new QFilter[]{projectFilter}, (String)"modifytime desc");
        if (projectCalendarArr.length == 0) {
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            DynamicObject[] defCalendarArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_projworkcalendarset"), (String)"id,project,modifytime,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"modifytime desc");
            return defCalendarArr;
        }
        return projectCalendarArr;
    }

    protected boolean isBeforePlanAudit(Object projectId, Object prePlanId) {
        boolean flag = false;
        DynamicObject[] proCalArr = this.getProCal(projectId);
        if (proCalArr != null && proCalArr.length > 0) {
            DynamicObject lastProCal = proCalArr[0];
            Date modifyTime = lastProCal.getDate("modifytime");
            DynamicObject prePlanObj = BusinessDataServiceHelper.loadSingle((Object)prePlanId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
            Date auditTime = prePlanObj.getDate("auditdate");
            if (modifyTime != null && auditTime != null && modifyTime.after(auditTime)) {
                flag = true;
            }
        }
        return flag;
    }

    protected void afterDeleteTask() {
        DynamicObjectCollection rowCount = this.getModel().getEntryEntity(TASKENTITY);
        for (int i = rowCount.size() - 1; i >= 0; --i) {
            this.settingTimeByChildren(i);
        }
    }

    protected PlanTaskImpAndExpUtil getUtil() {
        return new PlanTaskImpAndExpUtil(this.getView());
    }

    protected void verifyTaskIsPre(BeforeDoOperationEventArgs args) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TASKENTITY);
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length == 0) {
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection taskEntrys = this.getModel().getEntryEntity(TASKENTITY);
        Set preTaskId = taskEntrys.stream().filter(task -> task.get("pretask") != null).map(task -> task.getDynamicObject("pretask").getPkValue().toString()).collect(Collectors.toSet());
        if (preTaskId.isEmpty()) {
            return;
        }
        DynamicObject currentEntry = this.getModel().getEntryRowEntity(TASKENTITY, selRows[0]);
        if (preTaskId.contains(currentEntry.getPkValue().toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u4f5c\u4e3a\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\uff0c\u82e5\u65b0\u589e\u5b50\u7ea7\uff0c\u4f1a\u6e05\u9664\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MasterPlanEditPlugin_48", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(NEW_TASK_CONFIRM));
        }
    }
}

