/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;

public class MasterPlanListPlugin
extends AbstractPlacsListPlugin {
    private static final String PARENTID = "parentBillId";
    private static final String BEFIRSTENTER = "beFirstEnter";
    private static final String PROJECTID = "projectId";
    protected static final String ORGIdS = "orgIds";

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc,project.number desc,majortype.plantype asc,version asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                QFilter versionFilter = new QFilter("version", "=", (Object)"default");
                DynamicObject[] calendarArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"), (String)"version", (QFilter[])new QFilter[]{versionFilter});
                if (calendarArr.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"MasterPlanListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                ((ListView)this.getView()).clearSelection();
                break;
            }
            case "doadjust": {
                ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                if (row == null || ((ListView)this.getView()).getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"MasterPlanListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object id = row.getPrimaryKeyValue();
                if (null == id) break;
                DynamicObject curPlan = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"billstatus, majortype");
                if (curPlan == null) {
                    return;
                }
                if (!"C".equals(curPlan.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8c03\u6574\u5df2\u53d1\u5e03\u7684\u8ba1\u5212\u3002", (String)"MasterPlanListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("prechangeplan", "=", id)};
                DynamicObject[] parentVersion = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"billname", (QFilter[])filters);
                if (null != parentVersion && parentVersion.length > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u65b0\u7684\u8ba1\u5212\u7248\u672c\u8fdb\u884c\u8c03\u6574\u3002", (String)"MasterPlanListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject majorType = curPlan.getDynamicObject("majortype");
                filters = new QFilter[]{new QFilter("id", "=", majorType.getPkValue())};
                majorType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"plantype", (QFilter[])filters);
                String planType = majorType.getString("plantype");
                if (!StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.MAJORPLAN.getValue())) break;
                curPlan = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"majortype,masterplan,relatedmastertask");
                DynamicObject masterPlan = curPlan.getDynamicObject("masterplan");
                String planStatus = (masterPlan = BusinessDataServiceHelper.loadSingle((Object)masterPlan.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"sourceplan,planstatus")).getString("planstatus");
                if (!StringUtils.equals((CharSequence)planStatus, (CharSequence)PlanEnum.HISTORY.getValue())) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
                DynamicObject sourcePlan = masterPlan.getDynamicObject("sourceplan");
                Object sourcePlanPk = sourcePlan == null ? masterPlan.getPkValue() : sourcePlan.getPkValue();
                QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
                QFilter sourcePlanFilter = new QFilter("sourceplan", "=", sourcePlanPk);
                DynamicObject newestMasterPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"id", (QFilter[])new QFilter[]{sourcePlanFilter, planStatusFilter});
                map.put("selectedPlan", newestMasterPlan.getPkValue());
                map.put("majortypeId", curPlan.getDynamicObject("majortype").getPkValue());
                DynamicObject relatedMasterTask = curPlan.getDynamicObject("relatedmastertask");
                if (relatedMasterTask != null) {
                    relatedMasterTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask,islatest", (QFilter[])new QFilter[]{new QFilter("id", "=", relatedMasterTask.getPkValue())});
                    DynamicObject lastestTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", relatedMasterTask.get("sourcetask_id")), new QFilter("islatest", "=", (Object)"1")});
                    map.put("relatedmastertaskid", lastestTask.getPkValue());
                }
                this.modifyAdjustSpecialParamMap(map);
                FormShowParameter param = FormShowParameter.createFormShowParameter(map);
                param.setAppId(this.getAppId());
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setStatus(OperationStatus.ADDNEW);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specialplan"));
                this.getView().showForm(param);
                args.setCancel(true);
                return;
            }
            case "newmajorplan": {
                IListView listView = (IListView)this.getView();
                List selectedMainOrgIds = listView.getSelectedMainOrgIds();
                ListSelectedRow selectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (selectedRow != null && ((ListView)this.getView()).getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectedRow != null) {
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, project, majortype, billname, version, planstatus, org, displayfilter, spectypecombo, sourceplan, prechangeplan, assigner", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedRow.getPrimaryKeyValue())});
                    if (plan == null) {
                        args.setCancel(true);
                        return;
                    }
                    if (plan.getDynamicObject("org").getLong("id") != RequestContext.get().getOrgId()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u8ba1\u5212\u3002", (String)"MasterPlanListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
                    DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
                    if (!StringUtils.equals((CharSequence)plan.getDynamicObject("majortype").getPkValue().toString(), (CharSequence)planType.getPkValue().toString())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u7c7b\u578b\u3002", (String)"MasterPlanListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (!StringUtils.equals((CharSequence)plan.getString("planstatus"), (CharSequence)PlanEnum.PUBLISHED.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7248\u672c\u4e3a\u5386\u53f2\u7248\u672c\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u7248\u672c\u3002", (String)"MasterPlanListPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    map.put("selectedPlan", plan.getPkValue());
                }
                map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
                FormShowParameter param = FormShowParameter.createFormShowParameter(map);
                param.setAppId(this.getAppId());
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setStatus(OperationStatus.ADDNEW);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specialplan"));
                if (selectedMainOrgIds != null && selectedMainOrgIds.size() == 1) {
                    param.setCustomParam("SELECT_ORG_ID", (Object)((Long)selectedMainOrgIds.get(0)).toString());
                }
                this.getView().showForm(param);
                break;
            }
        }
    }

    protected void modifyAdjustSpecialParamMap(Map<String, Object> map) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "doadjust": {
                this.getView().invokeOperation("copy");
                break;
            }
            case "taskreport": {
                this.showTaskReportByProject(args);
                break;
            }
            case "workhours": {
                this.showWorkHoursByProject(args);
                break;
            }
            case "prooperationreport": {
                this.showProOperationReport(args);
                break;
            }
            case "proplanmonitor": {
                this.showProPlanMonitor(args);
                break;
            }
            case "proresulttrack": {
                this.showProResultTrack(args);
                break;
            }
            case "proplanreachrate": {
                this.showProPlanReachRate(args);
                break;
            }
            case "plancompareanalysis": {
                this.showPlanCompareAnalysis(args);
                break;
            }
            case "promeettaskmonitor": {
                this.showProMeetTaskMonitor(args);
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        IListView listView = (IListView)this.getView();
        ListSelectedRow row = listView.getCurrentSelectedRowInfo();
        if (row == null) {
            String projectId = this.getPageCache().get(PROJECTID);
            if (!StringUtils.isEmpty((CharSequence)projectId)) {
                e.getParameter().setCustomParam(PROJECTID, (Object)projectId);
            }
            return;
        }
        String planTypeStr = PlanTypeEnum.MAINPLAN.getValue();
        Object selectRowPk = row.getPrimaryKeyValue();
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)selectRowPk, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"majortype");
        DynamicObject planType = planObj.getDynamicObject("majortype");
        if (planType != null) {
            planTypeStr = planType.getString("plantype");
        }
        if (isCopy != null && isCopy.booleanValue() && PlanTypeEnum.MAINPLAN.getValue().equals(planTypeStr)) {
            e.getParameter().setCustomParam(PARENTID, selectRowPk);
        } else if (PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeStr)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
            FormShowParameter param = FormShowParameter.createFormShowParameter(map);
            param.setAppId(this.getAppId());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Object billId = e.getParameter().getPkId();
            if (billId != null) {
                ((BillShowParameter)param).setPkId(billId);
            }
            if (isCopy != null && isCopy.booleanValue()) {
                param.setCustomParam(PARENTID, selectRowPk);
                param.setCustomParam("iscopy", (Object)Boolean.TRUE);
            }
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specialplan"));
            this.getView().showForm(param);
            e.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            DynamicObject[] planTypeTypeArr;
            if ("creator.name".equals(filterColumn.getFieldName())) {
                CommonFilterColumn creatorFilterColumn = (CommonFilterColumn)filterColumn;
                DynamicObject[] planList = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"creator", (QFilter[])new QFilter[0]);
                HashMap<String, DynamicObject> creatorIdMap = new HashMap<String, DynamicObject>();
                for (DynamicObject plan : planList) {
                    DynamicObject creator = plan.getDynamicObject("creator");
                    String creatorId = creator.getString("id");
                    if (creatorIdMap.containsKey(creatorId)) continue;
                    creatorIdMap.put(creatorId, creator);
                }
                for (Map.Entry entry : creatorIdMap.entrySet()) {
                    ComboItem item = new ComboItem();
                    item.setId((String)entry.getKey());
                    item.setCaption(new LocaleString(((DynamicObject)entry.getValue()).getString("name")));
                    item.setValue((String)entry.getKey());
                    creatorFilterColumn.getComboItems().add(item);
                }
                continue;
            }
            if (!"majortype.name".equals(filterColumn.getFieldName())) continue;
            CommonFilterColumn planTypeFilterColumn = (CommonFilterColumn)filterColumn;
            planTypeFilterColumn.getComboItems().clear();
            QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
            String[] planTypeArr = new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.MAJORPLAN.getValue()};
            QFilter planTypeFilter = new QFilter("plantype", "in", (Object)planTypeArr);
            QFilter qFilter = enableFilter.and(planTypeFilter);
            for (DynamicObject planType : planTypeTypeArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (String)"id,name,plantype", (QFilter[])new QFilter[]{qFilter}, (String)"plantype asc,number asc")) {
                ComboItem item = new ComboItem();
                item.setId(planType.getString("id"));
                item.setCaption(new LocaleString(planType.getString("name")));
                item.setValue(planType.getString("id"));
                planTypeFilterColumn.getComboItems().add(item);
            }
        }
        String beFirstEnter = this.getPageCache().get(BEFIRSTENTER);
        if (beFirstEnter == null || beFirstEnter.equals("true")) {
            List orgIds = this.getOrgFilterColumn().getDefaultValues();
            String orgIdsJson = SerializationUtils.toJsonString((Object)orgIds);
            this.getPageCache().put(BEFIRSTENTER, "false");
            this.getPageCache().put(ORGIdS, orgIdsJson);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        List orgIds = this.getOrgFilterColumn().getDefaultValues();
        String orgIdsJson = SerializationUtils.toJsonString((Object)orgIds);
        this.getPageCache().put(ORGIdS, orgIdsJson);
    }

    protected CommonFilterColumn getOrgFilterColumn() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        int orgIndex = -1;
        List items = filterGridView.getItems();
        for (int i = 0; i < items.size(); ++i) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)items.get(i);
            if (!filterColumn.getFieldName().equals("org.name")) continue;
            orgIndex = i;
            break;
        }
        return (CommonFilterColumn)filterGridView.getItems().get(orgIndex);
    }

    protected CommonFilterColumn getProjectFilterColumn() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        int projectIndex = -1;
        List items = filterGridView.getItems();
        for (int i = 0; i < items.size(); ++i) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)items.get(i);
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("project.name") && !fieldName.equals("project.fullname")) continue;
            projectIndex = i;
            break;
        }
        return (CommonFilterColumn)filterGridView.getItems().get(projectIndex);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        Object projectId = args.getFilterValue("project.id");
        CommonFilterColumn planTypeCommonFilterColumn = this.getPlanTypeCommonFilterColumn();
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(projectId);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
        String fieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
        if (fieldName.equals("org.id")) {
            Map filterValues = args.getFilterValues();
            List customfilter = (List)filterValues.get("customfilter");
            for (Map filterColumn : customfilter) {
                String columnName = (String)((List)filterColumn.get("FieldName")).get(0);
                if (!columnName.equals("project.id")) continue;
                filterColumn.put("Value", Collections.singletonList(""));
                break;
            }
            this.getPageCache().put(PROJECTID, "");
        } else if (!Objects.isNull(projectId)) {
            this.getPageCache().put(PROJECTID, projectId.toString());
        }
    }

    protected CommonFilterColumn getPlanTypeCommonFilterColumn() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        return (CommonFilterColumn)filterGridView.getItems().get(4);
    }

    protected List<ComboItem> buildPlanTypeComboItems(Object projectId) {
        DynamicObject project;
        QFilter filter1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        String[] planTypeArray = new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.MAJORPLAN.getValue()};
        QFilter filter = new QFilter("plantype", "in", (Object)planTypeArray);
        if (projectId != null && (filter1 = this.getQFilterByProjectGroup(project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)this.getProjectFormId()))) != null) {
            filter.and(filter1);
        }
        filter.and("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject[] planTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (String)"plantype", (QFilter[])new QFilter[]{filter}, (String)"plantype asc,number asc");
        if (planTypes.length > 0) {
            for (DynamicObject planType : planTypes) {
                ComboItem item = new ComboItem();
                item.setId(planType.getPkValue().toString());
                OrmLocaleValue type = (OrmLocaleValue)planType.get("name");
                item.setCaption(new LocaleString(type.getLocaleValue()));
                item.setValue(planType.getPkValue().toString());
                if (PlanTypeEnum.getEnumByValue((Object)planType.get("plantype")) == PlanTypeEnum.MAINPLAN) {
                    combos.add(0, item);
                    continue;
                }
                combos.add(item);
            }
        }
        return combos;
    }

    protected QFilter getQFilterByProjectGroup(DynamicObject project) {
        DynamicObject kind = project.getDynamicObject("group");
        QFilter filter = new QFilter("group", "=", (Object)0L);
        if (kind != null) {
            filter.or(new QFilter("group", "=", kind.getPkValue()));
        }
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("specialplan".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    protected void showTaskReportByProject(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"project", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)operate.getListSelectedData().getPrimaryKeyValues())});
        parameter.setCustomParam("project", masterPlan.getDynamicObject("project").getPkValue());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showWorkHoursByProject(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_list"));
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId(this.getView().getFormShowParameter().getAppId());
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        parameter.setCustomParam("project", masterPlan.getDynamicObject("project").getPkValue());
        parameter.setCustomParam("source", (Object)"masterplan");
        this.getView().showForm(parameter);
    }

    protected void showProOperationReport(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        parameter.setCustomParam("project", masterPlan.getDynamicObject("project").getPkValue());
        parameter.setCustomParam("org", masterPlan.getDynamicObject("org").getPkValue());
        parameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u8fd0\u8425\u62a5\u544a", (String)"MasterPlanListPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showProPlanMonitor(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanmonitor"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        parameter.setCustomParam("project", masterPlan.getDynamicObject("project").getPkValue());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showProResultTrack(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proresulttrack"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("proId", masterPlan.getDynamicObject("project").getPkValue());
        showParameter.setCustomParam("source", (Object)"masterplan");
        if (selectedMainOrgIds != null && selectedMainOrgIds.size() >= 1) {
            showParameter.setCustomParam("orgId", (Object)((Long)selectedMainOrgIds.get(0)).toString());
        }
        this.getView().showForm(showParameter);
    }

    protected void showProPlanReachRate(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        DynamicObject[] masterPlans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"project", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)operate.getListSelectedData().getPrimaryKeyValues())});
        ArrayList proIds = new ArrayList();
        Arrays.stream(masterPlans).forEach(masterPlan -> proIds.add(masterPlan.getDynamicObject("project").getPkValue()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanreachrate"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("proId", proIds);
        showParameter.setCustomParam("source", (Object)"masterplan");
        if (selectedMainOrgIds != null && selectedMainOrgIds.size() >= 1) {
            showParameter.setCustomParam("orgId", (Object)selectedMainOrgIds);
        }
        this.getView().showForm(showParameter);
    }

    protected void showPlanCompareAnalysis(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        DynamicObject masterplan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plancompareanalysis"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("planId", (Object)masterplan.getPkValue().toString());
        showParameter.setCustomParam("source", (Object)"masterplan");
        this.getView().showForm(showParameter);
    }

    protected void showProMeetTaskMonitor(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if (operate.getListSelectedData().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MasterPlanListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"promeettaskmonitor"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)operate.getListSelectedData().get(0).toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        parameter.setCustomParam("project", masterPlan.getDynamicObject("project").getPkValue());
        parameter.setCustomParam("org", masterPlan.getDynamicObject("org").getPkValue());
        this.getView().showForm((FormShowParameter)parameter);
    }
}

