/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.control.Control;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;

public class PersonPlanBillListPlugin
extends AbstractPlacsListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List list = args.getCommonFilterColumns();
        Long orgId = RequestContext.get().getOrgId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List deptList = UserServiceHelper.getUserDepartment((long)userId, (boolean)true);
        if (null == deptList || !deptList.contains(orgId)) {
            CommonFilterColumn userCFC = (CommonFilterColumn)list.get(4);
            List<ComboItem> comboItems = this.buildUserComboItem(userId);
            userCFC.setComboItems(comboItems);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        } else {
            CommonFilterColumn userCFC = (CommonFilterColumn)list.get(4);
            ArrayList<Long> orgList = new ArrayList<Long>();
            orgList.add(RequestContext.get().getOrgId());
            List<ComboItem> comboItemsOfOrg = this.buildUserOfOrgComboItem(orgList);
            userCFC.setComboItems(comboItemsOfOrg);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        }
    }

    private List<ComboItem> buildUserComboItem(Long userId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        ComboItem item = new ComboItem();
        item.setId(user.getString("id"));
        item.setCaption(new LocaleString(user.getString("name")));
        item.setValue(user.getString("id"));
        combos.add(item);
        this.getPageCache().put("allchargeuser", userId.toString());
        return combos;
    }

    private List<ComboItem> buildUserOfOrgComboItem(List<Long> orgIds) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        List directUsersOfOrg = UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true);
        QFilter idFilter = new QFilter("id", "in", (Object)directUsersOfOrg);
        QFilter[] filters = new QFilter[]{idFilter};
        StringBuilder sb = new StringBuilder();
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])filters);
        for (int i = 0; i < users.length; ++i) {
            ComboItem item = new ComboItem();
            item.setId(users[i].getString("id"));
            item.setCaption(new LocaleString(users[i].getString("name")));
            item.setValue(users[i].getString("id"));
            combos.add(item);
            sb.append(users[i].getString("id")).append(",");
        }
        this.getPageCache().put("allchargeuser", sb.substring(0, sb.lastIndexOf(",")));
        return combos;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List<ComboItem> comboItemsOfOrg;
        List<ComboItem> comboItems;
        super.filterContainerSearchClick(args);
        List selectMainOrgIds = args.getSelectMainOrgIds();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List deptList = UserServiceHelper.getUserDepartment((long)userId, (boolean)true);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        CommonFilterColumn userCFC = null;
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        List items = filterGridView.getItems();
        for (Control item : items) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)item;
            String fieldName = commonFilterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"planperson")) continue;
            userCFC = commonFilterColumn;
        }
        if (userCFC == null) {
            return;
        }
        if (deptList == null || deptList.isEmpty()) {
            comboItems = this.buildUserComboItem(userId);
            userCFC.setComboItems(comboItems);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        } else if (selectMainOrgIds == null || selectMainOrgIds.isEmpty()) {
            comboItemsOfOrg = this.buildUserOfOrgComboItem(deptList);
            userCFC.setComboItems(comboItemsOfOrg);
            userCFC.setDefaultValue(RequestContext.get().getUserId());
        } else {
            deptList.retainAll(selectMainOrgIds);
            if (deptList.isEmpty()) {
                comboItems = this.buildUserComboItem(userId);
                userCFC.setComboItems(comboItems);
                userCFC.setDefaultValue(RequestContext.get().getUserId());
            } else {
                comboItemsOfOrg = this.buildUserOfOrgComboItem(deptList);
                userCFC.setComboItems(comboItemsOfOrg);
                userCFC.setDefaultValue(RequestContext.get().getUserId());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filterList = e.getQFilters();
        QFilter personFilter = null;
        for (QFilter qFilter : filterList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"planperson")) continue;
            personFilter = qFilter;
            Object value = qFilter.getValue();
            if (value instanceof ArrayList) {
                ArrayList collect = (ArrayList)((ArrayList)value).stream().map(id -> Long.valueOf((String)id)).collect(Collectors.toList());
                qFilter.__setValue((Object)collect);
                continue;
            }
            qFilter.__setValue((Object)Long.valueOf((String)value));
        }
        if (null != personFilter) {
            QFilter deptFilter;
            filterList.remove(personFilter);
            Object value = personFilter.getValue();
            if (value instanceof ArrayList) {
                deptFilter = new QFilter("modifier", "in", personFilter.getValue());
                filterList.add(deptFilter);
            } else {
                deptFilter = new QFilter("modifier", "=", personFilter.getValue());
                filterList.add(deptFilter);
            }
        } else {
            String users = this.getPageCache().get("allchargeuser");
            if (StringUtils.isNotBlank((CharSequence)users)) {
                List collect = Arrays.stream(users.split(",")).map(id -> Long.valueOf(id)).collect(Collectors.toList());
                QFilter userFilter = new QFilter("modifier", "in", collect);
                filterList.add(userFilter);
            }
        }
    }
}

