/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.PersonTypeEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class PersonPlanTaskEditPlugin
extends AbstractPlacsBillPlugin
implements BeforeF7SelectListener {
    private static final String ORG_ID = "orgId";
    private static final Log logger = LogFactory.getLog(PersonPlanTaskEditPlugin.class);
    public static final int RESPONORSHARE_PEERSONTYPE = 1;
    public static final int COOPERATE_PERSONTYPE = 2;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationPerson = (BasedataEdit)this.getControl("cooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationDept = (BasedataEdit)this.getControl("cooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        switch (propName) {
            case "responsibleperson": {
                DynamicObject responsibleDept = this.getModel().getDataEntity().getDynamicObject("responsibledept");
                if (null == customMap.get(ORG_ID)) break;
                Long orgId = Long.valueOf(customMap.get(ORG_ID).toString());
                if (responsibleDept != null) {
                    orgId = Long.valueOf(responsibleDept.getPkValue().toString());
                }
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                String userId = RequestContext.get().getUserId();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List userIds = null;
                userIds = null != subordinateOrgs && subordinateOrgs.contains(orgId) ? UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)true) : UserServiceHelper.getAllUsersOfOrg(orgIds, (boolean)false);
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "responsibledept": {
                DynamicObject responsiblePreson = this.getModel().getDataEntity().getDynamicObject("responsibleperson");
                if (null == customMap.get(ORG_ID)) break;
                Long orgId = Long.valueOf(customMap.get(ORG_ID).toString());
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgIds.add(orgId);
                List orgIdList = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), orgIds, (boolean)true);
                String userId = RequestContext.get().getUserId();
                if (responsiblePreson != null) {
                    userId = responsiblePreson.getPkValue().toString();
                }
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                QFilter orgFilter = null;
                if (null != subordinateOrgs && subordinateOrgs.contains(orgId)) {
                    orgFilter = new QFilter("id", "in", (Object)orgIdList);
                } else {
                    List allDeptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    allDeptList.retainAll(orgIdList);
                    orgFilter = new QFilter("id", "in", (Object)allDeptList);
                }
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
            case "cooperationperson": {
                DynamicObject cooperationDept = this.getModel().getDataEntity().getDynamicObject("cooperationdept");
                if (cooperationDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(cooperationDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "cooperationdept": {
                DynamicObject cooperationPreson = this.getModel().getDataEntity().getDynamicObject("cooperationperson");
                if (cooperationPreson == null) break;
                String userId = cooperationPreson.getPkValue().toString();
                List deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                deptIds.removeAll(subordinateOrgs);
                deptIds.addAll(subordinateOrgs);
                QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("billId")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("personplanid", customParams.get("billId"));
            this.getModel().setValue("level", (Object)"1");
            this.getModel().setValue("isleaf", (Object)"0");
            this.getModel().setValue("parent", (Object)"");
            this.getModel().setValue("responsibledept", (Object)RequestContext.get().getOrgId());
            this.getModel().setValue("responsibleperson", (Object)RequestContext.get().getUserId());
            QFilter[] filters = new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.PRIVATEPLAN.getValue())};
            DynamicObject majors = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])filters);
            if (null != majors) {
                this.getModel().setValue("belongplantype", majors.get("id"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDateEditRange();
        this.updateTimeDeviationColor();
        Object status = this.getModel().getValue("status");
        if (!StatusEnum.CHECKED.getValue().equals(status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"progressreport"});
        }
    }

    protected void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("planstarttime");
        DateEdit planEndTime = (DateEdit)this.getControl("planendtime");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        Object orgId = customMap.get(ORG_ID);
        if (null != orgId) {
            Date firstDay = TaskUtil.getFirstDayByOrg(orgId, (String)this.getAppId()).getTime();
            Date endDay = TaskUtil.getEndDayByOrg(orgId, (String)this.getAppId()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    protected void updateTimeDeviationColor() {
        BigDecimal comTimeDeviation = this.getModel().getDataEntity().getBigDecimal("comptimedeviation");
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            propMap.put("fc", "#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            propMap.put("fc", "#FF0000");
        }
        this.getView().updateControlMetadata("comptimedeviation", propMap);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (null != this.getModel().getDataEntity() && null != this.getModel().getDataEntity().getPkValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", this.getModel().getDataEntity().getPkValue().toString());
            this.getView().returnDataToParent(map);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        Date planEndTime = model.getDate("planendtime");
        BigDecimal absoluteduration = model.getBigDecimal("absoluteduration");
        switch (propertyName) {
            case "responsibleperson": 
            case "cooperationperson": {
                List deptIds;
                List subordinateOrgs;
                List deptChargeList;
                String userId;
                DynamicObject respon = (DynamicObject)this.getModel().getValue("responsibleperson");
                DynamicObject cooper = (DynamicObject)this.getModel().getValue("cooperationperson");
                DynamicObject respondept = (DynamicObject)this.getModel().getValue("responsibledept");
                DynamicObject cooperdept = (DynamicObject)this.getModel().getValue("cooperationdept");
                if (respon != null && cooper != null && StringUtils.equalsIgnoreCase((CharSequence)respon.getPkValue().toString(), (CharSequence)cooper.getPkValue().toString())) {
                    this.getModel().setValue("cooperationperson", null);
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u534f\u529e\u4eba\u4e0d\u80fd\u548c\u8d23\u4efb\u4eba\u662f\u540c\u4e00\u4e2a\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PersonPlanTaskEditPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (null != cooper) {
                    userId = cooper.getPkValue().toString();
                    deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                    subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                    deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                    deptIds.removeAll(subordinateOrgs);
                    deptIds.addAll(subordinateOrgs);
                    if (!deptIds.isEmpty() && cooperdept == null) {
                        this.getModel().setValue("cooperationdept", deptIds.get(0));
                    }
                }
                if (null == respon) break;
                userId = respon.getPkValue().toString();
                deptChargeList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)true);
                subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (List)deptChargeList, (boolean)true);
                deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)false);
                deptIds.removeAll(subordinateOrgs);
                deptIds.addAll(subordinateOrgs);
                if (deptIds.isEmpty() || respondept != null) break;
                this.getModel().setValue("responsibledept", deptIds.get(0));
                break;
            }
            case "planstarttime": {
                Date oldValue = (Date)changeSet.getOldValue();
                if (planStartTime != null && planEndTime != null && DateUtil.compareByDay((Date)planStartTime, (Date)planEndTime) > 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u665a\u4e8e\u4efb\u52a1\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u3002", (String)"PersonPlanTaskEditPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("planstarttime", (Object)oldValue);
                    this.getModel().endInit();
                    this.getView().updateView("planstarttime");
                    return;
                }
                if (planStartTime == null) break;
                this.calPlanTime("planstarttime");
                break;
            }
            case "planendtime": {
                Date oldValueend = (Date)changeSet.getOldValue();
                if (planStartTime != null && planEndTime != null && DateUtil.compareByDay((Date)planEndTime, (Date)planStartTime) < 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u9700\u8981\u5927\u4e8e\u7b49\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PersonPlanTaskEditPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("planendtime", (Object)oldValueend);
                    this.getModel().endInit();
                    this.getView().updateView("planendtime");
                    return;
                }
                if (planEndTime == null) break;
                this.calPlanTime("planendtime");
                this.calCompTimeDeviation();
                break;
            }
            case "absoluteduration": {
                BigDecimal oldValue1 = (BigDecimal)changeSet.getOldValue();
                if (absoluteduration.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u7edd\u5bf9\u5de5\u671f\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"PersonPlanTaskEditPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("absoluteduration", (Object)oldValue1);
                    this.getModel().endInit();
                    this.getView().updateView("absoluteduration");
                    break;
                }
                this.calPlanTime("absoluteduration");
                break;
            }
            case "aimfinishtime": {
                this.calCompTimeDeviation();
                break;
            }
        }
    }

    protected void calPlanTime(String changeField) {
        DynamicObject model = this.getModel().getDataEntity();
        Date planStartTime = model.getDate("planstarttime");
        BigDecimal absoluteDuration = model.getBigDecimal("absoluteduration");
        Date planEndTime = model.getDate("planendtime");
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        if (customMap.get(ORG_ID) == null) {
            return;
        }
        String orgId = customMap.get(ORG_ID).toString();
        switch (changeField) {
            case "absoluteduration": {
                if (planStartTime != null) {
                    this.getModel().beginInit();
                    Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)orgId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                    this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                    this.calCompTimeDeviation();
                    this.getModel().endInit();
                    this.getView().updateView("planendtime");
                    break;
                }
                if (planEndTime == null) break;
                this.getModel().beginInit();
                Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)orgId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                break;
            }
            case "planendtime": {
                if (planStartTime != null) {
                    try {
                        this.getModel().beginInit();
                        BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)orgId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                        this.getModel().endInit();
                        this.getView().updateView("absoluteduration");
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        this.getModel().beginInit();
                        this.getModel().setValue("planendtime", (Object)"");
                        this.getModel().endInit();
                        this.getView().updateView("planendtime");
                        this.getModel().beginInit();
                        this.getModel().setValue("absoluteduration", (Object)"");
                        this.getModel().endInit();
                        this.getView().updateView("absoluteduration");
                    }
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                Date newPlanStartTime = TaskUtil.getDateAfterAddDaysByOrg((Object)orgId, (Date)planEndTime, (int)(-absoluteDuration.intValue()), (String)this.getAppId());
                this.getModel().setValue("planstarttime", (Object)newPlanStartTime);
                this.getModel().endInit();
                this.getView().updateView("planstarttime");
                break;
            }
            case "planstarttime": {
                if (absoluteDuration != null && absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
                    if (planEndTime == null) break;
                    try {
                        this.getModel().beginInit();
                        BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg((Object)orgId, (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
                        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
                        this.getModel().endInit();
                        this.getView().updateView("absoluteduration");
                    }
                    catch (KDBizException e) {
                        this.getView().showTipNotification(e.getMessage());
                        this.getModel().beginInit();
                        this.getModel().setValue("planstarttime", (Object)"");
                        this.getModel().endInit();
                        this.getView().updateView("planstarttime");
                        this.getModel().beginInit();
                        this.getModel().setValue("absoluteduration", (Object)"");
                        this.getModel().endInit();
                        this.getView().updateView("absoluteduration");
                    }
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().beginInit();
                Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg((Object)orgId, (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
                this.getModel().setValue("planendtime", (Object)newPlanEndTime);
                this.calCompTimeDeviation();
                this.getModel().endInit();
                this.getView().updateView("planendtime");
                break;
            }
        }
    }

    protected void calCompTimeDeviation() {
        Date aimFinishTime = this.getModel().getDataEntity().getDate("aimfinishtime");
        Date planEndTime = this.getModel().getDataEntity().getDate("planendtime");
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        String orgId = customMap.get(ORG_ID).toString();
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        BigDecimal days = TaskUtil.getDaysBetweenTwoDateByOrg((Object)orgId, (Date)planEndTime, (Date)aimFinishTime, (String)this.getAppId());
        this.getModel().setValue("comptimedeviation", (Object)days);
        this.getView().updateView("comptimedeviation");
        this.updateTimeDeviationColor();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        Date planstarttime = (Date)this.getModel().getValue("planstarttime");
        Date planendtime = (Date)this.getModel().getValue("planendtime");
        String starttime = this.getView().getFormShowParameter().getCustomParam("starttime").toString();
        String endtime = this.getView().getFormShowParameter().getCustomParam("endtime").toString();
        Date taskstarttimeFrom = null;
        Date taskendtimeTo = null;
        try {
            taskstarttimeFrom = dateFormat.parse(starttime);
            taskendtimeTo = dateFormat.parse(endtime);
        }
        catch (ParseException e) {
            logger.error("parse exceprtion", (Throwable)e);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save")) {
            boolean flag;
            String userid;
            String res;
            DynamicObject responsible = (DynamicObject)this.getModel().getValue("responsibleperson");
            DynamicObject cooperation = (DynamicObject)this.getModel().getValue("cooperationperson");
            if (responsible != null && cooperation != null) {
                res = responsible.getPkValue().toString();
                String coop = cooperation.getPkValue().toString();
                String userid2 = RequestContext.get().getUserId() + "";
                if (res.equals(coop)) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u534f\u529e\u4eba\u548c\u8d23\u4efb\u4eba\u4e0d\u53ef\u91cd\u590d\u3002", (String)"PersonPlanTaskEditPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!res.equals(userid2) && !coop.equals(userid2)) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458\u5fc5\u987b\u662f\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u6216\u534f\u529e\u4eba\u3002", (String)"PersonPlanTaskEditPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (responsible != null && !(res = responsible.getPkValue().toString()).equals(userid = RequestContext.get().getUserId() + "")) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458\u5fc5\u987b\u662f\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u6216\u534f\u529e\u4eba\u3002", (String)"PersonPlanTaskEditPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!(flag = this.checkTime(taskstarttimeFrom, taskendtimeTo))) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0e\u4e2a\u4eba\u8ba1\u5212\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u3002", (String)"PersonPlanTaskEditPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object customParam = this.getView().getFormShowParameter().getCustomParam("tasks");
            if (customParam != null) {
                JSONArray jsons = (JSONArray)customParam;
                int size = jsons.size();
                String name = this.getModel().getValue("name").toString();
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < size; ++i) {
                    JSONObject object = (JSONObject)jsons.get(i);
                    String taskname = object.get((Object)"taskname").toString();
                    set.add(taskname);
                }
                if (set.contains(name)) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PersonPlanTaskEditPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (planstarttime.after(planendtime)) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f00\u59cb\u65f6\u95f4\u5e94\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"PersonPlanTaskEditPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"taskreport")) {
            this.doTaskReport(args);
        }
    }

    protected void doTaskReport(BeforeDoOperationEventArgs args) {
        QFilter taskReportPersonType;
        Object taskId = this.getModel().getDataEntity().getPkValue();
        QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
        QFilter taskIdFilter = new QFilter("task", "=", taskId);
        QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{StatusEnum.CHECKED.getValue(), StatusEnum.TEMPSAVE.getValue()});
        DynamicObject[] noCheckedReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"id,task,percent,autocomplete", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter});
        List<String> noCReportIdList = Arrays.stream(noCheckedReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
        String[] noCReportIds = new String[noCReportIdList.size()];
        noCReportIdList.toArray(noCReportIds);
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])noCReportIds);
        if (bizProcessStatus != null && !bizProcessStatus.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6709\u201c\u8fdb\u5ea6\u6c47\u62a5\u201d\u8fdb\u5165\u5ba1\u6279\u6d41\uff0c\u8bf7\u5148\u5ba1\u6279\u518d\u6c47\u62a5\u3002", (String)"PersonPlanTaskEditPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
        map.put("taskId", taskId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.setAppId(this.getAppId());
        QFilter taskid = new QFilter("task", "=", taskId);
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.TEMPSAVE.getValue()).or("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
        QFilter[] filters = null;
        String userId = RequestContext.get().getUserId();
        DynamicObject responPerson = (DynamicObject)this.getModel().getValue("responsibleperson");
        DynamicObjectCollection cooperatePersons = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson");
        List<Object> coopersonIds = new ArrayList();
        if (cooperatePersons != null && !cooperatePersons.isEmpty()) {
            coopersonIds = cooperatePersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        DynamicObject sharer = (DynamicObject)this.getModel().getValue("sharer");
        if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)userId) || null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            map.put("person", 1);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue()).or("persontype", "=", (Object)PersonTypeEnum.SHARER.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else if (coopersonIds.contains(Long.parseLong(userId))) {
            map.put("person", 2);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u53ea\u6709\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u3001\u534f\u529e\u4eba\u548c\u5171\u4eab\u4eba\uff0c\u624d\u80fd\u6c47\u62a5\u8be5\u4efb\u52a1\u3002", (String)"PersonPlanTaskEditPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters);
        if (null != taskReports && taskReports.length > 0) {
            showParameter.setStatus(OperationStatus.EDIT);
            map.put("editreport", Boolean.TRUE);
            ((BillShowParameter)showParameter).setPkId(taskReports[0].getPkValue());
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            map.put("addreport", Boolean.TRUE);
        }
        showParameter.setCustomParams(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected boolean checkTime(Date planStartTime, Date planEndTime) {
        Date taskStartTime = (Date)this.getModel().getValue("planstarttime");
        Date taskEndTime = (Date)this.getModel().getValue("planendtime");
        if (taskEndTime.before(planStartTime) || taskStartTime.after(planEndTime)) {
            return taskStartTime.equals(planStartTime) && taskEndTime.equals(planEndTime);
        }
        return true;
    }
}

