/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class PlanCompareAnalysisListPlugin
extends AbstractPlacsFormPlugin
implements ClickListener {
    private static final String KEY_PROJECT = "project";
    private static final String KEY_PLANTYPE = "plantype";
    private static final String KEY_BASEVERSIONID = "baseversionid";
    private static final String KEY_BASEVERSION = "baseversion";
    private static final String KEY_COMPAREVERSIONSIDLIST = "compareversionsidlist";
    private static final String KEY_COMPAREVERSIONS = "compareversions";
    private static final String KEY_BASEVERSIONCALLBACK = "baseversioncallback";
    private static final String KEY_COMPAREVERSIONSCALLBACK = "compareversionscallback";
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String KEY_SEARCH = "search";
    private static final String KEY_ID = "id";
    private static final String KEY_VERSION = "version";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_SOURCETASKID = "sourcetaskid";
    private static final String KEY_PARENT = "parent";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_TASK = "task";
    private static final String KEY_TASKNAME = "taskname";
    private static final String KEY_TASKCONTROLLEVEL = "taskcontrollevel";
    private static final String KEY_TASKTYPE = "tasktype";
    private static final String KEY_RESPONSIBLEPERSON = "responsibleperson";
    private static final String KEY_STARTTIME = "planstarttime";
    private static final String KEY_ENDTIME = "planendtime";
    private static final String KEY_ABSDURATION = "absoluteduration";
    private static final String KEY_SPECIALTASK = "specialtask";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static String KEY_VERSION_PREFIX = "V";
    private static final String CODE_QUERYCLICK = "queryclick";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BASEVERSION});
        this.addClickListeners(new String[]{KEY_COMPAREVERSIONS});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (KEY_SEARCH.equals(operateKey)) {
            this.doSearch(args);
        } else if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"PlanCompareAnalysisListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"true");
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"PlanCompareAnalysisListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"false");
            }
        }
    }

    private void doSearch(BeforeDoOperationEventArgs args) {
        DynamicObject project = (DynamicObject)this.getModel().getValue(KEY_PROJECT);
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PlanCompareAnalysisListPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        Object planTypePk = this.getModel().getValue(KEY_PLANTYPE);
        if (planTypePk == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7c7b\u578b\u3002\u3002", (String)"PlanCompareAnalysisListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        String baseVersion = (String)this.getModel().getValue(KEY_BASEVERSION);
        if (baseVersion == null || "".equals(baseVersion)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u57fa\u51c6\u7248\u672c\u3002", (String)"PlanCompareAnalysisListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        JSONObject baseVersionObj = JSONObject.parseObject((String)this.getModel().getValue(KEY_BASEVERSIONID).toString());
        String compareVersions = (String)this.getModel().getValue(KEY_COMPAREVERSIONS);
        if (compareVersions == null || "".equals(compareVersions)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u5bf9\u6bd4\u7248\u672c\u3002", (String)"PlanCompareAnalysisListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        JSONArray compareVersionObjList = JSONArray.parseArray((String)this.getModel().getValue(KEY_COMPAREVERSIONSIDLIST).toString());
        this.configColumnName();
        this.hideColumn();
        this.showColumn();
        JSONObject data = this.getTaskData(baseVersionObj, compareVersionObjList);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONArray taskArray = data.getJSONArray(KEY_TASK);
        taskArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getInteger(KEY_SEQ)));
        List allTaskIds = taskArray.stream().map(obj -> ((JSONObject)obj).getString(KEY_TASKID)).collect(Collectors.toList());
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        IDataModel model = treeGrid.getModel();
        model.deleteEntryData(KEY_TREEENTRYENTITY);
        JSONArray commonArray = new JSONArray();
        JSONArray rootArray = new JSONArray();
        for (Object obj2 : taskArray) {
            JSONObject task = (JSONObject)obj2;
            commonArray.add((Object)task);
            if (allTaskIds.contains(task.getString(KEY_PARENT))) continue;
            rootArray.add((Object)task);
        }
        this.fillTreeList(model, rootArray, commonArray, true, 0);
        this.initStyleTreeEntity(treeGrid);
    }

    private JSONObject getTaskData(JSONObject basePlanObj, JSONArray comparePlanObjList) {
        DynamicObject[] baseTasks;
        if (null == basePlanObj || comparePlanObjList == null) {
            return null;
        }
        JSONObject data = new JSONObject();
        Map<Object, JSONObject> tasksMap = new HashMap<Object, JSONObject>(16);
        DynamicObject basePlan = BusinessDataServiceHelper.loadSingle((Object)basePlanObj.get((Object)KEY_ID), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"masterplan"));
        if (basePlan == null) {
            return null;
        }
        DynamicObjectCollection baseVersionEntries = basePlan.getDynamicObjectCollection("taskentity");
        if (baseVersionEntries == null || baseVersionEntries.isEmpty()) {
            return null;
        }
        for (DynamicObject dynamicObject : baseTasks = this.getTasksByEntry(baseVersionEntries)) {
            tasksMap = this.getNewArrayByTask(tasksMap, dynamicObject, false, BigDecimal.ONE.toString());
        }
        HashSet<Object> comparePlanIds = new HashSet<Object>(16);
        for (int j = 0; j < comparePlanObjList.size(); ++j) {
            JSONObject plan = comparePlanObjList.getJSONObject(j);
            if (plan == null) continue;
            comparePlanIds.add(plan.get((Object)KEY_ID));
        }
        DynamicObject[] compareVersions = BusinessDataServiceHelper.load((Object[])comparePlanIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"masterplan"));
        int i = 2;
        for (DynamicObject compareVersion : compareVersions) {
            String columnIndex = String.valueOf(i);
            ++i;
            DynamicObjectCollection compareVersionEntries = compareVersion.getDynamicObjectCollection("taskentity");
            DynamicObject[] compareTasks = this.getTasksByEntry(compareVersionEntries);
            for (DynamicObject baseTask : baseTasks) {
                for (DynamicObject compareTask : compareTasks) {
                    DynamicObject baseSourceTask = baseTask.getDynamicObject("sourcetask");
                    if (baseSourceTask == null) {
                        if (baseTask.getPkValue().equals(compareTask.getPkValue())) {
                            tasksMap = this.getNewArrayByTask(tasksMap, compareTask, false, columnIndex);
                            continue;
                        }
                        tasksMap = this.getNewArrayByTask(tasksMap, compareTask, true, columnIndex);
                        continue;
                    }
                    DynamicObject compareSourceTask = compareTask.getDynamicObject("sourcetask");
                    if (compareSourceTask == null) {
                        if (baseSourceTask.getPkValue().equals(compareTask.getPkValue())) {
                            tasksMap = this.getNewArrayByTask(tasksMap, compareTask, false, columnIndex);
                            continue;
                        }
                        tasksMap = this.getNewArrayByTask(tasksMap, compareTask, true, columnIndex);
                        continue;
                    }
                    tasksMap = baseSourceTask.getPkValue().equals(compareSourceTask.getPkValue()) ? this.getNewArrayByTask(tasksMap, compareTask, false, columnIndex) : this.getNewArrayByTask(tasksMap, compareTask, true, columnIndex);
                }
            }
        }
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<Object, JSONObject> task : tasksMap.entrySet()) {
            jSONArray.add((Object)task.getValue());
        }
        data.put(KEY_TASK, (Object)jSONArray);
        return data;
    }

    private Map<Object, JSONObject> getNewArrayByTask(Map<Object, JSONObject> tasksMap, DynamicObject task, boolean isSpecial, String columnIndex) {
        Date endDate;
        Date startDate;
        JSONObject planstarttime;
        Object taskId = task.getPkValue();
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        Object sourceTaskId = null;
        sourceTaskId = sourceTask != null ? sourceTask.getPkValue() : taskId;
        JSONObject taskJson = null;
        boolean isExist = false;
        if (tasksMap.get(sourceTaskId) != null) {
            taskJson = tasksMap.get(sourceTaskId);
            isExist = true;
        }
        if (!isExist) {
            taskJson = new JSONObject();
            taskJson.put(KEY_SEQ, (Object)task.getInt("taskseq"));
            taskJson.put(KEY_TASKID, (Object)taskId.toString());
            taskJson.put(KEY_SPECIALTASK, (Object)isSpecial);
            taskJson.put(KEY_SOURCETASKID, (Object)sourceTaskId.toString());
            DynamicObject parent = task.getDynamicObject(KEY_PARENT);
            taskJson.put(KEY_PARENT, parent == null ? null : parent.getPkValue().toString());
            taskJson.put(KEY_LEVEL, (Object)task.getInt(KEY_LEVEL));
            taskJson.put(KEY_TASKNAME, (Object)task.getString("name"));
            DynamicObject ctrllevel = task.getDynamicObject("controllevel");
            taskJson.put(KEY_TASKCONTROLLEVEL, ctrllevel == null ? null : ctrllevel.getPkValue().toString());
            DynamicObject tasktype = task.getDynamicObject(KEY_TASKTYPE);
            taskJson.put(KEY_TASKTYPE, tasktype == null ? null : tasktype.getLocaleString("name").getLocaleValue_zh_CN());
            DynamicObject responsibleperson = task.getDynamicObject(KEY_RESPONSIBLEPERSON);
            taskJson.put(KEY_RESPONSIBLEPERSON, responsibleperson == null ? null : responsibleperson.getLocaleString("name").getLocaleValue_zh_CN());
        }
        if ((planstarttime = taskJson.getJSONObject(KEY_STARTTIME)) == null) {
            planstarttime = new JSONObject();
        }
        planstarttime.put(columnIndex, (startDate = task.getDate(KEY_STARTTIME)) == null ? null : this.sdf.format(startDate));
        taskJson.put(KEY_STARTTIME, (Object)planstarttime);
        JSONObject planendtime = taskJson.getJSONObject(KEY_ENDTIME);
        if (planendtime == null) {
            planendtime = new JSONObject();
        }
        planendtime.put(columnIndex, (endDate = task.getDate(KEY_ENDTIME)) == null ? null : this.sdf.format(endDate));
        taskJson.put(KEY_ENDTIME, (Object)planendtime);
        JSONObject absoluteduration = taskJson.getJSONObject(KEY_ABSDURATION);
        if (absoluteduration == null) {
            absoluteduration = new JSONObject();
        }
        absoluteduration.put(columnIndex, (Object)task.getBigDecimal(KEY_ABSDURATION));
        taskJson.put(KEY_ABSDURATION, (Object)absoluteduration);
        tasksMap.put(sourceTaskId, taskJson);
        return tasksMap;
    }

    private DynamicObject[] getTasksByEntry(DynamicObjectCollection entries) {
        Object[] pks = new Object[entries.size()];
        for (int i = 0; i < pks.length; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            String id = entry.getString(KEY_ID);
            pks[i] = Long.parseLong(id);
        }
        return BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)KEY_TASK));
    }

    private void fillTreeList(IDataModel model, JSONArray sameLevelTaskArray, JSONArray allTaskArray, boolean isRoot, int rowIndex) {
        if (sameLevelTaskArray == null || sameLevelTaskArray.isEmpty()) {
            return;
        }
        for (Object taskObj : sameLevelTaskArray) {
            JSONObject absoluteduration;
            JSONObject endTime;
            JSONObject task = (JSONObject)taskObj;
            int rIndex = 0;
            rIndex = isRoot ? model.createNewEntryRow(KEY_TREEENTRYENTITY) : model.insertEntryRow(KEY_TREEENTRYENTITY, rowIndex);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            grid.setCollapse(false);
            grid.getModel().updateCache();
            model.setValue(KEY_TASK, task.get((Object)KEY_TASKID), rIndex);
            JSONObject startTime = task.getJSONObject(KEY_STARTTIME);
            if (startTime != null && !startTime.isEmpty()) {
                for (Object key : startTime.keySet()) {
                    model.setValue(KEY_STARTTIME + (String)key, startTime.get(key), rIndex);
                }
            }
            if ((endTime = task.getJSONObject(KEY_ENDTIME)) != null && !endTime.isEmpty()) {
                Object key;
                key = endTime.keySet().iterator();
                while (key.hasNext()) {
                    String key2 = (String)key.next();
                    model.setValue(KEY_ENDTIME + (String)key2, endTime.get((Object)key2), rIndex);
                }
            }
            if ((absoluteduration = task.getJSONObject(KEY_ABSDURATION)) != null && !absoluteduration.isEmpty()) {
                for (String key : absoluteduration.keySet()) {
                    model.setValue(KEY_ABSDURATION + key, absoluteduration.get((Object)key), rIndex);
                }
            }
            JSONArray sons = new JSONArray();
            for (Object allTaskObj : allTaskArray) {
                JSONObject allTask = (JSONObject)allTaskObj;
                if (!task.getString(KEY_TASKID).equals(allTask.getString(KEY_PARENT))) continue;
                sons.add((Object)allTask);
            }
            if (sons == null || sons.isEmpty()) continue;
            this.fillTreeList(model, sons, allTaskArray, false, rIndex);
        }
    }

    private void showColumn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TREEENTRYENTITY});
        String compareVersions = String.valueOf(this.getModel().getValue(KEY_COMPAREVERSIONS));
        String[] versionArray = compareVersions.split(",");
        for (int i = 1; i <= versionArray.length + 1; ++i) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_STARTTIME + i});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENDTIME + i});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ABSDURATION + i});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TASK});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TASKNAME});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TASKCONTROLLEVEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TASKTYPE});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_RESPONSIBLEPERSON});
    }

    private void hideColumn() {
        for (int i = 1; i <= 5; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_STARTTIME + i});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ENDTIME + i});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ABSDURATION + i});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TASK});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TASKNAME});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TASKCONTROLLEVEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TASKTYPE});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_RESPONSIBLEPERSON});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEENTRYENTITY});
    }

    private List<Object> getTableTitle() {
        ArrayList<Object> titles = new ArrayList<Object>();
        String baseVersion = KEY_VERSION_PREFIX + this.getModel().getValue(KEY_BASEVERSION);
        titles.add(baseVersion);
        String compareVersions = String.valueOf(this.getModel().getValue(KEY_COMPAREVERSIONS));
        String[] versionArray = compareVersions.split(",");
        for (int i = 0; i < 4; ++i) {
            if (i < versionArray.length) {
                titles.add(KEY_VERSION_PREFIX + versionArray[i]);
                continue;
            }
            titles.add("UNNAMED");
        }
        return titles;
    }

    private void configColumnName() {
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        List fieldEdits = treeGrid.getFieldEdits();
        for (int i = 0; i < 5; ++i) {
            FieldEdit planstarttime = (FieldEdit)fieldEdits.get(5 + i);
            FieldEdit planendtime = (FieldEdit)fieldEdits.get(10 + i);
            FieldEdit absoluteduration = (FieldEdit)fieldEdits.get(15 + i);
            LocaleString versionStr = new LocaleString("zh_CN", this.getTableTitle().get(i));
            treeGrid.setColumnProperty(planstarttime.getFieldKey(), "header", (Object)versionStr);
            treeGrid.setColumnProperty(planendtime.getFieldKey(), "header", (Object)versionStr);
            treeGrid.setColumnProperty(absoluteduration.getFieldKey(), "header", (Object)versionStr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        if (returnData.size() >= 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u52fe\u9009\u56db\u4e2a\u5bf9\u6bd4\u7248\u672c\u3002", (String)"PlanCompareAnalysisListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object planTypePk = this.getModel().getValue(KEY_PLANTYPE);
        DynamicObject planType = BusinessDataServiceHelper.loadSingle((Object)planTypePk, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"));
        Object planTypeEnum = planType.get(KEY_PLANTYPE);
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        if (KEY_BASEVERSIONCALLBACK.equals(actionId)) {
            ListSelectedRow row = returnData.get(0);
            Object pk = row.getPrimaryKeyValue();
            DynamicObject plan = null;
            JSONObject planVersion = new JSONObject();
            if (PlanTypeEnum.MAINPLAN.getValue().equals(planTypeEnum)) {
                plan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
                planVersion.put(KEY_ID, plan.getPkValue());
                planVersion.put(KEY_VERSION, (Object)decimalFormat.format(plan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSION, (Object)decimalFormat.format(plan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSIONID, (Object)planVersion);
            } else if (PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeEnum)) {
                plan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
                planVersion.put(KEY_ID, plan.getPkValue());
                planVersion.put(KEY_VERSION, (Object)decimalFormat.format(plan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSION, (Object)decimalFormat.format(plan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSIONID, (Object)planVersion.toString());
            }
            this.getModel().setValue(KEY_COMPAREVERSIONS, null);
            this.getModel().setValue(KEY_COMPAREVERSIONSIDLIST, null);
        } else if (KEY_COMPAREVERSIONSCALLBACK.equals(actionId)) {
            DynamicObject[] plans = null;
            if (PlanTypeEnum.MAINPLAN.getValue().equals(planTypeEnum)) {
                plans = BusinessDataServiceHelper.load((Object[])returnData.getPrimaryKeyValues(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"masterplan"));
            } else if (PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeEnum)) {
                plans = BusinessDataServiceHelper.load((Object[])returnData.getPrimaryKeyValues(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"specialplan"));
            }
            JSONArray planVersions = new JSONArray();
            if (plans != null && plans.length > 0) {
                StringBuilder versions = new StringBuilder();
                for (int i = 0; i < plans.length; ++i) {
                    DynamicObject plan = plans[i];
                    versions.append(decimalFormat.format(plan.get(KEY_VERSION)));
                    if (i != plans.length - 1) {
                        versions.append(',');
                    }
                    JSONObject planVersion = new JSONObject();
                    planVersion.put(KEY_ID, plan.getPkValue());
                    planVersion.put(KEY_VERSION, plan.get(KEY_VERSION));
                    planVersions.add((Object)planVersion);
                }
                this.getModel().setValue(KEY_COMPAREVERSIONS, (Object)versions);
                this.getModel().setValue(KEY_COMPAREVERSIONSIDLIST, (Object)planVersions.toString());
            }
        }
    }

    public void click(EventObject evt) {
        TextEdit source = (TextEdit)evt.getSource();
        String key = source.getProperty().getName();
        DynamicObject project = (DynamicObject)this.getModel().getValue(KEY_PROJECT);
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee", (String)"PlanCompareAnalysisListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object planTypePk = this.getModel().getValue(KEY_PLANTYPE);
        Long planTypeId = 0L;
        if (null != planTypePk) {
            planTypeId = Long.valueOf((String)planTypePk);
        }
        if (planTypePk == null || "".equals(planTypePk.toString().trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7c7b\u578b\u3002", (String)"PlanCompareAnalysisListPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (KEY_BASEVERSION.equals(key)) {
            ListShowParameter listShowParameter = null;
            listShowParameter = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (boolean)false, (int)2);
            QFilter planFilters = new QFilter(KEY_PROJECT, "=", project.getPkValue());
            planFilters.and("majortype", "=", (Object)planTypeId);
            planFilters.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            if (listShowParameter != null) {
                if (planFilters != null) {
                    listShowParameter.getListFilterParameter().getQFilters().add(planFilters);
                }
                CloseCallBack callback = new CloseCallBack((IFormPlugin)this, KEY_BASEVERSIONCALLBACK);
                listShowParameter.setCloseCallBack(callback);
                listShowParameter.setMultiSelect(false);
                listShowParameter.getListFilterParameter().setOrderBy("version desc");
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u57fa\u51c6\u7248\u672c\u3002", (String)"PlanCompareAnalysisListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        } else if (KEY_COMPAREVERSIONS.equals(key)) {
            Object baseVersionId = this.getModel().getValue(KEY_BASEVERSIONID);
            if (baseVersionId == null || "".equals(baseVersionId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u57fa\u51c6\u7248\u672c\u3002", (String)"PlanCompareAnalysisListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            QFilter planFilters = null;
            ListShowParameter listShowParameter = null;
            JSONObject plans = JSONObject.parseObject((String)baseVersionId.toString());
            DynamicObject baseVersion = BusinessDataServiceHelper.loadSingle((Object)plans.get((Object)KEY_ID), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
            if (baseVersion == null) {
                return;
            }
            listShowParameter = this.getMasterPlanF7ShowListForm();
            DynamicObject sourcePlan = baseVersion.getDynamicObject("sourceplan");
            if (sourcePlan == null) {
                planFilters = new QFilter("sourceplan", "=", baseVersion.getPkValue());
            } else {
                planFilters = new QFilter("sourceplan", "=", sourcePlan.getPkValue());
                planFilters.or(KEY_ID, "=", sourcePlan.getPkValue());
            }
            planFilters.and("majortype", "=", (Object)planTypeId);
            planFilters.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            planFilters.and(KEY_VERSION, "!=", (Object)baseVersion.getBigDecimal(KEY_VERSION));
            if (listShowParameter != null) {
                if (planFilters != null) {
                    listShowParameter.getListFilterParameter().getQFilters().add(planFilters);
                }
                CloseCallBack callback = new CloseCallBack((IFormPlugin)this, KEY_COMPAREVERSIONSCALLBACK);
                listShowParameter.setCloseCallBack(callback);
                listShowParameter.setMultiSelect(true);
                listShowParameter.getListFilterParameter().setOrderBy("version desc");
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u5bf9\u6bd4\u7248\u672c", (String)"PlanCompareAnalysisListPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    protected ListShowParameter getMasterPlanF7ShowListForm() {
        return ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplanf7"), (boolean)false, (int)2);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject[] plantypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id,plantypename,plantype", null);
        if (plantypes.length > 0) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (DynamicObject plantype : plantypes) {
                Object planTypeEnum = plantype.get(KEY_PLANTYPE);
                if (!PlanTypeEnum.MAINPLAN.getValue().equals(planTypeEnum) && !PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeEnum)) continue;
                ComboItem item = new ComboItem();
                item.setId(plantype.getPkValue().toString());
                item.setValue(plantype.getPkValue().toString());
                item.setCaption(new LocaleString(plantype.getString("plantypename")));
                items.add(item);
                if (!PlanTypeEnum.MAINPLAN.getValue().equals(planTypeEnum)) continue;
                this.getModel().setValue(KEY_PLANTYPE, plantype.getPkValue());
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_PLANTYPE);
            comboEdit.setComboItems(items);
        }
        this.hideColumn();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String beFirst = this.getPageCache().get("beFirst");
        if (beFirst == null || beFirst.equals("true")) {
            String planId = (String)this.getView().getFormShowParameter().getCustomParam("planId");
            Object sourceOpen = this.getView().getFormShowParameter().getCustomParam("source");
            if ("masterplan".equals(sourceOpen) && null != planId) {
                DynamicObject masterplan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
                this.getModel().setValue(KEY_PROJECT, (Object)masterplan.getDynamicObject(KEY_PROJECT));
                DynamicObject planType = masterplan.getDynamicObject("majortype");
                DecimalFormat decimalFormat = new DecimalFormat("0.0");
                JSONObject planVersion = new JSONObject();
                this.getModel().setValue(KEY_PLANTYPE, planType.getPkValue());
                this.getView().updateView(KEY_PLANTYPE);
                planVersion.put(KEY_ID, masterplan.getPkValue());
                planVersion.put(KEY_VERSION, (Object)decimalFormat.format(masterplan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSION, (Object)decimalFormat.format(masterplan.get(KEY_VERSION)));
                this.getModel().setValue(KEY_BASEVERSIONID, (Object)planVersion);
                this.getModel().setValue(KEY_COMPAREVERSIONS, null);
                this.getModel().setValue(KEY_COMPAREVERSIONSIDLIST, null);
                this.getView().updateView(KEY_PROJECT);
                this.getView().updateView(KEY_BASEVERSION);
                this.getView().updateView(KEY_BASEVERSIONID);
            }
            this.getPageCache().put("beFirst", "false");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_PROJECT.equals(key)) {
            this.getModel().setValue(KEY_BASEVERSION, null);
            this.getModel().setValue(KEY_BASEVERSIONID, null);
            this.getModel().setValue(KEY_COMPAREVERSIONS, null);
            this.getModel().setValue(KEY_COMPAREVERSIONSIDLIST, null);
        }
        if (KEY_PLANTYPE.equals(key)) {
            this.getModel().setValue(KEY_BASEVERSION, null);
            this.getModel().setValue(KEY_BASEVERSIONID, null);
            this.getModel().setValue(KEY_COMPAREVERSIONS, null);
            this.getModel().setValue(KEY_COMPAREVERSIONSIDLIST, null);
        }
    }

    private void setCellTextColor(TreeEntryGrid grid, int rowIndex, String fieldKey, String color) {
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(rowIndex);
        statusStyle.setFieldKey(fieldKey);
        statusStyle.setForeColor(color);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    private void initStyleTreeEntity(TreeEntryGrid grid) {
        if (grid == null) {
            return;
        }
        List<Object> columns = this.getTableTitle();
        int size = columns.size();
        IDataModel model = grid.getModel();
        DynamicObjectCollection rows = model.getEntryEntity(KEY_TREEENTRYENTITY);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            Date start1 = row.getDate(KEY_STARTTIME + BigDecimal.ONE);
            for (int j = 2; j <= size; ++j) {
                Date start2 = row.getDate(KEY_STARTTIME + j);
                if (start1 == null || start2 == null) continue;
                String color = "black";
                if (start2.before(start1)) {
                    color = "green";
                } else if (start2.after(start1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_STARTTIME + j, color);
            }
            Date end1 = row.getDate(KEY_ENDTIME + BigDecimal.ONE);
            for (int j = 2; j <= size; ++j) {
                Date end2 = row.getDate(KEY_ENDTIME + j);
                if (end1 == null || end2 == null) continue;
                String color = "black";
                if (end2.before(end1)) {
                    color = "green";
                } else if (end2.after(end1)) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_ENDTIME + j, color);
            }
            BigDecimal abs1 = row.getBigDecimal(KEY_ABSDURATION + BigDecimal.ONE);
            for (int j = 2; j <= size; ++j) {
                BigDecimal abs2 = row.getBigDecimal(KEY_ABSDURATION + j);
                if (abs1 == null || abs2 == null || abs1.compareTo(BigDecimal.ZERO) == 0 || abs2.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal dvalue = abs2.subtract(abs1);
                String color = "black";
                if (dvalue.compareTo(BigDecimal.ZERO) < 0) {
                    color = "green";
                } else if (dvalue.compareTo(BigDecimal.ZERO) > 0) {
                    color = "red";
                }
                this.setCellTextColor(grid, i, KEY_ABSDURATION + j, color);
            }
        }
    }
}

