/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.business.utils.task.PlanTaskPOIHelper;
import kd.pccs.placs.business.utils.task.PlanTemplateImpAndExpUtil;
import kd.pccs.placs.business.utils.task.PlanTplUtil;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;
import org.apache.commons.collections.CollectionUtils;

public class PlanTemplateEditPlugin
extends AbstractPlacsBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String NEW_TASK_CONFIRM = "newTaskConfirm";
    private static final String DELETE_TASK_ENTRY = "deletetaskentry";
    private static final String DELETE_TASK_CONFIRM = "deletetaskconfirm";
    private static final String TASK_ENTRY_TRANSACTION_TYPE = "transactiontype";
    private static final String TASK_ENTRY_TRANSACTION_TYPE_NUMBER = "number";
    private static final String IS_LEAF = "isleaf";
    private static String[] PLANTYPEARRAY = new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.DEPTPLAN.getValue(), PlanTypeEnum.PRIVATEPLAN.getValue(), PlanTypeEnum.DEPTFENJIEPLAN.getValue()};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("taskentry");
        taskEntryGrid.addRowClickListener((RowClickEventListener)this);
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("pretask");
        payeebanknum.addButtonClickListener((ClickListener)this);
        BasedataEdit specTypeEdit = (BasedataEdit)this.getControl("spectype");
        specTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.projectKindAddBerforeF7SelectListener();
    }

    protected void projectKindAddBerforeF7SelectListener() {
        BasedataEdit projectKindEdit = (BasedataEdit)this.getControl("projectkind");
        projectKindEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"upgrade", (CharSequence)operateKey)) {
            this.upGrade();
            this.setIsLeaf();
            this.sumToParent();
        } else if (StringUtils.equals((CharSequence)"downgrade", (CharSequence)operateKey)) {
            this.downGrade();
            this.setIsLeaf();
            this.sumToParent();
        } else if (StringUtils.equals((CharSequence)"insertplantpentry", (CharSequence)operateKey)) {
            this.verifyTaskIsPre(args);
        } else if (StringUtils.equals((CharSequence)"inserttaskentry", (CharSequence)operateKey)) {
            this.setEntryCurrentRowIsNotLeaf();
        } else if (StringUtils.equals((CharSequence)"excelimport", (CharSequence)operateKey)) {
            this.excelImport();
        } else if (StringUtils.equals((CharSequence)"importprotask", (CharSequence)operateKey)) {
            this.importProTask("proplan");
        } else if (StringUtils.equals((CharSequence)"importothertemp", (CharSequence)operateKey)) {
            this.importProTask("othertpl");
        } else if (StringUtils.equals((CharSequence)DELETE_TASK_ENTRY, (CharSequence)operateKey)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentry");
            int[] selRows = grid.getSelectRows();
            if (null == selRows || selRows.length <= 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"PlanTemplateEditPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"PlanTemplateEditPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
            args.setCancel(true);
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey) && !this.checkExistResultDoc()) {
            args.setCancel(true);
        }
    }

    protected boolean checkExistResultDoc() {
        DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentry");
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return true;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            DynamicObjectCollection resultDocCollection;
            if (!this.isAchievementNode((DynamicObject)tasks.get(i)) || !CollectionUtils.isEmpty((Collection)(resultDocCollection = this.getModel().getEntryEntity("taskresultdocdetail")))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u7b2c%s\u884c\uff1a\u4e1a\u52a1\u7c7b\u578b\u5305\u542b\u201c\u6210\u679c\u7c7b\u578b\u201d\uff0c\u672a\u5f55\u5165\u5bf9\u5e94\u7684\u201c\u6210\u679c\u660e\u7ec6\u201d\u3002", (String)"PlanTemplateEditPlugin_24", (String)"pccs-placs-formplugin", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    protected boolean isAchievementNode(DynamicObject task) {
        boolean achievementNode = false;
        DynamicObjectCollection transactionTypeList = task.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
        for (DynamicObject txType : transactionTypeList) {
            if (txType == null || txType.getDynamicObject(1) == null || !Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.getDynamicObject(1).getString(TASK_ENTRY_TRANSACTION_TYPE_NUMBER))) continue;
            achievementNode = true;
            break;
        }
        return achievementNode;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        PlanTemplateImpAndExpUtil util = this.getUtil();
        switch (operateKey) {
            case "insertplantpentry": {
                this.rebuildTreeStructure();
                break;
            }
            case "exportmodel": {
                util.exportDeptModel(this.getView(), true, "taskentry");
                break;
            }
            case "importtask": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"PlanTemplateEditPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                int rowCount = this.getModel().getEntryRowCount("taskentry");
                if (rowCount > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5bfc\u5165\u5c06\u4f1a\u5220\u9664\u73b0\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PlanTemplateEditPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importtask"));
                    break;
                }
                this.importTaskOperation();
                break;
            }
        }
    }

    protected PlanTemplateImpAndExpUtil getUtil() {
        return new PlanTemplateImpAndExpUtil(this.getView());
    }

    protected void setEntryCurrentRowIsNotLeaf() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
        this.getModel().setValue(IS_LEAF, (Object)"0", rowIndex);
    }

    protected void newTaskEntry(BeforeDoOperationEventArgs args) {
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)"spectype", (CharSequence)propName)) {
            this.beforeSpectypeF7Select(arg0);
        } else if (StringUtils.equals((CharSequence)"projectkind", (CharSequence)propName)) {
            arg0.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectProjectKind"));
        }
    }

    protected void beforeSpectypeF7Select(BeforeF7SelectEvent arg0) {
        QFilter notSysFilter = new QFilter("plantype", "not in", (Object)PLANTYPEARRAY);
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        this.projectKindBySpectypeF7Select(qFilters);
        qFilters.add(notSysFilter);
    }

    protected void projectKindBySpectypeF7Select(List<QFilter> qFilters) {
        Object projectKindId = this.getModel().getValue("projectkind_id");
        QFilter kindFilter = new QFilter("group", "=", projectKindId).or(new QFilter("group", "=", (Object)0L));
        qFilters.add(kindFilter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateTaskEntryPreTaskId();
        this.setPreAndVersionAndName();
        EntryGrid grid = (EntryGrid)this.getControl("taskentry");
        grid.setCollapse(false);
    }

    protected void updateTaskEntryPreTaskId() {
        Object prePlanTempId = this.getView().getFormShowParameter().getCustomParam("prePlanTempId");
        if (prePlanTempId != null) {
            DynamicObject prePlanTpl = BusinessDataServiceHelper.loadSingle((Object)prePlanTempId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
            DynamicObjectCollection preTaskEntryCol = prePlanTpl.getDynamicObjectCollection("taskentry");
            if (preTaskEntryCol.isEmpty()) {
                return;
            }
            HashMap<Long, Integer> idSeqMap = new HashMap<Long, Integer>(16);
            for (int seq = 0; seq < preTaskEntryCol.size(); ++seq) {
                idSeqMap.put((Long)((DynamicObject)preTaskEntryCol.get(seq)).getPkValue(), seq);
            }
            DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
            for (DynamicObject taskEntry : taskEntryCol) {
                long preTaskId = taskEntry.getLong("pretaskid");
                if (preTaskId == 0L) continue;
                DynamicObject newTask = (DynamicObject)taskEntryCol.get(((Integer)idSeqMap.get(preTaskId)).intValue());
                taskEntry.set("pretaskid", newTask.getPkValue());
            }
            this.getModel().updateEntryCache(taskEntryCol);
        }
    }

    protected void setPreAndVersionAndName() {
        Object prePlanTempId = this.getView().getFormShowParameter().getCustomParam("prePlanTempId");
        if (prePlanTempId != null) {
            this.getModel().setValue("pretemplate", prePlanTempId);
            DynamicObject preTemplate = this.getModel().getDataEntity().getDynamicObject("pretemplate");
            BigDecimal vision = preTemplate.getBigDecimal("version");
            BigDecimal newVersion = vision.add(BigDecimal.ONE);
            this.getModel().setValue("version", (Object)newVersion);
            String name = preTemplate.getString("name");
            StringBuilder newName = new StringBuilder(name);
            int newVerValue = newVersion.intValue();
            if (newVerValue > 2 && name.endsWith("(" + vision.intValue() + ".0)")) {
                int length = newName.length();
                newName.replace(length - 4, length - 3, newVerValue + "");
            } else {
                newName.append("(").append(newVerValue).append(".0)");
            }
            this.getModel().setValue("name", (Object)newName.toString());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object transactiontype = this.getModel().getValue(TASK_ENTRY_TRANSACTION_TYPE, 0);
        this.hideResultdocapByTransactionType(transactiontype);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)"projectkind", (CharSequence)propName)) {
            Object newValue = changeData.getNewValue();
            if (newValue != null) {
                DynamicObject kind = (DynamicObject)newValue;
                Object kindPkValue = kind.getPkValue();
                this.checkProKindIsLeaf(kindPkValue);
            }
            this.projectKindChanged(e);
        } else if (StringUtils.equals((CharSequence)TASK_ENTRY_TRANSACTION_TYPE, (CharSequence)propName)) {
            this.transactiontypeNodeChange(changeData);
        } else if (StringUtils.equals((CharSequence)"taskname", (CharSequence)propName)) {
            this.updateReferTaskPreTaskName(changeData);
        } else if (StringUtils.equals((CharSequence)"absoluteduration", (CharSequence)propName)) {
            this.sumToParent();
        } else if (StringUtils.equals((CharSequence)"pretask", (CharSequence)propName)) {
            this.preTaskChanged(changeData);
        } else if (StringUtils.equals((CharSequence)"responsiblepost", (CharSequence)propName)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject associatePost = (DynamicObject)this.getModel().getValue("associatepost");
            if (associatePost != null && newValue != null && newValue.getPkValue().toString().equals(associatePost.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d23\u4efb\u5c97\u4f4d\u548c\u534f\u529e\u5c97\u4f4d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"PlanTemplateEditPlugin_25", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("responsiblepost", (Object)oldValue, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"associatepost", (CharSequence)propName)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject responsiblePost = (DynamicObject)this.getModel().getValue("responsiblepost");
            if (responsiblePost != null && newValue != null && newValue.getPkValue().toString().equals(responsiblePost.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d23\u4efb\u5c97\u4f4d\u548c\u534f\u529e\u5c97\u4f4d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"PlanTemplateEditPlugin_25", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("associatepost", (Object)oldValue, rowIndex);
            }
        }
    }

    private void hideResultdocapByTransactionType(Object transactionType) {
        boolean showResultDoc = false;
        if (null != transactionType) {
            DynamicObjectCollection transactionTypeCollections = (DynamicObjectCollection)transactionType;
            for (DynamicObject tx : transactionTypeCollections) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASK_ENTRY_TRANSACTION_TYPE));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get(TASK_ENTRY_TRANSACTION_TYPE_NUMBER))) continue;
                showResultDoc = true;
            }
        }
        if (showResultDoc) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"resultdocap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"resultdocap"});
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskresultdocdetail");
            if (entryEntity != null && !entryEntity.isEmpty()) {
                this.getModel().deleteEntryData("taskresultdocdetail");
            }
        }
    }

    protected void transactiontypeNodeChange(ChangeData changeData) {
        Object transactionType = changeData.getNewValue();
        this.hideResultdocapByTransactionType(transactionType);
    }

    protected void preTaskChanged(ChangeData changeData) {
        String newValue = (String)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.getModel().setValue("pretaskid", (Object)0, rowIndex);
            return;
        }
        DynamicObject currentTask = this.getModel().getEntryRowEntity("taskentry", rowIndex);
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        HashSet idSet = new HashSet();
        PlanTplUtil.getAfterTaskIdSet((List)taskEntryCol, idSet, (DynamicObject)currentTask);
        PlanTplUtil.getParentIdSet((List)taskEntryCol, idSet, (DynamicObject)currentTask);
        taskEntryCol.remove(rowIndex);
        List afterFilterTaskList = taskEntryCol.stream().filter(task -> !idSet.contains(task.getPkValue())).collect(Collectors.toList());
        for (int i = 0; i < afterFilterTaskList.size(); ++i) {
            DynamicObject afterFilterTask = (DynamicObject)afterFilterTaskList.get(i);
            String taskName = afterFilterTask.getString("taskname");
            if (!StringUtils.equals((CharSequence)newValue, (CharSequence)taskName)) continue;
            this.getModel().setValue("pretaskid", afterFilterTask.get("id"), rowIndex);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u524d\u7f6e\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5b58\u5728\u76f8\u4e92\u5f15\u7528\u7684\u5173\u7cfb\u3002", (String)"PlanTemplateEditPlugin_26", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("pretask", (Object)"", rowIndex);
    }

    protected void achievementNodeChange(ChangeData changeData) {
        Object achieveNode = changeData.getNewValue();
        if (!((Boolean)achieveNode).booleanValue()) {
            this.getModel().deleteEntryData("taskresultdocdetail");
            this.getView().setVisible(Boolean.FALSE, new String[]{"resultdocap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"resultdocap"});
        }
    }

    protected void projectKindChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet = e.getChangeSet();
        DynamicObject oldProjectKind = (DynamicObject)valueSet[0].getOldValue();
        String oldProjectKindId = "";
        if (oldProjectKind != null) {
            oldProjectKindId = oldProjectKind.getString("id");
        }
        this.getPageCache().put("oldProjectKindId", oldProjectKindId);
        int rowCount = this.getModel().getEntryRowCount("taskentry");
        if (rowCount > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5206\u7c7b\u4f1a\u6e05\u7a7a\u6a21\u677f\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PlanTemplateEditPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switchProjectKind"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"switchProjectKind", (CharSequence)callBackId)) {
            this.switchProjectKindConfirmCallBack(result);
        } else if (NEW_TASK_CONFIRM.equalsIgnoreCase(callBackId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentry");
            int[] selRows = grid.getSelectRows();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("taskentry", selectRow);
                    String pidPkValue = entry.getString("pid");
                    deletepks.add(pidPkValue);
                }
                this.deletePreTask(deletepks);
            } else {
                this.getModel().deleteEntryRows("taskentry", selRows);
            }
            this.getModel().updateCache();
            this.rebuildTreeStructure();
            this.getView().updateView("taskentry");
        } else if (StringUtils.equals((CharSequence)DELETE_TASK_CONFIRM, (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentry");
                int[] selRows = grid.getSelectRows();
                this.getModel().deleteEntryRows("taskentry", selRows);
                this.setIsGroupNodeWhenDel();
                this.setIsLeaf();
                this.sumToParent();
                Object value = this.getModel().getValue("achievementnode", 0);
                Boolean visible = value == null ? Boolean.FALSE : ((Boolean)value != false ? Boolean.TRUE : Boolean.FALSE);
                this.getView().setVisible(visible, new String[]{"resultdocap"});
                this.getModel().updateCache();
            }
        } else if ("importtask".equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.importTaskOperation();
        }
    }

    protected void importTaskOperation() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"entryimpdialog"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"entryimpdialog")));
        this.getView().showForm(importExcelFormParameter);
    }

    protected void deletePreTask(Set<String> deleteTasks) {
        DynamicObjectCollection taskEntity = this.getModel().getEntryEntity("taskentry");
        for (DynamicObject task : taskEntity) {
            String pretaskid;
            Object preTaskid = task.get("pretaskid");
            if (null == preTaskid || !deleteTasks.contains(pretaskid = preTaskid.toString())) continue;
            task.set("pretask", null);
            task.set("pretaskid", null);
            task.set("logical", null);
        }
    }

    protected void switchProjectKindConfirmCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().deleteEntryData("taskentry");
        } else {
            String oldProjectKindId = this.getPageCache().get("oldProjectKindId");
            this.getModel().beginInit();
            this.getModel().setValue("projectkind", (Object)oldProjectKindId);
            this.getModel().endInit();
            this.getView().updateView("projectkind");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"plantplpretask", (CharSequence)actionId)) {
            this.planTplPreTaskCloseCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"excelimport", (CharSequence)actionId)) {
            this.importFromExcel(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"proplan", (CharSequence)actionId)) {
            this.proPlanCloseCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"othertpl", (CharSequence)actionId)) {
            this.otherPlanCloseCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"selectProjectKind", (CharSequence)actionId)) {
            this.selectProjectKindCloseCallBack(closedCallBackEvent);
        } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"entryimpdialog").equalsIgnoreCase(actionId) && StringUtils.isNotBlank((Object)(returnData = closedCallBackEvent.getReturnData()))) {
            DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
            boolean showResultDoc = false;
            for (DynamicObject task : tasks) {
                DynamicObjectCollection transactionType = task.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
                if (null != transactionType) {
                    for (DynamicObject tx : transactionType) {
                        Long baseDataId = tx.getLong("fbasedataid_id");
                        DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASK_ENTRY_TRANSACTION_TYPE));
                        if (transactionType.size() >= 2 || Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get(TASK_ENTRY_TRANSACTION_TYPE_NUMBER)) || task.getDynamicObjectCollection("taskresultdocdetail") == null || task.getDynamicObjectCollection("taskresultdocdetail").size() <= 0) continue;
                        showResultDoc = true;
                    }
                    continue;
                }
                if (transactionType != null || task.getDynamicObjectCollection("taskresultdocdetail") == null || task.getDynamicObjectCollection("taskresultdocdetail").size() <= 0) continue;
                showResultDoc = true;
            }
            if (showResultDoc) {
                throw new KDBizException(ResManager.loadKDString((String)"Excel\u6587\u4ef6\u4e2d\u53ea\u6709\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u679c\u201d\u7684\u4efb\u52a1\uff0c\u624d\u80fd\u4e0a\u4f20\u201c\u6210\u679c\u6587\u6863\u201d\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"PlanTemplateEditPlugin_27", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            this.getModel().deleteEntryData("taskentry");
            this.getModel().updateCache();
            this.getModel().updateEntryCache(tasks);
            this.getView().updateView();
            this.getView().invokeOperation("save");
            ArrayList<String> pretaskNameList = new ArrayList<String>();
            for (int i = 0; i < tasks.size(); ++i) {
                if (!StringUtils.isNotBlank((CharSequence)((DynamicObject)tasks.get(i)).getString("pretask"))) continue;
                pretaskNameList.add(((DynamicObject)tasks.get(i)).getString("pretask"));
                for (DynamicObject task1 : tasks) {
                    if (!((DynamicObject)tasks.get(i)).get("pretask").equals(task1.getString("taskname"))) continue;
                    this.getModel().setValue("pretaskid", task1.get("id"), i);
                    pretaskNameList.remove(((DynamicObject)tasks.get(i)).getString("pretask"));
                }
            }
            if (pretaskNameList.size() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"PlanTemplateEditPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ((Object)pretaskNameList).toString()));
            }
            TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentry");
            entryTree.setCollapse(false);
        }
        this.sumToParent();
    }

    protected void selectProjectKindCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnDataCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnDataCol != null && returnDataCol.size() > 0) {
            Object primaryKeyValue = returnDataCol.get(0).getPrimaryKeyValue();
            this.checkProKindIsLeaf(primaryKeyValue);
            this.getModel().setValue("projectkind", primaryKeyValue);
        }
    }

    protected void checkProKindIsLeaf(Object primaryKeyValue) {
        QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
        qFilter.and(new QFilter(IS_LEAF, "=", (Object)"1"));
        boolean isLeaf = QueryServiceHelper.exists((String)"bd_projectkind", (QFilter[])new QFilter[]{qFilter});
        if (!isLeaf) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u8282\u70b9\u3002", (String)"PlanTemplateEditPlugin_29", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void otherPlanCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof HashMap) {
            HashMap resultMap = (HashMap)returnData;
            ArrayList entryRowList = (ArrayList)resultMap.get("entryRowList");
            Object billId = resultMap.get("billId");
            DynamicObject planTpl = BusinessDataServiceHelper.loadSingle(billId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
            Object otherPlanProjectKindId = planTpl.get("projectkind_id");
            Object thisPlanProjectKindId = this.getModel().getValue("projectkind_id");
            boolean kindEqual = otherPlanProjectKindId.equals(thisPlanProjectKindId);
            DynamicObjectCollection planTplTaskEntryCol = planTpl.getDynamicObjectCollection("taskentry");
            HashMap<Object, DynamicObject> entryIdRowMap = new HashMap<Object, DynamicObject>(16);
            for (DynamicObject dynamicObject : planTplTaskEntryCol) {
                entryIdRowMap.put(dynamicObject.getPkValue(), dynamicObject);
            }
            HashMap<Object, Long> entryIdMap = new HashMap<Object, Long>(16);
            HashSet pidSet = new HashSet(16);
            ORM orm = ORM.create();
            DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
            DynamicObjectType taskEntryDt = taskEntryCol.getDynamicObjectType();
            long[] newEntryIds = orm.genLongIds((IDataEntityType)taskEntryDt, entryRowList.size());
            int index = 0;
            for (DynamicObject entryRow : entryRowList) {
                Long newEntryId = newEntryIds[index++];
                entryIdMap.put(entryRow.getPkValue(), newEntryId);
            }
            for (DynamicObject entryRow : entryRowList) {
                pidSet.add(entryIdMap.get(entryRow.get("pid")));
            }
            for (DynamicObject entryRow : entryRowList) {
                boolean containsPreTask;
                DynamicObject taskEntry = new DynamicObject(taskEntryDt);
                taskEntry.set("id", entryIdMap.get(entryRow.getPkValue()));
                taskEntry.set("pid", entryIdMap.get(entryRow.get("pid")));
                if (pidSet.contains(entryIdMap.get(entryRow.getPkValue()))) {
                    taskEntry.set(IS_LEAF, (Object)"0");
                }
                DynamicObject entryRowEntity = (DynamicObject)entryIdRowMap.get(entryRow.getPkValue());
                taskEntry.set("taskname", entryRowEntity.get("taskname"));
                taskEntry.set("controllevel", entryRowEntity.get("controllevel"));
                if (kindEqual) {
                    taskEntry.set("spectype", entryRowEntity.get("spectype"));
                }
                taskEntry.set("tasktype", entryRowEntity.get("tasktype"));
                taskEntry.set("absoluteduration", entryRowEntity.get("absoluteduration"));
                taskEntry.set("logical", entryRowEntity.get("logical"));
                taskEntry.set("relativeduration", entryRowEntity.get("relativeduration"));
                DynamicObjectCollection oldCol = entryRowEntity.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
                DynamicObjectCollection transactionTypeCol = taskEntry.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
                DynamicObjectType type = transactionTypeCol.getDynamicObjectType();
                for (int i = 0; i < oldCol.size(); ++i) {
                    DynamicObject tx = (DynamicObject)oldCol.get(i);
                    DynamicObject newtx = new DynamicObject(type);
                    newtx.set("fbasedataid", tx.get("fbasedataid"));
                    transactionTypeCol.add((Object)newtx);
                }
                Object preTaskId = entryRowEntity.get("pretaskid");
                if (preTaskId != null && (containsPreTask = entryIdMap.containsKey(preTaskId))) {
                    taskEntry.set("pretaskid", entryIdMap.get(preTaskId));
                    taskEntry.set("pretask", entryRowEntity.get("pretask"));
                }
                DynamicObjectCollection relevantDocCol = taskEntry.getDynamicObjectCollection("relevantdoc");
                DynamicObjectType relevantDocDt = relevantDocCol.getDynamicObjectType();
                DynamicObjectCollection taskReferDocCol = entryRowEntity.getDynamicObjectCollection("relevantdoc");
                for (DynamicObject taskReferDoc : taskReferDocCol) {
                    DynamicObject attFile = new DynamicObject(relevantDocDt);
                    DynamicObject relevantFile = taskReferDoc.getDynamicObject("fbasedataid");
                    attFile.set("fbasedataid", (Object)relevantFile);
                    relevantDocCol.add((Object)attFile);
                }
                DynamicObjectCollection taskResultCol = entryRowEntity.getDynamicObjectCollection("taskresultdocdetail");
                DynamicObjectCollection thisTaskResultCol = taskEntry.getDynamicObjectCollection("taskresultdocdetail");
                DynamicObjectType thisTaskResultDt = thisTaskResultCol.getDynamicObjectType();
                for (DynamicObject taskResult : taskResultCol) {
                    DynamicObject thisTaskResult = new DynamicObject(thisTaskResultDt);
                    thisTaskResult.set("resultname", taskResult.get("resultname"));
                    thisTaskResult.set("force", taskResult.get("force"));
                    thisTaskResult.set("frequency", taskResult.get("frequency"));
                    thisTaskResult.set("resultdescription", taskResult.get("resultdescription"));
                    thisTaskResultCol.add((Object)thisTaskResult);
                }
                taskEntryCol.add((Object)taskEntry);
            }
            this.getModel().updateEntryCache(taskEntryCol);
            this.getView().updateView("taskentry");
            EntryGrid taskEntry = (EntryGrid)this.getControl("taskentry");
            taskEntry.setCollapse(false);
            Object value = this.getModel().getValue("achievementnode", 0);
            if (value != null) {
                this.getView().setVisible((Boolean)value, new String[]{"resultdocap"});
            }
        }
    }

    protected void proPlanCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof HashMap) {
            HashMap resultMap = (HashMap)returnData;
            ArrayList entryRowList = (ArrayList)resultMap.get("entryRowList");
            HashMap<Object, Long> entryIdMap = new HashMap<Object, Long>(16);
            HashSet pidSet = new HashSet(16);
            ORM orm = ORM.create();
            DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
            DynamicObjectType taskEntryDt = taskEntryCol.getDynamicObjectType();
            long[] newEntryIds = orm.genLongIds((IDataEntityType)taskEntryDt, entryRowList.size());
            int index = 0;
            for (DynamicObject entryRow : entryRowList) {
                Long newEntryId = newEntryIds[index++];
                entryIdMap.put(entryRow.getPkValue(), newEntryId);
            }
            for (DynamicObject entryRow : entryRowList) {
                pidSet.add(entryIdMap.get(entryRow.get("pid")));
            }
            for (DynamicObject entryRow : entryRowList) {
                boolean containsPreTask;
                DynamicObject taskEntry = new DynamicObject(taskEntryDt);
                taskEntry.set("id", entryIdMap.get(entryRow.getPkValue()));
                taskEntry.set("pid", entryIdMap.get(entryRow.get("pid")));
                if (pidSet.contains(entryIdMap.get(entryRow.getPkValue()))) {
                    taskEntry.set(IS_LEAF, (Object)"0");
                }
                Object taskId = entryRow.getPkValue();
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                taskEntry.set("taskname", (Object)task.getString("name"));
                taskEntry.set("controllevel", task.get("controllevel"));
                taskEntry.set("spectype", task.get("majortype"));
                taskEntry.set("tasktype", task.get("tasktype"));
                taskEntry.set("absoluteduration", task.get("absoluteduration"));
                taskEntry.set("logical", task.get("logical"));
                taskEntry.set("relativeduration", task.get("relativeduration"));
                DynamicObjectCollection oldCol = task.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
                DynamicObjectCollection transactionTypeCol = taskEntry.getDynamicObjectCollection(TASK_ENTRY_TRANSACTION_TYPE);
                DynamicObjectType type = transactionTypeCol.getDynamicObjectType();
                for (int i = 0; i < oldCol.size(); ++i) {
                    DynamicObject tx = (DynamicObject)oldCol.get(i);
                    DynamicObject newtx = new DynamicObject(type);
                    newtx.set("fbasedataid", tx.get("fbasedataid"));
                    transactionTypeCol.add((Object)newtx);
                }
                DynamicObject preTask = task.getDynamicObject("pretask");
                if (preTask != null && (containsPreTask = entryIdMap.containsKey(preTask.getPkValue()))) {
                    taskEntry.set("pretaskid", entryIdMap.get(preTask.getPkValue()));
                    taskEntry.set("pretask", (Object)preTask.getString("name"));
                }
                DynamicObjectCollection relevantDocCol = taskEntry.getDynamicObjectCollection("relevantdoc");
                DynamicObjectType relevantDocDt = relevantDocCol.getDynamicObjectType();
                DynamicObjectCollection taskReferDocCol = task.getDynamicObjectCollection("taskreferdocentry");
                for (DynamicObject taskReferDoc : taskReferDocCol) {
                    DynamicObject attFile = new DynamicObject(relevantDocDt);
                    DynamicObjectCollection referDocCol = taskReferDoc.getDynamicObjectCollection("attachment");
                    for (DynamicObject referFile : referDocCol) {
                        DynamicObject relevantFile = referFile.getDynamicObject("fbasedataid");
                        relevantFile.set("description", (Object)taskReferDoc.getString("description"));
                        attFile.set("fbasedataid", (Object)relevantFile);
                    }
                    relevantDocCol.add((Object)attFile);
                }
                DynamicObjectCollection taskResultCol = task.getDynamicObjectCollection("taskresultdocentry");
                DynamicObjectCollection thisTaskResultCol = taskEntry.getDynamicObjectCollection("taskresultdocdetail");
                DynamicObjectType thisTaskResultDt = thisTaskResultCol.getDynamicObjectType();
                for (DynamicObject taskResult : taskResultCol) {
                    DynamicObject thisTaskResult = new DynamicObject(thisTaskResultDt);
                    thisTaskResult.set("resultname", taskResult.get("resultname"));
                    thisTaskResult.set("force", taskResult.get("force"));
                    thisTaskResult.set("frequency", taskResult.get("frequency"));
                    thisTaskResult.set("resultdescription", taskResult.get("resultdescription"));
                    thisTaskResultCol.add((Object)thisTaskResult);
                }
                taskEntryCol.add((Object)taskEntry);
            }
            this.getModel().updateEntryCache(taskEntryCol);
            this.getView().updateView("taskentry");
            EntryGrid taskEntry = (EntryGrid)this.getControl("taskentry");
            taskEntry.setCollapse(false);
        }
    }

    protected void planTplPreTaskCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof DynamicObject) {
            DynamicObject preTask = (DynamicObject)returnData;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
            this.getModel().setValue("pretaskid", preTask.get("taskentryid"), rowIndex);
            this.getModel().setValue("pretask", preTask.get("taskname"), rowIndex);
        }
    }

    public static String[] getExcelColumnKey() {
        return new String[]{"taskname", "controllevel", "spectype", "tasktype", "absoluteduration", "achievementnode", "pretask", "logical", "parent", "relativeduration"};
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (StringUtils.equals((CharSequence)"pretask", (CharSequence)key)) {
            this.showSelectPreTaskForm();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if (StringUtils.equals((CharSequence)"taskentry", (CharSequence)entryKey)) {
            Object transactiontype = this.getModel().getValue(TASK_ENTRY_TRANSACTION_TYPE, rowIndex);
            this.hideResultdocapByTransactionType(transactiontype);
        }
    }

    protected boolean checkProjectKindInput(BeforeDoOperationEventArgs args) {
        DynamicObject projectKind = this.getModel().getDataEntity().getDynamicObject("projectkind");
        if (projectKind == null) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u5206\u7c7b\u3002", (String)"PlanTemplateEditPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void excelImport() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplateimport"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object projectKindId = this.getModel().getValue("projectkind_id");
        importExcelFormParameter.getCustomParams().put("projectKindId", projectKindId);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack(this.getCloseCallBackPluginName("thisplugin"), "excelimport"));
        this.getView().showForm(importExcelFormParameter);
    }

    protected void importProTask(String importType) {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantplimporttask"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack(this.getCloseCallBackPluginName("thisplugin"), importType));
        importExcelFormParameter.getCustomParams().put("importType", importType);
        Object projectKindId = this.getModel().getValue("projectkind_id");
        importExcelFormParameter.getCustomParams().put("projectKindId", projectKindId);
        if (StringUtils.equals((CharSequence)"othertpl", (CharSequence)importType)) {
            importExcelFormParameter.setCaption(ResManager.loadKDString((String)"\u5f15\u5165\u5176\u4ed6\u6a21\u677f\u4efb\u52a1", (String)"PlanTemplateEditPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(importExcelFormParameter);
    }

    protected void setIsGroupNodeWhenDel() {
        this.getModel().updateCache();
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        HashSet<String> parentSet = new HashSet<String>(16);
        for (DynamicObject taskEntry : taskEntryCol) {
            parentSet.add(taskEntry.getString("pid"));
        }
        for (DynamicObject taskEntry : taskEntryCol) {
            if (parentSet.contains(taskEntry.getPkValue())) continue;
            taskEntry.set("isGroupNode", (Object)Boolean.FALSE);
        }
        this.getModel().updateEntryCache(taskEntryCol);
        this.getView().updateView("taskentry");
    }

    protected void verifyTaskIsPre(BeforeDoOperationEventArgs args) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentry");
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length == 0) {
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection taskEntrys = this.getModel().getEntryEntity("taskentry");
        Set preTaskId = taskEntrys.stream().filter(task -> StringUtils.isNotBlank((Object)task.get("pretask"))).map(task -> task.get("pretaskid").toString()).collect(Collectors.toSet());
        if (preTaskId.isEmpty()) {
            return;
        }
        DynamicObject currentEntry = this.getModel().getEntryRowEntity("taskentry", selRows[0]);
        if (preTaskId.contains(currentEntry.getPkValue().toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u4f5c\u4e3a\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\uff0c\u82e5\u65b0\u589e\u5b50\u7ea7\uff0c\u4f1a\u6e05\u9664\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PlanTemplateEditPlugin_30", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(NEW_TASK_CONFIRM));
        }
    }

    protected void sumToParent() {
        String parentId;
        int entryRowCount = this.getModel().getEntryRowCount("taskentry");
        if (entryRowCount <= 0) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
        this.getPageCache().put("rowIndex", rowIndex + "");
        this.getModel().updateCache();
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        DynamicObjectCollection taskEntryCopy = new DynamicObjectCollection();
        taskEntryCopy.addAll((Collection)taskEntryCol);
        HashMap<String, Integer> idLevelMap = new HashMap<String, Integer>(16);
        HashMap<String, DynamicObject> idDynamicObjectMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject taskEntry : taskEntryCopy) {
            idDynamicObjectMap.put(taskEntry.getString("id"), taskEntry);
            parentId = taskEntry.getString("pid");
            if (!"0".equals(parentId) && parentId != null) {
                idLevelMap.put(taskEntry.getString("id"), (Integer)idLevelMap.get(parentId) + 1);
            } else {
                idLevelMap.put(taskEntry.getString("id"), 1);
            }
            if (taskEntry.getBoolean(IS_LEAF)) continue;
            taskEntry.set("absoluteduration", (Object)BigDecimal.ZERO);
        }
        taskEntryCopy.sort(Comparator.comparingInt(o -> -((Integer)idLevelMap.get(o.getString("id"))).intValue()));
        for (DynamicObject taskEntry : taskEntryCopy) {
            DynamicObject parent;
            parentId = taskEntry.getString("pid");
            if ("0".equals(parentId) || parentId == null || (parent = (DynamicObject)idDynamicObjectMap.get(parentId)) == null) continue;
            parent.set("absoluteduration", (Object)parent.getBigDecimal("absoluteduration").add(taskEntry.getBigDecimal("absoluteduration")));
        }
        this.getModel().updateEntryCache(taskEntryCol);
        this.getView().updateView("taskentry");
    }

    protected void setIsLeaf() {
        this.getModel().updateCache();
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        HashMap<Object, DynamicObject> taskIdMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject taskEntry : taskEntryCol) {
            taskEntry.set(IS_LEAF, (Object)"1");
            DynamicObject parentTask = (DynamicObject)taskIdMap.get(taskEntry.get("pid"));
            if (parentTask != null) {
                parentTask.set(IS_LEAF, (Object)"0");
            }
            taskIdMap.put(taskEntry.get("id"), taskEntry);
        }
    }

    protected void upGrade() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
        DynamicObject currentRowIndex = this.getModel().getEntryRowEntity("taskentry", rowIndex);
        if (currentRowIndex == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PlanTemplateEditPlugin_31", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String parentId = String.valueOf(this.getModel().getValue("pid", rowIndex));
        if (rowIndex == 0 || Long.parseLong(parentId) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u6839\u8282\u70b9\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"PlanTemplateEditPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            String curRowId = this.getModel().getEntryRowEntity("taskentry", i).getString("id");
            if (!parentId.equals(curRowId)) continue;
            String parentpId = String.valueOf(this.getModel().getValue("pid", i));
            this.getModel().getEntryRowEntity("taskentry", rowIndex).set("pid", (Object)parentpId);
            this.getModel().getEntryRowEntity("taskentry", i).set("isGroupNode", (Object)Boolean.FALSE);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u6839\u8282\u70b9\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"PlanTemplateEditPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
    }

    protected void downGrade() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
        DynamicObject currentRowIndex = this.getModel().getEntryRowEntity("taskentry", rowIndex);
        if (currentRowIndex == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PlanTemplateEditPlugin_31", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String parentId = String.valueOf(this.getModel().getValue("pid", rowIndex));
        int rowCount = this.getModel().getEntryRowCount("taskentry");
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"PlanTemplateEditPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            String parentpId = String.valueOf(this.getModel().getValue("pid", i));
            if (!StringUtils.equals((CharSequence)parentId, (CharSequence)parentpId)) continue;
            String curRowId = this.getModel().getEntryRowEntity("taskentry", i).getString("id");
            this.getModel().getEntryRowEntity("taskentry", rowIndex).set("pid", (Object)curRowId);
            this.getModel().getEntryRowEntity("taskentry", i).set("isGroupNode", (Object)Boolean.FALSE);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"PlanTemplateEditPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
    }

    protected void updateReferTaskPreTaskName(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        DynamicObject taskEntry = this.getModel().getEntryRowEntity("taskentry", rowIndex);
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        for (int i = 0; i < taskEntryCol.size(); ++i) {
            DynamicObject task = (DynamicObject)taskEntryCol.get(i);
            Long preTaskId = task.getLong("pretaskid");
            if (!taskEntry.getPkValue().equals(preTaskId)) continue;
            this.getModel().setValue("pretask", (Object)taskEntry.getString("taskname"), i);
        }
    }

    protected void importFromExcel(ClosedCallBackEvent closedCallBackEvent) {
        String url = (String)closedCallBackEvent.getReturnData();
        if (url == null || "".equals(url.trim())) {
            return;
        }
        PlanTaskPOIHelper helper = new PlanTaskPOIHelper();
        String columnKeyHash = POIHelper.stringArrayToHash((String[])PlanTemplateEditPlugin.getExcelColumnKey());
        JSONArray jsonArray = helper.newInputExcelForTask(url, columnKeyHash);
        if (jsonArray == null || jsonArray.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\uff0c\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u4e3a\u7a7a\u3002", (String)"PlanTemplateEditPlugin_33", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter nameFilter = null;
        HashMap<Long, String> parentMap = new HashMap<Long, String>(16);
        HashMap<Long, String> preMap = new HashMap<Long, String>(16);
        HashMap<String, Long> nameMap = new HashMap<String, Long>(16);
        HashSet<String> parentNameSet = new HashSet<String>(16);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentry");
        DynamicObjectType entryDt = entries.getDynamicObjectType();
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        ORM orm = ORM.create();
        long[] entryIds = orm.genLongIds((IDataEntityType)entryDt, jsonArray.size());
        int index = 0;
        for (Object json : jsonArray) {
            JSONArray jArray = JSONArray.parseArray((String)json.toString());
            DynamicObject entry = new DynamicObject(entryDt);
            Long entryId = entryIds[index++];
            entry.set("id", (Object)entryId);
            for (Object jsonObject : jArray) {
                JSONObject jObject = JSONObject.parseObject((String)jsonObject.toString());
                String columnKey = jObject.getString("columnKey");
                String value = jObject.get((Object)"cellValue") != null ? jObject.get((Object)"cellValue").toString() : "";
                nameFilter = new QFilter("name", "=", (Object)value);
                Object o = jObject.get((Object)"cellValue");
                block12 : switch (columnKey) {
                    case "taskname": {
                        entry.set("taskname", (Object)value);
                        nameMap.put(value, entryId);
                        break;
                    }
                    case "controllevel": {
                        DynamicObject controlLevel = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"controllevel"), (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter});
                        entry.set("controllevel", (Object)controlLevel);
                        break;
                    }
                    case "tasktype": {
                        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter});
                        entry.set("tasktype", (Object)taskType);
                        break;
                    }
                    case "spectype": {
                        Object projectKindId = this.getModel().getValue("projectkind_id");
                        QFilter kindFilter = new QFilter("group", "=", projectKindId).or(new QFilter("group", "=", (Object)0L));
                        DynamicObject spectType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter, kindFilter});
                        entry.set("spectype", (Object)spectType);
                        break;
                    }
                    case "absoluteduration": {
                        if (!StringUtils.equals((CharSequence)"", (CharSequence)value)) {
                            if (!(o instanceof BigDecimal)) break;
                            Object absoluteshedule = (BigDecimal)o;
                            entry.set("absoluteduration", absoluteshedule);
                            break;
                        }
                        entry.set("absoluteduration", (Object)BigDecimal.ZERO);
                        break;
                    }
                    case "achievementnode": {
                        switch (value) {
                            case "\u662f": {
                                entry.set("achievementnode", (Object)DefaultEnum.YES.getValue());
                                break block12;
                            }
                            case "\u5426": {
                                entry.set("achievementnode", (Object)DefaultEnum.NO.getValue());
                                break block12;
                            }
                        }
                        break;
                    }
                    case "pretask": {
                        preMap.put(entryId, value);
                        break;
                    }
                    case "logical": {
                        switch (value) {
                            case "\u5f00\u59cb-\u5f00\u59cb": {
                                entry.set("logical", (Object)LogicalEnum.START_START.getValue());
                                break block12;
                            }
                            case "\u5f00\u59cb-\u5b8c\u6210": {
                                entry.set("logical", (Object)LogicalEnum.START_FINISH.getValue());
                                break block12;
                            }
                            case "\u5b8c\u6210-\u5f00\u59cb": {
                                entry.set("logical", (Object)LogicalEnum.FINISH_START.getValue());
                                break block12;
                            }
                            case "\u5b8c\u6210-\u5b8c\u6210": {
                                entry.set("logical", (Object)LogicalEnum.FINISH_FINISH.getValue());
                                break block12;
                            }
                        }
                        break;
                    }
                    case "relativeduration": {
                        if (!StringUtils.equals((CharSequence)"", (CharSequence)value)) {
                            if (!(o instanceof BigDecimal)) break;
                            BigDecimal relativeduration = (BigDecimal)o;
                            entry.set("relativeduration", (Object)relativeduration);
                            break;
                        }
                        entry.set("relativeduration", (Object)BigDecimal.ZERO);
                        break;
                    }
                    case "parent": {
                        parentMap.put(entryId, value);
                        if (StringUtils.equals((CharSequence)"", (CharSequence)value)) break;
                        parentNameSet.add(value);
                        break;
                    }
                }
            }
            entryList.add(entry);
        }
        for (DynamicObject entry : entryList) {
            String preName;
            Long parentId;
            String parentName;
            String taskName = entry.getString("taskname");
            if (parentNameSet.contains(taskName)) {
                entry.set(IS_LEAF, (Object)Boolean.FALSE);
            }
            if (!StringUtils.equals((CharSequence)"", (CharSequence)(parentName = (String)parentMap.get(entry.getLong("id")))) && (parentId = (Long)nameMap.get(parentName)) != null) {
                entry.set("pid", (Object)parentId);
            }
            if (StringUtils.equals((CharSequence)"", (CharSequence)(preName = (String)preMap.get(entry.getLong("id"))))) continue;
            Long preId = (Long)nameMap.get(preName);
            if (preId != null) {
                entry.set("pretask", (Object)preName);
                entry.set("pretaskid", (Object)preId);
                continue;
            }
            entry.set("logical", (Object)"");
            entry.set("relativeduration", (Object)BigDecimal.ZERO);
        }
        this.getModel().deleteEntryData("taskentry");
        this.getModel().updateCache();
        entries = this.getModel().getEntryEntity("taskentry");
        entries.addAll(entryList);
        this.getModel().updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("taskentry");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("taskentry");
    }

    protected void showSelectPreTaskForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantplpretask"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"PlanTemplateEditPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(this.getCloseCallBackPluginName("thisplugin"), "plantplpretask"));
        this.getView().showForm(showParameter);
    }

    protected String getCloseCallBackPluginName(String closeCallBackAction) {
        String pluginName = "";
        if (StringUtils.equals((CharSequence)"thisplugin", (CharSequence)closeCallBackAction)) {
            pluginName = this.getPluginName();
        }
        return pluginName;
    }

    protected void rebuildTreeStructure() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentry");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int index = selectRows[0];
        DynamicObject entry = this.getModel().getEntryRowEntity("taskentry", index);
        long pid = entry.getLong("pid");
        int rows = this.getModel().getEntryRowCount("taskentry");
        if (pid == 0L) {
            this.getModel().setValue(IS_LEAF, (Object)DefaultEnum.YES.getValue(), index);
        } else {
            for (int i = 0; i < rows; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity("taskentry", i);
                if (pid != Long.parseLong(row.getPkValue().toString())) continue;
                this.getModel().setValue(IS_LEAF, (Object)DefaultEnum.NO.getValue(), i);
                this.getModel().setValue(IS_LEAF, (Object)DefaultEnum.YES.getValue(), index);
            }
        }
    }
}

