/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.tree.DynamicObjectTreeNode;
import kd.pccs.placs.common.utils.tree.Hierarchy;
import kd.pccs.placs.common.utils.tree.Hierarchyable;
import kd.pccs.placs.common.utils.tree.OrgProjectTreeHelper;
import kd.pccs.placs.formplugin.base.TreeSelectCtrlPlugin;

public class PlanTemplateImportListPlugin
extends TreeSelectCtrlPlugin
implements TreeNodeClickListener,
SearchEnterListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(PlanTemplateImportListPlugin.class);
    public static final String TREE_ENTRYENTITY = "treeentryentity";
    private static final String OKBTN = "okbtn";
    public static final String KEY_TREEVIEWAP = "treeview";
    public static final String TPLTASK_TREE_KEY = "orgproject_tree_key";

    protected String getProjectFormId() {
        return "bd_project";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{OKBTN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isInitSucess = this.initNavTree();
        if (!isInitSucess) {
            return;
        }
        this.initTreeData(null);
    }

    protected boolean initNavTree() {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (customMap.get("projectId") != null) {
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            DynamicObject project = parentModel.getDataEntity().getDynamicObject("project");
            QFilter projectKindFilter = new QFilter("projectkind", "=", (Object)0L);
            DynamicObject projectKind = this.getProjectKind(project);
            if (projectKind != null) {
                projectKindFilter.or(new QFilter("projectkind", "=", projectKind.getPkValue()));
            }
            QFilter validFilter = new QFilter("validversion", "=", (Object)"1");
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            DynamicObject[] tplArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"), (String)"id,name", (QFilter[])new QFilter[]{projectKindFilter, validFilter, enableFilter}, (String)"projectkind desc,version desc");
            if (tplArr == null || tplArr.length == 0) {
                return false;
            }
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
            Hierarchy tree = this.initPlanTplNavTree(treeView, tplArr);
            this.getPageCache().put(TPLTASK_TREE_KEY, SerializeHelper.serialize((Object)tree));
            return true;
        }
        return false;
    }

    protected DynamicObject getProjectKind(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    public Hierarchy initPlanTplNavTree(TreeView treeView, DynamicObject[] tplArr) {
        DynamicObjectTreeNode node;
        Hierarchy tree = new Hierarchy();
        TreeNode root = new TreeNode("", "0L", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PlanTemplateImportListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), true);
        DynamicObjectTreeNode rootnoode = new DynamicObjectTreeNode();
        rootnoode.setId(0L);
        rootnoode.setName(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PlanTemplateImportListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        tree.setRootNode((Hierarchyable)rootnoode);
        tree.setSort(true);
        for (DynamicObject tpl : tplArr) {
            node = new DynamicObjectTreeNode();
            node.setId(((Long)tpl.getPkValue()).longValue());
            node.setName(tpl.getString("name"));
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("color", "black");
            node.setData(data);
            node.setValue(tpl);
            node.setParentId(0L);
            node.setNumber(tpl.getString("number"));
            tree.addObject((Hierarchyable)node);
        }
        List treeNodes = tree.getAllChildren(tree.getRootNode());
        treeView.deleteAllNodes();
        root.setIsOpened(true);
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            node = treeNode.getTreeNode();
            if (hierarchyable.getParentId() == 0L || hierarchyable.getParentId() == 1L) {
                node.setIsOpened(true);
            }
            treeView.addNode((TreeNode)node);
            if (!((Hierarchyable)treeNodes.get(0)).equals(hierarchyable)) continue;
            treeView.focusNode((TreeNode)node);
        }
        return tree;
    }

    public void click(EventObject evt) {
        String btnKey;
        Button source = (Button)evt.getSource();
        switch (btnKey = source.getKey()) {
            case "okbtn": {
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
                int[] rows = entryGrid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u4efb\u52a1\u3002", (String)"PlanTemplateImportListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> list = new ArrayList<Long>(10);
                for (int row : rows) {
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(TREE_ENTRYENTITY, row);
                    long pkId = rowObj.getLong("id");
                    list.add(pkId);
                }
                this.getView().returnDataToParent(list);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    protected void initTreeData(Object conditionFilter) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData(TREE_ENTRYENTITY);
        DynamicObjectCollection tasks = null;
        DynamicObject[] showTasks = null;
        if (conditionFilter == null) {
            String treeStr = this.getPageCache().get(TPLTASK_TREE_KEY);
            Hierarchy tree = (Hierarchy)SerializeHelper.unserialize((String)treeStr);
            List treeNodes = tree.getAllChildren(tree.getRootNode());
            long tplId = ((Hierarchyable)treeNodes.get(0)).getId();
            DynamicObject planTemplate = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
            tasks = planTemplate.getDynamicObjectCollection("taskentry");
            showTasks = (DynamicObject[])tasks.toArray((Object[])new DynamicObject[tasks.size()]);
        } else {
            DynamicObject planTemplate = BusinessDataServiceHelper.loadSingle((Object)conditionFilter, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
            tasks = planTemplate.getDynamicObjectCollection("taskentry");
            showTasks = (DynamicObject[])tasks.toArray((Object[])new DynamicObject[tasks.size()]);
        }
        Set<String> taskIdSet = Arrays.stream(showTasks).map(o -> o.getPkValue().toString()).collect(Collectors.toSet());
        DynamicObjectCollection taskEntries = this.fillShowTask(showTasks, taskIdSet);
        if (taskEntries == null || taskEntries.isEmpty()) {
            return;
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView(TREE_ENTRYENTITY);
    }

    protected DynamicObjectCollection fillShowTask(DynamicObject[] showTasks, Set<String> taskIdSet) {
        if (showTasks == null || showTasks.length == 0) {
            return null;
        }
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        for (DynamicObject task : showTasks) {
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            newEntry.set("id", task.get("id"));
            newEntry.set("name", task.get("taskname"));
            newEntry.set("tasktype", task.get("tasktype"));
            newEntry.set("seq", task.get("seq"));
            newEntry.set("controllevel", task.get("controllevel"));
            newEntry.set("absoluteduration", task.get("absoluteduration"));
            newEntry.set("pretask", task.get("pretask"));
            newEntry.set("logical", task.get("logical"));
            newEntry.set("responsiblepost", task.get("responsiblepost"));
            newEntry.set("associatepost", task.get("associatepost"));
            newEntry.set("transactiontype", task.get("transactiontype"));
            newEntry.set("pid", task.get("pid"));
            taskEntries.add((Object)newEntry);
        }
        return taskEntries;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchKey = search.getKey();
        if ("treesearchap".equals(searchKey)) {
            OrgProjectTreeHelper.search((IFormView)this.getView(), (IPageCache)pageCache, (String)searchText);
        }
    }

    protected void showData(Object conditionFilter, boolean isProjectNode) {
        this.initTreeData(conditionFilter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (KEY_TREEVIEWAP.equals(key)) {
            Object nodeId = evt.getNodeId();
            this.showData(nodeId, true);
        }
    }
}

