/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;

public class PlanTemplateListPlugin
extends AbstractPlacsListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (StringUtils.equals((CharSequence)"adjust", (CharSequence)operate.getOperateKey())) {
            this.beforeDoAdjust(args, listSelectedData);
        }
    }

    protected void beforeDoAdjust(BeforeDoOperationEventArgs args, ListSelectedRowCollection listSelectedData) {
        if (listSelectedData.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u64cd\u4f5c\u4e0d\u652f\u6301\u591a\u9009\uff0c\u8bf7\u9009\u4e2d\u5355\u6761\u6570\u636e\u3002", (String)"PlanTemplateListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)listSelectedData.get(0).getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
        String billStatus = bill.getString("status");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"C")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlanTemplateListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject prePlanTemp = bill.getDynamicObject("pretemplate");
        boolean isNotNewest = false;
        if (prePlanTemp == null) {
            QFilter prePlanTempFilter = new QFilter("pretemplate", "=", bill.getPkValue());
            isNotNewest = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"), (QFilter[])new QFilter[]{prePlanTempFilter});
        } else {
            QFilter versionFilter = new QFilter("version", ">", bill.get("version"));
            QFilter prePlanTempFilter = new QFilter("pretemplate", "=", prePlanTemp.getPkValue());
            isNotNewest = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"), (QFilter[])new QFilter[]{versionFilter, prePlanTempFilter});
        }
        if (isNotNewest) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6700\u65b0\u7248\u672c\u4e0a\u8fdb\u884c\u8c03\u6574\u548c\u7f16\u8f91\u3002", (String)"PlanTemplateListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent beforeshowbillformevent) {
        super.beforeShowBill(beforeshowbillformevent);
        BillShowParameter parameter = beforeshowbillformevent.getParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        Boolean isCopy = (Boolean)parameter.getCustomParam("iscopy");
        if (billStatus == null || isCopy == null) {
            return;
        }
        String formId = parameter.getFormId();
        if (StringUtils.equals((CharSequence)formId, (CharSequence)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate")) && billStatus.compareTo((Enum)BillOperationStatus.ADDNEW) == 0 && isCopy.booleanValue()) {
            parameter.setCustomParam("prePlanTempId", parameter.getPkId());
        }
    }
}

