/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class PlanTplImportTaskPlugin
extends AbstractPlacsFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid planEntry = (EntryGrid)this.getControl("planentry");
        planEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object importType = this.getView().getFormShowParameter().getCustomParam("importType");
        Object projectKindId = this.getView().getFormShowParameter().getCustomParam("projectKindId");
        DynamicObjectCollection planEntryCol = this.getModel().getEntryEntity("planentry");
        DynamicObjectType planEntryDt = planEntryCol.getDynamicObjectType();
        if (importType != null && StringUtils.equals((CharSequence)((String)importType), (CharSequence)"othertpl")) {
            DynamicObject[] planTplArr;
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter validVersionFilter = new QFilter("validversion", "=", (Object)"1");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(statusFilter);
            qFilters.add(validVersionFilter);
            for (DynamicObject planTpl : planTplArr = this.getPlanTplArr(projectKindId, qFilters)) {
                DynamicObject newPlan = new DynamicObject(planEntryDt);
                newPlan.set("tplname", (Object)planTpl.getString("name"));
                newPlan.set("billid", planTpl.getPkValue());
                planEntryCol.add((Object)newPlan);
            }
        } else {
            DynamicObject[] planArr;
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)"3");
            QFilter proFilter = this.getProFilter();
            billStatusFilter.and(proFilter);
            for (DynamicObject plan : planArr = this.getPlanArrByFilters(projectKindId, billStatusFilter, planStatusFilter)) {
                DynamicObject newPlan = new DynamicObject(planEntryDt);
                newPlan.set("project", (Object)plan.getDynamicObject("project"));
                newPlan.set("planname", (Object)plan.getString("billname"));
                newPlan.set("billid", plan.getPkValue());
                planEntryCol.add((Object)newPlan);
            }
        }
    }

    protected QFilter getProFilter() {
        return null;
    }

    protected DynamicObject[] getPlanTplArr(Object projectKindId, List<QFilter> qFilters) {
        QFilter projectKindFilter = new QFilter("projectkind", "=", projectKindId).or("projectkind", "=", (Object)0L);
        qFilters.add(projectKindFilter);
        DynamicObject[] planTplArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"), (String)"name,number,projectkind", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"projectkind,number");
        return planTplArr;
    }

    protected DynamicObject[] getPlanArrByFilters(Object projectKindId, QFilter billStatusFilter, QFilter planStatusFilter) {
        QFilter projectKindFilter = new QFilter("project.group", "=", projectKindId);
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"project,billname,taskentity", (QFilter[])new QFilter[]{billStatusFilter, planStatusFilter, projectKindFilter}, (String)"project,billname");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object importType = this.getView().getFormShowParameter().getCustomParam("importType");
        if (importType != null && StringUtils.equals((CharSequence)((String)importType), (CharSequence)"othertpl")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"project", "planname"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tplname"});
        }
        int rowCount = this.getModel().getEntryRowCount("planentry");
        if (rowCount > 0) {
            EntryGrid planEntry = (EntryGrid)this.getControl("planentry");
            planEntry.selectRows(0);
            this.loadTaskInfo(0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"returntoparent", (CharSequence)operateKey)) {
            this.beforeReturnToParent();
        }
    }

    protected void beforeReturnToParent() {
        int[] selectRowIndexArr;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        int planEntryCurrentRow = this.getModel().getEntryCurrentRowIndex("planentry");
        Object billId = this.getModel().getValue("billid", planEntryCurrentRow);
        resultMap.put("billId", billId);
        ArrayList<DynamicObject> entryRowList = new ArrayList<DynamicObject>(10);
        EntryGrid taskEntry = (EntryGrid)this.getControl("taskentry");
        for (int i : selectRowIndexArr = taskEntry.getSelectRows()) {
            DynamicObject entryRow = this.getModel().getEntryRowEntity("taskentry", i);
            entryRowList.add(entryRow);
        }
        resultMap.put("entryRowList", entryRowList);
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if (StringUtils.equals((CharSequence)"planentry", (CharSequence)entryKey)) {
            this.loadTaskInfo(rowIndex);
        }
    }

    protected void loadTaskInfo(int rowIndex) {
        this.getModel().deleteEntryData("taskentry");
        Long billId = (Long)this.getModel().getValue("billid", rowIndex);
        Object importType = this.getView().getFormShowParameter().getCustomParam("importType");
        DynamicObjectCollection taskEntryCol = this.getModel().getEntryEntity("taskentry");
        DynamicObjectType taskEntryDt = taskEntryCol.getDynamicObjectType();
        if (importType != null && StringUtils.equals((CharSequence)((String)importType), (CharSequence)"othertpl")) {
            DynamicObject planTplObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"));
            DynamicObjectCollection taskCol = planTplObj.getDynamicObjectCollection("taskentry");
            for (DynamicObject task : taskCol) {
                DynamicObject newTaskEntry = new DynamicObject(taskEntryDt);
                newTaskEntry.set("id", task.getPkValue());
                newTaskEntry.set("pid", task.get("pid"));
                newTaskEntry.set("taskid", task.getPkValue());
                newTaskEntry.set("taskname", task.get("taskname"));
                newTaskEntry.set("majortype", task.get("spectype"));
                newTaskEntry.set("transactiontype", task.get("transactiontype"));
                newTaskEntry.set("controllevel", (Object)task.getDynamicObject("controllevel"));
                newTaskEntry.set("tasktype", (Object)task.getDynamicObject("tasktype"));
                newTaskEntry.set("achievementnode", task.get("achievementnode"));
                newTaskEntry.set("pretask", (Object)task.getString("pretask"));
                newTaskEntry.set("logical", task.get("logical"));
                newTaskEntry.set("relativeduration", task.get("relativeduration"));
                newTaskEntry.set("absoluteduration", task.get("absoluteduration"));
                taskEntryCol.add((Object)newTaskEntry);
            }
        } else {
            DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
            DynamicObjectCollection taskCol = planObj.getDynamicObjectCollection("taskentity");
            for (DynamicObject task : taskCol) {
                DynamicObject newTaskEntry = new DynamicObject(taskEntryDt);
                newTaskEntry.set("id", task.getPkValue());
                newTaskEntry.set("pid", task.get("pid"));
                newTaskEntry.set("taskname", (Object)task.getString("name"));
                newTaskEntry.set("majortype", task.get("specialtype"));
                newTaskEntry.set("transactiontype", task.get("transactiontype"));
                newTaskEntry.set("controllevel", (Object)task.getDynamicObject("controllevel"));
                newTaskEntry.set("tasktype", (Object)task.getDynamicObject("tasktype"));
                newTaskEntry.set("achievementnode", task.get("achievementnode"));
                DynamicObject preTask = task.getDynamicObject("pretask");
                if (preTask != null) {
                    newTaskEntry.set("pretask", (Object)preTask.getString("name"));
                }
                newTaskEntry.set("logical", task.get("logical"));
                newTaskEntry.set("relativeduration", task.get("relativeduration"));
                newTaskEntry.set("absoluteduration", task.get("absoluteduration"));
                taskEntryCol.add((Object)newTaskEntry);
            }
        }
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("taskentry");
        taskEntryGrid.setCollapse(false);
        this.getModel().updateEntryCache(taskEntryCol);
        this.getView().updateView("taskentry");
    }
}

