/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.Html;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.PersonTaskCalendarViewPlugin;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ProCalendarViewPlugin
extends AbstractPlacsFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PersonTaskCalendarViewPlugin.class);
    private static final int ROW = 7;
    private static final int COL = 8;

    public void createNewData(BizDataEventArgs e) {
        this.init();
    }

    public void init() {
        this.setCalendar(new Date());
    }

    protected void setCalendar(Date date) {
        DynamicObject[] tasks;
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> infoMap = new HashMap<String, String>(16);
        String taskIdsStr = this.getPageCache().get("taskIds");
        Object[] taskIds = taskIdsStr.split(",");
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((Object[])taskIds, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))) {
            infoMap.put(task.getPkValue().toString(), task.get("planstarttime").toString() + "@22KD&&@" + task.getString("name"));
        }
        int index = 1;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                this.getModel().setValue("textfield_" + i + "_" + j, (Object)dfnyr.format(calendar.getTime()));
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("<div title=\"\"><div style=\"text-align:right;\"><span style=\"width:28px;font-size:16px;height:28px;color:#333333;border-radius:50%;display:inline-block;line-height:28px;text-align:center;");
                if (index < weekday || index - weekday - maxday + 1 > 0) {
                    sBuilder.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime()))) {
                    sBuilder.append("background:rgba(95,137,243,1);");
                    sBuilder.append("color:#ffffff;");
                }
                sBuilder.append("\">").append(dfdd.format(calendar.getTime())).append("</span>").append("</div>");
                int k = 0;
                for (Map.Entry entry : infoMap.entrySet()) {
                    String value = (String)entry.getValue();
                    String[] split = value.split("@22KD&&@");
                    String starttime = split[0];
                    String taskname = split[1];
                    int tasknamelength = taskname.length();
                    String tasknametitle = null;
                    tasknametitle = tasknamelength > 6 ? taskname.substring(0, 6) + "..." : taskname;
                    Date starttimeFrom = null;
                    try {
                        starttimeFrom = dfnyr.parse(starttime);
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                    if (!dfnyr.format(starttimeFrom).equals(dfnyr.format(calendar.getTime()))) continue;
                    sBuilder.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                    sBuilder.append("<span style=\"background:#FC8555;width:4px;height:4px;display:inline-block;font-size:large;\"></span>");
                    sBuilder.append("<span style=\"color:rgba(51,51,51,1);margin-left:4px;font-size:large;\">").append(tasknametitle).append("</span>");
                    sBuilder.append("</div>");
                    if (++k <= 1) continue;
                    break;
                }
                sBuilder.append("</div></div>");
                html.setConent(sBuilder.toString());
                ++index;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }
}

