/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.tree.DynamicObjectTreeNode;
import kd.pccs.placs.common.utils.tree.Hierarchy;
import kd.pccs.placs.common.utils.tree.Hierarchyable;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ProImportTaskListPlugin
extends AbstractPlacsFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(ProImportTaskListPlugin.class);
    private static final String TREEVIEW = "treeview";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String KEY_SEARCHAP = "searchap";
    private static final String TOTALTABPAGEAP = "totaltabpageap";
    private static final String ID_PLANTYPE_PLANTYPENAME = "id,plantype,plantypename";
    private static final String ZHUZETABPAGEAP = "zhuzetabpageap";
    private static final String XIEBANTABPAGEAP = "xiebantabpageap";
    private static final String OKBTN = "okbtn";
    private static final String CANCELBTN = "btnclose";
    private static final String PROJECT_SELECTPROS = "id,name,createorg";

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "majortype": {
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
                Map focusNodeMap = tree.getTreeState().getFocusNode();
                tree.treeNodeClick(focusNodeMap.get("parentid").toString(), focusNodeMap.get("id").toString());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
        Search searchap = (Search)this.getView().getControl(KEY_SEARCHAP);
        searchap.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{OKBTN});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject[] orgs;
        super.beforeBindData(e);
        TreeView treeview = (TreeView)this.getView().getControl(TREEVIEW);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)this.getAppId());
        String userId = RequestContext.get().getUserId();
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(userId), (String)appId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"47150e89000000ac");
        List haspPermOrgIds = hasPermOrgs.getHasPermOrgs();
        if (hasPermOrgs.hasAllOrgPerm() && haspPermOrgIds.size() == 0) {
            orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", null);
            haspPermOrgIds = Arrays.stream(orgs).map(org -> org.getLong("id")).collect(Collectors.toList());
        } else {
            orgs = BusinessDataServiceHelper.load((Object[])haspPermOrgIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
        }
        Map<Long, Long> orgRelationMap = this.setOrgRelationMap(haspPermOrgIds);
        Hierarchy tree = new Hierarchy();
        DynamicObject[] projects = this.getAllProjectOfOrgs(orgs);
        List<DynamicObject> orgHasProject = this.getOrgsOfHavingPros(projects, orgs);
        boolean hasOtherPro = this.beHavingOtherPros(orgHasProject, projects);
        this.initTreeNodeOfOrg(orgHasProject, orgRelationMap, tree, hasOtherPro);
        this.initProjectTree(tree, projects);
        TreeNode root = ((DynamicObjectTreeNode)tree.getRootNode()).getTreeNode();
        root.setIsOpened(true);
        treeview.addNode(root);
        treeview.focusNode(root);
        tree.getAllChildren(tree.getRootNode()).forEach(entity -> {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)entity;
            TreeNode node = treeNode.getTreeNode();
            String color = (String)treeNode.getData().get("color");
            node.setColor(color);
            treeview.addNode(node);
            treeview.expand(node.getId());
        });
        this.getPageCache().put("orgproject_tree_key", SerializeHelper.serialize((Object)tree));
    }

    protected boolean beHavingOtherPros(List<DynamicObject> orgHasProject, DynamicObject[] projects) {
        boolean hasOtherPro = false;
        List displayOrgIds = orgHasProject.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        for (DynamicObject pro : projects) {
            long orgId = pro.getDynamicObject("org").getLong("id");
            if (displayOrgIds.contains(orgId)) continue;
            hasOtherPro = true;
            break;
        }
        return hasOtherPro;
    }

    protected List<DynamicObject> getOrgsOfHavingPros(DynamicObject[] projects, DynamicObject[] orgs) {
        List orgIdHasProject = Arrays.stream(projects).map(project -> ((DynamicObject)project.get("org")).getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> orgHasProject = Arrays.stream(orgs).filter(org -> orgIdHasProject.contains(org.getLong("id"))).collect(Collectors.toList());
        return orgHasProject;
    }

    protected void initProjectTree(Hierarchy tree, DynamicObject[] projects) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        String proId = StringUtils.isNotBlank(customMap.get("proId")) ? customMap.get("proId").toString() : "";
        Arrays.stream(projects).filter(project -> !StringUtils.equals((CharSequence)proId, (CharSequence)project.getString("id"))).sorted(Comparator.comparing(project -> project.getInt("level"))).forEach(project -> this.initTreeNodeByProject(tree, (DynamicObject)project));
    }

    protected DynamicObject[] getAllProjectOfOrgs(DynamicObject[] orgs) {
        List orgIdList = Arrays.stream(orgs).map(entity -> (Long)entity.get("id")).collect(Collectors.toList());
        DynamicObject[] projs = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdList)});
        return BusinessDataServiceHelper.load((Object[])Arrays.stream(projs).map(proj -> proj.getPkValue()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getProjectFormId()));
    }

    protected String getProjectFormId() {
        return "bd_project";
    }

    protected void initTreeNodeByProject(Hierarchy tree, DynamicObject project) {
        DynamicObjectTreeNode node = new DynamicObjectTreeNode();
        node.setId(((Long)project.getPkValue()).longValue());
        node.setName(project.getString("name"));
        long parentId = this.getParentId(project);
        DynamicObjectTreeNode parent = (DynamicObjectTreeNode)tree.getObject(parentId);
        TreeNode parentNode = parent == null ? ((DynamicObjectTreeNode)tree.getObject(-2L)).getTreeNode() : parent.getTreeNode();
        node.setParentId(Long.parseLong(parentNode.getId()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("color", "blue");
        node.setData(data);
        node.setValue(project);
        TreeNode projectNode = node.getTreeNode();
        projectNode.setColor("blue");
        parentNode.addChild(0, node.getTreeNode());
    }

    protected long getParentId(DynamicObject project) {
        DynamicObject org = project.getDynamicObject("org");
        return Long.parseLong(org.getPkValue().toString());
    }

    protected void initTreeNodeOfOrg(List<DynamicObject> orgs, Map<Long, Long> orgRelationMap, Hierarchy tree, boolean hasOtherPro) {
        DynamicObjectTreeNode rootNode = new DynamicObjectTreeNode();
        rootNode.setId(-1L);
        rootNode.setName(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ProImportTaskListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        rootNode.setValue(null);
        tree.setRootNode((Hierarchyable)rootNode);
        for (DynamicObject org : orgs) {
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId(((Long)org.getPkValue()).longValue());
            node.setName(org.getString("name"));
            Long parentId = orgRelationMap.get(Long.valueOf(org.getPkValue().toString()));
            if (null != parentId) {
                node.setParentId(parentId.longValue());
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("color", "black");
            node.setData(data);
            node.setValue(org);
            tree.addObject((Hierarchyable)node);
        }
        if (hasOtherPro) {
            DynamicObjectTreeNode otherNode = new DynamicObjectTreeNode();
            otherNode.setId(-2L);
            otherNode.setName(ResManager.loadKDString((String)"\u5176\u4ed6\u9879\u76ee", (String)"ProImportTaskListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            otherNode.setParentId(-1L);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("color", "black");
            otherNode.setData(data);
            otherNode.setValue(null);
            tree.addObject((Hierarchyable)otherNode);
        }
    }

    protected Map<Long, Long> setOrgRelationMap(List<Long> haspPermOrgIds) {
        QFilter filterOrgId = new QFilter("org.id", "in", haspPermOrgIds);
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)"15");
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreeType};
        Map orgMapping = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org_structure"), (QFilter[])filters);
        HashMap<Long, Long> orgRelationMap = new HashMap<Long, Long>();
        for (Map.Entry relation : orgMapping.entrySet()) {
            DynamicObject relationInfo = (DynamicObject)relation.getValue();
            if (relationInfo.get("parent.id") != null && haspPermOrgIds.contains(relationInfo.get("parent.id"))) {
                orgRelationMap.put(relationInfo.getLong("org.id"), Long.valueOf(relationInfo.get("parent.id").toString()));
                continue;
            }
            orgRelationMap.put(relationInfo.getLong("org.id"), -1L);
        }
        return orgRelationMap;
    }

    protected QFilter getBasicFilter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String filterStr = (String)parameter.getCustomParam("filter");
        return (QFilter)SerializeHelper.unserialize((String)filterStr);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (TREEVIEW.equals(key)) {
            Object nodeId = evt.getNodeId();
            if (nodeId != null && this.isProjectNode(nodeId)) {
                QFilter proNodeFilter = this.getProjectNodeFilter(nodeId);
                this.showData(proNodeFilter, true);
            } else {
                Object[] projectIds = Arrays.stream(BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{this.getOrgFilter(nodeId)})).map(project -> project.getPkValue().toString()).toArray();
                this.showData(new QFilter("project", "in", Arrays.stream(projectIds).filter(StringUtils::isNotBlank).map(String::valueOf).map(Long::valueOf).collect(Collectors.toList())), false);
            }
        }
    }

    protected QFilter getOrgFilter(Object nodeId) {
        return new QFilter("org", "in", (Object)Long.valueOf((String)nodeId));
    }

    protected void showData(QFilter conditionFilter, boolean isProjectNode) {
        this.initTreeData(conditionFilter, isProjectNode);
    }

    protected void initTreeData(QFilter conditionFilter, boolean isProjectNode) {
        Set<String> taskIdSet;
        DynamicObject[] showTasks;
        DynamicObjectCollection taskEntries;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData(TREEENTRYENTITY);
        QFilter basicFilter = this.getBasicFilter();
        if (conditionFilter != null) {
            basicFilter.and(conditionFilter);
        }
        if ((taskEntries = this.fillShowTask(showTasks = isProjectNode ? BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{basicFilter}, (String)"belongplantype, taskseq asc") : BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{basicFilter}, (String)"project asc"), taskIdSet = Arrays.stream(showTasks).map(o -> o.getPkValue().toString()).collect(Collectors.toSet()))) == null || taskEntries.isEmpty()) {
            return;
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView(TREEENTRYENTITY);
    }

    protected DynamicObjectCollection fillShowTask(DynamicObject[] showTasks, Set<String> taskIdSet) {
        if (showTasks == null || showTasks.length == 0) {
            return null;
        }
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TREEENTRYENTITY);
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        for (DynamicObject task : showTasks) {
            DynamicObject parent;
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            newEntry.set("task", (Object)task);
            newEntry.set("id", task.get("id"));
            newEntry.set("name", task.get("name"));
            newEntry.set("project", task.get("project"));
            newEntry.set("belongplantype", task.get("belongplantype"));
            newEntry.set("tasktype", task.get("tasktype"));
            newEntry.set("pretask", task.get("pretask"));
            newEntry.set("seq", task.get("taskseq"));
            newEntry.set("controllevel", task.get("controllevel"));
            newEntry.set("planstarttime", task.get("planstarttime"));
            newEntry.set("planendtime", task.get("planendtime"));
            newEntry.set("absoluteduration", task.get("absoluteduration"));
            newEntry.set("responsibleperson", task.get("responsibleperson"));
            newEntry.set("responsibledept", task.get("responsibledept"));
            newEntry.set("multicooperationperson", task.get("multicooperationperson"));
            newEntry.set("multicooperationdept", task.get("multicooperationdept"));
            for (parent = task.getDynamicObject("parent"); parent != null && !taskIdSet.contains(parent.getPkValue().toString()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            taskEntries.add((Object)newEntry);
        }
        return taskEntries;
    }

    private QFilter getProjectNodeFilter(Object nodeId) {
        ArrayList<Object> proIds = new ArrayList<Object>(32);
        proIds.add(nodeId);
        QFilter proFilter = new QFilter("project", "in", proIds.stream().map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList()));
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)"1")});
        QFilter majorTypeFilter = new QFilter("majortype", "=", majorType.getPkValue());
        DynamicObject[] projectPlans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"taskentity,taskid", (QFilter[])new QFilter[]{proFilter, statusFilter, majorTypeFilter});
        ArrayList<Object> taskIds = new ArrayList<Object>(10);
        for (DynamicObject projectPlan : projectPlans) {
            DynamicObjectCollection taskEntries = projectPlan.getDynamicObjectCollection("taskentity");
            for (DynamicObject taskEntry : taskEntries) {
                taskIds.add(taskEntry.getPkValue());
            }
        }
        return new QFilter("id", "in", taskIds);
    }

    private boolean isProjectNode(Object nodeId) {
        DynamicObject project = null;
        try {
            project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)this.getProjectFormId());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return project != null;
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        String btnKey = source.getKey();
        if (OKBTN.equals(btnKey)) {
            this.doOkBtnClick();
        }
    }

    private void doOkBtnClick() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u4efb\u52a1\u3002", (String)"ProImportTaskListPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(10);
        for (int row : rows) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
            long pkId = rowObj.getLong("id");
            list.add(pkId);
        }
        this.getView().returnDataToParent(list);
        this.getView().invokeOperation("close");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchKey = search.getKey();
        if ("treesearchap".equals(searchKey)) {
            List treeNodes;
            IFormView view = this.getView();
            TreeView treeView = (TreeView)view.getControl(TREEVIEW);
            String oldSearchText = pageCache.get("old_tree_search_text_key");
            if (oldSearchText == null || !oldSearchText.equals(searchText)) {
                pageCache.put("old_tree_search_text_key", searchText);
                Hierarchy tree = (Hierarchy)SerializeHelper.unserialize((String)pageCache.get("orgproject_tree_key"));
                treeNodes = tree.getAllChildren(tree.getRootNode()).stream().map(rootNode -> ((DynamicObjectTreeNode)rootNode).getTreeNode().getChildren()).flatMap(Collection::stream).filter(child -> StringUtils.containsIgnoreCase((CharSequence)child.getText(), (CharSequence)searchText)).collect(Collectors.toList());
            } else {
                treeNodes = JSONArray.parseArray((String)pageCache.get("search_tree_result_key"), TreeNode.class);
            }
            TreeNode result = ProImportTaskListPlugin.getResultFromSearchResults(pageCache, treeNodes);
            if (result == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"ProImportTaskListPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                String parentId = result.getParentid();
                String nodeId = result.getId();
                String name = result.getText();
                TreeNode node = new TreeNode(parentId, nodeId, name);
                treeView.showNode(nodeId);
                treeView.focusNode(node);
                treeView.treeNodeClick(parentId, nodeId);
            }
        } else if (KEY_SEARCHAP.equals(searchKey)) {
            TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (nodeId != null && this.isProjectNode(nodeId)) {
                QFilter proNodeFilter = this.getProjectNodeFilter(nodeId);
                QFilter searchFilter = this.getSearchFilter(searchText);
                QFilter conditionFilter = proNodeFilter.and(searchFilter);
                this.showData(conditionFilter, true);
            } else {
                QFilter searchFilter = this.getSearchFilter(searchText);
                this.showData(searchFilter, false);
            }
        }
    }

    private static TreeNode getResultFromSearchResults(IPageCache pageCache, List<TreeNode> results) {
        TreeNode result = null;
        if (CollectionUtils.isNotEmpty(results)) {
            result = results.get(0);
            results.remove(result);
            pageCache.put("search_tree_result_key", JSONArray.toJSONString(results));
        }
        if (CollectionUtils.isEmpty(results)) {
            pageCache.remove("old_tree_search_text_key");
        }
        return result;
    }

    protected QFilter getSearchFilter(String searchText) {
        StringBuilder sb = new StringBuilder();
        sb.append('%').append(searchText).append('%');
        QFilter taskNameFilter = new QFilter("name", "like", (Object)sb.toString());
        QFilter controllevelFilter = new QFilter("controllevel.name", "like", (Object)sb.toString());
        return taskNameFilter.or(controllevelFilter);
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        return null;
    }

    public List<Object> getComPlexSearchList(SearchEnterEvent evt) {
        return null;
    }
}

