/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ProKeyNodeTaskPlugin
extends AbstractPlacsFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ProKeyNodeTaskPlugin.class);
    private static final String proF7 = "project_base";
    private static final String orgF7 = "org_base";
    private static final String dateF7 = "daterange";
    private static final String dateStart = "start_time";
    private static final String dateEnd = "end_time";
    private static final String taskFormId = "placs_procriticalnodes";

    protected String getProjectFormId() {
        return "bd_project";
    }

    protected String getTaskTypeFormId() {
        return "placs_tasktype";
    }

    protected String getTaskFormId() {
        return "placs_task";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit prof7 = (MulBasedataEdit)this.getControl(proF7);
        prof7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        prof7.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCustomData(this.filterData());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "end_time": {
                this.setCustomData(this.filterData());
                break;
            }
            case "org_base": {
                this.getModel().setValue(orgF7, null);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        FieldEdit fieldEdit = (FieldEdit)event.getSource();
        if (StringUtils.equals((CharSequence)proF7, (CharSequence)fieldEdit.getKey())) {
            this.setCustomData(this.filterData());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String name = args.getProperty().getName();
        if (proF7.equals(name)) {
            this.filterProject(args);
        }
    }

    protected void setCustomData(Object jsonData) {
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("pageIndex", 1);
        data.put("pageSize", 10);
        data.put("data", jsonData);
        customControl.setData(data);
    }

    protected void filterProject(BeforeF7SelectEvent args) {
        ListShowParameter lsp = (ListShowParameter)args.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        DynamicObjectCollection orgList = (DynamicObjectCollection)this.getModel().getValue(orgF7);
        if (orgList != null && orgList.size() > 0) {
            ArrayList<Object> orgPks = new ArrayList<Object>();
            for (DynamicObject org : orgList) {
                DynamicObject orgInfo = (DynamicObject)org.get("fbasedataid");
                orgPks.add(orgInfo.getPkValue());
            }
            QFilter orgFilter = new QFilter("useorg", "in", orgPks);
            qFilters.add(orgFilter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"ProKeyNodeTaskPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected JSONArray filterData() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Object prof7 = this.getModel().getValue(proF7);
        if (prof7 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProKeyNodeTaskPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection projectList = (DynamicObjectCollection)prof7;
        DynamicObjectType relaDT = projectList.getDynamicObjectType();
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds((IDataEntityType)relaDT, projectList.size());
        List<long[]> idList = Collections.singletonList(ids);
        qFilters.add(new QFilter("project.id", "in", (Object)ids));
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id,createtime desc", (int)1, (int)10);
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)this.getTaskTypeFormId(), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue())});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        this.filterDateRange(qFilters);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)this.getTaskFormId(), (String)"id,name,completionstatus,planstarttime,planendtime,absoluteduration,percent,expecttime,realendtime,responsibleperson,responsibledept,majortype,project.id", (QFilter[])qFilters.toArray(new QFilter[2]), (String)"createtime", (int)1, (int)10);
        HashMap<long[], JSONArray> map = new HashMap<long[], JSONArray>();
        for (DynamicObject task : tasks) {
            JSONArray jsonArray;
            int index = idList.indexOf(task.getDynamicObject("project").getPkValue());
            long[] id = idList.get(index);
            if (id == null) continue;
            if (map.get(id) != null) {
                jsonArray = (JSONArray)map.get(id);
                jsonArray.add((Object)this.revertToJsonObject(task));
                map.put(idList.get(index), jsonArray);
                continue;
            }
            jsonArray = new JSONArray();
            jsonArray.add((Object)this.revertToJsonObject(task));
            map.put(idList.get(index), jsonArray);
        }
        JSONArray proArray = new JSONArray();
        for (DynamicObject dynamicObject : projects) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", dynamicObject.get("id"));
            jsonObject.put("name", (Object)dynamicObject.getString("name"));
            JSONArray taskList = (JSONArray)map.get(dynamicObject.get("id"));
            if (taskList != null && taskList.size() == 10) {
                jsonObject.put("isPage", (Object)true);
                jsonObject.put("taskPage", (Object)1);
                jsonObject.put("taskPageSize", (Object)10);
            } else {
                jsonObject.put("isPage", (Object)false);
            }
            jsonObject.put("taskList", (Object)taskList);
            proArray.add((Object)jsonObject);
        }
        String data = JSON.toJSONString((Object)proArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        LOG.info("data", (Object)data);
        return proArray;
    }

    protected JSONObject nextProjectTask(String projectId, int pageIndex, int pageSize) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("project.id", "=", (Object)projectId));
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)this.getTaskTypeFormId(), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue())});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)this.getTaskFormId(), (String)"id,name,completionstatus,planstarttime,planendtime,absoluteduration,percent,expecttime,realendtime,responsibleperson,responsibledept,majortype,project.id", (QFilter[])qFilters.toArray(new QFilter[2]), (String)"createtime", (int)pageIndex, (int)pageSize);
        JSONArray taskList = new JSONArray();
        for (DynamicObject task : tasks) {
            taskList.add((Object)this.revertToJsonObject(task));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)projectId);
        if (taskList.size() == 10) {
            jsonObject.put("isPage", (Object)true);
            jsonObject.put("taskPage", (Object)pageIndex);
            jsonObject.put("taskPageSize", (Object)pageSize);
        } else {
            jsonObject.put("isPage", (Object)false);
        }
        jsonObject.put("taskList", (Object)taskList);
        return jsonObject;
    }

    protected JSONObject revertToJsonObject(DynamicObject task) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", task.get("id"));
        jsonObject.put("name", (Object)task.getString("name"));
        jsonObject.put("completionstatus", task.get("completionstatus"));
        jsonObject.put("planstarttime", (Object)task.getDate("planstarttime"));
        jsonObject.put("planendtime", (Object)task.getDate("planendtime"));
        jsonObject.put("absoluteduration", task.get("absoluteduration"));
        jsonObject.put("percent", task.get("percent"));
        jsonObject.put("expecttime", task.get("expecttime"));
        jsonObject.put("realendtime", (Object)task.getDate("realendtime"));
        jsonObject.put("responsibleperson", (Object)task.getDynamicObject("responsibleperson").getString("name"));
        jsonObject.put("responsibledept", (Object)task.getDynamicObject("responsibledept").getString("name"));
        jsonObject.put("majortype", (Object)task.getDynamicObject("majortype").getString("name"));
        return jsonObject;
    }

    protected DynamicObject[] getOrgProject() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter(orgF7, "=", (Object)RequestContext.get().getOrgId());
        qFilters.add(orgFilter);
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,createorg,org,useorg,ctrlstrategy,group,planbegindate,planenddate,prostatus,proaddress", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)1, (int)10);
        return projects;
    }

    protected JSONObject taskData(String projectId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("project.id", "=", (Object)projectId));
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)this.getTaskTypeFormId(), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue())});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)this.getTaskFormId(), (String)"id,name,completionstatus,planstarttime,planendtime,absoluteduration,percent,expecttime,realendtime,responsibleperson,responsibledept,majortype,project.id", (QFilter[])qFilters.toArray(new QFilter[0]));
        JSONArray taskList = new JSONArray();
        BigDecimal bigDecimal = new BigDecimal("0");
        for (DynamicObject task : tasks) {
            taskList.add((Object)this.revertToJsonObject(task));
            if (task.getBigDecimal("percent") == null) continue;
            bigDecimal = bigDecimal.add(task.getBigDecimal("percent"));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)projectId);
        if (taskList.size() > 0) {
            bigDecimal = bigDecimal.divide(new BigDecimal(taskList.size()), 2, 0);
            jsonObject.put("projectPercent", (Object)bigDecimal);
        }
        jsonObject.put("taskList", (Object)taskList);
        LOG.info("data", (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    protected void filterDateRange(List<QFilter> qFilters) {
        Date startTime = (Date)this.getModel().getValue(dateStart);
        Date endTime = (Date)this.getModel().getValue(dateEnd);
        if (startTime != null && endTime != null) {
            qFilters.add(new QFilter("createtime", ">=", (Object)startTime));
            qFilters.add(new QFilter("createtime", "<=", (Object)endTime));
        }
    }

    protected void toProjectDetail(Long projectId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("proId", projectId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }
}

