/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ProKeyNodesFormPlugin
extends AbstractPlacsFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String TABPAGE = "tabpage";
    private static final String SCALE = "scale";
    private static final Log LOG = LogFactory.getLog(ProKeyNodesFormPlugin.class);

    protected String getTaskTypeFormId() {
        return "placs_tasktype";
    }

    protected String getTaskFormId() {
        return "placs_task";
    }

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(TABPAGE, "tabpagepro");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object org = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object project = this.getView().getFormShowParameter().getCustomParam("proId");
        if (org != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)project, (String)this.getProjectFormId());
            this.getModel().setValue("org", object.getDynamicObject("userorg").getPkValue());
        }
        if (project != null) {
            this.getModel().setValue("project", project);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.beforeProjectF7(evt);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabkey = tabSelectEvent.getTabKey();
        if ("tabpagepro".equals(tabkey)) {
            this.getPageCache().put(TABPAGE, "tabpagepro");
        } else if ("tabpagetype".equals(tabkey)) {
            this.getPageCache().put(TABPAGE, "tabpagetype");
            this.showTaskByType();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        Date startTime = (Date)this.getModel().getValue("start_time");
        Date endTime = (Date)this.getModel().getValue("end_time");
        String tabkey = this.getPageCache().get(TABPAGE);
        if ("org".equals(propName)) {
            this.getModel().setValue("project", null);
        }
        if (org == null || project == null || startTime == null || endTime == null) {
            return;
        }
        if ("tabpagepro".equals(tabkey)) {
            this.keyNodeTaskData(project);
        } else if ("tabpagetype".equals(tabkey)) {
            this.showTaskByType();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String tabpage = this.getPageCache().get(TABPAGE);
        if ("tabpagetype".equals(tabpage) && "taskId".equals(eventName)) {
            this.showProPlanMonitor(e);
        }
    }

    protected void showTaskByType() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        Date startTime = (Date)this.getModel().getValue("start_time");
        Date endTime = (Date)this.getModel().getValue("end_time");
        if (org == null || project == null || startTime == null || endTime == null) {
            return;
        }
        List<QFilter> qFilters = this.getProFilter();
        if (qFilters == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e0b\u6ca1\u6709\u5df2\u53d1\u5e03\u7684\u4e3b\u9879\u8ba1\u5212\u7f16\u5236\u3002", (String)"ProKeyNodesFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter majorTypeFilter = new QFilter("majortype", "is not null", null).and("majortype", "!=", (Object)0);
        qFilters.add(majorTypeFilter);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])qFilters.toArray(new QFilter[0]));
        JSONObject data = this.convert2Data(tasks);
        CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap1");
        customControl.setData((Object)data);
    }

    protected List<QFilter> getProFilter() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        Date startTime = (Date)this.getModel().getValue("start_time");
        Date endTime = (Date)this.getModel().getValue("end_time");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter planTypeFilter = new QFilter("number", "=", (Object)"MASTERPLAN_S");
        DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{planTypeFilter});
        if (null != planType) {
            projectFilter.and(new QFilter("majortype", "=", planType.getPkValue()));
        }
        QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        projectFilter.and(planStatusFilter);
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"", (QFilter[])projectFilter.toArray());
        if (masterPlan == null) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter planFilter = new QFilter("planid", "=", masterPlan.getPkValue());
        qFilters.add(planFilter);
        QFilter time1 = new QFilter("planstarttime", ">=", (Object)startTime).and(new QFilter("planstarttime", "<=", (Object)endTime));
        QFilter time2 = new QFilter("planendtime", ">=", (Object)startTime).and(new QFilter("planendtime", "<=", (Object)endTime));
        QFilter timeFilter = time1.and(time2);
        qFilters.add(timeFilter);
        QFilter taskTypeFilter = new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue());
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id", (QFilter[])new QFilter[]{taskTypeFilter});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        return qFilters;
    }

    protected void beforeProjectF7(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            QFilter orgFilter = new QFilter("useorg", "=", org.getPkValue());
            beforeF7SelectEvent.getCustomQFilters().add(orgFilter);
        }
    }

    protected JSONObject convert2Data(DynamicObject[] tasks) {
        JSONObject data = new JSONObject();
        Date startTime = (Date)this.getModel().getValue("start_time");
        Date endTime = (Date)this.getModel().getValue("end_time");
        JSONArray scaleAll = this.convert2Scale(startTime, endTime);
        String scale = this.getPageCache().get(SCALE);
        if ("month".equals(scale)) {
            data.put(SCALE, (Object)0);
        } else {
            data.put(SCALE, (Object)1);
        }
        data.put("totaltimeslot", (Object)scaleAll);
        HashSet majortype = new HashSet();
        Arrays.stream(tasks).forEach(task -> majortype.add(task.getDynamicObject("majortype")));
        Arrays.sort(tasks, (task1, task2) -> {
            if (task1.getDate("planendtime").before(task2.getDate("planendtime"))) {
                return -1;
            }
            return 1;
        });
        HashMap dataTask = new HashMap();
        for (DynamicObject task3 : tasks) {
            if (!dataTask.containsKey(task3.getDynamicObject("majortype").getPkValue().toString())) {
                dataTask.put(task3.getDynamicObject("majortype").getPkValue().toString(), new ArrayList());
            }
            ((List)dataTask.get(task3.getDynamicObject("majortype").getPkValue().toString())).add(task3);
        }
        JSONObject[] majorObjects = new JSONObject[majortype.size()];
        int i = 0;
        for (DynamicObject majorType : majortype) {
            JSONObject majorObject = new JSONObject();
            majorObject.put("id", majorType.getPkValue());
            majorObject.put("name", (Object)majorType.getLocaleString("name").getLocaleValue());
            List majorTasks = (List)dataTask.get(majorType.getPkValue().toString());
            majorObject.put("amount", (Object)majorTasks.size());
            if (majorTasks.size() <= 0) continue;
            Map<String, Object> map = this.convert2Task(majorTasks);
            majorObject.put("percent", map.get("percent"));
            majorObject.put("taskList", map.get("taskList"));
            majorObjects[i] = majorObject;
            ++i;
        }
        data.put("majortype", (Object)majorObjects);
        return data;
    }

    protected JSONArray convert2Scale(Date startTime, Date endTime) {
        JSONArray dateStr = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        while (calendar.getTime().before(endTime)) {
            String str = sdf.format(calendar.getTime());
            dateStr.add((Object)str);
            calendar.add(2, 1);
        }
        if (!dateStr.contains((Object)sdf.format(endTime))) {
            dateStr.add((Object)sdf.format(endTime));
        }
        this.getPageCache().put(SCALE, "month");
        if (dateStr.size() >= 12) {
            JSONArray quarters = new JSONArray();
            String quarter = "";
            for (Object str : dateStr) {
                String month;
                String[] dates = str.toString().split("-");
                switch (month = dates[1]) {
                    case "01": 
                    case "02": 
                    case "03": {
                        quarter = dates[0] + "-01";
                        break;
                    }
                    case "04": 
                    case "05": 
                    case "06": {
                        quarter = dates[0] + "-02";
                        break;
                    }
                    case "07": 
                    case "08": 
                    case "09": {
                        quarter = dates[0] + "-03";
                        break;
                    }
                    case "10": 
                    case "11": 
                    case "12": {
                        quarter = dates[0] + "-04";
                    }
                }
                if (quarters.contains((Object)quarter)) continue;
                quarters.add((Object)quarter);
            }
            this.getPageCache().put(SCALE, "quarter");
            return quarters;
        }
        return dateStr;
    }

    protected String convert2Scale(Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String str = sdf.format(endTime);
        String[] dates = str.split("-");
        String month = dates[1];
        String quarter = "";
        switch (month) {
            case "01": 
            case "02": 
            case "03": {
                quarter = dates[0] + "-01";
                break;
            }
            case "04": 
            case "05": 
            case "06": {
                quarter = dates[0] + "-02";
                break;
            }
            case "07": 
            case "08": 
            case "09": {
                quarter = dates[0] + "-03";
                break;
            }
            case "10": 
            case "11": 
            case "12": {
                quarter = dates[0] + "-04";
            }
        }
        return quarter;
    }

    protected Map<String, Object> convert2Task(List<DynamicObject> majorTasks) {
        int percent = 0;
        String scale = this.getPageCache().get(SCALE);
        ArrayList<JSONObject> taskList = new ArrayList<JSONObject>(10);
        JSONObject taskGroup = new JSONObject();
        JSONArray timescale = new JSONArray();
        JSONArray taskinfo = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject task : majorTasks) {
            percent += task.getInt("percent");
            JSONObject dataTask = new JSONObject();
            dataTask.put("id", (Object)task.getPkValue().toString());
            dataTask.put("name", (Object)task.getLocaleString("name").getLocaleValue());
            dataTask.put("completionstatus", task.get("completionstatus"));
            dataTask.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
            dataTask.put("planendtime", (Object)sdf.format(task.getDate("planendtime")));
            dataTask.put("absoluteduration", (Object)task.getInt("absoluteduration"));
            dataTask.put("percent", task.get("percent"));
            if (null != task.getDate("expecttime")) {
                dataTask.put("expecttime", (Object)sdf.format(task.getDate("expecttime")));
            } else {
                dataTask.put("expecttime", null);
            }
            if (null != task.getDate("realendtime")) {
                dataTask.put("realendtime", (Object)sdf.format(task.getDate("realendtime")));
            } else {
                dataTask.put("realendtime", null);
            }
            dataTask.put("responsibleperson", (Object)task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue());
            dataTask.put("responsibledept", (Object)task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue());
            if ("month".equals(scale)) {
                timescale.add((Object)sdf.format(task.getDate("planendtime")));
            } else {
                String formatScale = this.convert2Scale(task.getDate("planendtime"));
                timescale.add((Object)formatScale);
                dataTask.put("quarter", (Object)formatScale);
            }
            taskinfo.add((Object)dataTask);
            if (this.identifyReportRecord(task)) continue;
            taskGroup.put("timescale", (Object)timescale);
            taskGroup.put("taskinfo", (Object)taskinfo);
            taskList.add(taskGroup);
            taskGroup = new JSONObject();
            timescale = new JSONArray();
            taskinfo = new JSONArray();
        }
        if (taskinfo.size() > 0) {
            taskGroup.put("timescale", (Object)timescale);
            taskGroup.put("taskinfo", (Object)taskinfo);
            taskList.add(taskGroup);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("percent", percent / majorTasks.size());
        map.put("taskList", taskList);
        return map;
    }

    protected boolean identifyReportRecord(DynamicObject task) {
        int percent = task.getInt("percent");
        if (percent == 0) {
            return false;
        }
        QFilter taskid = new QFilter("task", "=", (Object)Long.valueOf(task.getPkValue().toString()));
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
        if (taskReportObjs.length == 0) {
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            if (sourceTask != null) {
                QFilter sameSourceTaskFilter = new QFilter("sourcetask", "=", (Object)sourceTask.getPkValue().toString());
                QFilter taskStatus = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] sameSourceTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", (QFilter[])new QFilter[]{sameSourceTaskFilter, taskStatus});
                if (sameSourceTasks == null || sameSourceTasks.length == 0) {
                    return false;
                }
                ArrayList<String> taskIds = new ArrayList<String>(sameSourceTasks.length);
                for (DynamicObject stask : sameSourceTasks) {
                    taskIds.add(stask.getPkValue().toString());
                }
                taskid = new QFilter("task", "in", taskIds);
                taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])new QFilter[]{taskid, taskreportStatus}, (String)"auditdate desc", (int)1);
                return null != taskReportObjs && taskReportObjs.length != 0;
            }
            return false;
        }
        return true;
    }

    protected void showProPlanMonitor(CustomEventArgs args) {
        Long taskId = Long.valueOf(args.getKey());
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanmonitor"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        parameter.setCustomParam("project", task.getDynamicObject("project").getPkValue());
        parameter.setCustomParam("taskId", (Object)task.getPkValue().toString());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected JSONObject keyNodeTaskData(DynamicObject project) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("project.id", "=", project.getPkValue()));
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)this.getTaskTypeFormId(), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue())});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)this.getTaskFormId(), (String)"id,name,completionstatus,planstarttime,planendtime,absoluteduration,percent,expecttime,realendtime,responsibleperson,responsibledept,majortype,project.id", (QFilter[])qFilters.toArray(new QFilter[0]));
        JSONArray taskList = new JSONArray();
        BigDecimal bigDecimal = new BigDecimal("0");
        for (DynamicObject task : tasks) {
            taskList.add((Object)this.revertToJsonObject(task));
            if (task.getBigDecimal("percent") == null) continue;
            bigDecimal = bigDecimal.add(task.getBigDecimal("percent"));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", project.getPkValue());
        jsonObject.put("name", (Object)project.getString("name"));
        if (taskList.size() > 0) {
            bigDecimal = bigDecimal.divide(new BigDecimal(taskList.size()), 2, 0);
            jsonObject.put("projectPercent", (Object)bigDecimal);
        }
        jsonObject.put("taskList", (Object)taskList);
        LOG.info("data", (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    protected JSONObject revertToJsonObject(DynamicObject task) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", task.get("id"));
        jsonObject.put("name", (Object)task.getString("name"));
        jsonObject.put("completionstatus", task.get("completionstatus"));
        jsonObject.put("planstarttime", (Object)task.getDate("planstarttime"));
        jsonObject.put("planendtime", (Object)task.getDate("planendtime"));
        jsonObject.put("absoluteduration", task.get("absoluteduration"));
        jsonObject.put("percent", task.get("percent"));
        jsonObject.put("expecttime", task.get("expecttime"));
        jsonObject.put("realendtime", (Object)task.getDate("realendtime"));
        jsonObject.put("responsibleperson", (Object)task.getDynamicObject("responsibleperson").getString("name"));
        jsonObject.put("responsibledept", (Object)task.getDynamicObject("responsibledept").getString("name"));
        jsonObject.put("majortype", (Object)task.getDynamicObject("majortype").getString("name"));
        return jsonObject;
    }
}

