/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;
import kd.pccs.placs.formplugin.model.MulitTxType;

public class ProMeetTaskMonitorListPlugin
extends AbstractPlacsListPlugin
implements HyperLinkClickListener {
    public static final String formBillId = "bd_project";
    private static final int DEFAULT_KEY_TIMEOUT = 36000;
    private static Control controlStore = null;
    private static FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String TASKNAME = "taskname";
    private static final String FORM_ID = "formId";
    private static final String TIME_KEY = "datefield";
    private static final Log logger = LogFactory.getLog(ProMeetTaskMonitorListPlugin.class);
    private static final int ROW = 7;
    private static final int COL = 8;
    private static String[] COLUMNKEY = new String[]{"taskname", "completionstatus", "tasksource", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "completedescription", "pretaskname", "planstarttime", "planendtime", "realendtime", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "cooperationdeptname"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"ProMeetTaskMonitorListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"ProMeetTaskMonitorListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90", (String)"ProMeetTaskMonitorListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"ProMeetTaskMonitorListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"ProMeetTaskMonitorListPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"ProMeetTaskMonitorListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"ProMeetTaskMonitorListPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"ProMeetTaskMonitorListPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6(%)", (String)"ProMeetTaskMonitorListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u60c5\u51b5\u8bf4\u660e", (String)"ProMeetTaskMonitorListPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"ProMeetTaskMonitorListPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"ProMeetTaskMonitorListPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"ProMeetTaskMonitorListPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProMeetTaskMonitorListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"ProMeetTaskMonitorListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"ProMeetTaskMonitorListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"ProMeetTaskMonitorListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"ProMeetTaskMonitorListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0])};

    protected String setProjectBizOrgFileName() {
        return "createorg";
    }

    protected String getProjectFormId() {
        return formBillId;
    }

    protected DynamicObject[] getProjByOrgList(List<Long> orgIdList) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (orgIdList != null && orgIdList.size() > 0) {
            QFilter orgFilter = new QFilter(this.setProjectBizOrgFileName(), "in", orgIdList);
            qFilters.add(orgFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        return this.queryProjects(qFilters);
    }

    protected DynamicObject[] queryProjects(List<QFilter> qFilters) {
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,billname,billno,billstatus", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return projects;
    }

    public List<ComboItem> buildProComboItems(List<Long> orgList) {
        DynamicObject[] projects = this.getProjByOrgList(orgList);
        return this.loadProComboItems(projects);
    }

    protected List<ComboItem> loadProComboItems(DynamicObject[] projects) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject project : projects) {
            ComboItem item = new ComboItem();
            item.setId(project.getPkValue().toString());
            item.setCaption(new LocaleString(project.getString("name")));
            item.setValue(project.getPkValue().toString());
            combos.add(item);
        }
        return combos;
    }

    protected void setProjectColDefaultByInit(CommonFilterColumn projectColumn, List<ComboItem> proComboItems) {
        projectColumn.setComboItems(proComboItems);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String beFirst = this.getPageCache().get("beFirst");
        if (beFirst == null || beFirst.equals("true")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
            int proIndex = -1;
            int orgIndex = -1;
            List items = filterGridView.getItems();
            for (int i = 0; i < items.size(); ++i) {
                CommonFilterColumn filterColumn = (CommonFilterColumn)items.get(i);
                if (filterColumn.getFieldName().equals("project.org.name") || filterColumn.getFieldName().equals("project.createorg.name")) {
                    orgIndex = i;
                }
                if (!filterColumn.getFieldName().equals("project.name")) continue;
                proIndex = i;
                break;
            }
            if (customParams.get("org") != null && orgIndex >= 0) {
                ((CommonFilterColumn)filterGridView.getItems().get(orgIndex)).setDefaultValue(customParams.get("org").toString());
            }
            if (customParams.get("project") != null && proIndex >= 0) {
                ((CommonFilterColumn)filterGridView.getItems().get(proIndex)).setDefaultValue(customParams.get("project").toString());
            }
            this.getPageCache().put("beFirst", "false");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        String btnNumber = key.split("buttonap_")[1];
        String value = this.getModel().getValue("textfield_" + btnNumber).toString();
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData(TREEENTRYENTITY);
        Date parse = null;
        try {
            parse = dfnyr.parse(value);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        String taskIdsStr = this.getPageCache().get("taskIds");
        if (!StringUtils.isEmpty((CharSequence)taskIdsStr)) {
            DynamicObject[] tasks;
            String[] taskIds = taskIdsStr.split(",");
            List collect = Arrays.stream(taskIds).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            for (DynamicObject task : tasks = BusinessDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))) {
                String planstarttime = task.get("planstarttime").toString();
                Date starttimeFrom = null;
                try {
                    starttimeFrom = dfnyr.parse(planstarttime);
                    if (!starttimeFrom.equals(parse)) continue;
                    int entryRow = model.createNewEntryRow(TREEENTRYENTITY);
                    this.getModel().setValue(TASKNAME, task.getPkValue(), entryRow);
                }
                catch (ParseException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    protected void showView() {
        boolean isGird = Boolean.parseBoolean(this.getPageCache().get("isGird"));
        boolean isCalendar = Boolean.parseBoolean(this.getPageCache().get("isCalendar"));
        if (isGird) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billlistap"});
        }
        if (isCalendar) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billlistap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("isGird")) && StringUtils.isEmpty((CharSequence)this.getPageCache().get("isCalendar"))) {
            this.getPageCache().put("isGird", "true");
            this.getPageCache().put("isCalendar", "false");
            this.showView();
        }
    }

    private String getFileName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u4f1a\u8bae\u8ddf\u8e2a", (String)"ProMeetTaskMonitorListPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"ProMeetTaskMonitorListPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.addClickListeners(new String[]{"buttonap_" + i + "_" + j});
            }
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)TransactionTypeEnum.MEETING.getValue());
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"), (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        String routeKey = MetaDataUtil.getDT((String)this.getAppId(), (String)"transactiontype").getDBRouteKey();
        String sql = " select fpkid,fentryid,fbasedataid from t_" + this.getAppId() + "_multitxtype where fbasedataid=? ";
        ArrayList<Object> paramsList = new ArrayList<Object>(1);
        List mulitTxTypes = new ArrayList();
        if (txType != null) {
            paramsList.add(txType.getPkValue());
            mulitTxTypes = (List)DB.query((DBRoute)new DBRoute(routeKey), (String)sql, (Object[])paramsList.toArray(new Object[paramsList.size()]), (ResultSetHandler)new ResultSetHandler<List<MulitTxType>>(){

                public List<MulitTxType> handle(ResultSet rs) throws Exception {
                    ArrayList<MulitTxType> result = new ArrayList<MulitTxType>(10);
                    while (rs.next()) {
                        MulitTxType tx = new MulitTxType();
                        tx.setfEntryId(rs.getLong("fentryid"));
                        result.add(tx);
                    }
                    return result;
                }
            });
        }
        List taskIds = mulitTxTypes.stream().map(mt -> mt.getfEntryId()).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        latestTaskFilter.and(taskFilter);
        qFilters.add(latestTaskFilter);
        for (int i = 0; i < qFilters.size(); ++i) {
            this.getPageCache().put("biz" + i, ((QFilter)qFilters.get(i)).toSerializedString());
        }
        Date datefield = (Date)this.getModel().getValue(TIME_KEY);
        this.setCalendarTaskIds(datefield);
        this.setCalendar(datefield);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date datefield;
        if (TIME_KEY.equals(e.getProperty().getName()) && (datefield = (Date)this.getModel().getValue(TIME_KEY)) != null) {
            this.setCalendarTaskIds(datefield);
            this.setCalendar(datefield);
        }
    }

    protected void setCalendarTaskIds(List<QFilter> qFilters) {
        ArrayList<QFilter> taskFilters = new ArrayList<QFilter>(qFilters);
        Iterator iterator = taskFilters.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (!next.getProperty().equals("planstarttime")) continue;
            iterator.remove();
        }
        Date today = new Date();
        Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)today);
        Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)today);
        QFilter timeFilter = new QFilter("planstarttime", ">=", (Object)firstDayOfThisMonth).and("planstarttime", "<=", (Object)lastDayOfThisMonth);
        taskFilters.add(timeFilter);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])taskFilters.toArray(new QFilter[taskFilters.size()]));
        List ids = Stream.of(tasks).map(o -> ((Long)o.getPkValue()).toString()).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.getPageCache().put("taskIds", String.join((CharSequence)",", ids));
        } else {
            this.getPageCache().remove("taskIds");
        }
    }

    protected void setCalendar(Date date) {
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> infoMap = new HashMap<String, String>(16);
        String taskIdsStr = this.getPageCache().get("taskIds");
        if (!StringUtils.isEmpty((CharSequence)taskIdsStr)) {
            String[] taskIds = taskIdsStr.split(",");
            List collect = Arrays.stream(taskIds).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            if (taskIds.length > 0) {
                DynamicObject[] tasks;
                for (DynamicObject task : tasks = BusinessDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))) {
                    infoMap.put(task.getPkValue().toString(), task.get("planstarttime").toString() + "@22KD&&@" + task.getString("name"));
                }
            }
        }
        int index = 1;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                this.getModel().setValue("textfield_" + i + "_" + j, (Object)dfnyr.format(calendar.getTime()));
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("<div title=\"\"><div style=\"text-align:right;\"><span style=\"width:28px;font-size:16px;height:28px;color:#333333;border-radius:50%;display:inline-block;line-height:28px;text-align:center;");
                if (index < weekday || index - weekday - maxday + 1 > 0) {
                    sBuilder.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime()))) {
                    sBuilder.append("background:rgba(95,137,243,1);");
                    sBuilder.append("color:#ffffff;");
                }
                sBuilder.append("\">").append(dfdd.format(calendar.getTime())).append("</span>").append("</div>");
                int k = 0;
                for (Map.Entry entry : infoMap.entrySet()) {
                    String value = (String)entry.getValue();
                    String[] split = value.split("@22KD&&@");
                    String starttime = split[0];
                    String taskname = split[1];
                    int tasknamelength = taskname.length();
                    String tasknametitle = null;
                    tasknametitle = tasknamelength > 6 ? taskname.substring(0, 6) + "..." : taskname;
                    Date starttimeFrom = null;
                    try {
                        starttimeFrom = dfnyr.parse(starttime);
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                    if (!dfnyr.format(starttimeFrom).equals(dfnyr.format(calendar.getTime()))) continue;
                    sBuilder.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                    sBuilder.append("<span style=\"background:#FC8555;width:4px;height:4px;display:inline-block;font-size:large;\"></span>");
                    sBuilder.append("<span style=\"color:rgba(51,51,51,1);margin-left:4px;font-size:large;\">").append(tasknametitle).append("</span>");
                    sBuilder.append("</div>");
                    if (++k <= 1) continue;
                    break;
                }
                sBuilder.append("</div></div>");
                html.setConent(sBuilder.toString());
                ++index;
            }
        }
    }

    protected void setCalendarTaskIds(Date date) {
        ArrayList<QFilter> taskFilters = new ArrayList<QFilter>();
        List<String> cacheKeys = this.getPageCache().getAll().keySet().stream().filter(s -> s.startsWith("biz")).collect(Collectors.toList());
        IPageCache pageCache = this.getPageCache();
        cacheKeys.forEach(key -> taskFilters.add(QFilter.fromSerializedString((String)pageCache.get(key))));
        Iterator iterator = taskFilters.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (!next.getProperty().equals("planstarttime") && !next.getProperty().equals("planendtime")) continue;
            iterator.remove();
        }
        Date today = date;
        Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)today);
        Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)today);
        QFilter timeFilter = new QFilter("planstarttime", ">=", (Object)firstDayOfThisMonth).and("planstarttime", "<=", (Object)lastDayOfThisMonth).or(new QFilter("planendtime", ">=", (Object)firstDayOfThisMonth).and("planendtime", "<=", (Object)lastDayOfThisMonth));
        taskFilters.add(timeFilter);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])taskFilters.toArray(new QFilter[taskFilters.size()]));
        List ids = Stream.of(tasks).map(o -> ((Long)o.getPkValue()).toString()).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.getPageCache().put("taskIds", String.join((CharSequence)",", ids));
        } else {
            this.getPageCache().remove("taskIds");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if ("export".equals(operateKey)) {
            this.doExportExcel(selectedRows);
        }
        if ("switchcalendar".equals(operateKey)) {
            this.doSwitchcalendar();
        }
        if ("switchlist".equals(operateKey)) {
            this.doSwitchlist();
        }
    }

    protected void doSwitchlist() {
        this.getPageCache().put("isCalendar", "false");
        this.getPageCache().put("isGird", "true");
        this.showView();
    }

    protected void doSwitchcalendar() {
        this.getPageCache().put("isCalendar", "true");
        this.getPageCache().put("isGird", "false");
        Date datefield = (Date)this.getModel().getValue(TIME_KEY);
        this.setCalendar(datefield);
        this.showView();
    }

    private void doExportExcel(ListSelectedRowCollection selectedRows) {
        if (!selectedRows.isEmpty()) {
            DynamicObject[] tasks;
            JSONArray data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (DynamicObject[] selectedRow : selectedRows) {
                Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                taskIds.add(primaryKeyValue);
            }
            for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)})) {
                JSONObject obj = new JSONObject();
                obj.put(COLUMNKEY[0], (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[1], (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                obj.put(COLUMNKEY[2], task.getDynamicObject("tasksource") == null ? null : task.getDynamicObject("tasksource").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[3], task.getDynamicObject("project") == null ? null : task.getDynamicObject("project").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[4], task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[5], task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[6], task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[7], (Object)task.getInt("absoluteduration"));
                obj.put(COLUMNKEY[8], (Object)task.getBigDecimal("percent").setScale(2));
                obj.put(COLUMNKEY[9], (Object)task.getString("completedescription"));
                obj.put(COLUMNKEY[10], task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[11], (Object)sdf.format(task.getDate("planstarttime")));
                obj.put(COLUMNKEY[12], (Object)sdf.format(task.getDate("planendtime")));
                obj.put(COLUMNKEY[13], task.getDate("realendtime") == null ? null : sdf.format(task.getDate("realendtime")));
                obj.put(COLUMNKEY[14], task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[15], task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                List names = cooPersons.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                obj.put(COLUMNKEY[16], (Object)String.join((CharSequence)";", names));
                DynamicObjectCollection cooDepts = task.getDynamicObjectCollection("multicooperationdept");
                List deptNames = cooDepts.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                obj.put(COLUMNKEY[17], (Object)String.join((CharSequence)";", deptNames));
                data.add((Object)obj);
            }
            String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
            this.getView().download(url);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ProMeetTaskMonitorListPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void showTaskView(Map<String, Object> map, HyperLinkClickArgs args, Object focusRowPkId, String activedTab) {
        map.put(FORM_ID, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
        map.put("pkId", focusRowPkId.toString());
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setAppId(this.getAppId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (StringUtils.isNotBlank((CharSequence)activedTab)) {
            parameter.setCustomParam("activedTab", (Object)activedTab);
        }
        this.getView().showForm(parameter);
        args.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        ListView view = (ListView)this.getView();
        Object focusRowPkId = view.getFocusRowPkId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"name")) {
            this.showTaskView(map, args, focusRowPkId, null);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            this.showTaskView(map, args, focusRowPkId, "meetresolution");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        String fieldName = arg.getFieldName();
        int rowIndex = arg.getRowIndex();
        DynamicObject fieldValue = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
        this.openUpdateParameter(fieldValue);
    }

    protected void openUpdateParameter(DynamicObject task) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(task.getPkValue());
        showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

