/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class ProOperationalReportPlugin
extends AbstractPlacsBillPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Long TASKTYPE_CRUXNODE_ID = 681750946157443072L;
    private static final String chartTitleName = "chartTitleName";
    private static final String planEnd = "planEnd";
    private static final String unStart = "unStart";
    private static final String progressing = "progressing";
    private static final String onTimeEnd = "onTimeEnd";
    private static final String overTimeEnd = "overTimeEnd";
    private static final String overTimeNotEnd = "overTimeNotEnd";
    private static final String estimateDelay = "estimateDelay";
    private static final String xAxisList = "xAxisList";
    private static final String realDataList = "realDataList";
    private static final String planEndQtyList = "planEndList";
    private static final String leftpiedata = "leftpiedata";
    private static final String rightpiedata = "rightpiedata";
    private static final String leftbardata = "leftbardata";
    private static final String rightbardata = "rightbardata";
    private static final String colorap = "colorap";
    private static final String tasknamelabel = "tasknamelabel";
    private static final String planendtimeap = "planendtimeap";
    private static final String cruxtasknodeap = "cruxtasknodeap";
    private static final String rightarrowap = "rightarrowap";
    private static final String leftarrowap = "leftarrowap";
    private static final String unStartTaskIds = "unStartTaskIds";
    private static final String progressingTaskIds = "progressingTaskIds";
    private static final String onTimeEndTaskIds = "onTimeEndTaskIds";
    private static final String overTimeEndTaskIds = "overTimeEndTaskIds";
    private static final String overTimeNotEndTaskIds = "overTimeNotEndTaskIds";
    private static final String estimateDelayTaskIds = "estimateDelayTaskIds";
    private static final String cLevelPlanEndTaskIds = "cLevelPlanEndTaskIds";
    private static final String cLevelRealEndTaskIds = "cLevelRealEndTaskIds";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object project = this.getView().getFormShowParameter().getCustomParam("projectId");
        if (project != null) {
            this.getModel().setValue("project", project);
        }
    }

    protected void generateBillno() {
        Date creatime = (Date)this.getModel().getValue("createtime");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(creatime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        QFilter timeFilter = new QFilter("createtime", ">=", (Object)calendar.getTime());
        timeFilter.and("createtime", "<=", (Object)creatime);
        DynamicObjectCollection query = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"), (String)"id,billname", (QFilter[])new QFilter[]{timeFilter});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String format = simpleDateFormat.format(creatime.getTime());
        String billno = "POR-" + format + "-" + (query.size() + 1);
        this.getModel().setValue("billno", (Object)billno);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.generateBillno();
        this.setTimeRange();
        for (int i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalanalysisap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cruxap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"processap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"thiscycleap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nextcycleap"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
        }
        DynamicObject thisModel = this.getModel().getDataEntity();
        boolean isFormDb = thisModel.getDataEntityState().getFromDatabase();
        if (isFormDb) {
            DynamicObjectCollection progessEntry;
            this.updateChart();
            this.statisticsTaskCount();
            this.getView().setVisible(Boolean.TRUE, new String[]{"cruxap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"thiscycleap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nextcycleap"});
            DynamicObjectCollection dataDetailCol = this.getModel().getEntryEntity("datadetailentry");
            if (dataDetailCol == null || dataDetailCol.size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datadetalap"});
            }
            if ((progessEntry = this.getModel().getEntryEntity("progressentry")) != null && progessEntry.size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"processap"});
            }
            DynamicObjectCollection cruxNodeCol = this.getModel().getEntryEntity("cruxnodeentry");
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
            for (int i = 0; i < cruxNodeCol.size(); ++i) {
                DynamicObject task = ((DynamicObject)cruxNodeCol.get(i)).getDynamicObject("cruxtask");
                if (task == null) continue;
                taskList.add(task);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
            this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
            if (taskList.size() == 0) {
                return;
            }
            if (taskList.size() > 10) {
                this.getPageCache().put("beginIndex", "0");
                this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
            }
            this.updateCruxFlex(taskList.toArray(new DynamicObject[taskList.size()]));
            this.getModel().setDataChanged(false);
        } else {
            DynamicObject project = thisModel.getDynamicObject("project");
            if (project != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
                this.updateTotalData("project");
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
                this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
            }
        }
        this.updateDataDetailEntryName();
        this.updateEntryColor();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("cruxnodeentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl("thiscyctaskentry");
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Chart pieChart1 = (Chart)this.getControl("thismonthpiechart");
        pieChart1.addClickListener((ClickListener)this);
        Chart pieChart2 = (Chart)this.getControl("totalpiechart");
        pieChart2.addClickListener((ClickListener)this);
        Chart barChart1 = (Chart)this.getControl("thismonthbarchart");
        barChart1.addClickListener((ClickListener)this);
        Chart barChart2 = (Chart)this.getControl("totalbarchart");
        barChart2.addClickListener((ClickListener)this);
        EntryGrid dataDetailEntryGrid = (EntryGrid)this.getControl("datadetailentry");
        dataDetailEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)"cruxtaskname", (CharSequence)fieldName)) {
            this.cruxTaskLinkClick(rowIndex);
        } else if (StringUtils.equals((CharSequence)"thiscycletaskname", (CharSequence)fieldName)) {
            this.thisCycleTaskLinkClick(rowIndex);
        } else {
            this.detailEntryCellLinkClick(rowIndex, fieldName);
        }
    }

    protected void detailEntryCellLinkClick(int rowIndex, String completeStatus) {
        DynamicObject majortype = (DynamicObject)this.getModel().getValue("majortype", rowIndex);
        String majorTypeId = majortype.getPkValue().toString();
        String datadetail = (String)this.getModel().getValue("datadetail");
        Map datadetailMap = (Map)SerializationUtils.fromJsonString((String)datadetail, Map.class);
        Map taskIdsMap = (Map)datadetailMap.get(majorTypeId);
        String taskIds = (String)taskIdsMap.get(completeStatus);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskIds", taskIds);
        paramMap.put("formId", this.getAppId() + "_tasklist");
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected void thisCycleTaskLinkClick(int rowIndex) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        DynamicObject task = (DynamicObject)this.getModel().getValue("thiscycletask", rowIndex);
        if (task != null) {
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            BigDecimal version = (BigDecimal)this.getModel().getValue("thisversion", rowIndex);
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            if (sourceTask != null) {
                QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
                QFilter versionFilter = new QFilter("version", "=", (Object)version);
                DynamicObject versionTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceTaskFilter, versionFilter});
                if (versionTask != null) {
                    paramMap.put("pkId", versionTask.getPkValue().toString());
                }
            }
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void cruxTaskLinkClick(int rowIndex) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        DynamicObject task = (DynamicObject)this.getModel().getValue("cruxtask", rowIndex);
        if (task != null) {
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            BigDecimal version = (BigDecimal)this.getModel().getValue("cruxversion", rowIndex);
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            if (sourceTask != null) {
                QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
                QFilter versionFilter = new QFilter("version", "=", (Object)version);
                DynamicObject versionTask = QueryServiceHelper.queryOne((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceTaskFilter, versionFilter});
                if (versionTask != null) {
                    paramMap.put("pkId", versionTask.getString("id"));
                }
            }
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected boolean isExistOne() {
        Date lastDayInReportDate;
        Date firstDayInReportDate;
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return false;
        }
        Date reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        QFilter largeFirstDayFilter = null;
        QFilter lessLastDayFilter = null;
        if (StringUtils.equals((CharSequence)"01", (CharSequence)reportType)) {
            firstDayInReportDate = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            lastDayInReportDate = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            largeFirstDayFilter = new QFilter("reportcycle", ">=", (Object)firstDayInReportDate);
            lessLastDayFilter = new QFilter("reportcycle", "<", (Object)lastDayInReportDate);
        } else {
            firstDayInReportDate = DateUtil.getThisWeekMonday((Date)reportDate);
            lastDayInReportDate = DateUtil.getThisWeekSunDay((Date)reportDate);
            largeFirstDayFilter = new QFilter("reportcycle", ">=", (Object)firstDayInReportDate);
            lessLastDayFilter = new QFilter("reportcycle", "<", (Object)lastDayInReportDate);
        }
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter reportTypeFilter = new QFilter("reporttype", "=", (Object)reportType);
        boolean fromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        boolean isExist = false;
        if (fromDb) {
            QFilter notSelfFilter = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"), (QFilter[])new QFilter[]{projectFilter, reportTypeFilter, largeFirstDayFilter, lessLastDayFilter, notSelfFilter});
        } else {
            isExist = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"), (QFilter[])new QFilter[]{projectFilter, reportTypeFilter, largeFirstDayFilter, lessLastDayFilter});
        }
        return isExist;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submitandnew": {
                boolean isExist = this.isExistOne();
                if (!isExist) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5728\u8be5\u5468\u671f\u4e0b\uff0c\u5df2\u7ecf\u5b58\u5728\u4e86\u4e00\u4efd\u9879\u76ee\u8fd0\u8425\u62a5\u544a\uff0c\u4e0d\u80fd\u91cd\u590d\u4fdd\u5b58\u3002", (String)"ProOperationalReportPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            case "precruxnode": {
                this.preCruxNode();
                break;
            }
            case "nextcruxnode": {
                this.nextCruxNode();
                break;
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            long orgId = RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)orgId);
        }
    }

    protected void nextCruxNode() {
        this.getView().setVisible(Boolean.TRUE, new String[]{leftarrowap});
        String beginIndex = this.getPageCache().get("beginIndex");
        Integer beginRow = Integer.valueOf(beginIndex);
        DynamicObjectCollection cruxEntry = this.getModel().getEntryEntity("cruxnodeentry");
        Integer n = beginRow;
        Integer n2 = beginRow = Integer.valueOf(beginRow + 1);
        if (cruxEntry.size() - beginRow > 10) {
            this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
        }
        DynamicObject[] taskArr = new DynamicObject[10];
        for (int i = 0; i < 10; ++i) {
            taskArr[i] = ((DynamicObject)cruxEntry.get(i + beginRow)).getDynamicObject("cruxtask");
        }
        this.updateCruxFlex(taskArr);
        this.getPageCache().put("beginIndex", beginRow.toString());
    }

    protected void preCruxNode() {
        this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
        String beginIndex1 = this.getPageCache().get("beginIndex");
        Integer beginRow1 = Integer.valueOf(beginIndex1);
        DynamicObjectCollection cruxEntry1 = this.getModel().getEntryEntity("cruxnodeentry");
        Integer n = beginRow1;
        Integer n2 = beginRow1 = Integer.valueOf(beginRow1 - 1);
        if (beginRow1 > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{leftarrowap});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
        }
        DynamicObject[] taskArr1 = new DynamicObject[10];
        for (int i = 0; i < 10; ++i) {
            taskArr1[i] = ((DynamicObject)cruxEntry1.get(i + beginRow1)).getDynamicObject("cruxtask");
        }
        this.updateCruxFlex(taskArr1);
        this.getPageCache().put("beginIndex", beginRow1.toString());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    protected void autoName() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        String reportType = (String)this.getModel().getValue("reporttype");
        Date startTime = (Date)this.getModel().getValue("STARTTIME");
        if (project == null || reportType == null || startTime == null) {
            return;
        }
        int date = startTime.getDate();
        String typeName = null;
        String weekName = "";
        switch (reportType) {
            case "01": {
                typeName = ResManager.loadKDString((String)"\u6708\u62a5", (String)"ProOperationalReportPlugin_27", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "02": {
                int week = date / 7 + (date % 7 <= 1 ? 1 : 2);
                weekName = String.format(ResManager.loadKDString((String)"\u7b2c%s\u5468", (String)"ProOperationalReportPlugin_30", (String)"pccs-placs-formplugin", (Object[])new Object[0]), week);
                typeName = ResManager.loadKDString((String)"\u5468\u62a5", (String)"ProOperationalReportPlugin_29", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String name = project.getString("name") + typeName + simpleDateFormat.format(startTime) + weekName;
        this.getModel().setValue("billname", (Object)name);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"reporttype", (CharSequence)propName)) {
            this.setTimeRange();
            this.updateDataDetailEntryName();
            this.updateTotalData(propName);
            this.autoName();
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
            this.updateTotalData(propName);
            this.autoName();
        } else if (StringUtils.equals((CharSequence)"reportcycle", (CharSequence)propName)) {
            this.setTimeRange();
            this.updateTotalData(propName);
            this.autoName();
        } else if (StringUtils.equals((CharSequence)"controllevels", (CharSequence)propName)) {
            this.updateTotalData(propName);
        }
    }

    protected void setTimeRange() {
        String reportType = (String)this.getModel().getValue("reporttype");
        Date startTime = (Date)this.getModel().getValue("reportcycle");
        Date rangeStart = null;
        Date rangeEnd = null;
        if (null != startTime) {
            if (StringUtils.equalsIgnoreCase((CharSequence)reportType, (CharSequence)"01")) {
                rangeStart = DateUtil.getFirstDayOfThisMonth((Date)startTime);
                rangeEnd = DateUtil.getLastDayOfThisMonth((Date)startTime);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)reportType, (CharSequence)"02")) {
                rangeStart = DateUtil.getThisWeekMonday((Date)startTime);
                rangeEnd = DateUtil.getThisWeekSunDay((Date)startTime);
            }
        }
        this.getModel().setValue("STARTTIME", rangeStart);
        this.getModel().setValue("ENDTIME", (Object)rangeEnd);
    }

    protected void updateTotalData(String propName) {
        boolean isExist = this.isExistOne();
        if (isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5468\u671f\u5df2\u5b58\u5728\u9879\u76ee\u8fd0\u8425\u62a5\u544a\uff0c\u65e0\u6cd5\u91cd\u590d\u4fdd\u5b58\u3002", (String)"ProOperationalReportPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        Date reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        if (project == null || reportType == null || reportDate == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"reporttype", (CharSequence)propName)) {
            this.queryPieData();
            this.queryBarData();
            this.updateChart();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
        } else if (StringUtils.equals((CharSequence)"reportcycle", (CharSequence)propName)) {
            this.queryPieData();
            this.queryBarData();
            this.updateChart();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.queryPieData();
            this.queryBarData();
            this.updateChart();
            this.updateCruxNodeEntry();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
            this.updateProcessEntry();
        } else if (StringUtils.equals((CharSequence)"controllevels", (CharSequence)propName)) {
            this.queryBarData();
            this.updateChart();
        }
    }

    protected void updateCruxNodeEntry() {
        this.getModel().deleteEntryData("cruxnodeentry");
        this.getView().setVisible(Boolean.TRUE, new String[]{"cruxap"});
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        if (project == null) {
            return;
        }
        QFilter commonFilter = this.getCommonFilter();
        QFilter taskTypeNumberFilter = new QFilter("tasktype", "=", (Object)TASKTYPE_CRUXNODE_ID);
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskseq,name,planendtime,realendtime,majortype,percent,realtimedeviation,responsibleperson,responsibledept,multicooperationperson,multicooperationdept,version,completionstatus,riskcolor", (QFilter[])new QFilter[]{commonFilter, taskTypeNumberFilter}, (String)"planendtime,taskseq desc");
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        for (DynamicObject dynamicObject : taskArr) {
            int rowIndex = this.getModel().createNewEntryRow("cruxnodeentry");
            this.getModel().setValue("cruxtask", (Object)dynamicObject, rowIndex);
            this.setCruxTaskDetail(dynamicObject, rowIndex, styles);
        }
        EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("cruxnodeentry");
        cruxnodeentry.setCellStyle(styles);
        this.getView().updateView("cruxnodeentry");
        this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
        this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
        if (taskArr.length == 0) {
            return;
        }
        if (taskArr.length > 10) {
            this.getPageCache().put("beginIndex", "0");
            this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
        }
        this.updateCruxFlex(taskArr);
    }

    protected void updateCruxFlex(DynamicObject[] taskArr) {
        int i;
        for (i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
        }
        for (i = 0; i < taskArr.length && i <= 9; ++i) {
            HashMap<String, String> propMap;
            String completionStatus = taskArr[i].getString("completionstatus");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap<String, String>(16);
                propMap.put("bc", "#FF585A");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#2DECE9");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#00BBFF");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.UNSTART.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#D2DBDE");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#83F348");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#FFC000");
                this.getView().updateControlMetadata(colorap + i, propMap);
            }
            Label taskNameLabel = (Label)this.getControl(tasknamelabel + i);
            taskNameLabel.setText(taskArr[i].getString("name"));
            Label planEndTimeLabel = (Label)this.getControl(planendtimeap + i);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            String planEndTimeString = f.format(taskArr[i].getDate("planendtime"));
            planEndTimeLabel.setText(planEndTimeString);
            this.getView().setVisible(Boolean.TRUE, new String[]{cruxtasknodeap + i});
        }
    }

    protected void updateNextCycleTaskEntry() {
        this.getModel().deleteEntryData("nextcyctaskentry");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"nextcycleap"});
        String reportType = dataEntity.getString("reporttype");
        Date reportDate = dataEntity.getDate("reportcycle");
        QFilter commonFilter = this.getCommonFilter();
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            Date firstDayOfNextMonth = DateUtil.getFirstDayOfNextMonth((Date)reportDate);
            Date lastDayOfNextMonth = DateUtil.getLastDayOfNextMonth((Date)reportDate);
            QFilter endTimeLargeLastDayOfNextMonthFilter = new QFilter("planendtime", ">", (Object)lastDayOfNextMonth);
            QFilter startTimeLessFirstDayOfNextMonthFilter = new QFilter("planstarttime", "<", (Object)firstDayOfNextMonth);
            QFilter startTimeInNextMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfNextMonth).and(new QFilter("planstarttime", ">=", (Object)firstDayOfNextMonth));
            QFilter endTimeInNextMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfNextMonth).and(new QFilter("planendtime", ">=", (Object)firstDayOfNextMonth));
            ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
            unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.OVERDUE.getValue());
            QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
            QFilter filter = startTimeInNextMonthFilter.or(endTimeInNextMonthFilter).or(startTimeLessFirstDayOfNextMonthFilter.and(endTimeLargeLastDayOfNextMonthFilter)).and(unCompleteFilter);
            DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskseq,name,planstarttime,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,multicooperationperson,multicooperationdept,version,completionstatus,riskcolor", (QFilter[])new QFilter[]{commonFilter, filter}, (String)"taskseq");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            for (DynamicObject dynamicObject : taskArr) {
                int rowIndex = this.getModel().createNewEntryRow("nextcyctaskentry");
                this.getModel().setValue("nextcycletask", (Object)dynamicObject, rowIndex);
                this.setNextCycleTaskDetail(dynamicObject, rowIndex, styles);
            }
            EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("nextcyctaskentry");
            cruxnodeentry.setCellStyle(styles);
            this.getView().updateView("nextcyctaskentry");
        } else {
            Date firstDayOfNextWeek = DateUtil.getNextWeekMonday((Date)reportDate);
            Date lastDayOfNextWeek = DateUtil.getNextWeekSunday((Date)reportDate);
            QFilter endTimeLargeLastDayOfNextMonthFilter = new QFilter("planendtime", ">", (Object)lastDayOfNextWeek);
            QFilter startTimeLessFirstDayOfNextMonthFilter = new QFilter("planstarttime", "<", (Object)firstDayOfNextWeek);
            QFilter startTimeInNextMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfNextWeek).and(new QFilter("planstarttime", ">=", (Object)firstDayOfNextWeek));
            QFilter endTimeInNextMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfNextWeek).and(new QFilter("planendtime", ">=", (Object)firstDayOfNextWeek));
            ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
            unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
            QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
            QFilter filter = startTimeInNextMonthFilter.or(endTimeInNextMonthFilter).or(startTimeLessFirstDayOfNextMonthFilter.and(endTimeLargeLastDayOfNextMonthFilter)).and(unCompleteFilter);
            EntryGrid taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskseq,name,planstarttime,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,multicooperationperson,multicooperationdept,version,completionstatus,riskcolor", (QFilter[])new QFilter[]{commonFilter, filter}, (String)"taskseq");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            for (DynamicObject task : taskArr) {
                int rowIndex = this.getModel().createNewEntryRow("nextcyctaskentry");
                this.getModel().setValue("nextcycletask", (Object)task, rowIndex);
                this.setNextCycleTaskDetail(task, rowIndex, styles);
            }
            EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("nextcyctaskentry");
            cruxnodeentry.setCellStyle(styles);
            this.getView().updateView("nextcyctaskentry");
        }
    }

    protected void updateThisCycleTaskEntry() {
        this.getModel().deleteEntryData("thiscyctaskentry");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"thiscycleap"});
        String reportType = dataEntity.getString("reporttype");
        Date reportDate = dataEntity.getDate("reportcycle");
        QFilter commonFilter = this.getCommonFilter();
        ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
        unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.OVERDUE.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
        QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter startTimeInThisMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfMonth).and(new QFilter("planstarttime", ">=", (Object)firstDayOfMonth));
            QFilter endTimeInThisMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth).and(new QFilter("planendtime", "<=", (Object)lastDayOfMonth));
            QFilter endTimeBeforeThisMonthAndUnCompleteFilter = new QFilter("planendtime", "<", (Object)firstDayOfMonth).and(unCompleteFilter);
            QFilter startOrEndInThisFilter = startTimeInThisMonthFilter.or(endTimeInThisMonthFilter);
            QFilter startBeforeThisAndEndAfterThisFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfMonth).and(new QFilter("planendtime", ">", (Object)lastDayOfMonth));
            QFilter realEndTimeInThisFilter = new QFilter("realendtime", "<=", (Object)lastDayOfMonth).and(new QFilter("realendtime", ">=", (Object)firstDayOfMonth));
            DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskseq,name,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,multicooperationperson,multicooperationdept,version,completionstatus,riskcolor", (QFilter[])new QFilter[]{commonFilter, endTimeBeforeThisMonthAndUnCompleteFilter.or(startOrEndInThisFilter).or(startBeforeThisAndEndAfterThisFilter).or(realEndTimeInThisFilter)}, (String)"taskseq");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            for (DynamicObject dynamicObject : taskArr) {
                int rowIndex = this.getModel().createNewEntryRow("thiscyctaskentry");
                this.getModel().setValue("thiscycletask", (Object)dynamicObject, rowIndex);
                this.setThisCycleTaskDetail(dynamicObject, rowIndex, styles);
            }
            EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("thiscyctaskentry");
            cruxnodeentry.setCellStyle(styles);
            this.getView().updateView("thiscyctaskentry");
        } else {
            Date firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter startTimeInThisWeekFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfWeek).and(new QFilter("planstarttime", ">=", (Object)firstDayOfWeek));
            QFilter endTimeInThisWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek).and(new QFilter("planendtime", "<=", (Object)lastDayOfWeek));
            QFilter endTimeBeforeThisWeekAndUnCompleteFilter = new QFilter("planendtime", "<", (Object)firstDayOfWeek).and(unCompleteFilter);
            QFilter startOrEndInThisFilter = startTimeInThisWeekFilter.and(endTimeInThisWeekFilter);
            QFilter startBeforeThisAndEndAfterThisFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfWeek).and(new QFilter("planendtime", ">", (Object)lastDayOfWeek));
            QFilter realEndTimeInThisFilter = new QFilter("realendtime", "<=", (Object)lastDayOfWeek).and(new QFilter("realendtime", ">=", (Object)firstDayOfWeek));
            EntryGrid taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskseq,name,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,version,completionstatus, riskcolor", (QFilter[])new QFilter[]{commonFilter, endTimeBeforeThisWeekAndUnCompleteFilter.or(startOrEndInThisFilter).or(startBeforeThisAndEndAfterThisFilter).or(realEndTimeInThisFilter)}, (String)"taskseq");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            for (DynamicObject task : taskArr) {
                int rowIndex = this.getModel().createNewEntryRow("thiscyctaskentry");
                this.getModel().setValue("thiscycletask", (Object)task, rowIndex);
                this.setThisCycleTaskDetail(task, rowIndex, styles);
            }
            EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("thiscyctaskentry");
            cruxnodeentry.setCellStyle(styles);
            this.getView().updateView("thiscyctaskentry");
        }
        this.statisticsTaskCount();
    }

    protected void updateChart() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"totalanalysisap"});
        String leftPieDataObj = this.getModel().getDataEntity().getString(leftpiedata);
        String rightPieDataObj = this.getModel().getDataEntity().getString(rightpiedata);
        this.updatePieChartByJsonData("thismonthpiechart", JSONObject.parseObject((String)leftPieDataObj));
        this.updatePieChartByJsonData("totalpiechart", JSONObject.parseObject((String)rightPieDataObj));
        String leftBarDataObj = this.getModel().getDataEntity().getString(leftbardata);
        String rightBarDataObj = this.getModel().getDataEntity().getString(rightbardata);
        this.updateBarChartByJsonData("thismonthbarchart", JSONObject.parseObject((String)leftBarDataObj));
        this.updateBarChartByJsonData("totalbarchart", JSONObject.parseObject((String)rightBarDataObj));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String sourceName = evt.getSource().getClass().getName();
        if (StringUtils.equals((CharSequence)sourceName, (CharSequence)PieChart.class.getName())) {
            ChartClickEvent chartClickEvent = (ChartClickEvent)evt;
            Chart chart = chartClickEvent.getSource();
            if (StringUtils.equals((CharSequence)"thismonthpiechart", (CharSequence)chart.getKey())) {
                this.pieChartapClick(chartClickEvent, true);
            }
            if (StringUtils.equals((CharSequence)"totalpiechart", (CharSequence)chart.getKey())) {
                this.pieChartapClick(chartClickEvent, false);
            }
        } else if (StringUtils.equals((CharSequence)sourceName, (CharSequence)HistogramChart.class.getName())) {
            ChartClickEvent chartClickEvent = (ChartClickEvent)evt;
            Chart chart = chartClickEvent.getSource();
            if (StringUtils.equals((CharSequence)"thismonthbarchart", (CharSequence)chart.getKey())) {
                this.barChartapClick(chartClickEvent, true);
            }
            if (StringUtils.equals((CharSequence)"totalbarchart", (CharSequence)chart.getKey())) {
                this.barChartapClick(chartClickEvent, false);
            }
        }
    }

    protected void pieChartapClick(ChartClickEvent chartClickEvent, boolean beLeft) {
        String itemName = chartClickEvent.getName();
        String seriesName = chartClickEvent.getSeriesName();
        if (itemName == null || seriesName == null) {
            return;
        }
        if (seriesName.contains("%")) {
            return;
        }
        String pieData = null;
        pieData = beLeft ? (String)this.getModel().getValue(leftpiedata) : (String)this.getModel().getValue(rightpiedata);
        JSONObject parse = (JSONObject)JSONObject.parse((String)pieData);
        String taskIds = "";
        if (itemName.equals(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"ProOperationalReportPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)unStartTaskIds);
        } else if (itemName.equals(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"ProOperationalReportPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)progressingTaskIds);
        } else if (itemName.equals(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"ProOperationalReportPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)onTimeEndTaskIds);
        } else if (itemName.equals(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"ProOperationalReportPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)overTimeEndTaskIds);
        } else if (itemName.equals(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProOperationalReportPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)overTimeNotEndTaskIds);
        } else if (itemName.equals(ResManager.loadKDString((String)"\u9884\u8ba1\u903e\u671f", (String)"ProOperationalReportPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            taskIds = (String)parse.get((Object)estimateDelayTaskIds);
        }
        if (StringUtils.isBlank((CharSequence)taskIds)) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskIds", taskIds);
        paramMap.put("formId", this.getAppId() + "_tasklist");
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected void barChartapClick(ChartClickEvent chartClickEvent, boolean beLeft) {
        String itemName = chartClickEvent.getName();
        String seriesName = chartClickEvent.getSeriesName();
        if (itemName == null || seriesName == null) {
            return;
        }
        if (seriesName.contains("%")) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String barData = null;
        barData = beLeft ? (String)this.getModel().getValue(leftbardata) : (String)this.getModel().getValue(rightbardata);
        JSONObject parse = (JSONObject)JSONObject.parse((String)barData);
        JSONObject seriesJSONObject = new JSONObject();
        if (seriesName.equals(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            seriesJSONObject = (JSONObject)parse.get((Object)cLevelRealEndTaskIds);
        } else if (seriesName.equals(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            seriesJSONObject = (JSONObject)parse.get((Object)cLevelPlanEndTaskIds);
        }
        String taskIds = (String)seriesJSONObject.get((Object)itemName);
        if (StringUtils.isBlank((CharSequence)taskIds)) {
            return;
        }
        paramMap.put("taskIds", taskIds);
        paramMap.put("formId", this.getAppId() + "_tasklist");
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected void queryBarData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (project == null) {
            return;
        }
        String reportType = dataEntity.getString("reporttype");
        Date reportDate = dataEntity.getDate("reportcycle");
        DynamicObjectCollection controllevels = dataEntity.getDynamicObjectCollection("controllevels");
        HashSet<Object> controlLevelIdSet = new HashSet<Object>();
        for (DynamicObject ctrllevel : controllevels) {
            DynamicObject controlLevel = ctrllevel.getDynamicObject("fbasedataid");
            controlLevelIdSet.add(controlLevel.getPkValue());
        }
        DynamicObject[] taskArr = null;
        DynamicObject[] totalTaskArr = null;
        JSONObject leftBarDataObj = new JSONObject();
        JSONObject rightBarDataObj = new JSONObject();
        QFilter commonFilter = this.getCommonFilter();
        QFilter controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            leftBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u6708\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            rightBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
            QFilter largeFirstDayOfMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth);
            if (!controlLevelIdSet.isEmpty()) {
                taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter, controlLevelFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, controlLevelFilter});
            } else {
                taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter});
            }
        } else {
            leftBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u5468\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            rightBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            Date firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter lessLastDayOfWeekFilter = new QFilter("planendtime", "<=", (Object)lastDayOfWeek);
            QFilter largeFirstDayOfWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek);
            if (!controlLevelIdSet.isEmpty()) {
                taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter, controlLevelFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, controlLevelFilter});
            } else {
                taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter});
            }
        }
        this.setBarDataObj(taskArr, leftBarDataObj);
        this.setBarDataObj(totalTaskArr, rightBarDataObj);
        this.getModel().setValue(leftbardata, (Object)leftBarDataObj.toString());
        this.getModel().setValue(rightbardata, (Object)rightBarDataObj.toString());
    }

    private void setBarDataObj(DynamicObject[] taskArr, JSONObject barDataObj) {
        HashMap<String, Integer> controlLevelPlanEndMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> controlLevelRealEndMap = new HashMap<String, Integer>(16);
        HashMap<String, String> cLevelPlanEndTaskIdsMap = new HashMap<String, String>(16);
        HashMap<String, String> cLevelRealEndTaskIdsMap = new HashMap<String, String>(16);
        for (DynamicObject task : taskArr) {
            DynamicObject controlLevel = task.getDynamicObject("controllevel");
            if (controlLevel == null) continue;
            String controlLevelName = controlLevel.getString("name");
            Integer planEndQty = (Integer)controlLevelPlanEndMap.get(controlLevelName);
            planEndQty = planEndQty != null ? Integer.valueOf(planEndQty + 1) : Integer.valueOf(1);
            controlLevelPlanEndMap.put(controlLevelName, planEndQty);
            String planEndTaskIds = (String)cLevelPlanEndTaskIdsMap.get(controlLevelName);
            planEndTaskIds = StringUtils.isNotBlank((CharSequence)planEndTaskIds) ? planEndTaskIds + task.getPkValue().toString() + "," : task.getPkValue().toString() + ",";
            cLevelPlanEndTaskIdsMap.put(controlLevelName, planEndTaskIds);
            String comPletionStatus = task.getString("completionstatus");
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue()) && !StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) continue;
            Integer endQty = (Integer)controlLevelRealEndMap.get(controlLevelName);
            endQty = endQty != null ? Integer.valueOf(endQty + 1) : Integer.valueOf(1);
            controlLevelRealEndMap.put(controlLevelName, endQty);
            String realEndTaskIds = (String)cLevelRealEndTaskIdsMap.get(controlLevelName);
            realEndTaskIds = StringUtils.isNotBlank((CharSequence)realEndTaskIds) ? realEndTaskIds + task.getPkValue().toString() + "," : task.getPkValue().toString() + ",";
            cLevelRealEndTaskIdsMap.put(controlLevelName, realEndTaskIds);
        }
        ArrayList<BigDecimal> realDataDetailList = new ArrayList<BigDecimal>(10);
        ArrayList<Integer> planEndList = new ArrayList<Integer>(10);
        for (Map.Entry controlLevel : controlLevelPlanEndMap.entrySet()) {
            Integer endQty = (Integer)controlLevelRealEndMap.get(controlLevel.getKey());
            if (endQty == null) {
                endQty = 0;
            }
            realDataDetailList.add(BigDecimal.valueOf(endQty.intValue()));
            Integer planEndQty = (Integer)controlLevel.getValue();
            planEndList.add(planEndQty);
        }
        barDataObj.put(xAxisList, controlLevelPlanEndMap.keySet());
        barDataObj.put(realDataList, realDataDetailList);
        barDataObj.put(planEndQtyList, planEndList);
        barDataObj.put(cLevelPlanEndTaskIds, cLevelPlanEndTaskIdsMap);
        barDataObj.put(cLevelRealEndTaskIds, cLevelRealEndTaskIdsMap);
    }

    protected void queryPieData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject project = dataEntity.getDynamicObject("project");
        String reportType = dataEntity.getString("reporttype");
        Date reportDate = dataEntity.getDate("reportcycle");
        if (project == null) {
            return;
        }
        JSONObject leftPieDataObj = new JSONObject();
        JSONObject rightPieDataObj = new JSONObject();
        QFilter commonFilter = this.getCommonFilter();
        DynamicObject[] taskArr = null;
        DynamicObject[] totalTaskArr = null;
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            leftPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u6708\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            rightPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
            QFilter largeFirstDayOfMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth);
            taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter});
            totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter});
        } else {
            leftPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u5468\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            rightPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            Date firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter lessLastDayOfWeekFilter = new QFilter("planendtime", "<=", (Object)lastDayOfWeek);
            QFilter largeFirstDayOfWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek);
            taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter});
            totalTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter});
        }
        this.setPieDataObj(leftPieDataObj, taskArr);
        this.setPieDataObj(rightPieDataObj, totalTaskArr);
        this.getModel().setValue(leftpiedata, (Object)leftPieDataObj.toJSONString());
        this.getModel().setValue(rightpiedata, (Object)rightPieDataObj.toJSONString());
    }

    private void setPieDataObj(JSONObject pieDataObj, DynamicObject[] taskArr) {
        int unStartQty = 0;
        int progressingQty = 0;
        int onTimeEndQty = 0;
        int overTimeEndQty = 0;
        int overTimeNotEndQty = 0;
        int estimateDelayQty = 0;
        StringBuilder unStartTaskIdsSb = new StringBuilder();
        StringBuilder progressingTaskIdsSb = new StringBuilder();
        StringBuilder onTimeEndTaskIdsSb = new StringBuilder();
        StringBuilder overTimeEndTaskIdsSb = new StringBuilder();
        StringBuilder overTimeNotEndTaskIdsSb = new StringBuilder();
        StringBuilder estimateDelayTaskIdsSb = new StringBuilder();
        for (DynamicObject task : taskArr) {
            String comPletionStatus = task.getString("completionstatus");
            String taskId = task.getPkValue().toString();
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue())) {
                ++unStartQty;
                unStartTaskIdsSb.append(taskId).append(",");
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.PROGRESSING.getValue())) {
                ++progressingQty;
                progressingTaskIdsSb.append(taskId).append(",");
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                ++onTimeEndQty;
                onTimeEndTaskIdsSb.append(taskId).append(",");
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                ++overTimeEndQty;
                overTimeEndTaskIdsSb.append(taskId).append(",");
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                ++overTimeNotEndQty;
                overTimeNotEndTaskIdsSb.append(taskId).append(",");
                continue;
            }
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue())) continue;
            ++estimateDelayQty;
            estimateDelayTaskIdsSb.append(taskId).append(",");
        }
        pieDataObj.put(planEnd, (Object)taskArr.length);
        pieDataObj.put(unStart, (Object)unStartQty);
        pieDataObj.put(progressing, (Object)progressingQty);
        pieDataObj.put(onTimeEnd, (Object)onTimeEndQty);
        pieDataObj.put(overTimeEnd, (Object)overTimeEndQty);
        pieDataObj.put(overTimeNotEnd, (Object)overTimeNotEndQty);
        pieDataObj.put(estimateDelay, (Object)estimateDelayQty);
        pieDataObj.put(unStartTaskIds, (Object)unStartTaskIdsSb.toString());
        pieDataObj.put(progressingTaskIds, (Object)progressingTaskIdsSb.toString());
        pieDataObj.put(onTimeEndTaskIds, (Object)onTimeEndTaskIdsSb.toString());
        pieDataObj.put(overTimeEndTaskIds, (Object)overTimeEndTaskIdsSb.toString());
        pieDataObj.put(overTimeNotEndTaskIds, (Object)overTimeNotEndTaskIdsSb.toString());
        pieDataObj.put(estimateDelayTaskIds, (Object)estimateDelayTaskIdsSb.toString());
    }

    protected void updatePieChartByJsonData(String chartKey, JSONObject pieDataObject) {
        String pieTiltleName = pieDataObject.getString(chartTitleName);
        BigDecimal planEndQty = pieDataObject.getBigDecimal(planEnd);
        BigDecimal unStartQty = pieDataObject.getBigDecimal(unStart);
        BigDecimal progessingQty = pieDataObject.getBigDecimal(progressing);
        BigDecimal onTimeEndQty = pieDataObject.getBigDecimal(onTimeEnd);
        BigDecimal overTimeEndQty = pieDataObject.getBigDecimal(overTimeEnd);
        BigDecimal overTimeNotEndQty = pieDataObject.getBigDecimal(overTimeNotEnd);
        BigDecimal estimateDelayQty = pieDataObject.getBigDecimal(estimateDelay);
        PieChart pieChart1 = (PieChart)this.getControl(chartKey);
        pieChart1.clearData();
        pieChart1.setTitleAlign(XAlign.left, YAlign.top);
        pieChart1.setShowTooltip(true);
        pieChart1.setName(new LocaleString(pieTiltleName));
        PieSeries pieSeries1 = pieChart1.createPieSeries(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210 (%s) \u6761", (String)"ProOperationalReportPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), planEndQty));
        pieSeries1.setCenter("50%", "55%");
        pieSeries1.setRadius("62%");
        boolean flag = false;
        if (unStartQty != null && unStartQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"ProOperationalReportPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)unStartQty, "#D2DBDE");
            flag = true;
        }
        if (progessingQty != null && progessingQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"ProOperationalReportPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)progessingQty, "#00BBFF");
            flag = true;
        }
        if (onTimeEndQty != null && onTimeEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"ProOperationalReportPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)onTimeEndQty, "#83F348");
            flag = true;
        }
        if (overTimeEndQty != null && overTimeEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"ProOperationalReportPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)overTimeEndQty, "#2DECE9");
            flag = true;
        }
        if (overTimeNotEndQty != null && overTimeNotEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProOperationalReportPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)overTimeNotEndQty, "#FF585A");
            flag = true;
        }
        if (estimateDelayQty != null && estimateDelayQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u9884\u8ba1\u903e\u671f", (String)"ProOperationalReportPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)estimateDelayQty, "#FFC000");
            flag = true;
        }
        HashMap labelMap = new HashMap(16);
        HashMap<String, String> subTextMap = new HashMap<String, String>(16);
        subTextMap.put("color", "#FF3300");
        subTextMap.put("fontSize", "13");
        pieChart1.setTitlePropValue("subtext", (Object)("\uff08" + String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210 (%s) \u6761", (String)"ProOperationalReportPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), planEndQty) + "\uff09"));
        pieChart1.setTitlePropValue("subtextStyle", subTextMap);
        HashMap<String, String> normalMap = new HashMap<String, String>(16);
        normalMap.put("formatter", ResManager.loadKDString((String)"{b}\uff1a{c} \u6761\n\u5360\u6bd4\uff1a{d}%", (String)"ProOperationalReportPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        labelMap.put("normal", normalMap);
        pieSeries1.setPropValue("label", labelMap);
        if (!flag) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ProOperationalReportPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO, "#BEBEBE");
            pieChart1.refresh();
            return;
        }
        pieChart1.refresh();
    }

    protected void updateBarChartByJsonData(String chartKey, JSONObject barDataObject) {
        String chartTitleName = barDataObject.getString(chartTitleName);
        JSONArray xAxisListArr = barDataObject.getJSONArray(xAxisList);
        String[] xAxisList = new String[xAxisListArr.size()];
        for (int i = 0; i < xAxisListArr.size(); ++i) {
            xAxisList[i] = (String)xAxisListArr.get(i);
        }
        JSONArray realDataListArr = barDataObject.getJSONArray(realDataList);
        Number[] realDataList = new BigDecimal[realDataListArr.size()];
        for (int i = 0; i < realDataListArr.size(); ++i) {
            realDataList[i] = realDataListArr.getBigDecimal(i);
        }
        JSONArray planEndQtyListArr = barDataObject.getJSONArray(planEndQtyList);
        if (planEndQtyListArr == null) {
            return;
        }
        Number[] planEndList = new Integer[planEndQtyListArr.size()];
        for (int i = 0; i < planEndQtyListArr.size(); ++i) {
            planEndList[i] = planEndQtyListArr.getInteger(i);
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl(chartKey);
        histogramChart.clearData();
        histogramChart.setTitleAlign(XAlign.left, YAlign.top);
        histogramChart.setLegendAlign(XAlign.right, YAlign.top);
        histogramChart.setShowTooltip(true);
        histogramChart.setMargin(Position.top, "60px");
        histogramChart.setName(new LocaleString(chartTitleName));
        Axis yAxis = histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"ProOperationalReportPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]), AxisType.value);
        Integer max = 0;
        for (Integer n : planEndList) {
            if (n <= max) continue;
            max = n;
        }
        kd.bos.form.chart.Label plLabel = new kd.bos.form.chart.Label();
        plLabel.setShow(true);
        plLabel.setFontSize("14");
        plLabel.setPosition(Position.inside);
        BarSeries series1 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series1.setBarWidth("50px");
        series1.setStack("aa");
        series1.setData(planEndList);
        series1.setColor("#00BBFF");
        series1.setLabel(plLabel);
        BigDecimal xBigDecimal = BigDecimal.valueOf(max.intValue()).multiply(new BigDecimal("1.2")).setScale(0, RoundingMode.HALF_UP);
        yAxis.setMax((Number)xBigDecimal);
        histogramChart.createXAxis("", xAxisList);
        BarSeries barSeries = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        barSeries.setBarWidth("50px");
        barSeries.setStack("aa");
        barSeries.setData(realDataList);
        barSeries.setColor("#83F348");
        barSeries.setLabel(plLabel);
        histogramChart.setShowLegend(true);
        histogramChart.refresh();
    }

    protected void updateDataDetailEntryName() {
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        String thisMonthColName = ResManager.loadKDString((String)"\u672c\u6708", (String)"ProOperationalReportPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        String thisCycleTaskEntryName = ResManager.loadKDString((String)"\u672c\u6708\u4efb\u52a1", (String)"ProOperationalReportPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        String nextCycleTaskEntryName = ResManager.loadKDString((String)"\u4e0b\u6708\u4efb\u52a1", (String)"ProOperationalReportPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"02", (CharSequence)reportType)) {
            thisMonthColName = ResManager.loadKDString((String)"\u672c\u5468", (String)"ProOperationalReportPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
            thisCycleTaskEntryName = ResManager.loadKDString((String)"\u672c\u5468\u4efb\u52a1", (String)"ProOperationalReportPlugin_24", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
            nextCycleTaskEntryName = ResManager.loadKDString((String)"\u4e0b\u5468\u4efb\u52a1", (String)"ProOperationalReportPlugin_25", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("datadetailentry");
        grid.setColumnProperty("thismonth", "header", (Object)new LocaleString(thisMonthColName));
        HashMap<String, LocaleString> thisCycleMap = new HashMap<String, LocaleString>(16);
        thisCycleMap.put("text", new LocaleString(thisCycleTaskEntryName));
        this.getView().updateControlMetadata("thiscycleap", thisCycleMap);
        HashMap<String, LocaleString> nextCycleMap = new HashMap<String, LocaleString>(16);
        nextCycleMap.put("text", new LocaleString(nextCycleTaskEntryName));
        this.getView().updateControlMetadata("nextcycleap", nextCycleMap);
    }

    protected void updateEntryColor() {
        int cruxnodRow = this.getModel().getEntryRowCount("cruxnodeentry");
        int thiscyctaskRow = this.getModel().getEntryRowCount("thiscyctaskentry");
        int nextcyctaskRow = this.getModel().getEntryRowCount("nextcyctaskentry");
        ArrayList<CellStyle> styles1 = new ArrayList<CellStyle>(10);
        for (int i = 0; i < cruxnodRow; ++i) {
            DynamicObject cruxtask = (DynamicObject)this.getModel().getValue("cruxtask", i);
            cruxtask = BusinessDataServiceHelper.loadSingle((Object)cruxtask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("cruxtaskname");
            String riskColor = cruxtask.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style.setBackColor("#FD6C6A");
            }
            styles1.add(style);
        }
        EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("cruxnodeentry");
        cruxnodeentry.setCellStyle(styles1);
        this.getView().updateView("cruxnodeentry");
        ArrayList<CellStyle> styles2 = new ArrayList<CellStyle>(10);
        for (int i = 0; i < thiscyctaskRow; ++i) {
            DynamicObject cruxtask = (DynamicObject)this.getModel().getValue("thiscycletask", i);
            cruxtask = BusinessDataServiceHelper.loadSingle((Object)cruxtask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("thiscycletaskname");
            String riskColor = cruxtask.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style.setBackColor("#FD6C6A");
            }
            styles2.add(style);
        }
        EntryGrid thiscyctaskentry = (EntryGrid)this.getView().getControl("thiscyctaskentry");
        thiscyctaskentry.setCellStyle(styles2);
        this.getView().updateView("thiscyctaskentry");
        ArrayList<CellStyle> styles3 = new ArrayList<CellStyle>(10);
        for (int i = 0; i < nextcyctaskRow; ++i) {
            DynamicObject cruxtask = (DynamicObject)this.getModel().getValue("nextcycletask", i);
            cruxtask = BusinessDataServiceHelper.loadSingle((Object)cruxtask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("nextcycletaskname");
            String riskColor = cruxtask.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style.setBackColor("#FD6C6A");
            }
            styles3.add(style);
        }
        EntryGrid nextcyctaskentry = (EntryGrid)this.getView().getControl("nextcyctaskentry");
        nextcyctaskentry.setCellStyle(styles3);
        this.getView().updateView("nextcyctaskentry");
    }

    protected void statisticsTaskCount() {
        DynamicObjectCollection taskCol = this.getModel().getEntryEntity("thiscyctaskentry");
        int totalQty = taskCol.size();
        int onTimeEndQty = 0;
        int overTimeEndQty = 0;
        int processQty = 0;
        int overTimeNotEndQty = 0;
        for (DynamicObject dynamicObject : taskCol) {
            String status = dynamicObject.getString("thistaskstatus");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                ++onTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)status)) {
                ++processQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                ++overTimeEndQty;
                continue;
            }
            if (!StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) continue;
            ++overTimeNotEndQty;
        }
        this.getModel().setValue("totalqty", (Object)totalQty);
        this.getModel().setValue("ontimeqty", (Object)onTimeEndQty);
        this.getModel().setValue("overtimeendqty", (Object)overTimeEndQty);
        this.getModel().setValue("processqty", (Object)processQty);
        this.getModel().setValue("overtimenotendqty", (Object)overTimeNotEndQty);
    }

    protected void updateDataDetailEntry() {
        Date reportDate;
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getModel().deleteEntryData("datadetailentry");
        QFilter commonFilter = this.getCommonFilter();
        QFilter belongPlanTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        Date lastDayOfMonth = reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        lastDayOfMonth = StringUtils.equals((CharSequence)reportType, (CharSequence)"01") ? DateUtil.getLastDayOfThisMonth((Date)reportDate) : DateUtil.getThisWeekSunDay((Date)reportDate);
        QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
        DynamicObject[] majorTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,name,majortype,planendtime,completionstatus", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, belongPlanTypeFilter});
        HashMap majorTypeMap = new HashMap(16);
        HashMap entryMap = new HashMap(16);
        for (DynamicObject task : majorTaskArr) {
            HashMap<String, String> taskIdsMap;
            DynamicObject majorType = task.getDynamicObject("majortype");
            String status = task.getString("completionstatus");
            Date planEndTime = task.getDate("planendtime");
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            if (majorType == null) continue;
            String majorTypeId = majorType.getString("id");
            HashMap<String, Integer> taskQtyMap = (HashMap<String, Integer>)majorTypeMap.get(majorTypeId);
            if (taskQtyMap == null) {
                taskQtyMap = new HashMap<String, Integer>(16);
            }
            if ((taskIdsMap = (HashMap<String, String>)entryMap.get(majorTypeId)) == null) {
                taskIdsMap = new HashMap<String, String>(16);
            }
            Integer planEndQty = 0;
            Integer onTimeEndQty = 0;
            Integer overTimeEndQty = 0;
            Integer overTimeNotEndQty = 0;
            Integer totalPlanEndQty = 0;
            Integer totalOnTimeEndQty = 0;
            Integer totalOverTimeEndQty = 0;
            Integer totalOverTimeNotEndQty = 0;
            String totalPlanEndTIds = "";
            String totalOnTimeEndTIds = "";
            String totalOverTimeEndTIds = "";
            String totalOverTimeNotEndTIds = "";
            String planEndTIds = "";
            String onTimeEndTIds = "";
            String overTimeEndTIds = "";
            String overTimeNotEndTIds = "";
            totalPlanEndQty = (Integer)taskQtyMap.get("totalPlanEndQty");
            totalPlanEndQty = totalPlanEndQty == null ? 1 : totalPlanEndQty + 1;
            totalPlanEndTIds = (String)taskIdsMap.get("entrytotalplanend");
            totalPlanEndTIds = (totalPlanEndTIds == null ? "" : totalPlanEndTIds) + task.getPkValue().toString() + ",";
            if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                totalOnTimeEndQty = (Integer)taskQtyMap.get("totalOnTimeEndQty");
                totalOnTimeEndQty = totalOnTimeEndQty == null ? 1 : totalOnTimeEndQty + 1;
                totalOnTimeEndTIds = (String)taskIdsMap.get("entrytotalontimeend");
                totalOnTimeEndTIds = (totalOnTimeEndTIds == null ? "" : totalOnTimeEndTIds) + task.getPkValue().toString() + ",";
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                totalOverTimeEndQty = (Integer)taskQtyMap.get("totalOverTimeEndQty");
                totalOverTimeEndQty = totalOverTimeEndQty == null ? 1 : totalOverTimeEndQty + 1;
                totalOverTimeEndTIds = (String)taskIdsMap.get("entrytotalovertimeend");
                totalOverTimeEndTIds = (totalOverTimeEndTIds == null ? "" : totalOverTimeEndTIds) + task.getPkValue().toString() + ",";
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                totalOverTimeNotEndQty = (Integer)taskQtyMap.get("totalOverTimeNotEndQty");
                totalOverTimeNotEndQty = totalOverTimeNotEndQty == null ? 1 : totalOverTimeNotEndQty + 1;
                totalOverTimeNotEndTIds = (String)taskIdsMap.get("entrytotalovertimenotend");
                totalOverTimeNotEndTIds = (totalOverTimeNotEndTIds == null ? "" : totalOverTimeNotEndTIds) + task.getPkValue().toString() + ",";
            }
            if (!planEndTime.before(firstDayOfThisMonth)) {
                planEndQty = (Integer)taskQtyMap.get("planEndQty");
                planEndQty = planEndQty == null ? 1 : planEndQty + 1;
                planEndTIds = (String)taskIdsMap.get("entryplanend");
                planEndTIds = (planEndTIds == null ? "" : planEndTIds) + task.getPkValue().toString() + ",";
                if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                    onTimeEndQty = (Integer)taskQtyMap.get("onTimeEndQty");
                    onTimeEndQty = onTimeEndQty == null ? 1 : onTimeEndQty + 1;
                    onTimeEndTIds = (String)taskIdsMap.get("entryontimeend");
                    onTimeEndTIds = (onTimeEndTIds == null ? "" : onTimeEndTIds) + task.getPkValue().toString() + ",";
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                    overTimeEndQty = (Integer)taskQtyMap.get("overTimeEndQty");
                    overTimeEndQty = overTimeEndQty == null ? 1 : overTimeEndQty + 1;
                    overTimeEndTIds = (String)taskIdsMap.get("entryovertimeend");
                    overTimeEndTIds = (overTimeEndTIds == null ? "" : overTimeEndTIds) + task.getPkValue().toString() + ",";
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                    overTimeNotEndQty = (Integer)taskQtyMap.get("overTimeNotEndQty");
                    overTimeNotEndQty = overTimeNotEndQty == null ? 1 : overTimeNotEndQty + 1;
                    overTimeNotEndTIds = (String)taskIdsMap.get("entryovertimenotend");
                    overTimeNotEndTIds = (overTimeNotEndTIds == null ? "" : overTimeNotEndTIds) + task.getPkValue().toString() + ",";
                }
            }
            taskQtyMap.put("planEndQty", planEndQty);
            taskQtyMap.put("onTimeEndQty", onTimeEndQty);
            taskQtyMap.put("overTimeEndQty", overTimeEndQty);
            taskQtyMap.put("overTimeNotEndQty", overTimeNotEndQty);
            taskQtyMap.put("totalPlanEndQty", totalPlanEndQty);
            taskQtyMap.put("totalOnTimeEndQty", totalOnTimeEndQty);
            taskQtyMap.put("totalOverTimeEndQty", totalOverTimeEndQty);
            taskQtyMap.put("totalOverTimeNotEndQty", totalOverTimeNotEndQty);
            majorTypeMap.put(majorTypeId, taskQtyMap);
            taskIdsMap.put("entryplanend", planEndTIds);
            taskIdsMap.put("entryontimeend", onTimeEndTIds);
            taskIdsMap.put("entryovertimeend", overTimeEndTIds);
            taskIdsMap.put("entryovertimenotend", overTimeNotEndTIds);
            taskIdsMap.put("entrytotalplanend", totalPlanEndTIds);
            taskIdsMap.put("entrytotalontimeend", totalOnTimeEndTIds);
            taskIdsMap.put("entrytotalovertimeend", totalOverTimeEndTIds);
            taskIdsMap.put("entrytotalovertimenotend", totalOverTimeNotEndTIds);
            entryMap.put(majorTypeId, taskIdsMap);
        }
        String s = SerializationUtils.toJsonString(entryMap);
        this.getModel().setValue("datadetail", (Object)s);
        if (majorTypeMap.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datadetalap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"datadetalap"});
        for (Map.Entry major : majorTypeMap.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow("datadetailentry");
            this.getModel().setValue("majortype", major.getKey(), rowIndex);
            Map taskQtyMap = (Map)major.getValue();
            this.getModel().setValue("entryplanend", taskQtyMap.get("planEndQty"), rowIndex);
            this.getModel().setValue("entryontimeend", taskQtyMap.get("onTimeEndQty"), rowIndex);
            this.getModel().setValue("entryovertimeend", taskQtyMap.get("overTimeEndQty"), rowIndex);
            this.getModel().setValue("entryovertimenotend", taskQtyMap.get("overTimeNotEndQty"), rowIndex);
            this.getModel().setValue("entrytotalplanend", taskQtyMap.get("totalPlanEndQty"), rowIndex);
            this.getModel().setValue("entrytotalontimeend", taskQtyMap.get("totalOnTimeEndQty"), rowIndex);
            this.getModel().setValue("entrytotalovertimeend", taskQtyMap.get("totalOverTimeEndQty"), rowIndex);
            this.getModel().setValue("entrytotalovertimenotend", taskQtyMap.get("totalOverTimeNotEndQty"), rowIndex);
        }
    }

    protected void updateProcessEntry() {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getModel().deleteEntryData("progressentry");
        QFilter majorTypeFilter = new QFilter("majortype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] majorPlanArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"id,name,majortype", (QFilter[])new QFilter[]{projectFilter, majorTypeFilter, billStatusFilter});
        if (majorPlanArr == null || majorPlanArr.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"processap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"processap"});
        HashSet<String> majorNameSet = new HashSet<String>();
        for (DynamicObject majorPlan : majorPlanArr) {
            DynamicObject majorType = majorPlan.getDynamicObject("majortype");
            if (majorType == null) continue;
            majorNameSet.add(majorType.getString("name"));
        }
        int rowIndex = this.getModel().createNewEntryRow("progressentry");
        this.getModel().setValue("majortypename", (Object)ResManager.loadKDString((String)"\u6574\u4f53\u8bf4\u660e", (String)"ProOperationalReportPlugin_26", (String)"pccs-placs-formplugin", (Object[])new Object[0]), rowIndex);
        for (String majorName : majorNameSet) {
            rowIndex = this.getModel().createNewEntryRow("progressentry");
            this.getModel().setValue("majortypename", (Object)majorName, rowIndex);
        }
    }

    protected void setCruxTaskDetail(DynamicObject task, int rowIndex, List<CellStyle> styles) {
        DynamicObjectCollection cooperationDepts;
        DynamicObjectCollection cooperationPersons;
        DynamicObject responsibleDept;
        this.getModel().setValue("cruxtaskstatus", task.get("completionstatus"), rowIndex);
        this.getModel().setValue("cruxtaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject majorType = task.getDynamicObject("majortype");
        if (majorType != null) {
            this.getModel().setValue("cruxmajorname", (Object)majorType.getString("name"), rowIndex);
        }
        this.getModel().setValue("cruxpercent", (Object)task.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
        this.getModel().setValue("cruxplanendtime", task.get("planendtime"), rowIndex);
        this.getModel().setValue("cruxrealendtime", task.get("realendtime"), rowIndex);
        this.getModel().setValue("cruxrealtimedeviation", task.get("realtimedeviation"), rowIndex);
        DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
        if (responsiblePerson != null) {
            this.getModel().setValue("cruxresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        if ((responsibleDept = task.getDynamicObject("responsibledept")) != null) {
            this.getModel().setValue("cruxresponsibledept", (Object)responsibleDept.getString("name"), rowIndex);
        }
        if ((cooperationPersons = task.getDynamicObjectCollection("multicooperationperson")) != null && cooperationPersons.size() > 0) {
            StringBuilder cooPersonStr = new StringBuilder();
            cooperationPersons.stream().map(o -> cooPersonStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
            if (cooPersonStr.length() > 0) {
                cooPersonStr.deleteCharAt(cooPersonStr.length() - 1);
            }
            this.getModel().setValue("cruxcooperationperson", (Object)cooPersonStr, rowIndex);
        }
        if ((cooperationDepts = task.getDynamicObjectCollection("multicooperationdept")) != null && cooperationDepts.size() > 0) {
            StringBuilder cooDeptsStr = new StringBuilder();
            cooperationDepts.stream().map(o -> cooDeptsStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
            if (cooDeptsStr.length() > 0) {
                cooDeptsStr.deleteCharAt(cooDeptsStr.length() - 1);
            }
            this.getModel().setValue("cruxcooperationdept", (Object)cooDeptsStr, rowIndex);
        }
        this.getModel().setValue("cruxversion", task.get("version"), rowIndex);
        CellStyle style = new CellStyle();
        style.setRow(rowIndex);
        style.setFieldKey("cruxtaskname");
        String riskColor = task.getString("riskcolor");
        if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
            style.setBackColor("yellow");
        } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
            style.setBackColor("#FD6C6A");
        }
        styles.add(style);
    }

    protected void setThisCycleTaskDetail(DynamicObject task, int rowIndex, List<CellStyle> styles) {
        DynamicObject responsiblePerson;
        DynamicObject majorType;
        this.getModel().setValue("thistaskstatus", task.get("completionstatus"), rowIndex);
        this.getModel().setValue("thiscycletaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskType != null) {
            this.getModel().setValue("thistasktype", (Object)taskType.getString("name"), rowIndex);
        }
        if ((majorType = task.getDynamicObject("majortype")) != null) {
            this.getModel().setValue("thismajorname", (Object)majorType.getString("name"), rowIndex);
        }
        if ((responsiblePerson = task.getDynamicObject("responsibleperson")) != null) {
            this.getModel().setValue("thisresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        this.getModel().setValue("thisplanendtime", task.get("planendtime"), rowIndex);
        this.getModel().setValue("thisrealendtime", task.get("realendtime"), rowIndex);
        this.getModel().setValue("thisrealtimedeviation", task.get("realtimedeviation"), rowIndex);
        this.getModel().setValue("thisversion", task.get("version"), rowIndex);
        CellStyle style = new CellStyle();
        style.setRow(rowIndex);
        style.setFieldKey("thiscycletaskname");
        String riskColor = task.getString("riskcolor");
        if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
            style.setBackColor("yellow");
        } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
            style.setBackColor("#FD6C6A");
        }
        styles.add(style);
    }

    protected void setNextCycleTaskDetail(DynamicObject task, int rowIndex, List<CellStyle> styles) {
        DynamicObjectCollection cooperationPersons;
        DynamicObject majorType;
        this.getModel().setValue("nextcycletaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskType != null) {
            this.getModel().setValue("nexttasktype", (Object)taskType.getString("name"), rowIndex);
        }
        if ((majorType = task.getDynamicObject("majortype")) != null) {
            this.getModel().setValue("nextmajorname", (Object)majorType.getString("name"), rowIndex);
        }
        this.getModel().setValue("nextplanstarttime", task.get("planstarttime"), rowIndex);
        this.getModel().setValue("nextplanendtime", task.get("planendtime"), rowIndex);
        DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
        if (responsiblePerson != null) {
            this.getModel().setValue("nextresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        if ((cooperationPersons = task.getDynamicObjectCollection("multicooperationperson")) != null && cooperationPersons.size() > 0) {
            StringBuilder cooPersonStr = new StringBuilder();
            cooperationPersons.stream().map(o -> cooPersonStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
            if (cooPersonStr.length() > 0) {
                cooPersonStr.deleteCharAt(cooPersonStr.length() - 1);
            }
            this.getModel().setValue("nextcooperationperson", (Object)cooPersonStr, rowIndex);
        }
        this.getModel().setValue("nextversion", task.get("version"), rowIndex);
        CellStyle style = new CellStyle();
        style.setRow(rowIndex);
        style.setFieldKey("nextcycletaskname");
        String riskColor = task.getString("riskcolor");
        if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
            style.setBackColor("yellow");
        } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
            style.setBackColor("#FD6C6A");
        }
        styles.add(style);
    }

    protected QFilter getCommonFilter() {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        QFilter isLastFilter = new QFilter("islatest", "=", (Object)"1");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter notFenJieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        QFilter relationFilter = new QFilter("relationtask", "=", (Object)0);
        return isLastFilter.and(projectFilter).and(statusFilter).and(notFenJieFilter).and(relationFilter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            String orgId = org.getString("id");
            QFilter orgFilter = new QFilter("useorg", "=", (Object)Long.valueOf(orgId));
            beforeF7SelectEvent.getCustomQFilters().add(orgFilter);
        }
    }
}

