/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.permission.PermServiceHelper;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;
import kd.pccs.placs.formplugin.helper.TreeEntryGridHelper;

public class ProPlanMonitorListPlugin
extends AbstractPlacsListPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ProPlanMonitorListPlugin.class);
    private static final String KEY_TREEENTRYENTITY = "taskentity";
    private static final String CODE_EXPORT = "export";
    public static final String PROJECT_ITEM_CACHE = "projectitem";
    public static final String QUICK_FILTER_PROPERTY = "1";
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();
    private static final int MAX_LEVEL = 6;
    private static final int TAB_SIZE = 1;
    private static final String LEVEL = "level";
    private static String[] COLUMNKEY = new String[]{"taskname", "completionstatus", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "pretaskname", "planstarttime", "planendtime", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "resultdoc"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"ProPlanMonitorListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"ProPlanMonitorListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"ProPlanMonitorListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"ProPlanMonitorListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"ProPlanMonitorListPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"ProPlanMonitorListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"ProPlanMonitorListPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6\uff08%\uff09", (String)"ProPlanMonitorListPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"ProPlanMonitorListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"ProPlanMonitorListPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"ProPlanMonitorListPlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"ProPlanMonitorListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"ProPlanMonitorListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"ProPlanMonitorListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u679c", (String)"ProPlanMonitorListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0])};

    private String getFileName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u76d1\u63a7", (String)"ProPlanMonitorListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"ProPlanMonitorListPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.levelLableAddListener(6, 1);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideLevelNum();
    }

    protected void levelLableAddListener(int maxLevel, int tabSize) {
        for (int i = 1; i <= maxLevel * tabSize; ++i) {
            Label level = (Label)this.getControl("level_" + i);
            level.addClickListener((ClickListener)this);
        }
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (null == map || map.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    protected void hideLevelNum() {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (taskEntries.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
        }
        int maxLevel = 0;
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DynamicObject taskEnetity : taskEntries) {
            map.put(taskEnetity.getString("id"), taskEnetity.getLong("pid"));
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        maxLevel = max.isPresent() ? max.get() : 0;
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        for (int i = 1; i <= 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                if (maxLevel < i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String levelColKey = "";
        String treeEntityKey = "";
        if (key.contains(LEVEL)) {
            int level = Integer.parseInt(key.split("_")[1]);
            if (level <= 6 && level > 0) {
                treeEntityKey = KEY_TREEENTRYENTITY;
                levelColKey = "task";
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeEntityKey);
            Map all = this.getPageCache().getAll();
            all.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("@taskId")).forEach(entry -> this.taskLevelMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("@taskId")), Integer.valueOf((String)entry.getValue())));
            TreeEntryGridHelper.expandNodes(treeEntryGrid, levelColKey, level, this.taskLevelMap);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_EXPORT.equals(operateKey)) {
            this.doExportExcel();
        }
    }

    private void doExportExcel() {
        DynamicObjectCollection rowData = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (!rowData.isEmpty()) {
            JSONArray data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject row : rowData) {
                JSONObject obj = new JSONObject();
                DynamicObject task = row.getDynamicObject("task");
                obj.put("taskname", (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("completionstatus", (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                this.putProjectNameToJson(obj, task);
                obj.put("controllevelname", task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("majortypename", task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("tasktype", task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("absoluteduration", (Object)task.getInt("absoluteduration"));
                obj.put("percent", (Object)task.getBigDecimal("percent").setScale(2));
                obj.put("pretaskname", task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
                obj.put("planendtime", (Object)sdf.format(task.get("planendtime")));
                obj.put("responsiblepersonname", task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("responsibledeptname", task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                StringBuilder cooPersonsStr = new StringBuilder();
                cooPersons.stream().map(o -> cooPersonsStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
                if (cooPersonsStr.length() > 0) {
                    cooPersonsStr.deleteCharAt(cooPersonsStr.length() - 1);
                }
                obj.put("cooperationpersonsname", (Object)cooPersonsStr);
                obj.put("resultdoc", task.get("resultdoc"));
                data.add((Object)obj);
            }
            String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
            this.getView().download(url);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ProPlanMonitorListPlugin_21", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void putProjectNameToJson(JSONObject obj, DynamicObject task) {
        obj.put("project", task.getDynamicObject("project") == null ? null : task.getDynamicObject("project").getLocaleString("name").getLocaleValue_zh_CN());
    }

    protected void doFilterBulding(FilterGridView filterGridView, String projectId) {
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
        if (StringUtils.equals((CharSequence)"taskname", (CharSequence)fieldName) && task != null) {
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
        if (StringUtils.equals((CharSequence)"meetassigncount", (CharSequence)fieldName)) {
            if (task == null) {
                return;
            }
            if (task.getLong("meetassigncount") == 0L) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8be5\u4efb\u52a1\u65e0\u4f1a\u8bae\u51b3\u8bae\u3002", (String)"ProPlanMonitorListPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(paramMap);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String beFirst;
        DynamicObject[] taskTypes;
        DynamicObject[] levels;
        List list = args.getCommonFilterColumns();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        List orgList = PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)((ListView)this.getView()).getBillFormId(), (String)"view");
        CommonFilterColumn projectColumn = (CommonFilterColumn)list.get(0);
        String projectId = null;
        List<ComboItem> proComboItems = this.buildProComboItems(orgList, RequestContext.get().getUserId());
        List proItemIds = proComboItems.stream().map(item -> item.getId()).collect(Collectors.toList());
        this.getPageCache().put(PROJECT_ITEM_CACHE, JSON.toJSONString(proItemIds));
        projectColumn.setMustInput(true);
        if (!proComboItems.isEmpty()) {
            projectColumn.setComboItems(proComboItems);
            projectId = proComboItems.get(0).getValue();
            projectColumn.setDefaultValue(projectId);
        } else {
            this.setProjectColDefaultByInit(projectColumn, proComboItems);
        }
        if (this.getView().getFormShowParameter().getCustomParam("proId") != null) {
            projectId = (String)this.getView().getFormShowParameter().getCustomParam("proId");
        }
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(1);
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(projectId);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
        this.doFilterBulding(filterGridView, projectId);
        CommonFilterColumn controllevelColum = (CommonFilterColumn)list.get(2);
        List controllevelItems = controllevelColum.getComboItems();
        ArrayList<Object> new_controllevelItems = new ArrayList<Object>(10);
        ArrayList<String> levelIds = new ArrayList<String>(10);
        for (ComboItem comboItem : controllevelItems) {
            levelIds.add(comboItem.getValue());
        }
        ArrayList<QFilter> levelFilters = new ArrayList<QFilter>(10);
        List levelIdList = levelIds.stream().filter(StringUtils::isNotBlank).map(id -> Long.valueOf(id)).collect(Collectors.toList());
        QFilter levelIdFilter = new QFilter("id", "in", levelIdList);
        levelFilters.add(levelIdFilter);
        QFilter levelEnableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        levelFilters.add(levelEnableFilter);
        for (DynamicObject level : levels = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"controllevel"), (String)"id,name", (QFilter[])levelFilters.toArray(new QFilter[levelFilters.size()]))) {
            ComboItem item2 = new ComboItem();
            item2.setId(String.valueOf(level.getPkValue()));
            item2.setCaption(new LocaleString(level.getString("name")));
            item2.setValue(String.valueOf(level.getPkValue()));
            new_controllevelItems.add(item2);
        }
        controllevelColum.setComboItems(new_controllevelItems);
        CommonFilterColumn taskTypeColum = (CommonFilterColumn)list.get(3);
        List taskTypeItems = taskTypeColum.getComboItems();
        ArrayList<ComboItem> new_taskTypeItems = new ArrayList<ComboItem>(10);
        ArrayList<Long> typeIds = new ArrayList<Long>(10);
        for (ComboItem comboItem : taskTypeItems) {
            if (!StringUtils.isNotBlank((CharSequence)comboItem.getValue())) continue;
            typeIds.add(Long.valueOf(comboItem.getValue()));
        }
        ArrayList<QFilter> typeFilters = new ArrayList<QFilter>(10);
        QFilter typeIdFilter = new QFilter("id", "in", (Object)typeIds.toArray());
        typeFilters.add(typeIdFilter);
        QFilter typeEnableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        typeFilters.add(typeEnableFilter);
        QFilter isProjectFilter = new QFilter("checkboxisprojecttask", "=", (Object)DefaultEnum.YES.getValue());
        isProjectFilter.or(new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue()));
        typeFilters.add(isProjectFilter);
        for (DynamicObject type : taskTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id,name", (QFilter[])typeFilters.toArray(new QFilter[typeFilters.size()]), (String)"id desc")) {
            ComboItem item3 = new ComboItem();
            item3.setId(String.valueOf(type.getPkValue()));
            item3.setCaption(new LocaleString(type.getString("name")));
            item3.setValue(String.valueOf(type.getPkValue()));
            new_taskTypeItems.add(item3);
        }
        taskTypeColum.setComboItems(new_taskTypeItems);
        Object planTypeId = this.getView().getFormShowParameter().getCustomParam("planTypeId");
        Object proId = this.getView().getFormShowParameter().getCustomParam("proId");
        if (null != planTypeId && null != proId) {
            planTypeCommonFilterColumn.setDefaultValue(String.valueOf(planTypeId));
            projectColumn.setDefaultValue(String.valueOf(proId));
        }
        if ((beFirst = this.getPageCache().get("beFirst")) == null || beFirst.equals("true")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            int proIndex = -1;
            List items = filterGridView.getItems();
            for (int i = 0; i < items.size(); ++i) {
                CommonFilterColumn filterColumn = (CommonFilterColumn)items.get(i);
                if (!filterColumn.getFieldName().equals("project.name") && !filterColumn.getFieldName().equals("project.fullname")) continue;
                proIndex = i;
                break;
            }
            if (customParams.get("project") != null && proIndex >= 0) {
                ((CommonFilterColumn)filterGridView.getItems().get(proIndex)).setDefaultValue(customParams.get("project").toString());
            }
            this.getPageCache().put("beFirst", "false");
        }
        super.filterContainerInit(args);
    }

    protected void saveOrgIds(List<Long> orgList) {
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List orgList = PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)((ListView)this.getView()).getBillFormId(), (String)"view");
        this.saveOrgIds(orgList);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        List items = filterGridView.getItems();
        Object projectId = args.getFilterValue("project.id");
        List<ComboItem> proComboItems = this.buildProComboItems(orgList, RequestContext.get().getUserId());
        List proItemIds = proComboItems.stream().map(item -> item.getId()).collect(Collectors.toList());
        this.getPageCache().put(PROJECT_ITEM_CACHE, JSON.toJSONString(proItemIds));
        ComboItem proComboItem = null;
        CommonFilterColumn projectFilterColumn = (CommonFilterColumn)items.get(0);
        if (projectFilterColumn != null) {
            projectFilterColumn.setMustInput(true);
            this.setProjectFilterColumn(projectId, proComboItems, proComboItem, projectFilterColumn, args);
        }
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)items.get(1);
        String curSelectedProId = this.getPageCache().get("curSelectedProId");
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(curSelectedProId);
        Object planType = args.getFilterValue("belongplantype.id");
        this.setPlanTypeFilterColumn(planType, planTypeComboItems, planTypeCommonFilterColumn, args);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
        this.doFilterBulding(filterGridView, curSelectedProId);
        super.filterContainerSearchClick(args);
    }

    protected void setPlanTypeFilterColumn(Object planType, List<ComboItem> planTypeComboItems, CommonFilterColumn planTypeCommonFilterColumn, FilterContainerSearchClickArgs args) {
        ArrayList<String> planTypeList = new ArrayList<String>(10);
        if (planType != null && !planTypeComboItems.isEmpty()) {
            if (planType instanceof ArrayList) {
                block0: for (Object planTypeId : (ArrayList)planType) {
                    for (ComboItem comboItem : planTypeComboItems) {
                        if (!comboItem.getValue().equals(planTypeId.toString())) continue;
                        planTypeList.add(comboItem.getValue());
                        continue block0;
                    }
                }
            } else {
                for (ComboItem comboItem : planTypeComboItems) {
                    if (!comboItem.getValue().equals(planType.toString())) continue;
                    planTypeList.add(comboItem.getValue());
                    break;
                }
            }
            if (planTypeList.isEmpty()) {
                String curPlanType = planTypeComboItems.get(0).getValue();
                Map filterValues = args.getFilterValues();
                List customfilter = (List)filterValues.get("customfilter");
                if (customfilter != null) {
                    for (Map map : customfilter) {
                        List values;
                        List fieldName = (List)map.get("FieldName");
                        if (!fieldName.contains("belongplantype.id") || (values = (List)map.get("Value")) == null || values.size() <= 0) continue;
                        values.clear();
                        values.add(curPlanType);
                    }
                }
                planTypeCommonFilterColumn.setDefaultValue(curPlanType);
            } else {
                planTypeCommonFilterColumn.setDefaultValues(planTypeList);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("project.id".equals(fieldName) || "project.name".equals(fieldName) || "project.fullname".equals(fieldName)) {
            String projItemStr = this.getPageCache().get(PROJECT_ITEM_CACHE);
            List projItemList = (List)JSON.parseObject((String)projItemStr, (TypeReference)new TypeReference<ArrayList<String>>(){}, (Feature[])new Feature[0]);
            List proIds = projItemList.stream().map(pro -> Long.valueOf(pro)).collect(Collectors.toList());
            args.addCustomQFilter(new QFilter("id", "in", proIds));
        }
    }

    protected String setProjectBizOrgFileName() {
        return "org";
    }

    protected String setProjectFileName() {
        return "project.createorg.id";
    }

    protected void setProjectColDefaultByClick(List<Control> items) {
    }

    protected void setProjectColDefaultByInit(CommonFilterColumn projectColumn, List<ComboItem> proComboItems) {
        projectColumn.setComboItems(proComboItems);
    }

    protected void setProjectFilterColumn(Object projectId, List<ComboItem> proComboItems, ComboItem proComboItem, CommonFilterColumn projectFilterColumn) {
        if (!proComboItems.isEmpty()) {
            projectFilterColumn.setComboItems(proComboItems);
            for (ComboItem comboItem : proComboItems) {
                if (projectId == null || !comboItem.getValue().equals(projectId.toString())) continue;
                proComboItem = comboItem;
                break;
            }
            if (proComboItem == null) {
                projectFilterColumn.setDefaultValue(proComboItems.get(0).getValue());
            } else {
                projectFilterColumn.setDefaultValue(proComboItem.getValue());
            }
        }
    }

    protected void setProjectFilterColumn(Object projectId, List<ComboItem> proComboItems, ComboItem proComboItem, CommonFilterColumn projectFilterColumn, FilterContainerSearchClickArgs args) {
        if (!proComboItems.isEmpty()) {
            String curProId;
            projectFilterColumn.setComboItems(proComboItems);
            for (ComboItem comboItem : proComboItems) {
                if (projectId == null || !comboItem.getValue().equals(projectId.toString())) continue;
                proComboItem = comboItem;
                break;
            }
            if (proComboItem == null) {
                curProId = proComboItems.get(0).getValue();
                this.getPageCache().put("curSelectedProId", curProId);
                this.resetFilterFieldValue(args, "project.id", curProId);
                projectFilterColumn.setDefaultValue(curProId);
            } else {
                curProId = proComboItem.getValue();
                this.getPageCache().put("curSelectedProId", curProId);
                projectFilterColumn.setDefaultValue(curProId);
            }
        } else {
            this.getPageCache().remove("curSelectedProId");
            projectFilterColumn.setComboItems(proComboItems);
        }
    }

    protected void resetFilterFieldValue(FilterContainerSearchClickArgs args, String field, String curFieldValue) {
        Map filterValues = args.getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter != null) {
            for (Map map : customfilter) {
                List values;
                List fieldName = (List)map.get("FieldName");
                if (!fieldName.contains(field) || (values = (List)map.get("Value")) == null || values.size() <= 0) continue;
                values.clear();
                values.add(curFieldValue);
            }
        }
    }

    protected boolean isNeedParse(List<QFilter> filters) {
        return filters != null && filters.size() == 1 && (filters.get(0).toString().contains("AND") || filters.get(0).toString().contains("OR"));
    }

    protected void doParse(List<QFilter> filters) {
        logger.info(String.format("<<<<<log>>>>> \u89e3\u6790\u524d\u7684filters: %s", filters));
        QFilter filter = filters.get(0);
        filters.clear();
        filters.add(new QFilter(filter.getProperty(), filter.getCP(), filter.getValue()));
        List nests = filter.getNests(true);
        QFilter planStartTime = null;
        QFilter planEndTime = null;
        for (QFilter.QFilterNest nest : nests) {
            QFilter qFilter = nest.getFilter();
            if (qFilter.getProperty().equals("planstarttime")) {
                if (planStartTime == null) {
                    planStartTime = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
                } else {
                    planStartTime.and(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
                }
            }
            if (qFilter.getProperty().equals("planendtime")) {
                if (planEndTime == null) {
                    planEndTime = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
                } else {
                    planEndTime.and(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
                }
            }
            if (qFilter.getProperty().equals("planstarttime") || qFilter.getProperty().equals("planendtime")) continue;
            filters.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        }
        if (null != planStartTime) {
            filters.add(planStartTime);
        }
        if (null != planEndTime) {
            filters.add(planEndTime);
        }
        logger.info(String.format("<<<<<log>>>>> \u53cd\u89e3\u6790\u751f\u6210\u7684\u8fc7\u6ee4\u6761\u4ef6:%s", filters));
    }

    public void setFilter(SetFilterEvent e) {
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        List<Object> filters = filterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        if (!(filters != null && filters.size() != 0 || (filters = e.getQFilters()) != null && filters.size() != 0)) {
            return;
        }
        if (this.isNeedParse((List<QFilter>)filters)) {
            ArrayList<QFilter> originFilter = new ArrayList<QFilter>(filters);
            ListCache listCache = new ListCache(this.getPageCache());
            filters = listCache.getListViewFilterParameter().getQFilters();
            if (filters == null || filters.size() == 0) {
                filters = e.getQFilters();
            }
            if (this.isNeedParse((List<QFilter>)filters)) {
                this.doParse(originFilter);
                filters = originFilter;
            }
        }
        List fastFilters = filterContainer.getContext().getFastQueryFilterParameter().getQFilters();
        filters.addAll(fastFilters);
        logger.info(String.format("<<<<<log>>>>> filters: %s", filters));
        HashMap<String, QFilter> taskFilterMap = new HashMap<String, QFilter>(16);
        ArrayList<QFilter> planFilters = new ArrayList<QFilter>(10);
        boolean hasCheckProjectFilter = false;
        QFilter projectFilter = null;
        QFilter majorTypeFilter = null;
        for (QFilter qFilter : filters) {
            String property = qFilter.getProperty();
            if (this.setProjectFileName().equals(property)) continue;
            if ("belongplantype.id".equals(property)) {
                majorTypeFilter = new QFilter("id", "in", qFilter.getValue());
                QFilter majorTypeIdFilter = new QFilter("majortype", "in", qFilter.getValue());
                planFilters.add(majorTypeIdFilter);
                continue;
            }
            if ("project.id".equals(property)) {
                projectFilter = new QFilter("project", "=", qFilter.getValue());
                planFilters.add(projectFilter);
                hasCheckProjectFilter = true;
                continue;
            }
            taskFilterMap.put(qFilter.getProperty(), qFilter);
        }
        if (!hasCheckProjectFilter) {
            return;
        }
        QFilter planTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
        DynamicObject mainPlanMajor = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"plantypename", (QFilter[])new QFilter[]{planTypeFilter});
        boolean isExistMainMajor = false;
        if (majorTypeFilter != null) {
            Object value = majorTypeFilter.getValue();
            if (value instanceof ArrayList) {
                ArrayList majors = (ArrayList)value;
                if (mainPlanMajor != null && majors.contains(mainPlanMajor.getPkValue())) {
                    isExistMainMajor = true;
                }
            }
        } else {
            isExistMainMajor = true;
        }
        logger.info(String.format("<<<<<log>>>>> filters control  dataMap: %s", taskFilterMap));
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        planFilters.add(planVersion);
        this.modifyPlanFilter(filters, planFilters);
        DynamicObject[] masterPlans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"id,majortype,relationtask,taskentity.id,taskentity.taskid,taskentity.level,taskentity.pid", (QFilter[])planFilters.toArray(new QFilter[planFilters.size()]));
        HashSet<String> allTaskids = new HashSet<String>(16);
        this.getAllTaskByProjectPlans(masterPlans, allTaskids, isExistMainMajor);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter planStatusFilter = new QFilter("islatest", "=", (Object)QUICK_FILTER_PROPERTY);
        DynamicObject assignTaskPlanType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ASSIGNTASK_S")});
        QFilter belogPlanTypeFilter = new QFilter("belongplantype", "=", null == assignTaskPlanType ? Long.valueOf(0L) : assignTaskPlanType.getPkValue());
        boolean isNeedAddAssignTask = false;
        if (majorTypeFilter != null) {
            Object value = majorTypeFilter.getValue();
            if (value instanceof ArrayList) {
                ArrayList belongTypes = (ArrayList)value;
                if (assignTaskPlanType != null && belongTypes.contains(assignTaskPlanType.getPkValue())) {
                    isNeedAddAssignTask = true;
                }
            } else if (assignTaskPlanType != null && majorTypeFilter.getValue().equals(assignTaskPlanType.getPkValue())) {
                isNeedAddAssignTask = true;
            }
        } else {
            isNeedAddAssignTask = true;
        }
        if (isNeedAddAssignTask) {
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{statusFilter, projectFilter, belogPlanTypeFilter, planStatusFilter});
            allTaskids.addAll(Arrays.stream(tasks).map(t -> String.valueOf(t.getPkValue())).collect(Collectors.toList()));
        }
        if (!allTaskids.isEmpty()) {
            this.fillTreeList(taskFilterMap, allTaskids, isExistMainMajor);
        }
    }

    protected void modifyPlanFilter(List<QFilter> oldFilters, List<QFilter> planFilters) {
    }

    protected void fillTreeList(Map<String, QFilter> taskFilterMap, Set<String> allTaskids, boolean isExistMainMajor) {
        DynamicObject[] allTasks;
        DynamicObjectCollection showTaskCol = new DynamicObjectCollection();
        QFilter ids = new QFilter("id", "in", allTaskids.stream().filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList()));
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        for (DynamicObject task : allTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,parent,tasktype,taskseq,controllevel,planstarttime,planendtime,sourcetask,status,completionstatus,realtimedeviation,comptimedeviation,level,relationtask,riskcolor,completedescription,realendtime,multibuilding", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq")) {
            boolean isShow = this.judgeTaskIsShow(task, taskFilterMap);
            if (!isShow) continue;
            showTaskCol.add((Object)task);
        }
        if (!showTaskCol.isEmpty()) {
            this.fillTreeListByShowTask(showTaskCol, isExistMainMajor);
        }
    }

    protected void getAllTaskByProjectPlans(DynamicObject[] projectPlans, Set<String> allTaskids, boolean isExistMainMajor) {
        for (DynamicObject plan : projectPlans) {
            List taskIds;
            DynamicObjectCollection taskEntry;
            if (PlanTypeEnum.MAINPLAN.getValue().equals(plan.getDynamicObject("majortype").getString("plantype"))) {
                taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
                if (taskEntry == null || taskEntry.isEmpty()) continue;
                taskIds = taskEntry.stream().map(entry -> entry.get("id").toString()).collect(Collectors.toList());
                allTaskids.addAll(taskIds);
                continue;
            }
            if (!PlanTypeEnum.MAJORPLAN.getValue().equals(plan.getDynamicObject("majortype").getString("plantype")) || (taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY)) == null || taskEntry.isEmpty()) continue;
            taskIds = isExistMainMajor ? taskEntry.stream().filter(entry -> entry.getDynamicObject("relationtask") == null).map(entry -> entry.get("id").toString()).collect(Collectors.toList()) : taskEntry.stream().map(entry -> entry.get("id").toString()).collect(Collectors.toList());
            allTaskids.addAll(taskIds);
        }
    }

    protected boolean judgeTaskIsShow(DynamicObject task, Map<String, QFilter> taskFilterMap) {
        String valueStr;
        QFilter quickFilter;
        Object value;
        Long bigMillisecond;
        Object bigTime;
        Long smallMillisecond;
        Date smallTime;
        QFilter time;
        ArrayList<Long> levelList = null;
        ArrayList<String> statusList = null;
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskFilterMap.get("tasktype.id") != null && taskType != null) {
            Object typeIds = taskFilterMap.get("tasktype.id").getValue();
            ArrayList<Long> taskTypeList = new ArrayList<Long>(10);
            if (typeIds instanceof List) {
                for (Object obj : (List)typeIds) {
                    taskTypeList.add((Long)obj);
                }
            } else {
                taskTypeList.add((Long)typeIds);
            }
            if (!taskTypeList.contains(taskType.getPkValue())) {
                return false;
            }
        }
        Object controllevel = task.get("controllevel.id");
        if (taskFilterMap.get("controllevel.id") != null) {
            Object levelIds = taskFilterMap.get("controllevel.id").getValue();
            levelList = new ArrayList<Long>(10);
            if (levelIds instanceof List) {
                for (Object obj : (List)levelIds) {
                    levelList.add((Long)obj);
                }
            } else {
                levelList.add((Long)levelIds);
            }
            if (controllevel == null || !levelList.contains(controllevel)) {
                return false;
            }
        }
        Object completionStatus = task.get("completionstatus");
        if (taskFilterMap.get("completionstatus") != null) {
            Object statusIds = taskFilterMap.get("completionstatus").getValue();
            statusList = new ArrayList<String>(10);
            if (statusIds instanceof List) {
                for (Object obj : (List)statusIds) {
                    statusList.add((String)obj);
                }
            } else {
                statusList.add(statusIds.toString());
            }
            if (completionStatus == null || !statusList.contains(completionStatus)) {
                return false;
            }
        }
        Date planstarttime = task.getDate("planstarttime");
        Long startMillisecond = planstarttime.getTime();
        Date planendtime = task.getDate("planendtime");
        Long endMillisecond = planendtime.getTime();
        if (taskFilterMap.get("planstarttime") != null) {
            time = taskFilterMap.get("planstarttime");
            smallTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getParent().getValue();
            smallMillisecond = smallTime.getTime();
            bigTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getFilter().getValue();
            bigMillisecond = ((Date)bigTime).getTime();
            if (startMillisecond < smallMillisecond || startMillisecond >= bigMillisecond) {
                return false;
            }
        }
        if (taskFilterMap.get("planendtime") != null) {
            time = taskFilterMap.get("planendtime");
            smallTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getParent().getValue();
            smallMillisecond = smallTime.getTime();
            bigTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getFilter().getValue();
            bigMillisecond = ((Date)bigTime).getTime();
            if (endMillisecond < smallMillisecond || endMillisecond >= bigMillisecond) {
                return false;
            }
        }
        String color = task.getString("riskcolor");
        if (taskFilterMap.get("riskcolor") != null) {
            Object riskcolor = taskFilterMap.get("riskcolor").getValue();
            ArrayList<String> colorList = new ArrayList<String>(10);
            if (riskcolor instanceof List) {
                for (Object obj : (List)riskcolor) {
                    colorList.add((String)obj);
                }
            } else {
                colorList.add((String)riskcolor);
            }
            if (!colorList.contains(color)) {
                if (!colorList.contains(RiskColorEnum.NOCOLOR.getValue())) {
                    return false;
                }
                if (RiskColorEnum.YELLOW.getValue().equals(color) || RiskColorEnum.RED.getValue().equals(color)) {
                    return false;
                }
            }
        }
        String taskName = task.getString("name");
        if (taskFilterMap.get(QUICK_FILTER_PROPERTY) != null && (value = this.getQuickfilterValue(quickFilter = taskFilterMap.get(QUICK_FILTER_PROPERTY))) instanceof String && !taskName.contains(valueStr = (String)value)) {
            return false;
        }
        return this.busiTaskFilter(task, taskFilterMap);
    }

    protected boolean busiTaskFilter(DynamicObject task, Map<String, QFilter> taskFilterMap) {
        return true;
    }

    protected Object getQuickfilterValue(QFilter quickFilter) {
        String property = quickFilter.getProperty();
        Object value = quickFilter.getValue();
        String fieldValue = "";
        if (StringUtils.equals((CharSequence)property, (CharSequence)QUICK_FILTER_PROPERTY)) {
            String valueStr;
            if (value instanceof String && StringUtils.isNotEmpty((CharSequence)(valueStr = (String)value))) {
                String[] fieldAndName = valueStr.split("#");
                fieldValue = fieldAndName[1];
            }
        } else {
            return value;
        }
        return fieldValue;
    }

    public List<ComboItem> buildProComboItems(List<Long> orgList, String userId) {
        DynamicObject[] projects = this.getProjByOrgList(orgList, userId);
        return this.loadProComboItems(projects);
    }

    protected Map<String, Object> getPermObj(String entityNum, String operateNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        for (Map operate : dataEntityOperate) {
            String operateKey = (String)operate.get("key");
            if (!operateKey.equals(operateNum)) continue;
            String permItemPk = (String)operate.get("permission");
            if (permItemPk == null) break;
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)permItemPk, (String)"perm_permitem");
            String permNumber = object.getString("number");
            String permName = object.getString("name");
            map.put("id", permItemPk);
            map.put("permNumber", permNumber);
            map.put("permName", permName);
            break;
        }
        return map;
    }

    protected DynamicObject[] getProjByOrgList(List<Long> orgIdList, String userId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (orgIdList != null && orgIdList.size() > 0) {
            QFilter orgFilter = new QFilter(this.setProjectBizOrgFileName(), "in", orgIdList);
            qFilters.add(orgFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,billname,billno,billstatus", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"createtime desc");
        return projects;
    }

    private static Set<Long> getChargerOrgIds(String userId) {
        ArrayList<Long> userids = new ArrayList<Long>(10);
        userids.add(Long.valueOf(userId));
        List position = UserServiceHelper.getPosition(userids);
        HashSet<Long> charOrgIds = new HashSet<Long>(16);
        for (Object o : position) {
            ArrayList entries = (ArrayList)((HashMap)o).get("entryentity");
            if (entries == null) continue;
            for (HashMap map : entries) {
                Boolean isincharge = (Boolean)map.get("isincharge");
                DynamicObject org = (DynamicObject)map.get("dpt");
                if (org == null || !isincharge.booleanValue()) continue;
                List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(org.getPkValue().toString())).collect(Collectors.toList()), (boolean)true);
                charOrgIds.addAll(allSubordinateOrgs);
            }
        }
        return charOrgIds;
    }

    protected List<ComboItem> loadProComboItems(DynamicObject[] projects) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject project : projects) {
            ComboItem item = new ComboItem();
            item.setId(project.getPkValue().toString());
            item.setCaption(new LocaleString(project.getString("name")));
            item.setValue(project.getPkValue().toString());
            combos.add(item);
        }
        return combos;
    }

    protected List<ComboItem> buildPlanTypeComboItems(Object projectId) {
        String[] planTypeArray;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        QFilter filter = null;
        if (projectId != null) {
            planTypeArray = new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.MAJORPLAN.getValue(), PlanTypeEnum.ASSIGNTASK.getValue()};
            filter = new QFilter("plantype", "in", (Object)planTypeArray);
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)this.getProjectFormId());
            QFilter filter1 = this.getQFilterByProjectGroup(project);
            if (filter1 != null) {
                filter.and(filter1);
            }
        } else {
            planTypeArray = new String[]{PlanTypeEnum.MAINPLAN.getValue()};
            filter = new QFilter("plantype", "in", (Object)planTypeArray);
        }
        filter.and("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject[] planTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantype"), (String)"plantype", (QFilter[])new QFilter[]{filter}, (String)"plantype asc,number asc");
        if (planTypes.length > 0) {
            for (DynamicObject planType : planTypes) {
                ComboItem item = new ComboItem();
                item.setId(planType.getPkValue().toString());
                OrmLocaleValue type = (OrmLocaleValue)planType.get("name");
                item.setCaption(new LocaleString(type.getLocaleValue()));
                item.setValue(planType.getPkValue().toString());
                if (PlanTypeEnum.getEnumByValue((Object)planType.get("plantype")) == PlanTypeEnum.ASSIGNTASK) {
                    combos.add(0, item);
                    continue;
                }
                combos.add(item);
            }
        }
        return combos;
    }

    protected QFilter getQFilterByProjectGroup(DynamicObject project) {
        DynamicObject kind = this.getProjectKind(project);
        QFilter filter = new QFilter("group", "=", (Object)0L);
        if (kind != null) {
            filter.or(new QFilter("group", "=", kind.getPkValue()));
        }
        return filter;
    }

    protected DynamicObject getProjectKind(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    private void fillTreeList(IDataModel model, DynamicObjectCollection allTasks, DynamicObjectCollection parents, boolean isRoot, int rowIndex) {
        if (allTasks == null || allTasks.isEmpty()) {
            return;
        }
        parents.sort(Comparator.comparing(task -> task.getInt("taskseq")));
        for (int i = 0; i < parents.size(); ++i) {
            DynamicObject parent = (DynamicObject)parents.get(i);
            allTasks.remove((Object)parent);
            int rIndex = 0;
            rIndex = isRoot ? model.createNewEntryRow(KEY_TREEENTRYENTITY) : model.insertEntryRow(KEY_TREEENTRYENTITY, rowIndex);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            grid.setCollapse(false);
            grid.getModel().updateCache();
            model.setValue("task", parent.getPkValue(), rIndex);
            String completionstatus = parent.getString("completionstatus");
            model.setValue("completionstatus", (Object)completionstatus, rIndex);
            CellStyle style = new CellStyle();
            style.setRow(rIndex);
            style.setFieldKey("comptimedeviation");
            BigDecimal comptimedeviation = parent.getBigDecimal("comptimedeviation");
            if (BigDecimal.ZERO.compareTo(comptimedeviation) > 0) {
                style.setForeColor("red");
            } else if (BigDecimal.ZERO.compareTo(comptimedeviation) < 0) {
                style.setForeColor("green");
            }
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            styles.add(style);
            grid.setCellStyle(styles);
            DynamicObjectCollection sons = new DynamicObjectCollection();
            Object parentId = parent.getPkValue();
            for (DynamicObject task2 : allTasks) {
                Object taskParentId = task2.get("parent.id");
                if (parentId == null || taskParentId == null || !parentId.toString().equals(taskParentId.toString())) continue;
                sons.add((Object)task2);
            }
            if (sons.isEmpty()) continue;
            this.fillTreeList(model, allTasks, sons, false, rIndex);
        }
    }

    protected void fillTreeListByShowTask(DynamicObjectCollection allTaskCol, boolean isExistMainMajor) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        DynamicObjectCollection taskEntityCols = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = taskEntityCols.getDynamicObjectType();
        ArrayList<Integer> taskIndexFromMainPlans = new ArrayList<Integer>(allTaskCol.size());
        DynamicObject taskObj = null;
        DynamicObject newTaskObj = null;
        for (int i = 0; i < allTaskCol.size(); ++i) {
            taskObj = (DynamicObject)allTaskCol.get(i);
            newTaskObj = new DynamicObject(dt);
            DynamicObject relateTask = taskObj.getDynamicObject("relationtask");
            if (relateTask != null) {
                taskIndexFromMainPlans.add(i);
            }
            newTaskObj.set("id", (Object)taskObj.getPkValue().toString());
            newTaskObj.set("task", (Object)taskObj);
            BigDecimal realtimedeviation = taskObj.getBigDecimal("realtimedeviation");
            if (realtimedeviation.compareTo(BigDecimal.ZERO) < 0) {
                newTaskObj.set("overduedays", (Object)realtimedeviation.multiply(new BigDecimal(-1)));
            }
            String completionstatus = taskObj.getString("completionstatus");
            newTaskObj.set("completionstatus", (Object)completionstatus);
            DynamicObject parent = taskObj.getDynamicObject("parent");
            if (isExistMainMajor) {
                if (parent == null) {
                    newTaskObj.set("pid", (Object)"0");
                } else {
                    DynamicObject parentRelateTask = parent.getDynamicObject("relationtask");
                    if (parentRelateTask == null) {
                        newTaskObj.set("pid", (Object)parent.getPkValue().toString());
                    } else {
                        DynamicObject parentRelaTaskObj = BusinessDataServiceHelper.loadSingle((Object)parentRelateTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                        boolean isLatest = parentRelaTaskObj.getBoolean("islatest");
                        if (isLatest) {
                            newTaskObj.set("pid", (Object)parentRelateTask.getPkValue().toString());
                        } else {
                            DynamicObject sourceTask = parentRelaTaskObj.getDynamicObject("sourcetask");
                            QFilter latestTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
                            QFilter islatestFilter = new QFilter("islatest", "=", (Object)QUICK_FILTER_PROPERTY);
                            DynamicObject latestTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{latestTaskFilter, islatestFilter});
                            newTaskObj.set("pid", (Object)latestTask.getPkValue().toString());
                        }
                    }
                }
            } else {
                newTaskObj.set("pid", (Object)(parent == null ? "0" : parent.getPkValue().toString()));
            }
            taskEntityCols.add((Object)newTaskObj);
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("overduedays");
            BigDecimal rtd = taskObj.getBigDecimal("realtimedeviation");
            if (rtd.compareTo(BigDecimal.ZERO) < 0) {
                style.setForeColor("red");
            }
            styles.add(style);
            CellStyle style1 = new CellStyle();
            style1.setRow(i);
            style1.setFieldKey("taskname");
            String riskColor = taskObj.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style1.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style1.setBackColor("#FD6C6A");
            }
            styles.add(style1);
        }
        int[] taskIndexFromMainPlan = taskIndexFromMainPlans.stream().mapToInt(Integer::intValue).toArray();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        grid.setCollapse(false);
        grid.setCellStyle(styles);
        grid.setRowLock(true, taskIndexFromMainPlan);
        grid.setRowBackcolor("lightgrey", taskIndexFromMainPlan);
        grid.getModel().updateCache();
        grid.getModel().updateEntryCache(taskEntityCols);
        this.getModel().updateEntryCache(taskEntityCols);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }
}

