/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ProPlanReachRatePlugin
extends AbstractPlacsFormPlugin
implements ClickListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String[] columbKey = new String[]{"project", "planend", "ontimeend", "overtimeend", "totalend", "overtimenotend", "ontimeendrate", "overtimeendrate", "endrate"};
    private final String[] header = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"ProPlanReachRatePlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210", (String)"ProPlanReachRatePlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"ProPlanReachRatePlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"ProPlanReachRatePlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u603b\u6570", (String)"ProPlanReachRatePlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProPlanReachRatePlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210\u7387", (String)"ProPlanReachRatePlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210\u7387", (String)"ProPlanReachRatePlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"ProPlanReachRatePlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0])};
    protected static final Integer DEFAULT_SHOW_PROJECT_NAME_LENGTH = 12;
    protected static final String DEFAULT_SHOW_PROJECT_NAME_END_TAG = "..";

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"dataap"});
        String beFirst = this.getPageCache().get("beFirst");
        if (beFirst == null || beFirst.equals("true")) {
            List selectedMainOrgIds = (List)this.getView().getFormShowParameter().getCustomParam("orgId");
            List proId = (List)this.getView().getFormShowParameter().getCustomParam("proId");
            Object sourceOpen = this.getView().getFormShowParameter().getCustomParam("source");
            if ("masterplan".equals(sourceOpen) && null != selectedMainOrgIds && null != proId) {
                this.getModel().setValue("orgs", (Object)selectedMainOrgIds.toArray());
                this.getModel().setValue("projects", (Object)proId.toArray());
                this.getView().updateView("projects");
                this.getView().updateView("orgs");
                this.getView().invokeOperation("querydata");
                this.getView().updateView("dataap");
            }
            this.getPageCache().put("beFirst", "false");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Chart totalChart = (Chart)this.getControl("histogramchartap");
        totalChart.addClickListener((ClickListener)this);
        MulBasedataEdit projects = (MulBasedataEdit)this.getControl("projects");
        projects.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit taskSource = (MulBasedataEdit)this.getControl("tasksource");
        taskSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit orgs = (MulBasedataEdit)this.getControl("orgs");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"querydata", (CharSequence)operateKey)) {
            this.updateData();
        } else if (StringUtils.equals((CharSequence)"refreshdata", (CharSequence)operateKey)) {
            this.updateData();
        } else if (StringUtils.equals((CharSequence)"export", (CharSequence)operateKey)) {
            this.exportData();
        } else if (StringUtils.equals((CharSequence)"queryclick", (CharSequence)operateKey)) {
            this.queryClick();
        }
    }

    protected void queryClick() {
        String textField = (String)this.getModel().getValue("textfield");
        Label label = (Label)this.getControl("labelap");
        if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
            label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"ProPlanReachRatePlugin_10", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("textfield", (Object)"true");
        } else {
            label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProPlanReachRatePlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("textfield", (Object)"false");
        }
    }

    protected void exportData() {
        String fileName = ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u8fbe\u6210\u7387-\u6570\u636e\u660e\u7ec6", (String)"ProPlanReachRatePlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        String sheetName = ResManager.loadKDString((String)"\u6570\u636e\u660e\u7ec6", (String)"ProPlanReachRatePlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
        JSONArray data = new JSONArray();
        DynamicObjectCollection dataCol = this.getModel().getEntryEntity("entryentity");
        DecimalFormat df2 = new DecimalFormat("#.##");
        for (DynamicObject dynamicObject : dataCol) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("project", (Object)dynamicObject.getString("project.name"));
            jsonObj.put("planend", (Object)dynamicObject.getInt("planend"));
            jsonObj.put("ontimeend", (Object)dynamicObject.getInt("ontimeend"));
            jsonObj.put("overtimeend", (Object)dynamicObject.getInt("overtimeend"));
            jsonObj.put("totalend", (Object)dynamicObject.getInt("totalend"));
            jsonObj.put("overtimenotend", (Object)dynamicObject.getInt("overtimenotend"));
            jsonObj.put("ontimeendrate", (Object)(df2.format(dynamicObject.getBigDecimal("ontimeendrate").multiply(BigDecimal.valueOf(100L))) + "%"));
            jsonObj.put("overtimeendrate", (Object)(df2.format(dynamicObject.getBigDecimal("overtimeendrate").multiply(BigDecimal.valueOf(100L))) + "%"));
            jsonObj.put("endrate", (Object)(df2.format(dynamicObject.getBigDecimal("endrate").multiply(BigDecimal.valueOf(100L))) + "%"));
            data.add((Object)jsonObj);
        }
        ArrayList mustFillColumn = new ArrayList();
        String url = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])this.header, (String[])columbKey, mustFillColumn, (JSONArray)data);
        this.getView().download(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ProPlanReachRatePlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)"planend", (CharSequence)fieldName)) {
            this.showProjecTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)"ontimeend", (CharSequence)fieldName)) {
            this.showProjecTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)"overtimeend", (CharSequence)fieldName)) {
            this.showProjecTask(fieldName, rowIndex);
        } else if (StringUtils.equals((CharSequence)"overtimenotend", (CharSequence)fieldName)) {
            this.showProjecTask(fieldName, rowIndex);
        }
    }

    private void showProjecTask(String fieldName, int rowIndex) {
        Set<Object> taskSourceIdSet;
        Set<Object> taskTypeIdSet;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project", rowIndex);
        if ((project = this.getProjectByPk(project)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u7684\u9879\u76ee\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ProPlanReachRatePlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String completionStatus = "";
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"ontimeend")) {
            completionStatus = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"overtimeend")) {
            completionStatus = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"overtimenotend")) {
            completionStatus = CompletionStatusEnum.OVERDUE.getValue();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            paramMap.put("controllevels", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasktypes", taskTypeIdSet);
        }
        if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasksource", taskSourceIdSet);
        }
        paramMap.put("daterange_startdate", this.getRangeBeginDate(dataEntity));
        paramMap.put("daterange_enddate", this.getRangeEndDate(dataEntity));
        paramMap.put("formId", this.getAppId() + "_tasklist");
        paramMap.put("projectId", project.getString("id"));
        paramMap.put("completionStatus", completionStatus);
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanreachrate"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        ChartClickEvent chartClickEvent;
        Chart chart;
        super.click(evt);
        String sourceName = evt.getSource().getClass().getName();
        if (StringUtils.equals((CharSequence)sourceName, (CharSequence)HistogramChart.class.getName()) && StringUtils.equals((CharSequence)"histogramchartap", (CharSequence)(chart = (chartClickEvent = (ChartClickEvent)evt).getSource()).getKey())) {
            this.gramChartapClick(chartClickEvent);
        }
    }

    protected void gramChartapClick(ChartClickEvent chartClickEvent) {
        Set<Object> taskSourceIdSet;
        Set<Object> taskTypeIdSet;
        String projectName = chartClickEvent.getName();
        String seriesName = chartClickEvent.getSeriesName();
        if (projectName == null || seriesName == null) {
            return;
        }
        if (seriesName.contains("%")) {
            return;
        }
        DynamicObject project = this.getProjectByName(projectName);
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u7684\u9879\u76ee\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ProPlanReachRatePlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        String completionStatus = "";
        if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getName())) {
            completionStatus = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
        } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProPlanReachRatePlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            completionStatus = CompletionStatusEnum.OVERDUE.getValue();
        } else if (StringUtils.equals((CharSequence)seriesName, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getName())) {
            completionStatus = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
        }
        if (StringUtils.isBlank((CharSequence)completionStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u5757\u72b6\u6001\u4e0e\u7cfb\u7edf\u4efb\u52a1\u72b6\u6001\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProPlanReachRatePlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            paramMap.put("controllevels", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasktypes", taskTypeIdSet);
        }
        if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
            paramMap.put("tasksource", taskSourceIdSet);
        }
        paramMap.put("daterange_startdate", this.getRangeBeginDate(dataEntity));
        paramMap.put("daterange_enddate", this.getRangeEndDate(dataEntity));
        paramMap.put("formId", this.getAppId() + "_tasklist");
        paramMap.put("projectId", project.getString("id"));
        paramMap.put("completionStatus", completionStatus);
        paramMap.put("billsource", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanreachrate"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.setAppId(this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected DynamicObject getProjectByName(DynamicObject project) {
        String projectName = project.getString("name");
        return BusinessDataServiceHelper.loadSingle((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)projectName)});
    }

    protected DynamicObject getProjectByPk(DynamicObject project) {
        if (project == null) {
            return null;
        }
        Object pkValue = project.getPkValue();
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.getProjectFormId());
    }

    protected DynamicObject getProjectByName(String projectName) {
        return BusinessDataServiceHelper.loadSingle((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)projectName)});
    }

    protected Date getRangeBeginDate(DynamicObject dataEntity) {
        boolean thisWeek = dataEntity.getBoolean("thisweek");
        boolean thisMonth = dataEntity.getBoolean("thisMonth");
        boolean threeMonth = dataEntity.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date firstDayOfThisWeek = DateUtil.getThisWeekMonday((Date)nowDate);
            return firstDayOfThisWeek;
        }
        if (thisMonth) {
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)nowDate);
            return firstDayOfThisMonth;
        }
        if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            Date firstDayOfPreTwoMonth = DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
            return firstDayOfPreTwoMonth;
        }
        Date firstDayOfRange = dataEntity.getDate("daterange_startdate");
        return firstDayOfRange;
    }

    protected Date getRangeEndDate(DynamicObject dataEntity) {
        boolean thisWeek = dataEntity.getBoolean("thisweek");
        boolean thisMonth = dataEntity.getBoolean("thisMonth");
        boolean threeMonth = dataEntity.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date lastDayOfThisWeek = DateUtil.getThisWeekSunDay((Date)nowDate);
            return lastDayOfThisWeek;
        }
        if (thisMonth) {
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            return lastDayOfThisMonth;
        }
        if (threeMonth) {
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            return lastDayOfThisMonth;
        }
        Date lastDayOfRange = dataEntity.getDate("daterange_enddate");
        return lastDayOfRange;
    }

    protected void updateData() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject[] taskArr = this.getTaskArr(dataEntity);
        if (taskArr == null || taskArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u5207\u6362\u6761\u4ef6\u67e5\u8be2\u3002", (String)"ProPlanReachRatePlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"chartap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"dataap"});
        Map<String, Map<String, Object>> projectDataMap = this.handledata(taskArr);
        ArrayList<Integer> onTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeEndList = new ArrayList<Integer>(10);
        ArrayList<Integer> overTimeNotEndList = new ArrayList<Integer>(10);
        ArrayList<BigDecimal> endRateList = new ArrayList<BigDecimal>(10);
        ArrayList<String> projectNameList = new ArrayList<String>(10);
        for (Map.Entry<String, Map<String, Object>> project : projectDataMap.entrySet()) {
            Map<String, Object> taskQtyMap = project.getValue();
            String projectName = taskQtyMap.get("projectname").toString();
            Integer onTimeEnd = (Integer)taskQtyMap.get("ontimeend");
            Integer overTimeEnd = (Integer)taskQtyMap.get("overtimeend");
            Integer overTimeNotEnd = (Integer)taskQtyMap.get("overtimenotend");
            Integer planEnd = (Integer)taskQtyMap.get("planend");
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("project", (Object)project.getKey(), rowIndex);
            this.getModel().setValue("planend", (Object)planEnd, rowIndex);
            onTimeEndList.add(onTimeEnd);
            this.getModel().setValue("ontimeend", (Object)onTimeEnd, rowIndex);
            overTimeEndList.add(overTimeEnd);
            this.getModel().setValue("overtimeend", (Object)overTimeEnd, rowIndex);
            overTimeNotEndList.add(overTimeNotEnd);
            this.getModel().setValue("overtimenotend", (Object)overTimeNotEnd, rowIndex);
            projectNameList.add(projectName);
            Integer totalEnd = onTimeEnd + overTimeEnd;
            BigDecimal endRate = BigDecimal.ZERO;
            if (planEnd != 0) {
                endRate = BigDecimal.valueOf(totalEnd.intValue()).divide(BigDecimal.valueOf(planEnd.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            }
            endRateList.add(endRate);
        }
        this.setHistogramChart(onTimeEndList, overTimeEndList, overTimeNotEndList, endRateList, projectNameList);
    }

    protected void setHistogramChart(List<Integer> onTimeEndList, List<Integer> overTimeEndList, List<Integer> overTimeNotEndList, List<BigDecimal> endRateList, List<String> projectNameList) {
        for (int i = projectNameList.size(); i < 8; ++i) {
            projectNameList.add("");
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.clearData();
        Axis xAxis = histogramChart.createXAxis("", projectNameList);
        if (projectNameList.size() > 8) {
            HashMap<String, Integer> axisLabelMap = new HashMap<String, Integer>();
            axisLabelMap.put("interval", 0);
            axisLabelMap.put("rotate", -40);
            xAxis.setPropValue("axisLabel", axisLabelMap);
        }
        kd.bos.form.chart.Label plLabel = new kd.bos.form.chart.Label();
        plLabel.setShow(true);
        plLabel.setFontSize("14");
        plLabel.setPosition(Position.inside);
        histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"ProPlanReachRatePlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]), AxisType.value);
        BarSeries series = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"ProPlanReachRatePlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series.setBarWidth("50px");
        series.setStack("aa");
        series.setData((Number[])onTimeEndList.toArray(new Integer[onTimeEndList.size()]));
        series.setColor("#83F348");
        series.setLabel(plLabel);
        BarSeries series1 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"ProPlanReachRatePlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series1.setBarWidth("50px");
        series1.setStack("aa");
        series1.setData((Number[])overTimeEndList.toArray(new Integer[overTimeEndList.size()]));
        series1.setColor("#2DECE9");
        series1.setLabel(plLabel);
        BarSeries series2 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProPlanReachRatePlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series2.setBarWidth("50px");
        series2.setStack("aa");
        series2.setData((Number[])overTimeNotEndList.toArray(new Integer[overTimeNotEndList.size()]));
        series2.setColor("#FF585A");
        series2.setLabel(plLabel);
        Axis yAxis2 = histogramChart.createYAxis(ResManager.loadKDString((String)"\u5b8c\u6210\u7387", (String)"ProPlanReachRatePlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formatter", "{value}%");
        yAxis2.setPropValue("axisLabel", map);
        yAxis2.setInterval((Number)20);
        yAxis2.setMax((Number)100);
        LineSeries lineSeries = histogramChart.createLineSeries(ResManager.loadKDString((String)"\u5b8c\u6210\u7387\uff08%\uff09", (String)"ProPlanReachRatePlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        lineSeries.setData((Number[])endRateList.toArray(new BigDecimal[endRateList.size()]));
        HashMap itemStyleMap = new HashMap();
        HashMap<String, String> normalMap = new HashMap<String, String>();
        normalMap.put("color", "#1A94E6");
        itemStyleMap.put("normal", normalMap);
        lineSeries.setPropValue("itemStyle", itemStyleMap);
        lineSeries.setYAxisIndex(1);
        histogramChart.setShowTooltip(true);
        histogramChart.setShowLegend(true);
        histogramChart.setShowTitle(false);
        histogramChart.refresh();
    }

    protected String getShowProjectName(String projectName) {
        Integer showProjectNameLength = this.getShowProjectNameLength();
        if (showProjectNameLength < 0) {
            return projectName;
        }
        if (projectName.length() <= showProjectNameLength) {
            return projectName;
        }
        String showProjectName = projectName.substring(0, showProjectNameLength);
        return showProjectName + DEFAULT_SHOW_PROJECT_NAME_END_TAG;
    }

    protected Integer getShowProjectNameLength() {
        return DEFAULT_SHOW_PROJECT_NAME_LENGTH;
    }

    protected Map<String, Map<String, Object>> handledata(DynamicObject[] taskArr) {
        HashMap<String, Map<String, Object>> projectDataMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject task : taskArr) {
            DynamicObject project = task.getDynamicObject("project");
            String status = task.getString("completionstatus");
            HashMap<String, Object> taskQtyMap = null;
            if (project == null) continue;
            String projectId = project.getString("id");
            taskQtyMap = (HashMap<String, Object>)projectDataMap.get(projectId);
            if (taskQtyMap != null) {
                Integer planEnd;
                Integer n = planEnd = (Integer)taskQtyMap.get("planend");
                Integer n2 = planEnd = Integer.valueOf(planEnd + 1);
                taskQtyMap.put("planend", planEnd);
                if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                    Integer onTimeEnd;
                    n2 = onTimeEnd = (Integer)taskQtyMap.get("ontimeend");
                    Integer n3 = onTimeEnd = Integer.valueOf(onTimeEnd + 1);
                    taskQtyMap.put("ontimeend", onTimeEnd);
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                    Integer overTimeEnd;
                    n2 = overTimeEnd = (Integer)taskQtyMap.get("overtimeend");
                    Integer n4 = overTimeEnd = Integer.valueOf(overTimeEnd + 1);
                    taskQtyMap.put("overtimeend", overTimeEnd);
                } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) {
                    Integer overTimeNotEnd;
                    n2 = overTimeNotEnd = (Integer)taskQtyMap.get("overtimenotend");
                    Integer n5 = overTimeNotEnd = Integer.valueOf(overTimeNotEnd + 1);
                    taskQtyMap.put("overtimenotend", overTimeNotEnd);
                }
                projectDataMap.put(projectId, taskQtyMap);
                continue;
            }
            taskQtyMap = new HashMap<String, Object>();
            int planEnd = 0;
            int onTimeEnd = 0;
            int overTimeEnd = 0;
            int overTimeNotEnd = 0;
            ++planEnd;
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                ++onTimeEnd;
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                ++overTimeEnd;
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) {
                ++overTimeNotEnd;
            }
            taskQtyMap.put("planend", planEnd);
            taskQtyMap.put("ontimeend", onTimeEnd);
            taskQtyMap.put("overtimeend", overTimeEnd);
            taskQtyMap.put("overtimenotend", overTimeNotEnd);
            this.handledata4Project(project, taskQtyMap);
            projectDataMap.put(projectId, taskQtyMap);
        }
        return projectDataMap;
    }

    protected void handledata4Project(DynamicObject project, Map<String, Object> taskQtyMap) {
        taskQtyMap.put("projectid", project.getPkValue());
        taskQtyMap.put("projectname", project.getString("name"));
    }

    protected Set<Object> getControlLevelSet(DynamicObject thisModel) {
        DynamicObjectCollection controlLevelCol = thisModel.getDynamicObjectCollection("controllevels");
        HashSet<Object> controlLevelIdSet = new HashSet<Object>();
        if (controlLevelCol != null && controlLevelCol.size() > 0) {
            for (DynamicObject dynamicObject : controlLevelCol) {
                DynamicObject controlLevel = dynamicObject.getDynamicObject("fbasedataid");
                if (controlLevel == null) continue;
                controlLevelIdSet.add(controlLevel.getPkValue());
            }
        }
        return controlLevelIdSet;
    }

    protected Set<Object> getTaskTypeIdSet(DynamicObject thisModel) {
        HashSet<Object> taskTypeIdSet = new HashSet<Object>();
        DynamicObjectCollection taskTypeCol = thisModel.getDynamicObjectCollection("tasktypes");
        if (taskTypeCol != null && taskTypeCol.size() > 0) {
            for (DynamicObject dynamicObject : taskTypeCol) {
                DynamicObject taskType = dynamicObject.getDynamicObject("fbasedataid");
                if (taskType == null) continue;
                taskTypeIdSet.add(taskType.getPkValue());
            }
        }
        return taskTypeIdSet;
    }

    protected Set<Object> getTaskSourceIdSet(DynamicObject dataEntity) {
        HashSet<Object> taskSourceIdSet = new HashSet<Object>();
        DynamicObjectCollection taskSourceCol = dataEntity.getDynamicObjectCollection("tasksource");
        if (taskSourceCol != null && !taskSourceCol.isEmpty()) {
            for (DynamicObject taskSourceObj : taskSourceCol) {
                DynamicObject taskSource = taskSourceObj.getDynamicObject("fbasedataid");
                if (taskSource == null) continue;
                taskSourceIdSet.add(taskSource.getPkValue());
            }
        }
        return taskSourceIdSet;
    }

    protected String[] getPlanTypeArr(DynamicObject thisModel) {
        String[] planTypeArr;
        String planTypes = thisModel.getString("plantypes");
        if (StringUtils.isNotBlank((CharSequence)planTypes) && (planTypeArr = planTypes.split(",")) != null && planTypeArr.length > 0) {
            return planTypeArr;
        }
        return null;
    }

    protected Set<Object> getProjectIdSet(DynamicObject dataEntity) {
        DynamicObjectCollection probjectCollection = dataEntity.getDynamicObjectCollection("projects");
        HashSet<Object> projectIdSet = new HashSet<Object>();
        for (DynamicObject dynamicObject : probjectCollection) {
            DynamicObject project = dynamicObject.getDynamicObject("fbasedataid");
            if (project == null) continue;
            projectIdSet.add(project.getPkValue());
        }
        if (projectIdSet.isEmpty()) {
            DynamicObjectCollection orgCol = this.getModel().getDataEntity().getDynamicObjectCollection("orgs");
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : orgCol) {
                DynamicObject org = dynamicObject.getDynamicObject("fbasedataid");
                if (org == null) continue;
                orgIdList.add(org.getLong("id"));
            }
            DynamicObject[] filterProjects = this.getPermProjectByStatus(orgIdList, true, this.getView().getEntityId(), "view");
            for (int i = 0; i < filterProjects.length; ++i) {
                projectIdSet.add(filterProjects[i].getPkValue());
            }
        }
        return projectIdSet;
    }

    protected QFilter getPlanStartAndEndTimeFilter(DynamicObject dataEntity) {
        QFilter planEndTimeFilter = null;
        boolean thisWeek = dataEntity.getBoolean("thisweek");
        boolean thisMonth = dataEntity.getBoolean("thisMonth");
        boolean threeMonth = dataEntity.getBoolean("threeMonth");
        Date nowDate = new Date();
        if (thisWeek) {
            Date firstDayOfThisWeek = DateUtil.getThisWeekMonday((Date)nowDate);
            Date lastDayOfThisWeek = DateUtil.getThisWeekSunDay((Date)nowDate);
            QFilter largeFirstDayOfThisWeek = new QFilter("planendtime", ">=", (Object)firstDayOfThisWeek);
            QFilter lessLastDayOfThisWeek = new QFilter("planendtime", "<=", (Object)lastDayOfThisWeek);
            planEndTimeFilter = largeFirstDayOfThisWeek.and(lessLastDayOfThisWeek);
        } else if (thisMonth) {
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)nowDate);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfThisMonth = new QFilter("planendtime", ">=", (Object)firstDayOfThisMonth);
            QFilter lessLastDatOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfThisMonth.and(lessLastDatOfThisMonth);
        } else if (threeMonth) {
            Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth((Date)nowDate);
            Date firstDayOfPreTwoMonth = DateUtil.getFirstDayOfPreMonth((Date)firstDayOfPreMonth);
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)nowDate);
            QFilter largeFirstDayOfPreTwoMonth = new QFilter("planendtime", ">=", (Object)firstDayOfPreTwoMonth);
            QFilter lessLastDayOfThisMonth = new QFilter("planendtime", "<=", (Object)lastDayOfThisMonth);
            planEndTimeFilter = largeFirstDayOfPreTwoMonth.and(lessLastDayOfThisMonth);
        } else {
            Date firstDayOfRange = dataEntity.getDate("daterange_startdate");
            Date lastDayOfRange = dataEntity.getDate("daterange_enddate");
            if (firstDayOfRange != null && lastDayOfRange != null) {
                QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", (Object)firstDayOfRange);
                QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", (Object)lastDayOfRange);
                planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
            }
        }
        return planEndTimeFilter;
    }

    protected DynamicObject[] getTaskArr(DynamicObject dataEntity) {
        Set<Object> taskSourceIdSet;
        Set<Object> taskTypeIdSet;
        QFilter commonFilter = this.getCommonFilter();
        QFilter controlLevelFilter = null;
        QFilter taskTypeFilter = null;
        QFilter taskSourceFilter = null;
        QFilter projectFilter = null;
        QFilter planEndTimeFilter = this.getPlanStartAndEndTimeFilter(dataEntity);
        Set<Object> projectIdSet = this.getProjectIdSet(dataEntity);
        projectFilter = new QFilter("project", "in", projectIdSet);
        Set<Object> controlLevelIdSet = this.getControlLevelSet(dataEntity);
        if (!controlLevelIdSet.isEmpty()) {
            controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        }
        if (!(taskTypeIdSet = this.getTaskTypeIdSet(dataEntity)).isEmpty()) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypeIdSet);
        }
        if (!(taskSourceIdSet = this.getTaskSourceIdSet(dataEntity)).isEmpty()) {
            taskSourceFilter = new QFilter("tasksource", "in", taskSourceIdSet);
        }
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,name,majortype,planendtime,completionstatus,project", (QFilter[])new QFilter[]{projectFilter, planEndTimeFilter, commonFilter, taskSourceFilter, controlLevelFilter, taskTypeFilter});
        return taskArr;
    }

    protected QFilter getCommonFilter() {
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter relationFilter = new QFilter("relationtask", "=", (Object)0);
        return isLatestFilter.and(statusFilter).and(relationFilter);
    }

    protected DynamicObject[] getPermProjectByStatus(List<Long> orgIdList, boolean isSubordinate, String entityNum, String operateNum) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        QFilter orgFilter = new QFilter("useorg", "in", orgIdList);
        qFilters.add(orgFilter);
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return projects;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"projects", (CharSequence)propName)) {
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
            this.setProjectQfilters(beforeF7SelectEvent, orgCol);
        } else if (StringUtils.equals((CharSequence)"tasksource", (CharSequence)propName)) {
            DynamicObjectCollection projectsCol = (DynamicObjectCollection)this.getModel().getValue("projects");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (projectsCol.isEmpty()) {
                QFilter sysPreFilter = new QFilter("group", "=", (Object)0).and("number", "in", (Object)new String[]{"MASTERPLAN_S"});
                QFilter specialFilter = new QFilter("group", "!=", (Object)0);
                QFilter taskSourceFilter = sysPreFilter.or(specialFilter);
                showParameter.getListFilterParameter().getQFilters().add(taskSourceFilter);
            } else {
                HashSet<Object> projectIds = new HashSet<Object>();
                for (DynamicObject proObj : projectsCol) {
                    DynamicObject project = proObj.getDynamicObject("fbasedataid");
                    if (project == null) continue;
                    projectIds.add(project.getPkValue());
                }
                QFilter proIdFilter = new QFilter("id", "in", projectIds);
                DynamicObject[] proObjs = BusinessDataServiceHelper.load((String)"bd_project", (String)"group", (QFilter[])new QFilter[]{proIdFilter});
                Set groupIds = Arrays.stream(proObjs).filter(o -> o.getDynamicObject("group") != null).map(o -> o.getDynamicObject("group").getPkValue()).collect(Collectors.toSet());
                QFilter sysPreFilter = new QFilter("group", "=", (Object)0).and("number", "in", (Object)new String[]{"MASTERPLAN_S"});
                QFilter specialFilter = new QFilter("group", "in", groupIds);
                QFilter taskSourceFilter = sysPreFilter.or(specialFilter);
                showParameter.getListFilterParameter().getQFilters().add(taskSourceFilter);
            }
        }
    }

    protected void setProjectQfilters(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObjectCollection orgCol) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : orgCol) {
            DynamicObject org = dynamicObject.getDynamicObject("fbasedataid");
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("org", "in", orgIdList));
    }
}

