/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import kd.pccs.placs.formplugin.model.MulitTxType;

public class ProResultDocTrackListPlugin
extends AbstractPlacsFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String COL_RESULTNAME = "resultname";
    private static final String COL_TASKNAME = "name";
    private static final String BILLLISTID = "billlistap";
    private static final String CODE_QUERYCLICK = "queryclick";
    private static final String KEY_SEARCH = "search";
    public static final String DBROUTE_PMPMKEY = "cr";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"project")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                return;
            }
            QFilter orgId = new QFilter("id", "=", (Object)((DynamicObject)project.get("org")).getLong("id"));
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{orgId});
            this.getModel().setValue("org", (Object)org);
            this.getModel().setValue("project", (Object)project);
        } else if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"org")) {
            this.getModel().setValue("project", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label label = (Label)this.getControl("labelap");
        if (label != null) {
            label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billlist = (BillList)this.getControl(BILLLISTID);
        billlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if (KEY_SEARCH.equals(operateKey)) {
            this.doSearch(args);
        }
    }

    protected QFilter getTxTypeFilter() {
        QFilter txTypeFilter = new QFilter("number", "=", (Object)TransactionTypeEnum.RESULT.getValue());
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"), (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        String routeKey = MetaDataUtil.getDT((String)this.getAppId(), (String)"transactiontype").getDBRouteKey();
        String sql = " select fpkid,fentryid,fbasedataid from t_" + this.getAppId() + "_multitxtype where fbasedataid=? ";
        ArrayList<Object> paramsList = new ArrayList<Object>(1);
        List mulitTxTypes = new ArrayList();
        if (txType != null) {
            paramsList.add(txType.getPkValue());
            mulitTxTypes = (List)DB.query((DBRoute)new DBRoute(routeKey), (String)sql, (Object[])paramsList.toArray(new Object[paramsList.size()]), (ResultSetHandler)new ResultSetHandler<List<MulitTxType>>(){

                public List<MulitTxType> handle(ResultSet rs) throws Exception {
                    ArrayList<MulitTxType> result = new ArrayList<MulitTxType>(10);
                    while (rs.next()) {
                        MulitTxType tx = new MulitTxType();
                        tx.setfEntryId(rs.getLong("fentryid"));
                        result.add(tx);
                    }
                    return result;
                }
            });
        }
        QFilter taskFilter = null;
        if (!mulitTxTypes.isEmpty()) {
            List taskIds = mulitTxTypes.stream().map(mt -> mt.getfEntryId()).collect(Collectors.toList());
            taskFilter = new QFilter("id", "in", taskIds);
        }
        return taskFilter;
    }

    protected void doSearch(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ProResultDocTrackListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProResultDocTrackListPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
        qFilters.add(projectFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        qFilters.add(latestTaskFilter);
        QFilter txTypeFilter = this.getTxTypeFilter();
        qFilters.add(txTypeFilter);
        QFilter isForceFilter = new QFilter("taskresultdocentry.force", "=", (Object)DefaultEnum.YES.getValue());
        qFilters.add(isForceFilter);
        billList.getFilterParameter().setQFilters(qFilters);
        billList.getFilterParameter().setOrderBy("taskseq asc");
        billList.refreshData();
        this.configCellStyle();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter filter = new QFilter("1", "=", (Object)0);
        qFilters.add(filter);
        billList.getFilterParameter().setQFilters(qFilters);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object orgIdparma = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object planTypeId = this.getView().getFormShowParameter().getCustomParam("planTypeId");
        Object proId = this.getView().getFormShowParameter().getCustomParam("proId");
        Object sourceOpen = this.getView().getFormShowParameter().getCustomParam("source");
        String beFirst = this.getPageCache().get("beFirst");
        if (null != orgIdparma && null != planTypeId && null != proId) {
            this.getModel().setValue("org", orgIdparma);
            this.getModel().setValue("project", proId);
            BillList billList = (BillList)this.getControl(BILLLISTID);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter majortype = new QFilter("majortype", "=", planTypeId);
            QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
            QFilter proPlan = new QFilter("project", "=", proId);
            DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"id,taskentity,taskentity.taskid", (QFilter[])new QFilter[]{majortype, planVersion, proPlan});
            HashSet<Object> allTaskids = new HashSet<Object>();
            for (DynamicObject plan : plans) {
                DynamicObjectCollection taskentries = plan.getDynamicObjectCollection("taskentity");
                if (taskentries == null || taskentries.size() <= 0) continue;
                for (DynamicObject entry : taskentries) {
                    Object id = entry.getPkValue();
                    allTaskids.add(id);
                }
            }
            QFilter projectFilter = new QFilter("id", "in", allTaskids);
            qFilters.add(projectFilter);
            billList.getFilterParameter().setQFilters(qFilters);
            billList.getFilterParameter().setOrderBy("majorname asc,name asc");
            billList.refreshData();
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getView().invokeOperation(KEY_SEARCH);
        } else if ("masterplan".equals(sourceOpen) && null != orgIdparma && null != proId && (beFirst == null || beFirst.equals("true"))) {
            this.getModel().setValue("org", orgIdparma);
            this.getModel().setValue("project", proId);
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getView().invokeOperation(KEY_SEARCH);
            this.getPageCache().put("beFirst", "false");
        }
        this.configCellStyle();
    }

    protected void configCellStyle() {
        BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskbilllist.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            ListSelectedRow taskRow = rows.get(rowIndex);
            Object taskid = taskRow.getPrimaryKeyValue();
            Object entryid = taskRow.getEntryPrimaryKeyValue();
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(rowIndex);
            cellStyle.setFieldKey(COL_RESULTNAME);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceFilter});
            ArrayList<Object> docEntryIdList = new ArrayList<Object>(10);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            QFilter taskFilter = new QFilter("task", "in", Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            filters.add(taskFilter);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filters.add(statusFilter);
            DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency"), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
            if (taskReports != null && taskReports.length != 0) {
                for (DynamicObject report : taskReports) {
                    if (report.getBigDecimal("percent").compareTo(new BigDecimal("100")) == 0) {
                        cellStyle.setBackColor("lightgreen");
                        break;
                    }
                    DynamicObjectCollection entries = report.getDynamicObjectCollection("achieveentity");
                    if (!entries.isEmpty()) {
                        for (DynamicObject resultdoc : entries) {
                            if (!entryid.toString().equals(resultdoc.getString("resultid"))) continue;
                            docEntryIdList.add(resultdoc.getPkValue());
                            break;
                        }
                    }
                    List results = new ArrayList();
                    if (!docEntryIdList.isEmpty()) {
                        String sql = "SELECT FBASEDATAID FROM T_" + this.getAppId() + "_UPLOADDOC WHERE FENTRYID in(" + StringUtils.strip((String)((Object)docEntryIdList).toString(), (String)"[]") + ")";
                        results = (List)DB.query((DBRoute)new DBRoute(DBROUTE_PMPMKEY), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                            public List<String> handle(ResultSet rs) throws Exception {
                                ArrayList<String> result = new ArrayList<String>(10);
                                while (rs.next()) {
                                    result.add(rs.getString(1));
                                }
                                return result;
                            }
                        });
                    }
                    if (results.size() != 0) continue;
                    cellStyle.setBackColor("lightgrey");
                }
            } else {
                cellStyle.setBackColor("lightgrey");
            }
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            cellStyles.add(cellStyle);
            taskbilllist.setCellStyle(cellStyles);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (COL_RESULTNAME.equals(fieldName)) {
            this.resultNameHyperLink(args);
        } else if (COL_TASKNAME.equals(fieldName)) {
            BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
            ListSelectedRow row = taskbilllist.getCurrentSelectedRowInfo();
            Long taskPk = (Long)row.getPrimaryKeyValue();
            if (taskPk != null) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
                paramMap.put("pkId", String.valueOf(taskPk));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.setAppId(this.getAppId());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728", (String)"ProResultDocTrackListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void resultNameHyperLink(HyperLinkClickEvent args) {
        String sql;
        void var14_16;
        BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskbilllist.getCurrentListAllRowCollection();
        Optional<ListSelectedRow> currentRow = rows.stream().filter(row -> row.getRowKey() == args.getRowIndex()).findFirst();
        if (!currentRow.isPresent()) {
            return;
        }
        Object taskid = currentRow.get().getPrimaryKeyValue();
        Object entryid = currentRow.get().getEntryPrimaryKeyValue();
        ArrayList<Object> docEntryIdList = new ArrayList<Object>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter taskFilter = new QFilter("task", "=", taskid);
        filters.add(taskFilter);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filters.add(statusFilter);
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency"), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
        if (taskReports == null || taskReports.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5c1a\u672a\u5f00\u59cb\u6c47\u62a5\u3002", (String)"ProResultDocTrackListPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        DynamicObject[] dynamicObjectArray = taskReports;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var14_16 < n) {
            DynamicObject report = dynamicObjectArray[var14_16];
            DynamicObjectCollection entries = report.getDynamicObjectCollection("achieveentity");
            if (!entries.isEmpty()) {
                for (DynamicObject resultdoc : entries) {
                    if (!entryid.toString().equals(resultdoc.getString("resultid"))) continue;
                    docEntryIdList.add(resultdoc.getPkValue());
                }
            }
            ++var14_16;
        }
        if (docEntryIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u4e0a\u4f20\u6587\u6863\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"ProResultDocTrackListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List results = new ArrayList();
        for (Object e : docEntryIdList) {
            if (!results.isEmpty()) break;
            sql = "SELECT FBASEDATAID FROM T_" + this.getAppId() + "_UPLOADDOC WHERE FENTRYID = " + e;
            results = (List)DB.query((DBRoute)new DBRoute(DBROUTE_PMPMKEY), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
        }
        if (results == null || results.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5c1a\u672a\u4e0a\u4f20\u6587\u6863\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"ProResultDocTrackListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (String string : results) {
            sql = "SELECT FURL FROM T_BD_ATTACHMENT WHERE FID = " + string;
            List files = (List)DB.query((DBRoute)new DBRoute("basedata"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
            String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)((String)files.get(0))));
            this.getView().download(attUrl);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.beforeProjectF7(beforeF7SelectEvent);
        }
    }

    protected void beforeProjectF7(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            String orgId = org.getString("id");
            QFilter orgFilter = new QFilter("useorg", "=", (Object)Long.valueOf(orgId));
            beforeF7SelectEvent.getCustomQFilters().add(orgFilter);
        }
    }
}

