/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.ProgressTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.FrequencyEnum;
import kd.pccs.placs.common.enums.PersonTypeEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.permission.PermServiceHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class ProgressReportFormPlugin
extends AbstractPlacsBillPlugin
implements HyperLinkClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(ProgressReportFormPlugin.class);
    protected static final String PERCENT_OK = "100";
    public static final int COOPERATE_PERSONTYPE = 2;
    protected static final String DELETE_RESOLUTION_ENTRY = "deleteresolutionentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("reportrecordentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("resolutionentity");
        taskEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject latestReportRecord;
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        Object taskIdValue = customMap.get("taskId");
        if (null != taskIdValue && null != customMap.get("addreport")) {
            this.addReport(customMap);
        } else if (null != taskIdValue && null != customMap.get("editreport")) {
            this.editReport(customMap);
        } else if (null != taskIdValue && null != customMap.get("viewPercent")) {
            this.viewPercent(customMap);
        } else if (null != taskIdValue && null != customMap.get("hyper")) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle(taskIdValue, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            this.setHyperHuibaoJlEntry(task);
            this.hideSubmit(task);
            this.updateTips();
            this.getView().setVisible(Boolean.FALSE, new String[]{"achieverecord"});
        }
        this.showInputResolution();
        if (this.getModel().getEntryRowCount("resolutionentity") <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"assigntaskpanel", "advconap11"});
        }
        this.getModel().setDataChanged(false);
        if (taskIdValue != null && (latestReportRecord = this.getLatestTaskReportRecord(taskIdValue)) != null) {
            String minValue = latestReportRecord.getString("percent");
            HashMap<String, String> items = new HashMap<String, String>(1);
            items.put("min", minValue);
            HashMap<String, HashMap<String, String>> params = new HashMap<String, HashMap<String, String>>(1);
            params.put("item", items);
            this.getView().updateControlMetadata("percent", params);
        }
    }

    protected void viewPercent(Map customMap) {
        Object taskId = customMap.get("taskId");
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap", "attachmentpanel", "advconap1"});
        DynamicObject task = BusinessDataServiceHelper.loadSingle(taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        boolean showResultEntry = false;
        DynamicObjectCollection txCollections = task.getDynamicObjectCollection("transactiontype");
        for (DynamicObject tx : txCollections) {
            Long baseDataId = tx.getLong("fbasedataid_id");
            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
            if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
            showResultEntry = true;
        }
        if (showResultEntry) {
            QFilter taskid = new QFilter("task", "=", task.getPkValue());
            QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
            DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency"), (QFilter[])filters, (String)"modifytime desc");
            DynamicObjectCollection taskDocEntry = task.getDynamicObjectCollection("taskresultdocentry");
            this.setAchievementAttach(taskDocEntry, taskReports);
            this.getView().updateView("entryentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"achieverecord"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
        this.updateTips();
        boolean iscomplete = (Boolean)this.getModel().getValue("iscomplete");
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        if (iscomplete) {
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        } else {
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateView("completetime");
    }

    protected void editReport(Map customMap) {
        Object taskId = customMap.get("taskId");
        DynamicObject task = BusinessDataServiceHelper.loadSingle(taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        this.hideSubmit(task);
        DynamicObject model = this.getModel().getDataEntity();
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        boolean iscomplete = model.getBoolean("iscomplete");
        if (iscomplete) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"completetime"});
            this.getModel().setValue("completetime", (Object)new Date());
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        if (null != customMap.get("person")) {
            this.setFieldByPersonType(customMap.get("person"));
        }
        this.setAchievementEntry(task, "editchengguo");
        this.setReportRecordEntry(task);
        this.isComplete(task);
        this.updateTips();
        this.modifyPerson(task, "edit");
        this.getView().setVisible(Boolean.FALSE, new String[]{"achieverecord"});
    }

    protected void addReport(Map customMap) {
        Object taskId = customMap.get("taskId");
        DynamicObject task = BusinessDataServiceHelper.loadSingle(taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        this.getModel().setValue("task", task.getPkValue());
        this.getModel().setValue("percent", (Object)task.getBigDecimal("percent"));
        QFilter taskReportNew = new QFilter("latest", "=", (Object)"1");
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus, taskReportNew};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters);
        if (null != taskReportObjs && taskReportObjs.length > 0) {
            this.getModel().setValue("completetime", (Object)taskReportObjs[0].getDate("completetime"));
        } else {
            this.getModel().setValue("completetime", (Object)task.getDate("planendtime"));
        }
        this.updateTips();
        this.hideSubmit(task);
        if (null != customMap.get("person")) {
            this.setFieldByPersonType(customMap.get("person"));
        }
        this.setAchievementEntry(task, null);
        this.setReportRecordEntry(task);
        this.isComplete(task);
        this.modifyPerson(task, "add");
        this.getView().setVisible(Boolean.FALSE, new String[]{"achieverecord"});
    }

    protected void hideSubmit(DynamicObject task) {
        BigDecimal percent = task.getBigDecimal("percent");
        if (null != percent && percent.intValue() != 100) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitnopro"});
        }
        boolean iscomplete = (Boolean)this.getModel().getValue("iscomplete");
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        if (iscomplete) {
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        } else {
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateView("completetime");
    }

    protected void setFieldByPersonType(Object person) {
        int personType = (Integer)person;
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        if (personType == 2) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"iscomplete", "percent", "completetime"});
            FieldEdit percent = (FieldEdit)this.getView().getControl("percent");
            percent.setMustInput(false);
            completeTime.setMustInput(false);
            this.getModel().beginInit();
            this.getModel().setValue("completetime", null);
            this.getView().updateView("completetime");
            this.getModel().endInit();
        } else {
            FieldEdit percent = (FieldEdit)this.getView().getControl("percent");
            percent.setMustInput(true);
            completeTime.setMustInput(true);
        }
    }

    protected void setHyperHuibaoJlEntry(DynamicObject task) {
        String achievementnode = task.getString("achievementnode");
        if (StringUtils.equalsIgnoreCase((CharSequence)achievementnode, (CharSequence)"1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
        DynamicObject model = this.getModel().getDataEntity();
        Date hbdate = model.getDate("modifytime");
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter beginhbdate = new QFilter("modifytime", "<", (Object)hbdate);
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus, beginhbdate};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
        this.getModel().deleteEntryData("reportrecordentity");
        for (DynamicObject taskreport : taskReportObjs) {
            int rowIndex = this.getModel().createNewEntryRow("reportrecordentity");
            this.setReportRecordEntryByRowIndex(taskreport, rowIndex);
        }
        this.getView().updateView("reportrecordentity");
    }

    protected void isComplete(DynamicObject task) {
        int percent = task.getInt("percent");
        if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(percent), (CharSequence)PERCENT_OK)) {
            DynamicObjectCollection reportRecordEntity = (DynamicObjectCollection)this.getModel().getValue("reportrecordentity");
            if (reportRecordEntity != null && !reportRecordEntity.isEmpty()) {
                DynamicObject reportRecord = (DynamicObject)reportRecordEntity.get(0);
                boolean autoComplete = reportRecord.getBoolean("autocompleteentry");
                if (!autoComplete) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"iscomplete", "percent", "completetime"});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"iscomplete", "percent", "completetime"});
            }
            Date date = task.getDate("realendtime");
            this.getModel().beginInit();
            this.getModel().setValue("percent", (Object)PERCENT_OK);
            this.getModel().setValue("iscomplete", (Object)Boolean.TRUE);
            this.getModel().setValue("completetime", (Object)date);
            this.getView().updateView("percent");
            this.getView().updateView("iscomplete");
            this.getView().updateView("completetime");
            this.getModel().endInit();
        }
    }

    protected void setAchievementAttach(DynamicObjectCollection taskDocEntry, DynamicObject[] taskReports) {
        HashMap<String, DynamicObject> newMap = new HashMap<String, DynamicObject>();
        HashMap oldMap = new HashMap();
        for (int i = 0; i < taskReports.length; ++i) {
            DynamicObjectCollection huibaoEntrys = taskReports[i].getDynamicObjectCollection("achieveentity");
            if (i == 0) {
                for (DynamicObject entry : huibaoEntrys) {
                    newMap.put(entry.get("resultid").toString(), entry);
                }
                continue;
            }
            for (DynamicObject entry : huibaoEntrys) {
                String resultId = entry.get("resultid").toString();
                List resultIds = (List)oldMap.get(resultId);
                if (null != resultIds) {
                    resultIds.add(entry);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(entry);
                oldMap.put(resultId, list);
            }
        }
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject taskDoc : taskDocEntry) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            DynamicObject newEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            this.setHistoryAchievement(taskDoc, rowIndex);
            if (null != newMap.get(taskDoc.getPkValue().toString())) {
                DynamicObject huibaoEntry = (DynamicObject)newMap.get(taskDoc.getPkValue().toString());
                newEntry.set("newattachment", (Object)huibaoEntry.getDynamicObjectCollection("attachmentfield"));
            }
            if (null == oldMap.get(taskDoc.getPkValue().toString())) continue;
            List huibaoentryS = (List)oldMap.get(taskDoc.getPkValue().toString());
            DynamicObjectCollection historyC = new DynamicObjectCollection();
            for (DynamicObject huibaoentry : huibaoentryS) {
                historyC.addAll((Collection)huibaoentry.getDynamicObjectCollection("attachmentfield"));
            }
            newEntry.set("historyattachment", (Object)historyC);
        }
    }

    protected void setHistoryAchievement(DynamicObject cg, int rowIndex) {
        this.getModel().setValue("cgresultname", cg.get("resultname"), rowIndex);
        this.getModel().setValue("cgforce", cg.get("force"), rowIndex);
        this.getModel().setValue("cgdesc", cg.get("resultdescription"), rowIndex);
        this.getModel().setValue("cgfrequency", cg.get("frequency"), rowIndex);
        this.getModel().setValue("cgresultid", cg.getPkValue(), rowIndex);
    }

    protected void modifyPerson(DynamicObject task, String key) {
        DynamicObject responPerson = task.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperatePersons = task.getDynamicObjectCollection("multicooperationperson");
        List cooperatePersonIds = cooperatePersons.stream().map(o -> o.getString("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject sharer = task.getDynamicObject("sharer");
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"add")) {
            if (null != this.getModel().getValue("creator")) {
                this.getModel().setValue("modifier", this.getModel().getValue("creator"));
                DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
                String name = creator.getString("name");
                if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)creator.getString("id"))) {
                    this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"ProgressReportFormPlugin_27", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                    this.getModel().setValue("persontype", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue());
                } else if (null != cooperatePersons && cooperatePersons.size() > 0 && cooperatePersonIds.contains(creator.getString("id"))) {
                    this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"ProgressReportFormPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                    this.getModel().setValue("persontype", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
                } else if (null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)creator.getString("id"))) {
                    this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"ProgressReportFormPlugin_29", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                    this.getModel().setValue("persontype", (Object)PersonTypeEnum.SHARER.getValue());
                }
            }
            if (null != this.getModel().getValue("createtime")) {
                this.getModel().setValue("modifytime", this.getModel().getValue("createtime"));
            }
        } else {
            DynamicObject modifier = (DynamicObject)this.getModel().getValue("modifier");
            String name = modifier.getString("name");
            if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)modifier.getString("id"))) {
                this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"ProgressReportFormPlugin_27", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                this.getModel().setValue("persontype", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue());
            } else if (null != cooperatePersons && cooperatePersons.size() > 0 && cooperatePersonIds.contains(modifier.getString("id"))) {
                this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"ProgressReportFormPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                this.getModel().setValue("persontype", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
            } else if (null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)modifier.getString("id"))) {
                this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"ProgressReportFormPlugin_29", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
                this.getModel().setValue("persontype", (Object)PersonTypeEnum.SHARER.getValue());
            }
        }
        this.getView().updateView("huibaoperson");
        this.getView().updateView("persontype");
    }

    protected void setAchievementEntry(DynamicObject task, String key) {
        boolean showResultEntry = false;
        DynamicObjectCollection txCollections = task.getDynamicObjectCollection("transactiontype");
        for (DynamicObject tx : txCollections) {
            Long baseDataId = tx.getLong("fbasedataid_id");
            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
            if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
            showResultEntry = true;
        }
        if (showResultEntry) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            DynamicObjectCollection taskDocEntry = task.getDynamicObjectCollection("taskresultdocentry");
            if (StringUtils.equals((CharSequence)key, (CharSequence)"editchengguo")) {
                DynamicObjectCollection huibaocgEntry = this.getModel().getEntryEntity("achieveentity");
                HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
                for (DynamicObject entry : huibaocgEntry) {
                    map.put(entry.get("resultid").toString(), entry);
                }
                this.getModel().deleteEntryData("achieveentity");
                for (DynamicObject taskDoc : taskDocEntry) {
                    int rowIndex = this.getModel().createNewEntryRow("achieveentity");
                    DynamicObject newEntry = this.getModel().getEntryRowEntity("achieveentity", rowIndex);
                    newEntry.set("resultname", taskDoc.get("resultname"));
                    newEntry.set("force", taskDoc.get("force"));
                    newEntry.set("desc", taskDoc.get("resultdescription"));
                    newEntry.set("frequency", taskDoc.get("frequency"));
                    newEntry.set("resultid", taskDoc.getPkValue());
                    if (null == map.get(taskDoc.getPkValue().toString())) continue;
                    DynamicObject oldentry = (DynamicObject)map.get(taskDoc.getPkValue().toString());
                    newEntry.set("attachmentfield", (Object)oldentry.getDynamicObjectCollection("attachmentfield"));
                }
            } else {
                this.getModel().deleteEntryData("achieveentity");
                for (DynamicObject taskDoc : taskDocEntry) {
                    int rowIndex = this.getModel().createNewEntryRow("achieveentity");
                    this.setAchievementEntry(taskDoc, rowIndex);
                }
            }
            this.getView().updateView("achieveentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
    }

    protected void setAchievementEntry(DynamicObject cg, int rowIndex) {
        this.getModel().setValue("resultname", cg.get("resultname"), rowIndex);
        this.getModel().setValue("force", cg.get("force"), rowIndex);
        this.getModel().setValue("desc", cg.get("resultdescription"), rowIndex);
        this.getModel().setValue("frequency", cg.get("frequency"), rowIndex);
        this.getModel().setValue("resultid", cg.getPkValue(), rowIndex);
    }

    protected void setReportRecordEntry(DynamicObject task) {
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
        this.getModel().deleteEntryData("reportrecordentity");
        for (DynamicObject taskreport : taskReportObjs) {
            int rowIndex = this.getModel().createNewEntryRow("reportrecordentity");
            this.setReportRecordEntryByRowIndex(taskreport, rowIndex);
        }
        this.setHistoryReportRecordEntry(task);
        this.getView().updateView("reportrecordentity");
    }

    private DynamicObject getLatestTaskReportRecord(Object id) {
        QFilter filters = new QFilter("task", "=", (Object)Long.parseLong(id.toString())).and("latest", "=", (Object)Character.valueOf('1')).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])new QFilter[]{filters});
    }

    protected void setHistoryReportRecordEntry(DynamicObject task) {
        boolean isLatest = task.getBoolean("islatest");
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        DynamicObject precChangeTask = task.getDynamicObject("prechangetask");
        if (!isLatest || precChangeTask == null || sourceTask == null) {
            return;
        }
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)false);
        QFilter[] filters = new QFilter[]{sourceTaskFilter, isLatestFilter};
        DynamicObject[] historyTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])filters);
        HashSet<Object> taskIds = new HashSet<Object>(historyTasks.length);
        for (DynamicObject historyTask : historyTasks) {
            taskIds.add(historyTask.getPkValue());
        }
        QFilter taskid = new QFilter("task", "in", taskIds);
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filters = new QFilter[]{taskid, taskreportStatus};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
        int[] oldTaskReportIndex = new int[taskReportObjs.length];
        int i = 0;
        for (DynamicObject taskreport : taskReportObjs) {
            int rowIndex = this.getModel().createNewEntryRow("reportrecordentity");
            oldTaskReportIndex[i++] = rowIndex;
            this.setReportRecordEntryByRowIndex(taskreport, rowIndex);
        }
        if (oldTaskReportIndex.length > 0) {
            EntryGrid reportEntry = (EntryGrid)this.getView().getControl("reportrecordentity");
            reportEntry.setRowBackcolor("lightgrey", oldTaskReportIndex);
        }
    }

    protected void setReportRecordEntryByRowIndex(DynamicObject taskreport, int rowIndex) {
        this.getModel().setValue("resultdate", (Object)taskreport.getDate("modifytime"), rowIndex);
        this.getModel().setValue("completeprocess", (Object)taskreport.getString("percent"), rowIndex);
        this.getModel().setValue("resultstatus", taskreport.get("billstatus"), rowIndex);
        this.getModel().setValue("reportperson", taskreport.get("huibaoperson"), rowIndex);
        this.getModel().setValue("completedesc", taskreport.get("reportdesc"), rowIndex);
        this.getModel().setValue("taskreport", taskreport.getPkValue(), rowIndex);
        this.getModel().setValue("historytask", taskreport.getDynamicObject("task").getPkValue(), rowIndex);
        this.getModel().setValue("autocompleteentry", (Object)taskreport.getBoolean("autocomplete"), rowIndex);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (StringUtils.equals((CharSequence)"resolutionentity", (CharSequence)entryKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("resolutionentity");
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        int curIndex = changeSet.getRowIndex();
        DynamicObject model = this.getModel().getDataEntity();
        Object oldValue = changeSet.getOldValue();
        Object newValue = changeSet.getNewValue();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"percent")) {
            if (this.getModel().getEntryEntity("resolutionentity").size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u8fdb\u5ea6\u5c06\u4f1a\u5220\u9664\u73b0\u6709\u4f1a\u8bae\u51b3\u8bae\u4efb\u52a1\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProgressReportFormPlugin_39", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("percent"));
                return;
            }
            this.executeWhenPercentChanges(newValue.toString());
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"iscomplete")) {
            boolean iscomplete = model.getBoolean("iscomplete");
            if (this.getModel().getEntryEntity("resolutionentity").size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u672a\u5b8c\u6210\u5c06\u4f1a\u5220\u9664\u73b0\u6709\u4f1a\u8bae\u51b3\u8bae\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProgressReportFormPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("iscomplete"));
                return;
            }
            this.executeWhenIscompleteChanges(iscomplete);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"completetime")) {
            this.getModel().beginInit();
            this.updateTips();
            this.getModel().endInit();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planstarttime1")) {
            try {
                this.checkInputTime("planstarttime1", curIndex);
            }
            catch (Exception e1) {
                Date planStartTimeOldValue = (Date)oldValue;
                this.getModel().setValue("planstarttime1", (Object)planStartTimeOldValue, curIndex);
                this.getView().showTipNotification(e1.getMessage());
            }
            this.calculateAbusoluteDuration(curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"planendtime1")) {
            try {
                this.checkInputTime("planendtime1", curIndex);
            }
            catch (Exception e1) {
                Date planEndTimeOldValue = (Date)oldValue;
                this.getModel().setValue("planendtime1", (Object)planEndTimeOldValue, curIndex);
                this.getView().showTipNotification(e1.getMessage());
            }
            this.calculateAbusoluteDuration(curIndex);
            this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"absoluteduration1")) {
            this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"inchargeperson")) {
            this.checkResponsiblePerson("inchargeperson", curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"multicooperator")) {
            this.checkResponsiblePerson("multicooperator", curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"transactiontype")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("resolutionentity");
            Object trans = this.getModel().getValue("transactiontype", entryCurrentRowIndex);
            boolean deleteEntry = true;
            if (null != trans) {
                DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
                for (DynamicObject tx : transactionType) {
                    Long baseDataId = tx.getLong("fbasedataid_id");
                    DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                    if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                    deleteEntry = false;
                }
            }
            if (deleteEntry) {
                this.getModel().deleteEntryData("taskresultdocentry");
            }
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
    }

    protected void executeWhenIscompleteChanges(boolean iscomplete) {
        DynamicObject model = this.getModel().getDataEntity();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        Object taskId = customMap.get("taskId");
        if (taskId == null || StringUtils.isBlank((CharSequence)taskId.toString())) {
            DynamicObject taskReport = model.getDynamicObject("task");
            taskId = taskReport.getPkValue();
        }
        if (taskId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1ID\u83b7\u53d6\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProgressReportFormPlugin_40", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle(taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        this.getModel().beginInit();
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        if (iscomplete) {
            this.getModel().setValue("percent", (Object)PERCENT_OK);
            this.getView().setEnable(Boolean.FALSE, new String[]{"completetime"});
            this.getModel().setValue("completetime", (Object)new Date());
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        } else {
            this.getModel().setValue("percent", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"completetime"});
            this.getModel().setValue("completetime", (Object)task.getDate("planendtime"));
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateView("percent");
        this.getView().updateView("completetime");
        this.showInputResolution();
        this.updateTips();
        this.getModel().endInit();
    }

    protected void executeWhenPercentChanges(String percent) {
        this.getModel().beginInit();
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        if (StringUtils.equalsIgnoreCase((CharSequence)percent, (CharSequence)PERCENT_OK)) {
            this.getModel().setValue("iscomplete", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"completetime"});
            this.getModel().setValue("completetime", (Object)new Date());
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        } else {
            this.getModel().setValue("iscomplete", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.TRUE, new String[]{"completetime"});
            completeTime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"ProgressReportFormPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        this.showInputResolution();
        this.getView().updateView("iscomplete");
        this.getView().updateView("completetime");
        this.updateTips();
        this.getModel().endInit();
    }

    protected void setTransactionEntryEnable(int rowIndex) {
        boolean showResultDoc = false;
        Object trans = this.getModel().getValue("transactiontype", rowIndex);
        if (null != trans) {
            DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
            for (DynamicObject tx : transactionType) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if (showResultDoc) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap11"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap11"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap11"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap11"});
        }
    }

    protected void checkResponsiblePerson(String operateKey, int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity("resolutionentity", rowIndex);
        DynamicObject responsiblePerson = row.getDynamicObject("inchargeperson");
        DynamicObjectCollection cooperationPersons = row.getDynamicObjectCollection("multicooperator");
        MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPersons);
        if (responsiblePerson != null && "inchargeperson".equalsIgnoreCase(operateKey)) {
            long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePerson.getPkValue().toString()));
            this.getModel().setValue("inchargedept", (Object)orgId, rowIndex);
        } else if ("multicooperator".equalsIgnoreCase(operateKey)) {
            List cooperationDepts = MultiCooperationPersonUtils.getMultiMainOrgIdsByCopersons((DynamicObjectCollection)cooperationPersons);
            this.getModel().setValue("multicooperatedept", (Object)cooperationDepts.toArray(), rowIndex);
        }
    }

    protected void checkInputTime(String changeField, int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime1", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime1", rowIndex);
        if ("planstarttime1".equals(changeField)) {
            if (planStartTime == null) {
                return;
            }
            if (planEndTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4\u3002", (String)"ProgressReportFormPlugin_31", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if ("planendtime1".equals(changeField)) {
            if (planEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ProgressReportFormPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void calculateAbusoluteDuration(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime1", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime1", rowIndex);
        if (planStartTime != null && planEndTime != null) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("taskproject");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)(project != null ? project.getPkValue() : Long.valueOf(0L)), (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
            this.getModel().setValue("absoluteduration1", (Object)newAbsoluteDuration.add(BigDecimal.ONE), rowIndex);
        }
    }

    protected void calculatePlanEndTimeByAbusoluteDuration(int rowIndex) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("taskproject");
        Date planStartTime = (Date)this.getModel().getValue("planstarttime1", rowIndex);
        if (planStartTime == null) {
            return;
        }
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("absoluteduration1", rowIndex);
        if (absoluteDuration.compareTo(BigDecimal.ZERO) != 0) {
            Date newPlanEndTime = TaskUtil.getDateAfterAddDays((Object)(project != null ? project.getPkValue() : Long.valueOf(0L)), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
            this.getModel().setValue("planendtime1", (Object)newPlanEndTime, rowIndex);
        }
    }

    protected void showInputResolution() {
        Object transaction = Optional.ofNullable((DynamicObject)this.getModel().getValue("task")).map(task -> task.getDynamicObjectCollection("transactiontype")).orElse(null);
        Object percent = this.getModel().getValue("percent");
        if (StringUtils.equalsIgnoreCase((CharSequence)percent.toString(), (CharSequence)PERCENT_OK) && this.isMeetingTask(transaction)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputresolution"});
        } else {
            this.getModel().deleteEntryData("resolutionentity");
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputresolution", "assigntaskpanel", "advconap11"});
            this.getModel().updateEntryCache(this.getModel().getEntryEntity("resolutionentity"));
            this.getView().updateView("resolutionentity");
        }
    }

    protected boolean isMeetingTask(Object transactionType) {
        boolean isMeetingTask = false;
        if (null != transactionType) {
            DynamicObjectCollection transactionTypeCollections = (DynamicObjectCollection)transactionType;
            for (DynamicObject tx : transactionTypeCollections) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.MEETING.getValue(), txType.get("number"))) continue;
                isMeetingTask = true;
                break;
            }
        }
        return isMeetingTask;
    }

    protected void updateTips() {
        DynamicObject model = this.getModel().getDataEntity();
        Date completeTime = model.getDate("completetime");
        DynamicObject task = model.getDynamicObject("task");
        task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        Date taskPlanEnd = task.getDate("planendtime");
        BigDecimal days = BigDecimal.ZERO;
        if (null != completeTime && null != taskPlanEnd && completeTime.compareTo(taskPlanEnd) > 0) {
            DynamicObject project = task.getDynamicObject("project");
            DynamicObject belongType = task.getDynamicObject("belongplantype");
            if (null != project) {
                boolean taskPlanendIsWorkDay = TaskUtil.checkDateIsWorkDay((Date)taskPlanEnd, (Object)project.getPkValue(), (int)1, (String)this.getAppId());
                boolean completetimeIsWorkDay = TaskUtil.checkDateIsWorkDay((Date)completeTime, (Object)project.getPkValue(), (int)1, (String)this.getAppId());
                days = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)taskPlanEnd, (Date)completeTime, (String)this.getAppId());
                if (!taskPlanendIsWorkDay && !completetimeIsWorkDay) {
                    if (days.compareTo(BigDecimal.ZERO) > 0) {
                        days = days.add(BigDecimal.ONE);
                    }
                } else if (!taskPlanendIsWorkDay && completetimeIsWorkDay) {
                    days = days.add(BigDecimal.ONE);
                }
            } else if (null != belongType && (StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"TRANSACTIONPLAN_S") || StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"PERSONALPLAN_S"))) {
                QFilter idFilter;
                Long planId;
                DynamicObject org = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"TRANSACTIONPLAN_S")) {
                    planId = task.getLong("planid");
                    idFilter = new QFilter("id", "=", (Object)planId);
                    QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"assigner,billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, planningcycle, timerange, STARTTIME, ENDTIME, name, version, sourceplan, prechangeplan, planstatus, planstatus1", (QFilter[])new QFilter[]{idFilter, statusFilter});
                    if (null != plan) {
                        org = plan.getDynamicObject("org");
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"PERSONALPLAN_S")) {
                    planId = task.getLong("planid");
                    idFilter = new QFilter("id", "=", (Object)planId);
                    QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"personplan"), (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, name, planningcycle, planstarttime, timerangestartdate, timerangeenddate, planperson,assigner", (QFilter[])new QFilter[]{idFilter, statusFilter});
                    if (null != plan) {
                        org = plan.getDynamicObject("org");
                    }
                }
                if (null != org) {
                    boolean taskPlanendIsWork = TaskUtil.checkDateIsWorkDay((Date)taskPlanEnd, (Object)org.getPkValue(), (int)2, (String)this.getAppId());
                    boolean completetimeIsWork = TaskUtil.checkDateIsWorkDay((Date)completeTime, (Object)org.getPkValue(), (int)2, (String)this.getAppId());
                    days = TaskUtil.getDaysBetweenTwoDateByOrg((Object)org.getPkValue(), (Date)taskPlanEnd, (Date)completeTime, (String)this.getAppId());
                    if (!taskPlanendIsWork && !completetimeIsWork) {
                        if (days.compareTo(BigDecimal.ZERO) > 0) {
                            days = days.add(BigDecimal.ONE);
                        }
                    } else if (!taskPlanendIsWork && completetimeIsWork) {
                        days = days.add(BigDecimal.ONE);
                    }
                }
            }
        }
        days = days.subtract(BigDecimal.ONE);
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (days.compareTo(BigDecimal.ZERO) > 0) {
            propMap.put("fc", "#FF0000");
            this.getView().updateControlMetadata("tips", propMap);
            String msg = String.format(ResManager.loadKDString((String)"\u5ef6\u671f%s\u5929", (String)"ProgressReportFormPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), days);
            this.getModel().setValue("tips", (Object)msg);
            this.getView().setVisible(Boolean.TRUE, new String[]{"tips"});
        } else {
            this.getModel().setValue("tips", (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips"});
        }
        this.getView().updateView("tips");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        DynamicObject model = this.getModel().getDataEntity();
        switch (callBackId) {
            case "import": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.importTaskOperation();
                break;
            }
            case "percent": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.executeWhenPercentChanges(model.getString("percent"));
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("percent", (Object)PERCENT_OK);
                this.getModel().endInit();
                this.getView().updateView("percent");
                break;
            }
            case "iscomplete": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.executeWhenIscompleteChanges(model.getBoolean("iscomplete"));
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("iscomplete", (Object)true);
                this.getModel().endInit();
                this.getView().updateView("iscomplete");
                break;
            }
            case "deleteresolutionentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                EntryGrid grid = (EntryGrid)this.getControl("resolutionentity");
                int[] selRows = grid.getSelectRows();
                this.getModel().deleteEntryRows("resolutionentity", selRows);
            }
        }
    }

    protected void importTaskOperation() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog")));
        this.getView().showForm(importExcelFormParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String key = closedCallBackEvent.getActionId();
        if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog").equalsIgnoreCase(key) && StringUtils.isNotBlank((Object)(returnData = closedCallBackEvent.getReturnData()))) {
            DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
            boolean showResultDoc = false;
            for (DynamicObject task : tasks) {
                DynamicObjectCollection transactionType = task.getDynamicObjectCollection("transactiontype");
                if (null != transactionType) {
                    for (DynamicObject tx : transactionType) {
                        Long baseDataId = tx.getLong("fbasedataid_id");
                        DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                        if (transactionType.size() >= 2 || Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number")) || task.getDynamicObjectCollection("taskresultdocentry") == null || task.getDynamicObjectCollection("taskresultdocentry").size() <= 0) continue;
                        showResultDoc = true;
                    }
                } else if (transactionType == null && task.getDynamicObjectCollection("taskresultdocentry") != null) {
                    showResultDoc = true;
                }
                DynamicObject reportTask = (DynamicObject)this.getModel().getValue("task");
                task.set("isleaf", (Object)DefaultEnum.YES.getValue());
                task.set("level", (Object)1);
                task.set("taskproject", Optional.ofNullable(reportTask).map(t -> t.getDynamicObject("project")).orElse(null));
                task.set("meettask", (Object)reportTask);
                task.set("tasksource", Optional.ofNullable(reportTask).map(t -> t.getDynamicObject("tasksource")).orElse(null));
            }
            if (showResultDoc) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u679c\u201d\u7684\u4efb\u52a1\uff0c\u624d\u80fd\u4e0a\u4f20\u201c\u6210\u679c\u6587\u6863\u201d\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"ProgressReportFormPlugin_41", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            this.getModel().updateEntryCache(tasks);
            this.getView().updateView("resolutionentity");
            this.getView().invokeOperation("save");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        DynamicObject model = this.getModel().getDataEntity();
        if (StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)key)) {
            this.doSubmit(args, model);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)key)) {
            this.doSave(args, model);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"submitnopro", (CharSequence)key)) {
            this.getModel().setValue("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
            this.getModel().updateCache();
            this.getView().invokeOperation("audit");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"newentry", (CharSequence)key)) {
            args.setCancel(true);
            DynamicObjectCollection tasks = this.getModel().getEntryEntity("resolutionentity");
            DynamicObject newRow = tasks.addNew();
            newRow.set("taskproject", Optional.ofNullable((DynamicObject)this.getModel().getValue("task")).map(task -> task.getDynamicObject("project")).orElse(null));
            newRow.set("meettask", this.getModel().getValue("task"));
            newRow.set("tasksource", Optional.ofNullable((DynamicObject)this.getModel().getValue("task")).map(task -> task.getDynamicObject("tasksource")).orElse(null));
            newRow.set("level", (Object)1);
            this.getModel().updateEntryCache(tasks);
            this.getView().updateView("resolutionentity");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DELETE_RESOLUTION_ENTRY, (CharSequence)key)) {
            EntryGrid grid = (EntryGrid)this.getControl("resolutionentity");
            int[] selRows = grid.getSelectRows();
            if (null == selRows || selRows.length <= 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"ProgressReportFormPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"ProgressReportFormPlugin_26", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_RESOLUTION_ENTRY));
            args.setCancel(true);
        }
    }

    protected void doSave(BeforeDoOperationEventArgs args, DynamicObject model) {
        DynamicObject task = model.getDynamicObject("task");
        String personType = model.getString("persontype");
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.TEMPSAVE.getValue()).or("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
        if (StringUtils.equalsIgnoreCase((CharSequence)personType, (CharSequence)PersonTypeEnum.RESPONSIBLEPERSON.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)personType, (CharSequence)PersonTypeEnum.SHARER.getValue())) {
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue()).or("persontype", "=", (Object)PersonTypeEnum.SHARER.getValue());
        }
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"id", (QFilter[])filters);
        if (null != taskReportObjs && taskReportObjs.length == 1 && StringUtils.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().get("id").toString(), (CharSequence)"0")) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u4efb\u52a1\u6b63\u5728\u88ab\u5176\u4ed6\u4eba\u6c47\u62a5\u3002", (String)"ProgressReportFormPlugin_34", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected void doSubmit(BeforeDoOperationEventArgs args, DynamicObject model) {
        String huibaoPerson = model.getString("huibaoperson");
        if (!StringUtils.containsIgnoreCase((CharSequence)huibaoPerson, (CharSequence)ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"ProgressReportFormPlugin_7", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) {
            Date completetime = model.getDate("completetime");
            boolean isComplete = model.getBoolean("iscomplete");
            if (null == completetime) {
                if (isComplete) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4\u3002", (String)"ProgressReportFormPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4\u3002", (String)"ProgressReportFormPlugin_36", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            DynamicObject task = model.getDynamicObject("task");
            int percent = model.getInt("percent");
            if (percent == 0) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6c47\u62a5\u8fdb\u5ea6\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ProgressReportFormPlugin_37", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        int percent = model.getInt("percent");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("achieveentity");
        boolean isNeedUpload = true;
        DynamicObjectCollection reportRecords = this.getModel().getEntryEntity("reportrecordentity");
        for (DynamicObject reportRecord : reportRecords) {
            if (!reportRecord.get("completeprocess").equals(PERCENT_OK)) continue;
            isNeedUpload = false;
        }
        for (DynamicObject chenguo : entries) {
            DynamicObjectCollection attachmentfield;
            boolean force = chenguo.getBoolean("force");
            String frequency = chenguo.getString("frequency");
            if (force && StringUtils.equalsIgnoreCase((CharSequence)frequency, (CharSequence)FrequencyEnum.FINISH.getValue()) && percent == 100) {
                attachmentfield = chenguo.getDynamicObjectCollection("attachmentfield");
                if (null != attachmentfield && attachmentfield.size() != 0 || !isNeedUpload) continue;
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u4efb\u52a1\u6c47\u62a5\u5b8c\u6210\u65f6\uff0c\u4efb\u52a1\u4e3a\u5f3a\u5236\u63d0\u4ea4\u7684\u201c\u9636\u6bb5\u6027\u6210\u679c\u201d\uff0c\u8bf7\u63d0\u4ea4\u6210\u679c\u3002", (String)"ProgressReportFormPlugin_43", (String)"pccs-placs-formplugin", (Object[])new Object[0]), chenguo.getString("resultname")));
                args.setCancel(true);
                return;
            }
            if (!force || !StringUtils.equalsIgnoreCase((CharSequence)frequency, (CharSequence)FrequencyEnum.EVERYTIME.getValue()) || null != (attachmentfield = chenguo.getDynamicObjectCollection("attachmentfield")) && attachmentfield.size() != 0) continue;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6bcf\u6b21\u6c47\u62a5\u65f6\u5f3a\u5236\u63d0\u4ea4\u7684\u201c\u9636\u6bb5\u6027\u6210\u679c\u201d\uff0c\u8bf7\u63d0\u4ea4\u6210\u679c\u3002", (String)"ProgressReportFormPlugin_44", (String)"pccs-placs-formplugin", (Object[])new Object[0]), chenguo.getString("resultname")));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "inputresolution": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"assigntaskpanel"});
                break;
            }
            case "import": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProgressReportFormPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5bfc\u5165\u5c06\u4f1a\u5220\u9664\u73b0\u6709\u4f1a\u8bae\u51b3\u8bae\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProgressReportFormPlugin_24", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("import"));
                break;
            }
            case "export": {
                ProgressTaskImpAndExpUtil util = this.getUtil();
                util.exportProgressModel(this.getView(), true, "resolutionentity");
            }
        }
    }

    protected ProgressTaskImpAndExpUtil getUtil() {
        return new ProgressTaskImpAndExpUtil(this.getView());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"resultdate")) {
            Object taskreportId = this.getModel().getValue("taskreport", rowIndex);
            Object taskId = this.getModel().getValue("historytask", rowIndex);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
            map.put("pkId", taskreportId);
            map.put("taskId", taskId);
            map.put("hyper", taskId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setAppId(this.getAppId());
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (OperationStatus.VIEW.equals((Object)status) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            e.setCheckDataChange(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName = arg.getProperty().getName();
        if ("taskproject".equals(propName)) {
            arg.setCustomQFilters(this.setProjectListFilter().getQFilters());
        }
    }

    protected ListFilterParameter setProjectListFilter() {
        ListFilterParameter filterParameter = new ListFilterParameter();
        return filterParameter;
    }

    protected List<Long> getAllPermOrgs() {
        return PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)this.getView().getEntityId(), (String)"view");
    }
}

