/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.utils.TimeUtils;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.ProjWorkCalendarLoadService;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class ProjDefaultCalendarEditPlugin
extends AbstractPlacsFormPlugin
implements IConfirmCallBack {
    private static final Log logger = LogFactory.getLog(ProjDefaultCalendarEditPlugin.class);
    private static final String IS_COPY_LASTYEAR_CALLBACK = "isCopyLastyearCallBack";
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    public void initialize() {
        this.addClickListeners(new String[]{"setworkcalendar", "preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.addClickListener((ClickListener)this);
        workCalendar.setPassDayLocked(false);
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getValue("year") == null || String.valueOf(this.getModel().getDataEntity().get("year")).trim().length() == 0) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
        int year = Calendar.getInstance().get(1);
        this.loadWorkCalendarForDefault(year);
    }

    public void click(EventObject evt) {
        WorkCalendar workCalendar;
        Control c = (Control)evt.getSource();
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (c.getKey().toLowerCase().startsWith("preyear")) {
            if (this.clickPreYear(year)) {
                return;
            }
        } else if (c.getKey().toLowerCase().startsWith("nextyear")) {
            this.clickNextYear(year);
        }
        if ((workCalendar = (WorkCalendar)this.getControl("workcalendarap")).equals(c)) {
            Calendar curDatefor = Calendar.getInstance();
            curDatefor.set(curDatefor.get(1), curDatefor.get(2), curDatefor.get(5), 0, 0, 0);
            Date time = curDatefor.getTime();
            ArrayList dateList = workCalendar.getDateList();
            for (String date : dateList) {
                try {
                    Date parse = this.SDF.parse(date);
                    if (!parse.before(time)) continue;
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u65e0\u6cd5\u8bbe\u7f6e\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u7684\u65e5\u671f\u3002", (String)"ProjDefaultCalendarEditPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                    return;
                }
                catch (ParseException e) {
                    logger.error((Throwable)e);
                }
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closesetcalendartip");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"changecalendartips"));
            param.setCloseCallBack(closeCallBack);
            params.put("dateList", workCalendar.getDateList());
            params.put("dateType", workCalendar.getDateType());
            param.setCustomParams(params);
            this.getView().showForm(param);
        }
    }

    protected void clickNextYear(int year) {
        int nextyear = year + 1;
        Object curId = this.getModel().getValue("id");
        if (this.loadWorkCalendarForDefault(nextyear) || StringUtils.isBlank((Object)curId)) {
            this.setCurYear(nextyear);
        } else {
            this.getModel().setValue("id", curId);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u590d\u5236\u4e0a\u4e00\u5e74\u5de5\u4f5c\u65e5\u5386\uff1f", (String)"ProjDefaultCalendarEditPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]), nextyear), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_COPY_LASTYEAR_CALLBACK, (IFormPlugin)this));
        }
    }

    protected boolean clickPreYear(int year) {
        int lastyear = year - 1;
        Object curId = this.getModel().getValue("id");
        if (this.loadWorkCalendarForDefault(lastyear)) {
            this.setCurYear(lastyear);
        } else if (year > Calendar.getInstance().get(1)) {
            this.loadEmptyWorkCalendar(lastyear);
        } else {
            this.getModel().setValue("id", curId);
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386\u3002", (String)"ProjDefaultCalendarEditPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), year - 1);
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closesetcalendartip".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            String priority = closedCallBackEvent.getReturnData().toString().split("\\[\"")[0];
            String aftersplit = closedCallBackEvent.getReturnData().toString().split("\\[\"")[1];
            String date = aftersplit.split("\"\\]")[0];
            String dateType = aftersplit.split("\"\\]")[1];
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(date);
            workCalendar.setDateList(arrayList);
            workCalendar.setDateType(dateType);
            this.markWorkCalendar(workCalendar);
            TaskUtil.updateTimeWhenDefaultCalChange((int)Integer.parseInt(priority), (String)this.getAppId());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (IS_COPY_LASTYEAR_CALLBACK.equalsIgnoreCase(callBackId)) {
            int nextyear = year + 1;
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.generateNextYearEntry(nextyear);
                this.setCurYear(nextyear);
            }
        }
    }

    protected void generateNextYearEntry(int nextyear) {
        Object id = this.getModel().getValue("id");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"));
        DynamicObject[] curWorkCalendarArr = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)type);
        DynamicObject curWorkCalendar = curWorkCalendarArr[0];
        curWorkCalendar.set("expiringyearto", (Object)nextyear);
        int month = 12;
        curWorkCalendar.set("expiringmonthto", (Object)month);
        DynamicObjectCollection dateentry = curWorkCalendar.getDynamicObjectCollection("dateentry");
        if (dateentry != null && dateentry.size() > 0) {
            int seq = dateentry.size();
            DynamicObject lastObj = (DynamicObject)dateentry.get(seq - 1);
            Date lastWorkDate = lastObj.getDate("workdate");
            Calendar smallDate = Calendar.getInstance();
            smallDate.setTime(lastWorkDate);
            smallDate.add(5, 1);
            Calendar bigDate = Calendar.getInstance();
            bigDate.set(nextyear, month - 1, 1, 0, 0, 0);
            bigDate.set(nextyear, month - 1, bigDate.getActualMaximum(5), 0, 0, 0);
            int days = TimeUtils.daysBetween((Calendar)smallDate, (Calendar)bigDate);
            this.genCurWorkCalendarEntity(curWorkCalendar, dateentry, days, seq + 1, smallDate);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curWorkCalendar});
    }

    protected void genCurWorkCalendarEntity(DynamicObject curWorkCalendar, DynamicObjectCollection dateentry, int days, int seq, Calendar smallDate) {
        Object[] isRestDay = this.getRestDays(curWorkCalendar);
        Object[] isHalfWorkDay = this.getHalfWorkDays(curWorkCalendar);
        int year = smallDate.get(1);
        int nextYear = year + 1;
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.set(1, nextYear);
        int nextYearDays = nextYearCal.getActualMaximum(6);
        int newxYearStart = days - nextYearDays;
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMapForDefaultNoProjId(dateFrom, dateTo, this.getAppId());
        Calendar curCal = Calendar.getInstance();
        ArrayList<String> dateList = new ArrayList<String>(markDateMap.size());
        ArrayList workDataList = new ArrayList();
        for (int i = 0; i < days; ++i) {
            DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
            row.set("seq", (Object)(i + seq));
            Date workDate = smallDate.getTime();
            String workDateStr = this.SDF.format(workDate);
            row.set("workdate", (Object)workDate);
            curCal.setTime(workDate);
            curCal.set(1, year);
            String workDateKey = this.SDF.format(curCal.getTime());
            Object dateTypeObj = markDateMap.get(workDateKey);
            if (dateTypeObj != null) {
                String dateType = String.valueOf(dateTypeObj);
                row.set("datetype", (Object)dateType);
                dateList.add(workDateStr);
                this.recordMarkWorkCalendar(dateList, dateType);
                dateList.clear();
            } else {
                int curDate = smallDate.get(7) - 1;
                dateTypeObj = (Boolean)isRestDay[curDate] != false ? "4" : ((Boolean)isHalfWorkDay[curDate] != false ? "2" : "1");
                row.set("datetype", dateTypeObj);
            }
            dateentry.add((Object)row);
            smallDate.add(5, 1);
            if (i < newxYearStart) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("workDate", workDateStr);
            data.put("dateType", dateTypeObj == null ? "1" : dateTypeObj.toString());
            workDataList.add(data);
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        workCalendar.setYear(nextYear);
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
    }

    protected Object[] getRestDays(DynamicObject obj) {
        Object[] isRestDay = new Object[]{obj.get("issunrest"), obj.get("ismonrest"), obj.get("istuerest"), obj.get("iswedrest"), obj.get("isthurest"), obj.get("isfrirest"), obj.get("issatrest")};
        return isRestDay;
    }

    protected Object[] getHalfWorkDays(DynamicObject obj) {
        Object[] isHalfWorkDay = new Object[]{obj.get("ishalfsunrest"), obj.get("ishalfmonrest"), obj.get("ishalftuerest"), obj.get("ishalfwedrest"), obj.get("ishalfthurest"), obj.get("ishalffrirest"), obj.get("ishalfsatrest")};
        return isHalfWorkDay;
    }

    protected void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    protected boolean loadWorkCalendarForDefault(int year) {
        String dateTo;
        boolean isLoaded = false;
        HashMap<String, String> orgMap = new HashMap<String, String>();
        String dateFrom = year + "-01-01";
        List<Map<String, String>> workDataList = ProjWorkCalendarLoadService.loadWorkCalendarForDefualt(orgMap, dateFrom, dateTo = year + "-12-31", this.getAppId());
        if (workDataList != null && workDataList.size() > 0) {
            isLoaded = true;
            this.getModel().setValue("id", orgMap.get("id"));
            this.getModel().setValue("startvaliddate", (Object)workDataList.get(0).get("workDate"));
            this.getModel().setValue("endvaliddate", (Object)workDataList.get(workDataList.size() - 1).get("workDate"));
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
        } else {
            this.getModel().setValue("id", (Object)"");
        }
        return isLoaded;
    }

    protected void loadEmptyWorkCalendar(int year) {
        this.setCurYear(year);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        workCalendar.setYear(year);
        workCalendar.setData();
    }

    protected void markWorkCalendar(WorkCalendar workCalendar) {
        ArrayList dateList = workCalendar.getDateList();
        if (!this.markDateValidate(dateList)) {
            return;
        }
        String dateType = workCalendar.getDateType();
        this.recordMarkWorkCalendar(dateList, dateType);
        workCalendar.setDateTypeCallBack((List)dateList, dateType);
    }

    protected boolean markDateValidate(List<String> dateList) {
        if (dateList == null || dateList.size() == 0) {
            return false;
        }
        boolean isSucess = true;
        String startDateStr = dateList.get(0);
        Calendar today = Calendar.getInstance();
        try {
            Date startDate = this.SDF.parse(startDateStr);
            if (today.getTime().getTime() > startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6807\u6ce8\u5f53\u524d\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u5386\u3002", (String)"ProjDefaultCalendarEditPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                isSucess = false;
            } else {
                String endDateStr = dateList.get(dateList.size() - 1);
                Date endDate = this.SDF.parse(endDateStr);
                Date startvaliddate = (Date)this.getModel().getValue("startvaliddate");
                Date endvaliddate = (Date)this.getModel().getValue("endvaliddate");
                if (startvaliddate == null || endvaliddate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u5de5\u4f5c\u65e5\u5386\u7684\u6709\u6548\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u3002", (String)"ProjDefaultCalendarEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (startvaliddate.getTime() > startDate.getTime() || endvaliddate.getTime() < endDate.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u6709\u6548\u671f\u95f4\u4e4b\u5916\u7684\u65e5\u5386\u65e0\u6cd5\u6807\u6ce8\u3002", (String)"ProjDefaultCalendarEditPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    isSucess = false;
                }
            }
        }
        catch (Exception e) {
            isSucess = false;
        }
        return isSucess;
    }

    protected void recordMarkWorkCalendar(List<String> dateList, String dateType) {
        QFilter[] filters = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)Character.valueOf('1'))};
        ORM orm = ORM.create();
        ArrayList<DynamicObject> workCalendarObjs = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection workCalendarDb = orm.query(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"), "id, dateentry.*", filters);
        if (workCalendarDb == null || workCalendarDb.isEmpty()) {
            DynamicObject[] insertedObjs;
            DynamicObject obj = orm.newDynamicObject(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"));
            String smallDateStr = dateList.get(0);
            Date smallDate = new Date();
            try {
                smallDate = this.SDF.parse(smallDateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(smallDate);
            obj.set("isindividuation", (Object)Character.valueOf('1'));
            this.genEntityCommon(obj, "");
            for (DynamicObject newObj : insertedObjs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj})) {
                DynamicObjectCollection dateentry = newObj.getDynamicObjectCollection("dateentry");
                this.genMarkWorkCalendarEntity(newObj, dateentry, dateList.size(), dateType, cal);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
            }
        } else {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"projworkcalendarset"));
            EntryProp entryProp = (EntryProp)met.getProperty("dateentry");
            EntryType entryType = (EntryType)entryProp.getItemType();
            for (DynamicObject obj : workCalendarDb) {
                DynamicObjectCollection dateentry = obj.getDynamicObjectCollection("dateentry");
                if (dateentry == null) continue;
                List<Map<String, Object>> recordDateList = this.removeDuplicateMarkRecord(dateentry, dateList, dateType);
                int index = 1;
                for (Map<String, Object> dateMap : recordDateList) {
                    DynamicObject newObj = new DynamicObject((DynamicObjectType)entryType, null);
                    newObj.set("seq", (Object)index++);
                    newObj.set("workdate", dateMap.get("workdate"));
                    newObj.set("datetype", dateMap.get("datetype"));
                    dateentry.add((Object)newObj);
                }
                workCalendarObjs.add(obj);
            }
            orm.update(workCalendarObjs);
        }
    }

    protected void genEntityCommon(DynamicObject obj, String orgId) {
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("enable", (Object)"1");
        obj.set("status", (Object)"A");
        obj.set("creator", (Object)RequestContext.get().getUserId());
        Date date = new Date();
        obj.set("createtime", (Object)date);
        obj.set("modifier", (Object)RequestContext.get().getUserId());
        obj.set("modifytime", (Object)date);
        obj.set("minofendtimepm", (Object)0);
        obj.set("hourofendtimepm", (Object)0);
        obj.set("minofbegintimepm", (Object)0);
        obj.set("hourofbegintimepm", (Object)0);
        obj.set("minofendtimeam", (Object)0);
        obj.set("hourofendtimeam", (Object)0);
        obj.set("minofbegintimeam", (Object)0);
        obj.set("hourofbegintimeam", (Object)0);
        obj.set("version", (Object)"default");
    }

    protected void genMarkWorkCalendarEntity(DynamicObject curWorkCalendar, DynamicObjectCollection dateentry, int days, String dateType, Calendar smallDate) {
        for (int i = 0; i < days; ++i) {
            DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
            row.set("seq", (Object)0);
            row.set("workdate", (Object)smallDate.getTime());
            row.set("datetype", (Object)dateType);
            dateentry.add((Object)row);
            smallDate.add(5, 1);
        }
    }

    protected List<Map<String, Object>> removeDuplicateMarkRecord(DynamicObjectCollection dateentry, List<String> dateList, String dateType) {
        HashMap<String, Object> oldDateMap;
        int oldCount = 0;
        if (dateentry != null) {
            oldCount = dateentry.size();
        }
        int newDateCount = dateList.size();
        ArrayList<Map<String, Object>> recordDateList = new ArrayList<Map<String, Object>>(oldCount + newDateCount);
        HashMap<String, String> newDateMap = new HashMap<String, String>(newDateCount);
        try {
            for (String date : dateList) {
                oldDateMap = new HashMap<String, Object>(2);
                oldDateMap.put("datetype", dateType);
                oldDateMap.put("workdate", this.SDF.parse(date));
                recordDateList.add(oldDateMap);
                newDateMap.put(date, dateType);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (dateentry != null) {
            for (int i = oldCount - 1; i >= 0; --i) {
                DynamicObject newObj = (DynamicObject)dateentry.get(i);
                if (newDateMap.get(this.SDF.format(newObj.getDate("workdate"))) == null) {
                    oldDateMap = new HashMap(2);
                    oldDateMap.put("workdate", newObj.getDate("workdate"));
                    oldDateMap.put("datetype", newObj.get("datetype"));
                    recordDateList.add(oldDateMap);
                }
                dateentry.remove(i);
            }
        }
        return recordDateList;
    }
}

