/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class ProjWorkCalendarLoadService {
    public static final String ID = "id";
    public static final String SELECTED_ORG_ID = "org";
    public static final String DATA_ORG_ID = "dataorg";
    public static final String WORK_DATE = "workDate";
    public static final String DATE_TYPE = "dateType";
    public static final String PROJECT_ID = "projectid";
    private static Log logger = LogFactory.getLog(ProjWorkCalendarLoadService.class);

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, int year, String appId) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID)) {
            return new ArrayList<Map<String, String>>();
        }
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        return ProjWorkCalendarLoadService.loadWorkCalendar(orgMap, dateFrom, dateTo, appId);
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, String dateFrom, String dateTo, String appId) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        String orgId = orgMap.get(SELECTED_ORG_ID);
        orgMap.put(DATA_ORG_ID, orgId);
        if (orgId.contains("proj")) {
            ProjWorkCalendarLoadService.loadForProjctDefault(workDataList, orgMap, dateFrom, dateTo, appId);
        } else {
            ProjWorkCalendarLoadService.load(workDataList, orgMap, dateFrom, dateTo, appId);
        }
        if (workDataList.size() == 0) {
            return workDataList;
        }
        ProjWorkCalendarLoadService.fillFullYear(workDataList, orgMap, dateFrom, dateTo, appId);
        return workDataList;
    }

    public static List<Map<String, String>> loadWorkCalendarForDefualt(Map<String, String> orgMap, String dateFrom, String dateTo, String appId) {
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        ProjWorkCalendarLoadService.loadForProjctDefaultNoProjId(orgMap, workDataList, dateFrom, dateTo, appId);
        return workDataList;
    }

    public static Map<String, Object> getMarkDateMap(String orgId, String dateFrom, String dateTo, String flag, String appId) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        ProjWorkCalendarLoadService.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo, flag, appId);
        return markDateMap;
    }

    private static void load(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, String appId) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection parendCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), qf);
        String flag = "";
        if (parendCalendar != null && parendCalendar.size() > 0) {
            obj = parendCalendar;
            flag = "1";
            ProjWorkCalendarLoadService.loadCommon(workDataList, orgMap, dateFromStr, dateToStr, obj, flag, appId);
            return;
        }
        String parentId = ProjWorkCalendarLoadService.getOrgPrentId(orgId);
        if (StringUtils.isNotBlank((CharSequence)parentId) && !"0".equals(parentId)) {
            orgMap.put(DATA_ORG_ID, parentId);
            ProjWorkCalendarLoadService.load(workDataList, orgMap, dateFromStr, dateToStr, appId);
        } else {
            QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defaultProjCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), filter);
            if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
                obj = defaultProjCalendar;
                ProjWorkCalendarLoadService.loadCommonForDefaultNoProjId(workDataList, orgMap, dateFromStr, dateToStr, obj, appId);
            }
        }
    }

    private static void loadForProjctDefault(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, String appId) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0])) : new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection projCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), qf);
        String flag = "";
        if (projCalendar != null && projCalendar.size() > 0) {
            flag = "0";
            obj = projCalendar;
            ProjWorkCalendarLoadService.loadCommon(workDataList, orgMap, dateFromStr, dateToStr, obj, flag, appId);
        } else {
            QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defaultProjCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), filter);
            if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
                obj = defaultProjCalendar;
                ProjWorkCalendarLoadService.loadCommonForDefault(workDataList, orgMap, dateFromStr, dateToStr, obj, appId);
            }
        }
    }

    private static void loadForProjctDefaultNoProjId(Map<String, String> orgMap, List<Map<String, String>> workDataList, String dateFromStr, String dateToStr, String appId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        DynamicObjectCollection obj = null;
        QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection defaultProjCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), filter);
        if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
            obj = defaultProjCalendar;
            ProjWorkCalendarLoadService.loadCommonForDefaultNoProjId(workDataList, orgMap, dateFromStr, dateToStr, obj, appId);
        }
    }

    private static void fillFullYear(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFrom, String dateTo, String appId) {
        String minDateFrom = workDataList.get(0).get(WORK_DATE);
        String maxDateFrom = workDataList.get(workDataList.size() - 1).get(WORK_DATE);
        Date fDate = null;
        Date tDate = null;
        Date minDate = null;
        Date maxDate = null;
        try {
            Calendar cal;
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            fDate = SDF.parse(dateFrom);
            tDate = SDF.parse(dateTo);
            minDate = SDF.parse(minDateFrom);
            maxDate = SDF.parse(maxDateFrom);
            if (fDate.compareTo(minDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(minDate);
                cal.add(5, -1);
                workDataList.addAll(ProjWorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), dateFrom, SDF.format(cal.getTime()), appId));
            }
            if (maxDate.compareTo(tDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(maxDate);
                cal.add(5, 1);
                workDataList.addAll(ProjWorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), SDF.format(cal.getTime()), dateTo, appId));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    private static List<Map<String, String>> fillDate(String org, String dataOrg, String dateFrom, String dateTo, String appId) {
        ArrayList<Map<String, String>> tempWorkDataList = new ArrayList<Map<String, String>>();
        if (StringUtils.isBlank((CharSequence)org) || "0".equals(org)) {
            return tempWorkDataList;
        }
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put(SELECTED_ORG_ID, org);
        ProjWorkCalendarLoadService.loadForProjctDefault(tempWorkDataList, orgMap, dateFrom, dateTo, appId);
        return tempWorkDataList;
    }

    private static void findAllMarkDate(Map<String, Object> markDateMap, String orgId, String dateFromStr, String dateToStr, String flag, String appId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0])) : new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        if (entityList == null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defualtEntityList = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : defualtEntityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
    }

    private static String getOrgPrentId(String id) {
        DynamicObject parentObj;
        String parentId = "";
        QFilter[] qf = new QFilter[3];
        qf[0] = new QFilter("view.isdefault", "=", (Object)"1");
        qf[1] = new QFilter("view.treetype", "=", (Object)"15");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            qf[2] = new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(id));
        }
        if ((parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf)) == null) {
            return parentId;
        }
        return parentObj.getString("parent");
    }

    private static void loadCommon(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String flag, String appId) {
        String orgId = orgMap.get(DATA_ORG_ID);
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMap(orgMap.get(SELECTED_ORG_ID), dateFromStr, dateToStr, flag, appId);
        String selectOrgId = orgMap.get(SELECTED_ORG_ID);
        if (StringUtils.isNotBlank((CharSequence)selectOrgId) && !orgId.equals(selectOrgId)) {
            markDateMap = ProjWorkCalendarLoadService.getMarkDateMap(orgId, dateFromStr, dateToStr, flag, appId);
        }
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    private static void loadCommonForDefault(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String appId) {
        String orgId = orgMap.get(DATA_ORG_ID);
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        Map<String, Object> markDateMapForDefault = ProjWorkCalendarLoadService.getMarkDateMapForDefault(dateFromStr, dateToStr, orgId, appId);
        Map<String, Object> markDateMapForDefaultNoProjId = ProjWorkCalendarLoadService.getMarkDateMapForDefaultNoProjId(dateFromStr, dateToStr, appId);
        markDateMap.putAll(markDateMapForDefault);
        markDateMap.putAll(markDateMapForDefaultNoProjId);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    private static void loadCommonForDefaultNoProjId(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String appId) {
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMapForDefaultNoProjId(dateFromStr, dateToStr, appId);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    public static boolean queryCalendarFlag(String orgId, String startDate, String endDate, String appId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(startDate);
            dateTo = dateFormat.parse(endDate);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] qf = new QFilter[4];
        if (orgId.contains("proj")) {
            if (StringUtils.isNotBlank((CharSequence)orgId.split("proj")[0])) {
                qf[0] = new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0]));
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgId)) {
            qf[0] = new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId));
        }
        qf[1] = new QFilter("isindividuation", "=", (Object)"0");
        qf[2] = new QFilter("dateentry.workdate", ">=", (Object)dateFrom);
        qf[3] = new QFilter("dateentry.workdate", "<=", (Object)dateTo);
        DynamicObject[] projCalendar = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)ID, (QFilter[])qf);
        return projCalendar == null || projCalendar.length <= 0;
    }

    public static List<Map<String, String>> loadForCurrCalender(Map<String, String> orgMap, int year, String appId) {
        String dateFromStr = year + "-01-01";
        String dateToStr = year + "-12-31";
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        String orgId = orgMap.get(SELECTED_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0])) : new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection projCalendar = orm.query(MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), qf);
        String flag = "";
        if (projCalendar != null && projCalendar.size() > 0) {
            flag = "0";
            obj = projCalendar;
            ProjWorkCalendarLoadService.loadCommonForCurrOrg(workDataList, orgMap, dateFromStr, dateToStr, obj, flag, appId);
        }
        return workDataList;
    }

    public static void loadCommonForCurrOrg(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String flag, String appId) {
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMapForCurrOrg(orgMap.get(SELECTED_ORG_ID), dateFromStr, dateToStr, flag, appId);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    public static Map<String, Object> getMarkDateMapForCurrOrg(String orgId, String dateFrom, String dateTo, String flag, String appId) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0])) : new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static Map<String, Object> getMarkDateMapForDefault(String dateFrom, String dateTo, String org, String appId) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter("project", "=", (Object)Long.valueOf(org.split("proj")[0])), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static Map<String, Object> getMarkDateMapForDefaultNoProjId(String dateFrom, String dateTo, String appId) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static boolean queryCalendarFlagNoRecurtion(String orgId, String startDate, String endDate, String appId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(startDate);
            dateTo = dateFormat.parse(endDate);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0])) : new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObject[] projCalendar = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"projworkcalendarset"), (String)ID, (QFilter[])qf);
        return projCalendar == null || projCalendar.length <= 0;
    }

    public static boolean queryProjectTask(String appId, String orgId) {
        QFilter[] qf = new QFilter[]{new QFilter("project", "=", (Object)(StringUtils.isNotBlank((CharSequence)orgId.split("proj")[0]) ? Long.parseLong(orgId.split("proj")[0]) : 0L))};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)ID, (QFilter[])qf);
        return dynamicObject != null;
    }
}

