/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class SelectPlanTplPlugin
extends AbstractPlacsFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject project = parentModel.getDataEntity().getDynamicObject("project");
        if (project == null) {
            return;
        }
        QFilter projectKindFilter = new QFilter("projectkind", "=", (Object)0L);
        DynamicObject projectKind = this.getProjectKind(project);
        if (projectKind != null) {
            projectKindFilter.or(new QFilter("projectkind", "=", projectKind.getPkValue()));
        }
        QFilter validFilter = new QFilter("validversion", "=", (Object)"1");
        DynamicObject[] tplArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"plantemplate"), (String)"id,name", (QFilter[])new QFilter[]{projectKindFilter, validFilter}, (String)"projectkind desc,version desc");
        if (tplArr == null || tplArr.length == 0) {
            return;
        }
        this.getModel().setValue("plantpl", tplArr[0].getPkValue());
    }

    protected DynamicObject getProjectKind(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"returntoparent", (CharSequence)operateKey)) {
            DynamicObject planTpl = this.getModel().getDataEntity().getDynamicObject("plantpl");
            this.getView().returnDataToParent((Object)planTpl);
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planTplEdit = (BasedataEdit)this.getControl("plantpl");
        planTplEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String paramName = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"plantpl", (CharSequence)paramName)) {
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            DynamicObject project = parentModel.getDataEntity().getDynamicObject("project");
            DynamicObject projectKind = this.getProjectKind(project);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            QFilter projectKindFilter = new QFilter("projectkind", "=", (Object)0L);
            if (projectKind != null) {
                projectKindFilter.or(new QFilter("projectkind", "=", projectKind.getPkValue()));
            }
            QFilter validFilter = new QFilter("validversion", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(projectKindFilter.and(validFilter));
        }
    }
}

