/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;

public class SelectTaskEntryPlugin
extends AbstractPlacsFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object masterPlanId = this.getView().getFormShowParameter().getCustomParam("masterPlanId");
        if (masterPlanId == null) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(masterPlanId.toString()));
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"taskentity,taskentity.pid,isleaf", (QFilter[])new QFilter[]{idFilter});
        DynamicObjectCollection taskEntryCol = masterPlan.getDynamicObjectCollection("taskentity");
        this.getModel().deleteEntryData("treeentryentity");
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        DynamicObjectType type = treeentryentity.getDynamicObjectType();
        int i = 0;
        for (DynamicObject taskEntry : taskEntryCol) {
            DynamicObject newTask = new DynamicObject(type);
            newTask.set("id", taskEntry.getPkValue());
            newTask.set("pid", taskEntry.get("pid"));
            newTask.set("isleaf", taskEntry.get("isleaf"));
            treeentryentity.add((Object)newTask);
            this.getModel().setValue("task", taskEntry.getPkValue(), i++);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"returntoparent", (CharSequence)operateKey)) {
            int selectRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", selectRowIndex);
            Boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", selectRowIndex);
            if (!isLeaf.booleanValue()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u660e\u7ec6\u8282\u70b9", (String)"SelectTaskEntryPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject task = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "=", entry.getPkValue())});
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            HashSet<Long> taskIdSet = new HashSet<Long>(16);
            if (sourceTask != null) {
                DynamicObjectCollection sameSourceTaskCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue())});
                for (DynamicObject sameSourceTask : sameSourceTaskCol) {
                    taskIdSet.add(sameSourceTask.getLong("id"));
                }
            }
            taskIdSet.add(task.getLong("id"));
            QFilter relationTaskFilter = new QFilter("taskentity.relationtask", "in", taskIdSet);
            QFilter notRelationTaskPlanFilter = new QFilter("relatedmastertask", "not in", taskIdSet);
            Object specialPlanId = this.getView().getFormShowParameter().getCustomParam("specialPlanId");
            QFilter specialPlanIdFilter = new QFilter("id", "!=", (Object)Long.parseLong(specialPlanId.toString()));
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (QFilter[])new QFilter[]{relationTaskFilter, specialPlanIdFilter, notRelationTaskPlanFilter});
            if (exists) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4e13\u9879\u8ba1\u5212\u5f15\u7528\u3002", (String)"SelectTaskEntryPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkExistSamePlan()) {
                args.setCancel(true);
                return;
            }
            this.getView().returnDataToParent(entry.getPkValue());
            this.getView().close();
        }
    }

    protected boolean checkExistSamePlan() {
        DynamicObject parentModel = this.getView().getParentView().getModel().getDataEntity();
        Object masterPlanId = this.getView().getFormShowParameter().getCustomParam("masterPlanId");
        if (masterPlanId == null) {
            return false;
        }
        int selectRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", selectRowIndex);
        Long relatedMasterTaskId = (Long)entry.getPkValue();
        DynamicObject preRelatedMasterTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"majortype,prechangetask", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relatedMasterTaskId)});
        if (preRelatedMasterTask == null) {
            return false;
        }
        Long majorTypeId = preRelatedMasterTask.getLong("majortype_id");
        if (majorTypeId == 0L) {
            majorTypeId = parentModel.getLong("majortype_id");
        }
        if (majorTypeId == 0L) {
            return false;
        }
        preRelatedMasterTask = preRelatedMasterTask.getDynamicObject("prechangetask");
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)masterPlanId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        DynamicObject masterPreChangePlan = masterPlan.getDynamicObject("prechangeplan");
        QFilter majorTypeFilter = new QFilter("majortype", "=", (Object)majorTypeId);
        QFilter masterPlanFilter = null;
        if (masterPreChangePlan != null) {
            masterPlanFilter = new QFilter("masterplan", "=", masterPreChangePlan.getPkValue());
            String[] planStatusArr = new String[]{PlanEnum.CREATEING.getValue(), PlanEnum.CHECKING.getValue()};
            QFilter planStatusFilter = new QFilter("planstatus", "in", (Object)planStatusArr);
            QFilter preRelatedMasterTaskFilter = null;
            if (preRelatedMasterTask != null) {
                preRelatedMasterTaskFilter = new QFilter("relatedmastertask", "=", preRelatedMasterTask.getPkValue());
            }
            ArrayList<QFilter> unPublishedFilterList = new ArrayList<QFilter>(10);
            unPublishedFilterList.add(masterPlanFilter);
            unPublishedFilterList.add(majorTypeFilter);
            unPublishedFilterList.add(planStatusFilter);
            unPublishedFilterList.add(preRelatedMasterTaskFilter);
            this.modifyUnPublishedFilterList(unPublishedFilterList);
            DynamicObject specialObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"billname", (QFilter[])unPublishedFilterList.toArray(new QFilter[unPublishedFilterList.size()]));
            if (specialObj != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u65e7\u7248\u672c\u4e0b\u7684\u4e13\u9879\u8ba1\u5212\u201c%s\u201d\uff0c\u7136\u540e\u5728\u65b0\u7248\u672c\u4e0b\u521b\u5efa\u8be5\u4e13\u4e1a\u7c7b\u578b\u7684\u4e13\u9879\u8ba1\u5212\u3002", (String)"SelectTaskEntryPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]), specialObj.getString("billname")));
                return true;
            }
        }
        masterPlanFilter = new QFilter("masterplan", "=", masterPlan.getPkValue());
        QFilter relatedMasterTaskFilter = new QFilter("relatedmastertask", "=", (Object)relatedMasterTaskId);
        ArrayList<QFilter> oldPlanFilterList = new ArrayList<QFilter>(10);
        oldPlanFilterList.add(majorTypeFilter);
        oldPlanFilterList.add(masterPlanFilter);
        oldPlanFilterList.add(relatedMasterTaskFilter);
        this.modifyOldPlanFilterList(oldPlanFilterList);
        DynamicObject[] existedObj = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"version", (QFilter[])oldPlanFilterList.toArray(new QFilter[oldPlanFilterList.size()]));
        if (existedObj != null && existedObj.length == 1) {
            if (!StringUtils.equals((CharSequence)existedObj[0].getPkValue().toString(), (CharSequence)parentModel.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u7684\u4e13\u9879\u7c7b\u578b\u8ba1\u5212\u5df2\u5b58\u5728\u3002\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\u3002", (String)"SelectTaskEntryPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if (existedObj != null && existedObj.length > 1) {
            String curPk = parentModel.getPkValue().toString();
            boolean isHasSelf = false;
            for (DynamicObject obj : existedObj) {
                if (!StringUtils.equals((CharSequence)obj.getPkValue().toString(), (CharSequence)curPk)) continue;
                isHasSelf = true;
            }
            if (!isHasSelf) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u7684\u4e13\u9879\u7c7b\u578b\u8ba1\u5212\u5df2\u5b58\u5728\u3002\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\u3002", (String)"SelectTaskEntryPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected void modifyUnPublishedFilterList(List unPublishedFilterList) {
    }

    protected void modifyOldPlanFilterList(List oldPlanFilterList) {
    }
}

