/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.task.DealWithEntryDataUtils;
import kd.pccs.placs.business.utils.task.FileAttachmentHelper;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.PlanEntryUtil;
import kd.pccs.placs.business.utils.task.PlanTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.business.utils.task.TreeEntryUtils;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;
import kd.pccs.placs.formplugin.helper.TreeEntryGridHelper;
import org.jetbrains.annotations.NotNull;

public class SpecialPlanEditPlugin
extends AbstractPlacsBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String PARENTID = "parentBillId";
    private static final String DELETE_TASK_CONFIRM = "deleteTaskConfirm";
    public static final int PERCENT_OK = 100;
    private static final String NEW_TASK_CONFIRM = "newTaskConfirm";
    private static final Long MAJORPLANID = 1102888764654624768L;
    private static final String SHOWRELATEDTASKCLICK_CACHE = "showRelatedTaskCache";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    protected Map<String, Integer> taskLevelMap = new HashMap<String, Integer>();
    private static final int MAX_LEVEL = 6;
    private static final int TAB_SIZE = 2;
    private static final String LEVEL = "level";

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"SpecialPlanEditPlugin_63", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object taskId = this.getModel().getEntryRowEntity("taskentity", rowIndex).getPkValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", taskId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (StringUtils.equals((CharSequence)"taskentity", (CharSequence)entryProp.getName())) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            for (int i = 0; i < rowDataEntities.length; ++i) {
                int rowIndex = rowDataEntities[i].getRowIndex();
                if (i == 0) {
                    this.setAchievementEntryEnable(rowIndex);
                }
                DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
                this.getModel().setValue("belongplantype", majorType != null ? majorType.getPkValue() : null, rowIndex);
                this.getModel().setValue("tasksource", majorType != null ? majorType.getPkValue() : null, rowIndex);
                this.getModel().setValue("specialtype", majorType != null ? majorType.getPkValue() : null, rowIndex);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (StringUtils.equals((CharSequence)"taskentity", (CharSequence)entryKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
            this.setTransactionEntryEnable(entryCurrentRowIndex);
        }
    }

    protected boolean isAdjust(Object parentBillId) {
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (parentBillId == null) {
            parentBillId = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        }
        return isCopy != null && isCopy != false && null != parentBillId;
    }

    public void beforeBindData(EventObject e) {
        Object majortypeId;
        Object relatedmastertaskid;
        Object selectedPlan;
        super.beforeBindData(e);
        Object parentBillId = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        boolean isAdjust = this.isAdjust(parentBillId);
        if (isAdjust) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"masterplan"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"majortype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"relatedmastertask"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"billname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"generatefromtpl"});
            BigDecimal version = (BigDecimal)this.getModel().getValue("version");
            BigDecimal newVersion = version.add(BigDecimal.ONE.divide(BigDecimal.TEN));
            this.getModel().setValue("version", (Object)newVersion);
            this.getModel().setValue("billname", (Object)this.createSpecialPlanName());
            this.getModel().setValue("prechangeplan", parentBillId);
            DynamicObject parentPlan = BusinessDataServiceHelper.loadSingle((Object)parentBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
            DynamicObject sourcePlan = parentPlan.getDynamicObject("sourceplan");
            if (null == sourcePlan) {
                this.getModel().setValue("sourceplan", (Object)parentPlan);
            } else {
                this.getModel().setValue("sourceplan", (Object)sourcePlan);
            }
            this.getModel().setValue("planstatus", (Object)PlanEnum.CREATEING.getValue());
            String sourceBillFormId = parentPlan.getDynamicObjectType().toString();
            Object sourceBillId = parentBillId;
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
            DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
            if (entries == null || entries.isEmpty()) {
                return;
            }
            DynamicObjectCollection parentPlanEntries = parentPlan.getDynamicObjectCollection("taskentity");
            HashMap<Long, Integer> idSeqMap = new HashMap<Long, Integer>(16);
            for (int i = 0; i < parentPlanEntries.size(); ++i) {
                idSeqMap.put((Long)((DynamicObject)parentPlanEntries.get(i)).getPkValue(), i);
            }
            int seq = 0;
            for (DynamicObject entry : entries) {
                DynamicObject newTask;
                Integer curSeq;
                DynamicObject oldTask = (DynamicObject)parentPlanEntries.get(seq);
                entry.set("prechangetask", (Object)oldTask);
                DynamicObject sourceTask = oldTask.getDynamicObject("sourcetask");
                if (sourceTask == null) {
                    entry.set("sourcetask", (Object)oldTask);
                } else {
                    entry.set("sourcetask", (Object)sourceTask);
                }
                entry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                entry.set("taskversion", (Object)BigDecimal.ONE.divide(BigDecimal.TEN).add(oldTask.getBigDecimal("taskversion")));
                entry.set("islatest", (Object)DefaultEnum.NO.getValue());
                ++seq;
                long preTaskId = entry.getLong("pretask_id");
                if (preTaskId == 0L || (curSeq = (Integer)idSeqMap.get(preTaskId)) == null || (newTask = (DynamicObject)entries.get(curSeq.intValue())) == null) continue;
                entry.set("pretask", (Object)newTask);
            }
            this.getView().invokeOperation("save");
            this.getModel().updateCache();
        }
        if ((selectedPlan = this.getView().getFormShowParameter().getCustomParam("selectedPlan")) != null) {
            this.switchMasterPlan(selectedPlan);
        }
        if (this.getModel().getValue("org") == null) {
            this.getModel().beginInit();
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
            this.getModel().endInit();
        }
        if ((relatedmastertaskid = this.getView().getFormShowParameter().getCustomParam("relatedmastertaskid")) != null) {
            this.getModel().setValue("relatedmastertask", relatedmastertaskid);
        }
        if ((majortypeId = this.getView().getFormShowParameter().getCustomParam("majortypeId")) != null) {
            this.getModel().setValue("majortype", (Object)BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", majortypeId)}));
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
    }

    protected void levelLableAddListener(int maxLevel, int tabSize) {
        for (int i = 1; i <= maxLevel * tabSize; ++i) {
            Label level = (Label)this.getControl("level_" + i);
            level.addClickListener((ClickListener)this);
        }
    }

    protected void updateImportTask() {
        String billStatus = this.getModel().getValue("billstatus").toString();
        Map<String, DynamicObject> relationNewTaskMap = this.checkRelationNewTasks();
        if (relationNewTaskMap.isEmpty()) {
            return;
        }
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue())) {
            int rowCount = this.getModel().getEntryRowCount("taskentity");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject newTask;
                DynamicObject relationTask = (DynamicObject)this.getModel().getValue("relationtask", i);
                if (relationTask == null || (newTask = relationNewTaskMap.get(relationTask.getPkValue().toString())) == null) continue;
                this.updateEntryByRelationTask(newTask, i);
            }
            this.getModel().updateCache();
            this.getView().updateView("taskentity");
            this.getView().updateView("taskresultdocentry");
            this.getView().updateView("taskreferdocentry");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8c03\u6574\u5df2\u66f4\u65b0\u81f3\u6700\u65b0\u7248\u672c\u3002", (String)"SpecialPlanEditPlugin_64", (String)"pccs-placs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) {
            String planStatus = this.getModel().getValue("planstatus").toString();
            if (PlanEnum.PUBLISHED.getValue().equalsIgnoreCase(planStatus)) {
                DynamicObject masterPlan = (DynamicObject)this.getModel().getValue("masterplan");
                String masterPlanStatus = (masterPlan = BusinessDataServiceHelper.loadSingle((Object)masterPlan.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"planstatus")).getString("planstatus");
                if (StringUtils.equals((CharSequence)masterPlanStatus, (CharSequence)PlanEnum.HISTORY.getValue())) {
                    ArrayList<Integer> changeRowIndexList = new ArrayList<Integer>(10);
                    int rowCount = this.getModel().getEntryRowCount("taskentity");
                    for (int i = 0; i < rowCount; ++i) {
                        DynamicObject newTask;
                        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                        Date entryRowStartTime = entryRowEntity.getDate("planstarttime");
                        Date entryRowEndTime = entryRowEntity.getDate("planendtime");
                        DynamicObject relationTask = entryRowEntity.getDynamicObject("relationtask");
                        if (relationTask == null || (newTask = relationNewTaskMap.get(relationTask.getPkValue().toString())) == null) continue;
                        Date planstarttime = newTask.getDate("planstarttime");
                        Date planendtime = newTask.getDate("planendtime");
                        if (planstarttime.compareTo(entryRowStartTime) != 0) {
                            changeRowIndexList.add(i + 1);
                            continue;
                        }
                        if (planendtime.compareTo(entryRowEndTime) == 0) continue;
                        changeRowIndexList.add(i + 1);
                    }
                    if (!changeRowIndexList.isEmpty()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u5f15\u5165\u65f6\u95f4\u5df2\u8c03\u6574\u3002\u5982\u9700\u540c\u6b65\uff0c\u8bf7\u9009\u62e9\u6700\u65b0\u7684\u4e13\u9879\u8ba1\u5212\u7248\u672c\u8fdb\u884c\u8c03\u6574\u3002", (String)"SpecialPlanEditPlugin_65", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ((Object)changeRowIndexList).toString()));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212\u5df2\u505a\u8c03\u6574\uff0c\u5982\u9700\u540c\u6b65\uff0c\u9700\u624b\u52a8\u8c03\u6574\u4e13\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_47", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected void updateEntryByRelationTask(DynamicObject newTask, int rowIndex) {
        DynamicObject relationTask = BusinessDataServiceHelper.loadSingle((Object)newTask.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        this.getModel().setValue("name", (Object)relationTask.getString("name"), rowIndex);
        this.getModel().setValue("number", (Object)relationTask.getString("number"), rowIndex);
        this.getModel().setValue("controllevel", (Object)relationTask.getDynamicObject("controllevel"), rowIndex);
        this.getModel().setValue("tasktype", (Object)relationTask.getDynamicObject("tasktype"), rowIndex);
        this.getModel().setValue("achievementnode", (Object)relationTask.getString("achievementnode"), rowIndex);
        this.getModel().setValue("pretask", (Object)relationTask.getDynamicObject("pretask"), rowIndex);
        this.getModel().setValue("logical", (Object)relationTask.getString("logical"), rowIndex);
        this.getModel().setValue("absoluteduration", (Object)relationTask.getBigDecimal("absoluteduration"), rowIndex);
        this.getModel().setValue("relativeduration", (Object)relationTask.getBigDecimal("relativeduration"), rowIndex);
        this.getModel().setValue("planstarttime", (Object)relationTask.getDate("planstarttime"), rowIndex);
        this.getModel().setValue("planendtime", (Object)relationTask.getDate("planendtime"), rowIndex);
        this.getModel().setValue("aimfinishtime", (Object)relationTask.getDate("aimfinishtime"), rowIndex);
        this.getModel().setValue("comptimedeviation", (Object)relationTask.getBigDecimal("comptimedeviation"), rowIndex);
        this.getModel().setValue("realendtime", (Object)relationTask.getDate("realendtime"), rowIndex);
        this.getModel().setValue("percent", (Object)relationTask.getBigDecimal("percent"), rowIndex);
        this.getModel().setValue("responsibleperson", (Object)relationTask.getDynamicObject("responsibleperson"), rowIndex);
        this.getModel().setValue("responsibledept", (Object)relationTask.getDynamicObject("responsibledept"), rowIndex);
        this.getModel().setValue("completedescription", (Object)relationTask.getString("completedescription"), rowIndex);
        ORM orm = ORM.create();
        DynamicObject newEntry = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        SpecialPlanEditPlugin.setTx(relationTask.getDynamicObjectCollection("transactiontype"), newEntry, orm);
        MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)relationTask, (String)"multicooperationperson");
        MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)relationTask, (String)"multicooperationdept");
        this.getModel().setValue("comment", (Object)relationTask.getString("comment"), rowIndex);
        this.getModel().setValue("relationtask", relationTask.getPkValue(), rowIndex);
        DynamicObject task = (DynamicObject)this.getModel().getEntryEntity("taskentity").get(rowIndex);
        this.copyTaskFile(relationTask, task);
    }

    private void hideResultdocapByTransactionType(Object transactionType) {
        boolean showResultDoc = false;
        if (null != transactionType) {
            DynamicObjectCollection txCollect = (DynamicObjectCollection)transactionType;
            for (DynamicObject tx : txCollect) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if (showResultDoc) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    protected void hideLevelNum(String entityKey) {
        DynamicObjectCollection taskEntries;
        HashMap<String, Long> map = new HashMap<String, Long>();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if (StringUtils.equals((CharSequence)"tabpageap", (CharSequence)currentTab)) {
            taskEntries = this.getModel().getEntryEntity(entityKey);
            for (DynamicObject taskEnetity : taskEntries) {
                map.put(taskEnetity.getString("id"), taskEnetity.getLong("pid"));
            }
        }
        if (StringUtils.equals((CharSequence)"adjusttab", (CharSequence)currentTab)) {
            taskEntries = this.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject taskEnetity : taskEntries) {
                map.put(taskEnetity.getDynamicObject("task").getString("id"), taskEnetity.getLong("pid"));
            }
        }
        HashSet<String> taskIds = new HashSet<String>(map.keySet());
        this.taskLevelMap.clear();
        this.setTaskLevel(map, taskIds);
        Collection<Integer> values = this.taskLevelMap.values();
        Optional<Integer> max = values.stream().max(Comparator.comparingInt(o -> o));
        int maxLevel = max.isPresent() ? max.get() : 0;
        this.taskLevelMap.entrySet().stream().forEach(entry -> this.getPageCache().put((String)entry.getKey() + "@taskId", String.valueOf(entry.getValue())));
        for (int i = 1; i <= 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                if (maxLevel < i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level_" + (i + 6 * j)});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"level_" + (i + 6 * j)});
            }
        }
    }

    protected void setTaskLevel(Map<String, Long> map, Set<String> taskIds) {
        if (null == map || map.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        Set<String> keys = this.taskLevelMap.keySet();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> next = iterator.next();
            if (next.getValue() == 0L) {
                this.taskLevelMap.put(next.getKey(), 1);
                iterator.remove();
                continue;
            }
            if (taskIds.contains(String.valueOf(next.getValue()))) {
                Integer level;
                if (!keys.contains(String.valueOf(next.getValue())) || null == (level = this.taskLevelMap.get(String.valueOf(next.getValue())))) continue;
                this.taskLevelMap.put(next.getKey(), level + 1);
                iterator.remove();
                continue;
            }
            this.taskLevelMap.put(next.getKey(), 1);
            iterator.remove();
        }
        this.setTaskLevel(map, taskIds);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBaseInfoCollapse();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
        this.hideLevelNum("taskentity");
        Object transactionType = this.getModel().getValue("transactiontype", 0);
        this.hideResultdocapByTransactionType(transactionType);
        DynamicObject preChangePlan = (DynamicObject)this.getModel().getValue("prechangeplan");
        if (preChangePlan != null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assigner"});
        }
        this.updateImportTask();
        this.checkExceedMaster();
        this.setTransactionEntryEnable(0);
        this.setMajorTypeFilter();
    }

    protected void setBaseInfoCollapse() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        boolean isCopy = formShowParameter.getCustomParam("iscopy") != null;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (OperationStatus.VIEW.equals((Object)status) || isCopy || !StringUtils.endsWithIgnoreCase((CharSequence)"A", (CharSequence)billStatus)) {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(true);
        } else {
            Container baseinfo = (Container)this.getControl("fs_baseinfo");
            baseinfo.setCollapse(false);
        }
    }

    private void checkExceedMaster() {
        DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentity");
        HashMap<String, DynamicObject> masterTaskRef = new HashMap<String, DynamicObject>(16);
        ArrayList<Integer> outOfRangeRowList = new ArrayList<Integer>(10);
        for (int i = 0; i < tasks.size(); ++i) {
            DynamicObject task = (DynamicObject)tasks.get(i);
            if (task.getDynamicObject("relationtask") != null) {
                masterTaskRef.put(task.getPkValue().toString(), task);
                continue;
            }
            long pid = task.getLong("pid");
            if (pid == 0L || !masterTaskRef.containsKey(Long.toString(pid))) continue;
            DynamicObject masterParent = (DynamicObject)masterTaskRef.get(Long.toString(pid));
            Date planstarttime = task.getDate("planstarttime");
            Date planendtime = task.getDate("planendtime");
            if (planstarttime != null && planstarttime.before(masterParent.getDate("planstarttime"))) {
                outOfRangeRowList.add(i + 1);
                continue;
            }
            if (planendtime == null || !planendtime.after(masterParent.getDate("planendtime"))) continue;
            outOfRangeRowList.add(i + 1);
        }
        if (outOfRangeRowList.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u8d85\u51fa\u5bf9\u5e94\u4e3b\u9879\u4efb\u52a1\u65f6\u95f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SpecialPlanEditPlugin_52", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ((Object)outOfRangeRowList).toString()));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        DynamicObject masterPlan = (DynamicObject)this.getModel().getValue("masterplan");
        if (masterPlan == null && !key.equals("masterplan")) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeSet = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        int curIndex = changeSet.getRowIndex();
        switch (key) {
            case "masterplan": {
                DynamicObject masterPlan = (DynamicObject)changeSet.getNewValue();
                DynamicObject project = masterPlan.getDynamicObject("project");
                model.setValue("project", (Object)project);
                this.checkExistMajortype();
                model.setValue("majortype", null);
                model.setValue("billname", null);
                model.setValue("relatedmastertask", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
                break;
            }
            case "majortype": {
                if (this.checkExistSamePlan()) {
                    return;
                }
                model.setValue("billname", (Object)this.createSpecialPlanName());
                model.deleteEntryData("taskentity");
                DynamicObject majorType = (DynamicObject)changeSet.getNewValue();
                boolean isAdjust = this.isAdjust(null);
                if (!isAdjust) {
                    List<QFilter> qFilters = this.getPreChangePlanFilters(model);
                    DynamicObject specialObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
                    if (specialObj != null) {
                        model.setValue("prechangeplan", (Object)specialObj);
                        this.getView().setVisible(Boolean.FALSE, new String[]{"generatefromtpl"});
                    } else {
                        model.setValue("prechangeplan", null);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"generatefromtpl"});
                    }
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"generatefromtpl"});
                }
                if (majorType == null) break;
                this.settingTaskEntryData(majorType);
                break;
            }
            case "pretask": {
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                Object newValue = changeSet.getNewValue();
                if (newValue != null) break;
                this.getModel().setValue("logical", null, curIndex);
                break;
            }
            case "logical": {
                this.ctrlV2Enum(curIndex);
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                break;
            }
            case "aimfinishtime": {
                try {
                    this.checkInputTime("aimfinishtime", curIndex);
                }
                catch (Exception e1) {
                    Date oldValue = (Date)changeSet.getOldValue();
                    model.setValue("aimfinishtime", (Object)oldValue, curIndex);
                    this.getView().showTipNotification(e1.getMessage());
                }
                this.calculateCompleteTimeDeviation(curIndex);
                this.settingParentPlanTime("aimfinishtime", curIndex);
                break;
            }
            case "planstarttime": {
                try {
                    String startLogical = (String)model.getValue("logical", curIndex);
                    if (startLogical == null || startLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)startLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)startLogical)) {
                        this.settingParentPlanTime("planstarttime", curIndex);
                        this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                    } else {
                        this.checkInputTime("planstarttime", curIndex);
                        this.settingParentPlanTime("planstarttime", curIndex);
                        this.calculateAbusoluteDuration(curIndex);
                    }
                }
                catch (Exception e1) {
                    Date oldValue = (Date)changeSet.getOldValue();
                    if (oldValue != null) {
                        if (this.checkMainPlanTaskTime(curIndex, oldValue)) {
                            model.setValue("planstarttime", (Object)oldValue, curIndex);
                        }
                    } else {
                        model.beginInit();
                        model.setValue("planstarttime", (Object)oldValue, curIndex);
                        model.endInit();
                        this.getView().updateView("planstarttime", curIndex);
                    }
                    this.getView().showTipNotification(e1.getMessage());
                }
                this.calculateOtherTaskTime(curIndex);
                break;
            }
            case "planendtime": {
                String endLogical = (String)model.getValue("logical", curIndex);
                if (endLogical == null || endLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)endLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)endLogical)) {
                    try {
                        this.checkInputTime("planendtime", curIndex);
                        this.settingParentPlanTime("planendtime", curIndex);
                    }
                    catch (Exception e1) {
                        Date oldValue = (Date)changeSet.getOldValue();
                        if (oldValue != null) {
                            if (this.checkMainPlanTaskTime(curIndex, oldValue)) {
                                model.setValue("planendtime", (Object)oldValue, curIndex);
                            }
                        } else {
                            model.beginInit();
                            model.setValue("planendtime", (Object)oldValue, curIndex);
                            model.endInit();
                            this.getView().updateView("planendtime", curIndex);
                        }
                        this.getView().showTipNotification(e1.getMessage());
                    }
                    this.calculateAbusoluteDuration(curIndex);
                    this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                } else {
                    this.calculatePlanStartTimeByAbusoluteDuration(curIndex);
                }
                this.calculateCompleteTimeDeviation(curIndex);
                this.calculateOtherTaskTime(curIndex);
                this.calculateAimFinishTime(curIndex);
                break;
            }
            case "absoluteduration": {
                String absLogical = (String)model.getValue("logical", curIndex);
                try {
                    if (absLogical == null || absLogical.isEmpty() || StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)absLogical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)absLogical)) {
                        this.calculatePlanEndTimeByAbusoluteDuration(curIndex);
                        break;
                    }
                    this.calculatePlanStartTimeByAbusoluteDuration(curIndex);
                }
                catch (Exception e1) {
                    Object oldValue = changeSet.getOldValue();
                    if (oldValue != null) {
                        model.setValue("absoluteduration", oldValue, curIndex);
                    } else {
                        model.beginInit();
                        model.setValue("absoluteduration", oldValue, curIndex);
                        model.endInit();
                        this.getView().updateView("absoluteduration", curIndex);
                    }
                    this.getView().showTipNotification(e1.getMessage());
                }
                break;
            }
            case "relativeduration": {
                this.calculatePlanStartTimeByPreTaskAndLogical(curIndex);
                break;
            }
            case "multicooperationperson": {
                this.checkResponsiblePerson("multicooperationperson", curIndex);
                break;
            }
            case "responsibleperson": {
                this.checkResponsiblePerson("responsibleperson", curIndex);
                break;
            }
            case "transactiontype": {
                int entryCurrentRowIndex = model.getEntryCurrentRowIndex("taskentity");
                Object trans = model.getValue("transactiontype", entryCurrentRowIndex);
                boolean deleteEntry = true;
                if (null != trans) {
                    DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
                    for (DynamicObject tx : transactionType) {
                        Long baseDataId = tx.getLong("fbasedataid_id");
                        DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                        if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                        deleteEntry = false;
                    }
                }
                if (deleteEntry) {
                    model.deleteEntryData("taskresultdocentry");
                }
                this.setTransactionEntryEnable(entryCurrentRowIndex);
                break;
            }
            case "relatedmastertask": {
                Object relatedmastertaskId = this.getModel().getValue("relatedmastertask_id");
                if (this.checkExistSamePlan()) {
                    this.getModel().setValue("relatedmastertask", changeSet.getOldValue());
                    return;
                }
                DynamicObject relatedmastertask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"majortype", (QFilter[])new QFilter[]{new QFilter("id", "=", relatedmastertaskId)});
                this.getModel().setValue("majortype", null);
                if (relatedmastertask != null) {
                    Object majortype = relatedmastertask.get("majortype");
                    if (majortype == null) {
                        majortype = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)MAJORPLANID)});
                    }
                    this.getModel().setValue("majortype", majortype);
                }
                model.setValue("billname", (Object)this.createSpecialPlanName());
                break;
            }
        }
    }

    @NotNull
    protected List<QFilter> getPreChangePlanFilters(IDataModel model) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        DynamicObject majorType = this.getModel().getDataEntity().getDynamicObject("majortype");
        DynamicObject project2 = (DynamicObject)model.getValue("project");
        QFilter filter1 = new QFilter("project", "=", project2.getPkValue());
        QFilter filter2 = new QFilter("majortype", "=", majorType != null ? majorType.getPkValue() : null);
        QFilter filter3 = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        DynamicObject relatedMasterTask = this.getModel().getDataEntity().getDynamicObject("relatedmastertask");
        QFilter preRelatedMasterTaskFilter = null;
        if (relatedMasterTask != null) {
            relatedMasterTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"prechangetask,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relatedMasterTask.getLong("id"))});
            if (relatedMasterTask != null) {
                DynamicObject sourceTask = relatedMasterTask.getDynamicObject("sourcetask");
                if (sourceTask != null) {
                    HashSet<Long> taskIdSet = new HashSet<Long>(16);
                    DynamicObjectCollection sameSourceTaskCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue())});
                    for (DynamicObject sameSourceTask : sameSourceTaskCol) {
                        taskIdSet.add(sameSourceTask.getLong("id"));
                    }
                    preRelatedMasterTaskFilter = new QFilter("relatedmastertask", "in", taskIdSet);
                } else {
                    preRelatedMasterTaskFilter = new QFilter("relatedmastertask", "=", relatedMasterTask.getPkValue());
                }
            }
        } else {
            preRelatedMasterTaskFilter = new QFilter("relatedmastertask", "=", (Object)0L);
        }
        qFilters.add(filter1);
        qFilters.add(filter2);
        qFilters.add(filter3);
        qFilters.add(preRelatedMasterTaskFilter);
        return qFilters;
    }

    protected boolean checkExistSamePlan() {
        DynamicObject masterPlanObj = (DynamicObject)this.getModel().getValue("masterplan");
        if (masterPlanObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long majorTypeId = this.getModel().getDataEntity().getLong("majortype_id");
        if (majorTypeId == 0L) {
            return false;
        }
        DynamicObject masterPlan = BusinessDataServiceHelper.loadSingle((Object)masterPlanObj.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        DynamicObject masterPreChangePlan = masterPlan.getDynamicObject("prechangeplan");
        QFilter majorTypeFilter = new QFilter("majortype", "=", (Object)majorTypeId);
        QFilter masterPlanFilter = null;
        if (masterPreChangePlan != null) {
            masterPlanFilter = new QFilter("masterplan", "=", masterPreChangePlan.getPkValue());
            String[] planStatusArr = new String[]{PlanEnum.CREATEING.getValue(), PlanEnum.CHECKING.getValue()};
            QFilter planStatusFilter = new QFilter("planstatus", "in", (Object)planStatusArr);
            DynamicObject relatedMasterTask = this.getModel().getDataEntity().getDynamicObject("relatedmastertask");
            QFilter preRelatedMasterTaskFilter = null;
            if (relatedMasterTask != null) {
                Long relatedMasterTaskId = relatedMasterTask.getLong("id");
                DynamicObject preRelatedMasterTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"prechangetask", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relatedMasterTaskId)});
                if (preRelatedMasterTask != null) {
                    preRelatedMasterTaskFilter = new QFilter("relatedmastertask", "=", preRelatedMasterTask.getPkValue());
                }
            }
            ArrayList<QFilter> unPublishedFilterList = new ArrayList<QFilter>(10);
            unPublishedFilterList.add(masterPlanFilter);
            unPublishedFilterList.add(majorTypeFilter);
            unPublishedFilterList.add(planStatusFilter);
            unPublishedFilterList.add(preRelatedMasterTaskFilter);
            this.modifyUnPublishedFilterList(unPublishedFilterList);
            DynamicObject specialObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"billname", (QFilter[])unPublishedFilterList.toArray(new QFilter[unPublishedFilterList.size()]));
            if (specialObj != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u65e7\u7248\u672c\u4e0b\u7684\u4e13\u9879\u8ba1\u5212\u201c%s\u201d\uff0c\u7136\u540e\u5728\u65b0\u7248\u672c\u4e0b\u521b\u5efa\u8be5\u4e13\u4e1a\u7c7b\u578b\u7684\u4e13\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_66", (String)"pccs-placs-formplugin", (Object[])new Object[0]), specialObj.getString("billname")));
                return true;
            }
        }
        masterPlanFilter = new QFilter("masterplan", "=", masterPlan.getPkValue());
        Long relatedMasterTaskId = (Long)this.getModel().getValue("relatedmastertask_id");
        QFilter relatedMasterTaskFilter = new QFilter("relatedmastertask", "=", (Object)relatedMasterTaskId);
        ArrayList<QFilter> oldPlanFilterList = new ArrayList<QFilter>(10);
        oldPlanFilterList.add(majorTypeFilter);
        oldPlanFilterList.add(masterPlanFilter);
        oldPlanFilterList.add(relatedMasterTaskFilter);
        this.modifyOldPlanFilterList(oldPlanFilterList);
        DynamicObject[] existedObj = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"version", (QFilter[])oldPlanFilterList.toArray(new QFilter[oldPlanFilterList.size()]));
        if (existedObj != null && existedObj.length == 1) {
            if (!StringUtils.equals((CharSequence)existedObj[0].getPkValue().toString(), (CharSequence)this.getModel().getDataEntity().getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u7684\u4e13\u9879\u7c7b\u578b\u8ba1\u5212\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"SpecialPlanEditPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if (existedObj != null && existedObj.length > 1) {
            String curPk = this.getModel().getDataEntity().getPkValue().toString();
            boolean isHasSelf = false;
            for (DynamicObject obj : existedObj) {
                if (!StringUtils.equals((CharSequence)obj.getPkValue().toString(), (CharSequence)curPk)) continue;
                isHasSelf = true;
            }
            if (!isHasSelf) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e3b\u9879\u8ba1\u5212\u4e0b\u7684\u4e13\u9879\u7c7b\u578b\u8ba1\u5212\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"SpecialPlanEditPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected void modifyOldPlanFilterList(List oldPlanFilterList) {
    }

    protected void modifyUnPublishedFilterList(List unPublishedFilterList) {
    }

    protected void calculateAimFinishTime(int curIndex) {
        Date aimFinishTime = (Date)this.getModel().getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", curIndex);
        if (aimFinishTime == null && planEndTime != null) {
            this.getModel().setValue("aimfinishtime", (Object)planEndTime, curIndex);
        }
    }

    protected void ctrlV2Enum(int row) {
        String logical = (String)this.getModel().getValue("logical", row);
        if (logical == null) {
            return;
        }
        switch (logical.trim()) {
            case "\u5f00\u59cb-\u5b8c\u6210": {
                this.getModel().setValue("logical", (Object)LogicalEnum.START_FINISH.getValue(), row);
                break;
            }
            case "\u5b8c\u6210-\u5b8c\u6210": {
                this.getModel().setValue("logical", (Object)LogicalEnum.FINISH_FINISH.getValue(), row);
                break;
            }
            case "\u5f00\u59cb-\u5f00\u59cb": {
                this.getModel().setValue("logical", (Object)LogicalEnum.START_START.getValue(), row);
                break;
            }
            case "\u5b8c\u6210-\u5f00\u59cb": {
                this.getModel().setValue("logical", (Object)LogicalEnum.FINISH_START.getValue(), row);
            }
        }
    }

    protected void calculateOtherTaskTime(int curIndex) {
        DynamicObject curTask = this.getModel().getEntryRowEntity("taskentity", curIndex);
        DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentity");
        IDataModel model = this.getModel();
        Object curPk = curTask.getPkValue();
        if (curPk == null) {
            return;
        }
        Date preTaskPlanStartTime = curTask.getDate("planstarttime");
        Date preTaskPlanEndTime = curTask.getDate("planendtime");
        for (int rowIndex = 0; rowIndex < tasks.size(); ++rowIndex) {
            Date planEndTime;
            Date planStartTime;
            String logical;
            DynamicObject task = (DynamicObject)tasks.get(rowIndex);
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask == null || !curPk.equals(preTask.getPkValue()) || (logical = (String)model.getValue("logical", rowIndex)) == null) continue;
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeDuration = (BigDecimal)model.getValue("relativeduration", rowIndex);
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                if (preTaskPlanStartTime == null) continue;
                if (project == null) {
                    planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                    continue;
                }
                planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                if (preTaskPlanEndTime == null) continue;
                if (project == null) {
                    planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                    continue;
                }
                planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                if (preTaskPlanStartTime == null) continue;
                if (project == null) {
                    planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                    model.setValue("planendtime", (Object)planEndTime, rowIndex);
                    continue;
                }
                planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
                continue;
            }
            if (!StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) || preTaskPlanEndTime == null) continue;
            if (project == null) {
                planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
                continue;
            }
            planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
            model.setValue("planendtime", (Object)planEndTime, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("showMasterPlanListCallBack".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.showMasterPlanList();
            } else {
                DynamicObject masterPlan = (DynamicObject)this.getModel().getValue("masterplan");
                this.getModel().setValue("masterplan", (Object)masterPlan);
                this.getView().updateView("masterplan");
            }
        } else if (callBackId.equals(DELETE_TASK_CONFIRM)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
                int[] selRows = grid.getSelectRows();
                HashSet<Integer> selectRows = new HashSet<Integer>(10);
                for (int row : selRows) {
                    selectRows.add(row);
                    this.selectChildren(row, selectRows);
                }
                selRows = selectRows.stream().mapToInt(Integer::valueOf).toArray();
                this.deleteTaskCheck(selRows);
                HashSet<String> deletepks = new HashSet<String>(10);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRow);
                    String pkvalue = entry.getPkValue().toString();
                    deletepks.add(pkvalue);
                }
                this.deletePreTask(deletepks);
                this.getModel().deleteEntryRows("taskentity", selRows);
                this.getModel().updateCache();
                this.rebuildTreeStructure();
                this.getView().updateView("taskentity");
            }
        } else if ("importtask".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.importTaskOperation();
            }
        } else if (NEW_TASK_CONFIRM.equalsIgnoreCase(callBackId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
            int[] selRows = grid.getSelectRows();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRow);
                    String pidPkValue = entry.getString("pid");
                    deletepks.add(pidPkValue);
                }
                this.deletePreTask(deletepks);
            } else {
                this.getModel().deleteEntryRows("taskentity", selRows);
            }
            this.getModel().updateCache();
            this.rebuildTreeStructure();
            this.getView().updateView("taskentity");
        } else if (StringUtils.equals((CharSequence)"showSelectRelatedMasterTaskCallBack", (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().setValue("relatedmastertask", null);
                this.getView().updateView("relatedmastertask");
                DynamicObject masterPlan = this.getModel().getDataEntity().getDynamicObject("masterplan");
                this.showSelectRelatedMasterTaskList(masterPlan);
            } else {
                DynamicObject relatedMasterTask = (DynamicObject)this.getModel().getValue("relatedmastertask");
                this.getModel().setValue("relatedmastertask", (Object)relatedMasterTask);
                this.getView().updateView("relatedmastertask");
            }
            this.getPageCache().remove(SHOWRELATEDTASKCLICK_CACHE);
        }
    }

    protected void showSelectRelatedMasterTaskList(DynamicObject masterPlan) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("masterPlanId", (Object)masterPlan.getString("id"));
        showParameter.setCustomParam("specialPlanId", (Object)this.getModel().getDataEntity().getString("id"));
        showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskentryf7"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"SpecialPlanEditPlugin_37", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(this.getCloseCallBackPluginName("thisplugin"), "relatedmastertask"));
        this.getView().showForm(showParameter);
    }

    protected void importTaskOperation() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog"));
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog")));
        this.getView().showForm(importExcelFormParameter);
    }

    private void selectChildren(int row, Set<Integer> selectRows) {
        int count = this.getModel().getEntryRowCount("taskentity");
        String pid = this.getModel().getEntryRowEntity("taskentity", row).getPkValue().toString();
        for (int index = row + 1; index < count; ++index) {
            DynamicObject task = this.getModel().getEntryRowEntity("taskentity", index);
            if (!task.getString("pid").equals(pid)) continue;
            selectRows.add(index);
            this.selectChildren(index, selectRows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("switchMasterPlanCallBack".equalsIgnoreCase(key)) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
                DynamicObject masterPlan = (DynamicObject)this.getModel().getValue("masterplan");
                this.getModel().setValue("masterplan", (Object)masterPlan);
                this.getView().updateView("masterplan");
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
            this.switchMasterPlan(listSelectedRow.getPrimaryKeyValue());
        } else if ("batchmodify".equalsIgnoreCase(key)) {
            Map dataMap = (Map)closedCallBackEvent.getReturnData();
            MultiCooperationPersonUtils.dealBatchModifyPersons((IFormView)this.getView(), (Map)dataMap);
        } else if ("showTaskF7".equalsIgnoreCase(key)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null) {
                int curRow = this.getModel().getEntryCurrentRowIndex("taskentity");
                this.getModel().setValue("pretask", rows.get(0).getPrimaryKeyValue(), curRow);
            }
        } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog").equalsIgnoreCase(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (StringUtils.isNotBlank((Object)returnData)) {
                int i;
                DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
                boolean showResultDoc = false;
                for (DynamicObject task : tasks) {
                    DynamicObjectCollection transactionType = task.getDynamicObjectCollection("transactiontype");
                    if (null != transactionType) {
                        for (DynamicObject tx : transactionType) {
                            Long baseDataId = tx.getLong("fbasedataid_id");
                            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                            if (transactionType.size() >= 2 || Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number")) || task.getDynamicObjectCollection("taskresultdocentry") == null || task.getDynamicObjectCollection("taskresultdocentry").size() <= 0) continue;
                            showResultDoc = true;
                        }
                        continue;
                    }
                    if (transactionType != null || task.getDynamicObjectCollection("taskresultdocentry") == null) continue;
                    showResultDoc = true;
                }
                if (showResultDoc) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u679c\u201d\u7684\u4efb\u52a1\uff0c\u624d\u80fd\u4e0a\u4f20\u201c\u6210\u679c\u6587\u6863\u201d\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"SpecialPlanEditPlugin_67", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                DealWithEntryDataUtils.updateEntryLevelData((DynamicObjectCollection)tasks);
                this.dealErrorBuilding(returnData);
                this.getModel().deleteEntryData("taskentity");
                this.getModel().updateCache();
                this.getModel().updateEntryCache(tasks);
                this.getView().updateView("taskentity");
                this.getView().invokeOperation("save");
                DynamicObject relatedmastertask = this.getView().getModel().getDataEntity().getDynamicObject("relatedmastertask");
                String relatedmastertaskName = null;
                if (relatedmastertask != null) {
                    relatedmastertaskName = relatedmastertask.getString("name");
                }
                DynamicObject specialtype = this.getModel().getDataEntity().getDynamicObject("majortype");
                for (i = 0; i < tasks.size(); ++i) {
                    this.getView().getModel().setValue("specialtype", (Object)specialtype, i);
                    for (DynamicObject task1 : tasks) {
                        if (((DynamicObject)tasks.get(i)).get("pretask") == null || !((DynamicObject)tasks.get(i)).get("pretask").equals(task1.getString("name")) || !((DynamicObject)tasks.get(i)).getBoolean("isleaf")) continue;
                        this.getView().getModel().setValue("pretask", (Object)task1, i);
                    }
                    if (((DynamicObject)tasks.get(i)).get("pretask") != null && (((DynamicObject)tasks.get(i)).getBoolean("isleaf") || ((DynamicObject)tasks.get(i)).getString("name").equals(relatedmastertaskName))) continue;
                    this.getModel().setValue("logical", null, i);
                    this.getModel().setValue("relativeduration", null, i);
                }
                for (i = 0; i < tasks.size(); ++i) {
                    if (((DynamicObject)tasks.get(i)).get("pretask") == null) continue;
                    this.calculatePlanStartTimeByPreTaskAndLogical(i);
                }
                TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
                entryTree.setCollapse(false);
            }
        } else if (StringUtils.equals((CharSequence)"relatedmastertask", (CharSequence)key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                this.getModel().setValue("relatedmastertask", returnData);
            }
            this.getPageCache().remove(SHOWRELATEDTASKCLICK_CACHE);
        }
    }

    protected void dealErrorBuilding(Object returnData) {
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName = arg.getProperty().getName();
        ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
        if (propName.equals("masterplan")) {
            Object masterPlan = this.getModel().getValue("masterplan");
            if (masterPlan != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SpecialPlanEditPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showMasterPlanListCallBack"));
            } else {
                this.showMasterPlanList();
            }
            arg.setCancel(true);
        } else if ("pretask".equals(propName)) {
            this.getView().invokeOperation("save");
            this.getModel().updateCache();
            if (!arg.getSourceMethod().equals("click")) {
                this.settingPreTaskFilter(arg);
                return;
            }
            this.showTaskF7(arg);
        } else if (StringUtils.equals((CharSequence)"responsibledept", (CharSequence)propName)) {
            int entryCurrentRowIndex;
            DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("taskentity");
            DynamicObject taskRow = (DynamicObject)orgEntryEntity.get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity"));
            DynamicObject responsibleperson = taskRow.getDynamicObject("responsibleperson");
            if (responsibleperson != null) {
                List deptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsibleperson.getPkValue().toString()), (boolean)false);
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)deptList));
            }
        } else if (StringUtils.equals((CharSequence)"multicooperationdept", (CharSequence)propName)) {
            int entryCurrentRowIndex;
            DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("taskentity");
            DynamicObject taskRow = (DynamicObject)orgEntryEntity.get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity"));
            DynamicObjectCollection cooperationpersons = taskRow.getDynamicObjectCollection("multicooperationperson");
            if (cooperationpersons != null && cooperationpersons.size() > 0) {
                ArrayList deptList = new ArrayList();
                cooperationpersons.stream().map(o -> deptList.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", deptList));
            }
        } else if (StringUtils.equals((CharSequence)"relatedmastertask", (CharSequence)propName)) {
            DynamicObject masterPlan = this.getModel().getDataEntity().getDynamicObject("masterplan");
            if (masterPlan == null) {
                arg.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            String wasClick = this.getPageCache().get(SHOWRELATEDTASKCLICK_CACHE);
            if (wasClick != null && StringUtils.equals((CharSequence)"true", (CharSequence)wasClick)) {
                arg.setCancel(true);
                return;
            }
            Object majorType = this.getModel().getValue("majortype");
            if (majorType != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e13\u9879\u8ba1\u5212\u4efb\u52a1\u5df2\u66f4\u65b0\uff0c\u9700\u8981\u91cd\u65b0\u66f4\u65b0\u76f8\u5173\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SpecialPlanEditPlugin_68", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showSelectRelatedMasterTaskCallBack"));
            } else {
                this.showSelectRelatedMasterTaskList(masterPlan);
            }
            this.getPageCache().put(SHOWRELATEDTASKCLICK_CACHE, "true");
            arg.setCancel(true);
        } else if (StringUtils.equals((CharSequence)"specialtype", (CharSequence)propName)) {
            this.setSpecialTypeFilter(param);
        }
    }

    protected void setSpecialTypeFilter(ListShowParameter param) {
        List qFilters = param.getListFilterParameter().getQFilters();
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        Object projectKindId = projectObj.get("group_id");
        QFilter kindFilter = new QFilter("group", "=", projectKindId);
        QFilter specialFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        qFilters.add(specialFilter);
        qFilters.add(kindFilter);
    }

    protected String getCloseCallBackPluginName(String closeCallBackAction) {
        String pluginName = "";
        if (StringUtils.equals((CharSequence)"thisplugin", (CharSequence)closeCallBackAction)) {
            pluginName = this.getPluginName();
        }
        return pluginName;
    }

    private void showTaskF7(BeforeF7SelectEvent arg) {
        arg.setCancel(true);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)(this.getAppId() + "_" + "task"), (boolean)false, (int)2);
        this.settingPreTaskFilter(parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showTaskF7"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretask");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationPerson = (MulBasedataEdit)this.getControl("multicooperationperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cooperationDept = (MulBasedataEdit)this.getControl("multicooperationdept");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskType = (BasedataEdit)this.getControl("tasktype");
        taskType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit masterPlan = (BasedataEdit)this.getControl("masterplan");
        masterPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        masterPlan.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)this.viewDetail(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), beforeF7ViewDetailEvent.getPkId()));
        });
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("taskentity");
        taskEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit relatedmastertask = (BasedataEdit)this.getControl("relatedmastertask");
        if (relatedmastertask != null) {
            relatedmastertask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit specialTypeEdit = (BasedataEdit)this.getControl("specialtype");
        specialTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.levelLableAddListener(6, 2);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("taskentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected int getOriginLevel(int level) {
        while (level > 6) {
            level -= 6;
        }
        return level;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String treeEntityKey = "";
        if (key.contains(LEVEL)) {
            int level = Integer.parseInt(key.split("_")[1]);
            if (level <= 6 && level > 0) {
                treeEntityKey = "taskentity";
            }
            if (level <= 12 && level > 6) {
                treeEntityKey = "treeentryentity";
            }
            Tab tab = (Tab)this.getView().getControl("tabap");
            String currentTab = tab.getCurrentTab();
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeEntityKey);
            level = this.getOriginLevel(level);
            Map all = this.getPageCache().getAll();
            all.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("@taskId")).forEach(entry -> this.taskLevelMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("@taskId")), Integer.valueOf((String)entry.getValue())));
            if (StringUtils.equals((CharSequence)"tabpageap", (CharSequence)currentTab)) {
                TreeEntryGridHelper.expandNodes(treeEntryGrid, "id", level, this.taskLevelMap);
            }
            if (StringUtils.equals((CharSequence)"adjusttab", (CharSequence)currentTab)) {
                TreeEntryGridHelper.expandNodes(treeEntryGrid, "task", level, this.taskLevelMap);
            }
        }
    }

    protected BillShowParameter viewDetail(String formBillId, Object pkId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formBillId);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(bill.getPkValue());
        showParameter.setFormId(formBillId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    protected void setEntryTaskBelongTypeAndTaskSource() {
        DynamicObjectCollection taskEntrys = this.getModel().getEntryEntity("taskentity");
        for (int i = 0; i < taskEntrys.size(); ++i) {
            DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
            this.getModel().setValue("belongplantype", majorType != null ? majorType.getPkValue() : null, i);
            this.getModel().setValue("tasksource", majorType != null ? majorType.getPkValue() : null, i);
            this.getModel().setValue("specialtype", majorType != null ? majorType.getPkValue() : null, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selectRows = grid.getSelectRows();
        switch (key) {
            case "save": {
                this.setEntryTaskBelongTypeAndTaskSource();
                break;
            }
            case "newtaskentry": {
                Object masterPlan;
                Object relatedMasterTask = this.getModel().getValue("relatedmastertask");
                if (relatedMasterTask != null) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u6709\u201c\u5173\u8054\u4e3b\u9879\u8ba1\u5212\u4efb\u52a1\u201d\u53ea\u80fd\u201c\u65b0\u589e\u4e0b\u7ea7\u201d\u3002", (String)"SpecialPlanEditPlugin_38", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if ((masterPlan = this.getModel().getValue("masterplan")) != null) break;
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deletetaskentry": {
                this.deleteTaskEntry(args);
                break;
            }
            case "upgrade": {
                this.upgradeOperation(selectRows);
                grid.setCollapse(false);
                this.rebuildTreeStructure();
                break;
            }
            case "downgrade": {
                this.downgradeOperation(selectRows);
                grid.setCollapse(false);
                this.rebuildTreeStructure();
                break;
            }
            case "inserttaskentry": {
                this.checkCanInsertTaskEntry(selectRows, args);
                this.verifyTaskIsPre(args);
                break;
            }
            case "submit": {
                this.setEntryTaskBelongTypeAndTaskSource();
                boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                if (isFromDb) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"SpecialPlanEditPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void deleteTaskEntry(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length <= 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"SpecialPlanEditPlugin_69", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasSub = false;
        for (int i = 0; i < selRows.length; ++i) {
            boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", selRows[i]);
            if (isLeaf) continue;
            hasSub = true;
            break;
        }
        if (!hasSub) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"SpecialPlanEditPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u4efb\u52a1\u7684\u540c\u65f6\u5c06\u5220\u9664\u5b50\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SpecialPlanEditPlugin_70", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        switch (key) {
            case "newtaskentry": {
                this.settingTreeStructureAfterNew();
                this.rebuildTreeStructure();
                break;
            }
            case "inserttaskentry": {
                this.settingTreeStructureAfterNew();
                this.rebuildTreeStructure();
                break;
            }
            case "viewtaskdetail": {
                this.viewTaskDetailOperation(grid);
                break;
            }
            case "batchmodify": {
                this.batchModifyOperation(grid);
                this.rebuildTreeStructure();
                break;
            }
            case "upgrade": {
                this.rebuildTreeStructure();
                this.getView().updateView("taskentity");
                break;
            }
            case "exportmodel": {
                PlanTaskImpAndExpUtil util = this.getUtil();
                util.exportCommonModel(this.getView(), true);
                break;
            }
            case "proimptask": {
                break;
            }
            case "importtask": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"SpecialPlanEditPlugin_9", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                Object masterPlan = this.getModel().getValue("masterplan");
                if (masterPlan == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u4efb\u52a1\u6e05\u5355\u540e\uff0c\u5c06\u66f4\u65b0\u73b0\u6709\u4e13\u9879\u4efb\u52a1\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SpecialPlanEditPlugin_71", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importtask"));
                break;
            }
            case "audit": {
                this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
                this.getView().updateView("assigner");
                break;
            }
        }
    }

    protected PlanTaskImpAndExpUtil getUtil() {
        return new PlanTaskImpAndExpUtil(this.getView());
    }

    protected void checkResponsiblePerson(String operateKey, int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        DynamicObject responsiblePerson = row.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperationPerson = row.getDynamicObjectCollection("multicooperationperson");
        MultiCooperationPersonUtils.hostAndCoMustBeDiffer((DynamicObject)responsiblePerson, (DynamicObjectCollection)cooperationPerson);
        if (responsiblePerson != null && "responsibleperson".equalsIgnoreCase(operateKey)) {
            long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePerson.getPkValue().toString()));
            this.getModel().setValue("responsibledept", (Object)orgId, rowIndex);
        } else if (cooperationPerson != null && "multicooperationperson".equalsIgnoreCase(operateKey)) {
            MultiCooperationPersonUtils.writeCodeptsByCoPersons((DynamicObjectCollection)cooperationPerson, (IDataModel)this.getModel(), (int)rowIndex);
        }
    }

    protected void batchModifyOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"SpecialPlanEditPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Integer> relationIndexList = new ArrayList<Integer>(10);
        for (int i = 0; i < selRows.length; ++i) {
            Object value = this.getModel().getValue("relationtask", selRows[i]);
            if (value == null) continue;
            relationIndexList.add(i + 1);
        }
        if (!relationIndexList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u5c5e\u4e8e\u5f15\u5165\u7684\u5185\u5bb9\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SpecialPlanEditPlugin_45", (String)"pccs-placs-formplugin", (Object[])new Object[0]), ((Object)relationIndexList).toString()));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"batchmodify"));
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setAppId(this.getAppId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchmodify"));
        this.getView().showForm(parameter);
    }

    protected void calculatePlanStartTimeByPreTaskAndLogical(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject preTask = (DynamicObject)this.getModel().getValue("pretask", rowIndex);
        if (preTask == null) {
            return;
        }
        String logical = (String)model.getValue("logical", rowIndex);
        if (logical == null) {
            return;
        }
        DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentity");
        for (int row = 0; row < tasks.size(); ++row) {
            DynamicObject task = (DynamicObject)tasks.get(row);
            if (!task.getPkValue().equals(preTask.getPkValue())) continue;
            preTask = task;
            break;
        }
        DynamicObject project = (DynamicObject)model.getValue("project");
        BigDecimal relativeDuration = (BigDecimal)model.getValue("relativeduration");
        if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime == null) {
                return;
            }
            if (project == null) {
                Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            } else {
                Date planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                if (this.checkMainPlanTaskTime(rowIndex, planStartTime)) {
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
            Date preTaskPlanEndTime = preTask.getDate("planendtime");
            if (preTaskPlanEndTime == null) {
                return;
            }
            if (project == null) {
                Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planstarttime", (Object)planStartTime, rowIndex);
            } else {
                Date planStartTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                if (this.checkMainPlanTaskTime(rowIndex, planStartTime)) {
                    model.setValue("planstarttime", (Object)planStartTime, rowIndex);
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
            Date preTaskPlanStartTime = preTask.getDate("planstarttime");
            if (preTaskPlanStartTime == null) {
                return;
            }
            if (project == null) {
                Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            } else {
                Date planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanStartTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                if (this.checkMainPlanTaskTime(rowIndex, planEndTime)) {
                    model.setValue("planendtime", (Object)planEndTime, rowIndex);
                }
            }
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical)) {
            Date preTaskPlanEndTime = preTask.getDate("planendtime");
            if (preTaskPlanEndTime == null) {
                return;
            }
            if (project == null) {
                Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeDuration.intValue());
                model.setValue("planendtime", (Object)planEndTime, rowIndex);
            } else {
                Date planEndTime = TaskUtil.getDateAfterAddRelativeDays((Object)project.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration.intValue(), (String)this.getAppId());
                if (this.checkMainPlanTaskTime(rowIndex, planEndTime)) {
                    model.setValue("planendtime", (Object)planEndTime, rowIndex);
                }
            }
        }
    }

    protected boolean checkMainPlanTaskTime(int curIndex, Date planStartTime) {
        if (planStartTime == null) {
            return false;
        }
        String appId = this.getAppId();
        DynamicObject task = this.getModel().getEntryRowEntity("taskentity", curIndex);
        Object taskId = task.getPkValue();
        if (!QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (Object)taskId)) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
        if ((task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"majortype")).get("majortype") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e13\u4e1a\u7c7b\u578b\u201d\u3002", (String)"SpecialPlanEditPlugin_72", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        DynamicObject belongPlanType = BusinessDataServiceHelper.loadSingle((Object)task.getDynamicObject("majortype").getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"), (String)"plantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject relationTask;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (relationTask = (sourceParentTask = TaskUtil.getNearestMainPlanParentTask((DynamicObject)task, (String)appId)).getDynamicObject("relationtask")) != null) {
                Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                if (sourceTaskPlanStartTime != null && planStartTime.before(sourceTaskPlanStartTime)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_73", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
                if (sourceTaskPlanEndTime != null && planStartTime.after(sourceTaskPlanEndTime)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_74", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                }
            }
        }
        return true;
    }

    protected void settingPreTaskFilter(BeforeF7SelectEvent arg) {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        int selectIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        DynamicObject selectEntry = this.getModel().getEntryRowEntity("taskentity", selectIndex);
        Set taskIds = taskEntries.stream().filter(entry -> !StringUtils.isEmpty((CharSequence)entry.getString("name")) && !entry.getPkValue().equals(selectEntry.getPkValue()) && entry.getBoolean("isleaf") && (entry.getDynamicObject("pretask") == null || entry.getDynamicObject("pretask") != null && !entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue()))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet<Object> excludeTaskIds = new HashSet<Object>();
        this.getPreTaskLinkSet(taskEntries, selectEntry, excludeTaskIds);
        this.checkExistChildren(excludeTaskIds);
        taskIds.removeAll(excludeTaskIds);
        QFilter filter = new QFilter("id", "in", taskIds);
        arg.getCustomQFilters().add(filter);
    }

    protected void settingPreTaskFilter(ListShowParameter param) {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        int selectIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        DynamicObject selectEntry = this.getModel().getEntryRowEntity("taskentity", selectIndex);
        Set taskIds = taskEntries.stream().filter(entry -> !StringUtils.isEmpty((CharSequence)entry.getString("name")) && !entry.getPkValue().equals(selectEntry.getPkValue()) && entry.getBoolean("isleaf") && (entry.getDynamicObject("pretask") == null || entry.getDynamicObject("pretask") != null && !entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue()))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet<Object> excludeTaskIds = new HashSet<Object>();
        this.getPreTaskLinkSet(taskEntries, selectEntry, excludeTaskIds);
        this.checkExistChildren(excludeTaskIds);
        taskIds.removeAll(excludeTaskIds);
        QFilter filter = new QFilter("id", "in", taskIds);
        ListFilterParameter parameter = param.getListFilterParameter();
        parameter.setFilter(filter);
        parameter.setOrderBy("taskseq");
    }

    protected void getPreTaskLinkSet(DynamicObjectCollection taskEntries, DynamicObject selectEntry, Set<Object> taskSet) {
        long count = taskEntries.stream().filter(entry -> entry.getDynamicObject("pretask") != null && entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue())).count();
        if (count == 0L) {
            return;
        }
        for (DynamicObject task : taskEntries) {
            DynamicObject preTask;
            if (selectEntry.getPkValue().equals(task.getPkValue()) || (preTask = task.getDynamicObject("pretask")) == null || !selectEntry.getPkValue().equals(preTask.getPkValue())) continue;
            taskSet.add(task.getPkValue());
            this.getPreTaskLinkSet(taskEntries, task, taskSet);
        }
    }

    protected void downgradeOperation(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u964d\u7ea7\u7684\u884c\u3002", (String)"SpecialPlanEditPlugin_75", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u4e0d\u80fd\u964d\u7ea7\u3002", (String)"SpecialPlanEditPlugin_76", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)this.getAppId());
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", curIndex);
        if (row.getDate("planstarttime") != null) {
            this.settingParentPlanTime("planstarttime", curIndex);
        }
        if (row.getDate("planendtime") != null) {
            this.settingParentPlanTime("planendtime", curIndex);
        }
        if (row.getDate("aimfinishtime") != null) {
            this.settingParentPlanTime("aimfinishtime", curIndex);
        }
    }

    protected void upgradeOperation(int[] selRows) {
        Object value;
        DynamicObject relateMasterTask;
        int parentIndex;
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u884c\u3002", (String)"SpecialPlanEditPlugin_77", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"SpecialPlanEditPlugin_78", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        String parentPk = task.getString("pid");
        for (int index = parentIndex = curIndex - 1; index >= 0; --index) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            if (!StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)parentPk)) continue;
            parentIndex = index;
            break;
        }
        if ((relateMasterTask = this.getModel().getDataEntity().getDynamicObject("relatedmastertask")) != null && parentIndex >= 0 && (value = this.getModel().getValue("relationtask", parentIndex)) != null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4e0a\u7ea7\u8282\u70b9\u5df2\u5173\u8054\u4e3b\u9879\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"SpecialPlanEditPlugin_79", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)this.getAppId());
        this.settingTimeByChildren(parentIndex);
    }

    protected void viewTaskDetailOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"SpecialPlanEditPlugin_80", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SpecialPlanEditPlugin_81", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (task != null) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"SpecialPlanEditPlugin_63", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            DynamicObject relationTask = task.getDynamicObject("relationtask");
            if (relationTask == null) {
                paramMap.put("pkId", task.getPkValue().toString());
            } else {
                paramMap.put("pkId", relationTask.getPkValue().toString());
            }
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void convertMasterEntryToSpecialEntry(DynamicObjectCollection masterTaskEntries) {
        if (masterTaskEntries == null || masterTaskEntries.isEmpty()) {
            return;
        }
        Object[] pks = masterTaskEntries.stream().map(DataEntityBase::getPkValue).toArray();
        if (pks.length == 0) {
            return;
        }
        Set<Object> masterTaskIdSet = masterTaskEntries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObject[] tasksFromMasterPlan = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        HashMap<Object, Object> refMap = new HashMap<Object, Object>(16);
        this.fillTaskEntryFromMasterPlan(taskEntries, tasksFromMasterPlan, refMap, masterTaskIdSet);
        for (DynamicObject taskEntry : taskEntries) {
            Object pid = taskEntry.get("pid");
            if (pid == null || !refMap.containsKey(pid)) continue;
            taskEntry.set("pid", refMap.get(pid));
        }
        DealWithEntryDataUtils.updateEntryLevelData((DynamicObjectCollection)taskEntries);
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView("taskentity");
    }

    protected void settingTaskEntryData(DynamicObject majorTypeF7) {
        DynamicObject relatedMasterTask = this.getModel().getDataEntity().getDynamicObject("relatedmastertask");
        DynamicObject planF7 = (DynamicObject)this.getModel().getValue("masterplan");
        if (planF7 == null) {
            return;
        }
        boolean isAdjust = this.isAdjust(null);
        DynamicObject preChangePlan = (DynamicObject)this.getModel().getValue("prechangeplan");
        if (isAdjust || preChangePlan == null) {
            DynamicObject materPlan = BusinessDataServiceHelper.loadSingle((Object)planF7.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
            DynamicObjectCollection taskEntries = materPlan.getDynamicObjectCollection("taskentity");
            if (taskEntries == null || taskEntries.isEmpty()) {
                return;
            }
            DynamicObjectCollection masterTaskEntries = new DynamicObjectCollection();
            if (relatedMasterTask != null) {
                for (DynamicObject task : taskEntries) {
                    if (!StringUtils.equals((CharSequence)task.getPkValue().toString(), (CharSequence)relatedMasterTask.getPkValue().toString())) continue;
                    masterTaskEntries.add((Object)task);
                    break;
                }
            } else if (majorTypeF7 != null) {
                for (DynamicObject task : taskEntries) {
                    DynamicObject major = task.getDynamicObject("specialtype");
                    if (major == null) continue;
                    task = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "=", task.getPkValue())});
                    DynamicObject sourceTask = task.getDynamicObject("sourcetask");
                    HashSet<Long> taskIdSet = new HashSet<Long>(16);
                    if (sourceTask != null) {
                        DynamicObjectCollection sameSourceTaskCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue())});
                        for (DynamicObject sameSourceTask : sameSourceTaskCol) {
                            taskIdSet.add(sameSourceTask.getLong("id"));
                        }
                    }
                    taskIdSet.add(task.getLong("id"));
                    DynamicObjectCollection specialPlanCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"), (String)"relatedmastertask", (QFilter[])new QFilter[]{new QFilter("relatedmastertask", "in", taskIdSet)});
                    if (!specialPlanCol.isEmpty() || !major.getPkValue().toString().equals(majorTypeF7.getPkValue().toString())) continue;
                    masterTaskEntries.add((Object)task);
                }
            }
            this.convertMasterEntryToSpecialEntry(masterTaskEntries);
        } else {
            DynamicObject specPlan = BusinessDataServiceHelper.loadSingle((Object)preChangePlan.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"specialplan"));
            DynamicObjectCollection taskEntries = specPlan.getDynamicObjectCollection("taskentity");
            DynamicObjectCollection specTaskEntries = new DynamicObjectCollection();
            if (taskEntries != null && !taskEntries.isEmpty()) {
                for (DynamicObject task : taskEntries) {
                    specTaskEntries.add((Object)task);
                }
            }
            DynamicObjectCollection masterTaskEntries = new DynamicObjectCollection();
            if (relatedMasterTask == null) {
                masterTaskEntries = this.getMasterPanEntry(majorTypeF7, planF7, specPlan, specTaskEntries);
            }
            this.convertToSpecialEntry(specTaskEntries, masterTaskEntries);
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    protected DynamicObjectCollection getMasterPanEntry(DynamicObject majorTypeF7, DynamicObject planF7, DynamicObject specPlan, DynamicObjectCollection specTaskEntries) {
        DynamicObjectCollection masterTaskEntries;
        block4: {
            DynamicObject masterPlan;
            block3: {
                masterTaskEntries = new DynamicObjectCollection();
                masterPlan = BusinessDataServiceHelper.loadSingle((Object)planF7.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
                BigDecimal speVersion = specPlan.getBigDecimal("version");
                BigDecimal masterVersion = masterPlan.getBigDecimal("version");
                if (masterVersion.intValue() - speVersion.intValue() > 1) break block3;
                DynamicObjectCollection taskEntries = masterPlan.getDynamicObjectCollection("taskentity");
                if (taskEntries == null || taskEntries.isEmpty()) break block4;
                for (DynamicObject task : taskEntries) {
                    DynamicObject major = task.getDynamicObject("specialtype");
                    if (major == null || task.get("prechangetask") != null || !major.getPkValue().toString().equals(majorTypeF7.getPkValue().toString())) continue;
                    masterTaskEntries.add((Object)task);
                }
                break block4;
            }
            Set<Object> excludeTaskSet = this.getExcludeTask(majorTypeF7, specPlan, specTaskEntries);
            DynamicObjectCollection taskEntries = masterPlan.getDynamicObjectCollection("taskentity");
            if (taskEntries != null && !taskEntries.isEmpty()) {
                for (DynamicObject task : taskEntries) {
                    DynamicObject major = task.getDynamicObject("specialtype");
                    if (major == null || !major.getPkValue().toString().equals(majorTypeF7.getPkValue().toString()) || excludeTaskSet.contains(task.getPkValue())) continue;
                    masterTaskEntries.add((Object)task);
                }
            }
        }
        return masterTaskEntries;
    }

    protected Set<Object> getExcludeTask(DynamicObject majorTypeF7, DynamicObject oldSpecPlan, DynamicObjectCollection specTaskEntries) {
        DynamicObject[] latestTasks;
        HashSet<Object> oldRelateTaskIdSet = new HashSet<Object>(specTaskEntries.size());
        for (DynamicObject specTask : specTaskEntries) {
            DynamicObject relateTask = specTask.getDynamicObject("relationtask");
            if (relateTask == null) continue;
            oldRelateTaskIdSet.add(relateTask.getPkValue());
        }
        DynamicObject oldMasterPlan = oldSpecPlan.getDynamicObject("masterplan");
        oldMasterPlan = BusinessDataServiceHelper.loadSingle((Object)oldMasterPlan.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        DynamicObjectCollection taskEntries = oldMasterPlan.getDynamicObjectCollection("taskentity");
        HashSet<Object> deleteTaskFromSpec = new HashSet<Object>();
        if (taskEntries != null && !taskEntries.isEmpty()) {
            for (DynamicObject task : taskEntries) {
                DynamicObject major = task.getDynamicObject("specialtype");
                if (major == null || !major.getPkValue().toString().equals(majorTypeF7.getPkValue().toString()) || oldRelateTaskIdSet.contains(task.getPkValue())) continue;
                deleteTaskFromSpec.add(task.getPkValue());
            }
        }
        oldRelateTaskIdSet.addAll(deleteTaskFromSpec);
        HashSet<Object> sourceTaskSet = new HashSet<Object>(10);
        HashSet<Object> excludeTaskSet = new HashSet<Object>(10);
        if (!oldRelateTaskIdSet.isEmpty()) {
            DynamicObject[] oldTasks;
            for (DynamicObject oldTask : oldTasks = BusinessDataServiceHelper.load((Object[])oldRelateTaskIdSet.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"))) {
                DynamicObject sourceTask = oldTask.getDynamicObject("sourcetask");
                sourceTaskSet.add(sourceTask.getPkValue());
            }
        }
        QFilter filter = new QFilter("sourcetask", "in", sourceTaskSet);
        filter.and(new QFilter("islatest", "=", (Object)EnableEnum.ENABLE.getValue()));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
        for (DynamicObject latestTask : latestTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter})) {
            excludeTaskSet.add(latestTask.getPkValue());
        }
        return excludeTaskSet;
    }

    protected void convertToSpecialEntry(DynamicObjectCollection specTaskEntries, DynamicObjectCollection masterTaskEntries) {
        if ((specTaskEntries == null || specTaskEntries.isEmpty()) && (masterTaskEntries == null || masterTaskEntries.isEmpty())) {
            return;
        }
        Object[] specPks = new Object[]{};
        HashSet<Object> specTaskIdSet = new HashSet(0);
        if (specTaskEntries != null && !specTaskEntries.isEmpty()) {
            specPks = specTaskEntries.stream().map(DataEntityBase::getPkValue).toArray();
            specTaskIdSet = specTaskEntries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        }
        Object[] masterPks = new Object[]{};
        Set<Object> masterTaskIdSet = new HashSet(0);
        if (specTaskEntries != null && !specTaskEntries.isEmpty()) {
            masterPks = masterTaskEntries.stream().map(DataEntityBase::getPkValue).toArray();
            masterTaskIdSet = masterTaskEntries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        }
        if (specPks.length == 0 && masterPks.length == 0) {
            return;
        }
        Map<String, DynamicObject> relationNewTaskMap = this.checkRelationNewTasks(specTaskEntries);
        HashMap<Object, String> newToOldRelateTaskMap = new HashMap<Object, String>(relationNewTaskMap.size());
        for (Map.Entry<String, DynamicObject> entry : relationNewTaskMap.entrySet()) {
            masterTaskIdSet.add(entry.getValue().getPkValue());
            newToOldRelateTaskMap.put(entry.getValue().getPkValue(), entry.getKey());
        }
        HashMap<String, Object> oldRelateToSpecTaskMap = new HashMap<String, Object>(relationNewTaskMap.size());
        for (DynamicObject oldSpecTask : specTaskEntries) {
            DynamicObject relateTask = oldSpecTask.getDynamicObject("relationtask");
            if (relateTask == null) continue;
            oldRelateToSpecTaskMap.put(relateTask.getPkValue().toString(), oldSpecTask.getPkValue());
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])specPks, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        DynamicObject[] tasksFromMasterPlan = BusinessDataServiceHelper.load((Object[])masterPks, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        HashMap<Object, Object> refMap = new HashMap<Object, Object>(16);
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        this.fillTaskEntryFromSpecPlan(taskEntries, dynamicObjectArray, refMap, specTaskIdSet);
        this.fillTaskEntryFromMasterPlan(taskEntries, tasksFromMasterPlan, refMap, masterTaskIdSet);
        for (DynamicObject taskEntry : taskEntries) {
            Object pid = taskEntry.get("pid");
            if (pid == null || (Long)pid == 0L) continue;
            if (refMap.containsKey(pid)) {
                taskEntry.set("pid", refMap.get(pid));
                continue;
            }
            DynamicObject relateTask = taskEntry.getDynamicObject("relationtask");
            if (relateTask == null) continue;
            String oldRelationTaskId = (String)newToOldRelateTaskMap.get(pid);
            Object oldSpecTask = oldRelateToSpecTaskMap.get(oldRelationTaskId);
            taskEntry.set("pid", refMap.get(oldSpecTask));
        }
        this.updateSpecRelateTask(relationNewTaskMap, taskEntries);
        this.updateEntryLevelData(taskEntries);
    }

    private void updateEntryLevelData(DynamicObjectCollection taskEntries) {
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (Object taskEntry : taskEntries) {
            Object parentId = taskEntry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : taskEntries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString("pid"), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject taskEntry : taskEntries) {
            Long pid = taskEntry.getLong("pid");
            int level = 1;
            if (pid != 0L) continue;
            this.addChildTask(newEntries, parentToChildMap, taskEntry, level);
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        if (!newEntries.isEmpty()) {
            this.getModel().updateEntryCache(newEntries);
        }
        this.getView().updateView("taskentity");
    }

    private void addChildTask(DynamicObjectCollection newEntries, Map<Object, List<DynamicObject>> parentToChildMap, DynamicObject parentTask, int level) {
        List<DynamicObject> childList = parentToChildMap.get(parentTask.getPkValue());
        if (!childList.isEmpty()) {
            parentTask.set(LEVEL, (Object)level);
            parentTask.set("isleaf", (Object)EnableEnum.DISABLE.getValue());
            newEntries.add((Object)parentTask);
            ++level;
            for (DynamicObject child : childList) {
                this.addChildTask(newEntries, parentToChildMap, child, level);
            }
        } else {
            parentTask.set("isleaf", (Object)EnableEnum.ENABLE.getValue());
            parentTask.set(LEVEL, (Object)level);
            newEntries.add((Object)parentTask);
        }
    }

    private void updateSpecRelateTask(Map<String, DynamicObject> relationNewTaskMap, DynamicObjectCollection taskEntries) {
        ORM orm = ORM.create();
        for (DynamicObject task : taskEntries) {
            DynamicObject newTask;
            DynamicObject relateTask = task.getDynamicObject("relationtask");
            if (relateTask == null || (newTask = relationNewTaskMap.get(relateTask.getPkValue().toString())) == null) continue;
            newTask = BusinessDataServiceHelper.loadSingle((Object)newTask.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            task.set("relationtask", (Object)newTask);
            task.set("name", newTask.get("name"));
            task.set("number", newTask.get("number"));
            task.set("pretask", newTask.get("pretask"));
            task.set("specialtype", (Object)newTask.getDynamicObject("majortype"));
            task.set("controllevel", (Object)newTask.getDynamicObject("controllevel"));
            task.set("tasktype", (Object)newTask.getDynamicObject("tasktype"));
            task.set("achievementnode", newTask.get("achievementnode"));
            task.set("logical", newTask.get("logical"));
            task.set("relativeduration", newTask.get("realtimedeviation"));
            task.set("absoluteduration", newTask.get("absoluteduration"));
            task.set("planstarttime", newTask.get("planstarttime"));
            task.set("planendtime", newTask.get("planendtime"));
            task.set("aimfinishtime", newTask.get("aimfinishtime"));
            task.set("comptimedeviation", newTask.get("comptimedeviation"));
            task.set("realendtime", newTask.get("realendtime"));
            task.set("percent", newTask.get("percent"));
            task.set("responsibleperson", (Object)newTask.getDynamicObject("responsibleperson"));
            task.set("responsibledept", (Object)newTask.getDynamicObject("responsibledept"));
            task.set("completedescription", (Object)newTask.getString("completedescription"));
            SpecialPlanEditPlugin.setTx(newTask.getDynamicObjectCollection("transactiontype"), task, orm);
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationperson", (DynamicObject)newTask, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)task, (String)"multicooperationdept", (DynamicObject)newTask, (String)"multicooperationdept");
            task.set("comment", newTask.get("comment"));
            task.set(LEVEL, newTask.get(LEVEL));
            task.set("isleaf", newTask.get("isleaf"));
            task.set("taskproject", (Object)newTask.getDynamicObject("project"));
            task.set("taskversion", (Object)BigDecimal.ONE);
            task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            task.set("enable", (Object)EnableEnum.ENABLE.getValue());
            task.set("islatest", (Object)DefaultEnum.NO.getValue());
            task.set("completionstatus", newTask.get("completionstatus"));
            task.set("comment", newTask.get("comment"));
            this.copyTaskFile(newTask, task);
        }
    }

    protected static void setTx(DynamicObjectCollection transactiontype, DynamicObject newTask, ORM orm) {
        DynamicObjectType type = transactiontype.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)type, transactiontype.size());
        DynamicObjectCollection newCollect = new DynamicObjectCollection();
        for (int i = 0; i < transactiontype.size(); ++i) {
            DynamicObject tx = (DynamicObject)transactiontype.get(i);
            DynamicObject newtx = new DynamicObject(type);
            newtx.set("pkid", (Object)longIds[i]);
            newtx.set("fbasedataid", tx.get("fbasedataid"));
            newtx.set("fbasedataid_id", tx.get("fbasedataid_id"));
            newCollect.add((Object)newtx);
        }
        newTask.set("transactiontype", (Object)newCollect);
    }

    protected void fillTaskEntryFromMasterPlan(DynamicObjectCollection taskEntries, DynamicObject[] tasksFromMasterPlan, Map<Object, Object> refMap, Set<Object> masterTaskIdSet) {
        QFilter filter;
        long majorTypeId = this.getModel().getDataEntity().getLong("majortype_id");
        DynamicObject planType = null;
        if (majorTypeId != 0L) {
            filter = new QFilter("id", "=", (Object)majorTypeId);
            planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
        }
        if (planType == null) {
            filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
        }
        DynamicObjectType taskEntryDT = MetaDataUtil.getEntryDT((String)this.getAppId(), (String)"specialplan", (String)"taskentity");
        ORM orm = ORM.create();
        long[] newEntryIds = orm.genLongIds((IDataEntityType)taskEntryDT, tasksFromMasterPlan.length);
        Arrays.sort(tasksFromMasterPlan, (task1, task2) -> {
            if (Integer.parseInt(task1.get("taskseq").toString()) > Integer.parseInt(task2.get("taskseq").toString())) {
                return 1;
            }
            return -1;
        });
        int index = 0;
        for (DynamicObject masterTask : tasksFromMasterPlan) {
            DynamicObject parent;
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = newEntryIds[index++];
            refMap.put(masterTask.getPkValue(), pk);
            newEntry.set("relationtask", (Object)masterTask);
            newEntry.set("id", (Object)pk);
            newEntry.set("name", masterTask.get("name"));
            newEntry.set("number", masterTask.get("number"));
            newEntry.set("pretask", masterTask.get("pretask"));
            newEntry.set("specialtype", (Object)masterTask.getDynamicObject("majortype"));
            newEntry.set("controllevel", (Object)masterTask.getDynamicObject("controllevel"));
            newEntry.set("tasktype", (Object)masterTask.getDynamicObject("tasktype"));
            newEntry.set("achievementnode", masterTask.get("achievementnode"));
            SpecialPlanEditPlugin.setTx(masterTask.getDynamicObjectCollection("transactiontype"), newEntry, orm);
            newEntry.set("sourcetask", null);
            newEntry.set("prechangetask", null);
            newEntry.set("logical", masterTask.get("logical"));
            newEntry.set("relativeduration", masterTask.get("relativeduration"));
            newEntry.set("absoluteduration", masterTask.get("absoluteduration"));
            newEntry.set("planstarttime", masterTask.get("planstarttime"));
            newEntry.set("planendtime", masterTask.get("planendtime"));
            newEntry.set("aimfinishtime", masterTask.get("aimfinishtime"));
            newEntry.set("comptimedeviation", masterTask.get("comptimedeviation"));
            newEntry.set("realendtime", masterTask.get("realendtime"));
            newEntry.set("percent", masterTask.get("percent"));
            newEntry.set("responsibleperson", (Object)masterTask.getDynamicObject("responsibleperson"));
            newEntry.set("responsibledept", (Object)masterTask.getDynamicObject("responsibledept"));
            newEntry.set("completedescription", (Object)masterTask.getString("completedescription"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)masterTask, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)masterTask, (String)"multicooperationdept");
            newEntry.set("comment", masterTask.get("comment"));
            newEntry.set(LEVEL, masterTask.get(LEVEL));
            newEntry.set("isleaf", masterTask.get("isleaf"));
            newEntry.set("taskproject", (Object)masterTask.getDynamicObject("project"));
            newEntry.set("taskversion", (Object)BigDecimal.ONE);
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("enable", (Object)EnableEnum.ENABLE.getValue());
            newEntry.set("islatest", (Object)DefaultEnum.NO.getValue());
            newEntry.set("belongplantype", (Object)planType);
            newEntry.set("tasksource", (Object)planType);
            newEntry.set("completionstatus", masterTask.get("completionstatus"));
            newEntry.set("comment", masterTask.get("comment"));
            for (parent = masterTask.getDynamicObject("parent"); parent != null && !masterTaskIdSet.contains(parent.getPkValue()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            this.dealTaskEntryExtField(newEntry, masterTask, orm);
            taskEntries.add((Object)newEntry);
            this.copyTaskFile(masterTask, newEntry);
        }
    }

    protected void dealTaskEntryExtField(DynamicObject newEntry, DynamicObject masterTask, ORM orm) {
    }

    protected void fillTaskEntryFromSpecPlan(DynamicObjectCollection taskEntries, DynamicObject[] tasksFromSpecPlan, Map<Object, Object> refMap, Set<Object> specTaskIdSet) {
        QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
        DynamicObjectType taskEntryDT = MetaDataUtil.getEntryDT((String)this.getAppId(), (String)"specialplan", (String)"taskentity");
        Arrays.sort(tasksFromSpecPlan, (task1, task2) -> {
            if (Integer.parseInt(task1.get("taskseq").toString()) > Integer.parseInt(task2.get("taskseq").toString())) {
                return 1;
            }
            return -1;
        });
        ORM orm = ORM.create();
        long[] newEntryIds = orm.genLongIds((IDataEntityType)taskEntryDT, tasksFromSpecPlan.length);
        int index = 0;
        for (DynamicObject oldSpecTask : tasksFromSpecPlan) {
            DynamicObject parent;
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = newEntryIds[index++];
            refMap.put(oldSpecTask.getPkValue(), pk);
            newEntry.set("relationtask", (Object)oldSpecTask.getDynamicObject("relationtask"));
            newEntry.set("id", (Object)pk);
            newEntry.set("name", oldSpecTask.get("name"));
            newEntry.set("number", oldSpecTask.get("number"));
            newEntry.set("pretask", oldSpecTask.get("pretask"));
            newEntry.set("specialtype", (Object)oldSpecTask.getDynamicObject("majortype"));
            newEntry.set("controllevel", (Object)oldSpecTask.getDynamicObject("controllevel"));
            newEntry.set("tasktype", (Object)oldSpecTask.getDynamicObject("tasktype"));
            newEntry.set("achievementnode", oldSpecTask.get("achievementnode"));
            newEntry.set("sourcetask", oldSpecTask.get("sourcetask"));
            newEntry.set("prechangetask", (Object)oldSpecTask);
            newEntry.set("logical", oldSpecTask.get("logical"));
            newEntry.set("relativeduration", oldSpecTask.get("realtimedeviation"));
            newEntry.set("absoluteduration", oldSpecTask.get("absoluteduration"));
            newEntry.set("planstarttime", oldSpecTask.get("planstarttime"));
            newEntry.set("planendtime", oldSpecTask.get("planendtime"));
            newEntry.set("aimfinishtime", oldSpecTask.get("aimfinishtime"));
            newEntry.set("comptimedeviation", oldSpecTask.get("comptimedeviation"));
            newEntry.set("realendtime", oldSpecTask.get("realendtime"));
            newEntry.set("percent", oldSpecTask.get("percent"));
            newEntry.set("responsibleperson", (Object)oldSpecTask.getDynamicObject("responsibleperson"));
            newEntry.set("responsibledept", (Object)oldSpecTask.getDynamicObject("responsibledept"));
            newEntry.set("completedescription", (Object)oldSpecTask.getString("completedescription"));
            SpecialPlanEditPlugin.setTx(oldSpecTask.getDynamicObjectCollection("transactiontype"), newEntry, orm);
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)oldSpecTask, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)oldSpecTask, (String)"multicooperationdept");
            newEntry.set("comment", oldSpecTask.get("comment"));
            newEntry.set(LEVEL, oldSpecTask.get(LEVEL));
            newEntry.set("isleaf", oldSpecTask.get("isleaf"));
            newEntry.set("taskproject", (Object)oldSpecTask.getDynamicObject("project"));
            newEntry.set("taskversion", (Object)BigDecimal.ONE);
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("enable", (Object)EnableEnum.ENABLE.getValue());
            newEntry.set("islatest", (Object)DefaultEnum.NO.getValue());
            newEntry.set("belongplantype", (Object)planType);
            newEntry.set("tasksource", (Object)planType);
            newEntry.set("completionstatus", oldSpecTask.get("completionstatus"));
            newEntry.set("comment", oldSpecTask.get("comment"));
            for (parent = oldSpecTask.getDynamicObject("parent"); parent != null && !specTaskIdSet.contains(parent.getPkValue()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            this.dealTaskEntryExtField(newEntry, oldSpecTask, orm);
            taskEntries.add((Object)newEntry);
            this.copyTaskFile(oldSpecTask, newEntry);
        }
    }

    protected Map<String, DynamicObject> checkRelationNewTasks(DynamicObjectCollection entryEntity) {
        DynamicObject[] latestTasks;
        HashMap<String, DynamicObject> relationNewTaskMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, String> sourceTaskIdMap = new HashMap<String, String>(16);
        for (DynamicObject entry : entryEntity) {
            DynamicObject sourceTask;
            DynamicObject relationTask = entry.getDynamicObject("relationtask");
            if (relationTask == null) continue;
            String relationTaskId = relationTask.getPkValue().toString();
            relationTask = BusinessDataServiceHelper.loadSingle((Object)relationTaskId, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            int percent = entry.getInt("percent");
            if (percent == 100 || relationTask.getBoolean("islatest") || (sourceTask = relationTask.getDynamicObject("sourcetask")) == null) continue;
            sourceTaskIdMap.put(sourceTask.getPkValue().toString(), relationTaskId);
        }
        List sourceTaskIdList = sourceTaskIdMap.keySet().stream().map(o -> Long.parseLong(o)).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcetask", "in", sourceTaskIdList);
        filter.and(new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue()));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
        for (DynamicObject latestTask : latestTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter})) {
            String latestSourceId = latestTask.getDynamicObject("sourcetask").getPkValue().toString();
            relationNewTaskMap.put((String)sourceTaskIdMap.get(latestSourceId), latestTask);
        }
        return relationNewTaskMap;
    }

    protected void calculateAbusoluteDuration(int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        if (planStartTime == null || planEndTime == null) {
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"SpecialPlanEditPlugin_82", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planStartTime, (Date)planEndTime, (String)this.getAppId());
        this.getModel().setValue("absoluteduration", (Object)newAbsoluteDuration, rowIndex);
    }

    protected void settingParentPlanTime(String changeField, int rowIndex) {
        block15: {
            DynamicObjectCollection entries;
            block16: {
                block14: {
                    entries = this.getModel().getEntryEntity("taskentity");
                    if (!"planstarttime".equalsIgnoreCase(changeField)) break block14;
                    DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
                    Date planStartTime = row.getDate("planstarttime");
                    long pid = row.getLong("pid");
                    if (pid == 0L || planStartTime == null) {
                        return;
                    }
                    int rowSeq = 0;
                    for (DynamicObject entry : entries) {
                        if (pid == Long.parseLong(entry.getPkValue().toString())) {
                            DynamicObject relationTask = entry.getDynamicObject("relationtask");
                            if (relationTask != null) {
                                if (planStartTime.before(entry.getDate("planstarttime"))) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_73", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                                }
                                if (planStartTime.after(entry.getDate("planendtime"))) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_73", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                                }
                                return;
                            }
                            Date firstPlanStartTime = this.getBeginTimeBySameLevelTask(entries, row);
                            this.getModel().setValue("planstarttime", (Object)firstPlanStartTime, rowSeq);
                            return;
                        }
                        ++rowSeq;
                    }
                    break block15;
                }
                if (!"planendtime".equalsIgnoreCase(changeField)) break block16;
                DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
                Date planEndTime = row.getDate("planendtime");
                long pid = row.getLong("pid");
                if (pid == 0L || planEndTime == null) {
                    return;
                }
                int rowSeq = 0;
                for (DynamicObject entry : entries) {
                    if (pid == Long.parseLong(entry.getPkValue().toString())) {
                        DynamicObject relationTask = entry.getDynamicObject("relationtask");
                        if (relationTask != null) {
                            if (planEndTime.after(entry.getDate("planendtime"))) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_74", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                            }
                            return;
                        }
                        Date lastPlanEndTime = this.getEndTimeBySameLevelTask(entries, row);
                        this.getModel().setValue("planendtime", (Object)lastPlanEndTime, rowSeq);
                        return;
                    }
                    ++rowSeq;
                }
                break block15;
            }
            if (!"aimfinishtime".equalsIgnoreCase(changeField)) break block15;
            DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
            Date planAimTime = row.getDate("aimfinishtime");
            long pid = row.getLong("pid");
            if (pid == 0L || planAimTime == null) {
                return;
            }
            int rowSeq = 0;
            for (DynamicObject entry : entries) {
                if (pid == Long.parseLong(entry.getPkValue().toString())) {
                    Date parentPlanAimTime = this.getAimFinishTimeBySameLevelTask(entries, row);
                    this.getModel().setValue("aimfinishtime", (Object)parentPlanAimTime, rowSeq);
                    return;
                }
                ++rowSeq;
            }
        }
    }

    protected void calculatePlanEndTimeByAbusoluteDuration(int rowIndex) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"SpecialPlanEditPlugin_82", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        if (planStartTime == null) {
            return;
        }
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("absoluteduration", rowIndex);
        if (absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Date newPlanEndTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planStartTime, (int)(absoluteDuration.intValue() - 1), (String)this.getAppId());
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        long pid = row.getLong("pid");
        for (int rowSeq = 0; rowSeq < entries.size(); ++rowSeq) {
            DynamicObject entry = (DynamicObject)entries.get(rowSeq);
            if (pid != Long.parseLong(entry.getPkValue().toString())) continue;
            DynamicObject relationTask = entry.getDynamicObject("relationtask");
            if (relationTask == null || !newPlanEndTime.after(entry.getDate("planendtime"))) break;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8c03\u6574\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\uff0c\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_74", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("planendtime", (Object)newPlanEndTime, rowIndex);
    }

    protected void calculatePlanStartTimeByAbusoluteDuration(int rowIndex) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"SpecialPlanEditPlugin_82", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        if (planEndTime == null) {
            return;
        }
        BigDecimal absoluteDuration = (BigDecimal)this.getModel().getValue("absoluteduration", rowIndex);
        if (absoluteDuration.compareTo(BigDecimal.ZERO) != 0) {
            Date newPlanStartTime = TaskUtil.getDateAfterAddDays((Object)project.getPkValue(), (Date)planEndTime, (int)(absoluteDuration.intValue() * -1), (String)this.getAppId());
            this.getModel().setValue("planstarttime", (Object)newPlanStartTime, rowIndex);
        }
    }

    protected void calculateCompleteTimeDeviation(int curIndex) {
        BigDecimal days;
        Date aimFinishTime = (Date)this.getModel().getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", curIndex);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (aimFinishTime == null || planEndTime == null) {
            this.getModel().setValue("comptimedeviation", null, curIndex);
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)planEndTime, (Date)aimFinishTime, (String)this.getAppId());
            }
            catch (KDBizException e) {
                this.getView().showMessage(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        days = days.subtract(BigDecimal.ONE);
        this.getModel().setValue("comptimedeviation", (Object)days, curIndex);
        this.settingEntryFieldTextColor("taskentity", "comptimedeviation", curIndex);
    }

    protected Date getBeginTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date firstStartTime = currentTask.getDate("planstarttime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date planStartTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (planStartTime = ((DynamicObject)entries.get(i)).getDate("planstarttime")) == null || planStartTime.compareTo(firstStartTime) >= 0) continue;
            firstStartTime = planStartTime;
        }
        return firstStartTime;
    }

    protected Date getEndTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastEndTime = currentTask.getDate("planendtime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date planEndTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (planEndTime = ((DynamicObject)entries.get(i)).getDate("planendtime")) == null || planEndTime.compareTo(lastEndTime) <= 0) continue;
            lastEndTime = planEndTime;
        }
        return lastEndTime;
    }

    protected Date getAimFinishTimeBySameLevelTask(DynamicObjectCollection entries, DynamicObject currentTask) {
        Date lastAimFinishTime = currentTask.getDate("aimfinishtime");
        long pid = currentTask.getLong("pid");
        for (int i = 0; i < entries.size(); ++i) {
            Date aimFinishTime;
            long entryPid = ((DynamicObject)entries.get(i)).getLong("pid");
            if (entryPid != pid || (aimFinishTime = ((DynamicObject)entries.get(i)).getDate("aimfinishtime")) == null || aimFinishTime.compareTo(lastAimFinishTime) <= 0) continue;
            lastAimFinishTime = aimFinishTime;
        }
        return lastAimFinishTime;
    }

    protected void settingEntryFieldTextColor(String entryEntity, String fieldName, int curIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)this.getModel().getValue(fieldName, curIndex);
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntity);
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(curIndex);
        statusStyle.setFieldKey(fieldName);
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            statusStyle.setForeColor("#FF0000");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            statusStyle.setForeColor("#00DD2C");
        } else {
            statusStyle.setForeColor("#666");
        }
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    protected void checkInputTime(String changeField, int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("planstarttime", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime", rowIndex);
        Date aimEndTime = (Date)this.getModel().getValue("aimfinishtime", rowIndex);
        if ("planstarttime".equals(changeField)) {
            if (planStartTime == null) {
                return;
            }
            if (planEndTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_58", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if ("planendtime".equals(changeField)) {
            if (planEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(planEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_59", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        } else if ("aimfinishtime".equals(changeField)) {
            if (aimEndTime == null) {
                return;
            }
            if (planStartTime != null && planStartTime.after(aimEndTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SpecialPlanEditPlugin_60", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void setAchievementEntryEnable(int rowIndex) {
        int count = this.getModel().getEntryRowCount("taskentity");
        if (count == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            return;
        }
        String achievementNode = (String)this.getModel().getValue("achievementnode", rowIndex);
        DynamicObject relationTask = ((DynamicObject)this.getModel().getEntryEntity("taskentity").get(rowIndex)).getDynamicObject("relationtask");
        if (relationTask != null) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)achievementNode)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"taskresultdocentry"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taskreferdocentry"});
        } else {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)achievementNode)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"taskresultdocentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"taskreferdocentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap2"});
        }
    }

    protected void setTransactionEntryEnable(int rowIndex) {
        DynamicObject relationTask;
        int count = this.getModel().getEntryRowCount("taskentity");
        if (count == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            return;
        }
        boolean showResultDoc = false;
        Object trans = this.getModel().getValue("transactiontype", rowIndex);
        if (null != trans) {
            DynamicObjectCollection transactionType = (DynamicObjectCollection)trans;
            for (DynamicObject tx : transactionType) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                showResultDoc = true;
            }
        }
        if ((relationTask = ((DynamicObject)this.getModel().getEntryEntity("taskentity").get(rowIndex)).getDynamicObject("relationtask")) != null) {
            if (showResultDoc) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"taskresultdocentry"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap2"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taskreferdocentry"});
        } else {
            if (showResultDoc) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"advconap1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"taskresultdocentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"taskreferdocentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconap2"});
        }
    }

    protected void deletePreTask(Set<String> deleteTasks) {
        DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject task : tasks) {
            String pretaskPk;
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (null == preTask || !deleteTasks.contains(pretaskPk = preTask.getPkValue().toString())) continue;
            task.set("pretask", null);
            task.set("logical", null);
        }
        this.getModel().updateEntryCache(tasks);
        this.getView().updateView("taskentity");
    }

    protected void rebuildTreeStructure() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        if (entries.isEmpty()) {
            return;
        }
        HashSet<String> pidSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            String pid = entry.getString("pid");
            if (pid == null) continue;
            pidSet.add(pid);
        }
        for (int index = 0; index < entries.size(); ++index) {
            DynamicObject entry;
            entry = (DynamicObject)entries.get(index);
            String id = entry.getPkValue().toString();
            if (pidSet.contains(id)) {
                entry.set("isleaf", (Object)Boolean.FALSE);
                continue;
            }
            entry.set("isleaf", (Object)Boolean.TRUE);
            entry.set("isGroupNode", (Object)Boolean.FALSE);
        }
    }

    private void settingTimeByChildren(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        long id = Long.parseLong(row.getPkValue().toString());
        if (id == 0L) {
            return;
        }
        Date firstStartTime = null;
        for (Object entry : entries) {
            Date planStartTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planStartTime = entry.getDate("planstarttime"))) continue;
            if (null == firstStartTime) {
                firstStartTime = planStartTime;
            }
            firstStartTime = planStartTime.compareTo(firstStartTime) < 0 ? planStartTime : firstStartTime;
        }
        if (null != firstStartTime) {
            this.getModel().setValue("planstarttime", firstStartTime, rowIndex);
        }
        Date lastEndTime = null;
        for (DynamicObject entry : entries) {
            Date planEndTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planEndTime = entry.getDate("planendtime"))) continue;
            if (null == lastEndTime) {
                lastEndTime = planEndTime;
            }
            lastEndTime = planEndTime.compareTo(lastEndTime) > 0 ? planEndTime : lastEndTime;
        }
        if (null != lastEndTime) {
            this.getModel().setValue("planendtime", lastEndTime, rowIndex);
        }
        Date lastAimfinishtime = null;
        for (DynamicObject entry : entries) {
            Date planAimfinishTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planAimfinishTime = entry.getDate("aimfinishtime"))) continue;
            if (null == lastAimfinishtime) {
                lastAimfinishtime = planAimfinishTime;
            }
            lastAimfinishtime = planAimfinishTime.compareTo(lastAimfinishtime) > 0 ? planAimfinishTime : lastAimfinishtime;
        }
        if (null != lastAimfinishtime) {
            this.getModel().setValue("aimfinishtime", lastAimfinishtime, rowIndex);
        }
    }

    protected void settingTreeStructureAfterNew() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int index = selectRows[0];
        DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", index);
        long pid = entry.getLong("pid");
        int rows = this.getModel().getEntryRowCount("taskentity");
        if (pid == 0L) {
            this.getModel().setValue(LEVEL, (Object)1, index);
            this.getModel().setValue("isleaf", (Object)DefaultEnum.YES.getValue(), index);
        } else {
            for (int i = 0; i < rows; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity("taskentity", i);
                if (pid != Long.parseLong(row.getPkValue().toString())) continue;
                DynamicObject relationTask = row.getDynamicObject("relationtask");
                if (relationTask == null) {
                    this.getModel().setValue("pretask", null, i);
                    this.getModel().setValue("logical", null, i);
                    if (this.getModel().getValue("planstarttime", i) == null || this.getModel().getValue("planendtime", i) == null) {
                        this.getModel().setValue("absoluteduration", (Object)0, i);
                    }
                }
                this.getModel().setValue("isleaf", (Object)DefaultEnum.NO.getValue(), i);
                this.getModel().setValue(LEVEL, (Object)(row.getInt(LEVEL) + 1), index);
                this.getModel().setValue("isleaf", (Object)DefaultEnum.YES.getValue(), index);
                break;
            }
        }
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        if (majorType != null) {
            this.getModel().setValue("specialtype", (Object)majorType, index);
        }
    }

    protected void switchMasterPlan(Object pk) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"));
        if (plan == null) {
            return;
        }
        this.getModel().setValue("masterplan", plan.getPkValue());
        this.getModel().deleteEntryData("taskentity");
        this.setMajorTypeFilter();
        this.getModel().setValue("version", (Object)plan.getBigDecimal("version").add(BigDecimal.ONE.divide(BigDecimal.TEN)));
    }

    protected void deleteTaskCheck(int[] selectRowsIndex) {
        for (int selectRowIndex : selectRowsIndex) {
            boolean isFromMaster;
            DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRowIndex);
            boolean bl = isFromMaster = entry.getDynamicObject("relationtask") != null;
            if (isFromMaster) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u4e3b\u9879\u4efb\u52a1\u4e0d\u5141\u8bb8\u5728\u4e13\u9879\u8ba1\u5212\u4e2d\u88ab\u5220\u9664\u3002", (String)"SpecialPlanEditPlugin_61", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            DynamicObject prechangeTask = entry.getDynamicObject("prechangetask");
            if (prechangeTask == null) continue;
            Set<Object> relationIds = this.getSameSourceTaskIds(prechangeTask.getPkValue());
            QFilter[] qFilters = new QFilter[]{new QFilter("relationtask", "in", relationIds)};
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])qFilters);
            if (tasks == null || tasks.length == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u8ba1\u5212\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"SpecialPlanEditPlugin_83", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Object> getSameSourceTaskIds(Object pkValue) {
        HashSet<Object> idSet = new HashSet<Object>();
        idSet.add(pkValue);
        DynamicObject preTask = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject sourceTask = preTask.getDynamicObject("sourcetask");
        if (sourceTask != null) {
            DynamicObject[] relationTasks;
            idSet.add(sourceTask.getPkValue());
            QFilter filter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            filter.and(new QFilter("id", "!=", pkValue));
            for (DynamicObject task : relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{filter})) {
                idSet.add(task.getPkValue());
            }
        }
        return idSet;
    }

    protected void showMasterPlanList() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplanf7"), (boolean)false);
        this.setFilterToShowMasterPlanList(showListForm);
        this.getView().showForm((FormShowParameter)showListForm);
    }

    protected void setFilterToShowMasterPlanList(ListShowParameter showListForm) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            showListForm.getListFilterParameter().setFilter(orgFilter);
        }
        QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        showListForm.getListFilterParameter().setFilter(planStatusFilter);
        QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
        DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
        QFilter majorTypeFilter = new QFilter("majortype", "=", planType.getPkValue());
        showListForm.getListFilterParameter().setFilter(majorTypeFilter);
        this.addMasterPlanListFilter(showListForm);
        showListForm.getListFilterParameter().setOrderBy("createtime desc");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "switchMasterPlanCallBack");
        showListForm.setCloseCallBack(closeCallBack);
    }

    public void addMasterPlanListFilter(ListShowParameter showListForm) {
    }

    protected String createSpecialPlanName() {
        DynamicObject masterPlan = (DynamicObject)this.getModel().getValue("masterplan");
        DynamicObject project = masterPlan.getDynamicObject("project");
        if (project == null) {
            return null;
        }
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        if (majorType == null) {
            return null;
        }
        String majorTypeName = "";
        if (majorType != null) {
            majorTypeName = majorType.getString("plantypename");
        }
        DynamicObject relatedmastertask = this.getModel().getDataEntity().getDynamicObject("relatedmastertask");
        String relatedMasterTaskName = "";
        if (relatedmastertask != null) {
            relatedMasterTaskName = relatedmastertask.getString("name");
        }
        if (majorType == null && relatedmastertask == null) {
            return null;
        }
        String projectName = project.getString("name");
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        IDataEntityProperty billNameProperty = this.getView().getModel().getDataEntityType().findProperty("billname");
        int limitLength = ((TextProp)billNameProperty).getMaxLenth();
        String billName = String.format("%s%s%s%s", projectName, relatedMasterTaskName, majorTypeName, version.setScale(1, RoundingMode.HALF_UP));
        if (billName.length() > limitLength) {
            billName = billName.substring(0, limitLength);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u540d\u79f0\u8d85\u51fa\u4e86\u6700\u5927\u957f\u5ea6\uff0850\u5b57\u7b26\uff09\uff0c\u5df2\u81ea\u52a8\u622a\u53d6\u3002", (String)"SpecialPlanEditPlugin_84", (String)"pccs-placs-formplugin", (Object[])new Object[0]), limitLength));
        }
        return billName;
    }

    protected void setMajorTypeFilter() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)this.getProjectFormId(), (String)this.getProjectKind());
            DynamicObject projectKind = project.getDynamicObject(this.getProjectKind());
            QFilter groupFilter = new QFilter("group", "=", (Object)0L);
            if (projectKind != null) {
                groupFilter.or(new QFilter("group", "=", projectKind.getPkValue()));
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            QFilter notDefaultSpecialPlanFilter = new QFilter("id", "!=", (Object)MAJORPLANID);
            BasedataEdit majorTypeCtrl = (BasedataEdit)this.getControl("majortype");
            majorTypeCtrl.setQFilter(groupFilter.and(enableFilter).and(notDefaultSpecialPlanFilter));
            BasedataEdit entrySpecType = (BasedataEdit)this.getControl("specialtype");
            entrySpecType.setQFilter(groupFilter.and(enableFilter));
        }
    }

    protected String getProjectKind() {
        return "group";
    }

    protected void checkExistMajortype() {
        DynamicObject projectPlanObj = (DynamicObject)this.getModel().getValue("masterplan");
        DynamicObject project = projectPlanObj.getDynamicObject("project");
        DynamicObject projectKind = (project = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)this.getProjectFormId(), (String)this.getProjectKind())).getDynamicObject(this.getProjectKind());
        if (projectKind != null) {
            long kindId = projectKind.getLong("id");
            QFilter groupFilter = new QFilter("group", "=", (Object)kindId).or(new QFilter("group", "=", (Object)0L));
            QFilter typeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObject[] majorType = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"id", (QFilter[])new QFilter[]{groupFilter, enableFilter, typeFilter});
            if (majorType.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u4e0b\u65e0\u4e13\u4e1a\u7c7b\u578b\uff0c\u65e0\u6cd5\u5efa\u7acb\u4e13\u9879\u8ba1\u5212\u3002", (String)"SpecialPlanEditPlugin_62", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    protected void checkCanInsertTaskEntry(int[] selectRows, BeforeDoOperationEventArgs args) {
        if (selectRows.length != 0) {
            int index = selectRows[0];
            DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", index);
            DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
            if (taskEntries == null || taskEntries.isEmpty()) {
                return;
            }
            String entryId = entry.getPkValue().toString();
            DynamicObject relateTask = entry.getDynamicObject("relationtask");
            if (relateTask != null && !relateTask.getBoolean("isleaf")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5728\u4e3b\u9879\u8ba1\u5212\u7f16\u5236\u4e2d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u4efb\u52a1\u3002", (String)"SpecialPlanEditPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int i = index + 1; i < taskEntries.size(); ++i) {
                String parentId = ((DynamicObject)taskEntries.get(i)).get("pid").toString();
                if (parentId == null || !entryId.equals(parentId) || ((DynamicObject)taskEntries.get(i)).getDynamicObject("relationtask") == null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5728\u4e3b\u9879\u8ba1\u5212\u7f16\u5236\u4e2d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u4efb\u52a1\u3002", (String)"SpecialPlanEditPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    protected void copyTaskFile(DynamicObject relationTask, DynamicObject currentTask) {
        DynamicObjectCollection taskReferDocEntries;
        DynamicObjectType resultDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.getAppId(), (String)"specialplan", (String)"taskentity", (String)"taskresultdocentry");
        DynamicObjectType referDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.getAppId(), (String)"specialplan", (String)"taskentity", (String)"taskreferdocentry");
        ORM orm = ORM.create();
        DynamicObjectCollection taskResultDocEntries = relationTask.getDynamicObjectCollection("taskresultdocentry");
        if (!taskResultDocEntries.isEmpty()) {
            DynamicObjectCollection resultDocEntries = new DynamicObjectCollection();
            long[] resultDocEntryPks = orm.genLongIds((IDataEntityType)resultDocEntryDT, taskResultDocEntries.size());
            int resultDocEntryindex = 0;
            for (DynamicObject resultDocEntry : taskResultDocEntries) {
                Long resultDocEntryPk = resultDocEntryPks[resultDocEntryindex++];
                DynamicObject newResultDoc = new DynamicObject(resultDocEntryDT);
                newResultDoc.set("id", (Object)resultDocEntryPk);
                newResultDoc.setParent((Object)currentTask);
                newResultDoc.set("resultname", resultDocEntry.get("resultname"));
                newResultDoc.set("force", resultDocEntry.get("force"));
                newResultDoc.set("frequency", resultDocEntry.get("frequency"));
                newResultDoc.set("resultdescription", resultDocEntry.get("resultdescription"));
                resultDocEntries.add((Object)newResultDoc);
            }
            currentTask.set("taskresultdocentry", (Object)resultDocEntries);
        }
        if (!(taskReferDocEntries = relationTask.getDynamicObjectCollection("taskreferdocentry")).isEmpty()) {
            DynamicObjectCollection referDocEntries = new DynamicObjectCollection();
            long[] referDocEntryPks = orm.genLongIds((IDataEntityType)referDocEntryDT, taskReferDocEntries.size());
            int taskReferDocIndex = 0;
            for (DynamicObject referDocEntry : taskReferDocEntries) {
                Long referDocEntryPk = referDocEntryPks[taskReferDocIndex++];
                DynamicObject newReferDoc = new DynamicObject(referDocEntryDT);
                newReferDoc.setParent((Object)currentTask);
                newReferDoc.set("id", (Object)referDocEntryPk);
                newReferDoc.set("referdocname", referDocEntry.get("referdocname"));
                DynamicObjectCollection doces = referDocEntry.getDynamicObjectCollection("attachment");
                if (doces != null && !doces.isEmpty()) {
                    DynamicObjectCollection newDoces = new DynamicObjectCollection();
                    DynamicObjectType docDT = doces.getDynamicObjectType();
                    for (DynamicObject doc : doces) {
                        DynamicObject newDoc = new DynamicObject(docDT);
                        referDocEntry.getDataEntityType().getPrimaryKey().setValueFast((Object)newDoc, (Object)orm.genLongId((IDataEntityType)docDT));
                        newDoc.set("fbasedataid", (Object)doc.getDynamicObject("fbasedataid"));
                        newDoces.add((Object)newDoc);
                    }
                    newReferDoc.set("attachment", (Object)newDoces);
                }
                newReferDoc.set("description", referDocEntry.get("description"));
                referDocEntries.add((Object)newReferDoc);
            }
            currentTask.set("taskreferdocentry", (Object)referDocEntries);
        }
    }

    protected Boolean editionPlanLatest() {
        DynamicObject masterplanF7 = (DynamicObject)this.getModel().getValue("masterplan");
        if (masterplanF7 == null) {
            return false;
        }
        DynamicObject sourcePlan = masterplanF7.getDynamicObject("sourceplan");
        if (sourcePlan == null) {
            sourcePlan = masterplanF7;
        }
        QFilter qFilter = new QFilter("sourceplan", "=", sourcePlan.getPkValue());
        DynamicObject[] allPlanBasedOn = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"planstatus", (QFilter[])new QFilter[]{qFilter});
        DynamicObject newestMasterPlan = null;
        if (allPlanBasedOn.length > 0) {
            for (DynamicObject editionPlan : allPlanBasedOn) {
                if (!PlanEnum.PUBLISHED.getValue().equals(editionPlan.getString("planstatus"))) continue;
                newestMasterPlan = editionPlan;
                break;
            }
        } else {
            return false;
        }
        return true;
    }

    protected Map<String, DynamicObject> checkRelationNewTasks() {
        DynamicObject[] latestTasks;
        HashMap<String, DynamicObject> relationNewTaskMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, String> sourceTaskIdMap = new HashMap<String, String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject entry : entryEntity) {
            DynamicObject sourceTask;
            if (entry.getDynamicObject("relationtask") == null) continue;
            String relationTaskId = entry.getDynamicObject("relationtask").getPkValue().toString();
            DynamicObject relationTask = BusinessDataServiceHelper.loadSingle((Object)relationTaskId, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            int percent = entry.getInt("percent");
            if (percent == 100 || relationTask == null || relationTask.getBoolean("islatest") || (sourceTask = relationTask.getDynamicObject("sourcetask")) == null) continue;
            sourceTaskIdMap.put(sourceTask.getPkValue().toString(), relationTask.getPkValue().toString());
        }
        QFilter filter = new QFilter("sourcetask", "in", sourceTaskIdMap.keySet().stream().filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList()));
        filter.and(new QFilter("islatest", "=", (Object)EnableEnum.ENABLE.getValue()));
        for (DynamicObject latest : latestTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"sourcetask,taskseq,planstarttime,planendtime", (QFilter[])new QFilter[]{filter})) {
            String latestSourceId = latest.getDynamicObject("sourcetask").getPkValue().toString();
            relationNewTaskMap.put((String)sourceTaskIdMap.get(latestSourceId), latest);
        }
        return relationNewTaskMap;
    }

    protected void checkExistChildren(Set<Object> taskSet) {
        HashSet<Object> introduceTask = new HashSet<Object>();
        DynamicObjectCollection allTask = this.getModel().getEntryEntity("taskentity");
        for (DynamicObject task : allTask) {
            if (null == task.get("relationtask")) continue;
            introduceTask.add(task.getPkValue());
        }
        for (DynamicObject task : allTask) {
            if ("0".equals(task.get("pid").toString()) || null == task.get("pid") || !introduceTask.contains(task.get("pid"))) continue;
            taskSet.add(task.get("pid"));
        }
    }

    protected void verifyTaskIsPre(BeforeDoOperationEventArgs args) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length == 0) {
            args.setCancel(true);
            return;
        }
        DynamicObject currentEntry = this.getModel().getEntryRowEntity("taskentity", selRows[0]);
        if (currentEntry.getDynamicObject("relationtask") != null) {
            return;
        }
        DynamicObjectCollection taskEntrys = this.getModel().getEntryEntity("taskentity");
        Set preTaskId = taskEntrys.stream().filter(task -> task.get("pretask") != null).map(task -> task.getDynamicObject("pretask").getPkValue().toString()).collect(Collectors.toSet());
        if (preTaskId.isEmpty()) {
            return;
        }
        if (preTaskId.contains(currentEntry.getPkValue().toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u4f5c\u4e3a\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\uff0c\u82e5\u65b0\u589e\u5b50\u7ea7\uff0c\u4f1a\u6e05\u9664\u5176\u4ed6\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SpecialPlanEditPlugin_85", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(NEW_TASK_CONFIRM));
        }
    }
}

