/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.tree.DynamicObjectTreeNode;
import kd.pccs.placs.common.utils.tree.Hierarchy;
import kd.pccs.placs.common.utils.tree.Hierarchyable;
import kd.pccs.placs.common.utils.tree.OrgProjectTreeHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class TaskImportListPlugin
extends AbstractPlacsFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(TaskImportListPlugin.class);
    public static final String TREE_ENTRYENTITY = "treeentryentity";
    private static final String OKBTN = "okbtn";
    private static final String KEY_SEARCHAP = "searchap";
    public static final String BOS_ORG = "bos_org";

    protected String getProjectFormId() {
        return "bd_project";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
        Search searchap = (Search)this.getView().getControl(KEY_SEARCHAP);
        searchap.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{OKBTN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isInitSucess = this.initNavTree();
        if (!isInitSucess) {
            return;
        }
        this.initTreeData(null, false);
    }

    protected boolean initNavTree() {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (customMap.get("deptid") != null) {
            Long deptId = Long.valueOf(customMap.get("deptid").toString());
            DynamicObject[] projs = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)deptId)});
            ArrayList<String> proIds = new ArrayList<String>(projs.length);
            for (DynamicObject proj : projs) {
                proIds.add(proj.getPkValue().toString());
            }
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Hierarchy tree = this.initProjectNavTree(treeView, deptId, false, proIds);
            if (tree != null) {
                DynamicObjectTreeNode node = (DynamicObjectTreeNode)tree.getRootNode();
                TreeNode root = node.getTreeNode();
                treeView.addNode(root);
                treeView.focusNode(root);
                treeView.treeNodeClick(null, root.getId());
            }
            this.getPageCache().put("orgproject_tree_key", SerializeHelper.serialize((Object)tree));
            return true;
        }
        return false;
    }

    public Hierarchy initProjectNavTree(TreeView treeView, Long orgId, boolean isShowUnitProject, List<String> chargeProjIds) {
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)BOS_ORG);
        TreeNode root = new TreeNode("", orgObject.getString("id"), orgObject.getString("name"), true);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        DynamicObject[] orgs = this.getOrgObjs(orgIds);
        HashMap orgrelationsMap = new HashMap(16);
        OrgProjectTreeHelper.setOrgRelationMap((DynamicObject)orgObject, orgIds, orgrelationsMap);
        Hierarchy tree = new Hierarchy();
        DynamicObjectTreeNode rootnode = new DynamicObjectTreeNode();
        OrgProjectTreeHelper.setTreeNodeByRelationMap((DynamicObject)orgObject, (DynamicObject[])orgs, orgrelationsMap, (Hierarchy)tree, (DynamicObjectTreeNode)rootnode);
        QFilter filterOrgId_1 = new QFilter("org", "in", orgIds);
        QFilter[] filters_1 = new QFilter[]{filterOrgId_1};
        ArrayList<String> projectIds = new ArrayList<String>(10);
        Map<Object, DynamicObject> projectMap = this.getProjectMap(filters_1);
        this.initTreeNodeByProjects(tree, projectIds, projectMap);
        OrgProjectTreeHelper.removeNodeWithNoProject((Hierarchy)tree, (DynamicObjectTreeNode)rootnode, projectMap);
        root.setIsOpened(true);
        treeView.addNode(root);
        treeView.focusNode(root);
        List treeNodes = tree.getAllChildren(tree.getRootNode());
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            OrgProjectTreeHelper.addNodeToTreeView((TreeView)treeView, (DynamicObjectTreeNode)treeNode, (boolean)false);
        }
        return tree;
    }

    public void initTreeNodeByProjects(Hierarchy tree, List<String> projectIds, Map<Object, DynamicObject> projectMap) {
        projectMap.values().stream().sorted(Comparator.comparing(project -> project.getInt("level"))).forEach(project -> {
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId(((Long)project.getPkValue()).longValue());
            projectIds.add(project.getPkValue().toString());
            node.setName(project.getString("name"));
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("color", "blue");
            node.setData(data);
            node.setValue(project);
            node.setType("project");
            DynamicObject parentpro = project.getDynamicObject("parent");
            long parentId = parentpro == null ? project.getLong("org.id") : parentpro.getLong("id");
            node.setParentId(parentId);
            tree.addObject((Hierarchyable)node);
        });
    }

    protected DynamicObject[] getOrgObjs(List<Long> orgIds) {
        return BusinessDataServiceHelper.load((Object[])orgIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_ORG));
    }

    protected Map<Object, DynamicObject> getProjectMap(QFilter[] filters_1) {
        return BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getProjectFormId()), (QFilter[])filters_1);
    }

    public void click(EventObject evt) {
        String btnKey;
        Button source = (Button)evt.getSource();
        switch (btnKey = source.getKey()) {
            case "okbtn": {
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
                int[] rows = entryGrid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u4efb\u52a1\u3002", (String)"TaskImportListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> list = new ArrayList<Long>(10);
                for (int row : rows) {
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(TREE_ENTRYENTITY, row);
                    long pkId = rowObj.getLong("id");
                    list.add(pkId);
                }
                this.getView().returnDataToParent(list);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    protected void initTreeData(QFilter conditionFilter, boolean isProjectNode) {
        Set<String> taskIdSet;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
        IDataModel model = entryGrid.getModel();
        model.deleteEntryData(TREE_ENTRYENTITY);
        QFilter basicFilter = this.getBasicFilter();
        if (conditionFilter != null) {
            basicFilter.and(conditionFilter);
        }
        DynamicObject[] showTasks = null;
        showTasks = isProjectNode ? BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{basicFilter}, (String)"belongplantype, taskseq asc") : BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{basicFilter}, (String)"project asc");
        DynamicObjectCollection taskEntries = this.fillShowTask(showTasks, taskIdSet = Arrays.stream(showTasks).map(o -> o.getPkValue().toString()).collect(Collectors.toSet()));
        if (taskEntries == null || taskEntries.isEmpty()) {
            return;
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl(TREE_ENTRYENTITY);
        entryTree.setCollapse(false);
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView(TREE_ENTRYENTITY);
    }

    protected DynamicObjectCollection fillShowTask(DynamicObject[] showTasks, Set<String> taskIdSet) {
        if (showTasks == null || showTasks.length == 0) {
            return null;
        }
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        for (DynamicObject task : showTasks) {
            DynamicObject parent;
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            newEntry.set("id", task.get("id"));
            newEntry.set("name", task.get("name"));
            newEntry.set("project", task.get("project"));
            newEntry.set("belongplantype", task.get("belongplantype"));
            newEntry.set("tasktype", task.get("tasktype"));
            newEntry.set("seq", task.get("taskseq"));
            newEntry.set("controllevel", task.get("controllevel"));
            newEntry.set("planstarttime", task.get("planstarttime"));
            newEntry.set("planendtime", task.get("planendtime"));
            newEntry.set("absoluteduration", task.get("absoluteduration"));
            newEntry.set("responsibleperson", task.get("responsibleperson"));
            newEntry.set("responsibledept", task.get("responsibledept"));
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationperson", (DynamicObject)task, (String)"multicooperationperson");
            MultiCooperationPersonUtils.importMultiCooPersonOrDepts((DynamicObject)newEntry, (String)"multicooperationdept", (DynamicObject)task, (String)"multicooperationdept");
            for (parent = task.getDynamicObject("parent"); parent != null && !taskIdSet.contains(parent.getPkValue().toString()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            taskEntries.add((Object)newEntry);
        }
        return taskEntries;
    }

    protected QFilter getBasicFilter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String filterStr = (String)parameter.getCustomParam("filter");
        QFilter basecFilter = (QFilter)SerializeHelper.unserialize((String)filterStr);
        return basecFilter;
    }

    protected boolean isProjectNode(Object nodeId) {
        DynamicObject project = null;
        try {
            project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)this.getProjectFormId());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return project != null;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchKey = search.getKey();
        if ("treesearchap".equals(searchKey)) {
            OrgProjectTreeHelper.search((IFormView)this.getView(), (IPageCache)pageCache, (String)searchText);
        } else if (KEY_SEARCHAP.equals(searchKey)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (nodeId != null && this.isProjectNode(nodeId)) {
                QFilter proNodeFilter = this.getProjectNodeFilter(nodeId);
                QFilter searchFilter = this.getSearchFilter(searchText);
                QFilter conditionFilter = proNodeFilter.and(searchFilter);
                this.showData(conditionFilter, true);
            } else {
                QFilter searchFilter = this.getSearchFilter(searchText);
                this.showData(searchFilter, false);
            }
        }
    }

    protected QFilter getSearchFilter(String searchText) {
        StringBuilder sb = new StringBuilder();
        sb.append('%').append(searchText).append('%');
        QFilter taskNameFilter = new QFilter("name", "like", (Object)sb.toString());
        QFilter controllevelFilter = new QFilter("controllevel.name", "like", (Object)sb.toString());
        return taskNameFilter.or(controllevelFilter);
    }

    protected QFilter getProjectNodeFilter(Object nodeId) {
        ArrayList<Object> proIds = new ArrayList<Object>();
        proIds.add(nodeId);
        QFilter qFilter = new QFilter("project", "in", proIds.stream().map(String::valueOf).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(Long::valueOf).collect(Collectors.toList()));
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        DynamicObject[] projectPlans = BusinessDataServiceHelper.load((String)(this.getAppId() + "_" + "masterplan"), (String)"taskentity,taskid", (QFilter[])new QFilter[]{qFilter, statusFilter});
        ArrayList<Object> taskIds = new ArrayList<Object>(10);
        for (DynamicObject projectPlan : projectPlans) {
            DynamicObjectCollection taskEntrys = projectPlan.getDynamicObjectCollection("taskentity");
            for (DynamicObject taskEntry : taskEntrys) {
                taskIds.add(taskEntry.getPkValue());
            }
        }
        return new QFilter("id", "in", taskIds);
    }

    protected void showData(QFilter conditionFilter, boolean isProjectNode) {
        this.initTreeData(conditionFilter, isProjectNode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("treeview".equals(key)) {
            Object nodeId = evt.getNodeId();
            if (nodeId != null && this.isProjectNode(nodeId)) {
                QFilter proNodeFilter = this.getProjectNodeFilter(nodeId);
                this.showData(proNodeFilter, true);
            } else {
                this.showData(null, false);
            }
        }
    }
}

