/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class TaskListFormPlugin
extends AbstractPlacsBillPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(TaskListFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paramMap = showParameter.getCustomParams();
        String billsource = (String)paramMap.get("billsource");
        if (StringUtils.equals((CharSequence)billsource, (CharSequence)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplanreachrate"))) {
            this.getTaskFromDept(paramMap);
        } else if (StringUtils.equals((CharSequence)billsource, (CharSequence)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"proplanreachrate"))) {
            this.getTaskFromProject(paramMap);
        } else if (StringUtils.equals((CharSequence)billsource, (CharSequence)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"prooperationreport"))) {
            this.getTaskFromTaskIds(paramMap);
        }
        this.getView().updateView("entryentity");
        this.updateEntryColor();
    }

    protected void getTaskFromTaskIds(Map<String, Object> paramMap) {
        DynamicObject[] taskArr;
        String taskIds = (String)paramMap.get("taskIds");
        if (taskIds == null) {
            return;
        }
        String[] taskIdList = taskIds.split(",|\uff0c");
        if (taskIdList.length <= 0) {
            return;
        }
        List taskList = Arrays.stream(taskIdList).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
        for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,name,percent", (QFilter[])new QFilter[]{new QFilter("id", "in", taskList)})) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("task", dynamicObject.getPkValue(), rowIndex);
            this.getModel().setValue("percent", (Object)dynamicObject.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
        }
    }

    protected void getTaskFromProject(Map<String, Object> paramMap) {
        DynamicObject[] taskArr;
        String projectId = (String)paramMap.get("projectId");
        String completionStatus = (String)paramMap.get("completionStatus");
        if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percent"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"realendtime", "realtimedeviation"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"percent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"realendtime", "realtimedeviation"});
        }
        QFilter commonFilter = this.getCommonFilter();
        QFilter completionStatusFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)completionStatus)) {
            completionStatusFilter = new QFilter("completionstatus", "=", (Object)completionStatus);
        }
        Object controlLevels = paramMap.get("controllevels");
        QFilter planEndTimeFilter = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object beginDate = paramMap.get("daterange_startdate");
        Object endDate = paramMap.get("daterange_enddate");
        if (beginDate != null && endDate != null) {
            try {
                beginDate = sdf.parse((String)beginDate);
                endDate = sdf.parse((String)endDate);
            }
            catch (ParseException e1) {
                logger.error((Throwable)e1);
            }
            QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", beginDate);
            QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", endDate);
            planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
        }
        QFilter controlLevelsFilter = null;
        if (controlLevels != null) {
            controlLevelsFilter = new QFilter("controllevel", "in", controlLevels);
        }
        QFilter taskSourceFilter = null;
        Object taskSourceIds = paramMap.get("tasksource");
        if (taskSourceIds != null) {
            taskSourceFilter = new QFilter("tasksource", "in", taskSourceIds);
        }
        QFilter taskTypeFilter = null;
        Object taskTypes = paramMap.get("tasktypes");
        if (taskTypes != null) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypes);
        }
        QFilter projectFilter = new QFilter("project", "=", (Object)Long.valueOf(projectId));
        for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,name,percent", (QFilter[])new QFilter[]{completionStatusFilter, projectFilter, controlLevelsFilter, taskTypeFilter, taskSourceFilter, planEndTimeFilter, commonFilter})) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("task", dynamicObject.getPkValue(), rowIndex);
            this.getModel().setValue("percent", (Object)dynamicObject.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
        }
    }

    protected void getTaskFromDept(Map<String, Object> paramMap) {
        DynamicObject[] taskArr;
        String completionStatus = (String)paramMap.get("completionStatus");
        if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percent"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"realendtime", "realtimedeviation"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"percent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"realendtime", "realtimedeviation"});
        }
        QFilter completionStatusFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)completionStatus)) {
            completionStatusFilter = new QFilter("completionstatus", "=", (Object)completionStatus);
        }
        QFilter planEndTimeFilter = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object beginDate = paramMap.get("daterange_startdate");
        Object endDate = paramMap.get("daterange_enddate");
        if (beginDate != null && endDate != null) {
            try {
                beginDate = sdf.parse((String)beginDate);
                endDate = sdf.parse((String)endDate);
            }
            catch (ParseException e1) {
                logger.error((Throwable)e1);
            }
            QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", beginDate);
            QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", endDate);
            planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
        }
        QFilter controlLevelsFilter = null;
        Object controlLevels = paramMap.get("controllevels");
        if (controlLevels != null) {
            controlLevelsFilter = new QFilter("controllevel", "in", controlLevels);
        }
        QFilter taskTypeFilter = null;
        Object taskTypes = paramMap.get("tasktypes");
        if (taskTypes != null) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypes);
        }
        QFilter taskSourceFilter = null;
        Object taskSourceIds = paramMap.get("tasksource");
        if (taskSourceIds != null) {
            taskSourceFilter = new QFilter("tasksource", "in", taskSourceIds);
        }
        String orgId = (String)paramMap.get("orgId");
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(Long.valueOf(orgId));
        String dutys = (String)paramMap.get("dutys");
        QFilter orgFilter = null;
        if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1") && StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            QFilter responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
            QFilter cooperationdeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", orgIdList);
            orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1")) {
            orgFilter = new QFilter("responsibledept", "in", orgIdList);
        } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
            orgFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", orgIdList);
        }
        String deptplanId = (String)paramMap.get("deptplanId");
        QFilter planidFilter = new QFilter("planid", "=", (Object)Long.valueOf(deptplanId));
        for (DynamicObject task : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,name,percent", (QFilter[])new QFilter[]{completionStatusFilter, orgFilter, controlLevelsFilter, taskSourceFilter, taskTypeFilter, planEndTimeFilter, planidFilter})) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("task", task.getPkValue(), rowIndex);
            this.getModel().setValue("percent", (Object)task.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String fieldName = paramHyperLinkClickEvent.getFieldName();
        int rowIndex = paramHyperLinkClickEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)"task", (CharSequence)fieldName)) {
            this.taskClick(rowIndex);
        }
    }

    protected void taskClick(int rowIndex) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
        if (task != null) {
            paramMap.put("formId", this.getAppId() + "_reporttaskview");
            paramMap.put("pkId", String.valueOf(task.getPkValue()));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected QFilter getCommonFilter() {
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter relationFilter = new QFilter("relationtask", "=", (Object)0);
        return isLatestFilter.and(statusFilter).and(relationFilter);
    }

    protected void updateEntryColor() {
        int cruxnodRow = this.getModel().getEntryRowCount("entryentity");
        ArrayList<CellStyle> styles1 = new ArrayList<CellStyle>(10);
        for (int i = 0; i < cruxnodRow; ++i) {
            DynamicObject cruxtask = (DynamicObject)this.getModel().getValue("task", i);
            cruxtask = BusinessDataServiceHelper.loadSingle((Object)cruxtask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"riskcolor");
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("task");
            String riskColor = cruxtask.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style.setBackColor("#FD6C6A");
            }
            styles1.add(style);
        }
        EntryGrid cruxnodeentry = (EntryGrid)this.getView().getControl("entryentity");
        cruxnodeentry.setCellStyle(styles1);
        this.getView().updateView("entryentity");
    }
}

